#!/bin/bash
###################### INIZIO CREAZIONE CARTELLA DI DOMINIO #################################
echo "Inserisci il nome del dominio (senza spazi) "
read dominio

if [ -z $dominio ]
then
	echo "Non hai inserito nessun valore"
	exit
fi

domain_name="/var/www/html/$dominio"
silverdoc=0
screening=1
core_folder="/var/www/virtuhis"
storage_folder="/storage"
ris_domain_folder="/var/www/html/ris_domain"
ris_service_folder="/var/www/html/ris_service"
ipa_folder="/var/www/html/virtuhis_ipa"

mkdir ${domain_name}
cd ${domain_name}

# Cartelle 100% core
ln -s ${core_folder}/calend
ln -s ${core_folder}/classes
ln -s ${core_folder}/dose_manager
ln -s ${core_folder}/frequent
ln -s ${core_folder}/Indicizzazione
ln -s ${core_folder}/java
ln -s ${core_folder}/jquery_ui
ln -s ${core_folder}/license
ln -s ${core_folder}/login
ln -s ${core_folder}/pacs_rv
ln -s ${core_folder}/patient
ln -s ${core_folder}/service
ln -s ${core_folder}/sc_connector
ln -s ${storage_folder}/signed_report
ln -s ${core_folder}/statistics
ln -s ${core_folder}/support
ln -s ${core_folder}/theme
ln -s ${core_folder}/worklist

# Silverdoc
if [ ${silverdoc} -eq 1 ] 
then
	ln -s ${storage_folder}/doc_scan
	mkdir SilverDoc
fi


# CARTELLE CUSTOM

# config
mkdir config
cd config
cp ${core_folder}/config/conf.php.default ./conf.php.default
cp conf.php.default conf.php

if [ ${screening} -eq 1 ] 
then
	cp ${core_folder}/config/conf_screening.default.php ./conf_screening.php
fi

cp ${core_folder}/config/cron_conf_default.json ./cron_conf.json
cp ${core_folder}/config/customization_functions.php.default ./
cp customization_functions.php.default customization_functions.php
cp ${core_folder}/config/db_conf_mysql.php.default ./db_conf_mysql.php
cp ${core_folder}/config/external_code.php.default ./external_code.php
cp ${core_folder}/config/external_report_function.default.php ./external_report_function.php
cp ${core_folder}/config/gestione_notifiche.php ./
cp ${core_folder}/config/gestore_statistiche.php ./
cp ${core_folder}/config/licence.php.default ./licence.php
cp ${core_folder}/config/patient_fields_providers_blocco.php ./
cp ${core_folder}/config/patient_fields_providers.default.php ./patient_fields_providers.php
cp ${core_folder}/config/privacy_manager.default.php ./privacy_manager.php
cp ${core_folder}/config/stop_words_ITA.txt ./
cp ${core_folder}/config/version_custom_default.php ./version_custom.php
cp ${core_folder}/config/version_default.php ./version.php

if [ ${silverdoc} -eq 1 ] 
then
	cp ${core_folder}/config/silverdoc_conf.php ./
fi
cd ..

# cron_services
mkdir cron_services
cd cron_services
ln -s ${core_folder}/cron_services/crontab.php ./
cd ..

# functions
mkdir functions
cd functions
ln -s ${core_folder}/functions/ajax_Returns.php
ln -s ${core_folder}/functions/ATNA_Lib.php
ln -s ${core_folder}/functions/basic_functions.php
ln -s ${core_folder}/functions/browser.class.php
ln -s ${core_folder}/functions/call_function.php
ln -s ${core_folder}/functions/composer.json
ln -s ${core_folder}/functions/composer.lock
ln -s ${core_folder}/functions/cron_conf.json
ln -s ${core_folder}/functions/date_functions
ln -s ${core_folder}/functions/Encryption.php
ln -s ${core_folder}/functions/fea_upload.php
ln -s ${core_folder}/functions/FPDI-1.4.4
ln -s ${core_folder}/functions/functions_mysqli.php
ln -s ${core_folder}/functions/functions_mysql.php 
ln -s ${core_folder}/functions/hl7
ln -s ${core_folder}/functions/Html2TextException.php
ln -s ${core_folder}/functions/html2text.php
ln -s ${core_folder}/functions/html2txt.php
ln -s ${core_folder}/functions/IHEBasicSecurity.php
ln -s ${core_folder}/functions/jscalendar
ln -s ${core_folder}/functions/json_pretty.php
ln -s ${core_folder}/functions/JSON_Returns.php
ln -s ${core_folder}/functions/LDAP_auth_AD.php
ln -s ${core_folder}/functions/mail
ln -s ${core_folder}/functions/mail_function.php
ln -s ${core_folder}/functions/print.min.css
ln -s ${core_folder}/functions/print.min.js
ln -s ${core_folder}/functions/rad3.php
ln -s ${core_folder}/functions/rad4.php
ln -s ${core_folder}/functions/R-Os
ln -s ${core_folder}/functions/scan_upload.php
ln -s ${core_folder}/functions/StampeAjax.php
ln -s ${core_folder}/functions/syslog.php
ln -s ${core_folder}/functions/tcpdf
ln -s ${core_folder}/functions/tcpdf-6.2.13
ln -s ${core_folder}/functions/tcpdf.o
ln -s ${core_folder}/functions/validator.js
ln -s ${core_folder}/functions/vendor
ln -s ${core_folder}/functions/WSClientAruba.php
ln -s ${core_folder}/functions/WSMessageAruba.php
cp -r ${core_folder}/functions/siss-way-default ./
cd ..

# IndicizzaReferti
cp -r ${core_folder}/IndicizzaReferti ./

# lang
mkdir lang
cd lang
cp ${core_folder}/lang/definition_IT.default.php ./definition_IT.php
cp ${core_folder}/lang/definition_EN.default.php ./definition_EN.php
cp ${core_folder}/lang/definition_DE.default.php ./definition_DE.php
cp ${core_folder}/lang/definition_js_IT.default.json ./definition_js_IT.json
cp ${core_folder}/lang/definition_js_EN.default.json ./definition_js_EN.json
cp ${core_folder}/lang/definition_js_DE.default.json ./definition_js_DE.json
cd ..

# cartella vecchi log
mkdir logs

# print templates
mkdir print_templates
cd print_templates
cp ${core_folder}/print_templates/report_mpdf.php ./report_mpdf.php
cp ${core_folder}/print_templates/referto.php ./referto.php
cd ..

# report
mkdir report
cd report
ln -s ${core_folder}/report/createXML_CloseSession.php
ln -s ${core_folder}/report/createXML_OpenSession.php
ln -s ${core_folder}/report/createXMLpdfsignatureV2.php
ln -s ${core_folder}/report/createXMLpkcs7signV2.php
ln -s ${core_folder}/report/firma_massiva_da_firmare.js
ln -s ${core_folder}/report/firma_massiva_da_firmare.php
ln -s ${core_folder}/report/firma_massiva.php
ln -s ${core_folder}/report/group_fillers_EDIT_report.php
ln -s ${core_folder}/report/group_fillers.js
ln -s ${core_folder}/report/group_fillers_NEW_report.php
ln -s ${core_folder}/report/Precedenti_Ajax_newGui.php
ln -s ${core_folder}/report/Precedenti_Ajax.php
ln -s ${core_folder}/report/refertatore_1.js
ln -s ${core_folder}/report/refertatore_2.js
ln -s ${core_folder}/report/refertatore_3.js
ln -s ${core_folder}/report/refertatore_4.js
ln -s ${core_folder}/report/refertatore_5.js
ln -s ${core_folder}/report/refertatore_6.js
ln -s ${core_folder}/report/refertatore_99.js
ln -s ${core_folder}/report/report_annulla_insert.php
ln -s ${core_folder}/report/report_annulla.php
ln -s ${core_folder}/report/report_firmael_pdf.js
ln -s ${core_folder}/report/report_firmael_pdf.php
ln -s ${core_folder}/report/report_firmaremota.php
ln -s ${core_folder}/report/report_ins_DX.php
ln -s ${core_folder}/report/report_ins.js
ln -s ${core_folder}/report/report_ins.php
ln -s ${core_folder}/report/report_ins_SX.php
ln -s ${core_folder}/report/report.php
ln -s ${core_folder}/report/report_print_annulla.php
ln -s ${core_folder}/report/report_print_massiva.php
ln -s ${core_folder}/report/report_print.php
ln -s ${core_folder}/report/report_show_annulla.php
ln -s ${core_folder}/report/report_show.js
ln -s ${core_folder}/report/report_show.php
cp ${core_folder}/report/InviaXMLfirma_remota.php ./
cp ${core_folder}/report/InviaXMLfirma_remota2.php ./
cd ..

# tmp
mkdir tmp

# xdstools
mkdir xdstools
cd xdstools
ln -s ${core_folder}/xdstools/classes
ln -s ${core_folder}/xdstools/doc_publisher_php7.php
ln -s ${core_folder}/xdstools/documento.php
ln -s ${core_folder}/xdstools/functions
ln -s ${core_folder}/xdstools/java
ln -s ${core_folder}/xdstools/main
ln -s ${core_folder}/xdstools/ricerca.php
ln -s ${core_folder}/xdstools/xds_lib

mkdir config
cd config
cp ${core_folder}/xdstools/config/config.inc.php.default ./config.inc.php
cd ..

mkdir certificates
mkdir logs
mkdir tmp
cd ..

#Screening
if [ ${screening} -eq 1 ] 
then
	mkdir screening
	cd screening
	cp ${core_folder}/screening/confronta_firmati_automatico.default.php ./confronta_firmati_automatico.php
	cp ${core_folder}/screening/da_firmare.default.php ./da_firmare.php
	cp ${core_folder}/screening/da_firmare.default.js ./da_firmare.js
	cp ${core_folder}/screening/firma_auto_confronta_firmati.default.php ./firma_auto_confronta_firmati.php
	cp ${core_folder}/screening/report_screen_ins_SX.default.js ./report_screen_ins_SX.js
	cp ${core_folder}/screening/report_screen_ins_SX.default.php ./report_screen_ins_SX.php
	cp ${core_folder}/screening/vedi_referto.default.php ./vedi_referto.php

	ln -s ${core_folder}/screening/day_acquire.php
	ln -s ${core_folder}/screening/firma_auto_crea_PDF.php
	ln -s ${core_folder}/screening/firma_auto.php
	ln -s ${core_folder}/screening/firma_auto_singolo.js
	ln -s ${core_folder}/screening/firma_auto_singolo.php
	ln -s ${core_folder}/screening/report_ins.js
	ln -s ${core_folder}/screening/rullo.php
	ln -s ${core_folder}/screening/screening_start.php

	cd ..
fi
#attribuisco i permessi al dominio appena creato
chown -R www-data:www-data $domain_name
chmod -R 777 $domain_name

##############################  FINE CREAZIONE CARTELLA DI DOMINIO  ########################################

##############################  INIZIO CREAZIONE CARTELLA RIS_DOMAIN  ######################################

ris_domain_name="/var/www/html/ris_domain_$dominio"

mkdir $ris_domain_name
cd $ris_domain_name

cp ${ris_domain_folder}/ApiRis.skipper $ris_domain_name
cp ${ris_domain_folder}/composer.json $ris_domain_name
cp ${ris_domain_folder}/composer.lock $ris_domain_name
cp -r ${ris_domain_folder}/config/ $ris_domain_name
cp ${ris_domain_folder}/conn.php $ris_domain_name
cp ${ris_domain_folder}/COPYRIGHT.md $ris_domain_name
cp -r ${ris_domain_folder}/data/ $ris_domain_name
cp ${ris_domain_folder}/docker-compose.yml $ris_domain_name
cp ${ris_domain_folder}/Dockerfile $ris_domain_name
cp -r ${ris_domain_folder}/entities/ $ris_domain_name
cp ${ris_domain_folder}/LICENSE.md $ris_domain_name
cp -r ${ris_domain_folder}/logs/ $ris_domain_name
cp -r ${ris_domain_folder}/mappings/ $ris_domain_name
cp -r ${ris_domain_folder}/migrations/ $ris_domain_name
cp -r ${ris_domain_folder}/module/ $ris_domain_name
cp ${ris_domain_folder}/phpcs.xml $ris_domain_name
cp ${ris_domain_folder}/phpunit.xml.dist $ris_domain_name
cp -r ${ris_domain_folder}/public/ $ris_domain_name
cp ${ris_domain_folder}/README.md $ris_domain_name
cp -r ${ris_domain_folder}/src/ $ris_domain_name
cp ${ris_domain_folder}/Vagrantfile $ris_domain_name
cp -r ${ris_domain_folder}/vendor/ $ris_domain_name

cd ..
chown -R www-data:www-data $ris_domain_name
chmod -R 777 $ris_domain_name

################################  FINE CREAZIONE CARTELLA RIS_DOMAIN  #######################################

################################  INIZIO CREAZIONE CARTELLA RIS_SERVICE  ####################################

ris_service_name="/var/www/html/ris_service_$dominio"

mkdir $ris_service_name
cd $ris_service_name

cp ${ris_service_folder}/composer.json $ris_service_name
cp ${ris_service_folder}/config.php $ris_service_name
cp ${ris_service_folder}/database.php $ris_service_name
cp ${ris_service_folder}/generate.php $ris_service_name
cp ${ris_service_folder}/index.php $ris_service_name
cp ${ris_service_folder}/jwt.php $ris_service_name
cp ${ris_service_folder}/nexu-standalone-5.2.1-jar-with-dependencies.jar $ris_service_name

cd ..
chown -R www-data:www-data $ris_service_name
chmod -R 777 $ris_service_name

#################################  FINE CREAZIONE CARTELLA RIS_SERVICE  #######################################

#################################  INIZIO CREAZIONE CARTELLA VIRTUHIS_IPA  ####################################

virtuhis_ipa_name="/var/www/html/virtuhis_ipa_$dominio"

mkdir $virtuhis_ipa_name
cd $virtuhis_ipa_name
mkdir sc_cron_mirth
cd sc_cron_mirth

cp ${ipa_folder}/sc_cron_mirth/cron_mirth.php ${virtuhis_ipa_name}/sc_cron_mirth
cp ${ipa_folder}/sc_cron_mirth/cron_sync.php ${virtuhis_ipa_name}/sc_cron_mirth
cp ${ipa_folder}/sc_cron_mirth/functions.php ${virtuhis_ipa_name}/sc_cron_mirth
cp ${ipa_folder}/sc_cron_mirth/import_mirth.php ${virtuhis_ipa_name}/sc_cron_mirth

cd ..
chown -R www-data:www-data $virtuhis_ipa_name
chmod -R 777 $virtuhis_ipa_name

##################################  FINE CREAZIONE CARTELLA VIRTUHIS_IPA  ########################################

echo "FINE SCRIPT"