<?php
/**
 * file di configurazione per il VirtuHis[DCM]
 *
 * @copyright Gmed Srl
 * @author Sciarrone Riccardo <riccardos@gmed.it>, Taggi Silvio <silvio@gmed.it>
 */



 /*
      STATUS dello STUDIO
      0 =>  NUOVO
      1 =>  MODIFICATO (arrivata modifica ad uno esistente)

      2 =>  DA ELABORARE
            - versione manuale => Accession Number confermato dall'utente
            - versione automatica => viene messo in questo stato automaticamente alla ricezione

      5 =>  ELABORATO 
            lo studio è pronto per essere spedito

      6 =>  STORE in CORSO
            lo studio ha un JOB di trasferimento


      7 =>  SPEDITO
            lo studio può ancore essere rispedito a mano

      8 =>  ERRORE STORE
            errore riscontrato nello STORE


      9 =>  RIMOSSO
            lo studio NON è più su ortHanc QUINDI non può più essere rispedito


      55 =>  ELABORATO ma lo studio esce dalla procedura
      56 =>  STORE in CORSO : lo studio ha un JOB di trasferimento
      57 =>  SPEDITO : lo studio può ancore essere rispedito a mano  
      59 =>  RIMOSSO : lo studio NON è più su ortHanc QUINDI non può più essere rispedito  


      98 =>  DA RIMUOVERE
      lo studio verra rimosso da OrtHanc su richiesta dell'utente

      99 => RIMOSSO per richiesta dell'utente
  */


/*
 * STATUS IMPORT
 * 
 *  0 = in attesa di conferma
 *  1 = confermato  
 *  2 = inviato  
 * 90 = cancellato  
 * 99 = annullato
 * 
 */


define( "PROXY_use", FALSE );

// 2023-02-17 - SR - aggiunto il NOME dell'IPA che sta inviando al CS
define( "source_name", "IPA-X86" );
define( "source_tag", "RequestedProcedureDescription" );



// 2023-02-17 - SR - log per MONIT
define( "orthanc_call_error_logfile", "/var/www/html/dcm/logs/log_orthanc_call_error.log" );


//define( "orthanc_url", "http://192.168.62.126:8042" );
define( "orthanc_url", "http://127.0.0.1:8042" );
define( "orthanc_username", "gmedx" );
define( "orthanc_password", "0rt#4nc" );
define( "orthanc_dir", "/storage/virtuhis_dcm/db-v6/" );
define( "orthanc_timeout", 100 ); // millisecondi di attesa tra una chiamata e l'altra
define( "orthanc_call_logfile", "/var/www/html/dcm/logs/log_orthanc_call.log" );

// elenco dei tag da leggere
define( "dcm_tags", "" );


define( "dcmodify_path", "/usr/bin/dcmodify" );

// Modality o PEER di destinazione presente nel file di conf di orthanc
define( "dcm_destination", "PEER_134" );

// 2023-03-09 - SR - metodo di STORE DCM  ( 'peers' o 'modalities' )
define( "dcm_store_method", "peers" ); 


define( "demo_mode", TRUE );

define( "delete_after", 0 );  // gg di conservazione, oltre i quali viene cancellato lo studio    0 = SUBITO!


// se TRUE, per ogni studio entrerà nel ciclo di cambio TAG DICOM
// con Orthanc, questa cosa non serve!!
define( "tags_to_modify_foreach", FALSE );


// 2023-03-09 - conf portate fuori
define( "LocalAet", "IPA_X86" );
define( "MoveOriginatorAet", "IPA_X86" );
define( "MoveOriginatorID", 1234 );



// 2023-02-17 - gg di conservazione per i DCM fuori procedura (status 55)
define( "delete_other_after", 30 );  // gg di conservazione, oltre i quali viene cancellato lo studio


// 2023-05-15 -- quante volte tento di inviare uno studio il cui JOB è andato in errore nel C-MOVE
define( "max_send_repeat", 3 );


/*
 * IMPORT CD - DCM - DCM DIR
 */
// dati server e pacs remoti
define( "historic_import_active", TRUE );       // l'import di DVD, files e dir è attivo!!!

define( "IMPORT_restar_url", "http://192.168.62.134/ris_domain_t2" );
define( "IMPORT_sc_connector_url", "http://192.168.62.134/test2" );
define( "IMPORT_check_remote_pacs", TRUE );                             // cerco lo studio che sto importando su PACS remoto (via StudyInstanceID)
define( "IMPORT_AET_remote_pacs", 'me_stesso' );                        // AET del PACS per l'orthanc centrale!!!      
define( "IMPORT_remote_orthanc", "http://192.168.62.134:8042" );        // indirizzo dell'orthanc centrale


define( "IMPORT_change_acc_number", FALSE );  // deve cambiare l'AN all'import
define( "IMPORT_acc_number_prefix", "IMP_" );


// 2023-05-08 - SR - aggiunto il NOME dell'IPA IMPORT che sta inviando al CS
// può essere diverso da source_name
define( "IMPORT_source_name", "IMPORT-IPA-X86" );

define( "IMPORT_tag_dcm", "StationName" );
define( "IMPORT_tag_dcm_value", "VHIS-IMPORT-TMP" );
// -----------------------




define( "writelog_dir", "/var/www/html/dcm/logs/" );
define( "retrieve_logfile", "/var/www/html/dcm/logs/log_retrieve.log" );
define( "process_logfile", "/var/www/html/dcm/logs/log_process.log" );
define( "send_logfile", "/var/www/html/dcm/logs/log_send.log" );
define( "delete_logfile", "/var/www/html/dcm/logs/log_delete.log" );
define( "import_logfile", "/var/www/html/dcm/logs/log_import.log" );
define( "ris_logfile", "/var/www/html/dcm/logs/log_ris.log" );

define( "generic_logfile", "/var/www/html/dcm/logs/log_generic.log" );

define( "pids_dir", "/var/www/html/dcm/pids/" );




define('db_conn', [
    'conn_db' => [
        'active' => true,
        'default' => true,
        //'db_ip' => '192.168.62.125',
        'db_ip' => '127.0.0.1',
        'db_name' => 'risico',
        'db_user' => 'postgres',
        'db_pwd' => '',
        'db_port' => '5432'
    ],
]);



/**
 * mettere a TRUE se l'Accession Number sarà calcolato in autonomia
 * SENZA l'intervento dell'operatore
 */
define( "automatic_AC", TRUE );


/**
 * impostare qui se i programmi gireranno via
 * via command line ("cmd")
 * o
 * via browser ("web")
 */
define( "exec_as", "web" );



#####################################
############ DEBUG ENV ##############
define( "test_env", true );
####################################







####################################
//Configurazione mailserver
##### Gestione Notifiche #####
//Email
define('email_server_host', "gmed.it" );
define('email_server_port', "465" ); // Server port

define('email_server_smtp', true ); // true se il server si collega tramite smtp
define('email_server_auth', true ); // true se il server richiede autenticazione
define('email_server_ssl', "tls" ); // Connection security tls, ssl o vuoto
define('email_username', "vtiger" );
define('email_userpassword', "jBv_w2%Y882BkM*c" );

define('email_from', "service@gmed.it" );
define('email_from_name', "Adapter 01" );
