<?php
/**
 * @copyright Gmed Srl
 * @author Mirko Giulianini <mirko@gmed.it>
 * 
 * programma che visualizza lo stato dei servizi
 */

include('../include/header.php');


if (isset($_POST['to_update']) && $_POST['to_update'] == 'si') {

    $i = 0;
    foreach ($_POST['nome_poll'] as $single_proc) {
        $arr_new_json[$single_proc]['active'] = (int) $_POST['active'][$i];
        $arr_new_json[$single_proc]['act_polling'] = (int) $_POST['act_polling'][$i];
        $arr_new_json[$single_proc]['max_polling'] = (int) $_POST['max_polling'][$i];
        $arr_new_json[$single_proc]['exec_hour'] = $_POST['exec_hour'][$i];
        $arr_new_json[$single_proc]['last_execution'] = $_POST['last_execution'][$i];
        $arr_new_json[$single_proc]['exclude_time'] = trim($_POST['exclude_time'][$i]);
        $arr_new_json[$single_proc]['max_execution_time'] = (int) $_POST['max_execution_time'][$i];

        $i++;
    }

    echo "Backup crontab_attuale -> crontab_polling_" . date('YmdHis') . ".bck.json<br>";
    rename(__DIR__ . "/../crontab_polling.json", __DIR__ . "/../crontab_polling_" . date('YmdHis') . ".bck.json");
    
    echo "Scrivo nuovo crontab...<br>";
    file_put_contents(__DIR__ . "/../crontab_polling.json", json_encode($arr_new_json, JSON_PRETTY_PRINT));

    echo "<h4>Aggiornato!</h4><br>";

    echo "<pre>";
    //print_r($arr_new_json);
    echo "</pre>";
}

if (isset($_POST['to_execute']) && !empty($_POST['to_execute'])) {
	
	$cron_name = $_POST['to_execute'];
	echo "<h4>Esecuzione di $cron_name</h4>";
	
	$execute_string = "php " . __DIR__ . "/../cron_services/" . $cron_name . ".php > /dev/null &";
	
	exec("sudo " . $execute_string, $exe_out);
	echo "<br> Eseguito-> " . $execute_string . " <br/>o>" . json_encode($exe_out) . "<br/>";
    file_put_contents(__DIR__ . "/../cron_" . $cron_name . ".pid", date('Y-m-d H:i:s'));
    exit();
}

$arr_polling = json_decode(trim(file_get_contents(__DIR__ . "/../crontab_polling.json")), true);
ksort($arr_polling);
?>
<head>
</head>
<body>
    <div class="panel">
        <h3>Gestore Cron</h3>
        <button class="btn btn-warning btn-block"  value="Refresh Page" onClick="window.location = window.location.href;">Refresh Cron Polling</button>
        <form method="post">
            <input type="hidden" name="to_update" id="to_update" value="si">
            <input type="hidden" name="to_execute" id="to_execute" value="">
            <button class="btn btn-success btn-block" type="submit" id="update_me">Aggiorna JSON CRONTAB <span id="time"></span></button>
            <table class="table table-hover table-active table-bordered">
                <tr><th>
                        Nome
                    </th><th>
                        Stato
                    </th>
                    <th>
                        polling
                    </th>
                    <th>
                        Tempo massimo esecuzione
                    </th>
                    <th>
                        Orario Esclusione
                    </th>
                    <th>
                        Esegui alle ore..
                    </th>
                    <th>
                        ultima esecuzione
                    </th>
                    <th>
                        Polling attuale
                    </th>
                    <th>
                        Esecuzione Manuale
                    </th>
                </tr>
                <?php
                foreach ($arr_polling as $single_poll => $values) {
                    ?><tr>
                        <td>
                            <?php echo $single_poll ?>
                            <input type="hidden" name="nome_poll[]" id="nome_poll[]" value="<?php echo $single_poll ?>">
                        </td>
                        <td>
                            <div class="form-group">
                                <select class="form-control <?php echo ($values['active'] == '1') ? "btn-success" : "btn-danger" ?>" name="active[]" id="active[]" style="min-width: 97px;">
                                    <option <?php echo ($values['active'] == '1') ? "selected" : "" ?> value="1" >Attivo</option>
                                    <option <?php echo ($values['active'] == '0') ? "selected" : "" ?> value="0" >Spento</option>
                                </select>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input type="number" class="form-control" name="max_polling[]"  id="max_polling[]" aria-describedby="emailHelp" value="<?php echo $values['max_polling'] ?>">
                                <small id="emailHelp" class="form-text text-muted">Tempo di polling in minuti</small>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input type="number" class="form-control" name="max_execution_time[]" id="max_execution_time[]" aria-describedby="emailHelp" value="<?php echo $values['max_execution_time'] ?>">
                                <small id="emailHelp" class="form-text text-muted">Tempo massimo di esecuzione in minuti</small>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input type="text" class="form-control" name="exclude_time[]" id="exclude_time[]" aria-describedby="emailHelp" value="<?php echo @$values['exclude_time'] ?>">
                                <small id="emailHelp" class="form-text text-muted">Orario di Esclusione nel formato h-h (esempio 0-6)<br>Se i valori sono uguali il controllo viene escluso</small>
                            </div>
                        </td>
                        <td>

                            <div class="form-group">
                                <select class="form-control" name="exec_hour[]" id="exec_hour[]">
                                    <?php
                                    $arr_h = ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24'];

                                    foreach ($arr_h as $sh) {
                                        ?>

                                        <option <?php echo ($values['exec_hour'] == $sh) ? "selected='SELECTED'" : "" ?> value="<?php echo $sh ?>"><?php echo $sh ?></option>
                                    <?php }
                                    ?>

                                </select>
                                <small id="emailHelp" class="form-text text-muted">Esegui solo alle ore indicate<br>NB - Attivo solo se il tempo di pollig uguale o maggiore di 1440</small>
                            </div>

                        </td>
                        <td>
                            <?php echo $values['last_execution'] ?>
                            <input type="hidden" name="last_execution[]" id="last_execution[]" value="<?php echo $values['last_execution'] ?>">
                        </td>
                        <td>
                            <?php echo $values['act_polling'] ?>
                            <input type="hidden" name="act_polling[]" id="act_polling[]" value="<?php echo $values['act_polling'] ?>">
                        </td>
                        <td>
                            <!--div class="btn btn-block" onclick="openInNewTab('<?php echo "../cron_services/" . $single_poll ?>');">Avvia <?php echo $single_poll ?></div-->
							<button class="btn btn-primary btn-block" type="submit" onclick="execute('<?php echo $single_poll ?>');">Esegui <?php echo $single_poll ?></button>
                        </td>
                    </tr>   

                <?php } ?>
            </table>


        </form>

    </div>
    <pre>
        <?php //print_r($arr_polling)  ?>
    </pre>

    <script>
	    
	    function execute(command) {
		    document.getElementById('to_update').value = null;
		    document.getElementById('to_execute').value = command;
	    }
	    
        function openInNewTab(url) {
            var win = window.open(url, '_blank');
            win.focus();
        }
        ;
        var timeleft = 40;
        var downloadTimer = setInterval(function () {
            if (timeleft <= 0) {
                clearInterval(downloadTimer);
                document.getElementById("time").innerHTML = "(Tempo Scaduto. Cliccare su 'Refresh Cron' per riattivate)";
            } else {
                document.getElementById("time").innerHTML = "(" + timeleft + ")";
            }
            timeleft -= 1;
        }, 1000);
        window.onload = function () {
            document.getElementById('update_me').disabled = false;
            setTimeout(function () {
                var element = document.getElementById('update_me');
                element.disabled = true;
            }, 41000);
        };
    </script>
</body>
