<?php
/**
 * @copyright Gmed Srl
 * @author Sciarrone Riccardo <riccardos@gmed.it>
 *
 * programma che cancella gli "other" studi in "spedito" (status 57)
 *
 */

// Report all errors except E_NOTICE
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


include __DIR__ . "/../conf/config.inc.php";
include __DIR__ . "/../include/basic_function.php";
include __DIR__ . "/../include/dcm_function.php";
//include __DIR__ . "/tags_to_modify_calculation.php";

$this_pid = __DIR__ . "/../cron_" . basename(__FILE__, ".php") . ".pid";
if (file_exists($this_pid)) {
    unlink($this_pid);
}

$pid_name = "delete_studies";
check_pid($pid_name);


if( isset($GLOBALS["db_error"]['default_db']) ){
    WriteLog( "Errore DB: " . $GLOBALS["db_error"]['default_db'], "ERROR" );
    die_proc( "Errore DB: " . $GLOBALS["db_error"]['default_db'], $pid_name );
}


echoo( "\nELABORO GLI STUDI in stato 57\n\n" );
WriteLog( "ELABORO GLI STUDI in stato 57", process_logfile, "INFO" );



$single_orthanc_id = "";
if ( isset($argv[1]) || isset($_GET["id"]) ) {
    // da elaborare UN singolo studio
    $single_orthanc_id = " AND orthanc_id = '" .
                            ( isset($argv[1]) ? $argv[1] : $_GET["id"] )
                            . "' ";
}

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$data_to_delete = date('Y-m-d', strtotime($date . ' -' . delete_after . ' day'));


$studies = query_select("   SELECT  *
                            FROM    dcm_study
                            WHERE   status = 57 
                                    $single_orthanc_id
                            ORDER BY id ");


echoo( " WHERE  status = 57 $single_orthanc_id \n\n" );


if ( !isset($studies[0]['id']) || IsNull($studies[0]['id']) ) {
    // NULLA DA elaborare
    WriteLog( "NULLA DA ELABORARE", os_delete_logfile, "INFO" );
    die_proc( "NULLA DA ELABORARE \n", $pid_name );
}


foreach ($studies as $q_study) {
    echoo( "Elaboro " . $q_study["id"] . " => " . $q_study["orthanc_id"] . "  Status: " . $q_study["status"] . " \n" );
    WriteLog( "Elaboro " . $q_study["id"] . " => " . $q_study["orthanc_id"] . "  Status: " . $q_study["status"], os_delete_logfile, "INFO" );


    //curl -X DELETE http://localhost:8042/studies/d79f11d9-c75867f7-20330513-fb4c1101-33636dbf

    $cmd = orthanc_url . '/studies/' . $q_study["orthanc_id"];



    // 2023-03-09 - SR - ripristinare la chiamata REALE dopo i TEST
    $result = call_orthanc( $cmd, "DELETE", false, 'DELETE', null );
    //$result = Array( "TEST" => "OK" );


    WriteLog( "Studio " . $q_study["id"] . " => delete result: " . print_r($result, TRUE), os_delete_logfile, "INFO" );

    $update_sql = " UPDATE  dcm_study
                    SET     status = 59
                    WHERE   id = " . $q_study["id"];
    $upd_chan = query_execute($update_sql);
    echoo( "Studio " . $q_study["id"] . " => " . $q_study["orthanc_id"] . " andato in status: 59 <hr/>\n" );
    WriteLog( "Studio " . $q_study["id"] . " => " . $q_study["orthanc_id"] . " andato in status: 59", os_delete_logfile, "INFO" );
}


echoo( "\n\n<hr>FINE ELABORAZIONE\n\n" );

kill_pid($pid_name);
