<?php
/**
 * @copyright Gmed Srl
 * @author Sciarrone Riccardo <riccardos@gmed.it>
 * 
 * qui viene messa la funzione che 
 * elabora lo studio che arriva come parametro
 * 
 * deve tornare un "oggetto" che contiene
 *      "process"           : TRUE:FALSE
 *      "status"            : status che dovrà prendere dopo lo studio (se process "true")
 *      "tags_to_modify"    : elenco dei tags che devono essere modificati (se process "true")
 *      "update_fields"     : elenco dei campi da aggiornare in DB
 */


function process_single_study( $study, $study_db ) {

    $ret = Array(
        "process" => TRUE,
        "status" => 5,
        "tags_to_modify" => Array(),
        "update_fields" => Array()
    );


    $repl = ' "' . source_tag . '":"' . source_name .'" ';


    $src_tg = source_tag;
    switch( source_tag ){
        case "InstitutionName":
            $src_tg = "institution_name";
            break;
        case "StationName":
            $src_tg = "station_name";
            break;
        case "RequestedProcedureDescription":
            $src_tg = "requested_procedure_description";
        default:
            break;                    
    }
    $ret["update_fields"][ $src_tg ] = "'" . source_name . "'";
    $ret["tags_to_modify"][ source_tag ] = "'" . source_name . "'";

    // 2023-05-08
    // se è uno studio di IMPORT imposto i sui valori
    if( historic_import_active ){
        $sql = "    SELECT 	distinct(di.status) AS sts, di.id as di_id
                    FROM 	public.dcm_imports di 
                            INNER JOIN public.dcm_imports_instances dii ON dii.fk_import = di.id 
                    WHERE 	dii.parent_study = '" . $study_db["orthanc_id"] . "' ";
        $sts = query_select( $sql );

        /*
        * status   
        *  0 ==> ancora in pagina web
        *  1 ==> è stato confermato!
        *  2 ==> spedito
        * 90 ==> cancellato
        * 99 ==> annullato import
        */
        if ( isset($sts[0]['sts']) && !IsNull($sts[0]['sts']) && $sts[0]['sts'] == "1" ) {
            // lo studio è ANCORA IN GESTIONE IMPORT 
            echoo( "QUESTO STUDIO  (" . $study_db["orthanc_id"] . ")  E' DI IMPORT<br/>" );

            // campi di UPDATE nel DB
            $ret["update_fields"][ $src_tg ] = "'" . IMPORT_source_name . "'";

            switch( IMPORT_tag_dcm ){
                case "InstitutionName":
                    $ret["update_fields"][ "institution_name" ] = "'" . IMPORT_tag_dcm_value . "'";
                    break;
                case "StationName":
                    $ret["update_fields"][ "station_name" ] = "'" . IMPORT_tag_dcm_value . "'";
                    break;
                case "RequestedProcedureDescription":
                    $ret["update_fields"][ "requested_procedure_description" ] = "'" . IMPORT_tag_dcm_value . "'";
                default:
                    break;                    
            }

            // TAG DICOM da modificare
            $ret["tags_to_modify"][ source_tag ] = IMPORT_source_name ;
            $ret["tags_to_modify"][ IMPORT_tag_dcm ] = IMPORT_tag_dcm_value;

            $repl = ' "' . source_tag . '":"' . IMPORT_source_name .'" ';
            $repl .= ', "' . IMPORT_tag_dcm . '":"' . IMPORT_tag_dcm_value . '" ';
        }

        // 2023-05-11 - SR - setto lo studio COME già elaborato dal DCM
        $sql = "    UPDATE  public.dcm_imports_instances
                    SET     dcm_processed = 1
                    WHERE 	parent_study = '" . $study_db["orthanc_id"] . "' ";
        $dcm_proc = query_execute( $sql );
    }


    $post_fields = '
    {   
        "Replace": { ' . $repl . ' },
        "Remove":[],
        "Keep":["StudyInstanceUID","SeriesInstanceUID","SOPInstanceUID"],
        "KeepSource":true,
        "Force":true,
        "Synchronous":false
    }
    ';

    $modify_url = "/studies/" . $study_db["orthanc_id"]. "/modify";
    $studies = call_orthanc( orthanc_url . $modify_url, "STUDIES", FALSE, 'POST', trim($post_fields) );


    return $ret;
}
