<?php
/**
 * @copyright Gmed Srl
 * @author Sciarrone Riccardo <riccardos@gmed.it>
 *
 * Programma che elabora gli studi in STATUS 2
        - versione manuale (automatic_AC=FALSE) => Accession Number confermato dall'utente è nel campo AccessionNumber dello studio su DB
        - versione automatica (automatic_AC=TRUE) => va calcolato cercandolo nello studio DICOM (funzioni personalizzabili per installazione)
 */


// Report all errors except E_NOTICE
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


include __DIR__ . "/../conf/config.inc.php";
include __DIR__ . "/../include/basic_function.php";
include __DIR__ . "/../include/dcm_function.php";

// 2023-02-17 - SR - sostituito il file di include
//include __DIR__ . "/tags_to_modify_calculation.php";
include __DIR__ . "/process_single_study.php";


$this_pid = __DIR__ . "/../cron_" . basename(__FILE__, ".php") . ".pid";
if (file_exists($this_pid)) {
    unlink($this_pid);
}

$pid_name = "process_studies";
//check_pid($pid_name);


if( isset($GLOBALS["db_error"]['default_db']) ){
    WriteLog("Errore DB: " . $GLOBALS["db_error"]['default_db'], "ERROR");
    die_proc("Errore DB: " . $GLOBALS["db_error"]['default_db'], $pid_name);
}


$single_orthanc_id = "";
if ( isset($argv[1]) || isset($_GET["id"]) ) {
    // da elaborare UN singolo studio
    $single_orthanc_id = " AND orthanc_id = '" .
                            ( isset($argv[1]) ? $argv[1] : $_GET["id"] )
                            . "' ";
}



echoo("\nELABORO GLI STUDI in stato 2\n\n");
WriteLog("ELABORO GLI STUDI in stato 2", process_logfile, "INFO");


$studies = query_select("   SELECT  *
                            FROM    dcm_study
                            WHERE   status = 2
                                    $single_orthanc_id
                            ORDER BY id ");

if ( !isset($studies[0]['id']) || IsNull($studies[0]['id']) ) {
    // NULLA DA elaborare
    WriteLog("NULLA DA ELABORARE", process_logfile, "INFO");
    die_proc("NULLA DA ELABORARE \n", $pid_name);
}


foreach ( $studies as $q_study ) {
    echoo("Elaboro " . $q_study["id"] . " => " . $q_study["orthanc_id"]. "\n");
    WriteLog("Elaboro " . $q_study["id"] . " => " . $q_study["orthanc_id"], process_logfile, "INFO");


    $study = retrieve_single_study( $q_study["orthanc_id"] );

    if( isset($study["error"]) ){
        // studio non trovato! passo alla prossima
        echoo("ERRORE " . $study["error"] . " - " .$study["descr"] . "\n\n");
        WriteLog("ERRORE " . $study["error"] . " - " .$study["descr"], process_logfile, "ERROR");
        continue;
    }

    /*
     * 2023-02-17 - SR 
     * strutturato meglio la verticalizzazione dell'elaborazione
     * del singolo studio
     */


    // OLD!!!  chiamo la funzione di calcolo dell' acc number
    // $tags_to_modify = tags_to_modify_calculation($study, $q_study);
    $to_do = process_single_study( $study, $q_study );


    // 2023-02-17 - SR - mettere il controllo se questo studio va gestito o "abbandonato"
    if( $to_do["process"] ){
        $modify = 0;
        $tags_to_modify = $to_do["tags_to_modify"];
        /*
         * 2023-03-09 - SR
         * SU KORIAN NON SERVE 
         * qui si passa SOLO se sono da cambiare i TAG delle singole INSTANCES!!!!!!
         */
        if ( tags_to_modify_foreach && count($tags_to_modify) > 0 ) {
            // devo ciclare su tutte le istanze per cambiare dei TAG DICOM
            echoo( "ELABORO I TAGS CALCOLATI: \n" );
            echoo( $tags_to_modify, TRUE);
            WriteLog( "ELABORO I TAGS CALCOLATI: " . print_r($tags_to_modify, TRUE), process_logfile, "INFO" );
    
            foreach( $study["Instances"] as $instance ){
                $uuid = $instance["FileUuid"];

                $fileName = orthanc_dir . substr($uuid, 0, 2) . "/" . substr($uuid, 2,2) . "/" . $uuid;
                if ( 1== 1 || file_exists($fileName) ){
                    // setto il tag modificati
                    $sql_tags_to_modify = "{";
                    foreach( $tags_to_modify as $key => $value ){
                        // qui controllare che questo TAG non sia già a posto
                        // nel qual caso NON eseguire l'exec

                        // 2023-03-09 - SR
                        // tolto la parte che modificava le instances con dcmtools
                        // mettere ORTHANC!!

                        $modify++;
                    }
                }
            }
        }


        // 2023-02-17 - SR - controllo se devo modificare dei campi nel DB
        $update_fields = $to_do["update_fields"];
        $flds_sql = "";
        if ( count($update_fields) > 0 ){
            foreach( $update_fields as $key => $value ) {
                $flds_sql .= "$key = $value, ";
            }
        }

        echoo( $tags_to_modify, true );
        
        $sql_tags_to_modify = pg_escape_string( json_encode($tags_to_modify) );
        $update_sql = " UPDATE  dcm_study
                        SET     $flds_sql
                                status = " . $to_do["status"] . ",
                                archive_date = '" . date("Y-m-d H:i:s") . "',
                                tags_to_modify = '$sql_tags_to_modify'
                        WHERE   id = " . $q_study["id"];
        echoo( "$update_sql\n\n" );
        $upd_chan = query_execute( $update_sql );
                
        echoo( "modifiche apportate $flds_sql \n" );     
        //echoo( "trovate " . count($study["Instances"]) . " Instances  (modifiche apportate $modify)\n" );
        echoo( "cambiato lo stato in 5\n\n" );
        WriteLog("cambiato lo stato in '5' ", process_logfile, "INFO" );

        echoo( "<hr/>" );
    }
    else {
        echoo( "questo studio (" . $q_study["orthanc_id"] . ")  NON deve essere elaborato \n\n" );
    }
    // FINE di PROCESS!!
}


echoo("\n\n<hr>FINE ELABORAZIONE\n\n");

kill_pid($pid_name);