<?php
/**
 * @copyright Gmed srl
 * @author Riccardo Sciarrone <riccardos@gmed.it>
 *
 * Programma che recupera gli studi presenti in OrtHanc
 * controlla se sono nuovi o modificati e li mette nello stato
 * 0 o 1  se la procedura è con "accettazione manuale" o
 * stato 2 (da elaborare) se automatica
 * 
 * 
 * ex  check_
 */




// Report all errors except E_NOTICE
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


include __DIR__ . "/../conf/config.inc.php";
include __DIR__ . "/../include/basic_function.php";
include __DIR__ . "/../include/dcm_function.php";

// 2023-02-17 - SR - sostituito il file di include
//include __DIR__ . "/tags_to_modify_calculation.php";
include __DIR__ . "/process_single_study.php";


$this_pid = __DIR__ . "/../cron_" . basename(__FILE__, ".php") . ".pid";
if ( file_exists($this_pid) ) {
    unlink($this_pid);
}

$pid_name = "check_new_studies";
check_pid( $pid_name );


if (isset($GLOBALS["db_error"]['default_db'])) {
    WriteLog("Errore DB: " . $GLOBALS["db_error"]['default_db'], "ERROR");
    die_proc("Errore DB: " . $GLOBALS["db_error"]['default_db'], $pid_name);
}

WriteLog( "RECUPERO GLI STUDI DA ORTHANC", retrieve_logfile, "INFO" );


$single_orthanc_id = "";
if ( isset($argv[1]) || isset($_GET["id"]) ) {
    // da elaborare UN singolo studio
    $single_orthanc_id = isset($argv[1]) ? $argv[1] : $_GET["id"];
}



$studies = call_orthanc(orthanc_url . '/studies?expand', "STUDIES");


// Elaboro tutti gli studi arrivati
foreach ( $studies as $study ) {

    if( $single_orthanc_id != '' && $single_orthanc_id != $study["ID"] ){
        continue;
    }

    echoo("Elaboro " . $study["ID"] . " \n ");
    WriteLog("Elaboro " . $study["ID"], retrieve_logfile, "INFO");

    if ( $study["IsStable"] == 1 ) {
        // posso elaborare questo studio
        //echoo(($study, true);
        //echoo( "\n------</br/>";

        $orthanc_id = $study["ID"];

        /*
         * 2023-04-28 - SR 
         * ora controllo se import è attivo e, se sì, controllo che quello studio NON sia ancora da confermare!!
         */
        $sts = Array();
        if( historic_import_active ){
            $sql = "    SELECT 	distinct(di.status) AS sts, di.id as di_id
                        FROM 	public.dcm_imports di 
                                INNER JOIN public.dcm_imports_instances dii ON dii.fk_import = di.id 
                        WHERE 	dii.parent_study = '$orthanc_id' 
                                AND dcm_processed = 0 ";    // 2023-05-11 - SR -aggiunto AND per evitare che si elaborino studi già elaborati
            $sts = query_select( $sql );

            /*
             * status   
             *  0 ==> ancora in pagina web
             *  1 ==> è stato confermato!
             *  2 ==> spedito
             * 90 ==> cancellato
             * 99 ==> annullato import
             */
            if ( isset($sts[0]['sts']) && !IsNull($sts[0]['sts']) && $sts[0]['sts'] != "1" ) {
                // lo studio è ANCORA IN GESTIONE IMPORT 
                echoo( "QUESTO STUDIO ($orthanc_id) E' ANCORA IN IMPORT<br/>" );
                // vado al prossimo studio
                continue;
            }
        }

        echoo( $study["PatientMainDicomTags"], true );

        $std = query_select("   SELECT  *
                                FROM    dcm_study
                                WHERE   orthanc_id = '$orthanc_id' ");

        // salvo i dati del json in un array
        $sql_fields = array(
            'orthanc_id' => "'" . $study["ID"] . "'",
            'pat_name' => isset($study["PatientMainDicomTags"]["PatientName"]) ? "'" . my_pg_escape_string($study["PatientMainDicomTags"]["PatientName"]) . "'" : "'ND'",
            'pat_id' => isset($study["PatientMainDicomTags"]["PatientID"]) ? "'" . my_pg_escape_string($study["PatientMainDicomTags"]["PatientID"]) . "'" : "'ND'",
            'birth_date' => isset($study["PatientMainDicomTags"]["PatientBirthDate"]) ? dcm_date($study["PatientMainDicomTags"]["PatientBirthDate"]) : 'null',
            'sex' => isset($study["PatientMainDicomTags"]["PatientSex"]) ? "'" . $study["PatientMainDicomTags"]["PatientSex"] . "'" : "'ND'",
            'study_date' => isset($study["MainDicomTags"]["StudyDate"]) ? dcm_date($study["MainDicomTags"]["StudyDate"]) : null,
            'study_time' => isset($study["MainDicomTags"]["StudyTime"]) && isset($study["MainDicomTags"]["StudyDate"]) ? dcm_time($study["MainDicomTags"]["StudyDate"], $study["MainDicomTags"]["StudyTime"]) : 'null',
            'accession_number' => isset($study["MainDicomTags"]["AccessionNumber"]) ? "'" . my_pg_escape_string($study["MainDicomTags"]["AccessionNumber"]) . "'" : "'ND'",
            'study_id' => isset($study["MainDicomTags"]["StudyID"]) ? "'" . $study["MainDicomTags"]["StudyID"] . "'" : "'ND'",
            'study_instance_uid' => isset($study["MainDicomTags"]["StudyInstanceUID"]) ? "'" . my_pg_escape_string($study["MainDicomTags"]["StudyInstanceUID"]) . "'" : "'ND'",
            'study_description' => isset($study["MainDicomTags"]["StudyDescription"]) ? "'" . my_pg_escape_string($study["MainDicomTags"]["StudyDescription"]) . "'" : "'ND'",
            'archive_date' => "'" . date("Y-m-d H:i:s") . "'",
            'last_update' => isset($study['LastUpdate']) ? dcm_time(substr($study['LastUpdate'], 0, 8), substr($study['LastUpdate'], 9)) : 'null',
            'calculated_acc_numb' => "''",
            'status' => 0,
        );

        if( historic_import_active && isset($sts[0]['di_id']) && !IsNull($sts[0]['di_id']) ){
            $sql_fields["fk_import"] = $sts[0]['di_id'];
        }

        if ( isset($std[0]['id']) && !IsNull($std[0]['id']) ) {
            // ESISTE GIA'
            $sql_fields["status"] = automatic_AC ? 2 : 1;
            echoo("STUDIO GIA' TROVATO \n");
            WriteLog("STUDIO GIA' TROVATO: " . $sql_fields['last_update'], retrieve_logfile, "INFO");

            $lut = dcm_time(substr($study['LastUpdate'], 0, 8), substr($study['LastUpdate'], 9));

            $db_date = strtotime($std[0]["last_update"]);
            $st_date = strtotime(substr($lut, 1, strlen($lut) - 2)); // tolgo la virgoletta

            echoo(date("Y-m-d H:i:s", $db_date) . " <= " . date("Y-m-d H:i:s", $st_date) . "\n\n"); // . "  $lut\n\n");

            if ( $db_date < $st_date ) {
                // lo studio è stato modificato
                echoo("LO STUDIO E' STATO MODIFICATO\n");
                WriteLog("LO STUDIO E' STATO MODIFICATO", retrieve_logfile, "INFO");

                if (!automatic_AC) {
                    // mi carico TUTTO LO STUDIO e calcolo TUTTI i TAGS DICOM da modificare
                    $pacs_study = retrieve_single_study($study["ID"]);

                    
                    // OLD!!!  chiamo la funzione di calcolo dell' acc number
                    // $tags_to_modify = tags_to_modify_calculation($pacs_study, $std[0]);
                    $to_do = process_single_study( $pacs_study, $std[0] );                    
                    $tags_to_modify = $to_do["tags_to_modify"];

                    echoo("TAGS CALCOLATI: \n");
                    echoo($tags_to_modify, TRUE);
                    $sql_fields["tags_to_modify"] = "'" . pg_escape_string(json_encode($tags_to_modify)) . "'";
                }


                $update_sql = 'UPDATE dcm_study  SET ';

                $x = 0;
                foreach ( $sql_fields as $key => $value ) {
                    $update_sql .= " $key = $value ,";
                }
                
                // tolgo l'ultima virgola
                $update_sql = substr($update_sql, 0, strlen($update_sql) - 1);
                $update_sql .= ' WHERE id = ' . $std[0]['id'];

                echoo( "$update_sql \n\n" );

                $upd_chan = query_execute( $update_sql );
            }
        }
        else {
            // NUOVO
            $sql_fields["status"] = automatic_AC ? 2 : 0;
            echoo("  STUDIO NUOVO!\n\n");
            WriteLog("STUDIO NUOVO", retrieve_logfile, "INFO");
            $insert_sql = 'INSERT INTO  dcm_study '
                        . ' (' . implode(', ', array_keys($sql_fields)) . ')'
                        . ' VALUES (' . implode(', ', array_values($sql_fields)) . ')  '
                        . ' RETURNING id; ';

            //echoo( "$insert_sql\n\n" );
            $insert_res = query_execute( $insert_sql );

            $obj = pg_fetch_assoc($insert_res);
            $new_id = $obj["id"];


            // leggo l'id appena inserito
            $sql = "    SELECT  *
                        FROM    dcm_study
                        WHERE   id = $new_id ";
            $std = query_select( $sql );


            if (!automatic_AC) {
                // mi carico TUTTO LO STUDIO e calcolo TUTTI i TAGS DICOM da modificare
                $pacs_study = retrieve_single_study($study["ID"]);

                $tags_to_modify = tags_to_modify_calculation( $pacs_study, $std[0] );

                echoo( "TAGS CALCOLATI: \n" );
                echoo( $tags_to_modify, TRUE );

                $sql_fields["tags_to_modify"] = pg_escape_string(json_encode($tags_to_modify));

                $update_sql = " UPDATE  dcm_study
                                SET     tags_to_modify = '" . $sql_fields["tags_to_modify"] . "'
                                WHERE   id = $new_id ";
                echoo( "\n$update_sql\n" );
                $upd_chan = query_execute( $update_sql );
            }


        }
    }
    else {
        echoo($study["ID"] . " NOT STABLE \n ");
        WriteLog($study["ID"] . " NOT STABLE", retrieve_logfile, "INFO");
    }

    echoo( "<hr/><hr/>" );
}


echoo("\n\n<hr>FINE ELABORAZIONE\n\n");

kill_pid($pid_name);



function my_pg_escape_string( $s ){
   $cnn = $GLOBALS[ $GLOBALS["default_db"] ];
    if( !IsNull($s) ){
        $s = trim( $s );
        //echo "Elaboro $s <br/>";
        return pg_escape_string( $cnn, $s );
    }
    return "";
} 