<?php
/**
 * @copyright Gmed Srl
 * @author Mirko Giulianini <mirko@gmed.it>
 * 
 * programma che lancia i vari servizi
 */

if (php_sapi_name() == "cli") {
    $newline = "\n";
} 
else {
    $newline = "<br>";
    die("Solo da CLI");
}

set_time_limit(180);
ini_set('max_execution_time', 180); //3600 secondi = 60 minuti

include_once __DIR__.'/../conf/config.inc.php';
include_once __DIR__.'/../include/basic_function.php';
include_once __DIR__.'/../include/kxa_function.php';


$pid_basename = __DIR__ . "/../kx_cron.pid";
$json_polling = __DIR__ . "/../crontab_polling.json";

$new_arr_polling = [];

if (file_exists($json_polling)) {

    $arr_polling = json_decode(file_get_contents($json_polling), 1);
    if (!is_array($arr_polling)) {
        WriteLog("Config mancante", crontab_logfile, "ERROR");
        unlink($json_polling);
        exit();
    }
} 
else {
    //Se non c'è il file inizializzo un array vuoto
    $arr_polling = [];
}

//Fase 00 - KFE crontab
//MG 2019 04 - Nuova gestione Cron. Tutti i cron sono inseriti nella cartelal cron_services

echo "$newline Nuova gestione Cron. Tutti i cron sono inseriti nella cartella cron_services";


if ($handle = opendir(__DIR__.'/../cron_services')) {

    while (false !== ($entry = readdir($handle))) {

        //valida solo pagine con estensione .php che non siano index.php
        if ($entry != "." && $entry != ".." && $entry != ".htaccess" && $entry != "index.php"
                && strtolower(pathinfo($entry, PATHINFO_EXTENSION)) == 'php') {

            $cron_name = basename($entry, ".php");

            echo "$newline Trovato cron: $cron_name - Verifico se gia' attivo..";

            if (!isset($arr_polling[$cron_name])) {
                echo "$newline Cron: $cron_name - Non configurato, genero la configurazione in stato DISATTIVATO!!";
                $arr_polling[$cron_name]['active'] = 0;
                $arr_polling[$cron_name]['act_polling'] = 0;
                $arr_polling[$cron_name]['max_polling'] = 60;
                $arr_polling[$cron_name]['exec_hour'] = '00';
                $arr_polling[$cron_name]['last_execution'] = date('Y-m-d H:i:s');
                $arr_polling[$cron_name]['max_execution_time'] = 10;
            } 
            else {

                $to_go = CheckPoll($arr_polling, $cron_name);

                if ($to_go['active']) {
                    //Faccio partire il processo
                    //$execute_string = $wget_base . super_endpoint . "/cron_services/" . $entry . "' > /dev/null &";

                    //MG 2021 05 - Solo da CLI
                    $execute_string = "php " . __DIR__ . "/../cron_services/" . $entry . " > /dev/null &";

                    exec($execute_string, $exe_out);
                    echo "$newline Eseguito-> " . $execute_string . " $newline o>" . json_encode($exe_out) . "$newline";
                    file_put_contents(__DIR__ . "/../cron_" . $cron_name . ".pid", date('Y-m-d H:i:s'));
                    echo "$newline Eseguito-> " . $execute_string . "$newline";
                    sleep(1);
                }
                //echo "<pre>";
                //print_r($to_go['arr']);
                //echo "</pre>";
                $arr_polling = $to_go['arr'];
            }
            //Alla fine aggiorno il poller
            file_put_contents($json_polling, json_encode($arr_polling, JSON_PRETTY_PRINT));
        }
    }

    closedir($handle);
}

function CheckPoll($arr_polling, $proc_name) {
	
	global $newline;
	
    $pid_name = __DIR__ . "/../cron_" . $proc_name . ".pid";
    // Verifico se il processo sta ancora girando
    if (file_exists($pid_name)) {
        $proc_start_time = filemtime($pid_name);
        $now = time();

        $minuti = ($now - $proc_start_time) / 60; //Il ritorno è in secondi ed a me servono minuti

        echo "Processo " . $proc_name . " esiste da minuti " . $minuti . " ";

        if ($minuti > $arr_polling[$proc_name]['max_execution_time']) {
            //Processo appeso, termino il PID
            unlink($pid_name);
            echo "!!! Processo: $proc_name fermo da $minuti minuti, cancello il PID $newline";
            WriteLog("Processo: " . $proc_name . " fermo da " . $minuti . " minuti. Cancello il PID. $newline"
                    . "Verificare il tempo massimo di esecuzione (" . $arr_polling[$proc_name]['max_execution_time'] . " minuti) se si ripete il problema", crontab_logfile, "WARNING");
        } else {
            WriteLog("Processo: " . $proc_name . " in esecuzione da " . $minuti . " minuti (max " . $arr_polling[$proc_name]['max_execution_time'] . "). Salto", crontab_logfile, "INFO");
            echo "- Processo non concluso, salto $newline";
            $out['active'] = false;
            $out['arr'] = $arr_polling;
            return $out;
        }
    }

    //Verifico i parametri del processo e restituisco l'array modificato e lo stato di esecuzione
    $active = $arr_polling[$proc_name]['active'];

    echo "$newline Processo " . $proc_name . " - " . ($active ? "attivo" : "non attivo");

    if (!$active) {
        $out['active'] = false;
    } else {
        $act_p = $arr_polling[$proc_name]['act_polling'];
        $max_p = $arr_polling[$proc_name]['max_polling'];
        $exe_h = $arr_polling[$proc_name]['exec_hour'];
        $to_go_daily = false;
        if ($max_p > 1439) {
            //E' un polling giornaliero
            $to_go_daily = (($exe_h == date('H')) && ($act_p > 61)) ? true : false;
        }

        if (($act_p >= $max_p) || $to_go_daily) {
            //Eseguo il comando e faccio reset
            $out['active'] = true;
            $arr_polling[$proc_name]['act_polling'] = 1;
            $arr_polling[$proc_name]['last_execution'] = date('Y-m-d H:i:s');
        } else {
            //Incremento il numero e restituisco un false
            $out['active'] = false;
            $arr_polling[$proc_name]['act_polling'] = $act_p + 1;
        }
    }
    $out['arr'] = $arr_polling;
    return $out;
}
