<?php

 /**
 * O R T H A N C
 * faccio un DICOM C-FIND
 */

$pacs_di_ricerca = "xxxx";
$url = orthanc_url . "/modalities/$pacs_di_ricerca/query";
$post_fields = '{"Level":"Study","Query":{"AccessionNumber":"' . str_replace("^", "", $accession_number) . '","PatientBirthDate":"","PatientID":"","PatientName":"","PatientSex":"","StudyDate":"","StudyDescription":""}}';

echoo( ">>Inizio STUDIO\ncurl '$url' -X POST --data '$post_fields' " );
$curl = call_orthanc( $url, "GENERIC", TRUE, 'POST', $post_fields, TRUE );
$c_find_result = json_decode($curl);
//echoo( $c_find_result, true, TRUE );


/**
 * 2021-11-10 - SR
 * O R T H A N C
 * /query/xxxxx/answers
 *
 * controllo che il JOB esista ancora e abbia ritornato qualcosa
 */
$url = orthanc_url . "/queries/" . $c_find_result->ID . "/answers";
$curl = call_orthanc( $url, "/queries/xxxx/answers", TRUE, 'GET', null, TRUE );


if( $curl == "[]\n" ){
    $fields = array(
        'dicom_source_fk' => $pacs_di_ricerca,
        'status' => 298,
        'job_id' => "'" . $c_find_result->ID . "'",
        'document_fk' => $document_pk,
        'accession_number' => "'$accession_number'",
        'error' => "'" . pg_escape_string( "IL JOB NON HA TORNATO NULLA! IL DOC. XDS (AN: $accession_number) NON HA IMMAGINI NEL PACS" ) . "'",
        'retrieve_date' => "'" .  date("Y-m-d H:i:s") . "'",
        'notes' => "'$single_event'",
        'curl_response' => "' " . str_replace("'", '"', json_encode($curl) ) . "'"
    );
    $ris = sol_dicom_ins_updt( $document_pk, $accession_number, $fields, "sol_dicom" );

    echoo( "IL JOB NON HA TORNATO NULLA! IL DOC. XDS (AN: $accession_number) NON HA IMMAGINI NEL PACS" );
}
else {
    // 2021-11-10 - SR - ORTHANC ha un JOB OK
    /**
     * O R T H A N C
     * /query/xxxxx/answer
     */
    $url = orthanc_url . "/queries/" . $c_find_result->ID . "/answers/0/content";
    echoo( "curl $url -X GET \n" );
    $curl = call_orthanc( $url, "C-FIND", TRUE, 'GET', null, TRUE );
    echoo( "\n" );

    if( isset($curl["error"]) ){
        // studio NON trovato
        echoo( "STUDIO IN ERRORE!! (1)" );

        $fields = array(
            'dicom_source_fk' => $active_pacs[$dicom_source]["pk"],
            'status' => 299,
            'job_id' => "'" . $c_find_result->ID . "'",
            'document_fk' => $document_pk,
            'accession_number' => "'$accession_number'",
            'error' => "'" . pg_escape_string($curl["error"] . " - ". $curl["descr"]) . "'",
            'retrieve_date' => "'" .  date("Y-m-d H:i:s") . "'",
            'notes' => "'$single_event'  (1)",
            'curl_response' => "' " . str_replace("'", '"', json_encode($curl) ) . "'"
        );
        $ris = sol_dicom_ins_updt( $document_pk, $accession_number, $fields );
    }
    else {
        /*******
         * STUDIO TROVATO
         ******/
        echoo( "STUDIO TROVATO!!" );
        $study_result = json_decode($curl, TRUE );
        //echoo( $study_result, true, TRUE );

        // controllo i valori tornati (paziente, data di nascita ecc) con quello del referto
        $dcm_patient_name = strtoupper($study_result["0010,0010"]["Value"]);
        $dcm_patient_birth_date = str_replace("'", "", dcm_date($study_result["0010,0030"]["Value"]));
        $dcm_patient_sex = $study_result["0010,0040"]["Value"] == 'F' ? "female" : "male";
        $dcm_study_instance_uid = $study_result["0020,000d"]["Value"];

        $dcm_check = strtoupper("$dcm_patient_name <> $dcm_patient_birth_date <> $dcm_patient_sex" );
        $patient_check = strtoupper($get_docs[$y]['surname'] .  "^" . $get_docs[$y]['name'] . " <> " . $get_docs[$y]['dob'] . " <> " . $get_docs[$y]['gender']);

        if ( $dcm_check == $patient_check ){
            // i dati corrispondono quindi OK
            echoo( "STUDIO OK!!  ($dcm_study_instance_uid) \n\n" );

            // ora faccio la C-MOVE
            /*
            $url = orthanc_url . "/modalities/" . $active_pacs[$dicom_source]["server_name"] . "/move";
            $post_fields = '{ "Level":"Study",
                            "Resources" : [
                                {
                                "StudyInstanceUID": "' . $dcm_study_instance_uid . '"
                                }
                            ],
                            "Timeout": 60
                            }';
            echoo( "C-MOVE STUDIO\ncurl '$url' -X POST --data '$post_fields' " );
            */

            /**
             * O R T H A N C
             * VERSIONE RETRIEVE!!
             */
            $url = orthanc_url . "/queries/" . $c_find_result->ID . "/retrieve";
            $post_fields = '{ "Synchronous":false }';

            echoo( "RETRIEVE STUDIO\ncurl '$url' -X POST --data '$post_fields' " );
            $curl = call_orthanc( $url, "RETRIEVE", TRUE, 'POST', $post_fields, TRUE );
            $c_move_result = json_decode( $curl );

            echoo( "c_move_result: <br/>" );
            echoo( $c_move_result, TRUE, TRUE) ;
            echoo( "\n\n" );

            // ora salvo il JOB-ID di ortHanc
            $fields = array(
                'dicom_source_fk' => $active_pacs[$dicom_source]["pk"],
                'status' => 202,
                'document_fk' => $document_pk,
                'accession_number' => "'$accession_number'",
                'job_id' => "'" . $c_move_result->ID . "'",
                'retrieve_date' => "'" .  date("Y-m-d H:i:s") . "'",
                'notes' => "'$single_event'",
                'study_instance_uid' => "'" .trim($dcm_study_instance_uid) . "'",
                'curl_response' => "' " . str_replace("'", '"', json_encode($curl) ) . "'"
            );
            $ris = sol_dicom_ins_updt($document_pk, $accession_number, $fields);
            $sol_dicom_pk = $ris;

            // 2021-11-10 - SR
            $nr_sec = 10;   // 2022-01-17 - SR - messo a 10 sec per dare tempo a orthanc in caso di Paziente nuovo (ci mette di può a gestire il JOB)
            echoo( "ATTENDO $nr_sec sec per dare il tempo ad OrtHanc di elaborare" );
            sleep( $nr_sec );


            // 2022-01-17 - SR - messo in una funzione
            $curl = check_acc_number( $accession_number, $dcm_study_instance_uid );


            /*
                * 2021-11-10 - SR
                * controllare se arriva vuoto, nel qual caso, vuol dire che non riesce a fare il retrieve
                */
            if( $curl == "[]\n" ){
                // non riesce a fare il RETRIEVE
                $sql = "    UPDATE  sol_dicom
                            SET     status = 295,
                                    job_test_repeter = 1
                            WHERE   pk = $sol_dicom_pk";
                $ris = query_execute( $sql );                            
                $dcm_to_check = TRUE;

                echoo( "<div style='color: white; background-color: orange;'>IMPOSSIBILE FARE IL PRIMO RETRIEVE!!  (AccessionNumber: $accession_number) </div>" );
            }
            elseif( isset($curl["error"]) ){
                // ERRORE NELLO STUDIO
                echoo( "<div style='color: white; background-color: red;'>STUDIO IN ERRORE!!  (AN $accession_number)  (2) </div>" );
                $fields = array(
                    'status' => 299,
                    'error' => "'" . pg_escape_string($curl["error"] . " - ". $curl["descr"]) . "'",
                    'retrieve_date' => "'" .  date("Y-m-d H:i:s") . "'",
                    'notes' => "'$single_event' (2)",
                    'curl_response' => "' " . str_replace("'", '"', json_encode($curl) ) . "'"
                );
                $ris = sol_dicom_ins_updt( $sol_dicom_pk, $accession_number, $fields, "sol_dicom" );
            }
            else {
                // STUDIO OK!!
                $c_find_result = json_decode($curl);
                $sql = "    UPDATE  sol_dicom
                            SET     orthanc_id = '" . $c_find_result[0]->ID . "'
                            WHERE   pk = $sol_dicom_pk";
                $ris = query_execute( $sql );
                echoo( $sql );
                echoo( "<div style='color: white; background-color: darkgreen;'>Studio $sol_dicom_pk (AN $accession_number) => SALVATO orthanc_id " . $c_find_result[0]->ID . "</div>" );
            }
            /**** FINE ORTHANC ID ***/

            $c_move = true;   // almeno uno studio e' stato trovato e trasferito
        }
        else {
            echoo( "ERRORE Documento: $document_pk - questo studio è intestato ad un altro paziente!!! ($single_event)" );

            $errore = true;

            $fields = array(
                'dicom_source_fk' => $active_pacs[$dicom_source]["pk"],
                'status' => 297,
                'document_fk' => $document_pk,
                'accession_number' => "'$accession_number'",
                'error' => "'questo studio è intestato ad un altro paziente!!!\n$dcm_check <> $patient_check'",
                'retrieve_date' => "'" .  date("Y-m-d H:i:s") . "'",
                'notes' => "'$single_event'"
            );
            $ris = sol_dicom_ins_updt( $document_pk, $accession_number, $fields );
            continue;
        }
    }
}
echoo( "FINE STUDIO<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\n" );


/**
 * O R T H A N C
 * 2021-08-01 - SR
 * ora cerco l'ORTHANC-ID dello studio
 */
function check_acc_number( $accession_number, $dcm_study_instance_uid ){

    $url = orthanc_url . "/tools/find";

    $post_fields = '
    {
        "Level":"Study",
        "Expand":true,
        "Limit":101,
        "Query":{
            "AccessionNumber": "' . $accession_number . '", "StudyInstanceUID":"' . trim($dcm_study_instance_uid) . '"
        }
    } ';


    echoo( "FIND STUDIO da AccessionNumber + study_istance_id  \ncurl '$url' -X POST --data '$post_fields' " );
    $curl = call_orthanc( $url, "FIND", TRUE, 'POST', $post_fields, TRUE );

    echoo( "c_find_result: <br/>" );
    echoo( $curl, TRUE, TRUE );
    echoo( "\n\n" );

    return $curl;
}



/**
 * funzione che stampa a video (WEB o command line)
 * la stringa passata
 *
 * @param $stringa  string    dati da stampare
 * @param $br       string    se deve essere messo il caporiga (true di default)
 * @param $pre      string    se va aggiunto il tag <pre>
 * @param $exec_as  string    web o cmd  per distinguere se stampo su browser o su riga di comando
 */
function echoo($stringa, $br = true, $pre = false, $exec_as = "web") {

    if(isset($GLOBALS['dbg']) && !$GLOBALS['dbg']){
        // se la variabile globale $GLOBALS['dbg'] è settata e NON è TRUE, allora NON stampo
        return;
    }
  
    if ( $pre ) {
       if ($exec_as == "web") {
           echo "<pre>";
       }
       print_r($stringa);
       if ($exec_as == "web") {
           echo "</pre>";
       }
    }
    else {
       if ($exec_as == "web") {
           $stringa = str_replace("\n", "<br/>", $stringa);
           $stringa = str_replace("\t", "&nbsp&nbsp&nbsp&nbsp&nbsp", $stringa);
       }
       if ($exec_as == "cmd") {
           $stringa = str_replace("<br/>", "\n", $stringa);
           $stringa = str_replace("<br>", "\n", $stringa);
           $stringa = str_replace("<hr/>", "\n----------------------------------------\n", $stringa);
           $stringa = str_replace("<hr>", "\n----------------------------------------\n", $stringa);
       }
       echo $stringa;
    }
    if($br) {
      if ($exec_as == "web") {
        echo "<br/>";
      }
      else {
        echo "\n";
      }
    }
  
    flush();
    ob_flush();
  }

