<?php
/**
 * @copyright Gmed Srl
 * @author Sciarrone Riccardo <riccardos@gmed.it>
 *
 * Programma che recupera UNO studio
 * 
 * passare via argv   orthanc_id (anche più di uno diviso da virgola) e (opzionale) json se si vuole output in json
 * o in GET  id=xxxx (anche più di uno diviso da virgola) e &output=json se si vuole output in json
 */


// Report all errors except E_NOTICE
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


include "./conf/config.inc.php";
include "./include/basic_function.php";
include "./include/dcm_function.php";



if( isset($GLOBALS["db_error"]['default_db']) ){
    echoo("Errore DB: " . $GLOBALS["db_error"]['default_db'] . "\n\n");
}


if ( !isset($argv[1]) && !isset($_GET["id"])) {
    // NULLA DA elaborare
    echoo("NULLA DA ELABORARE \n");
}


$param = isset($argv[1]) ? $argv[1] : $_GET["id"];
$jsn = isset($argv[2]) ? $argv[2] : 
                isset($_GET["output"]) ? $_GET["output"] : "array";

$studies = explode(",", $param);
echoo("studi da ricercare: \t\t");
echoo($studies, TRUE);


// Elaboro tutti gli studi arrivati
foreach ($studies as $study_id) {
    echoo("Elaboro $study_id \n");

    $study = retrieve_single_study($study_id);

    if( isset($study["error"]) ){
        // non è tornato nullo
        echoo("ERRORE " . $study["error"] . " - " .$study["descr"] . "\n\n");
    }
    else {
        // trovato
        if( $jsn == "json"){
            echoo(json_encode($study), TRUE);
        }
        else {
            echoo($study, TRUE);
        }
    }
    
    echoo("<hr/>\n\n");
}


echoo("\nFINE\n");



