# ************************************************************
# Sequel Pro SQL dump
# Version (null)
#
# https://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 127.0.0.1 (MySQL 8.0.30-22)
# Database: VIRTUHIS_MASTER
# Generation Time: 2023-06-26 10:49:58 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
SET NAMES utf8mb4;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table ADMISSIONS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ADMISSIONS`;

CREATE TABLE `ADMISSIONS` (
  `ADMISSION_ID` int NOT NULL AUTO_INCREMENT,
  `PATIENT_CLASS` int DEFAULT NULL,
  `ASSIGNED_PATIENT_LOCATION` int DEFAULT NULL,
  `POINT_OF_CARE` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `ROOM` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `BED` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `FACILITY` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `BED_STATUS` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `PREADMIT_NUMBER` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `IDPATIENT` int NOT NULL DEFAULT '0',
  `AMBULATORY_STATUS` varchar(2) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `VISIT_NUMBER` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DISCHARGE_DATE` datetime DEFAULT NULL,
  `ATTENDING_DOCTOR` varchar(80) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '0',
  `TRANSACTION_DATE` datetime DEFAULT NULL,
  `REFERRING_DOCTOR` varchar(80) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `CONSULTING_DOCTOR` varchar(60) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `IDWARD` int DEFAULT NULL,
  `IDUNIT` int NOT NULL DEFAULT '1',
  `ENTERING_ORGANIZATION` varchar(250) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `ADMITTING_DOCTOR` varchar(80) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `PATIENT_ACCOUNT_NUMBER` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`ADMISSION_ID`),
  KEY `IDPATIENT` (`IDPATIENT`) USING BTREE,
  KEY `IDWARD` (`IDWARD`) USING BTREE,
  KEY `IDUNIT` (`IDUNIT`) USING BTREE,
  KEY `VISIT_NUMBER` (`VISIT_NUMBER`) USING BTREE,
  KEY `PATIENT_CLASS` (`PATIENT_CLASS`) USING BTREE,
  KEY `PATIENT_LOCATION` (`ASSIGNED_PATIENT_LOCATION`) USING BTREE,
  CONSTRAINT `ADMISSIONS_ibfk_1` FOREIGN KEY (`IDPATIENT`) REFERENCES `PATIENT` (`IDPATIENT`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ADMISSIONS_ibfk_2` FOREIGN KEY (`PATIENT_CLASS`) REFERENCES `PATIENT_CLASS` (`ID_PATIENT_CLASS`),
  CONSTRAINT `ADMISSIONS_ibfk_3` FOREIGN KEY (`IDWARD`) REFERENCES `WARDS` (`IDWARD`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `ADMISSIONS_ibfk_4` FOREIGN KEY (`IDUNIT`) REFERENCES `UNIT` (`IDUNIT`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci PACK_KEYS=0 ROW_FORMAT=COMPACT;

LOCK TABLES `ADMISSIONS` WRITE;
/*!40000 ALTER TABLE `ADMISSIONS` DISABLE KEYS */;

INSERT INTO `ADMISSIONS` (`ADMISSION_ID`, `PATIENT_CLASS`, `ASSIGNED_PATIENT_LOCATION`, `POINT_OF_CARE`, `ROOM`, `BED`, `FACILITY`, `BED_STATUS`, `PREADMIT_NUMBER`, `IDPATIENT`, `AMBULATORY_STATUS`, `VISIT_NUMBER`, `DISCHARGE_DATE`, `ATTENDING_DOCTOR`, `TRANSACTION_DATE`, `REFERRING_DOCTOR`, `CONSULTING_DOCTOR`, `IDWARD`, `IDUNIT`, `ENTERING_ORGANIZATION`, `ADMITTING_DOCTOR`, `PATIENT_ACCOUNT_NUMBER`)
VALUES
	(0,6,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0',NULL,NULL,NULL,0,1,NULL,NULL,NULL),
	(1,1,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0',NULL,NULL,NULL,0,1,NULL,NULL,NULL),
	(2,2,101,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,'0',NULL,NULL,NULL,0,1,NULL,NULL,NULL),
	(3,3,102,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,NULL,'0',NULL,NULL,NULL,0,1,NULL,NULL,NULL);

/*!40000 ALTER TABLE `ADMISSIONS` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table AFFINITY_DOMAIN
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AFFINITY_DOMAIN`;

CREATE TABLE `AFFINITY_DOMAIN` (
  `IDAFFINITY` int NOT NULL AUTO_INCREMENT,
  `CODE` varchar(50) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DISPLAY` varchar(128) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `CODING_SCHEME` varchar(128) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`IDAFFINITY`) USING BTREE,
  UNIQUE KEY `CODE` (`CODE`,`CODING_SCHEME`) USING BTREE,
  KEY `IDAFFINITY` (`IDAFFINITY`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AGENDA
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AGENDA`;

CREATE TABLE `AGENDA` (
  `IDAGENDA` int NOT NULL AUTO_INCREMENT,
  `IDFILLER` int NOT NULL DEFAULT '0',
  `DATE` date NOT NULL DEFAULT '1000-01-01',
  `IDROOM` int NOT NULL DEFAULT '0',
  `TYPE` int NOT NULL DEFAULT '0',
  `A_TIME` time NOT NULL DEFAULT '00:00:00',
  `REF_PHIS` int NOT NULL DEFAULT '0',
  `REF_NURSE` int NOT NULL DEFAULT '0',
  `REF_TECH` int NOT NULL DEFAULT '0',
  `REF_SPEC_1` int NOT NULL DEFAULT '0',
  `REF_SPEC_2` int NOT NULL DEFAULT '0',
  `REF_SPEC_3` int NOT NULL DEFAULT '0',
  `DURATION` int NOT NULL DEFAULT '0',
  `E_TIME` time NOT NULL DEFAULT '00:00:00',
  `LOCK_NOTE` varchar(256) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`IDAGENDA`),
  KEY `TYPE` (`TYPE`) USING BTREE,
  KEY `DATE` (`DATE`) USING BTREE,
  KEY `IDROOM` (`IDROOM`) USING BTREE,
  KEY `IDFILLER` (`IDFILLER`) USING BTREE,
  KEY `A_TIME` (`A_TIME`) USING BTREE,
  KEY `REF_PHIS` (`REF_PHIS`),
  KEY `REF_TECH` (`REF_TECH`),
  KEY `REF_SPEC_1` (`REF_SPEC_1`),
  KEY `REF_SPEC_2` (`REF_SPEC_2`),
  KEY `REF_SPEC_3` (`REF_SPEC_3`),
  CONSTRAINT `AGENDA_ibfk_10` FOREIGN KEY (`IDFILLER`) REFERENCES `FILLERS` (`IDFILLER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_2` FOREIGN KEY (`IDROOM`) REFERENCES `ROOM` (`IDROOM`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_4` FOREIGN KEY (`REF_PHIS`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_5` FOREIGN KEY (`REF_TECH`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_6` FOREIGN KEY (`REF_SPEC_1`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_7` FOREIGN KEY (`REF_SPEC_2`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDA_ibfk_8` FOREIGN KEY (`REF_SPEC_3`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci ROW_FORMAT=COMPACT COMMENT='AGENDE DIAGNOSTICHE';



# Dump of table AGENDE_AREE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AGENDE_AREE`;

CREATE TABLE `AGENDE_AREE` (
  `IDAGENDA` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `IDAREA` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`IDAGENDA`,`IDAREA`) USING BTREE,
  KEY `IDAREA` (`IDAREA`),
  CONSTRAINT `AGENDE_AREE_ibfk_2` FOREIGN KEY (`IDAREA`) REFERENCES `AREE` (`IDAREA`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AGENDE_ROOMS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AGENDE_ROOMS`;

CREATE TABLE `AGENDE_ROOMS` (
  `IDAGENDA` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `IDROOM` int NOT NULL DEFAULT '0',
  `URGENZA` char(1) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `ASSIGNED_USER` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`IDAGENDA`,`IDROOM`) USING BTREE,
  KEY `IDROOM` (`IDROOM`),
  KEY `ASSIGNED_USER` (`ASSIGNED_USER`),
  KEY `IDAGENDA` (`IDAGENDA`) USING BTREE,
  CONSTRAINT `AGENDE_ROOMS_ibfk_2` FOREIGN KEY (`IDROOM`) REFERENCES `ROOM` (`IDROOM`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AGENDE_ROOMS_ibfk_3` FOREIGN KEY (`ASSIGNED_USER`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

LOCK TABLES `AGENDE_ROOMS` WRITE;
/*!40000 ALTER TABLE `AGENDE_ROOMS` DISABLE KEYS */;

INSERT INTO `AGENDE_ROOMS` (`IDAGENDA`, `IDROOM`, `URGENZA`, `ASSIGNED_USER`)
VALUES
	('0',0,NULL,0),
	('IMPORT_DCM',99,NULL,0);

/*!40000 ALTER TABLE `AGENDE_ROOMS` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table AREE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AREE`;

CREATE TABLE `AREE` (
  `IDAREA` int NOT NULL AUTO_INCREMENT,
  `SMALL_DESCR` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DESCRIPTION` varchar(100) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `STATUS` char(1) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT 'N',
  `NOTE` varchar(250) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `COLOR` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '#000000',
  `COD_EXT` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT '',
  PRIMARY KEY (`IDAREA`) USING BTREE,
  KEY `COD_AGENDA` (`COD_EXT`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

LOCK TABLES `AREE` WRITE;
/*!40000 ALTER TABLE `AREE` DISABLE KEYS */;

INSERT INTO `AREE` (`IDAREA`, `SMALL_DESCR`, `DESCRIPTION`, `STATUS`, `NOTE`, `COLOR`, `COD_EXT`)
VALUES
	(99,'IMPORT_DCM','Import studi esterni','N',NULL,'#000000','IMPORT_DCM');

/*!40000 ALTER TABLE `AREE` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table AREE_LANG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AREE_LANG`;

CREATE TABLE `AREE_LANG` (
  `PK` int NOT NULL AUTO_INCREMENT,
  `IDAREA` int NOT NULL,
  `LANG_FK` int NOT NULL,
  `SMALL_DESCR` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DESCRIPTION` varchar(100) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`PK`),
  UNIQUE KEY `AREE_LANG_UN` (`IDAREA`,`LANG_FK`),
  KEY `AREE_LANG_FK_1` (`IDAREA`),
  KEY `AREE_LANG_FK_2` (`LANG_FK`),
  CONSTRAINT `AREE_LANG_FK_1` FOREIGN KEY (`IDAREA`) REFERENCES `AREE` (`IDAREA`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AREE_LANG_FK_2` FOREIGN KEY (`LANG_FK`) REFERENCES `LANGUAGES` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AREE_UNITS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AREE_UNITS`;

CREATE TABLE `AREE_UNITS` (
  `IDAREA` int NOT NULL,
  `IDUNIT` int NOT NULL,
  PRIMARY KEY (`IDAREA`,`IDUNIT`) USING BTREE,
  KEY `IDUNIT` (`IDUNIT`),
  CONSTRAINT `AREE_UNITS_ibfk_1` FOREIGN KEY (`IDAREA`) REFERENCES `AREE` (`IDAREA`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AREE_UNITS_ibfk_2` FOREIGN KEY (`IDUNIT`) REFERENCES `UNIT` (`IDUNIT`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AUDIT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT`;

CREATE TABLE `AUDIT` (
  `IDAUDIT` int NOT NULL AUTO_INCREMENT,
  `DATETIME` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `DESCRIPTION` varchar(250) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `USER` int NOT NULL DEFAULT '0',
  `TYPE` char(2) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `IDORDER` int NOT NULL DEFAULT '0',
  `COD_EVENT` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DESCRIPTION_CODE` int DEFAULT NULL,
  `OPTIONAL_DESC_DATA` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`IDAUDIT`),
  KEY `IDORDER` (`IDORDER`) USING BTREE,
  KEY `TYPE` (`TYPE`) USING BTREE,
  KEY `USER` (`USER`) USING BTREE,
  KEY `COD_EVENT` (`COD_EVENT`),
  KEY `AUDIT_FK` (`DESCRIPTION_CODE`),
  CONSTRAINT `AUDIT_FK` FOREIGN KEY (`DESCRIPTION_CODE`) REFERENCES `AUDIT_LIST` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_ibfk_1` FOREIGN KEY (`USER`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_ibfk_3` FOREIGN KEY (`COD_EVENT`) REFERENCES `EVENT` (`COD_EVENT`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_ibfk_4` FOREIGN KEY (`TYPE`) REFERENCES `AUDIT_CATEGORY` (`type`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_ibfk_5` FOREIGN KEY (`IDORDER`) REFERENCES `ORDERS` (`IDORDER`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci ROW_FORMAT=COMPACT;



# Dump of table AUDIT_CATEGORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT_CATEGORY`;

CREATE TABLE `AUDIT_CATEGORY` (
  `pk` int NOT NULL AUTO_INCREMENT,
  `type` char(2) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `cat` varchar(5) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `label` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `description` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`pk`) USING BTREE,
  UNIQUE KEY `type` (`type`,`cat`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

LOCK TABLES `AUDIT_CATEGORY` WRITE;
/*!40000 ALTER TABLE `AUDIT_CATEGORY` DISABLE KEYS */;

INSERT INTO `AUDIT_CATEGORY` (`pk`, `type`, `cat`, `label`, `description`)
VALUES
	(1,'AC','OPE','Acc.Studio','Accettazione studio da operatore'),
	(2,'AC','ADM','Acc.Studio','Accettazione studio da amministratore di sistema'),
	(3,'AC','SYS','Acc.Studio','Accettazione studio da integrazione'),
	(4,'AE','OPE','Acc.Esame','Accettazione esame da operatore'),
	(5,'AE','ADM','Acc.Esame','Accettazione esame da amministratore di sistema'),
	(6,'AE','SYS','Acc.Esame','Accettazione esame da integrazione'),
	(7,'AF','OPE','Ann.Fatt.','Annullamento fattura da operatore'),
	(8,'AF','ADM','Ann.Fatt.','Annullamento fattura da amministratore di sistema'),
	(9,'AF','SYS','Ann.Fatt.','Annullamento fatura da integrazione'),
	(10,'CA','OPE','Can.Studio','Eliminato studio da operatore'),
	(11,'CA','ADM','Can.Studio','Eliminato studio da amministratore di sistema'),
	(12,'CA','SYS','Can.Studio','Eliminato studio da integrazione'),
	(13,'CC','OPE','CreaCD','Creazione CD Paziente da operatore'),
	(14,'CC','ADM','CreaCD','Creazione CD Paziente da amministratore di sistema'),
	(15,'CC','SYS','CreaCD','Creazione CD Paziente da integrazione'),
	(16,'CD','OPE','Cons.CD','Consegnato CD da operatore'),
	(17,'CD','ADM','Cons.CD','Consegnato CD da amministratore di sistema'),
	(18,'CD','SYS','Cons.CD','Consegnato CD da integrazione'),
	(19,'CE','OPE','Can.Esame','Cancellato esame da operatore'),
	(20,'CE','ADM','Can.Esame','Cancellato esame da amministratore di sistema'),
	(21,'CE','SYS','Can.Esame','Cancellato esame da integrazione'),
	(22,'CF','OPE','CreaFAT','Creazione fattura da operatore'),
	(23,'CF','ADM','CreaFAT','Creazione fattura da amministratore di sistema'),
	(24,'CF','SYS','CreaFAT','Creazione fattura da integrazione'),
	(25,'CR','OPE','Camb.REF','Modifica assegnazione referto da operatore'),
	(27,'CR','ADM','Camb.REF','Modifica assegnazione referto da amministratore di sistema'),
	(28,'CR','SYS','Camb.REF','Modifica assegnazione referto da integrazione'),
	(29,'ER','OPE','Ese.Med.','Studio eseguito direttamente da personale medico'),
	(30,'ER','ADM','Ese.Med.','Studio eseguito direttamente da personale medico '),
	(31,'ER','SYS','Ese.Med.','Studio eseguito direttamente da personale medico '),
	(32,'EX','OPE','Ese.Studio','Eseguita procedura da operatore'),
	(33,'EX','ADM','Ese.Studio','Eseguita procedura da amministratore di sistema'),
	(34,'EX','SYS','Ese.Studio','Eseguita procedura da integrazione'),
	(35,'FM','OPE','Fir.Ref.','Firma del referto da operatore'),
	(36,'FM','ADM','Fir.Ref.','Firma del referto da amministratore di sistema'),
	(37,'FM','SYS','Fir.Ref.','Firma del referto da integrazione'),
	(38,'FR','OPE','Fir.Dig.','Firma digitale del referto da operatore'),
	(39,'FR','ADM','Fir.Dig.','Firma digitale del referto da amministratore di sistema'),
	(40,'FR','SYS','Fir.Dig.','Firma digitale del referto da integrazione'),
	(41,'IM','OPE','Import','Import da storico'),
	(42,'IM','ADM','Import','Import da storico'),
	(43,'IM','SYS','Import','Import da storico'),
	(44,'IN','OPE','Ins.Rich.','Inserimento richiesta da operatore'),
	(45,'IN','ADM','Ins.Rich.','Inserimento richiesta da amministratore di sistema'),
	(46,'IN','SYS','Ins.Rich.','Inserimento richiesta da integrazione'),
	(47,'MG','OPE','Merge','Merge da operatore - Studio proveniente da fusione '),
	(48,'MG','ADM','Merge','Merge da amministratore - Studio proveniente da fusione '),
	(49,'MG','SYS','Merge','Merge da integrazione - Studio proveniente da fusione '),
	(50,'MO','OPE','Mod.Proc.','Modifica procedura da operatore'),
	(51,'MO','ADM','Mod.Proc.','Modifica procedura da amministratore di sistema'),
	(52,'MO','SYS','Mod.Proc.','Modifica procedura da integrazione'),
	(53,'MR','OPE','Sbl.Refer.','Sblocco referto da operatore'),
	(54,'MR','ADM','Sbl.Refer.','Sblocco referto da amministratore di sistema'),
	(55,'MR','SYS','Sbl.Refer.','Sblocco referto da integrazione'),
	(56,'NR','OPE','Mod.Note','Modifica note medico refertante'),
	(57,'NR','ADM','Mod.Note','Modifica note medico refertante da amministratore di sistema'),
	(58,'NR','SYS','Mod.Note','Modifica note medico refertante'),
	(59,'NT','OPE','Ins.Nota','Inserita nota slot id agenda'),
	(60,'NT','ADM','Ins.Nota','Inserita nota slot id agenda'),
	(61,'NT','SYS','Ins.Nota','Inserita nota slot id agenda'),
	(62,'PP','OPE','Pre.Esame','Prenotazione esame da operatore'),
	(63,'PP','ADM','Pre.Esame','Prenotazione esame da amministratore di sistema'),
	(64,'PP','SYS','Pre.Esame','Prenotazione esame da integrazione'),
	(65,'PR','OPE','Con.Priv.','Raccolta privacy da operatore'),
	(66,'PR','ADM','Con.Priv.','Raccolta privacy da amministratore di sistema'),
	(67,'PR','SYS','Con.Priv.','Raccolta privacy da integrazione'),
	(68,'UL','OPE','Login','Login Utente'),
	(69,'RQ','OPE','Rich.Esa.','Richiesta esame da operatore'),
	(70,'RQ','ADM','Rich.Esa.','Richiesta esame da amministratore di sistema'),
	(72,'RQ','SYS','Rich.Esa.','Richiesta esame da integrazione'),
	(73,'UL','ADM','Login','Login Utente amministratore'),
	(74,'UL','SYS','Login','Login Utente da integrazione'),
	(75,'SP','OPE','Spre.Stu.','Sprenotato ordine da operatore'),
	(76,'SP','ADM','Spre.Stu.','Sprenotato ordine da amministratore'),
	(77,'SP','SYS','Spre.Stu.','Sprenotato ordine da integrazione'),
	(78,'SS','OPE','Stu.Spost.','Studi spostato da operatore da sala'),
	(79,'SS','ADM','Stu.Spost.','Studi spostato da amministratore di sistema da sala'),
	(80,'SS','SYS','Stu.Spost.','Studi spostato da integrazione da sala'),
	(81,'UI','OPE','Esa.Proven','Esame proveniente da altro RIS in stato non definitivo'),
	(82,'UI','ADM','Esa.Proven','Esame proveniente da altro RIS in stato non definitivo'),
	(83,'UI','SYS','Esa.Proven','Esame proveniente da altro RIS in stato non definitivo'),
	(84,'UP','OPE','Mod.Ord.','Modifica ordine da operatore'),
	(85,'UP','ADM','Mod.Ord.','Modifica ordine da amministratore di sistema'),
	(86,'UP','SYS','Mod.Ord.','Modifica ordine da integrazione'),
	(87,'UR','OPE','Sal.Ref.','Salvataggio referto da operatore'),
	(88,'UR','ADM','Sal.Ref.','Salvataggio referto da amministratore di sistema'),
	(89,'UR','SYS','Sal.Ref.','Salvataggio referto da integrazione'),
	(90,'XD','OPE','Canc.Doc.','Cancellazione documento da operatore'),
	(91,'XD','ADM','Canc.Doc.','Cancellazione documento da amministratore di sistema'),
	(92,'XD','SYS','Canc.Doc.','Cancellazione documento da integrazione'),
	(93,'XN','OPE','Ins.Doc','Inserimento documento da operatore'),
	(94,'XN','ADM','Ins.Doc','Inserimento documento da amministratore di sistema'),
	(95,'XN','SYS','Ins.Doc','Inserimento documento da integrazione'),
	(96,'SI','OPE','Ind.Amm.','Indagine amministratore di sistema in corso'),
	(97,'SI','ADM','Ind.Amm.','Indagine amministratore di sistema in corso'),
	(98,'SI','SYS','Ind.Amm.','Indagine amministratore di sistema in corso'),
	(99,'VI','OPE','Vis.Imm.','Visualizzazione immagini da operatore'),
	(100,'VI','ADM','Vis.Imm.','Visualizzazione immagini da amministratore di sistema'),
	(101,'VI','SYS','Vis.Imm.','Visualizzazione immagini da integrazione'),
	(102,'VR','OPE','Vis.Ref.','Visualizzazione referto da operatore'),
	(103,'VR','ADM','Vis.Ref.','Visualizzazione referto da amministratore di sistema'),
	(104,'VR','SYS','Vis.Ref.','Visualizzazione referto da integrazione'),
	(105,'LO','OPE','Logout','Logout utente'),
	(106,'LO','ADM','Logout','Logout utente'),
	(107,'LO','SYS','Logout','Logout utente'),
	(108,'VP','OPE','Vis.Paz.','Visualizzazione anagrafica paziente'),
	(109,'VP','ADM','Vis.Paz.','Visualizzazione anagrafica paziente'),
	(110,'VP','SYS','Vis.Paz.','Visualizzazione anagrafica paziente'),
	(111,'MP','OPE','Mod.Paz.','Modifica anagrafica paziente'),
	(112,'MP','ADM','Mod.Paz.','Modifica anagrafica paziente'),
	(113,'MP','SYS','Mod.Paz.','Modifica anagrafica paziente'),
	(114,'VE','OPE','Vis.Esa','Visualizzazione elenco esami paziente'),
	(115,'VE','ADM','Vis.Esa','Visualizzazione elenco esami paziente'),
	(116,'VE','SYS','Vis.Esa','Visualizzazione elenco esami paziente'),
	(117,'VD','OPE','Vis.Dett.','Vsualizzazione dettagli studio'),
	(118,'VD','ADM','Vis.Dett.','Vsualizzazione dettagli studio'),
	(119,'VD','SYS','Vis.Dett.','Vsualizzazione dettagli studio'),
	(120,'LE','OPE','Log.Err.','Login errato'),
	(121,'LE','ADM','Log.Err.','Login errato'),
	(122,'LE','SYS','Log.Err.','Login errato'),
	(123,'UM','OPE','UserMan.','Visualizzazione gestione utenti'),
	(124,'UM','ADM','UserMan.','Visualizzazione gestione utenti'),
	(125,'UM','SYS','UserMan.','Visualizzazione gestione utenti'),
	(126,'GM','OPE','GroupMan.','Modificato privilegi gruppi utenti'),
	(127,'GM','ADM','GroupMan.','Modificato privilegi gruppi utenti'),
	(128,'GM','SYS','GroupMan.','Modificato privilegi gruppi utenti'),
	(130,'PM','OPE','Mod.Post.','Modifica Postazione'),
	(131,'PM','ADM','Mod.Post.','Modifica Postazione'),
	(132,'PM','SYS','Mod.Post.','Modifica Postazione'),
	(133,'IP','OPE','Ins.Post.','Inserimento nuova postazione'),
	(134,'IP','ADM','Ins.Post.','Inserimento nuova postazione'),
	(135,'IP','SYS','Ins.Post.','Inserimento nuova postazione'),
	(137,'MF','OPE','Conf.Stam.','Configurazione stampanti su postazione'),
	(138,'MF','ADM','Conf.Stam.','Configurazione stampanti su postazione'),
	(139,'MF','SYS','Conf.Stam.','Configurazione stampanti su postazione'),
	(140,'MS','OPE','Mod.Stamp.','Modificato configurazione stampante'),
	(141,'MS','ADM','Mod.Stamp.','Modificato configurazione stampante'),
	(142,'MS','SYS','Mod.Stamp.','Modificato configurazione stampante'),
	(143,'IS','OPE','Ins.Stamp.','Inserimento stampante'),
	(144,'IS','ADM','Ins.Stamp.','Inserimento stampante'),
	(145,'IS','SYS','Ins.Stamp.','Inserimento stampante'),
	(146,'MD','OPE','Mod.Sala','Modifica sala diagnostica'),
	(147,'MD','ADM','Mod.Sala','Modifica sala diagnostica'),
	(148,'MD','SYS','Mod.Sala','Modifica sala diagnostica'),
	(149,'ID','OPE','Ins.Sala','Inserimento sala diagnostica'),
	(150,'ID','ADM','Ins.Sala','Inserimento sala diagnostica'),
	(151,'ID','SYS','Ins.Sala','Inserimento sala diagnostica'),
	(152,'MM','OPE','Mod.Moda.','Modifica macchina'),
	(153,'MM','ADM','Mod.Moda.','Modifica macchina'),
	(154,'MM','SYS','Mod.Moda.','Modifica macchina'),
	(155,'AM','OPE','Ins.Moda.','Inserimento macchina'),
	(156,'AM','ADM','Ins.Moda.','Inserimento macchina'),
	(157,'AM','SYS','Ins.Moda.','Inserimento macchina'),
	(158,'CM','OPE','Canc.Moda.','Cancellazione macchina'),
	(159,'CM','ADM','Canc.Moda.','Cancellazione macchina'),
	(160,'CM','SYS','Canc.Moda.','Cancellazione macchina'),
	(161,'WM','OPE','Work.Moda.','Configurazione lista di lavoro macchina'),
	(162,'WM','ADM','Work.Moda.','Configurazione lista di lavoro macchina'),
	(163,'WM','SYS','Work.Moda.','Configurazione lista di lavoro macchina'),
	(164,'NE','OPE','Ins.Esame','Inserimento nuovo esame'),
	(165,'NE','ADM','Ins.Esame','Inserimento nuovo esame'),
	(166,'NE','SYS','Ins.Esame','Inserimento nuovo esame'),
	(167,'AV','OPE','Ass.CDC','Associazione CDC all\'esame'),
	(168,'AV','ADM','Ass.CDC','Associazione CDC all\'esame'),
	(169,'AV','SYS','Ass.CDC','Associazione CDC all\'esame'),
	(170,'ME','OPE','Mod.Esame','Modifica parametri esame'),
	(171,'ME','ADM','Mod.Esame','Modifica parametri esame'),
	(172,'ME','SYS','Mod.Esame','Modifica parametri esame'),
	(173,'EE','OPE','Canc.Esame','Cancellazione esame'),
	(174,'EE','ADM','Canc.Esame','Cancellazione esame'),
	(175,'EE','SYS','Canc.Esame','Cancellazione esame'),
	(176,'IW','OPE','Ins.Prov.','Inserimento nuova provenienza'),
	(177,'IW','ADM','Ins.Prov.','Inserimento nuova provenienza'),
	(178,'IW','SYS','Ins.Prov.','Inserimento nuova provenienza'),
	(179,'MW','OPE','Mod.Prov.','Modifica provenienza'),
	(180,'MW','ADM','Mod.Prov.','Modifica provenienza'),
	(181,'MW','SYS','Mod.Prov.','Modifica provenienza'),
	(182,'IA','OPE','Ins.Area','Inserimento nuova area'),
	(183,'IA','ADM','Ins.Area','Inserimento nuova area'),
	(184,'IA','SYS','Ins.Area','Inserimento nuova area'),
	(185,'MA','OPE','Mod.Area','Modifica parametri area'),
	(186,'MA','ADM','Mod.Area','Modifica parametri area'),
	(187,'MA','SYS','Mod.Area','Modifica parametri area'),
	(188,'EA','OPE','Canc.Area','Cancellazione area'),
	(189,'EA','ADM','Canc.Area','Cancellazione area'),
	(190,'EA','SYS','Canc.Area','Cancellazione area'),
	(192,'AP','OPE','Ins.Maga','Inserito nuovo materiale/pacchetto'),
	(193,'AP','ADM','Ins.Maga','Inserito nuovo materiale/pacchetto'),
	(194,'AP','SYS','Ins.Maga','Inserito nuovo materiale/pacchetto'),
	(198,'AW','OPE','Mod.Maga','Modifica materiale/pacchetto'),
	(199,'AW','ADM','Mod.Maga','Modifica materiale/pacchetto'),
	(200,'AW','SYS','Mod.Maga','Modifica materiale/pacchetto'),
	(201,'ST','OPE','Acc.Stat.','Accesso modulo statistiche'),
	(202,'ST','ADM','Acc.Stat.','Accesso modulo statistiche'),
	(203,'ST','SYS','Acc.Stat.','Accesso modulo statistiche'),
	(205,'RE','OPE','Ins.Reg.','Inserita regola di stampa/masterizzazione'),
	(206,'RE','ADM','Ins.Reg.','Inserita regola di stampa/masterizzazione'),
	(207,'RE','SYS','Ins.Reg.','Inserita regola di stampa/masterizzazione'),
	(208,'RM','OPE','Mod.Reg.','Modificata regola di stampa/masterizzazione'),
	(209,'RM','ADM','Mod.Reg.','Modificata regola di stampa/masterizzazione'),
	(210,'RM','SYS','Mod.Reg.','Modificata regola di stampa/masterizzazione'),
	(211,'OA','OPE','Ord. Att.','Ordine Attivo'),
	(212,'OS','OPE','Ord. Sosp.','Ordine Sospeso'),
	(213,'OA','ADM','Ord. Att.','Ordine Attivo'),
	(214,'OS','ADM','Ord. Sosp.','Ordine Sospeso'),
	(216,'OA','SYS','Ord. Att.','Ordine Attivo'),
	(217,'OS','SYS','Ord. Sosp.','Ordine Sospeso'),
	(218,'OE','SYS','**Da Def ','** Da Definire  **'),
	(219,'OE','ADM','**Da Def ','** Da Definire  **'),
	(220,'OE','OPE','**Da Def ','** Da Definire  **'),
	(221,'WP','SYS','WrongPat','WrongPatient'),
	(222,'WP','ADM','WrongPat','WrongPatient'),
	(223,'WP','OPE','WrongPat','WrongPatient'),
	(224,'AX','SYS','CancStudio','Studio Cancellato da processo automatico'),
	(225,'AX','ADM','CancStudio','Studio Cancellato da processo automatico'),
	(226,'AX','OPE','CancStudio','Studio Cancellato da processo automatico'),
	(230,'NU','SYS','NewUser','Nuovo Utente'),
	(231,'NU','ADM','NewUser','Nuovo Utente'),
	(232,'NU','OPE','NewUser','Nuovo Utente');

/*!40000 ALTER TABLE `AUDIT_CATEGORY` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table AUDIT_LANG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT_LANG`;

CREATE TABLE `AUDIT_LANG` (
  `PK` int NOT NULL AUTO_INCREMENT,
  `AUDIT_ID` int NOT NULL,
  `LANG_FK` int NOT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`PK`),
  UNIQUE KEY `AUDIT_LANG_UN` (`AUDIT_ID`,`LANG_FK`),
  KEY `AUDIT_LANG_FK_1` (`AUDIT_ID`),
  KEY `AUDIT_LANG_FK_2` (`LANG_FK`),
  CONSTRAINT `AUDIT_LANG_FK_1` FOREIGN KEY (`AUDIT_ID`) REFERENCES `AUDIT_LIST` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_LANG_FK_2` FOREIGN KEY (`LANG_FK`) REFERENCES `LANGUAGES` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AUDIT_LIST
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT_LIST`;

CREATE TABLE `AUDIT_LIST` (
  `PK` int NOT NULL AUTO_INCREMENT,
  `CODE` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DESCR_DEFAULT` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`PK`),
  UNIQUE KEY `AUDIT_LIST_UN` (`CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

LOCK TABLES `AUDIT_LIST` WRITE;
/*!40000 ALTER TABLE `AUDIT_LIST` DISABLE KEYS */;

INSERT INTO `AUDIT_LIST` (`PK`, `CODE`, `DESCR_DEFAULT`)
VALUES
	(62,'DEL_AG_NOTE','Eliminazione nota da Agenda'),
	(63,'INS_AG_NOTE','Inserimento nota in Agenda'),
	(64,'DEL_AG_STUD','Eliminazione studio da Agenda'),
	(65,'DEL_PREN','Cancellazione prenotazione'),
	(66,'AG_PREN','Prenotazione esame da Agenda'),
	(67,'REP_RETR_KO','Fallito recupero referto da repository'),
	(68,'REP_RETR_OK','Referto correttamente verificato su repository'),
	(69,'STUD_STAT_CHG','Studio posto in stato'),
	(70,'ACC_STUD','Accettazione studio'),
	(71,'CANC_ORD','Ordine cancellato'),
	(72,'EXE_STUD','Studio eseguito'),
	(73,'PREN_STUD','Studio prenotato'),
	(74,'REP_STUD','Esame refertato'),
	(75,'PRIV_CONS','Raccolta consenso sulla privacy'),
	(76,'MD_NOTE_INS','Inserimento Note del Medico Refertante'),
	(77,'MD_NOTE_MOD','Modifica Note del Medico Refertante'),
	(78,'CD_CREAT','Creazione CD'),
	(79,'CD_DELIV','Consegna CD'),
	(80,'EXE_PROC','Eseguita procedura'),
	(81,'EXE_PROC_SCR','Eseguita procedura screening'),
	(82,'EXAM_INS','Inserita riga esame'),
	(83,'MOD_PROC','Modifica procedura'),
	(84,'EXAM_DEL','Eliminata riga esame'),
	(85,'DEL_STUD','Eliminazione studio'),
	(86,'STUD_MERGE','Studio in lista dopo fusione pazienti'),
	(87,'EXAM_PREN','Prenotazione esame'),
	(88,'EXAM_REQ','Richiesta esame'),
	(89,'CD_AUTO','Masterizzazione automatica'),
	(90,'SIGN_DIG_REP','Firma digitale referto'),
	(91,'MAN_SIGN_REP','Firma manuale referto'),
	(92,'UNLCK_REP','Sblocco referto'),
	(93,'TSRM_NOTE_MOD','Modifica Note Tecnico'),
	(94,'EXE_STUDY_MD','Studio eseguito direttamente da personale medico'),
	(95,'UNLCK_REP_FORC','Forzato sblocco refertazione'),
	(96,'REP_ASS_CHNG','Cambio assegnazione referto'),
	(97,'REP_ASS_SIGN','Assegnazione referto contestuale a Firma digitale'),
	(98,'NEW_REP_ANN','Creazione nuovo referto annullativo'),
	(99,'ORD_UPD','Aggiornamento ordine'),
	(100,'PPSM_INS','Inserimento ordine da PPSM'),
	(101,'MPPS_CREATE','MPPS N-CREATE'),
	(102,'MPPS_SET','MPPS N-SET'),
	(103,'PRNT_DEL_OVER','Stampa annullata per override'),
	(104,'NEW_EXT_DOC','Nuovo documento da sistema esterno'),
	(105,'EXAM_REQ_SU','Richiesta esame - forzato da super utente'),
	(106,'EXAM_PREN_SU','Prenotazione esame - forzato da super utente'),
	(107,'EXAM_ACC_SU','Accettazione esame - forzato da super utente'),
	(108,'EXAM_EXE_SU','Eseguita procedura - forzato da super utente'),
	(109,'EXAM_DEL_SU','Cancellazione esame - forzato da super utente'),
	(110,'PROC_INS','Inserita procedura'),
	(111,'DEL_PROC','Eliminata procedura'),
	(112,'ROOM_CHNG','Spostamento di sala'),
	(113,'WARD_PROV_CHNG','Modifica del reparto di provenienza'),
	(114,'REQ_WARD_CHNG','Modifica del reparto richiedente'),
	(115,'DEL_ORD','Cancellazione ordine'),
	(116,'URG_CHNG','Modificata urgenza ordine'),
	(117,'DEL_PRESCR','Cancellazione per discrepanza ricetta'),
	(118,'SCRN_SYS_REP','Firma di sistema del referto di screening'),
	(119,'REP_SAVE','Salvataggio referto'),
	(120,'MERGE_PAT','Accorpamento pazienti'),
	(121,'INS_PAT','Creazione Paziente'),
	(122,'UPD_PAT','Aggiornamento anagrafico paziente');

/*!40000 ALTER TABLE `AUDIT_LIST` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table AUDIT_PATIENT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT_PATIENT`;

CREATE TABLE `AUDIT_PATIENT` (
  `IDPATIENT` int DEFAULT NULL,
  `DATETIME` datetime DEFAULT NULL,
  `USER` int DEFAULT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DETAILS` longtext CHARACTER SET latin1 COLLATE latin1_general_ci,
  `IDAUDIT` int NOT NULL AUTO_INCREMENT,
  `TYPE` char(2) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DESCRIPTION_CODE` int DEFAULT NULL,
  `OPTIONAL_DESC_DATA` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`IDAUDIT`),
  KEY `AUDIT_PATIENT_ibfk_3` (`TYPE`),
  KEY `AUDIT_PATIENT_FK` (`IDPATIENT`),
  KEY `AUDIT_PATIENT_FK_1` (`USER`),
  KEY `AUDIT_PATIENT_FK_lang` (`DESCRIPTION_CODE`),
  CONSTRAINT `AUDIT_PATIENT_FK_lang` FOREIGN KEY (`DESCRIPTION_CODE`) REFERENCES `AUDIT_LIST` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_PATIENT_ibfk_1` FOREIGN KEY (`IDPATIENT`) REFERENCES `PATIENT` (`IDPATIENT`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_PATIENT_ibfk_2` FOREIGN KEY (`USER`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table AUDIT_SYSTEM
# ------------------------------------------------------------

DROP TABLE IF EXISTS `AUDIT_SYSTEM`;

CREATE TABLE `AUDIT_SYSTEM` (
  `pk` int NOT NULL AUTO_INCREMENT,
  `event_datetime` timestamp NULL DEFAULT NULL,
  `type_fk` int NOT NULL,
  `level` varchar(8) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `description` varchar(250) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `idcode` int DEFAULT NULL,
  `idpatient` int DEFAULT NULL,
  `ext_code` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`pk`) USING BTREE,
  KEY `type_fk` (`type_fk`),
  KEY `idpatient` (`idpatient`),
  KEY `idcode` (`idcode`),
  CONSTRAINT `AUDIT_SYSTEM_ibfk_1` FOREIGN KEY (`type_fk`) REFERENCES `AUDIT_CATEGORY` (`pk`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_SYSTEM_ibfk_2` FOREIGN KEY (`idpatient`) REFERENCES `PATIENT` (`IDPATIENT`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `AUDIT_SYSTEM_ibfk_3` FOREIGN KEY (`idcode`) REFERENCES `USERS` (`IDUSER`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CODICE_DIAGNOSTICO
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CODICE_DIAGNOSTICO`;

CREATE TABLE `CODICE_DIAGNOSTICO` (
  `ID_CODE` int NOT NULL DEFAULT '0',
  `CODE` varchar(5) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT 'R0',
  `DESCRIZIONE` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `ACTIVE` char(1) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT 'A',
  PRIMARY KEY (`ID_CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CODICE_DIAGNOSTICO_LANG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CODICE_DIAGNOSTICO_LANG`;

CREATE TABLE `CODICE_DIAGNOSTICO_LANG` (
  `PK` int NOT NULL AUTO_INCREMENT,
  `ID_CODE` int NOT NULL,
  `LANG_FK` int NOT NULL,
  `DESCRIZIONE` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`PK`),
  UNIQUE KEY `CODICE_DIAGNOSTICO_LANG_UN` (`ID_CODE`,`LANG_FK`),
  KEY `COD_DIAG_LANG_FK_1` (`ID_CODE`),
  KEY `COD_DIAG_LANG_FK_2` (`LANG_FK`),
  CONSTRAINT `COD_DIAG_LANG_FK_1` FOREIGN KEY (`ID_CODE`) REFERENCES `CODICE_DIAGNOSTICO` (`ID_CODE`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `COD_DIAG_LANG_FK_2` FOREIGN KEY (`LANG_FK`) REFERENCES `LANGUAGES` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CODICE_OSCURAMENTO
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CODICE_OSCURAMENTO`;

CREATE TABLE `CODICE_OSCURAMENTO` (
  `ID_CODE` int NOT NULL DEFAULT '0',
  `CODE` varchar(5) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `DESCRIZIONE` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `ACTIVE` char(1) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT 'A',
  PRIMARY KEY (`ID_CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CODICE_OSCURAMENTO_LANG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CODICE_OSCURAMENTO_LANG`;

CREATE TABLE `CODICE_OSCURAMENTO_LANG` (
  `PK` int NOT NULL AUTO_INCREMENT,
  `ID_CODE` int NOT NULL,
  `LANG_FK` int NOT NULL,
  `DESCRIZIONE` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`PK`),
  UNIQUE KEY `CODICE_OSCURAMENTO_LANG_UN` (`ID_CODE`,`LANG_FK`),
  KEY `COD_OSC_LANG_FK_1` (`ID_CODE`),
  KEY `COD_OSC_LANG_FK_2` (`LANG_FK`),
  CONSTRAINT `COD_OSC_LANG_FK_1` FOREIGN KEY (`ID_CODE`) REFERENCES `CODICE_OSCURAMENTO` (`ID_CODE`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `COD_OSC_LANG_FK_2` FOREIGN KEY (`LANG_FK`) REFERENCES `LANGUAGES` (`PK`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table COMUNI_ITALIANI
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMUNI_ITALIANI`;

CREATE TABLE `COMUNI_ITALIANI` (
  `IDCOMUNE` int NOT NULL AUTO_INCREMENT,
  `CODICE_REGIONE` varchar(3) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `CODICE_PROVINCIA` varchar(3) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `CODICE_COMUNE` varchar(3) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `CODICE_ISTAT_A` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `CODICE_ISTAT_N` int NOT NULL,
  `DENOMINAZIONE_IT_DE` varchar(90) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DENOMINAZIONE_IT` varchar(90) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DENOMINAZIONE_DE` varchar(90) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `SIGLA_PROVINCIA` varchar(2) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `STATUS` int DEFAULT '1',
  `INIZIO_VALIDITA` date DEFAULT '1840-01-01',
  `FINE_VALIDITA` date DEFAULT '2999-12-31',
  PRIMARY KEY (`IDCOMUNE`) USING BTREE,
  KEY `CODICE_ISTAT_A` (`CODICE_ISTAT_A`) USING BTREE,
  KEY `SIGLA_PROVINCIA` (`SIGLA_PROVINCIA`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='InnoDB free: 7098368 kB';

LOCK TABLES `COMUNI_ITALIANI` WRITE;
/*!40000 ALTER TABLE `COMUNI_ITALIANI` DISABLE KEYS */;

INSERT INTO `COMUNI_ITALIANI` (`IDCOMUNE`, `CODICE_REGIONE`, `CODICE_PROVINCIA`, `CODICE_COMUNE`, `CODICE_ISTAT_A`, `CODICE_ISTAT_N`, `DENOMINAZIONE_IT_DE`, `DENOMINAZIONE_IT`, `DENOMINAZIONE_DE`, `SIGLA_PROVINCIA`, `STATUS`, `INIZIO_VALIDITA`, `FINE_VALIDITA`)
VALUES
	(27853,'00','000','00','',0,'Comune Sconosciuto','Comune Sconosciuto','Comune Sconosciuto',NULL,1,'1840-01-01','2999-12-31'),
	(27854,'01','001',' 00','001001',1001,'Agliè','Agliè','','TO',1,'1840-01-01','2999-12-31'),
	(27855,'01','001',' 00','001002',1002,'Airasca','Airasca','','TO',1,'1840-01-01','2999-12-31'),
	(27856,'01','001',' 00','001003',1003,'Ala di Stura','Ala di Stura','','TO',1,'1840-01-01','2999-12-31'),
	(27857,'01','001',' 00','001004',1004,'Albiano d\'Ivrea','Albiano d\'Ivrea','','TO',1,'1840-01-01','2999-12-31'),
	(27858,'01','001',' 00','001005',1005,'Alice Superiore','Alice Superiore','','TO',1,'1840-01-01','2999-12-31'),
	(27859,'01','001',' 00','001006',1006,'Almese','Almese','','TO',1,'1840-01-01','2999-12-31'),
	(27860,'01','001',' 00','001007',1007,'Alpette','Alpette','','TO',1,'1840-01-01','2999-12-31'),
	(27861,'01','001',' 00','001008',1008,'Alpignano','Alpignano','','TO',1,'1840-01-01','2999-12-31'),
	(27862,'01','001',' 00','001009',1009,'Andezeno','Andezeno','','TO',1,'1840-01-01','2999-12-31'),
	(27863,'01','001',' 01','001010',1010,'Andrate','Andrate','','TO',1,'1840-01-01','2999-12-31'),
	(27864,'01','001',' 01','001011',1011,'Angrogna','Angrogna','','TO',1,'1840-01-01','2999-12-31'),
	(27865,'01','001',' 01','001012',1012,'Arignano','Arignano','','TO',1,'1840-01-01','2999-12-31'),
	(27866,'01','001',' 01','001013',1013,'Avigliana','Avigliana','','TO',1,'1840-01-01','2999-12-31'),
	(27867,'01','001',' 01','001014',1014,'Azeglio','Azeglio','','TO',1,'1840-01-01','2999-12-31'),
	(27868,'01','001',' 01','001015',1015,'Bairo','Bairo','','TO',1,'1840-01-01','2999-12-31'),
	(27869,'01','001',' 01','001016',1016,'Balangero','Balangero','','TO',1,'1840-01-01','2999-12-31'),
	(27870,'01','001',' 01','001017',1017,'Baldissero Canavese','Baldissero Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27871,'01','001',' 01','001018',1018,'Baldissero Torinese','Baldissero Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27872,'01','001',' 01','001019',1019,'Balme','Balme','','TO',1,'1840-01-01','2999-12-31'),
	(27873,'01','001',' 02','001020',1020,'Banchette','Banchette','','TO',1,'1840-01-01','2999-12-31'),
	(27874,'01','001',' 02','001021',1021,'Barbania','Barbania','','TO',1,'1840-01-01','2999-12-31'),
	(27875,'01','001',' 02','001022',1022,'Bardonecchia','Bardonecchia','','TO',1,'1840-01-01','2999-12-31'),
	(27876,'01','001',' 02','001023',1023,'Barone Canavese','Barone Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27877,'01','001',' 02','001024',1024,'Beinasco','Beinasco','','TO',1,'1840-01-01','2999-12-31'),
	(27878,'01','001',' 02','001025',1025,'Bibiana','Bibiana','','TO',1,'1840-01-01','2999-12-31'),
	(27879,'01','001',' 02','001026',1026,'Bobbio Pellice','Bobbio Pellice','','TO',1,'1840-01-01','2999-12-31'),
	(27880,'01','001',' 02','001027',1027,'Bollengo','Bollengo','','TO',1,'1840-01-01','2999-12-31'),
	(27881,'01','001',' 02','001028',1028,'Borgaro Torinese','Borgaro Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27882,'01','001',' 02','001029',1029,'Borgiallo','Borgiallo','','TO',1,'1840-01-01','2999-12-31'),
	(27883,'01','001',' 03','001030',1030,'Borgofranco d\'Ivrea','Borgofranco d\'Ivrea','','TO',1,'1840-01-01','2999-12-31'),
	(27884,'01','001',' 03','001031',1031,'Borgomasino','Borgomasino','','TO',1,'1840-01-01','2999-12-31'),
	(27885,'01','001',' 03','001032',1032,'Borgone Susa','Borgone Susa','','TO',1,'1840-01-01','2999-12-31'),
	(27886,'01','001',' 03','001033',1033,'Bosconero','Bosconero','','TO',1,'1840-01-01','2999-12-31'),
	(27887,'01','001',' 03','001034',1034,'Brandizzo','Brandizzo','','TO',1,'1840-01-01','2999-12-31'),
	(27888,'01','001',' 03','001035',1035,'Bricherasio','Bricherasio','','TO',1,'1840-01-01','2999-12-31'),
	(27889,'01','001',' 03','001036',1036,'Brosso','Brosso','','TO',1,'1840-01-01','2999-12-31'),
	(27890,'01','001',' 03','001037',1037,'Brozolo','Brozolo','','TO',1,'1840-01-01','2999-12-31'),
	(27891,'01','001',' 03','001038',1038,'Bruino','Bruino','','TO',1,'1840-01-01','2999-12-31'),
	(27892,'01','001',' 03','001039',1039,'Brusasco','Brusasco','','TO',1,'1840-01-01','2999-12-31'),
	(27893,'01','001',' 04','001040',1040,'Bruzolo','Bruzolo','','TO',1,'1840-01-01','2999-12-31'),
	(27894,'01','001',' 04','001041',1041,'Buriasco','Buriasco','','TO',1,'1840-01-01','2999-12-31'),
	(27895,'01','001',' 04','001042',1042,'Burolo','Burolo','','TO',1,'1840-01-01','2999-12-31'),
	(27896,'01','001',' 04','001043',1043,'Busano','Busano','','TO',1,'1840-01-01','2999-12-31'),
	(27897,'01','001',' 04','001044',1044,'Bussoleno','Bussoleno','','TO',1,'1840-01-01','2999-12-31'),
	(27898,'01','001',' 04','001045',1045,'Buttigliera Alta','Buttigliera Alta','','TO',1,'1840-01-01','2999-12-31'),
	(27899,'01','001',' 04','001046',1046,'Cafasse','Cafasse','','TO',1,'1840-01-01','2999-12-31'),
	(27900,'01','001',' 04','001047',1047,'Caluso','Caluso','','TO',1,'1840-01-01','2999-12-31'),
	(27901,'01','001',' 04','001048',1048,'Cambiano','Cambiano','','TO',1,'1840-01-01','2999-12-31'),
	(27902,'01','001',' 04','001049',1049,'Campiglione-Fenile','Campiglione-Fenile','','TO',1,'1840-01-01','2999-12-31'),
	(27903,'01','001',' 05','001050',1050,'Candia Canavese','Candia Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27904,'01','001',' 05','001051',1051,'Candiolo','Candiolo','','TO',1,'1840-01-01','2999-12-31'),
	(27905,'01','001',' 05','001052',1052,'Canischio','Canischio','','TO',1,'1840-01-01','2999-12-31'),
	(27906,'01','001',' 05','001053',1053,'Cantalupa','Cantalupa','','TO',1,'1840-01-01','2999-12-31'),
	(27907,'01','001',' 05','001054',1054,'Cantoira','Cantoira','','TO',1,'1840-01-01','2999-12-31'),
	(27908,'01','001',' 05','001055',1055,'Caprie','Caprie','','TO',1,'1840-01-01','2999-12-31'),
	(27909,'01','001',' 05','001056',1056,'Caravino','Caravino','','TO',1,'1840-01-01','2999-12-31'),
	(27910,'01','001',' 05','001057',1057,'Carema','Carema','','TO',1,'1840-01-01','2999-12-31'),
	(27911,'01','001',' 05','001058',1058,'Carignano','Carignano','','TO',1,'1840-01-01','2999-12-31'),
	(27912,'01','001',' 05','001059',1059,'Carmagnola','Carmagnola','','TO',1,'1840-01-01','2999-12-31'),
	(27913,'01','001',' 06','001060',1060,'Casalborgone','Casalborgone','','TO',1,'1840-01-01','2999-12-31'),
	(27914,'01','001',' 06','001061',1061,'Cascinette d\'Ivrea','Cascinette d\'Ivrea','','TO',1,'1840-01-01','2999-12-31'),
	(27915,'01','001',' 06','001062',1062,'Caselette','Caselette','','TO',1,'1840-01-01','2999-12-31'),
	(27916,'01','001',' 06','001063',1063,'Caselle Torinese','Caselle Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27917,'01','001',' 06','001064',1064,'Castagneto Po','Castagneto Po','','TO',1,'1840-01-01','2999-12-31'),
	(27918,'01','001',' 06','001065',1065,'Castagnole Piemonte','Castagnole Piemonte','','TO',1,'1840-01-01','2999-12-31'),
	(27919,'01','001',' 06','001066',1066,'Castellamonte','Castellamonte','','TO',1,'1840-01-01','2999-12-31'),
	(27920,'01','001',' 06','001067',1067,'Castelnuovo Nigra','Castelnuovo Nigra','','TO',1,'1840-01-01','2999-12-31'),
	(27921,'01','001',' 06','001068',1068,'Castiglione Torinese','Castiglione Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27922,'01','001',' 06','001069',1069,'Cavagnolo','Cavagnolo','','TO',1,'1840-01-01','2999-12-31'),
	(27923,'01','001',' 07','001070',1070,'Cavour','Cavour','','TO',1,'1840-01-01','2999-12-31'),
	(27924,'01','001',' 07','001071',1071,'Cercenasco','Cercenasco','','TO',1,'1840-01-01','2999-12-31'),
	(27925,'01','001',' 07','001072',1072,'Ceres','Ceres','','TO',1,'1840-01-01','2999-12-31'),
	(27926,'01','001',' 07','001073',1073,'Ceresole Reale','Ceresole Reale','','TO',1,'1840-01-01','2999-12-31'),
	(27927,'01','001',' 07','001074',1074,'Cesana Torinese','Cesana Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27928,'01','001',' 07','001075',1075,'Chialamberto','Chialamberto','','TO',1,'1840-01-01','2999-12-31'),
	(27929,'01','001',' 07','001076',1076,'Chianocco','Chianocco','','TO',1,'1840-01-01','2999-12-31'),
	(27930,'01','001',' 07','001077',1077,'Chiaverano','Chiaverano','','TO',1,'1840-01-01','2999-12-31'),
	(27931,'01','001',' 07','001078',1078,'Chieri','Chieri','','TO',1,'1840-01-01','2999-12-31'),
	(27932,'01','001',' 07','001079',1079,'Chiesanuova','Chiesanuova','','TO',1,'1840-01-01','2999-12-31'),
	(27933,'01','001',' 08','001080',1080,'Chiomonte','Chiomonte','','TO',1,'1840-01-01','2999-12-31'),
	(27934,'01','001',' 08','001081',1081,'Chiusa di San Michele','Chiusa di San Michele','','TO',1,'1840-01-01','2999-12-31'),
	(27935,'01','001',' 08','001082',1082,'Chivasso','Chivasso','','TO',1,'1840-01-01','2999-12-31'),
	(27936,'01','001',' 08','001083',1083,'Ciconio','Ciconio','','TO',1,'1840-01-01','2999-12-31'),
	(27937,'01','001',' 08','001084',1084,'Cintano','Cintano','','TO',1,'1840-01-01','2999-12-31'),
	(27938,'01','001',' 08','001085',1085,'Cinzano','Cinzano','','TO',1,'1840-01-01','2999-12-31'),
	(27939,'01','001',' 08','001086',1086,'Ciriè','Ciriè','','TO',1,'1840-01-01','2999-12-31'),
	(27940,'01','001',' 08','001087',1087,'Claviere','Claviere','','TO',1,'1840-01-01','2999-12-31'),
	(27941,'01','001',' 08','001088',1088,'Coassolo Torinese','Coassolo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27942,'01','001',' 08','001089',1089,'Coazze','Coazze','','TO',1,'1840-01-01','2999-12-31'),
	(27943,'01','001',' 09','001090',1090,'Collegno','Collegno','','TO',1,'1840-01-01','2999-12-31'),
	(27944,'01','001',' 09','001091',1091,'Colleretto Castelnuovo','Colleretto Castelnuovo','','TO',1,'1840-01-01','2999-12-31'),
	(27945,'01','001',' 09','001092',1092,'Colleretto Giacosa','Colleretto Giacosa','','TO',1,'1840-01-01','2999-12-31'),
	(27946,'01','001',' 09','001093',1093,'Condove','Condove','','TO',1,'1840-01-01','2999-12-31'),
	(27947,'01','001',' 09','001094',1094,'Corio','Corio','','TO',1,'1840-01-01','2999-12-31'),
	(27948,'01','001',' 09','001095',1095,'Cossano Canavese','Cossano Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27949,'01','001',' 09','001096',1096,'Cuceglio','Cuceglio','','TO',1,'1840-01-01','2999-12-31'),
	(27950,'01','001',' 09','001097',1097,'Cumiana','Cumiana','','TO',1,'1840-01-01','2999-12-31'),
	(27951,'01','001',' 09','001098',1098,'Cuorgnè','Cuorgnè','','TO',1,'1840-01-01','2999-12-31'),
	(27952,'01','001',' 09','001099',1099,'Druento','Druento','','TO',1,'1840-01-01','2999-12-31'),
	(27953,'01','001',' 10','001100',1100,'Exilles','Exilles','','TO',1,'1840-01-01','2999-12-31'),
	(27954,'01','001',' 10','001101',1101,'Favria','Favria','','TO',1,'1840-01-01','2999-12-31'),
	(27955,'01','001',' 10','001102',1102,'Feletto','Feletto','','TO',1,'1840-01-01','2999-12-31'),
	(27956,'01','001',' 10','001103',1103,'Fenestrelle','Fenestrelle','','TO',1,'1840-01-01','2999-12-31'),
	(27957,'01','001',' 10','001104',1104,'Fiano','Fiano','','TO',1,'1840-01-01','2999-12-31'),
	(27958,'01','001',' 10','001105',1105,'Fiorano Canavese','Fiorano Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27959,'01','001',' 10','001106',1106,'Foglizzo','Foglizzo','','TO',1,'1840-01-01','2999-12-31'),
	(27960,'01','001',' 10','001107',1107,'Forno Canavese','Forno Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(27961,'01','001',' 10','001108',1108,'Frassinetto','Frassinetto','','TO',1,'1840-01-01','2999-12-31'),
	(27962,'01','001',' 10','001109',1109,'Front','Front','','TO',1,'1840-01-01','2999-12-31'),
	(27963,'01','001',' 11','001110',1110,'Frossasco','Frossasco','','TO',1,'1840-01-01','2999-12-31'),
	(27964,'01','001',' 11','001111',1111,'Garzigliana','Garzigliana','','TO',1,'1840-01-01','2999-12-31'),
	(27965,'01','001',' 11','001112',1112,'Gassino Torinese','Gassino Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27966,'01','001',' 11','001113',1113,'Germagnano','Germagnano','','TO',1,'1840-01-01','2999-12-31'),
	(27967,'01','001',' 11','001114',1114,'Giaglione','Giaglione','','TO',1,'1840-01-01','2999-12-31'),
	(27968,'01','001',' 11','001115',1115,'Giaveno','Giaveno','','TO',1,'1840-01-01','2999-12-31'),
	(27969,'01','001',' 11','001116',1116,'Givoletto','Givoletto','','TO',1,'1840-01-01','2999-12-31'),
	(27970,'01','001',' 11','001117',1117,'Gravere','Gravere','','TO',1,'1840-01-01','2999-12-31'),
	(27971,'01','001',' 11','001118',1118,'Groscavallo','Groscavallo','','TO',1,'1840-01-01','2999-12-31'),
	(27972,'01','001',' 11','001119',1119,'Grosso','Grosso','','TO',1,'1840-01-01','2999-12-31'),
	(27973,'01','001',' 12','001120',1120,'Grugliasco','Grugliasco','','TO',1,'1840-01-01','2999-12-31'),
	(27974,'01','001',' 12','001121',1121,'Ingria','Ingria','','TO',1,'1840-01-01','2999-12-31'),
	(27975,'01','001',' 12','001122',1122,'Inverso Pinasca','Inverso Pinasca','','TO',1,'1840-01-01','2999-12-31'),
	(27976,'01','001',' 12','001123',1123,'Isolabella','Isolabella','','TO',1,'1840-01-01','2999-12-31'),
	(27977,'01','001',' 12','001124',1124,'Issiglio','Issiglio','','TO',1,'1840-01-01','2999-12-31'),
	(27978,'01','001',' 12','001125',1125,'Ivrea','Ivrea','','TO',1,'1840-01-01','2999-12-31'),
	(27979,'01','001',' 12','001126',1126,'La Cassa','La Cassa','','TO',1,'1840-01-01','2999-12-31'),
	(27980,'01','001',' 12','001127',1127,'La Loggia','La Loggia','','TO',1,'1840-01-01','2999-12-31'),
	(27981,'01','001',' 12','001128',1128,'Lanzo Torinese','Lanzo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(27982,'01','001',' 12','001129',1129,'Lauriano','Lauriano','','TO',1,'1840-01-01','2999-12-31'),
	(27983,'01','001',' 13','001130',1130,'Leinì','Leinì','','TO',1,'1840-01-01','2999-12-31'),
	(27984,'01','001',' 13','001131',1131,'Lemie','Lemie','','TO',1,'1840-01-01','2999-12-31'),
	(27985,'01','001',' 13','001132',1132,'Lessolo','Lessolo','','TO',1,'1840-01-01','2999-12-31'),
	(27986,'01','001',' 13','001133',1133,'Levone','Levone','','TO',1,'1840-01-01','2999-12-31'),
	(27987,'01','001',' 13','001134',1134,'Locana','Locana','','TO',1,'1840-01-01','2999-12-31'),
	(27988,'01','001',' 13','001135',1135,'Lombardore','Lombardore','','TO',1,'1840-01-01','2999-12-31'),
	(27989,'01','001',' 13','001136',1136,'Lombriasco','Lombriasco','','TO',1,'1840-01-01','2999-12-31'),
	(27990,'01','001',' 13','001137',1137,'Loranzè','Loranzè','','TO',1,'1840-01-01','2999-12-31'),
	(27991,'01','001',' 13','001138',1138,'Lugnacco','Lugnacco','','TO',1,'1840-01-01','2999-12-31'),
	(27992,'01','001',' 13','001139',1139,'Luserna San Giovanni','Luserna San Giovanni','','TO',1,'1840-01-01','2999-12-31'),
	(27993,'01','001',' 14','001140',1140,'Lusernetta','Lusernetta','','TO',1,'1840-01-01','2999-12-31'),
	(27994,'01','001',' 14','001141',1141,'Lusigliè','Lusigliè','','TO',1,'1840-01-01','2999-12-31'),
	(27995,'01','001',' 14','001142',1142,'Macello','Macello','','TO',1,'1840-01-01','2999-12-31'),
	(27996,'01','001',' 14','001143',1143,'Maglione','Maglione','','TO',1,'1840-01-01','2999-12-31'),
	(27997,'01','001',' 14','001144',1144,'Marentino','Marentino','','TO',1,'1840-01-01','2999-12-31'),
	(27998,'01','001',' 14','001145',1145,'Massello','Massello','','TO',1,'1840-01-01','2999-12-31'),
	(27999,'01','001',' 14','001146',1146,'Mathi','Mathi','','TO',1,'1840-01-01','2999-12-31'),
	(28000,'01','001',' 14','001147',1147,'Mattie','Mattie','','TO',1,'1840-01-01','2999-12-31'),
	(28001,'01','001',' 14','001148',1148,'Mazzè','Mazzè','','TO',1,'1840-01-01','2999-12-31'),
	(28002,'01','001',' 14','001149',1149,'Meana di Susa','Meana di Susa','','TO',1,'1840-01-01','2999-12-31'),
	(28003,'01','001',' 15','001150',1150,'Mercenasco','Mercenasco','','TO',1,'1840-01-01','2999-12-31'),
	(28004,'01','001',' 15','001151',1151,'Meugliano','Meugliano','','TO',1,'1840-01-01','2999-12-31'),
	(28005,'01','001',' 15','001152',1152,'Mezzenile','Mezzenile','','TO',1,'1840-01-01','2999-12-31'),
	(28006,'01','001',' 15','001153',1153,'Mombello di Torino','Mombello di Torino','','TO',1,'1840-01-01','2999-12-31'),
	(28007,'01','001',' 15','001154',1154,'Mompantero','Mompantero','','TO',1,'1840-01-01','2999-12-31'),
	(28008,'01','001',' 15','001155',1155,'Monastero di Lanzo','Monastero di Lanzo','','TO',1,'1840-01-01','2999-12-31'),
	(28009,'01','001',' 15','001156',1156,'Moncalieri','Moncalieri','','TO',1,'1840-01-01','2999-12-31'),
	(28010,'01','001',' 15','001157',1157,'Moncenisio','Moncenisio','','TO',1,'1840-01-01','2999-12-31'),
	(28011,'01','001',' 15','001158',1158,'Montaldo Torinese','Montaldo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28012,'01','001',' 15','001159',1159,'Montalenghe','Montalenghe','','TO',1,'1840-01-01','2999-12-31'),
	(28013,'01','001',' 16','001160',1160,'Montalto Dora','Montalto Dora','','TO',1,'1840-01-01','2999-12-31'),
	(28014,'01','001',' 16','001161',1161,'Montanaro','Montanaro','','TO',1,'1840-01-01','2999-12-31'),
	(28015,'01','001',' 16','001162',1162,'Monteu da Po','Monteu da Po','','TO',1,'1840-01-01','2999-12-31'),
	(28016,'01','001',' 16','001163',1163,'Moriondo Torinese','Moriondo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28017,'01','001',' 16','001164',1164,'Nichelino','Nichelino','','TO',1,'1840-01-01','2999-12-31'),
	(28018,'01','001',' 16','001165',1165,'Noasca','Noasca','','TO',1,'1840-01-01','2999-12-31'),
	(28019,'01','001',' 16','001166',1166,'Nole','Nole','','TO',1,'1840-01-01','2999-12-31'),
	(28020,'01','001',' 16','001167',1167,'Nomaglio','Nomaglio','','TO',1,'1840-01-01','2999-12-31'),
	(28021,'01','001',' 16','001168',1168,'None','None','','TO',1,'1840-01-01','2999-12-31'),
	(28022,'01','001',' 16','001169',1169,'Novalesa','Novalesa','','TO',1,'1840-01-01','2999-12-31'),
	(28023,'01','001',' 17','001170',1170,'Oglianico','Oglianico','','TO',1,'1840-01-01','2999-12-31'),
	(28024,'01','001',' 17','001171',1171,'Orbassano','Orbassano','','TO',1,'1840-01-01','2999-12-31'),
	(28025,'01','001',' 17','001172',1172,'Orio Canavese','Orio Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28026,'01','001',' 17','001173',1173,'Osasco','Osasco','','TO',1,'1840-01-01','2999-12-31'),
	(28027,'01','001',' 17','001174',1174,'Osasio','Osasio','','TO',1,'1840-01-01','2999-12-31'),
	(28028,'01','001',' 17','001175',1175,'Oulx','Oulx','','TO',1,'1840-01-01','2999-12-31'),
	(28029,'01','001',' 17','001176',1176,'Ozegna','Ozegna','','TO',1,'1840-01-01','2999-12-31'),
	(28030,'01','001',' 17','001177',1177,'Palazzo Canavese','Palazzo Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28031,'01','001',' 17','001178',1178,'Pancalieri','Pancalieri','','TO',1,'1840-01-01','2999-12-31'),
	(28032,'01','001',' 17','001179',1179,'Parella','Parella','','TO',1,'1840-01-01','2999-12-31'),
	(28033,'01','001',' 18','001180',1180,'Pavarolo','Pavarolo','','TO',1,'1840-01-01','2999-12-31'),
	(28034,'01','001',' 18','001181',1181,'Pavone Canavese','Pavone Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28035,'01','001',' 18','001182',1182,'Pecco','Pecco','','TO',1,'1840-01-01','2999-12-31'),
	(28036,'01','001',' 18','001183',1183,'Pecetto Torinese','Pecetto Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28037,'01','001',' 18','001184',1184,'Perosa Argentina','Perosa Argentina','','TO',1,'1840-01-01','2999-12-31'),
	(28038,'01','001',' 18','001185',1185,'Perosa Canavese','Perosa Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28039,'01','001',' 18','001186',1186,'Perrero','Perrero','','TO',1,'1840-01-01','2999-12-31'),
	(28040,'01','001',' 18','001187',1187,'Pertusio','Pertusio','','TO',1,'1840-01-01','2999-12-31'),
	(28041,'01','001',' 18','001188',1188,'Pessinetto','Pessinetto','','TO',1,'1840-01-01','2999-12-31'),
	(28042,'01','001',' 18','001189',1189,'Pianezza','Pianezza','','TO',1,'1840-01-01','2999-12-31'),
	(28043,'01','001',' 19','001190',1190,'Pinasca','Pinasca','','TO',1,'1840-01-01','2999-12-31'),
	(28044,'01','001',' 19','001191',1191,'Pinerolo','Pinerolo','','TO',1,'1840-01-01','2999-12-31'),
	(28045,'01','001',' 19','001192',1192,'Pino Torinese','Pino Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28046,'01','001',' 19','001193',1193,'Piobesi Torinese','Piobesi Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28047,'01','001',' 19','001194',1194,'Piossasco','Piossasco','','TO',1,'1840-01-01','2999-12-31'),
	(28048,'01','001',' 19','001195',1195,'Piscina','Piscina','','TO',1,'1840-01-01','2999-12-31'),
	(28049,'01','001',' 19','001196',1196,'Piverone','Piverone','','TO',1,'1840-01-01','2999-12-31'),
	(28050,'01','001',' 19','001197',1197,'Poirino','Poirino','','TO',1,'1840-01-01','2999-12-31'),
	(28051,'01','001',' 19','001198',1198,'Pomaretto','Pomaretto','','TO',1,'1840-01-01','2999-12-31'),
	(28052,'01','001',' 19','001199',1199,'Pont-Canavese','Pont-Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28053,'01','001',' 20','001200',1200,'Porte','Porte','','TO',1,'1840-01-01','2999-12-31'),
	(28054,'01','001',' 20','001201',1201,'Pragelato','Pragelato','','TO',1,'1840-01-01','2999-12-31'),
	(28055,'01','001',' 20','001202',1202,'Prali','Prali','','TO',1,'1840-01-01','2999-12-31'),
	(28056,'01','001',' 20','001203',1203,'Pralormo','Pralormo','','TO',1,'1840-01-01','2999-12-31'),
	(28057,'01','001',' 20','001204',1204,'Pramollo','Pramollo','','TO',1,'1840-01-01','2999-12-31'),
	(28058,'01','001',' 20','001205',1205,'Prarostino','Prarostino','','TO',1,'1840-01-01','2999-12-31'),
	(28059,'01','001',' 20','001206',1206,'Prascorsano','Prascorsano','','TO',1,'1840-01-01','2999-12-31'),
	(28060,'01','001',' 20','001207',1207,'Pratiglione','Pratiglione','','TO',1,'1840-01-01','2999-12-31'),
	(28061,'01','001',' 20','001208',1208,'Quagliuzzo','Quagliuzzo','','TO',1,'1840-01-01','2999-12-31'),
	(28062,'01','001',' 20','001209',1209,'Quassolo','Quassolo','','TO',1,'1840-01-01','2999-12-31'),
	(28063,'01','001',' 21','001210',1210,'Quincinetto','Quincinetto','','TO',1,'1840-01-01','2999-12-31'),
	(28064,'01','001',' 21','001211',1211,'Reano','Reano','','TO',1,'1840-01-01','2999-12-31'),
	(28065,'01','001',' 21','001212',1212,'Ribordone','Ribordone','','TO',1,'1840-01-01','2999-12-31'),
	(28066,'01','001',' 21','001213',1213,'Rivalba','Rivalba','','TO',1,'1840-01-01','2999-12-31'),
	(28067,'01','001',' 21','001214',1214,'Rivalta di Torino','Rivalta di Torino','','TO',1,'1840-01-01','2999-12-31'),
	(28068,'01','001',' 21','001215',1215,'Riva presso Chieri','Riva presso Chieri','','TO',1,'1840-01-01','2999-12-31'),
	(28069,'01','001',' 21','001216',1216,'Rivara','Rivara','','TO',1,'1840-01-01','2999-12-31'),
	(28070,'01','001',' 21','001217',1217,'Rivarolo Canavese','Rivarolo Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28071,'01','001',' 21','001218',1218,'Rivarossa','Rivarossa','','TO',1,'1840-01-01','2999-12-31'),
	(28072,'01','001',' 21','001219',1219,'Rivoli','Rivoli','','TO',1,'1840-01-01','2999-12-31'),
	(28073,'01','001',' 22','001220',1220,'Robassomero','Robassomero','','TO',1,'1840-01-01','2999-12-31'),
	(28074,'01','001',' 22','001221',1221,'Rocca Canavese','Rocca Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28075,'01','001',' 22','001222',1222,'Roletto','Roletto','','TO',1,'1840-01-01','2999-12-31'),
	(28076,'01','001',' 22','001223',1223,'Romano Canavese','Romano Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28077,'01','001',' 22','001224',1224,'Ronco Canavese','Ronco Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28078,'01','001',' 22','001225',1225,'Rondissone','Rondissone','','TO',1,'1840-01-01','2999-12-31'),
	(28079,'01','001',' 22','001226',1226,'Rorà','Rorà','','TO',1,'1840-01-01','2999-12-31'),
	(28080,'01','001',' 22','001227',1227,'Roure','Roure','','TO',1,'1840-01-01','2999-12-31'),
	(28081,'01','001',' 22','001228',1228,'Rosta','Rosta','','TO',1,'1840-01-01','2999-12-31'),
	(28082,'01','001',' 22','001229',1229,'Rubiana','Rubiana','','TO',1,'1840-01-01','2999-12-31'),
	(28083,'01','001',' 23','001230',1230,'Rueglio','Rueglio','','TO',1,'1840-01-01','2999-12-31'),
	(28084,'01','001',' 23','001231',1231,'Salassa','Salassa','','TO',1,'1840-01-01','2999-12-31'),
	(28085,'01','001',' 23','001232',1232,'Salbertrand','Salbertrand','','TO',1,'1840-01-01','2999-12-31'),
	(28086,'01','001',' 23','001233',1233,'Salerano Canavese','Salerano Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28087,'01','001',' 23','001234',1234,'Salza di Pinerolo','Salza di Pinerolo','','TO',1,'1840-01-01','2999-12-31'),
	(28088,'01','001',' 23','001235',1235,'Samone','Samone','','TO',1,'1840-01-01','2999-12-31'),
	(28089,'01','001',' 23','001236',1236,'San Benigno Canavese','San Benigno Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28090,'01','001',' 23','001237',1237,'San Carlo Canavese','San Carlo Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28091,'01','001',' 23','001238',1238,'San Colombano Belmonte','San Colombano Belmonte','','TO',1,'1840-01-01','2999-12-31'),
	(28092,'01','001',' 23','001239',1239,'San Didero','San Didero','','TO',1,'1840-01-01','2999-12-31'),
	(28093,'01','001',' 24','001240',1240,'San Francesco al Campo','San Francesco al Campo','','TO',1,'1840-01-01','2999-12-31'),
	(28094,'01','001',' 24','001241',1241,'Sangano','Sangano','','TO',1,'1840-01-01','2999-12-31'),
	(28095,'01','001',' 24','001242',1242,'San Germano Chisone','San Germano Chisone','','TO',1,'1840-01-01','2999-12-31'),
	(28096,'01','001',' 24','001243',1243,'San Gillio','San Gillio','','TO',1,'1840-01-01','2999-12-31'),
	(28097,'01','001',' 24','001244',1244,'San Giorgio Canavese','San Giorgio Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28098,'01','001',' 24','001245',1245,'San Giorio di Susa','San Giorio di Susa','','TO',1,'1840-01-01','2999-12-31'),
	(28099,'01','001',' 24','001246',1246,'San Giusto Canavese','San Giusto Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28100,'01','001',' 24','001247',1247,'San Martino Canavese','San Martino Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28101,'01','001',' 24','001248',1248,'San Maurizio Canavese','San Maurizio Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28102,'01','001',' 24','001249',1249,'San Mauro Torinese','San Mauro Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28103,'01','001',' 25','001250',1250,'San Pietro Val Lemina','San Pietro Val Lemina','','TO',1,'1840-01-01','2999-12-31'),
	(28104,'01','001',' 25','001251',1251,'San Ponso','San Ponso','','TO',1,'1840-01-01','2999-12-31'),
	(28105,'01','001',' 25','001252',1252,'San Raffaele Cimena','San Raffaele Cimena','','TO',1,'1840-01-01','2999-12-31'),
	(28106,'01','001',' 25','001253',1253,'San Sebastiano da Po','San Sebastiano da Po','','TO',1,'1840-01-01','2999-12-31'),
	(28107,'01','001',' 25','001254',1254,'San Secondo di Pinerolo','San Secondo di Pinerolo','','TO',1,'1840-01-01','2999-12-31'),
	(28108,'01','001',' 25','001255',1255,'Sant\'Ambrogio di Torino','Sant\'Ambrogio di Torino','','TO',1,'1840-01-01','2999-12-31'),
	(28109,'01','001',' 25','001256',1256,'Sant\'Antonino di Susa','Sant\'Antonino di Susa','','TO',1,'1840-01-01','2999-12-31'),
	(28110,'01','001',' 25','001257',1257,'Santena','Santena','','TO',1,'1840-01-01','2999-12-31'),
	(28111,'01','001',' 25','001258',1258,'Sauze di Cesana','Sauze di Cesana','','TO',1,'1840-01-01','2999-12-31'),
	(28112,'01','001',' 25','001259',1259,'Sauze d\'Oulx','Sauze d\'Oulx','','TO',1,'1840-01-01','2999-12-31'),
	(28113,'01','001',' 26','001260',1260,'Scalenghe','Scalenghe','','TO',1,'1840-01-01','2999-12-31'),
	(28114,'01','001',' 26','001261',1261,'Scarmagno','Scarmagno','','TO',1,'1840-01-01','2999-12-31'),
	(28115,'01','001',' 26','001262',1262,'Sciolze','Sciolze','','TO',1,'1840-01-01','2999-12-31'),
	(28116,'01','001',' 26','001263',1263,'Sestriere','Sestriere','','TO',1,'1840-01-01','2999-12-31'),
	(28117,'01','001',' 26','001264',1264,'Settimo Rottaro','Settimo Rottaro','','TO',1,'1840-01-01','2999-12-31'),
	(28118,'01','001',' 26','001265',1265,'Settimo Torinese','Settimo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28119,'01','001',' 26','001266',1266,'Settimo Vittone','Settimo Vittone','','TO',1,'1840-01-01','2999-12-31'),
	(28120,'01','001',' 26','001267',1267,'Sparone','Sparone','','TO',1,'1840-01-01','2999-12-31'),
	(28121,'01','001',' 26','001268',1268,'Strambinello','Strambinello','','TO',1,'1840-01-01','2999-12-31'),
	(28122,'01','001',' 26','001269',1269,'Strambino','Strambino','','TO',1,'1840-01-01','2999-12-31'),
	(28123,'01','001',' 27','001270',1270,'Susa','Susa','','TO',1,'1840-01-01','2999-12-31'),
	(28124,'01','001',' 27','001271',1271,'Tavagnasco','Tavagnasco','','TO',1,'1840-01-01','2999-12-31'),
	(28125,'01','001',' 27','001272',1272,'Torino','Torino','','TO',1,'1840-01-01','2999-12-31'),
	(28126,'01','001',' 27','001273',1273,'Torrazza Piemonte','Torrazza Piemonte','','TO',1,'1840-01-01','2999-12-31'),
	(28127,'01','001',' 27','001274',1274,'Torre Canavese','Torre Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28128,'01','001',' 27','001275',1275,'Torre Pellice','Torre Pellice','','TO',1,'1840-01-01','2999-12-31'),
	(28129,'01','001',' 27','001276',1276,'Trana','Trana','','TO',1,'1840-01-01','2999-12-31'),
	(28130,'01','001',' 27','001277',1277,'Trausella','Trausella','','TO',1,'1840-01-01','2999-12-31'),
	(28131,'01','001',' 27','001278',1278,'Traversella','Traversella','','TO',1,'1840-01-01','2999-12-31'),
	(28132,'01','001',' 27','001279',1279,'Traves','Traves','','TO',1,'1840-01-01','2999-12-31'),
	(28133,'01','001',' 28','001280',1280,'Trofarello','Trofarello','','TO',1,'1840-01-01','2999-12-31'),
	(28134,'01','001',' 28','001281',1281,'Usseaux','Usseaux','','TO',1,'1840-01-01','2999-12-31'),
	(28135,'01','001',' 28','001282',1282,'Usseglio','Usseglio','','TO',1,'1840-01-01','2999-12-31'),
	(28136,'01','001',' 28','001283',1283,'Vaie','Vaie','','TO',1,'1840-01-01','2999-12-31'),
	(28137,'01','001',' 28','001284',1284,'Val della Torre','Val della Torre','','TO',1,'1840-01-01','2999-12-31'),
	(28138,'01','001',' 28','001285',1285,'Valgioie','Valgioie','','TO',1,'1840-01-01','2999-12-31'),
	(28139,'01','001',' 28','001286',1286,'Vallo Torinese','Vallo Torinese','','TO',1,'1840-01-01','2999-12-31'),
	(28140,'01','001',' 28','001287',1287,'Valperga','Valperga','','TO',1,'1840-01-01','2999-12-31'),
	(28141,'01','001',' 28','001288',1288,'Valprato Soana','Valprato Soana','','TO',1,'1840-01-01','2999-12-31'),
	(28142,'01','001',' 28','001289',1289,'Varisella','Varisella','','TO',1,'1840-01-01','2999-12-31'),
	(28143,'01','001',' 29','001290',1290,'Vauda Canavese','Vauda Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28144,'01','001',' 29','001291',1291,'Venaus','Venaus','','TO',1,'1840-01-01','2999-12-31'),
	(28145,'01','001',' 29','001292',1292,'Venaria Reale','Venaria Reale','','TO',1,'1840-01-01','2999-12-31'),
	(28146,'01','001',' 29','001293',1293,'Verolengo','Verolengo','','TO',1,'1840-01-01','2999-12-31'),
	(28147,'01','001',' 29','001294',1294,'Verrua Savoia','Verrua Savoia','','TO',1,'1840-01-01','2999-12-31'),
	(28148,'01','001',' 29','001295',1295,'Vestignè','Vestignè','','TO',1,'1840-01-01','2999-12-31'),
	(28149,'01','001',' 29','001296',1296,'Vialfrè','Vialfrè','','TO',1,'1840-01-01','2999-12-31'),
	(28150,'01','001',' 29','001297',1297,'Vico Canavese','Vico Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28151,'01','001',' 29','001298',1298,'Vidracco','Vidracco','','TO',1,'1840-01-01','2999-12-31'),
	(28152,'01','001',' 29','001299',1299,'Vigone','Vigone','','TO',1,'1840-01-01','2999-12-31'),
	(28153,'01','001',' 30','001300',1300,'Villafranca Piemonte','Villafranca Piemonte','','TO',1,'1840-01-01','2999-12-31'),
	(28154,'01','001',' 30','001301',1301,'Villanova Canavese','Villanova Canavese','','TO',1,'1840-01-01','2999-12-31'),
	(28155,'01','001',' 30','001302',1302,'Villarbasse','Villarbasse','','TO',1,'1840-01-01','2999-12-31'),
	(28156,'01','001',' 30','001303',1303,'Villar Dora','Villar Dora','','TO',1,'1840-01-01','2999-12-31'),
	(28157,'01','001',' 30','001304',1304,'Villareggia','Villareggia','','TO',1,'1840-01-01','2999-12-31'),
	(28158,'01','001',' 30','001305',1305,'Villar Focchiardo','Villar Focchiardo','','TO',1,'1840-01-01','2999-12-31'),
	(28159,'01','001',' 30','001306',1306,'Villar Pellice','Villar Pellice','','TO',1,'1840-01-01','2999-12-31'),
	(28160,'01','001',' 30','001307',1307,'Villar Perosa','Villar Perosa','','TO',1,'1840-01-01','2999-12-31'),
	(28161,'01','001',' 30','001308',1308,'Villastellone','Villastellone','','TO',1,'1840-01-01','2999-12-31'),
	(28162,'01','001',' 30','001309',1309,'Vinovo','Vinovo','','TO',1,'1840-01-01','2999-12-31'),
	(28163,'01','001',' 31','001310',1310,'Virle Piemonte','Virle Piemonte','','TO',1,'1840-01-01','2999-12-31'),
	(28164,'01','001',' 31','001311',1311,'Vische','Vische','','TO',1,'1840-01-01','2999-12-31'),
	(28165,'01','001',' 31','001312',1312,'Vistrorio','Vistrorio','','TO',1,'1840-01-01','2999-12-31'),
	(28166,'01','001',' 31','001313',1313,'Viù','Viù','','TO',1,'1840-01-01','2999-12-31'),
	(28167,'01','001',' 31','001314',1314,'Volpiano','Volpiano','','TO',1,'1840-01-01','2999-12-31'),
	(28168,'01','001',' 31','001315',1315,'Volvera','Volvera','','TO',1,'1840-01-01','2999-12-31'),
	(28169,'01','002',' 00','002002',2002,'Alagna Valsesia','Alagna Valsesia','','VC',1,'1840-01-01','2999-12-31'),
	(28170,'01','002',' 00','002003',2003,'Albano Vercellese','Albano Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28171,'01','002',' 00','002004',2004,'Alice Castello','Alice Castello','','VC',1,'1840-01-01','2999-12-31'),
	(28172,'01','002',' 00','002006',2006,'Arborio','Arborio','','VC',1,'1840-01-01','2999-12-31'),
	(28173,'01','002',' 00','002007',2007,'Asigliano Vercellese','Asigliano Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28174,'01','002',' 00','002008',2008,'Balmuccia','Balmuccia','','VC',1,'1840-01-01','2999-12-31'),
	(28175,'01','002',' 00','002009',2009,'Balocco','Balocco','','VC',1,'1840-01-01','2999-12-31'),
	(28176,'01','002',' 01','002011',2011,'Bianzè','Bianzè','','VC',1,'1840-01-01','2999-12-31'),
	(28177,'01','002',' 01','002014',2014,'Boccioleto','Boccioleto','','VC',1,'1840-01-01','2999-12-31'),
	(28178,'01','002',' 01','002015',2015,'Borgo d\'Ale','Borgo d\'Ale','','VC',1,'1840-01-01','2999-12-31'),
	(28179,'01','002',' 01','002016',2016,'Borgosesia','Borgosesia','','VC',1,'1840-01-01','2999-12-31'),
	(28180,'01','002',' 01','002017',2017,'Borgo Vercelli','Borgo Vercelli','','VC',1,'1840-01-01','2999-12-31'),
	(28181,'01','002',' 01','002019',2019,'Breia','Breia','','VC',1,'1840-01-01','2999-12-31'),
	(28182,'01','002',' 02','002021',2021,'Buronzo','Buronzo','','VC',1,'1840-01-01','2999-12-31'),
	(28183,'01','002',' 02','002025',2025,'Campertogno','Campertogno','','VC',1,'1840-01-01','2999-12-31'),
	(28184,'01','002',' 02','002029',2029,'Carcoforo','Carcoforo','','VC',1,'1840-01-01','2999-12-31'),
	(28185,'01','002',' 03','002030',2030,'Caresana','Caresana','','VC',1,'1840-01-01','2999-12-31'),
	(28186,'01','002',' 03','002031',2031,'Caresanablot','Caresanablot','','VC',1,'1840-01-01','2999-12-31'),
	(28187,'01','002',' 03','002032',2032,'Carisio','Carisio','','VC',1,'1840-01-01','2999-12-31'),
	(28188,'01','002',' 03','002033',2033,'Casanova Elvo','Casanova Elvo','','VC',1,'1840-01-01','2999-12-31'),
	(28189,'01','002',' 03','002035',2035,'San Giacomo Vercellese','San Giacomo Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28190,'01','002',' 03','002038',2038,'Cellio','Cellio','','VC',1,'1840-01-01','2999-12-31'),
	(28191,'01','002',' 04','002041',2041,'Cervatto','Cervatto','','VC',1,'1840-01-01','2999-12-31'),
	(28192,'01','002',' 04','002042',2042,'Cigliano','Cigliano','','VC',1,'1840-01-01','2999-12-31'),
	(28193,'01','002',' 04','002043',2043,'Civiasco','Civiasco','','VC',1,'1840-01-01','2999-12-31'),
	(28194,'01','002',' 04','002045',2045,'Collobiano','Collobiano','','VC',1,'1840-01-01','2999-12-31'),
	(28195,'01','002',' 04','002047',2047,'Costanzana','Costanzana','','VC',1,'1840-01-01','2999-12-31'),
	(28196,'01','002',' 04','002048',2048,'Cravagliana','Cravagliana','','VC',1,'1840-01-01','2999-12-31'),
	(28197,'01','002',' 04','002049',2049,'Crescentino','Crescentino','','VC',1,'1840-01-01','2999-12-31'),
	(28198,'01','002',' 05','002052',2052,'Crova','Crova','','VC',1,'1840-01-01','2999-12-31'),
	(28199,'01','002',' 05','002054',2054,'Desana','Desana','','VC',1,'1840-01-01','2999-12-31'),
	(28200,'01','002',' 05','002057',2057,'Fobello','Fobello','','VC',1,'1840-01-01','2999-12-31'),
	(28201,'01','002',' 05','002058',2058,'Fontanetto Po','Fontanetto Po','','VC',1,'1840-01-01','2999-12-31'),
	(28202,'01','002',' 05','002059',2059,'Formigliana','Formigliana','','VC',1,'1840-01-01','2999-12-31'),
	(28203,'01','002',' 06','002061',2061,'Gattinara','Gattinara','','VC',1,'1840-01-01','2999-12-31'),
	(28204,'01','002',' 06','002062',2062,'Ghislarengo','Ghislarengo','','VC',1,'1840-01-01','2999-12-31'),
	(28205,'01','002',' 06','002065',2065,'Greggio','Greggio','','VC',1,'1840-01-01','2999-12-31'),
	(28206,'01','002',' 06','002066',2066,'Guardabosone','Guardabosone','','VC',1,'1840-01-01','2999-12-31'),
	(28207,'01','002',' 06','002067',2067,'Lamporo','Lamporo','','VC',1,'1840-01-01','2999-12-31'),
	(28208,'01','002',' 06','002068',2068,'Lenta','Lenta','','VC',1,'1840-01-01','2999-12-31'),
	(28209,'01','002',' 07','002070',2070,'Lignana','Lignana','','VC',1,'1840-01-01','2999-12-31'),
	(28210,'01','002',' 07','002071',2071,'Livorno Ferraris','Livorno Ferraris','','VC',1,'1840-01-01','2999-12-31'),
	(28211,'01','002',' 07','002072',2072,'Lozzolo','Lozzolo','','VC',1,'1840-01-01','2999-12-31'),
	(28212,'01','002',' 07','002078',2078,'Mollia','Mollia','','VC',1,'1840-01-01','2999-12-31'),
	(28213,'01','002',' 07','002079',2079,'Moncrivello','Moncrivello','','VC',1,'1840-01-01','2999-12-31'),
	(28214,'01','002',' 08','002082',2082,'Motta de\' Conti','Motta de\' Conti','','VC',1,'1840-01-01','2999-12-31'),
	(28215,'01','002',' 08','002088',2088,'Olcenengo','Olcenengo','','VC',1,'1840-01-01','2999-12-31'),
	(28216,'01','002',' 08','002089',2089,'Oldenico','Oldenico','','VC',1,'1840-01-01','2999-12-31'),
	(28217,'01','002',' 09','002090',2090,'Palazzolo Vercellese','Palazzolo Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28218,'01','002',' 09','002091',2091,'Pertengo','Pertengo','','VC',1,'1840-01-01','2999-12-31'),
	(28219,'01','002',' 09','002093',2093,'Pezzana','Pezzana','','VC',1,'1840-01-01','2999-12-31'),
	(28220,'01','002',' 09','002096',2096,'Pila','Pila','','VC',1,'1840-01-01','2999-12-31'),
	(28221,'01','002',' 09','002097',2097,'Piode','Piode','','VC',1,'1840-01-01','2999-12-31'),
	(28222,'01','002',' 10','002102',2102,'Postua','Postua','','VC',1,'1840-01-01','2999-12-31'),
	(28223,'01','002',' 10','002104',2104,'Prarolo','Prarolo','','VC',1,'1840-01-01','2999-12-31'),
	(28224,'01','002',' 10','002107',2107,'Quarona','Quarona','','VC',1,'1840-01-01','2999-12-31'),
	(28225,'01','002',' 10','002108',2108,'Quinto Vercellese','Quinto Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28226,'01','002',' 11','002110',2110,'Rassa','Rassa','','VC',1,'1840-01-01','2999-12-31'),
	(28227,'01','002',' 11','002111',2111,'Rima San Giuseppe','Rima San Giuseppe','','VC',1,'1840-01-01','2999-12-31'),
	(28228,'01','002',' 11','002112',2112,'Rimasco','Rimasco','','VC',1,'1840-01-01','2999-12-31'),
	(28229,'01','002',' 11','002113',2113,'Rimella','Rimella','','VC',1,'1840-01-01','2999-12-31'),
	(28230,'01','002',' 11','002114',2114,'Riva Valdobbia','Riva Valdobbia','','VC',1,'1840-01-01','2999-12-31'),
	(28231,'01','002',' 11','002115',2115,'Rive','Rive','','VC',1,'1840-01-01','2999-12-31'),
	(28232,'01','002',' 11','002116',2116,'Roasio','Roasio','','VC',1,'1840-01-01','2999-12-31'),
	(28233,'01','002',' 11','002118',2118,'Ronsecco','Ronsecco','','VC',1,'1840-01-01','2999-12-31'),
	(28234,'01','002',' 12','002121',2121,'Rossa','Rossa','','VC',1,'1840-01-01','2999-12-31'),
	(28235,'01','002',' 12','002122',2122,'Rovasenda','Rovasenda','','VC',1,'1840-01-01','2999-12-31'),
	(28236,'01','002',' 12','002123',2123,'Sabbia','Sabbia','','VC',1,'1840-01-01','2999-12-31'),
	(28237,'01','002',' 12','002126',2126,'Salasco','Salasco','','VC',1,'1840-01-01','2999-12-31'),
	(28238,'01','002',' 12','002127',2127,'Sali Vercellese','Sali Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28239,'01','002',' 12','002128',2128,'Saluggia','Saluggia','','VC',1,'1840-01-01','2999-12-31'),
	(28240,'01','002',' 13','002131',2131,'San Germano Vercellese','San Germano Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28241,'01','002',' 13','002133',2133,'Santhià','Santhià','','VC',1,'1840-01-01','2999-12-31'),
	(28242,'01','002',' 13','002134',2134,'Scopa','Scopa','','VC',1,'1840-01-01','2999-12-31'),
	(28243,'01','002',' 13','002135',2135,'Scopello','Scopello','','VC',1,'1840-01-01','2999-12-31'),
	(28244,'01','002',' 13','002137',2137,'Serravalle Sesia','Serravalle Sesia','','VC',1,'1840-01-01','2999-12-31'),
	(28245,'01','002',' 14','002142',2142,'Stroppiana','Stroppiana','','VC',1,'1840-01-01','2999-12-31'),
	(28246,'01','002',' 14','002147',2147,'Tricerro','Tricerro','','VC',1,'1840-01-01','2999-12-31'),
	(28247,'01','002',' 14','002148',2148,'Trino','Trino','','VC',1,'1840-01-01','2999-12-31'),
	(28248,'01','002',' 15','002150',2150,'Tronzano Vercellese','Tronzano Vercellese','','VC',1,'1840-01-01','2999-12-31'),
	(28249,'01','002',' 15','002152',2152,'Valduggia','Valduggia','','VC',1,'1840-01-01','2999-12-31'),
	(28250,'01','002',' 15','002156',2156,'Varallo','Varallo','','VC',1,'1840-01-01','2999-12-31'),
	(28251,'01','002',' 15','002158',2158,'Vercelli','Vercelli','','VC',1,'1840-01-01','2999-12-31'),
	(28252,'01','002',' 16','002163',2163,'Villarboit','Villarboit','','VC',1,'1840-01-01','2999-12-31'),
	(28253,'01','002',' 16','002164',2164,'Villata','Villata','','VC',1,'1840-01-01','2999-12-31'),
	(28254,'01','002',' 16','002166',2166,'Vocca','Vocca','','VC',1,'1840-01-01','2999-12-31'),
	(28255,'01','003',' 00','003001',3001,'Agrate Conturbia','Agrate Conturbia','','NO',1,'1840-01-01','2999-12-31'),
	(28256,'01','003',' 00','003002',3002,'Ameno','Ameno','','NO',1,'1840-01-01','2999-12-31'),
	(28257,'01','003',' 00','003006',3006,'Armeno','Armeno','','NO',1,'1840-01-01','2999-12-31'),
	(28258,'01','003',' 00','003008',3008,'Arona','Arona','','NO',1,'1840-01-01','2999-12-31'),
	(28259,'01','003',' 01','003012',3012,'Barengo','Barengo','','NO',1,'1840-01-01','2999-12-31'),
	(28260,'01','003',' 01','003016',3016,'Bellinzago Novarese','Bellinzago Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28261,'01','003',' 01','003018',3018,'Biandrate','Biandrate','','NO',1,'1840-01-01','2999-12-31'),
	(28262,'01','003',' 01','003019',3019,'Boca','Boca','','NO',1,'1840-01-01','2999-12-31'),
	(28263,'01','003',' 02','003021',3021,'Bogogno','Bogogno','','NO',1,'1840-01-01','2999-12-31'),
	(28264,'01','003',' 02','003022',3022,'Bolzano Novarese','Bolzano Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28265,'01','003',' 02','003023',3023,'Borgolavezzaro','Borgolavezzaro','','NO',1,'1840-01-01','2999-12-31'),
	(28266,'01','003',' 02','003024',3024,'Borgomanero','Borgomanero','','NO',1,'1840-01-01','2999-12-31'),
	(28267,'01','003',' 02','003025',3025,'Borgo Ticino','Borgo Ticino','','NO',1,'1840-01-01','2999-12-31'),
	(28268,'01','003',' 02','003026',3026,'Briga Novarese','Briga Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28269,'01','003',' 02','003027',3027,'Briona','Briona','','NO',1,'1840-01-01','2999-12-31'),
	(28270,'01','003',' 03','003030',3030,'Caltignaga','Caltignaga','','NO',1,'1840-01-01','2999-12-31'),
	(28271,'01','003',' 03','003032',3032,'Cameri','Cameri','','NO',1,'1840-01-01','2999-12-31'),
	(28272,'01','003',' 03','003036',3036,'Carpignano Sesia','Carpignano Sesia','','NO',1,'1840-01-01','2999-12-31'),
	(28273,'01','003',' 03','003037',3037,'Casalbeltrame','Casalbeltrame','','NO',1,'1840-01-01','2999-12-31'),
	(28274,'01','003',' 03','003039',3039,'Casaleggio Novara','Casaleggio Novara','','NO',1,'1840-01-01','2999-12-31'),
	(28275,'01','003',' 04','003040',3040,'Casalino','Casalino','','NO',1,'1840-01-01','2999-12-31'),
	(28276,'01','003',' 04','003041',3041,'Casalvolone','Casalvolone','','NO',1,'1840-01-01','2999-12-31'),
	(28277,'01','003',' 04','003042',3042,'Castellazzo Novarese','Castellazzo Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28278,'01','003',' 04','003043',3043,'Castelletto sopra Ticino','Castelletto sopra Ticino','','NO',1,'1840-01-01','2999-12-31'),
	(28279,'01','003',' 04','003044',3044,'Cavaglietto','Cavaglietto','','NO',1,'1840-01-01','2999-12-31'),
	(28280,'01','003',' 04','003045',3045,'Cavaglio d\'Agogna','Cavaglio d\'Agogna','','NO',1,'1840-01-01','2999-12-31'),
	(28281,'01','003',' 04','003047',3047,'Cavallirio','Cavallirio','','NO',1,'1840-01-01','2999-12-31'),
	(28282,'01','003',' 04','003049',3049,'Cerano','Cerano','','NO',1,'1840-01-01','2999-12-31'),
	(28283,'01','003',' 05','003051',3051,'Colazza','Colazza','','NO',1,'1840-01-01','2999-12-31'),
	(28284,'01','003',' 05','003052',3052,'Comignago','Comignago','','NO',1,'1840-01-01','2999-12-31'),
	(28285,'01','003',' 05','003055',3055,'Cressa','Cressa','','NO',1,'1840-01-01','2999-12-31'),
	(28286,'01','003',' 05','003058',3058,'Cureggio','Cureggio','','NO',1,'1840-01-01','2999-12-31'),
	(28287,'01','003',' 06','003060',3060,'Divignano','Divignano','','NO',1,'1840-01-01','2999-12-31'),
	(28288,'01','003',' 06','003062',3062,'Dormelletto','Dormelletto','','NO',1,'1840-01-01','2999-12-31'),
	(28289,'01','003',' 06','003065',3065,'Fara Novarese','Fara Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28290,'01','003',' 06','003066',3066,'Fontaneto d\'Agogna','Fontaneto d\'Agogna','','NO',1,'1840-01-01','2999-12-31'),
	(28291,'01','003',' 06','003068',3068,'Galliate','Galliate','','NO',1,'1840-01-01','2999-12-31'),
	(28292,'01','003',' 06','003069',3069,'Garbagna Novarese','Garbagna Novarese','','NO',1,'1840-01-01','2999-12-31'),
	(28293,'01','003',' 07','003070',3070,'Gargallo','Gargallo','','NO',1,'1840-01-01','2999-12-31'),
	(28294,'01','003',' 07','003071',3071,'Gattico','Gattico','','NO',1,'1840-01-01','2999-12-31'),
	(28295,'01','003',' 07','003073',3073,'Ghemme','Ghemme','','NO',1,'1840-01-01','2999-12-31'),
	(28296,'01','003',' 07','003076',3076,'Gozzano','Gozzano','','NO',1,'1840-01-01','2999-12-31'),
	(28297,'01','003',' 07','003077',3077,'Granozzo con Monticello','Granozzo con Monticello','','NO',1,'1840-01-01','2999-12-31'),
	(28298,'01','003',' 07','003079',3079,'Grignasco','Grignasco','','NO',1,'1840-01-01','2999-12-31'),
	(28299,'01','003',' 08','003082',3082,'Invorio','Invorio','','NO',1,'1840-01-01','2999-12-31'),
	(28300,'01','003',' 08','003083',3083,'Landiona','Landiona','','NO',1,'1840-01-01','2999-12-31'),
	(28301,'01','003',' 08','003084',3084,'Lesa','Lesa','','NO',1,'1840-01-01','2999-12-31'),
	(28302,'01','003',' 08','003088',3088,'Maggiora','Maggiora','','NO',1,'1840-01-01','2999-12-31'),
	(28303,'01','003',' 09','003090',3090,'Mandello Vitta','Mandello Vitta','','NO',1,'1840-01-01','2999-12-31'),
	(28304,'01','003',' 09','003091',3091,'Marano Ticino','Marano Ticino','','NO',1,'1840-01-01','2999-12-31'),
	(28305,'01','003',' 09','003093',3093,'Massino Visconti','Massino Visconti','','NO',1,'1840-01-01','2999-12-31'),
	(28306,'01','003',' 09','003095',3095,'Meina','Meina','','NO',1,'1840-01-01','2999-12-31'),
	(28307,'01','003',' 09','003097',3097,'Mezzomerico','Mezzomerico','','NO',1,'1840-01-01','2999-12-31'),
	(28308,'01','003',' 09','003098',3098,'Miasino','Miasino','','NO',1,'1840-01-01','2999-12-31'),
	(28309,'01','003',' 10','003100',3100,'Momo','Momo','','NO',1,'1840-01-01','2999-12-31'),
	(28310,'01','003',' 10','003103',3103,'Nebbiuno','Nebbiuno','','NO',1,'1840-01-01','2999-12-31'),
	(28311,'01','003',' 10','003104',3104,'Nibbiola','Nibbiola','','NO',1,'1840-01-01','2999-12-31'),
	(28312,'01','003',' 10','003106',3106,'Novara','Novara','','NO',1,'1840-01-01','2999-12-31'),
	(28313,'01','003',' 10','003108',3108,'Oleggio','Oleggio','','NO',1,'1840-01-01','2999-12-31'),
	(28314,'01','003',' 10','003109',3109,'Oleggio Castello','Oleggio Castello','','NO',1,'1840-01-01','2999-12-31'),
	(28315,'01','003',' 11','003112',3112,'Orta San Giulio','Orta San Giulio','','NO',1,'1840-01-01','2999-12-31'),
	(28316,'01','003',' 11','003114',3114,'Paruzzaro','Paruzzaro','','NO',1,'1840-01-01','2999-12-31'),
	(28317,'01','003',' 11','003115',3115,'Pella','Pella','','NO',1,'1840-01-01','2999-12-31'),
	(28318,'01','003',' 11','003116',3116,'Pettenasco','Pettenasco','','NO',1,'1840-01-01','2999-12-31'),
	(28319,'01','003',' 11','003119',3119,'Pisano','Pisano','','NO',1,'1840-01-01','2999-12-31'),
	(28320,'01','003',' 12','003120',3120,'Pogno','Pogno','','NO',1,'1840-01-01','2999-12-31'),
	(28321,'01','003',' 12','003121',3121,'Pombia','Pombia','','NO',1,'1840-01-01','2999-12-31'),
	(28322,'01','003',' 12','003122',3122,'Prato Sesia','Prato Sesia','','NO',1,'1840-01-01','2999-12-31'),
	(28323,'01','003',' 12','003129',3129,'Recetto','Recetto','','NO',1,'1840-01-01','2999-12-31'),
	(28324,'01','003',' 13','003130',3130,'Romagnano Sesia','Romagnano Sesia','','NO',1,'1840-01-01','2999-12-31'),
	(28325,'01','003',' 13','003131',3131,'Romentino','Romentino','','NO',1,'1840-01-01','2999-12-31'),
	(28326,'01','003',' 13','003133',3133,'San Maurizio d\'Opaglio','San Maurizio d\'Opaglio','','NO',1,'1840-01-01','2999-12-31'),
	(28327,'01','003',' 13','003134',3134,'San Nazzaro Sesia','San Nazzaro Sesia','','NO',1,'1840-01-01','2999-12-31'),
	(28328,'01','003',' 13','003135',3135,'San Pietro Mosezzo','San Pietro Mosezzo','','NO',1,'1840-01-01','2999-12-31'),
	(28329,'01','003',' 13','003138',3138,'Sillavengo','Sillavengo','','NO',1,'1840-01-01','2999-12-31'),
	(28330,'01','003',' 13','003139',3139,'Sizzano','Sizzano','','NO',1,'1840-01-01','2999-12-31'),
	(28331,'01','003',' 14','003140',3140,'Soriso','Soriso','','NO',1,'1840-01-01','2999-12-31'),
	(28332,'01','003',' 14','003141',3141,'Sozzago','Sozzago','','NO',1,'1840-01-01','2999-12-31'),
	(28333,'01','003',' 14','003143',3143,'Suno','Suno','','NO',1,'1840-01-01','2999-12-31'),
	(28334,'01','003',' 14','003144',3144,'Terdobbiate','Terdobbiate','','NO',1,'1840-01-01','2999-12-31'),
	(28335,'01','003',' 14','003146',3146,'Tornaco','Tornaco','','NO',1,'1840-01-01','2999-12-31'),
	(28336,'01','003',' 14','003149',3149,'Trecate','Trecate','','NO',1,'1840-01-01','2999-12-31'),
	(28337,'01','003',' 15','003153',3153,'Vaprio d\'Agogna','Vaprio d\'Agogna','','NO',1,'1840-01-01','2999-12-31'),
	(28338,'01','003',' 15','003154',3154,'Varallo Pombia','Varallo Pombia','','NO',1,'1840-01-01','2999-12-31'),
	(28339,'01','003',' 15','003157',3157,'Veruno','Veruno','','NO',1,'1840-01-01','2999-12-31'),
	(28340,'01','003',' 15','003158',3158,'Vespolate','Vespolate','','NO',1,'1840-01-01','2999-12-31'),
	(28341,'01','003',' 15','003159',3159,'Vicolungo','Vicolungo','','NO',1,'1840-01-01','2999-12-31'),
	(28342,'01','003',' 16','003164',3164,'Vinzaglio','Vinzaglio','','NO',1,'1840-01-01','2999-12-31'),
	(28343,'01','004',' 00','004001',4001,'Acceglio','Acceglio','','CN',1,'1840-01-01','2999-12-31'),
	(28344,'01','004',' 00','004002',4002,'Aisone','Aisone','','CN',1,'1840-01-01','2999-12-31'),
	(28345,'01','004',' 00','004003',4003,'Alba','Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28346,'01','004',' 00','004004',4004,'Albaretto della Torre','Albaretto della Torre','','CN',1,'1840-01-01','2999-12-31'),
	(28347,'01','004',' 00','004005',4005,'Alto','Alto','','CN',1,'1840-01-01','2999-12-31'),
	(28348,'01','004',' 00','004006',4006,'Argentera','Argentera','','CN',1,'1840-01-01','2999-12-31'),
	(28349,'01','004',' 00','004007',4007,'Arguello','Arguello','','CN',1,'1840-01-01','2999-12-31'),
	(28350,'01','004',' 00','004008',4008,'Bagnasco','Bagnasco','','CN',1,'1840-01-01','2999-12-31'),
	(28351,'01','004',' 00','004009',4009,'Bagnolo Piemonte','Bagnolo Piemonte','','CN',1,'1840-01-01','2999-12-31'),
	(28352,'01','004',' 01','004010',4010,'Baldissero d\'Alba','Baldissero d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28353,'01','004',' 01','004011',4011,'Barbaresco','Barbaresco','','CN',1,'1840-01-01','2999-12-31'),
	(28354,'01','004',' 01','004012',4012,'Barge','Barge','','CN',1,'1840-01-01','2999-12-31'),
	(28355,'01','004',' 01','004013',4013,'Barolo','Barolo','','CN',1,'1840-01-01','2999-12-31'),
	(28356,'01','004',' 01','004014',4014,'Bastia Mondovì','Bastia Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28357,'01','004',' 01','004015',4015,'Battifollo','Battifollo','','CN',1,'1840-01-01','2999-12-31'),
	(28358,'01','004',' 01','004016',4016,'Beinette','Beinette','','CN',1,'1840-01-01','2999-12-31'),
	(28359,'01','004',' 01','004017',4017,'Bellino','Bellino','','CN',1,'1840-01-01','2999-12-31'),
	(28360,'01','004',' 01','004018',4018,'Belvedere Langhe','Belvedere Langhe','','CN',1,'1840-01-01','2999-12-31'),
	(28361,'01','004',' 01','004019',4019,'Bene Vagienna','Bene Vagienna','','CN',1,'1840-01-01','2999-12-31'),
	(28362,'01','004',' 02','004020',4020,'Benevello','Benevello','','CN',1,'1840-01-01','2999-12-31'),
	(28363,'01','004',' 02','004021',4021,'Bergolo','Bergolo','','CN',1,'1840-01-01','2999-12-31'),
	(28364,'01','004',' 02','004022',4022,'Bernezzo','Bernezzo','','CN',1,'1840-01-01','2999-12-31'),
	(28365,'01','004',' 02','004023',4023,'Bonvicino','Bonvicino','','CN',1,'1840-01-01','2999-12-31'),
	(28366,'01','004',' 02','004024',4024,'Borgomale','Borgomale','','CN',1,'1840-01-01','2999-12-31'),
	(28367,'01','004',' 02','004025',4025,'Borgo San Dalmazzo','Borgo San Dalmazzo','','CN',1,'1840-01-01','2999-12-31'),
	(28368,'01','004',' 02','004026',4026,'Bosia','Bosia','','CN',1,'1840-01-01','2999-12-31'),
	(28369,'01','004',' 02','004027',4027,'Bossolasco','Bossolasco','','CN',1,'1840-01-01','2999-12-31'),
	(28370,'01','004',' 02','004028',4028,'Boves','Boves','','CN',1,'1840-01-01','2999-12-31'),
	(28371,'01','004',' 02','004029',4029,'Bra','Bra','','CN',1,'1840-01-01','2999-12-31'),
	(28372,'01','004',' 03','004030',4030,'Briaglia','Briaglia','','CN',1,'1840-01-01','2999-12-31'),
	(28373,'01','004',' 03','004031',4031,'Briga Alta','Briga Alta','','CN',1,'1840-01-01','2999-12-31'),
	(28374,'01','004',' 03','004032',4032,'Brondello','Brondello','','CN',1,'1840-01-01','2999-12-31'),
	(28375,'01','004',' 03','004033',4033,'Brossasco','Brossasco','','CN',1,'1840-01-01','2999-12-31'),
	(28376,'01','004',' 03','004034',4034,'Busca','Busca','','CN',1,'1840-01-01','2999-12-31'),
	(28377,'01','004',' 03','004035',4035,'Camerana','Camerana','','CN',1,'1840-01-01','2999-12-31'),
	(28378,'01','004',' 03','004036',4036,'Camo','Camo','','CN',1,'1840-01-01','2999-12-31'),
	(28379,'01','004',' 03','004037',4037,'Canale','Canale','','CN',1,'1840-01-01','2999-12-31'),
	(28380,'01','004',' 03','004038',4038,'Canosio','Canosio','','CN',1,'1840-01-01','2999-12-31'),
	(28381,'01','004',' 03','004039',4039,'Caprauna','Caprauna','','CN',1,'1840-01-01','2999-12-31'),
	(28382,'01','004',' 04','004040',4040,'Caraglio','Caraglio','','CN',1,'1840-01-01','2999-12-31'),
	(28383,'01','004',' 04','004041',4041,'Caramagna Piemonte','Caramagna Piemonte','','CN',1,'1840-01-01','2999-12-31'),
	(28384,'01','004',' 04','004042',4042,'Cardè','Cardè','','CN',1,'1840-01-01','2999-12-31'),
	(28385,'01','004',' 04','004043',4043,'Carrù','Carrù','','CN',1,'1840-01-01','2999-12-31'),
	(28386,'01','004',' 04','004044',4044,'Cartignano','Cartignano','','CN',1,'1840-01-01','2999-12-31'),
	(28387,'01','004',' 04','004045',4045,'Casalgrasso','Casalgrasso','','CN',1,'1840-01-01','2999-12-31'),
	(28388,'01','004',' 04','004046',4046,'Castagnito','Castagnito','','CN',1,'1840-01-01','2999-12-31'),
	(28389,'01','004',' 04','004047',4047,'Casteldelfino','Casteldelfino','','CN',1,'1840-01-01','2999-12-31'),
	(28390,'01','004',' 04','004048',4048,'Castellar','Castellar','','CN',1,'1840-01-01','2999-12-31'),
	(28391,'01','004',' 04','004049',4049,'Castelletto Stura','Castelletto Stura','','CN',1,'1840-01-01','2999-12-31'),
	(28392,'01','004',' 05','004050',4050,'Castelletto Uzzone','Castelletto Uzzone','','CN',1,'1840-01-01','2999-12-31'),
	(28393,'01','004',' 05','004051',4051,'Castellinaldo','Castellinaldo','','CN',1,'1840-01-01','2999-12-31'),
	(28394,'01','004',' 05','004052',4052,'Castellino Tanaro','Castellino Tanaro','','CN',1,'1840-01-01','2999-12-31'),
	(28395,'01','004',' 05','004053',4053,'Castelmagno','Castelmagno','','CN',1,'1840-01-01','2999-12-31'),
	(28396,'01','004',' 05','004054',4054,'Castelnuovo di Ceva','Castelnuovo di Ceva','','CN',1,'1840-01-01','2999-12-31'),
	(28397,'01','004',' 05','004055',4055,'Castiglione Falletto','Castiglione Falletto','','CN',1,'1840-01-01','2999-12-31'),
	(28398,'01','004',' 05','004056',4056,'Castiglione Tinella','Castiglione Tinella','','CN',1,'1840-01-01','2999-12-31'),
	(28399,'01','004',' 05','004057',4057,'Castino','Castino','','CN',1,'1840-01-01','2999-12-31'),
	(28400,'01','004',' 05','004058',4058,'Cavallerleone','Cavallerleone','','CN',1,'1840-01-01','2999-12-31'),
	(28401,'01','004',' 05','004059',4059,'Cavallermaggiore','Cavallermaggiore','','CN',1,'1840-01-01','2999-12-31'),
	(28402,'01','004',' 06','004060',4060,'Celle di Macra','Celle di Macra','','CN',1,'1840-01-01','2999-12-31'),
	(28403,'01','004',' 06','004061',4061,'Centallo','Centallo','','CN',1,'1840-01-01','2999-12-31'),
	(28404,'01','004',' 06','004062',4062,'Ceresole Alba','Ceresole Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28405,'01','004',' 06','004063',4063,'Cerretto Langhe','Cerretto Langhe','','CN',1,'1840-01-01','2999-12-31'),
	(28406,'01','004',' 06','004064',4064,'Cervasca','Cervasca','','CN',1,'1840-01-01','2999-12-31'),
	(28407,'01','004',' 06','004065',4065,'Cervere','Cervere','','CN',1,'1840-01-01','2999-12-31'),
	(28408,'01','004',' 06','004066',4066,'Ceva','Ceva','','CN',1,'1840-01-01','2999-12-31'),
	(28409,'01','004',' 06','004067',4067,'Cherasco','Cherasco','','CN',1,'1840-01-01','2999-12-31'),
	(28410,'01','004',' 06','004068',4068,'Chiusa di Pesio','Chiusa di Pesio','','CN',1,'1840-01-01','2999-12-31'),
	(28411,'01','004',' 06','004069',4069,'Cigliè','Cigliè','','CN',1,'1840-01-01','2999-12-31'),
	(28412,'01','004',' 07','004070',4070,'Cissone','Cissone','','CN',1,'1840-01-01','2999-12-31'),
	(28413,'01','004',' 07','004071',4071,'Clavesana','Clavesana','','CN',1,'1840-01-01','2999-12-31'),
	(28414,'01','004',' 07','004072',4072,'Corneliano d\'Alba','Corneliano d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28415,'01','004',' 07','004073',4073,'Cortemilia','Cortemilia','','CN',1,'1840-01-01','2999-12-31'),
	(28416,'01','004',' 07','004074',4074,'Cossano Belbo','Cossano Belbo','','CN',1,'1840-01-01','2999-12-31'),
	(28417,'01','004',' 07','004075',4075,'Costigliole Saluzzo','Costigliole Saluzzo','','CN',1,'1840-01-01','2999-12-31'),
	(28418,'01','004',' 07','004076',4076,'Cravanzana','Cravanzana','','CN',1,'1840-01-01','2999-12-31'),
	(28419,'01','004',' 07','004077',4077,'Crissolo','Crissolo','','CN',1,'1840-01-01','2999-12-31'),
	(28420,'01','004',' 07','004078',4078,'Cuneo','Cuneo','','CN',1,'1840-01-01','2999-12-31'),
	(28421,'01','004',' 07','004079',4079,'Demonte','Demonte','','CN',1,'1840-01-01','2999-12-31'),
	(28422,'01','004',' 08','004080',4080,'Diano d\'Alba','Diano d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28423,'01','004',' 08','004081',4081,'Dogliani','Dogliani','','CN',1,'1840-01-01','2999-12-31'),
	(28424,'01','004',' 08','004082',4082,'Dronero','Dronero','','CN',1,'1840-01-01','2999-12-31'),
	(28425,'01','004',' 08','004083',4083,'Elva','Elva','','CN',1,'1840-01-01','2999-12-31'),
	(28426,'01','004',' 08','004084',4084,'Entracque','Entracque','','CN',1,'1840-01-01','2999-12-31'),
	(28427,'01','004',' 08','004085',4085,'Envie','Envie','','CN',1,'1840-01-01','2999-12-31'),
	(28428,'01','004',' 08','004086',4086,'Farigliano','Farigliano','','CN',1,'1840-01-01','2999-12-31'),
	(28429,'01','004',' 08','004087',4087,'Faule','Faule','','CN',1,'1840-01-01','2999-12-31'),
	(28430,'01','004',' 08','004088',4088,'Feisoglio','Feisoglio','','CN',1,'1840-01-01','2999-12-31'),
	(28431,'01','004',' 08','004089',4089,'Fossano','Fossano','','CN',1,'1840-01-01','2999-12-31'),
	(28432,'01','004',' 09','004090',4090,'Frabosa Soprana','Frabosa Soprana','','CN',1,'1840-01-01','2999-12-31'),
	(28433,'01','004',' 09','004091',4091,'Frabosa Sottana','Frabosa Sottana','','CN',1,'1840-01-01','2999-12-31'),
	(28434,'01','004',' 09','004092',4092,'Frassino','Frassino','','CN',1,'1840-01-01','2999-12-31'),
	(28435,'01','004',' 09','004093',4093,'Gaiola','Gaiola','','CN',1,'1840-01-01','2999-12-31'),
	(28436,'01','004',' 09','004094',4094,'Gambasca','Gambasca','','CN',1,'1840-01-01','2999-12-31'),
	(28437,'01','004',' 09','004095',4095,'Garessio','Garessio','','CN',1,'1840-01-01','2999-12-31'),
	(28438,'01','004',' 09','004096',4096,'Genola','Genola','','CN',1,'1840-01-01','2999-12-31'),
	(28439,'01','004',' 09','004097',4097,'Gorzegno','Gorzegno','','CN',1,'1840-01-01','2999-12-31'),
	(28440,'01','004',' 09','004098',4098,'Gottasecca','Gottasecca','','CN',1,'1840-01-01','2999-12-31'),
	(28441,'01','004',' 09','004099',4099,'Govone','Govone','','CN',1,'1840-01-01','2999-12-31'),
	(28442,'01','004',' 10','004100',4100,'Grinzane Cavour','Grinzane Cavour','','CN',1,'1840-01-01','2999-12-31'),
	(28443,'01','004',' 10','004101',4101,'Guarene','Guarene','','CN',1,'1840-01-01','2999-12-31'),
	(28444,'01','004',' 10','004102',4102,'Igliano','Igliano','','CN',1,'1840-01-01','2999-12-31'),
	(28445,'01','004',' 10','004103',4103,'Isasca','Isasca','','CN',1,'1840-01-01','2999-12-31'),
	(28446,'01','004',' 10','004104',4104,'Lagnasco','Lagnasco','','CN',1,'1840-01-01','2999-12-31'),
	(28447,'01','004',' 10','004105',4105,'La Morra','La Morra','','CN',1,'1840-01-01','2999-12-31'),
	(28448,'01','004',' 10','004106',4106,'Lequio Berria','Lequio Berria','','CN',1,'1840-01-01','2999-12-31'),
	(28449,'01','004',' 10','004107',4107,'Lequio Tanaro','Lequio Tanaro','','CN',1,'1840-01-01','2999-12-31'),
	(28450,'01','004',' 10','004108',4108,'Lesegno','Lesegno','','CN',1,'1840-01-01','2999-12-31'),
	(28451,'01','004',' 10','004109',4109,'Levice','Levice','','CN',1,'1840-01-01','2999-12-31'),
	(28452,'01','004',' 11','004110',4110,'Limone Piemonte','Limone Piemonte','','CN',1,'1840-01-01','2999-12-31'),
	(28453,'01','004',' 11','004111',4111,'Lisio','Lisio','','CN',1,'1840-01-01','2999-12-31'),
	(28454,'01','004',' 11','004112',4112,'Macra','Macra','','CN',1,'1840-01-01','2999-12-31'),
	(28455,'01','004',' 11','004113',4113,'Magliano Alfieri','Magliano Alfieri','','CN',1,'1840-01-01','2999-12-31'),
	(28456,'01','004',' 11','004114',4114,'Magliano Alpi','Magliano Alpi','','CN',1,'1840-01-01','2999-12-31'),
	(28457,'01','004',' 11','004115',4115,'Mango','Mango','','CN',1,'1840-01-01','2999-12-31'),
	(28458,'01','004',' 11','004116',4116,'Manta','Manta','','CN',1,'1840-01-01','2999-12-31'),
	(28459,'01','004',' 11','004117',4117,'Marene','Marene','','CN',1,'1840-01-01','2999-12-31'),
	(28460,'01','004',' 11','004118',4118,'Margarita','Margarita','','CN',1,'1840-01-01','2999-12-31'),
	(28461,'01','004',' 11','004119',4119,'Marmora','Marmora','','CN',1,'1840-01-01','2999-12-31'),
	(28462,'01','004',' 12','004120',4120,'Marsaglia','Marsaglia','','CN',1,'1840-01-01','2999-12-31'),
	(28463,'01','004',' 12','004121',4121,'Martiniana Po','Martiniana Po','','CN',1,'1840-01-01','2999-12-31'),
	(28464,'01','004',' 12','004122',4122,'Melle','Melle','','CN',1,'1840-01-01','2999-12-31'),
	(28465,'01','004',' 12','004123',4123,'Moiola','Moiola','','CN',1,'1840-01-01','2999-12-31'),
	(28466,'01','004',' 12','004124',4124,'Mombarcaro','Mombarcaro','','CN',1,'1840-01-01','2999-12-31'),
	(28467,'01','004',' 12','004125',4125,'Mombasiglio','Mombasiglio','','CN',1,'1840-01-01','2999-12-31'),
	(28468,'01','004',' 12','004126',4126,'Monastero di Vasco','Monastero di Vasco','','CN',1,'1840-01-01','2999-12-31'),
	(28469,'01','004',' 12','004127',4127,'Monasterolo Casotto','Monasterolo Casotto','','CN',1,'1840-01-01','2999-12-31'),
	(28470,'01','004',' 12','004128',4128,'Monasterolo di Savigliano','Monasterolo di Savigliano','','CN',1,'1840-01-01','2999-12-31'),
	(28471,'01','004',' 12','004129',4129,'Monchiero','Monchiero','','CN',1,'1840-01-01','2999-12-31'),
	(28472,'01','004',' 13','004130',4130,'Mondovì','Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28473,'01','004',' 13','004131',4131,'Monesiglio','Monesiglio','','CN',1,'1840-01-01','2999-12-31'),
	(28474,'01','004',' 13','004132',4132,'Monforte d\'Alba','Monforte d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28475,'01','004',' 13','004133',4133,'Montà','Montà','','CN',1,'1840-01-01','2999-12-31'),
	(28476,'01','004',' 13','004134',4134,'Montaldo di Mondovì','Montaldo di Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28477,'01','004',' 13','004135',4135,'Montaldo Roero','Montaldo Roero','','CN',1,'1840-01-01','2999-12-31'),
	(28478,'01','004',' 13','004136',4136,'Montanera','Montanera','','CN',1,'1840-01-01','2999-12-31'),
	(28479,'01','004',' 13','004137',4137,'Montelupo Albese','Montelupo Albese','','CN',1,'1840-01-01','2999-12-31'),
	(28480,'01','004',' 13','004138',4138,'Montemale di Cuneo','Montemale di Cuneo','','CN',1,'1840-01-01','2999-12-31'),
	(28481,'01','004',' 13','004139',4139,'Monterosso Grana','Monterosso Grana','','CN',1,'1840-01-01','2999-12-31'),
	(28482,'01','004',' 14','004140',4140,'Monteu Roero','Monteu Roero','','CN',1,'1840-01-01','2999-12-31'),
	(28483,'01','004',' 14','004141',4141,'Montezemolo','Montezemolo','','CN',1,'1840-01-01','2999-12-31'),
	(28484,'01','004',' 14','004142',4142,'Monticello d\'Alba','Monticello d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28485,'01','004',' 14','004143',4143,'Moretta','Moretta','','CN',1,'1840-01-01','2999-12-31'),
	(28486,'01','004',' 14','004144',4144,'Morozzo','Morozzo','','CN',1,'1840-01-01','2999-12-31'),
	(28487,'01','004',' 14','004145',4145,'Murazzano','Murazzano','','CN',1,'1840-01-01','2999-12-31'),
	(28488,'01','004',' 14','004146',4146,'Murello','Murello','','CN',1,'1840-01-01','2999-12-31'),
	(28489,'01','004',' 14','004147',4147,'Narzole','Narzole','','CN',1,'1840-01-01','2999-12-31'),
	(28490,'01','004',' 14','004148',4148,'Neive','Neive','','CN',1,'1840-01-01','2999-12-31'),
	(28491,'01','004',' 14','004149',4149,'Neviglie','Neviglie','','CN',1,'1840-01-01','2999-12-31'),
	(28492,'01','004',' 15','004150',4150,'Niella Belbo','Niella Belbo','','CN',1,'1840-01-01','2999-12-31'),
	(28493,'01','004',' 15','004151',4151,'Niella Tanaro','Niella Tanaro','','CN',1,'1840-01-01','2999-12-31'),
	(28494,'01','004',' 15','004152',4152,'Novello','Novello','','CN',1,'1840-01-01','2999-12-31'),
	(28495,'01','004',' 15','004153',4153,'Nucetto','Nucetto','','CN',1,'1840-01-01','2999-12-31'),
	(28496,'01','004',' 15','004154',4154,'Oncino','Oncino','','CN',1,'1840-01-01','2999-12-31'),
	(28497,'01','004',' 15','004155',4155,'Ormea','Ormea','','CN',1,'1840-01-01','2999-12-31'),
	(28498,'01','004',' 15','004156',4156,'Ostana','Ostana','','CN',1,'1840-01-01','2999-12-31'),
	(28499,'01','004',' 15','004157',4157,'Paesana','Paesana','','CN',1,'1840-01-01','2999-12-31'),
	(28500,'01','004',' 15','004158',4158,'Pagno','Pagno','','CN',1,'1840-01-01','2999-12-31'),
	(28501,'01','004',' 15','004159',4159,'Pamparato','Pamparato','','CN',1,'1840-01-01','2999-12-31'),
	(28502,'01','004',' 16','004160',4160,'Paroldo','Paroldo','','CN',1,'1840-01-01','2999-12-31'),
	(28503,'01','004',' 16','004161',4161,'Perletto','Perletto','','CN',1,'1840-01-01','2999-12-31'),
	(28504,'01','004',' 16','004162',4162,'Perlo','Perlo','','CN',1,'1840-01-01','2999-12-31'),
	(28505,'01','004',' 16','004163',4163,'Peveragno','Peveragno','','CN',1,'1840-01-01','2999-12-31'),
	(28506,'01','004',' 16','004164',4164,'Pezzolo Valle Uzzone','Pezzolo Valle Uzzone','','CN',1,'1840-01-01','2999-12-31'),
	(28507,'01','004',' 16','004165',4165,'Pianfei','Pianfei','','CN',1,'1840-01-01','2999-12-31'),
	(28508,'01','004',' 16','004166',4166,'Piasco','Piasco','','CN',1,'1840-01-01','2999-12-31'),
	(28509,'01','004',' 16','004167',4167,'Pietraporzio','Pietraporzio','','CN',1,'1840-01-01','2999-12-31'),
	(28510,'01','004',' 16','004168',4168,'Piobesi d\'Alba','Piobesi d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28511,'01','004',' 16','004169',4169,'Piozzo','Piozzo','','CN',1,'1840-01-01','2999-12-31'),
	(28512,'01','004',' 17','004170',4170,'Pocapaglia','Pocapaglia','','CN',1,'1840-01-01','2999-12-31'),
	(28513,'01','004',' 17','004171',4171,'Polonghera','Polonghera','','CN',1,'1840-01-01','2999-12-31'),
	(28514,'01','004',' 17','004172',4172,'Pontechianale','Pontechianale','','CN',1,'1840-01-01','2999-12-31'),
	(28515,'01','004',' 17','004173',4173,'Pradleves','Pradleves','','CN',1,'1840-01-01','2999-12-31'),
	(28516,'01','004',' 17','004174',4174,'Prazzo','Prazzo','','CN',1,'1840-01-01','2999-12-31'),
	(28517,'01','004',' 17','004175',4175,'Priero','Priero','','CN',1,'1840-01-01','2999-12-31'),
	(28518,'01','004',' 17','004176',4176,'Priocca','Priocca','','CN',1,'1840-01-01','2999-12-31'),
	(28519,'01','004',' 17','004177',4177,'Priola','Priola','','CN',1,'1840-01-01','2999-12-31'),
	(28520,'01','004',' 17','004178',4178,'Prunetto','Prunetto','','CN',1,'1840-01-01','2999-12-31'),
	(28521,'01','004',' 17','004179',4179,'Racconigi','Racconigi','','CN',1,'1840-01-01','2999-12-31'),
	(28522,'01','004',' 18','004180',4180,'Revello','Revello','','CN',1,'1840-01-01','2999-12-31'),
	(28523,'01','004',' 18','004181',4181,'Rifreddo','Rifreddo','','CN',1,'1840-01-01','2999-12-31'),
	(28524,'01','004',' 18','004182',4182,'Rittana','Rittana','','CN',1,'1840-01-01','2999-12-31'),
	(28525,'01','004',' 18','004183',4183,'Roaschia','Roaschia','','CN',1,'1840-01-01','2999-12-31'),
	(28526,'01','004',' 18','004184',4184,'Roascio','Roascio','','CN',1,'1840-01-01','2999-12-31'),
	(28527,'01','004',' 18','004185',4185,'Robilante','Robilante','','CN',1,'1840-01-01','2999-12-31'),
	(28528,'01','004',' 18','004186',4186,'Roburent','Roburent','','CN',1,'1840-01-01','2999-12-31'),
	(28529,'01','004',' 18','004187',4187,'Roccabruna','Roccabruna','','CN',1,'1840-01-01','2999-12-31'),
	(28530,'01','004',' 18','004188',4188,'Rocca Cigliè','Rocca Cigliè','','CN',1,'1840-01-01','2999-12-31'),
	(28531,'01','004',' 18','004189',4189,'Rocca de\' Baldi','Rocca de\' Baldi','','CN',1,'1840-01-01','2999-12-31'),
	(28532,'01','004',' 19','004190',4190,'Roccaforte Mondovì','Roccaforte Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28533,'01','004',' 19','004191',4191,'Roccasparvera','Roccasparvera','','CN',1,'1840-01-01','2999-12-31'),
	(28534,'01','004',' 19','004192',4192,'Roccavione','Roccavione','','CN',1,'1840-01-01','2999-12-31'),
	(28535,'01','004',' 19','004193',4193,'Rocchetta Belbo','Rocchetta Belbo','','CN',1,'1840-01-01','2999-12-31'),
	(28536,'01','004',' 19','004194',4194,'Roddi','Roddi','','CN',1,'1840-01-01','2999-12-31'),
	(28537,'01','004',' 19','004195',4195,'Roddino','Roddino','','CN',1,'1840-01-01','2999-12-31'),
	(28538,'01','004',' 19','004196',4196,'Rodello','Rodello','','CN',1,'1840-01-01','2999-12-31'),
	(28539,'01','004',' 19','004197',4197,'Rossana','Rossana','','CN',1,'1840-01-01','2999-12-31'),
	(28540,'01','004',' 19','004198',4198,'Ruffia','Ruffia','','CN',1,'1840-01-01','2999-12-31'),
	(28541,'01','004',' 19','004199',4199,'Sale delle Langhe','Sale delle Langhe','','CN',1,'1840-01-01','2999-12-31'),
	(28542,'01','004',' 20','004200',4200,'Sale San Giovanni','Sale San Giovanni','','CN',1,'1840-01-01','2999-12-31'),
	(28543,'01','004',' 20','004201',4201,'Saliceto','Saliceto','','CN',1,'1840-01-01','2999-12-31'),
	(28544,'01','004',' 20','004202',4202,'Salmour','Salmour','','CN',1,'1840-01-01','2999-12-31'),
	(28545,'01','004',' 20','004203',4203,'Saluzzo','Saluzzo','','CN',1,'1840-01-01','2999-12-31'),
	(28546,'01','004',' 20','004204',4204,'Sambuco','Sambuco','','CN',1,'1840-01-01','2999-12-31'),
	(28547,'01','004',' 20','004205',4205,'Sampeyre','Sampeyre','','CN',1,'1840-01-01','2999-12-31'),
	(28548,'01','004',' 20','004206',4206,'San Benedetto Belbo','San Benedetto Belbo','','CN',1,'1840-01-01','2999-12-31'),
	(28549,'01','004',' 20','004207',4207,'San Damiano Macra','San Damiano Macra','','CN',1,'1840-01-01','2999-12-31'),
	(28550,'01','004',' 20','004208',4208,'Sanfrè','Sanfrè','','CN',1,'1840-01-01','2999-12-31'),
	(28551,'01','004',' 20','004209',4209,'Sanfront','Sanfront','','CN',1,'1840-01-01','2999-12-31'),
	(28552,'01','004',' 21','004210',4210,'San Michele Mondovì','San Michele Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28553,'01','004',' 21','004211',4211,'Sant\'Albano Stura','Sant\'Albano Stura','','CN',1,'1840-01-01','2999-12-31'),
	(28554,'01','004',' 21','004212',4212,'Santa Vittoria d\'Alba','Santa Vittoria d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28555,'01','004',' 21','004213',4213,'Santo Stefano Belbo','Santo Stefano Belbo','','CN',1,'1840-01-01','2999-12-31'),
	(28556,'01','004',' 21','004214',4214,'Santo Stefano Roero','Santo Stefano Roero','','CN',1,'1840-01-01','2999-12-31'),
	(28557,'01','004',' 21','004215',4215,'Savigliano','Savigliano','','CN',1,'1840-01-01','2999-12-31'),
	(28558,'01','004',' 21','004216',4216,'Scagnello','Scagnello','','CN',1,'1840-01-01','2999-12-31'),
	(28559,'01','004',' 21','004217',4217,'Scarnafigi','Scarnafigi','','CN',1,'1840-01-01','2999-12-31'),
	(28560,'01','004',' 21','004218',4218,'Serralunga d\'Alba','Serralunga d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28561,'01','004',' 21','004219',4219,'Serravalle Langhe','Serravalle Langhe','','CN',1,'1840-01-01','2999-12-31'),
	(28562,'01','004',' 22','004220',4220,'Sinio','Sinio','','CN',1,'1840-01-01','2999-12-31'),
	(28563,'01','004',' 22','004221',4221,'Somano','Somano','','CN',1,'1840-01-01','2999-12-31'),
	(28564,'01','004',' 22','004222',4222,'Sommariva del Bosco','Sommariva del Bosco','','CN',1,'1840-01-01','2999-12-31'),
	(28565,'01','004',' 22','004223',4223,'Sommariva Perno','Sommariva Perno','','CN',1,'1840-01-01','2999-12-31'),
	(28566,'01','004',' 22','004224',4224,'Stroppo','Stroppo','','CN',1,'1840-01-01','2999-12-31'),
	(28567,'01','004',' 22','004225',4225,'Tarantasca','Tarantasca','','CN',1,'1840-01-01','2999-12-31'),
	(28568,'01','004',' 22','004226',4226,'Torre Bormida','Torre Bormida','','CN',1,'1840-01-01','2999-12-31'),
	(28569,'01','004',' 22','004227',4227,'Torre Mondovì','Torre Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28570,'01','004',' 22','004228',4228,'Torre San Giorgio','Torre San Giorgio','','CN',1,'1840-01-01','2999-12-31'),
	(28571,'01','004',' 22','004229',4229,'Torresina','Torresina','','CN',1,'1840-01-01','2999-12-31'),
	(28572,'01','004',' 23','004230',4230,'Treiso','Treiso','','CN',1,'1840-01-01','2999-12-31'),
	(28573,'01','004',' 23','004231',4231,'Trezzo Tinella','Trezzo Tinella','','CN',1,'1840-01-01','2999-12-31'),
	(28574,'01','004',' 23','004232',4232,'Trinità','Trinità','','CN',1,'1840-01-01','2999-12-31'),
	(28575,'01','004',' 23','004233',4233,'Valdieri','Valdieri','','CN',1,'1840-01-01','2999-12-31'),
	(28576,'01','004',' 23','004234',4234,'Valgrana','Valgrana','','CN',1,'1840-01-01','2999-12-31'),
	(28577,'01','004',' 23','004235',4235,'Valloriate','Valloriate','','CN',1,'1840-01-01','2999-12-31'),
	(28578,'01','004',' 23','004236',4236,'Valmala','Valmala','','CN',1,'1840-01-01','2999-12-31'),
	(28579,'01','004',' 23','004237',4237,'Venasca','Venasca','','CN',1,'1840-01-01','2999-12-31'),
	(28580,'01','004',' 23','004238',4238,'Verduno','Verduno','','CN',1,'1840-01-01','2999-12-31'),
	(28581,'01','004',' 23','004239',4239,'Vernante','Vernante','','CN',1,'1840-01-01','2999-12-31'),
	(28582,'01','004',' 24','004240',4240,'Verzuolo','Verzuolo','','CN',1,'1840-01-01','2999-12-31'),
	(28583,'01','004',' 24','004241',4241,'Vezza d\'Alba','Vezza d\'Alba','','CN',1,'1840-01-01','2999-12-31'),
	(28584,'01','004',' 24','004242',4242,'Vicoforte','Vicoforte','','CN',1,'1840-01-01','2999-12-31'),
	(28585,'01','004',' 24','004243',4243,'Vignolo','Vignolo','','CN',1,'1840-01-01','2999-12-31'),
	(28586,'01','004',' 24','004244',4244,'Villafalletto','Villafalletto','','CN',1,'1840-01-01','2999-12-31'),
	(28587,'01','004',' 24','004245',4245,'Villanova Mondovì','Villanova Mondovì','','CN',1,'1840-01-01','2999-12-31'),
	(28588,'01','004',' 24','004246',4246,'Villanova Solaro','Villanova Solaro','','CN',1,'1840-01-01','2999-12-31'),
	(28589,'01','004',' 24','004247',4247,'Villar San Costanzo','Villar San Costanzo','','CN',1,'1840-01-01','2999-12-31'),
	(28590,'01','004',' 24','004248',4248,'Vinadio','Vinadio','','CN',1,'1840-01-01','2999-12-31'),
	(28591,'01','004',' 24','004249',4249,'Viola','Viola','','CN',1,'1840-01-01','2999-12-31'),
	(28592,'01','004',' 25','004250',4250,'Vottignasco','Vottignasco','','CN',1,'1840-01-01','2999-12-31'),
	(28593,'01','005',' 00','005001',5001,'Agliano Terme','Agliano Terme','','AT',1,'1840-01-01','2999-12-31'),
	(28594,'01','005',' 00','005002',5002,'Albugnano','Albugnano','','AT',1,'1840-01-01','2999-12-31'),
	(28595,'01','005',' 00','005003',5003,'Antignano','Antignano','','AT',1,'1840-01-01','2999-12-31'),
	(28596,'01','005',' 00','005004',5004,'Aramengo','Aramengo','','AT',1,'1840-01-01','2999-12-31'),
	(28597,'01','005',' 00','005005',5005,'Asti','Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28598,'01','005',' 00','005006',5006,'Azzano d\'Asti','Azzano d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28599,'01','005',' 00','005007',5007,'Baldichieri d\'Asti','Baldichieri d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28600,'01','005',' 00','005008',5008,'Belveglio','Belveglio','','AT',1,'1840-01-01','2999-12-31'),
	(28601,'01','005',' 00','005009',5009,'Berzano di San Pietro','Berzano di San Pietro','','AT',1,'1840-01-01','2999-12-31'),
	(28602,'01','005',' 01','005010',5010,'Bruno','Bruno','','AT',1,'1840-01-01','2999-12-31'),
	(28603,'01','005',' 01','005011',5011,'Bubbio','Bubbio','','AT',1,'1840-01-01','2999-12-31'),
	(28604,'01','005',' 01','005012',5012,'Buttigliera d\'Asti','Buttigliera d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28605,'01','005',' 01','005013',5013,'Calamandrana','Calamandrana','','AT',1,'1840-01-01','2999-12-31'),
	(28606,'01','005',' 01','005014',5014,'Calliano','Calliano','','AT',1,'1840-01-01','2999-12-31'),
	(28607,'01','005',' 01','005015',5015,'Calosso','Calosso','','AT',1,'1840-01-01','2999-12-31'),
	(28608,'01','005',' 01','005016',5016,'Camerano Casasco','Camerano Casasco','','AT',1,'1840-01-01','2999-12-31'),
	(28609,'01','005',' 01','005017',5017,'Canelli','Canelli','','AT',1,'1840-01-01','2999-12-31'),
	(28610,'01','005',' 01','005018',5018,'Cantarana','Cantarana','','AT',1,'1840-01-01','2999-12-31'),
	(28611,'01','005',' 01','005019',5019,'Capriglio','Capriglio','','AT',1,'1840-01-01','2999-12-31'),
	(28612,'01','005',' 02','005020',5020,'Casorzo','Casorzo','','AT',1,'1840-01-01','2999-12-31'),
	(28613,'01','005',' 02','005021',5021,'Cassinasco','Cassinasco','','AT',1,'1840-01-01','2999-12-31'),
	(28614,'01','005',' 02','005022',5022,'Castagnole delle Lanze','Castagnole delle Lanze','','AT',1,'1840-01-01','2999-12-31'),
	(28615,'01','005',' 02','005023',5023,'Castagnole Monferrato','Castagnole Monferrato','','AT',1,'1840-01-01','2999-12-31'),
	(28616,'01','005',' 02','005024',5024,'Castel Boglione','Castel Boglione','','AT',1,'1840-01-01','2999-12-31'),
	(28617,'01','005',' 02','005025',5025,'Castell\'Alfero','Castell\'Alfero','','AT',1,'1840-01-01','2999-12-31'),
	(28618,'01','005',' 02','005026',5026,'Castellero','Castellero','','AT',1,'1840-01-01','2999-12-31'),
	(28619,'01','005',' 02','005027',5027,'Castelletto Molina','Castelletto Molina','','AT',1,'1840-01-01','2999-12-31'),
	(28620,'01','005',' 02','005028',5028,'Castello di Annone','Castello di Annone','','AT',1,'1840-01-01','2999-12-31'),
	(28621,'01','005',' 02','005029',5029,'Castelnuovo Belbo','Castelnuovo Belbo','','AT',1,'1840-01-01','2999-12-31'),
	(28622,'01','005',' 03','005030',5030,'Castelnuovo Calcea','Castelnuovo Calcea','','AT',1,'1840-01-01','2999-12-31'),
	(28623,'01','005',' 03','005031',5031,'Castelnuovo Don Bosco','Castelnuovo Don Bosco','','AT',1,'1840-01-01','2999-12-31'),
	(28624,'01','005',' 03','005032',5032,'Castel Rocchero','Castel Rocchero','','AT',1,'1840-01-01','2999-12-31'),
	(28625,'01','005',' 03','005033',5033,'Cellarengo','Cellarengo','','AT',1,'1840-01-01','2999-12-31'),
	(28626,'01','005',' 03','005034',5034,'Celle Enomondo','Celle Enomondo','','AT',1,'1840-01-01','2999-12-31'),
	(28627,'01','005',' 03','005035',5035,'Cerreto d\'Asti','Cerreto d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28628,'01','005',' 03','005036',5036,'Cerro Tanaro','Cerro Tanaro','','AT',1,'1840-01-01','2999-12-31'),
	(28629,'01','005',' 03','005037',5037,'Cessole','Cessole','','AT',1,'1840-01-01','2999-12-31'),
	(28630,'01','005',' 03','005038',5038,'Chiusano d\'Asti','Chiusano d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28631,'01','005',' 03','005039',5039,'Cinaglio','Cinaglio','','AT',1,'1840-01-01','2999-12-31'),
	(28632,'01','005',' 04','005040',5040,'Cisterna d\'Asti','Cisterna d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28633,'01','005',' 04','005041',5041,'Coazzolo','Coazzolo','','AT',1,'1840-01-01','2999-12-31'),
	(28634,'01','005',' 04','005042',5042,'Cocconato','Cocconato','','AT',1,'1840-01-01','2999-12-31'),
	(28635,'01','005',' 04','005044',5044,'Corsione','Corsione','','AT',1,'1840-01-01','2999-12-31'),
	(28636,'01','005',' 04','005045',5045,'Cortandone','Cortandone','','AT',1,'1840-01-01','2999-12-31'),
	(28637,'01','005',' 04','005046',5046,'Cortanze','Cortanze','','AT',1,'1840-01-01','2999-12-31'),
	(28638,'01','005',' 04','005047',5047,'Cortazzone','Cortazzone','','AT',1,'1840-01-01','2999-12-31'),
	(28639,'01','005',' 04','005048',5048,'Cortiglione','Cortiglione','','AT',1,'1840-01-01','2999-12-31'),
	(28640,'01','005',' 04','005049',5049,'Cossombrato','Cossombrato','','AT',1,'1840-01-01','2999-12-31'),
	(28641,'01','005',' 05','005050',5050,'Costigliole d\'Asti','Costigliole d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28642,'01','005',' 05','005051',5051,'Cunico','Cunico','','AT',1,'1840-01-01','2999-12-31'),
	(28643,'01','005',' 05','005052',5052,'Dusino San Michele','Dusino San Michele','','AT',1,'1840-01-01','2999-12-31'),
	(28644,'01','005',' 05','005053',5053,'Ferrere','Ferrere','','AT',1,'1840-01-01','2999-12-31'),
	(28645,'01','005',' 05','005054',5054,'Fontanile','Fontanile','','AT',1,'1840-01-01','2999-12-31'),
	(28646,'01','005',' 05','005055',5055,'Frinco','Frinco','','AT',1,'1840-01-01','2999-12-31'),
	(28647,'01','005',' 05','005056',5056,'Grana','Grana','','AT',1,'1840-01-01','2999-12-31'),
	(28648,'01','005',' 05','005057',5057,'Grazzano Badoglio','Grazzano Badoglio','','AT',1,'1840-01-01','2999-12-31'),
	(28649,'01','005',' 05','005058',5058,'Incisa Scapaccino','Incisa Scapaccino','','AT',1,'1840-01-01','2999-12-31'),
	(28650,'01','005',' 05','005059',5059,'Isola d\'Asti','Isola d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28651,'01','005',' 06','005060',5060,'Loazzolo','Loazzolo','','AT',1,'1840-01-01','2999-12-31'),
	(28652,'01','005',' 06','005061',5061,'Maranzana','Maranzana','','AT',1,'1840-01-01','2999-12-31'),
	(28653,'01','005',' 06','005062',5062,'Maretto','Maretto','','AT',1,'1840-01-01','2999-12-31'),
	(28654,'01','005',' 06','005063',5063,'Moasca','Moasca','','AT',1,'1840-01-01','2999-12-31'),
	(28655,'01','005',' 06','005064',5064,'Mombaldone','Mombaldone','','AT',1,'1840-01-01','2999-12-31'),
	(28656,'01','005',' 06','005065',5065,'Mombaruzzo','Mombaruzzo','','AT',1,'1840-01-01','2999-12-31'),
	(28657,'01','005',' 06','005066',5066,'Mombercelli','Mombercelli','','AT',1,'1840-01-01','2999-12-31'),
	(28658,'01','005',' 06','005067',5067,'Monale','Monale','','AT',1,'1840-01-01','2999-12-31'),
	(28659,'01','005',' 06','005068',5068,'Monastero Bormida','Monastero Bormida','','AT',1,'1840-01-01','2999-12-31'),
	(28660,'01','005',' 06','005069',5069,'Moncalvo','Moncalvo','','AT',1,'1840-01-01','2999-12-31'),
	(28661,'01','005',' 07','005070',5070,'Moncucco Torinese','Moncucco Torinese','','AT',1,'1840-01-01','2999-12-31'),
	(28662,'01','005',' 07','005071',5071,'Mongardino','Mongardino','','AT',1,'1840-01-01','2999-12-31'),
	(28663,'01','005',' 07','005072',5072,'Montabone','Montabone','','AT',1,'1840-01-01','2999-12-31'),
	(28664,'01','005',' 07','005073',5073,'Montafia','Montafia','','AT',1,'1840-01-01','2999-12-31'),
	(28665,'01','005',' 07','005074',5074,'Montaldo Scarampi','Montaldo Scarampi','','AT',1,'1840-01-01','2999-12-31'),
	(28666,'01','005',' 07','005075',5075,'Montechiaro d\'Asti','Montechiaro d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28667,'01','005',' 07','005076',5076,'Montegrosso d\'Asti','Montegrosso d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28668,'01','005',' 07','005077',5077,'Montemagno','Montemagno','','AT',1,'1840-01-01','2999-12-31'),
	(28669,'01','005',' 07','005079',5079,'Moransengo','Moransengo','','AT',1,'1840-01-01','2999-12-31'),
	(28670,'01','005',' 08','005080',5080,'Nizza Monferrato','Nizza Monferrato','','AT',1,'1840-01-01','2999-12-31'),
	(28671,'01','005',' 08','005081',5081,'Olmo Gentile','Olmo Gentile','','AT',1,'1840-01-01','2999-12-31'),
	(28672,'01','005',' 08','005082',5082,'Passerano Marmorito','Passerano Marmorito','','AT',1,'1840-01-01','2999-12-31'),
	(28673,'01','005',' 08','005083',5083,'Penango','Penango','','AT',1,'1840-01-01','2999-12-31'),
	(28674,'01','005',' 08','005084',5084,'Piea','Piea','','AT',1,'1840-01-01','2999-12-31'),
	(28675,'01','005',' 08','005085',5085,'Pino d\'Asti','Pino d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28676,'01','005',' 08','005086',5086,'Piovà Massaia','Piovà Massaia','','AT',1,'1840-01-01','2999-12-31'),
	(28677,'01','005',' 08','005087',5087,'Portacomaro','Portacomaro','','AT',1,'1840-01-01','2999-12-31'),
	(28678,'01','005',' 08','005088',5088,'Quaranti','Quaranti','','AT',1,'1840-01-01','2999-12-31'),
	(28679,'01','005',' 08','005089',5089,'Refrancore','Refrancore','','AT',1,'1840-01-01','2999-12-31'),
	(28680,'01','005',' 09','005090',5090,'Revigliasco d\'Asti','Revigliasco d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28681,'01','005',' 09','005091',5091,'Roatto','Roatto','','AT',1,'1840-01-01','2999-12-31'),
	(28682,'01','005',' 09','005092',5092,'Robella','Robella','','AT',1,'1840-01-01','2999-12-31'),
	(28683,'01','005',' 09','005093',5093,'Rocca d\'Arazzo','Rocca d\'Arazzo','','AT',1,'1840-01-01','2999-12-31'),
	(28684,'01','005',' 09','005094',5094,'Roccaverano','Roccaverano','','AT',1,'1840-01-01','2999-12-31'),
	(28685,'01','005',' 09','005095',5095,'Rocchetta Palafea','Rocchetta Palafea','','AT',1,'1840-01-01','2999-12-31'),
	(28686,'01','005',' 09','005096',5096,'Rocchetta Tanaro','Rocchetta Tanaro','','AT',1,'1840-01-01','2999-12-31'),
	(28687,'01','005',' 09','005097',5097,'San Damiano d\'Asti','San Damiano d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28688,'01','005',' 09','005098',5098,'San Giorgio Scarampi','San Giorgio Scarampi','','AT',1,'1840-01-01','2999-12-31'),
	(28689,'01','005',' 09','005099',5099,'San Martino Alfieri','San Martino Alfieri','','AT',1,'1840-01-01','2999-12-31'),
	(28690,'01','005',' 10','005100',5100,'San Marzano Oliveto','San Marzano Oliveto','','AT',1,'1840-01-01','2999-12-31'),
	(28691,'01','005',' 10','005101',5101,'San Paolo Solbrito','San Paolo Solbrito','','AT',1,'1840-01-01','2999-12-31'),
	(28692,'01','005',' 10','005103',5103,'Scurzolengo','Scurzolengo','','AT',1,'1840-01-01','2999-12-31'),
	(28693,'01','005',' 10','005104',5104,'Serole','Serole','','AT',1,'1840-01-01','2999-12-31'),
	(28694,'01','005',' 10','005105',5105,'Sessame','Sessame','','AT',1,'1840-01-01','2999-12-31'),
	(28695,'01','005',' 10','005106',5106,'Settime','Settime','','AT',1,'1840-01-01','2999-12-31'),
	(28696,'01','005',' 10','005107',5107,'Soglio','Soglio','','AT',1,'1840-01-01','2999-12-31'),
	(28697,'01','005',' 10','005108',5108,'Tigliole','Tigliole','','AT',1,'1840-01-01','2999-12-31'),
	(28698,'01','005',' 10','005109',5109,'Tonco','Tonco','','AT',1,'1840-01-01','2999-12-31'),
	(28699,'01','005',' 11','005110',5110,'Tonengo','Tonengo','','AT',1,'1840-01-01','2999-12-31'),
	(28700,'01','005',' 11','005111',5111,'Vaglio Serra','Vaglio Serra','','AT',1,'1840-01-01','2999-12-31'),
	(28701,'01','005',' 11','005112',5112,'Valfenera','Valfenera','','AT',1,'1840-01-01','2999-12-31'),
	(28702,'01','005',' 11','005113',5113,'Vesime','Vesime','','AT',1,'1840-01-01','2999-12-31'),
	(28703,'01','005',' 11','005114',5114,'Viale','Viale','','AT',1,'1840-01-01','2999-12-31'),
	(28704,'01','005',' 11','005115',5115,'Viarigi','Viarigi','','AT',1,'1840-01-01','2999-12-31'),
	(28705,'01','005',' 11','005116',5116,'Vigliano d\'Asti','Vigliano d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28706,'01','005',' 11','005117',5117,'Villafranca d\'Asti','Villafranca d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28707,'01','005',' 11','005118',5118,'Villanova d\'Asti','Villanova d\'Asti','','AT',1,'1840-01-01','2999-12-31'),
	(28708,'01','005',' 11','005119',5119,'Villa San Secondo','Villa San Secondo','','AT',1,'1840-01-01','2999-12-31'),
	(28709,'01','005',' 12','005120',5120,'Vinchio','Vinchio','','AT',1,'1840-01-01','2999-12-31'),
	(28710,'01','005',' 12','005121',5121,'Montiglio Monferrato','Montiglio Monferrato','','AT',1,'1840-01-01','2999-12-31'),
	(28711,'01','006',' 00','006001',6001,'Acqui Terme','Acqui Terme','','AL',1,'1840-01-01','2999-12-31'),
	(28712,'01','006',' 00','006002',6002,'Albera Ligure','Albera Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28713,'01','006',' 00','006003',6003,'Alessandria','Alessandria','','AL',1,'1840-01-01','2999-12-31'),
	(28714,'01','006',' 00','006004',6004,'Alfiano Natta','Alfiano Natta','','AL',1,'1840-01-01','2999-12-31'),
	(28715,'01','006',' 00','006005',6005,'Alice Bel Colle','Alice Bel Colle','','AL',1,'1840-01-01','2999-12-31'),
	(28716,'01','006',' 00','006006',6006,'Alluvioni Cambiò','Alluvioni Cambiò','','AL',1,'1840-01-01','2999-12-31'),
	(28717,'01','006',' 00','006007',6007,'Altavilla Monferrato','Altavilla Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28718,'01','006',' 00','006008',6008,'Alzano Scrivia','Alzano Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28719,'01','006',' 00','006009',6009,'Arquata Scrivia','Arquata Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28720,'01','006',' 01','006010',6010,'Avolasca','Avolasca','','AL',1,'1840-01-01','2999-12-31'),
	(28721,'01','006',' 01','006011',6011,'Balzola','Balzola','','AL',1,'1840-01-01','2999-12-31'),
	(28722,'01','006',' 01','006012',6012,'Basaluzzo','Basaluzzo','','AL',1,'1840-01-01','2999-12-31'),
	(28723,'01','006',' 01','006013',6013,'Bassignana','Bassignana','','AL',1,'1840-01-01','2999-12-31'),
	(28724,'01','006',' 01','006014',6014,'Belforte Monferrato','Belforte Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28725,'01','006',' 01','006015',6015,'Bergamasco','Bergamasco','','AL',1,'1840-01-01','2999-12-31'),
	(28726,'01','006',' 01','006016',6016,'Berzano di Tortona','Berzano di Tortona','','AL',1,'1840-01-01','2999-12-31'),
	(28727,'01','006',' 01','006017',6017,'Bistagno','Bistagno','','AL',1,'1840-01-01','2999-12-31'),
	(28728,'01','006',' 01','006018',6018,'Borghetto di Borbera','Borghetto di Borbera','','AL',1,'1840-01-01','2999-12-31'),
	(28729,'01','006',' 01','006019',6019,'Borgoratto Alessandrino','Borgoratto Alessandrino','','AL',1,'1840-01-01','2999-12-31'),
	(28730,'01','006',' 02','006020',6020,'Borgo San Martino','Borgo San Martino','','AL',1,'1840-01-01','2999-12-31'),
	(28731,'01','006',' 02','006021',6021,'Bosco Marengo','Bosco Marengo','','AL',1,'1840-01-01','2999-12-31'),
	(28732,'01','006',' 02','006022',6022,'Bosio','Bosio','','AL',1,'1840-01-01','2999-12-31'),
	(28733,'01','006',' 02','006023',6023,'Bozzole','Bozzole','','AL',1,'1840-01-01','2999-12-31'),
	(28734,'01','006',' 02','006024',6024,'Brignano-Frascata','Brignano-Frascata','','AL',1,'1840-01-01','2999-12-31'),
	(28735,'01','006',' 02','006025',6025,'Cabella Ligure','Cabella Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28736,'01','006',' 02','006026',6026,'Camagna Monferrato','Camagna Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28737,'01','006',' 02','006027',6027,'Camino','Camino','','AL',1,'1840-01-01','2999-12-31'),
	(28738,'01','006',' 02','006028',6028,'Cantalupo Ligure','Cantalupo Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28739,'01','006',' 02','006029',6029,'Capriata d\'Orba','Capriata d\'Orba','','AL',1,'1840-01-01','2999-12-31'),
	(28740,'01','006',' 03','006030',6030,'Carbonara Scrivia','Carbonara Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28741,'01','006',' 03','006031',6031,'Carentino','Carentino','','AL',1,'1840-01-01','2999-12-31'),
	(28742,'01','006',' 03','006032',6032,'Carezzano','Carezzano','','AL',1,'1840-01-01','2999-12-31'),
	(28743,'01','006',' 03','006033',6033,'Carpeneto','Carpeneto','','AL',1,'1840-01-01','2999-12-31'),
	(28744,'01','006',' 03','006034',6034,'Carrega Ligure','Carrega Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28745,'01','006',' 03','006035',6035,'Carrosio','Carrosio','','AL',1,'1840-01-01','2999-12-31'),
	(28746,'01','006',' 03','006036',6036,'Cartosio','Cartosio','','AL',1,'1840-01-01','2999-12-31'),
	(28747,'01','006',' 03','006037',6037,'Casal Cermelli','Casal Cermelli','','AL',1,'1840-01-01','2999-12-31'),
	(28748,'01','006',' 03','006038',6038,'Casaleggio Boiro','Casaleggio Boiro','','AL',1,'1840-01-01','2999-12-31'),
	(28749,'01','006',' 03','006039',6039,'Casale Monferrato','Casale Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28750,'01','006',' 04','006040',6040,'Casalnoceto','Casalnoceto','','AL',1,'1840-01-01','2999-12-31'),
	(28751,'01','006',' 04','006041',6041,'Casasco','Casasco','','AL',1,'1840-01-01','2999-12-31'),
	(28752,'01','006',' 04','006042',6042,'Cassano Spinola','Cassano Spinola','','AL',1,'1840-01-01','2999-12-31'),
	(28753,'01','006',' 04','006043',6043,'Cassine','Cassine','','AL',1,'1840-01-01','2999-12-31'),
	(28754,'01','006',' 04','006044',6044,'Cassinelle','Cassinelle','','AL',1,'1840-01-01','2999-12-31'),
	(28755,'01','006',' 04','006045',6045,'Castellania','Castellania','','AL',1,'1840-01-01','2999-12-31'),
	(28756,'01','006',' 04','006046',6046,'Castellar Guidobono','Castellar Guidobono','','AL',1,'1840-01-01','2999-12-31'),
	(28757,'01','006',' 04','006047',6047,'Castellazzo Bormida','Castellazzo Bormida','','AL',1,'1840-01-01','2999-12-31'),
	(28758,'01','006',' 04','006048',6048,'Castelletto d\'Erro','Castelletto d\'Erro','','AL',1,'1840-01-01','2999-12-31'),
	(28759,'01','006',' 04','006049',6049,'Castelletto d\'Orba','Castelletto d\'Orba','','AL',1,'1840-01-01','2999-12-31'),
	(28760,'01','006',' 05','006050',6050,'Castelletto Merli','Castelletto Merli','','AL',1,'1840-01-01','2999-12-31'),
	(28761,'01','006',' 05','006051',6051,'Castelletto Monferrato','Castelletto Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28762,'01','006',' 05','006052',6052,'Castelnuovo Bormida','Castelnuovo Bormida','','AL',1,'1840-01-01','2999-12-31'),
	(28763,'01','006',' 05','006053',6053,'Castelnuovo Scrivia','Castelnuovo Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28764,'01','006',' 05','006054',6054,'Castelspina','Castelspina','','AL',1,'1840-01-01','2999-12-31'),
	(28765,'01','006',' 05','006055',6055,'Cavatore','Cavatore','','AL',1,'1840-01-01','2999-12-31'),
	(28766,'01','006',' 05','006056',6056,'Cella Monte','Cella Monte','','AL',1,'1840-01-01','2999-12-31'),
	(28767,'01','006',' 05','006057',6057,'Cereseto','Cereseto','','AL',1,'1840-01-01','2999-12-31'),
	(28768,'01','006',' 05','006058',6058,'Cerreto Grue','Cerreto Grue','','AL',1,'1840-01-01','2999-12-31'),
	(28769,'01','006',' 05','006059',6059,'Cerrina Monferrato','Cerrina Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28770,'01','006',' 06','006060',6060,'Coniolo','Coniolo','','AL',1,'1840-01-01','2999-12-31'),
	(28771,'01','006',' 06','006061',6061,'Conzano','Conzano','','AL',1,'1840-01-01','2999-12-31'),
	(28772,'01','006',' 06','006062',6062,'Costa Vescovato','Costa Vescovato','','AL',1,'1840-01-01','2999-12-31'),
	(28773,'01','006',' 06','006063',6063,'Cremolino','Cremolino','','AL',1,'1840-01-01','2999-12-31'),
	(28774,'01','006',' 06','006064',6064,'Cuccaro Monferrato','Cuccaro Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28775,'01','006',' 06','006065',6065,'Denice','Denice','','AL',1,'1840-01-01','2999-12-31'),
	(28776,'01','006',' 06','006066',6066,'Dernice','Dernice','','AL',1,'1840-01-01','2999-12-31'),
	(28777,'01','006',' 06','006067',6067,'Fabbrica Curone','Fabbrica Curone','','AL',1,'1840-01-01','2999-12-31'),
	(28778,'01','006',' 06','006068',6068,'Felizzano','Felizzano','','AL',1,'1840-01-01','2999-12-31'),
	(28779,'01','006',' 06','006069',6069,'Fraconalto','Fraconalto','','AL',1,'1840-01-01','2999-12-31'),
	(28780,'01','006',' 07','006070',6070,'Francavilla Bisio','Francavilla Bisio','','AL',1,'1840-01-01','2999-12-31'),
	(28781,'01','006',' 07','006071',6071,'Frascaro','Frascaro','','AL',1,'1840-01-01','2999-12-31'),
	(28782,'01','006',' 07','006072',6072,'Frassinello Monferrato','Frassinello Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28783,'01','006',' 07','006073',6073,'Frassineto Po','Frassineto Po','','AL',1,'1840-01-01','2999-12-31'),
	(28784,'01','006',' 07','006074',6074,'Fresonara','Fresonara','','AL',1,'1840-01-01','2999-12-31'),
	(28785,'01','006',' 07','006075',6075,'Frugarolo','Frugarolo','','AL',1,'1840-01-01','2999-12-31'),
	(28786,'01','006',' 07','006076',6076,'Fubine','Fubine','','AL',1,'1840-01-01','2999-12-31'),
	(28787,'01','006',' 07','006077',6077,'Gabiano','Gabiano','','AL',1,'1840-01-01','2999-12-31'),
	(28788,'01','006',' 07','006078',6078,'Gamalero','Gamalero','','AL',1,'1840-01-01','2999-12-31'),
	(28789,'01','006',' 07','006079',6079,'Garbagna','Garbagna','','AL',1,'1840-01-01','2999-12-31'),
	(28790,'01','006',' 08','006080',6080,'Gavazzana','Gavazzana','','AL',1,'1840-01-01','2999-12-31'),
	(28791,'01','006',' 08','006081',6081,'Gavi','Gavi','','AL',1,'1840-01-01','2999-12-31'),
	(28792,'01','006',' 08','006082',6082,'Giarole','Giarole','','AL',1,'1840-01-01','2999-12-31'),
	(28793,'01','006',' 08','006083',6083,'Gremiasco','Gremiasco','','AL',1,'1840-01-01','2999-12-31'),
	(28794,'01','006',' 08','006084',6084,'Grognardo','Grognardo','','AL',1,'1840-01-01','2999-12-31'),
	(28795,'01','006',' 08','006085',6085,'Grondona','Grondona','','AL',1,'1840-01-01','2999-12-31'),
	(28796,'01','006',' 08','006086',6086,'Guazzora','Guazzora','','AL',1,'1840-01-01','2999-12-31'),
	(28797,'01','006',' 08','006087',6087,'Isola Sant\'Antonio','Isola Sant\'Antonio','','AL',1,'1840-01-01','2999-12-31'),
	(28798,'01','006',' 08','006088',6088,'Lerma','Lerma','','AL',1,'1840-01-01','2999-12-31'),
	(28799,'01','006',' 08','006089',6089,'Lu','Lu','','AL',1,'1840-01-01','2999-12-31'),
	(28800,'01','006',' 09','006090',6090,'Malvicino','Malvicino','','AL',1,'1840-01-01','2999-12-31'),
	(28801,'01','006',' 09','006091',6091,'Masio','Masio','','AL',1,'1840-01-01','2999-12-31'),
	(28802,'01','006',' 09','006092',6092,'Melazzo','Melazzo','','AL',1,'1840-01-01','2999-12-31'),
	(28803,'01','006',' 09','006093',6093,'Merana','Merana','','AL',1,'1840-01-01','2999-12-31'),
	(28804,'01','006',' 09','006094',6094,'Mirabello Monferrato','Mirabello Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28805,'01','006',' 09','006095',6095,'Molare','Molare','','AL',1,'1840-01-01','2999-12-31'),
	(28806,'01','006',' 09','006096',6096,'Molino dei Torti','Molino dei Torti','','AL',1,'1840-01-01','2999-12-31'),
	(28807,'01','006',' 09','006097',6097,'Mombello Monferrato','Mombello Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28808,'01','006',' 09','006098',6098,'Momperone','Momperone','','AL',1,'1840-01-01','2999-12-31'),
	(28809,'01','006',' 09','006099',6099,'Moncestino','Moncestino','','AL',1,'1840-01-01','2999-12-31'),
	(28810,'01','006',' 10','006100',6100,'Mongiardino Ligure','Mongiardino Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28811,'01','006',' 10','006101',6101,'Monleale','Monleale','','AL',1,'1840-01-01','2999-12-31'),
	(28812,'01','006',' 10','006102',6102,'Montacuto','Montacuto','','AL',1,'1840-01-01','2999-12-31'),
	(28813,'01','006',' 10','006103',6103,'Montaldeo','Montaldeo','','AL',1,'1840-01-01','2999-12-31'),
	(28814,'01','006',' 10','006104',6104,'Montaldo Bormida','Montaldo Bormida','','AL',1,'1840-01-01','2999-12-31'),
	(28815,'01','006',' 10','006105',6105,'Montecastello','Montecastello','','AL',1,'1840-01-01','2999-12-31'),
	(28816,'01','006',' 10','006106',6106,'Montechiaro d\'Acqui','Montechiaro d\'Acqui','','AL',1,'1840-01-01','2999-12-31'),
	(28817,'01','006',' 10','006107',6107,'Montegioco','Montegioco','','AL',1,'1840-01-01','2999-12-31'),
	(28818,'01','006',' 10','006108',6108,'Montemarzino','Montemarzino','','AL',1,'1840-01-01','2999-12-31'),
	(28819,'01','006',' 10','006109',6109,'Morano sul Po','Morano sul Po','','AL',1,'1840-01-01','2999-12-31'),
	(28820,'01','006',' 11','006110',6110,'Morbello','Morbello','','AL',1,'1840-01-01','2999-12-31'),
	(28821,'01','006',' 11','006111',6111,'Mornese','Mornese','','AL',1,'1840-01-01','2999-12-31'),
	(28822,'01','006',' 11','006112',6112,'Morsasco','Morsasco','','AL',1,'1840-01-01','2999-12-31'),
	(28823,'01','006',' 11','006113',6113,'Murisengo','Murisengo','','AL',1,'1840-01-01','2999-12-31'),
	(28824,'01','006',' 11','006114',6114,'Novi Ligure','Novi Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28825,'01','006',' 11','006115',6115,'Occimiano','Occimiano','','AL',1,'1840-01-01','2999-12-31'),
	(28826,'01','006',' 11','006116',6116,'Odalengo Grande','Odalengo Grande','','AL',1,'1840-01-01','2999-12-31'),
	(28827,'01','006',' 11','006117',6117,'Odalengo Piccolo','Odalengo Piccolo','','AL',1,'1840-01-01','2999-12-31'),
	(28828,'01','006',' 11','006118',6118,'Olivola','Olivola','','AL',1,'1840-01-01','2999-12-31'),
	(28829,'01','006',' 11','006119',6119,'Orsara Bormida','Orsara Bormida','','AL',1,'1840-01-01','2999-12-31'),
	(28830,'01','006',' 12','006120',6120,'Ottiglio','Ottiglio','','AL',1,'1840-01-01','2999-12-31'),
	(28831,'01','006',' 12','006121',6121,'Ovada','Ovada','','AL',1,'1840-01-01','2999-12-31'),
	(28832,'01','006',' 12','006122',6122,'Oviglio','Oviglio','','AL',1,'1840-01-01','2999-12-31'),
	(28833,'01','006',' 12','006123',6123,'Ozzano Monferrato','Ozzano Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28834,'01','006',' 12','006124',6124,'Paderna','Paderna','','AL',1,'1840-01-01','2999-12-31'),
	(28835,'01','006',' 12','006125',6125,'Pareto','Pareto','','AL',1,'1840-01-01','2999-12-31'),
	(28836,'01','006',' 12','006126',6126,'Parodi Ligure','Parodi Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28837,'01','006',' 12','006127',6127,'Pasturana','Pasturana','','AL',1,'1840-01-01','2999-12-31'),
	(28838,'01','006',' 12','006128',6128,'Pecetto di Valenza','Pecetto di Valenza','','AL',1,'1840-01-01','2999-12-31'),
	(28839,'01','006',' 12','006129',6129,'Pietra Marazzi','Pietra Marazzi','','AL',1,'1840-01-01','2999-12-31'),
	(28840,'01','006',' 13','006130',6130,'Piovera','Piovera','','AL',1,'1840-01-01','2999-12-31'),
	(28841,'01','006',' 13','006131',6131,'Pomaro Monferrato','Pomaro Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28842,'01','006',' 13','006132',6132,'Pontecurone','Pontecurone','','AL',1,'1840-01-01','2999-12-31'),
	(28843,'01','006',' 13','006133',6133,'Pontestura','Pontestura','','AL',1,'1840-01-01','2999-12-31'),
	(28844,'01','006',' 13','006134',6134,'Ponti','Ponti','','AL',1,'1840-01-01','2999-12-31'),
	(28845,'01','006',' 13','006135',6135,'Ponzano Monferrato','Ponzano Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28846,'01','006',' 13','006136',6136,'Ponzone','Ponzone','','AL',1,'1840-01-01','2999-12-31'),
	(28847,'01','006',' 13','006137',6137,'Pozzol Groppo','Pozzol Groppo','','AL',1,'1840-01-01','2999-12-31'),
	(28848,'01','006',' 13','006138',6138,'Pozzolo Formigaro','Pozzolo Formigaro','','AL',1,'1840-01-01','2999-12-31'),
	(28849,'01','006',' 13','006139',6139,'Prasco','Prasco','','AL',1,'1840-01-01','2999-12-31'),
	(28850,'01','006',' 14','006140',6140,'Predosa','Predosa','','AL',1,'1840-01-01','2999-12-31'),
	(28851,'01','006',' 14','006141',6141,'Quargnento','Quargnento','','AL',1,'1840-01-01','2999-12-31'),
	(28852,'01','006',' 14','006142',6142,'Quattordio','Quattordio','','AL',1,'1840-01-01','2999-12-31'),
	(28853,'01','006',' 14','006143',6143,'Ricaldone','Ricaldone','','AL',1,'1840-01-01','2999-12-31'),
	(28854,'01','006',' 14','006144',6144,'Rivalta Bormida','Rivalta Bormida','','AL',1,'1840-01-01','2999-12-31'),
	(28855,'01','006',' 14','006145',6145,'Rivarone','Rivarone','','AL',1,'1840-01-01','2999-12-31'),
	(28856,'01','006',' 14','006146',6146,'Roccaforte Ligure','Roccaforte Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28857,'01','006',' 14','006147',6147,'Rocca Grimalda','Rocca Grimalda','','AL',1,'1840-01-01','2999-12-31'),
	(28858,'01','006',' 14','006148',6148,'Rocchetta Ligure','Rocchetta Ligure','','AL',1,'1840-01-01','2999-12-31'),
	(28859,'01','006',' 14','006149',6149,'Rosignano Monferrato','Rosignano Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28860,'01','006',' 15','006150',6150,'Sala Monferrato','Sala Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28861,'01','006',' 15','006151',6151,'Sale','Sale','','AL',1,'1840-01-01','2999-12-31'),
	(28862,'01','006',' 15','006152',6152,'San Cristoforo','San Cristoforo','','AL',1,'1840-01-01','2999-12-31'),
	(28863,'01','006',' 15','006153',6153,'San Giorgio Monferrato','San Giorgio Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28864,'01','006',' 15','006154',6154,'San Salvatore Monferrato','San Salvatore Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28865,'01','006',' 15','006155',6155,'San Sebastiano Curone','San Sebastiano Curone','','AL',1,'1840-01-01','2999-12-31'),
	(28866,'01','006',' 15','006156',6156,'Sant\'Agata Fossili','Sant\'Agata Fossili','','AL',1,'1840-01-01','2999-12-31'),
	(28867,'01','006',' 15','006157',6157,'Sardigliano','Sardigliano','','AL',1,'1840-01-01','2999-12-31'),
	(28868,'01','006',' 15','006158',6158,'Sarezzano','Sarezzano','','AL',1,'1840-01-01','2999-12-31'),
	(28869,'01','006',' 15','006159',6159,'Serralunga di Crea','Serralunga di Crea','','AL',1,'1840-01-01','2999-12-31'),
	(28870,'01','006',' 16','006160',6160,'Serravalle Scrivia','Serravalle Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28871,'01','006',' 16','006161',6161,'Sezzadio','Sezzadio','','AL',1,'1840-01-01','2999-12-31'),
	(28872,'01','006',' 16','006162',6162,'Silvano d\'Orba','Silvano d\'Orba','','AL',1,'1840-01-01','2999-12-31'),
	(28873,'01','006',' 16','006163',6163,'Solero','Solero','','AL',1,'1840-01-01','2999-12-31'),
	(28874,'01','006',' 16','006164',6164,'Solonghello','Solonghello','','AL',1,'1840-01-01','2999-12-31'),
	(28875,'01','006',' 16','006165',6165,'Spigno Monferrato','Spigno Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28876,'01','006',' 16','006166',6166,'Spineto Scrivia','Spineto Scrivia','','AL',1,'1840-01-01','2999-12-31'),
	(28877,'01','006',' 16','006167',6167,'Stazzano','Stazzano','','AL',1,'1840-01-01','2999-12-31'),
	(28878,'01','006',' 16','006168',6168,'Strevi','Strevi','','AL',1,'1840-01-01','2999-12-31'),
	(28879,'01','006',' 16','006169',6169,'Tagliolo Monferrato','Tagliolo Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28880,'01','006',' 17','006170',6170,'Tassarolo','Tassarolo','','AL',1,'1840-01-01','2999-12-31'),
	(28881,'01','006',' 17','006171',6171,'Terruggia','Terruggia','','AL',1,'1840-01-01','2999-12-31'),
	(28882,'01','006',' 17','006172',6172,'Terzo','Terzo','','AL',1,'1840-01-01','2999-12-31'),
	(28883,'01','006',' 17','006173',6173,'Ticineto','Ticineto','','AL',1,'1840-01-01','2999-12-31'),
	(28884,'01','006',' 17','006174',6174,'Tortona','Tortona','','AL',1,'1840-01-01','2999-12-31'),
	(28885,'01','006',' 17','006175',6175,'Treville','Treville','','AL',1,'1840-01-01','2999-12-31'),
	(28886,'01','006',' 17','006176',6176,'Trisobbio','Trisobbio','','AL',1,'1840-01-01','2999-12-31'),
	(28887,'01','006',' 17','006177',6177,'Valenza','Valenza','','AL',1,'1840-01-01','2999-12-31'),
	(28888,'01','006',' 17','006178',6178,'Valmacca','Valmacca','','AL',1,'1840-01-01','2999-12-31'),
	(28889,'01','006',' 17','006179',6179,'Vignale Monferrato','Vignale Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28890,'01','006',' 18','006180',6180,'Vignole Borbera','Vignole Borbera','','AL',1,'1840-01-01','2999-12-31'),
	(28891,'01','006',' 18','006181',6181,'Viguzzolo','Viguzzolo','','AL',1,'1840-01-01','2999-12-31'),
	(28892,'01','006',' 18','006182',6182,'Villadeati','Villadeati','','AL',1,'1840-01-01','2999-12-31'),
	(28893,'01','006',' 18','006183',6183,'Villalvernia','Villalvernia','','AL',1,'1840-01-01','2999-12-31'),
	(28894,'01','006',' 18','006184',6184,'Villamiroglio','Villamiroglio','','AL',1,'1840-01-01','2999-12-31'),
	(28895,'01','006',' 18','006185',6185,'Villanova Monferrato','Villanova Monferrato','','AL',1,'1840-01-01','2999-12-31'),
	(28896,'01','006',' 18','006186',6186,'Villaromagnano','Villaromagnano','','AL',1,'1840-01-01','2999-12-31'),
	(28897,'01','006',' 18','006187',6187,'Visone','Visone','','AL',1,'1840-01-01','2999-12-31'),
	(28898,'01','006',' 18','006188',6188,'Volpedo','Volpedo','','AL',1,'1840-01-01','2999-12-31'),
	(28899,'01','006',' 18','006189',6189,'Volpeglino','Volpeglino','','AL',1,'1840-01-01','2999-12-31'),
	(28900,'01','006',' 19','006190',6190,'Voltaggio','Voltaggio','','AL',1,'1840-01-01','2999-12-31'),
	(28901,'02','007',' 00','007001',7001,'Allein','Allein','','AO',1,'1840-01-01','2999-12-31'),
	(28902,'02','007',' 00','007002',7002,'Antey-Saint-Andrè','Antey-Saint-Andrè','','AO',1,'1840-01-01','2999-12-31'),
	(28903,'02','007',' 00','007003',7003,'Aosta','Aosta','','AO',1,'1840-01-01','2999-12-31'),
	(28904,'02','007',' 00','007004',7004,'Arnad','Arnad','','AO',1,'1840-01-01','2999-12-31'),
	(28905,'02','007',' 00','007005',7005,'Arvier','Arvier','','AO',1,'1840-01-01','2999-12-31'),
	(28906,'02','007',' 00','007006',7006,'Avise','Avise','','AO',1,'1840-01-01','2999-12-31'),
	(28907,'02','007',' 00','007007',7007,'Ayas','Ayas','','AO',1,'1840-01-01','2999-12-31'),
	(28908,'02','007',' 00','007008',7008,'Aymavilles','Aymavilles','','AO',1,'1840-01-01','2999-12-31'),
	(28909,'02','007',' 00','007009',7009,'Bard','Bard','','AO',1,'1840-01-01','2999-12-31'),
	(28910,'02','007',' 01','007010',7010,'Bionaz','Bionaz','','AO',1,'1840-01-01','2999-12-31'),
	(28911,'02','007',' 01','007011',7011,'Brissogne','Brissogne','','AO',1,'1840-01-01','2999-12-31'),
	(28912,'02','007',' 01','007012',7012,'Brusson','Brusson','','AO',1,'1840-01-01','2999-12-31'),
	(28913,'02','007',' 01','007013',7013,'Challand-Saint-Anselme','Challand-Saint-Anselme','','AO',1,'1840-01-01','2999-12-31'),
	(28914,'02','007',' 01','007014',7014,'Challand-Saint-Victor','Challand-Saint-Victor','','AO',1,'1840-01-01','2999-12-31'),
	(28915,'02','007',' 01','007015',7015,'Chambave','Chambave','','AO',1,'1840-01-01','2999-12-31'),
	(28916,'02','007',' 01','007016',7016,'Chamois','Chamois','','AO',1,'1840-01-01','2999-12-31'),
	(28917,'02','007',' 01','007017',7017,'Champdepraz','Champdepraz','','AO',1,'1840-01-01','2999-12-31'),
	(28918,'02','007',' 01','007018',7018,'Champorcher','Champorcher','','AO',1,'1840-01-01','2999-12-31'),
	(28919,'02','007',' 01','007019',7019,'Charvensod','Charvensod','','AO',1,'1840-01-01','2999-12-31'),
	(28920,'02','007',' 02','007020',7020,'Chatillon','Chatillon','','AO',1,'1840-01-01','2999-12-31'),
	(28921,'02','007',' 02','007021',7021,'Cogne','Cogne','','AO',1,'1840-01-01','2999-12-31'),
	(28922,'02','007',' 02','007022',7022,'Courmayeur','Courmayeur','','AO',1,'1840-01-01','2999-12-31'),
	(28923,'02','007',' 02','007023',7023,'Donnas','Donnas','','AO',1,'1840-01-01','2999-12-31'),
	(28924,'02','007',' 02','007024',7024,'Doues','Doues','','AO',1,'1840-01-01','2999-12-31'),
	(28925,'02','007',' 02','007025',7025,'Emarèse','Emarèse','','AO',1,'1840-01-01','2999-12-31'),
	(28926,'02','007',' 02','007026',7026,'Etroubles','Etroubles','','AO',1,'1840-01-01','2999-12-31'),
	(28927,'02','007',' 02','007027',7027,'Fénis','Fénis','','AO',1,'1840-01-01','2999-12-31'),
	(28928,'02','007',' 02','007028',7028,'Fontainemore','Fontainemore','','AO',1,'1840-01-01','2999-12-31'),
	(28929,'02','007',' 02','007029',7029,'Gaby','Gaby','','AO',1,'1840-01-01','2999-12-31'),
	(28930,'02','007',' 03','007030',7030,'Gignod','Gignod','','AO',1,'1840-01-01','2999-12-31'),
	(28931,'02','007',' 03','007031',7031,'Gressan','Gressan','','AO',1,'1840-01-01','2999-12-31'),
	(28932,'02','007',' 03','007032',7032,'Gressoney-La-Trinitè','Gressoney-La-Trinitè','','AO',1,'1840-01-01','2999-12-31'),
	(28933,'02','007',' 03','007033',7033,'Gressoney-Saint-Jean','Gressoney-Saint-Jean','','AO',1,'1840-01-01','2999-12-31'),
	(28934,'02','007',' 03','007034',7034,'Hone','Hone','','AO',1,'1840-01-01','2999-12-31'),
	(28935,'02','007',' 03','007035',7035,'Introd','Introd','','AO',1,'1840-01-01','2999-12-31'),
	(28936,'02','007',' 03','007036',7036,'Issime','Issime','','AO',1,'1840-01-01','2999-12-31'),
	(28937,'02','007',' 03','007037',7037,'Issogne','Issogne','','AO',1,'1840-01-01','2999-12-31'),
	(28938,'02','007',' 03','007038',7038,'Jovencan','Jovencan','','AO',1,'1840-01-01','2999-12-31'),
	(28939,'02','007',' 03','007039',7039,'La Magdeleine','La Magdeleine','','AO',1,'1840-01-01','2999-12-31'),
	(28940,'02','007',' 04','007040',7040,'La Salle','La Salle','','AO',1,'1840-01-01','2999-12-31'),
	(28941,'02','007',' 04','007041',7041,'La Thuile','La Thuile','','AO',1,'1840-01-01','2999-12-31'),
	(28942,'02','007',' 04','007042',7042,'Lillianes','Lillianes','','AO',1,'1840-01-01','2999-12-31'),
	(28943,'02','007',' 04','007043',7043,'Montjovet','Montjovet','','AO',1,'1840-01-01','2999-12-31'),
	(28944,'02','007',' 04','007044',7044,'Morgex','Morgex','','AO',1,'1840-01-01','2999-12-31'),
	(28945,'02','007',' 04','007045',7045,'Nus','Nus','','AO',1,'1840-01-01','2999-12-31'),
	(28946,'02','007',' 04','007046',7046,'Ollomont','Ollomont','','AO',1,'1840-01-01','2999-12-31'),
	(28947,'02','007',' 04','007047',7047,'Oyace','Oyace','','AO',1,'1840-01-01','2999-12-31'),
	(28948,'02','007',' 04','007048',7048,'Perloz','Perloz','','AO',1,'1840-01-01','2999-12-31'),
	(28949,'02','007',' 04','007049',7049,'Pollein','Pollein','','AO',1,'1840-01-01','2999-12-31'),
	(28950,'02','007',' 05','007050',7050,'Pontboset','Pontboset','','AO',1,'1840-01-01','2999-12-31'),
	(28951,'02','007',' 05','007051',7051,'Pontey','Pontey','','AO',1,'1840-01-01','2999-12-31'),
	(28952,'02','007',' 05','007052',7052,'Pont-Saint-Martin','Pont-Saint-Martin','','AO',1,'1840-01-01','2999-12-31'),
	(28953,'02','007',' 05','007053',7053,'Prè-Saint-Didier','Prè-Saint-Didier','','AO',1,'1840-01-01','2999-12-31'),
	(28954,'02','007',' 05','007054',7054,'Quart','Quart','','AO',1,'1840-01-01','2999-12-31'),
	(28955,'02','007',' 05','007055',7055,'Rhemes-Notre-Dame','Rhemes-Notre-Dame','','AO',1,'1840-01-01','2999-12-31'),
	(28956,'02','007',' 05','007056',7056,'Rhemes-Saint-Georges','Rhemes-Saint-Georges','','AO',1,'1840-01-01','2999-12-31'),
	(28957,'02','007',' 05','007057',7057,'Roisan','Roisan','','AO',1,'1840-01-01','2999-12-31'),
	(28958,'02','007',' 05','007058',7058,'Saint-Christophe','Saint-Christophe','','AO',1,'1840-01-01','2999-12-31'),
	(28959,'02','007',' 05','007059',7059,'Saint-Denis','Saint-Denis','','AO',1,'1840-01-01','2999-12-31'),
	(28960,'02','007',' 06','007060',7060,'Saint-Marcel','Saint-Marcel','','AO',1,'1840-01-01','2999-12-31'),
	(28961,'02','007',' 06','007061',7061,'Saint-Nicolas','Saint-Nicolas','','AO',1,'1840-01-01','2999-12-31'),
	(28962,'02','007',' 06','007062',7062,'Saint-Oyen','Saint-Oyen','','AO',1,'1840-01-01','2999-12-31'),
	(28963,'02','007',' 06','007063',7063,'Saint-Pierre','Saint-Pierre','','AO',1,'1840-01-01','2999-12-31'),
	(28964,'02','007',' 06','007064',7064,'Saint-Rhémy-en-Bosses','Saint-Rhémy-en-Bosses','','AO',1,'1840-01-01','2999-12-31'),
	(28965,'02','007',' 06','007065',7065,'Saint-Vincent','Saint-Vincent','','AO',1,'1840-01-01','2999-12-31'),
	(28966,'02','007',' 06','007066',7066,'Sarre','Sarre','','AO',1,'1840-01-01','2999-12-31'),
	(28967,'02','007',' 06','007067',7067,'Torgnon','Torgnon','','AO',1,'1840-01-01','2999-12-31'),
	(28968,'02','007',' 06','007068',7068,'Valgrisenche','Valgrisenche','','AO',1,'1840-01-01','2999-12-31'),
	(28969,'02','007',' 06','007069',7069,'Valpelline','Valpelline','','AO',1,'1840-01-01','2999-12-31'),
	(28970,'02','007',' 07','007070',7070,'Valsavarenche','Valsavarenche','','AO',1,'1840-01-01','2999-12-31'),
	(28971,'02','007',' 07','007071',7071,'Valtournenche','Valtournenche','','AO',1,'1840-01-01','2999-12-31'),
	(28972,'02','007',' 07','007072',7072,'Verrayes','Verrayes','','AO',1,'1840-01-01','2999-12-31'),
	(28973,'02','007',' 07','007073',7073,'Verrès','Verrès','','AO',1,'1840-01-01','2999-12-31'),
	(28974,'02','007',' 07','007074',7074,'Villeneuve','Villeneuve','','AO',1,'1840-01-01','2999-12-31'),
	(28975,'07','008',' 00','008001',8001,'Airole','Airole','','IM',1,'1840-01-01','2999-12-31'),
	(28976,'07','008',' 00','008002',8002,'Apricale','Apricale','','IM',1,'1840-01-01','2999-12-31'),
	(28977,'07','008',' 00','008003',8003,'Aquila d\'Arroscia','Aquila d\'Arroscia','','IM',1,'1840-01-01','2999-12-31'),
	(28978,'07','008',' 00','008004',8004,'Armo','Armo','','IM',1,'1840-01-01','2999-12-31'),
	(28979,'07','008',' 00','008005',8005,'Aurigo','Aurigo','','IM',1,'1840-01-01','2999-12-31'),
	(28980,'07','008',' 00','008006',8006,'Badalucco','Badalucco','','IM',1,'1840-01-01','2999-12-31'),
	(28981,'07','008',' 00','008007',8007,'Bajardo','Bajardo','','IM',1,'1840-01-01','2999-12-31'),
	(28982,'07','008',' 00','008008',8008,'Bordighera','Bordighera','','IM',1,'1840-01-01','2999-12-31'),
	(28983,'07','008',' 00','008009',8009,'Borghetto d\'Arroscia','Borghetto d\'Arroscia','','IM',1,'1840-01-01','2999-12-31'),
	(28984,'07','008',' 01','008010',8010,'Borgomaro','Borgomaro','','IM',1,'1840-01-01','2999-12-31'),
	(28985,'07','008',' 01','008011',8011,'Camporosso','Camporosso','','IM',1,'1840-01-01','2999-12-31'),
	(28986,'07','008',' 01','008012',8012,'Caravonica','Caravonica','','IM',1,'1840-01-01','2999-12-31'),
	(28987,'07','008',' 01','008013',8013,'Carpasio','Carpasio','','IM',1,'1840-01-01','2999-12-31'),
	(28988,'07','008',' 01','008014',8014,'Castellaro','Castellaro','','IM',1,'1840-01-01','2999-12-31'),
	(28989,'07','008',' 01','008015',8015,'Castel Vittorio','Castel Vittorio','','IM',1,'1840-01-01','2999-12-31'),
	(28990,'07','008',' 01','008016',8016,'Ceriana','Ceriana','','IM',1,'1840-01-01','2999-12-31'),
	(28991,'07','008',' 01','008017',8017,'Cervo','Cervo','','IM',1,'1840-01-01','2999-12-31'),
	(28992,'07','008',' 01','008018',8018,'Cesio','Cesio','','IM',1,'1840-01-01','2999-12-31'),
	(28993,'07','008',' 01','008019',8019,'Chiusanico','Chiusanico','','IM',1,'1840-01-01','2999-12-31'),
	(28994,'07','008',' 02','008020',8020,'Chiusavecchia','Chiusavecchia','','IM',1,'1840-01-01','2999-12-31'),
	(28995,'07','008',' 02','008021',8021,'Cipressa','Cipressa','','IM',1,'1840-01-01','2999-12-31'),
	(28996,'07','008',' 02','008022',8022,'Civezza','Civezza','','IM',1,'1840-01-01','2999-12-31'),
	(28997,'07','008',' 02','008023',8023,'Cosio d\'Arroscia','Cosio d\'Arroscia','','IM',1,'1840-01-01','2999-12-31'),
	(28998,'07','008',' 02','008024',8024,'Costarainera','Costarainera','','IM',1,'1840-01-01','2999-12-31'),
	(28999,'07','008',' 02','008025',8025,'Diano Arentino','Diano Arentino','','IM',1,'1840-01-01','2999-12-31'),
	(29000,'07','008',' 02','008026',8026,'Diano Castello','Diano Castello','','IM',1,'1840-01-01','2999-12-31'),
	(29001,'07','008',' 02','008027',8027,'Diano Marina','Diano Marina','','IM',1,'1840-01-01','2999-12-31'),
	(29002,'07','008',' 02','008028',8028,'Diano San Pietro','Diano San Pietro','','IM',1,'1840-01-01','2999-12-31'),
	(29003,'07','008',' 02','008029',8029,'Dolceacqua','Dolceacqua','','IM',1,'1840-01-01','2999-12-31'),
	(29004,'07','008',' 03','008030',8030,'Dolcedo','Dolcedo','','IM',1,'1840-01-01','2999-12-31'),
	(29005,'07','008',' 03','008031',8031,'Imperia','Imperia','','IM',1,'1840-01-01','2999-12-31'),
	(29006,'07','008',' 03','008032',8032,'Isolabona','Isolabona','','IM',1,'1840-01-01','2999-12-31'),
	(29007,'07','008',' 03','008033',8033,'Lucinasco','Lucinasco','','IM',1,'1840-01-01','2999-12-31'),
	(29008,'07','008',' 03','008034',8034,'Mendatica','Mendatica','','IM',1,'1840-01-01','2999-12-31'),
	(29009,'07','008',' 03','008035',8035,'Molini di Triora','Molini di Triora','','IM',1,'1840-01-01','2999-12-31'),
	(29010,'07','008',' 03','008036',8036,'Montalto Ligure','Montalto Ligure','','IM',1,'1840-01-01','2999-12-31'),
	(29011,'07','008',' 03','008037',8037,'Montegrosso Pian Latte','Montegrosso Pian Latte','','IM',1,'1840-01-01','2999-12-31'),
	(29012,'07','008',' 03','008038',8038,'Olivetta San Michele','Olivetta San Michele','','IM',1,'1840-01-01','2999-12-31'),
	(29013,'07','008',' 03','008039',8039,'Ospedaletti','Ospedaletti','','IM',1,'1840-01-01','2999-12-31'),
	(29014,'07','008',' 04','008040',8040,'Perinaldo','Perinaldo','','IM',1,'1840-01-01','2999-12-31'),
	(29015,'07','008',' 04','008041',8041,'Pietrabruna','Pietrabruna','','IM',1,'1840-01-01','2999-12-31'),
	(29016,'07','008',' 04','008042',8042,'Pieve di Teco','Pieve di Teco','','IM',1,'1840-01-01','2999-12-31'),
	(29017,'07','008',' 04','008043',8043,'Pigna','Pigna','','IM',1,'1840-01-01','2999-12-31'),
	(29018,'07','008',' 04','008044',8044,'Pompeiana','Pompeiana','','IM',1,'1840-01-01','2999-12-31'),
	(29019,'07','008',' 04','008045',8045,'Pontedassio','Pontedassio','','IM',1,'1840-01-01','2999-12-31'),
	(29020,'07','008',' 04','008046',8046,'Pornassio','Pornassio','','IM',1,'1840-01-01','2999-12-31'),
	(29021,'07','008',' 04','008047',8047,'Prelà','Prelà','','IM',1,'1840-01-01','2999-12-31'),
	(29022,'07','008',' 04','008048',8048,'Ranzo','Ranzo','','IM',1,'1840-01-01','2999-12-31'),
	(29023,'07','008',' 04','008049',8049,'Rezzo','Rezzo','','IM',1,'1840-01-01','2999-12-31'),
	(29024,'07','008',' 05','008050',8050,'Riva Ligure','Riva Ligure','','IM',1,'1840-01-01','2999-12-31'),
	(29025,'07','008',' 05','008051',8051,'Rocchetta Nervina','Rocchetta Nervina','','IM',1,'1840-01-01','2999-12-31'),
	(29026,'07','008',' 05','008052',8052,'San Bartolomeo al Mare','San Bartolomeo al Mare','','IM',1,'1840-01-01','2999-12-31'),
	(29027,'07','008',' 05','008053',8053,'San Biagio della Cima','San Biagio della Cima','','IM',1,'1840-01-01','2999-12-31'),
	(29028,'07','008',' 05','008054',8054,'San Lorenzo al Mare','San Lorenzo al Mare','','IM',1,'1840-01-01','2999-12-31'),
	(29029,'07','008',' 05','008055',8055,'Sanremo','Sanremo','','IM',1,'1840-01-01','2999-12-31'),
	(29030,'07','008',' 05','008056',8056,'Santo Stefano al Mare','Santo Stefano al Mare','','IM',1,'1840-01-01','2999-12-31'),
	(29031,'07','008',' 05','008057',8057,'Seborga','Seborga','','IM',1,'1840-01-01','2999-12-31'),
	(29032,'07','008',' 05','008058',8058,'Soldano','Soldano','','IM',1,'1840-01-01','2999-12-31'),
	(29033,'07','008',' 05','008059',8059,'Taggia','Taggia','','IM',1,'1840-01-01','2999-12-31'),
	(29034,'07','008',' 06','008060',8060,'Terzorio','Terzorio','','IM',1,'1840-01-01','2999-12-31'),
	(29035,'07','008',' 06','008061',8061,'Triora','Triora','','IM',1,'1840-01-01','2999-12-31'),
	(29036,'07','008',' 06','008062',8062,'Vallebona','Vallebona','','IM',1,'1840-01-01','2999-12-31'),
	(29037,'07','008',' 06','008063',8063,'Vallecrosia','Vallecrosia','','IM',1,'1840-01-01','2999-12-31'),
	(29038,'07','008',' 06','008064',8064,'Vasia','Vasia','','IM',1,'1840-01-01','2999-12-31'),
	(29039,'07','008',' 06','008065',8065,'Ventimiglia','Ventimiglia','','IM',1,'1840-01-01','2999-12-31'),
	(29040,'07','008',' 06','008066',8066,'Vessalico','Vessalico','','IM',1,'1840-01-01','2999-12-31'),
	(29041,'07','008',' 06','008067',8067,'Villa Faraldi','Villa Faraldi','','IM',1,'1840-01-01','2999-12-31'),
	(29042,'07','009',' 00','009001',9001,'Alassio','Alassio','','SV',1,'1840-01-01','2999-12-31'),
	(29043,'07','009',' 00','009002',9002,'Albenga','Albenga','','SV',1,'1840-01-01','2999-12-31'),
	(29044,'07','009',' 00','009003',9003,'Albissola Marina','Albissola Marina','','SV',1,'1840-01-01','2999-12-31'),
	(29045,'07','009',' 00','009004',9004,'Albisola Superiore','Albisola Superiore','','SV',1,'1840-01-01','2999-12-31'),
	(29046,'07','009',' 00','009005',9005,'Altare','Altare','','SV',1,'1840-01-01','2999-12-31'),
	(29047,'07','009',' 00','009006',9006,'Andora','Andora','','SV',1,'1840-01-01','2999-12-31'),
	(29048,'07','009',' 00','009007',9007,'Arnasco','Arnasco','','SV',1,'1840-01-01','2999-12-31'),
	(29049,'07','009',' 00','009008',9008,'Balestrino','Balestrino','','SV',1,'1840-01-01','2999-12-31'),
	(29050,'07','009',' 00','009009',9009,'Bardineto','Bardineto','','SV',1,'1840-01-01','2999-12-31'),
	(29051,'07','009',' 01','009010',9010,'Bergeggi','Bergeggi','','SV',1,'1840-01-01','2999-12-31'),
	(29052,'07','009',' 01','009011',9011,'Boissano','Boissano','','SV',1,'1840-01-01','2999-12-31'),
	(29053,'07','009',' 01','009012',9012,'Borghetto Santo Spirito','Borghetto Santo Spirito','','SV',1,'1840-01-01','2999-12-31'),
	(29054,'07','009',' 01','009013',9013,'Borgio Verezzi','Borgio Verezzi','','SV',1,'1840-01-01','2999-12-31'),
	(29055,'07','009',' 01','009014',9014,'Bormida','Bormida','','SV',1,'1840-01-01','2999-12-31'),
	(29056,'07','009',' 01','009015',9015,'Cairo Montenotte','Cairo Montenotte','','SV',1,'1840-01-01','2999-12-31'),
	(29057,'07','009',' 01','009016',9016,'Calice Ligure','Calice Ligure','','SV',1,'1840-01-01','2999-12-31'),
	(29058,'07','009',' 01','009017',9017,'Calizzano','Calizzano','','SV',1,'1840-01-01','2999-12-31'),
	(29059,'07','009',' 01','009018',9018,'Carcare','Carcare','','SV',1,'1840-01-01','2999-12-31'),
	(29060,'07','009',' 01','009019',9019,'Casanova Lerrone','Casanova Lerrone','','SV',1,'1840-01-01','2999-12-31'),
	(29061,'07','009',' 02','009020',9020,'Castelbianco','Castelbianco','','SV',1,'1840-01-01','2999-12-31'),
	(29062,'07','009',' 02','009021',9021,'Castelvecchio di Rocca Barbena','Castelvecchio di Rocca Barbena','','SV',1,'1840-01-01','2999-12-31'),
	(29063,'07','009',' 02','009022',9022,'Celle Ligure','Celle Ligure','','SV',1,'1840-01-01','2999-12-31'),
	(29064,'07','009',' 02','009023',9023,'Cengio','Cengio','','SV',1,'1840-01-01','2999-12-31'),
	(29065,'07','009',' 02','009024',9024,'Ceriale','Ceriale','','SV',1,'1840-01-01','2999-12-31'),
	(29066,'07','009',' 02','009025',9025,'Cisano sul Neva','Cisano sul Neva','','SV',1,'1840-01-01','2999-12-31'),
	(29067,'07','009',' 02','009026',9026,'Cosseria','Cosseria','','SV',1,'1840-01-01','2999-12-31'),
	(29068,'07','009',' 02','009027',9027,'Dego','Dego','','SV',1,'1840-01-01','2999-12-31'),
	(29069,'07','009',' 02','009028',9028,'Erli','Erli','','SV',1,'1840-01-01','2999-12-31'),
	(29070,'07','009',' 02','009029',9029,'Finale Ligure','Finale Ligure','','SV',1,'1840-01-01','2999-12-31'),
	(29071,'07','009',' 03','009030',9030,'Garlenda','Garlenda','','SV',1,'1840-01-01','2999-12-31'),
	(29072,'07','009',' 03','009031',9031,'Giustenice','Giustenice','','SV',1,'1840-01-01','2999-12-31'),
	(29073,'07','009',' 03','009032',9032,'Giusvalla','Giusvalla','','SV',1,'1840-01-01','2999-12-31'),
	(29074,'07','009',' 03','009033',9033,'Laigueglia','Laigueglia','','SV',1,'1840-01-01','2999-12-31'),
	(29075,'07','009',' 03','009034',9034,'Loano','Loano','','SV',1,'1840-01-01','2999-12-31'),
	(29076,'07','009',' 03','009035',9035,'Magliolo','Magliolo','','SV',1,'1840-01-01','2999-12-31'),
	(29077,'07','009',' 03','009036',9036,'Mallare','Mallare','','SV',1,'1840-01-01','2999-12-31'),
	(29078,'07','009',' 03','009037',9037,'Massimino','Massimino','','SV',1,'1840-01-01','2999-12-31'),
	(29079,'07','009',' 03','009038',9038,'Millesimo','Millesimo','','SV',1,'1840-01-01','2999-12-31'),
	(29080,'07','009',' 03','009039',9039,'Mioglia','Mioglia','','SV',1,'1840-01-01','2999-12-31'),
	(29081,'07','009',' 04','009040',9040,'Murialdo','Murialdo','','SV',1,'1840-01-01','2999-12-31'),
	(29082,'07','009',' 04','009041',9041,'Nasino','Nasino','','SV',1,'1840-01-01','2999-12-31'),
	(29083,'07','009',' 04','009042',9042,'Noli','Noli','','SV',1,'1840-01-01','2999-12-31'),
	(29084,'07','009',' 04','009043',9043,'Onzo','Onzo','','SV',1,'1840-01-01','2999-12-31'),
	(29085,'07','009',' 04','009044',9044,'Orco Feglino','Orco Feglino','','SV',1,'1840-01-01','2999-12-31'),
	(29086,'07','009',' 04','009045',9045,'Ortovero','Ortovero','','SV',1,'1840-01-01','2999-12-31'),
	(29087,'07','009',' 04','009046',9046,'Osiglia','Osiglia','','SV',1,'1840-01-01','2999-12-31'),
	(29088,'07','009',' 04','009047',9047,'Pallare','Pallare','','SV',1,'1840-01-01','2999-12-31'),
	(29089,'07','009',' 04','009048',9048,'Piana Crixia','Piana Crixia','','SV',1,'1840-01-01','2999-12-31'),
	(29090,'07','009',' 04','009049',9049,'Pietra Ligure','Pietra Ligure','','SV',1,'1840-01-01','2999-12-31'),
	(29091,'07','009',' 05','009050',9050,'Plodio','Plodio','','SV',1,'1840-01-01','2999-12-31'),
	(29092,'07','009',' 05','009051',9051,'Pontinvrea','Pontinvrea','','SV',1,'1840-01-01','2999-12-31'),
	(29093,'07','009',' 05','009052',9052,'Quiliano','Quiliano','','SV',1,'1840-01-01','2999-12-31'),
	(29094,'07','009',' 05','009053',9053,'Rialto','Rialto','','SV',1,'1840-01-01','2999-12-31'),
	(29095,'07','009',' 05','009054',9054,'Roccavignale','Roccavignale','','SV',1,'1840-01-01','2999-12-31'),
	(29096,'07','009',' 05','009055',9055,'Sassello','Sassello','','SV',1,'1840-01-01','2999-12-31'),
	(29097,'07','009',' 05','009056',9056,'Savona','Savona','','SV',1,'1840-01-01','2999-12-31'),
	(29098,'07','009',' 05','009057',9057,'Spotorno','Spotorno','','SV',1,'1840-01-01','2999-12-31'),
	(29099,'07','009',' 05','009058',9058,'Stella','Stella','','SV',1,'1840-01-01','2999-12-31'),
	(29100,'07','009',' 05','009059',9059,'Stellanello','Stellanello','','SV',1,'1840-01-01','2999-12-31'),
	(29101,'07','009',' 06','009060',9060,'Testico','Testico','','SV',1,'1840-01-01','2999-12-31'),
	(29102,'07','009',' 06','009061',9061,'Toirano','Toirano','','SV',1,'1840-01-01','2999-12-31'),
	(29103,'07','009',' 06','009062',9062,'Tovo San Giacomo','Tovo San Giacomo','','SV',1,'1840-01-01','2999-12-31'),
	(29104,'07','009',' 06','009063',9063,'Urbe','Urbe','','SV',1,'1840-01-01','2999-12-31'),
	(29105,'07','009',' 06','009064',9064,'Vado Ligure','Vado Ligure','','SV',1,'1840-01-01','2999-12-31'),
	(29106,'07','009',' 06','009065',9065,'Varazze','Varazze','','SV',1,'1840-01-01','2999-12-31'),
	(29107,'07','009',' 06','009066',9066,'Vendone','Vendone','','SV',1,'1840-01-01','2999-12-31'),
	(29108,'07','009',' 06','009067',9067,'Vezzi Portio','Vezzi Portio','','SV',1,'1840-01-01','2999-12-31'),
	(29109,'07','009',' 06','009068',9068,'Villanova d\'Albenga','Villanova d\'Albenga','','SV',1,'1840-01-01','2999-12-31'),
	(29110,'07','009',' 06','009069',9069,'Zuccarello','Zuccarello','','SV',1,'1840-01-01','2999-12-31'),
	(29111,'07','010',' 00','010001',10001,'Arenzano','Arenzano','','GE',1,'1840-01-01','2999-12-31'),
	(29112,'07','010',' 00','010002',10002,'Avegno','Avegno','','GE',1,'1840-01-01','2999-12-31'),
	(29113,'07','010',' 00','010003',10003,'Bargagli','Bargagli','','GE',1,'1840-01-01','2999-12-31'),
	(29114,'07','010',' 00','010004',10004,'Bogliasco','Bogliasco','','GE',1,'1840-01-01','2999-12-31'),
	(29115,'07','010',' 00','010005',10005,'Borzonasca','Borzonasca','','GE',1,'1840-01-01','2999-12-31'),
	(29116,'07','010',' 00','010006',10006,'Busalla','Busalla','','GE',1,'1840-01-01','2999-12-31'),
	(29117,'07','010',' 00','010007',10007,'Camogli','Camogli','','GE',1,'1840-01-01','2999-12-31'),
	(29118,'07','010',' 00','010008',10008,'Campo Ligure','Campo Ligure','','GE',1,'1840-01-01','2999-12-31'),
	(29119,'07','010',' 00','010009',10009,'Campomorone','Campomorone','','GE',1,'1840-01-01','2999-12-31'),
	(29120,'07','010',' 01','010010',10010,'Carasco','Carasco','','GE',1,'1840-01-01','2999-12-31'),
	(29121,'07','010',' 01','010011',10011,'Casarza Ligure','Casarza Ligure','','GE',1,'1840-01-01','2999-12-31'),
	(29122,'07','010',' 01','010012',10012,'Casella','Casella','','GE',1,'1840-01-01','2999-12-31'),
	(29123,'07','010',' 01','010013',10013,'Castiglione Chiavarese','Castiglione Chiavarese','','GE',1,'1840-01-01','2999-12-31'),
	(29124,'07','010',' 01','010014',10014,'Ceranesi','Ceranesi','','GE',1,'1840-01-01','2999-12-31'),
	(29125,'07','010',' 01','010015',10015,'Chiavari','Chiavari','','GE',1,'1840-01-01','2999-12-31'),
	(29126,'07','010',' 01','010016',10016,'Cicagna','Cicagna','','GE',1,'1840-01-01','2999-12-31'),
	(29127,'07','010',' 01','010017',10017,'Cogoleto','Cogoleto','','GE',1,'1840-01-01','2999-12-31'),
	(29128,'07','010',' 01','010018',10018,'Cogorno','Cogorno','','GE',1,'1840-01-01','2999-12-31'),
	(29129,'07','010',' 01','010019',10019,'Coreglia Ligure','Coreglia Ligure','','GE',1,'1840-01-01','2999-12-31'),
	(29130,'07','010',' 02','010020',10020,'Crocefieschi','Crocefieschi','','GE',1,'1840-01-01','2999-12-31'),
	(29131,'07','010',' 02','010021',10021,'Davagna','Davagna','','GE',1,'1840-01-01','2999-12-31'),
	(29132,'07','010',' 02','010022',10022,'Fascia','Fascia','','GE',1,'1840-01-01','2999-12-31'),
	(29133,'07','010',' 02','010023',10023,'Favale di Malvaro','Favale di Malvaro','','GE',1,'1840-01-01','2999-12-31'),
	(29134,'07','010',' 02','010024',10024,'Fontanigorda','Fontanigorda','','GE',1,'1840-01-01','2999-12-31'),
	(29135,'07','010',' 02','010025',10025,'Genova','Genova','','GE',1,'1840-01-01','2999-12-31'),
	(29136,'07','010',' 02','010026',10026,'Gorreto','Gorreto','','GE',1,'1840-01-01','2999-12-31'),
	(29137,'07','010',' 02','010027',10027,'Isola del Cantone','Isola del Cantone','','GE',1,'1840-01-01','2999-12-31'),
	(29138,'07','010',' 02','010028',10028,'Lavagna','Lavagna','','GE',1,'1840-01-01','2999-12-31'),
	(29139,'07','010',' 02','010029',10029,'Leivi','Leivi','','GE',1,'1840-01-01','2999-12-31'),
	(29140,'07','010',' 03','010030',10030,'Lorsica','Lorsica','','GE',1,'1840-01-01','2999-12-31'),
	(29141,'07','010',' 03','010031',10031,'Lumarzo','Lumarzo','','GE',1,'1840-01-01','2999-12-31'),
	(29142,'07','010',' 03','010032',10032,'Masone','Masone','','GE',1,'1840-01-01','2999-12-31'),
	(29143,'07','010',' 03','010033',10033,'Mele','Mele','','GE',1,'1840-01-01','2999-12-31'),
	(29144,'07','010',' 03','010034',10034,'Mezzanego','Mezzanego','','GE',1,'1840-01-01','2999-12-31'),
	(29145,'07','010',' 03','010035',10035,'Mignanego','Mignanego','','GE',1,'1840-01-01','2999-12-31'),
	(29146,'07','010',' 03','010036',10036,'Moconesi','Moconesi','','GE',1,'1840-01-01','2999-12-31'),
	(29147,'07','010',' 03','010037',10037,'Moneglia','Moneglia','','GE',1,'1840-01-01','2999-12-31'),
	(29148,'07','010',' 03','010038',10038,'Montebruno','Montebruno','','GE',1,'1840-01-01','2999-12-31'),
	(29149,'07','010',' 03','010039',10039,'Montoggio','Montoggio','','GE',1,'1840-01-01','2999-12-31'),
	(29150,'07','010',' 04','010040',10040,'Ne','Ne','','GE',1,'1840-01-01','2999-12-31'),
	(29151,'07','010',' 04','010041',10041,'Neirone','Neirone','','GE',1,'1840-01-01','2999-12-31'),
	(29152,'07','010',' 04','010042',10042,'Orero','Orero','','GE',1,'1840-01-01','2999-12-31'),
	(29153,'07','010',' 04','010043',10043,'Pieve Ligure','Pieve Ligure','','GE',1,'1840-01-01','2999-12-31'),
	(29154,'07','010',' 04','010044',10044,'Portofino','Portofino','','GE',1,'1840-01-01','2999-12-31'),
	(29155,'07','010',' 04','010045',10045,'Propata','Propata','','GE',1,'1840-01-01','2999-12-31'),
	(29156,'07','010',' 04','010046',10046,'Rapallo','Rapallo','','GE',1,'1840-01-01','2999-12-31'),
	(29157,'07','010',' 04','010047',10047,'Recco','Recco','','GE',1,'1840-01-01','2999-12-31'),
	(29158,'07','010',' 04','010048',10048,'Rezzoaglio','Rezzoaglio','','GE',1,'1840-01-01','2999-12-31'),
	(29159,'07','010',' 04','010049',10049,'Ronco Scrivia','Ronco Scrivia','','GE',1,'1840-01-01','2999-12-31'),
	(29160,'07','010',' 05','010050',10050,'Rondanina','Rondanina','','GE',1,'1840-01-01','2999-12-31'),
	(29161,'07','010',' 05','010051',10051,'Rossiglione','Rossiglione','','GE',1,'1840-01-01','2999-12-31'),
	(29162,'07','010',' 05','010052',10052,'Rovegno','Rovegno','','GE',1,'1840-01-01','2999-12-31'),
	(29163,'07','010',' 05','010053',10053,'San Colombano Certenoli','San Colombano Certenoli','','GE',1,'1840-01-01','2999-12-31'),
	(29164,'07','010',' 05','010054',10054,'Santa Margherita Ligure','Santa Margherita Ligure','','GE',1,'1840-01-01','2999-12-31'),
	(29165,'07','010',' 05','010055',10055,'Sant\'Olcese','Sant\'Olcese','','GE',1,'1840-01-01','2999-12-31'),
	(29166,'07','010',' 05','010056',10056,'Santo Stefano d\'Aveto','Santo Stefano d\'Aveto','','GE',1,'1840-01-01','2999-12-31'),
	(29167,'07','010',' 05','010057',10057,'Savignone','Savignone','','GE',1,'1840-01-01','2999-12-31'),
	(29168,'07','010',' 05','010058',10058,'Serra Riccò','Serra Riccò','','GE',1,'1840-01-01','2999-12-31'),
	(29169,'07','010',' 05','010059',10059,'Sestri Levante','Sestri Levante','','GE',1,'1840-01-01','2999-12-31'),
	(29170,'07','010',' 06','010060',10060,'Sori','Sori','','GE',1,'1840-01-01','2999-12-31'),
	(29171,'07','010',' 06','010061',10061,'Tiglieto','Tiglieto','','GE',1,'1840-01-01','2999-12-31'),
	(29172,'07','010',' 06','010062',10062,'Torriglia','Torriglia','','GE',1,'1840-01-01','2999-12-31'),
	(29173,'07','010',' 06','010063',10063,'Tribogna','Tribogna','','GE',1,'1840-01-01','2999-12-31'),
	(29174,'07','010',' 06','010064',10064,'Uscio','Uscio','','GE',1,'1840-01-01','2999-12-31'),
	(29175,'07','010',' 06','010065',10065,'Valbrevenna','Valbrevenna','','GE',1,'1840-01-01','2999-12-31'),
	(29176,'07','010',' 06','010066',10066,'Vobbia','Vobbia','','GE',1,'1840-01-01','2999-12-31'),
	(29177,'07','010',' 06','010067',10067,'Zoagli','Zoagli','','GE',1,'1840-01-01','2999-12-31'),
	(29178,'07','011',' 00','011001',11001,'Ameglia','Ameglia','','SP',1,'1840-01-01','2999-12-31'),
	(29179,'07','011',' 00','011002',11002,'Arcola','Arcola','','SP',1,'1840-01-01','2999-12-31'),
	(29180,'07','011',' 00','011003',11003,'Beverino','Beverino','','SP',1,'1840-01-01','2999-12-31'),
	(29181,'07','011',' 00','011004',11004,'Bolano','Bolano','','SP',1,'1840-01-01','2999-12-31'),
	(29182,'07','011',' 00','011005',11005,'Bonassola','Bonassola','','SP',1,'1840-01-01','2999-12-31'),
	(29183,'07','011',' 00','011006',11006,'Borghetto di Vara','Borghetto di Vara','','SP',1,'1840-01-01','2999-12-31'),
	(29184,'07','011',' 00','011007',11007,'Brugnato','Brugnato','','SP',1,'1840-01-01','2999-12-31'),
	(29185,'07','011',' 00','011008',11008,'Calice al Cornoviglio','Calice al Cornoviglio','','SP',1,'1840-01-01','2999-12-31'),
	(29186,'07','011',' 00','011009',11009,'Carro','Carro','','SP',1,'1840-01-01','2999-12-31'),
	(29187,'07','011',' 01','011010',11010,'Carrodano','Carrodano','','SP',1,'1840-01-01','2999-12-31'),
	(29188,'07','011',' 01','011011',11011,'Castelnuovo Magra','Castelnuovo Magra','','SP',1,'1840-01-01','2999-12-31'),
	(29189,'07','011',' 01','011012',11012,'Deiva Marina','Deiva Marina','','SP',1,'1840-01-01','2999-12-31'),
	(29190,'07','011',' 01','011013',11013,'Follo','Follo','','SP',1,'1840-01-01','2999-12-31'),
	(29191,'07','011',' 01','011014',11014,'Framura','Framura','','SP',1,'1840-01-01','2999-12-31'),
	(29192,'07','011',' 01','011015',11015,'La Spezia','La Spezia','','SP',1,'1840-01-01','2999-12-31'),
	(29193,'07','011',' 01','011016',11016,'Lerici','Lerici','','SP',1,'1840-01-01','2999-12-31'),
	(29194,'07','011',' 01','011017',11017,'Levanto','Levanto','','SP',1,'1840-01-01','2999-12-31'),
	(29195,'07','011',' 01','011018',11018,'Maissana','Maissana','','SP',1,'1840-01-01','2999-12-31'),
	(29196,'07','011',' 01','011019',11019,'Monterosso al Mare','Monterosso al Mare','','SP',1,'1840-01-01','2999-12-31'),
	(29197,'07','011',' 02','011020',11020,'Ortonovo','Ortonovo','','SP',1,'1840-01-01','2999-12-31'),
	(29198,'07','011',' 02','011021',11021,'Pignone','Pignone','','SP',1,'1840-01-01','2999-12-31'),
	(29199,'07','011',' 02','011022',11022,'Portovenere','Portovenere','','SP',1,'1840-01-01','2999-12-31'),
	(29200,'07','011',' 02','011023',11023,'Riccò del Golfo di Spezia','Riccò del Golfo di Spezia','','SP',1,'1840-01-01','2999-12-31'),
	(29201,'07','011',' 02','011024',11024,'Riomaggiore','Riomaggiore','','SP',1,'1840-01-01','2999-12-31'),
	(29202,'07','011',' 02','011025',11025,'Rocchetta di Vara','Rocchetta di Vara','','SP',1,'1840-01-01','2999-12-31'),
	(29203,'07','011',' 02','011026',11026,'Santo Stefano di Magra','Santo Stefano di Magra','','SP',1,'1840-01-01','2999-12-31'),
	(29204,'07','011',' 02','011027',11027,'Sarzana','Sarzana','','SP',1,'1840-01-01','2999-12-31'),
	(29205,'07','011',' 02','011028',11028,'Sesta Godano','Sesta Godano','','SP',1,'1840-01-01','2999-12-31'),
	(29206,'07','011',' 02','011029',11029,'Varese Ligure','Varese Ligure','','SP',1,'1840-01-01','2999-12-31'),
	(29207,'07','011',' 03','011030',11030,'Vernazza','Vernazza','','SP',1,'1840-01-01','2999-12-31'),
	(29208,'07','011',' 03','011031',11031,'Vezzano Ligure','Vezzano Ligure','','SP',1,'1840-01-01','2999-12-31'),
	(29209,'07','011',' 03','011032',11032,'Zignago','Zignago','','SP',1,'1840-01-01','2999-12-31'),
	(29210,'03','012',' 00','012001',12001,'Agra','Agra','','VA',1,'1840-01-01','2999-12-31'),
	(29211,'03','012',' 00','012002',12002,'Albizzate','Albizzate','','VA',1,'1840-01-01','2999-12-31'),
	(29212,'03','012',' 00','012003',12003,'Angera','Angera','','VA',1,'1840-01-01','2999-12-31'),
	(29213,'03','012',' 00','012004',12004,'Arcisate','Arcisate','','VA',1,'1840-01-01','2999-12-31'),
	(29214,'03','012',' 00','012005',12005,'Arsago Seprio','Arsago Seprio','','VA',1,'1840-01-01','2999-12-31'),
	(29215,'03','012',' 00','012006',12006,'Azzate','Azzate','','VA',1,'1840-01-01','2999-12-31'),
	(29216,'03','012',' 00','012007',12007,'Azzio','Azzio','','VA',1,'1840-01-01','2999-12-31'),
	(29217,'03','012',' 00','012008',12008,'Barasso','Barasso','','VA',1,'1840-01-01','2999-12-31'),
	(29218,'03','012',' 00','012009',12009,'Bardello','Bardello','','VA',1,'1840-01-01','2999-12-31'),
	(29219,'03','012',' 01','012010',12010,'Bedero Valcuvia','Bedero Valcuvia','','VA',1,'1840-01-01','2999-12-31'),
	(29220,'03','012',' 01','012011',12011,'Besano','Besano','','VA',1,'1840-01-01','2999-12-31'),
	(29221,'03','012',' 01','012012',12012,'Besnate','Besnate','','VA',1,'1840-01-01','2999-12-31'),
	(29222,'03','012',' 01','012013',12013,'Besozzo','Besozzo','','VA',1,'1840-01-01','2999-12-31'),
	(29223,'03','012',' 01','012014',12014,'Biandronno','Biandronno','','VA',1,'1840-01-01','2999-12-31'),
	(29224,'03','012',' 01','012015',12015,'Bisuschio','Bisuschio','','VA',1,'1840-01-01','2999-12-31'),
	(29225,'03','012',' 01','012016',12016,'Bodio Lomnago','Bodio Lomnago','','VA',1,'1840-01-01','2999-12-31'),
	(29226,'03','012',' 01','012017',12017,'Brebbia','Brebbia','','VA',1,'1840-01-01','2999-12-31'),
	(29227,'03','012',' 01','012018',12018,'Bregano','Bregano','','VA',1,'1840-01-01','2999-12-31'),
	(29228,'03','012',' 01','012019',12019,'Brenta','Brenta','','VA',1,'1840-01-01','2999-12-31'),
	(29229,'03','012',' 02','012020',12020,'Brezzo di Bedero','Brezzo di Bedero','','VA',1,'1840-01-01','2999-12-31'),
	(29230,'03','012',' 02','012021',12021,'Brinzio','Brinzio','','VA',1,'1840-01-01','2999-12-31'),
	(29231,'03','012',' 02','012022',12022,'Brissago-Valtravaglia','Brissago-Valtravaglia','','VA',1,'1840-01-01','2999-12-31'),
	(29232,'03','012',' 02','012023',12023,'Brunello','Brunello','','VA',1,'1840-01-01','2999-12-31'),
	(29233,'03','012',' 02','012024',12024,'Brusimpiano','Brusimpiano','','VA',1,'1840-01-01','2999-12-31'),
	(29234,'03','012',' 02','012025',12025,'Buguggiate','Buguggiate','','VA',1,'1840-01-01','2999-12-31'),
	(29235,'03','012',' 02','012026',12026,'Busto Arsizio','Busto Arsizio','','VA',1,'1840-01-01','2999-12-31'),
	(29236,'03','012',' 02','012027',12027,'Cadegliano-Viconago','Cadegliano-Viconago','','VA',1,'1840-01-01','2999-12-31'),
	(29237,'03','012',' 02','012028',12028,'Cadrezzate','Cadrezzate','','VA',1,'1840-01-01','2999-12-31'),
	(29238,'03','012',' 02','012029',12029,'Cairate','Cairate','','VA',1,'1840-01-01','2999-12-31'),
	(29239,'03','012',' 03','012030',12030,'Cantello','Cantello','','VA',1,'1840-01-01','2999-12-31'),
	(29240,'03','012',' 03','012031',12031,'Caravate','Caravate','','VA',1,'1840-01-01','2999-12-31'),
	(29241,'03','012',' 03','012032',12032,'Cardano al Campo','Cardano al Campo','','VA',1,'1840-01-01','2999-12-31'),
	(29242,'03','012',' 03','012033',12033,'Carnago','Carnago','','VA',1,'1840-01-01','2999-12-31'),
	(29243,'03','012',' 03','012034',12034,'Caronno Pertusella','Caronno Pertusella','','VA',1,'1840-01-01','2999-12-31'),
	(29244,'03','012',' 03','012035',12035,'Caronno Varesino','Caronno Varesino','','VA',1,'1840-01-01','2999-12-31'),
	(29245,'03','012',' 03','012036',12036,'Casale Litta','Casale Litta','','VA',1,'1840-01-01','2999-12-31'),
	(29246,'03','012',' 03','012037',12037,'Casalzuigno','Casalzuigno','','VA',1,'1840-01-01','2999-12-31'),
	(29247,'03','012',' 03','012038',12038,'Casciago','Casciago','','VA',1,'1840-01-01','2999-12-31'),
	(29248,'03','012',' 03','012039',12039,'Casorate Sempione','Casorate Sempione','','VA',1,'1840-01-01','2999-12-31'),
	(29249,'03','012',' 04','012040',12040,'Cassano Magnago','Cassano Magnago','','VA',1,'1840-01-01','2999-12-31'),
	(29250,'03','012',' 04','012041',12041,'Cassano Valcuvia','Cassano Valcuvia','','VA',1,'1840-01-01','2999-12-31'),
	(29251,'03','012',' 04','012042',12042,'Castellanza','Castellanza','','VA',1,'1840-01-01','2999-12-31'),
	(29252,'03','012',' 04','012043',12043,'Castello Cabiaglio','Castello Cabiaglio','','VA',1,'1840-01-01','2999-12-31'),
	(29253,'03','012',' 04','012044',12044,'Castelseprio','Castelseprio','','VA',1,'1840-01-01','2999-12-31'),
	(29254,'03','012',' 04','012045',12045,'Castelveccana','Castelveccana','','VA',1,'1840-01-01','2999-12-31'),
	(29255,'03','012',' 04','012046',12046,'Castiglione Olona','Castiglione Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29256,'03','012',' 04','012047',12047,'Castronno','Castronno','','VA',1,'1840-01-01','2999-12-31'),
	(29257,'03','012',' 04','012048',12048,'Cavaria con Premezzo','Cavaria con Premezzo','','VA',1,'1840-01-01','2999-12-31'),
	(29258,'03','012',' 04','012049',12049,'Cazzago Brabbia','Cazzago Brabbia','','VA',1,'1840-01-01','2999-12-31'),
	(29259,'03','012',' 05','012050',12050,'Cislago','Cislago','','VA',1,'1840-01-01','2999-12-31'),
	(29260,'03','012',' 05','012051',12051,'Cittiglio','Cittiglio','','VA',1,'1840-01-01','2999-12-31'),
	(29261,'03','012',' 05','012052',12052,'Clivio','Clivio','','VA',1,'1840-01-01','2999-12-31'),
	(29262,'03','012',' 05','012053',12053,'Cocquio-Trevisago','Cocquio-Trevisago','','VA',1,'1840-01-01','2999-12-31'),
	(29263,'03','012',' 05','012054',12054,'Comabbio','Comabbio','','VA',1,'1840-01-01','2999-12-31'),
	(29264,'03','012',' 05','012055',12055,'Comerio','Comerio','','VA',1,'1840-01-01','2999-12-31'),
	(29265,'03','012',' 05','012056',12056,'Cremenaga','Cremenaga','','VA',1,'1840-01-01','2999-12-31'),
	(29266,'03','012',' 05','012057',12057,'Crosio della Valle','Crosio della Valle','','VA',1,'1840-01-01','2999-12-31'),
	(29267,'03','012',' 05','012058',12058,'Cuasso al Monte','Cuasso al Monte','','VA',1,'1840-01-01','2999-12-31'),
	(29268,'03','012',' 05','012059',12059,'Cugliate-Fabiasco','Cugliate-Fabiasco','','VA',1,'1840-01-01','2999-12-31'),
	(29269,'03','012',' 06','012060',12060,'Cunardo','Cunardo','','VA',1,'1840-01-01','2999-12-31'),
	(29270,'03','012',' 06','012061',12061,'Curiglia con Monteviasco','Curiglia con Monteviasco','','VA',1,'1840-01-01','2999-12-31'),
	(29271,'03','012',' 06','012062',12062,'Cuveglio','Cuveglio','','VA',1,'1840-01-01','2999-12-31'),
	(29272,'03','012',' 06','012063',12063,'Cuvio','Cuvio','','VA',1,'1840-01-01','2999-12-31'),
	(29273,'03','012',' 06','012064',12064,'Daverio','Daverio','','VA',1,'1840-01-01','2999-12-31'),
	(29274,'03','012',' 06','012065',12065,'Dumenza','Dumenza','','VA',1,'1840-01-01','2999-12-31'),
	(29275,'03','012',' 06','012066',12066,'Duno','Duno','','VA',1,'1840-01-01','2999-12-31'),
	(29276,'03','012',' 06','012067',12067,'Fagnano Olona','Fagnano Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29277,'03','012',' 06','012068',12068,'Ferno','Ferno','','VA',1,'1840-01-01','2999-12-31'),
	(29278,'03','012',' 06','012069',12069,'Ferrera di Varese','Ferrera di Varese','','VA',1,'1840-01-01','2999-12-31'),
	(29279,'03','012',' 07','012070',12070,'Gallarate','Gallarate','','VA',1,'1840-01-01','2999-12-31'),
	(29280,'03','012',' 07','012071',12071,'Galliate Lombardo','Galliate Lombardo','','VA',1,'1840-01-01','2999-12-31'),
	(29281,'03','012',' 07','012072',12072,'Gavirate','Gavirate','','VA',1,'1840-01-01','2999-12-31'),
	(29282,'03','012',' 07','012073',12073,'Gazzada Schianno','Gazzada Schianno','','VA',1,'1840-01-01','2999-12-31'),
	(29283,'03','012',' 07','012074',12074,'Gemonio','Gemonio','','VA',1,'1840-01-01','2999-12-31'),
	(29284,'03','012',' 07','012075',12075,'Gerenzano','Gerenzano','','VA',1,'1840-01-01','2999-12-31'),
	(29285,'03','012',' 07','012076',12076,'Germignaga','Germignaga','','VA',1,'1840-01-01','2999-12-31'),
	(29286,'03','012',' 07','012077',12077,'Golasecca','Golasecca','','VA',1,'1840-01-01','2999-12-31'),
	(29287,'03','012',' 07','012078',12078,'Gorla Maggiore','Gorla Maggiore','','VA',1,'1840-01-01','2999-12-31'),
	(29288,'03','012',' 07','012079',12079,'Gorla Minore','Gorla Minore','','VA',1,'1840-01-01','2999-12-31'),
	(29289,'03','012',' 08','012080',12080,'Gornate-Olona','Gornate-Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29290,'03','012',' 08','012081',12081,'Grantola','Grantola','','VA',1,'1840-01-01','2999-12-31'),
	(29291,'03','012',' 08','012082',12082,'Inarzo','Inarzo','','VA',1,'1840-01-01','2999-12-31'),
	(29292,'03','012',' 08','012083',12083,'Induno Olona','Induno Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29293,'03','012',' 08','012084',12084,'Ispra','Ispra','','VA',1,'1840-01-01','2999-12-31'),
	(29294,'03','012',' 08','012085',12085,'Jerago con Orago','Jerago con Orago','','VA',1,'1840-01-01','2999-12-31'),
	(29295,'03','012',' 08','012086',12086,'Lavena Ponte Tresa','Lavena Ponte Tresa','','VA',1,'1840-01-01','2999-12-31'),
	(29296,'03','012',' 08','012087',12087,'Laveno-Mombello','Laveno-Mombello','','VA',1,'1840-01-01','2999-12-31'),
	(29297,'03','012',' 08','012088',12088,'Leggiuno','Leggiuno','','VA',1,'1840-01-01','2999-12-31'),
	(29298,'03','012',' 08','012089',12089,'Lonate Ceppino','Lonate Ceppino','','VA',1,'1840-01-01','2999-12-31'),
	(29299,'03','012',' 09','012090',12090,'Lonate Pozzolo','Lonate Pozzolo','','VA',1,'1840-01-01','2999-12-31'),
	(29300,'03','012',' 09','012091',12091,'Lozza','Lozza','','VA',1,'1840-01-01','2999-12-31'),
	(29301,'03','012',' 09','012092',12092,'Luino','Luino','','VA',1,'1840-01-01','2999-12-31'),
	(29302,'03','012',' 09','012093',12093,'Luvinate','Luvinate','','VA',1,'1840-01-01','2999-12-31'),
	(29303,'03','012',' 09','012094',12094,'Maccagno','Maccagno','','VA',1,'1840-01-01','2999-12-31'),
	(29304,'03','012',' 09','012095',12095,'Malgesso','Malgesso','','VA',1,'1840-01-01','2999-12-31'),
	(29305,'03','012',' 09','012096',12096,'Malnate','Malnate','','VA',1,'1840-01-01','2999-12-31'),
	(29306,'03','012',' 09','012097',12097,'Marchirolo','Marchirolo','','VA',1,'1840-01-01','2999-12-31'),
	(29307,'03','012',' 09','012098',12098,'Marnate','Marnate','','VA',1,'1840-01-01','2999-12-31'),
	(29308,'03','012',' 09','012099',12099,'Marzio','Marzio','','VA',1,'1840-01-01','2999-12-31'),
	(29309,'03','012',' 10','012100',12100,'Masciago Primo','Masciago Primo','','VA',1,'1840-01-01','2999-12-31'),
	(29310,'03','012',' 10','012101',12101,'Mercallo','Mercallo','','VA',1,'1840-01-01','2999-12-31'),
	(29311,'03','012',' 10','012102',12102,'Mesenzana','Mesenzana','','VA',1,'1840-01-01','2999-12-31'),
	(29312,'03','012',' 10','012103',12103,'Montegrino Valtravaglia','Montegrino Valtravaglia','','VA',1,'1840-01-01','2999-12-31'),
	(29313,'03','012',' 10','012104',12104,'Monvalle','Monvalle','','VA',1,'1840-01-01','2999-12-31'),
	(29314,'03','012',' 10','012105',12105,'Morazzone','Morazzone','','VA',1,'1840-01-01','2999-12-31'),
	(29315,'03','012',' 10','012106',12106,'Mornago','Mornago','','VA',1,'1840-01-01','2999-12-31'),
	(29316,'03','012',' 10','012107',12107,'Oggiona con Santo Stefano','Oggiona con Santo Stefano','','VA',1,'1840-01-01','2999-12-31'),
	(29317,'03','012',' 10','012108',12108,'Olgiate Olona','Olgiate Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29318,'03','012',' 10','012109',12109,'Origgio','Origgio','','VA',1,'1840-01-01','2999-12-31'),
	(29319,'03','012',' 11','012110',12110,'Orino','Orino','','VA',1,'1840-01-01','2999-12-31'),
	(29320,'03','012',' 11','012111',12111,'Osmate','Osmate','','VA',1,'1840-01-01','2999-12-31'),
	(29321,'03','012',' 11','012112',12112,'Pino sulla Sponda del Lago Maggiore','Pino sulla Sponda del Lago Maggiore','','VA',1,'1840-01-01','2999-12-31'),
	(29322,'03','012',' 11','012113',12113,'Porto Ceresio','Porto Ceresio','','VA',1,'1840-01-01','2999-12-31'),
	(29323,'03','012',' 11','012114',12114,'Porto Valtravaglia','Porto Valtravaglia','','VA',1,'1840-01-01','2999-12-31'),
	(29324,'03','012',' 11','012115',12115,'Rancio Valcuvia','Rancio Valcuvia','','VA',1,'1840-01-01','2999-12-31'),
	(29325,'03','012',' 11','012116',12116,'Ranco','Ranco','','VA',1,'1840-01-01','2999-12-31'),
	(29326,'03','012',' 11','012117',12117,'Saltrio','Saltrio','','VA',1,'1840-01-01','2999-12-31'),
	(29327,'03','012',' 11','012118',12118,'Samarate','Samarate','','VA',1,'1840-01-01','2999-12-31'),
	(29328,'03','012',' 11','012119',12119,'Saronno','Saronno','','VA',1,'1840-01-01','2999-12-31'),
	(29329,'03','012',' 12','012120',12120,'Sesto Calende','Sesto Calende','','VA',1,'1840-01-01','2999-12-31'),
	(29330,'03','012',' 12','012121',12121,'Solbiate Arno','Solbiate Arno','','VA',1,'1840-01-01','2999-12-31'),
	(29331,'03','012',' 12','012122',12122,'Solbiate Olona','Solbiate Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29332,'03','012',' 12','012123',12123,'Somma Lombardo','Somma Lombardo','','VA',1,'1840-01-01','2999-12-31'),
	(29333,'03','012',' 12','012124',12124,'Sumirago','Sumirago','','VA',1,'1840-01-01','2999-12-31'),
	(29334,'03','012',' 12','012125',12125,'Taino','Taino','','VA',1,'1840-01-01','2999-12-31'),
	(29335,'03','012',' 12','012126',12126,'Ternate','Ternate','','VA',1,'1840-01-01','2999-12-31'),
	(29336,'03','012',' 12','012127',12127,'Tradate','Tradate','','VA',1,'1840-01-01','2999-12-31'),
	(29337,'03','012',' 12','012128',12128,'Travedona-Monate','Travedona-Monate','','VA',1,'1840-01-01','2999-12-31'),
	(29338,'03','012',' 12','012129',12129,'Tronzano Lago Maggiore','Tronzano Lago Maggiore','','VA',1,'1840-01-01','2999-12-31'),
	(29339,'03','012',' 13','012130',12130,'Uboldo','Uboldo','','VA',1,'1840-01-01','2999-12-31'),
	(29340,'03','012',' 13','012131',12131,'Valganna','Valganna','','VA',1,'1840-01-01','2999-12-31'),
	(29341,'03','012',' 13','012132',12132,'Varano Borghi','Varano Borghi','','VA',1,'1840-01-01','2999-12-31'),
	(29342,'03','012',' 13','012133',12133,'Varese','Varese','','VA',1,'1840-01-01','2999-12-31'),
	(29343,'03','012',' 13','012134',12134,'Vedano Olona','Vedano Olona','','VA',1,'1840-01-01','2999-12-31'),
	(29344,'03','012',' 13','012135',12135,'Veddasca','Veddasca','','VA',1,'1840-01-01','2999-12-31'),
	(29345,'03','012',' 13','012136',12136,'Venegono Inferiore','Venegono Inferiore','','VA',1,'1840-01-01','2999-12-31'),
	(29346,'03','012',' 13','012137',12137,'Venegono Superiore','Venegono Superiore','','VA',1,'1840-01-01','2999-12-31'),
	(29347,'03','012',' 13','012138',12138,'Vergiate','Vergiate','','VA',1,'1840-01-01','2999-12-31'),
	(29348,'03','012',' 13','012139',12139,'Viggiù','Viggiù','','VA',1,'1840-01-01','2999-12-31'),
	(29349,'03','012',' 14','012140',12140,'Vizzola Ticino','Vizzola Ticino','','VA',1,'1840-01-01','2999-12-31'),
	(29350,'03','012',' 14','012141',12141,'Sangiano','Sangiano','','VA',1,'1840-01-01','2999-12-31'),
	(29351,'03','013',' 00','013003',13003,'Albavilla','Albavilla','','CO',1,'1840-01-01','2999-12-31'),
	(29352,'03','013',' 00','013004',13004,'Albese con Cassano','Albese con Cassano','','CO',1,'1840-01-01','2999-12-31'),
	(29353,'03','013',' 00','013005',13005,'Albiolo','Albiolo','','CO',1,'1840-01-01','2999-12-31'),
	(29354,'03','013',' 00','013006',13006,'Alserio','Alserio','','CO',1,'1840-01-01','2999-12-31'),
	(29355,'03','013',' 00','013007',13007,'Alzate Brianza','Alzate Brianza','','CO',1,'1840-01-01','2999-12-31'),
	(29356,'03','013',' 00','013009',13009,'Anzano del Parco','Anzano del Parco','','CO',1,'1840-01-01','2999-12-31'),
	(29357,'03','013',' 01','013010',13010,'Appiano Gentile','Appiano Gentile','','CO',1,'1840-01-01','2999-12-31'),
	(29358,'03','013',' 01','013011',13011,'Argegno','Argegno','','CO',1,'1840-01-01','2999-12-31'),
	(29359,'03','013',' 01','013012',13012,'Arosio','Arosio','','CO',1,'1840-01-01','2999-12-31'),
	(29360,'03','013',' 01','013013',13013,'Asso','Asso','','CO',1,'1840-01-01','2999-12-31'),
	(29361,'03','013',' 01','013015',13015,'Barni','Barni','','CO',1,'1840-01-01','2999-12-31'),
	(29362,'03','013',' 01','013019',13019,'Bellagio','Bellagio','','CO',1,'1840-01-01','2999-12-31'),
	(29363,'03','013',' 02','013021',13021,'Bene Lario','Bene Lario','','CO',1,'1840-01-01','2999-12-31'),
	(29364,'03','013',' 02','013022',13022,'Beregazzo con Figliaro','Beregazzo con Figliaro','','CO',1,'1840-01-01','2999-12-31'),
	(29365,'03','013',' 02','013023',13023,'Binago','Binago','','CO',1,'1840-01-01','2999-12-31'),
	(29366,'03','013',' 02','013024',13024,'Bizzarone','Bizzarone','','CO',1,'1840-01-01','2999-12-31'),
	(29367,'03','013',' 02','013025',13025,'Blessagno','Blessagno','','CO',1,'1840-01-01','2999-12-31'),
	(29368,'03','013',' 02','013026',13026,'Blevio','Blevio','','CO',1,'1840-01-01','2999-12-31'),
	(29369,'03','013',' 02','013028',13028,'Bregnano','Bregnano','','CO',1,'1840-01-01','2999-12-31'),
	(29370,'03','013',' 02','013029',13029,'Brenna','Brenna','','CO',1,'1840-01-01','2999-12-31'),
	(29371,'03','013',' 03','013030',13030,'Brienno','Brienno','','CO',1,'1840-01-01','2999-12-31'),
	(29372,'03','013',' 03','013032',13032,'Brunate','Brunate','','CO',1,'1840-01-01','2999-12-31'),
	(29373,'03','013',' 03','013034',13034,'Bulgarograsso','Bulgarograsso','','CO',1,'1840-01-01','2999-12-31'),
	(29374,'03','013',' 03','013035',13035,'Cabiate','Cabiate','','CO',1,'1840-01-01','2999-12-31'),
	(29375,'03','013',' 03','013036',13036,'Cadorago','Cadorago','','CO',1,'1840-01-01','2999-12-31'),
	(29376,'03','013',' 03','013037',13037,'Caglio','Caglio','','CO',1,'1840-01-01','2999-12-31'),
	(29377,'03','013',' 03','013038',13038,'Cagno','Cagno','','CO',1,'1840-01-01','2999-12-31'),
	(29378,'03','013',' 04','013040',13040,'Campione d\'Italia','Campione d\'Italia','','CO',1,'1840-01-01','2999-12-31'),
	(29379,'03','013',' 04','013041',13041,'Cantù','Cantù','','CO',1,'1840-01-01','2999-12-31'),
	(29380,'03','013',' 04','013042',13042,'Canzo','Canzo','','CO',1,'1840-01-01','2999-12-31'),
	(29381,'03','013',' 04','013043',13043,'Capiago Intimiano','Capiago Intimiano','','CO',1,'1840-01-01','2999-12-31'),
	(29382,'03','013',' 04','013044',13044,'Carate Urio','Carate Urio','','CO',1,'1840-01-01','2999-12-31'),
	(29383,'03','013',' 04','013045',13045,'Carbonate','Carbonate','','CO',1,'1840-01-01','2999-12-31'),
	(29384,'03','013',' 04','013046',13046,'Carimate','Carimate','','CO',1,'1840-01-01','2999-12-31'),
	(29385,'03','013',' 04','013047',13047,'Carlazzo','Carlazzo','','CO',1,'1840-01-01','2999-12-31'),
	(29386,'03','013',' 04','013048',13048,'Carugo','Carugo','','CO',1,'1840-01-01','2999-12-31'),
	(29387,'03','013',' 05','013050',13050,'Casasco d\'Intelvi','Casasco d\'Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29388,'03','013',' 05','013052',13052,'Caslino d\'Erba','Caslino d\'Erba','','CO',1,'1840-01-01','2999-12-31'),
	(29389,'03','013',' 05','013053',13053,'Casnate con Bernate','Casnate con Bernate','','CO',1,'1840-01-01','2999-12-31'),
	(29390,'03','013',' 05','013055',13055,'Cassina Rizzardi','Cassina Rizzardi','','CO',1,'1840-01-01','2999-12-31'),
	(29391,'03','013',' 05','013058',13058,'Castelmarte','Castelmarte','','CO',1,'1840-01-01','2999-12-31'),
	(29392,'03','013',' 05','013059',13059,'Castelnuovo Bozzente','Castelnuovo Bozzente','','CO',1,'1840-01-01','2999-12-31'),
	(29393,'03','013',' 06','013060',13060,'Castiglione d\'Intelvi','Castiglione d\'Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29394,'03','013',' 06','013061',13061,'Cavallasca','Cavallasca','','CO',1,'1840-01-01','2999-12-31'),
	(29395,'03','013',' 06','013062',13062,'Cavargna','Cavargna','','CO',1,'1840-01-01','2999-12-31'),
	(29396,'03','013',' 06','013063',13063,'Cerano d\'Intelvi','Cerano d\'Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29397,'03','013',' 06','013064',13064,'Cermenate','Cermenate','','CO',1,'1840-01-01','2999-12-31'),
	(29398,'03','013',' 06','013065',13065,'Cernobbio','Cernobbio','','CO',1,'1840-01-01','2999-12-31'),
	(29399,'03','013',' 06','013068',13068,'Cirimido','Cirimido','','CO',1,'1840-01-01','2999-12-31'),
	(29400,'03','013',' 07','013070',13070,'Civenna','Civenna','','CO',1,'1840-01-01','2999-12-31'),
	(29401,'03','013',' 07','013071',13071,'Claino con Osteno','Claino con Osteno','','CO',1,'1840-01-01','2999-12-31'),
	(29402,'03','013',' 07','013074',13074,'Colonno','Colonno','','CO',1,'1840-01-01','2999-12-31'),
	(29403,'03','013',' 07','013075',13075,'Como','Como','','CO',1,'1840-01-01','2999-12-31'),
	(29404,'03','013',' 07','013076',13076,'Consiglio di Rumo','Consiglio di Rumo','','',1,'1840-01-01','2999-12-31'),
	(29405,'03','013',' 07','013077',13077,'Corrido','Corrido','','CO',1,'1840-01-01','2999-12-31'),
	(29406,'03','013',' 08','013083',13083,'Cremia','Cremia','','CO',1,'1840-01-01','2999-12-31'),
	(29407,'03','013',' 08','013084',13084,'Cucciago','Cucciago','','CO',1,'1840-01-01','2999-12-31'),
	(29408,'03','013',' 08','013085',13085,'Cusino','Cusino','','CO',1,'1840-01-01','2999-12-31'),
	(29409,'03','013',' 08','013087',13087,'Dizzasco','Dizzasco','','CO',1,'1840-01-01','2999-12-31'),
	(29410,'03','013',' 08','013089',13089,'Domaso','Domaso','','CO',1,'1840-01-01','2999-12-31'),
	(29411,'03','013',' 09','013090',13090,'Dongo','Dongo','','CO',1,'1840-01-01','2999-12-31'),
	(29412,'03','013',' 09','013092',13092,'Dosso del Liro','Dosso del Liro','','CO',1,'1840-01-01','2999-12-31'),
	(29413,'03','013',' 09','013093',13093,'Drezzo','Drezzo','','CO',1,'1840-01-01','2999-12-31'),
	(29414,'03','013',' 09','013095',13095,'Erba','Erba','','CO',1,'1840-01-01','2999-12-31'),
	(29415,'03','013',' 09','013097',13097,'Eupilio','Eupilio','','CO',1,'1840-01-01','2999-12-31'),
	(29416,'03','013',' 09','013098',13098,'Faggeto Lario','Faggeto Lario','','CO',1,'1840-01-01','2999-12-31'),
	(29417,'03','013',' 09','013099',13099,'Faloppio','Faloppio','','CO',1,'1840-01-01','2999-12-31'),
	(29418,'03','013',' 10','013100',13100,'Fenegrò','Fenegrò','','CO',1,'1840-01-01','2999-12-31'),
	(29419,'03','013',' 10','013101',13101,'Figino Serenza','Figino Serenza','','CO',1,'1840-01-01','2999-12-31'),
	(29420,'03','013',' 10','013102',13102,'Fino Mornasco','Fino Mornasco','','CO',1,'1840-01-01','2999-12-31'),
	(29421,'03','013',' 10','013106',13106,'Garzeno','Garzeno','','CO',1,'1840-01-01','2999-12-31'),
	(29422,'03','013',' 10','013107',13107,'Gera Lario','Gera Lario','','CO',1,'1840-01-01','2999-12-31'),
	(29423,'03','013',' 10','013108',13108,'Germasino','Germasino','','',1,'1840-01-01','2999-12-31'),
	(29424,'03','013',' 10','013109',13109,'Gironico','Gironico','','CO',1,'1840-01-01','2999-12-31'),
	(29425,'03','013',' 11','013110',13110,'Grandate','Grandate','','CO',1,'1840-01-01','2999-12-31'),
	(29426,'03','013',' 11','013111',13111,'Grandola ed Uniti','Grandola ed Uniti','','CO',1,'1840-01-01','2999-12-31'),
	(29427,'03','013',' 11','013112',13112,'Gravedona','Gravedona','','',1,'1840-01-01','2999-12-31'),
	(29428,'03','013',' 11','013113',13113,'Griante','Griante','','CO',1,'1840-01-01','2999-12-31'),
	(29429,'03','013',' 11','013114',13114,'Guanzate','Guanzate','','CO',1,'1840-01-01','2999-12-31'),
	(29430,'03','013',' 11','013118',13118,'Inverigo','Inverigo','','CO',1,'1840-01-01','2999-12-31'),
	(29431,'03','013',' 11','013119',13119,'Laglio','Laglio','','CO',1,'1840-01-01','2999-12-31'),
	(29432,'03','013',' 12','013120',13120,'Laino','Laino','','CO',1,'1840-01-01','2999-12-31'),
	(29433,'03','013',' 12','013121',13121,'Lambrugo','Lambrugo','','CO',1,'1840-01-01','2999-12-31'),
	(29434,'03','013',' 12','013122',13122,'Lanzo d\'Intelvi','Lanzo d\'Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29435,'03','013',' 12','013123',13123,'Lasnigo','Lasnigo','','CO',1,'1840-01-01','2999-12-31'),
	(29436,'03','013',' 12','013125',13125,'Lenno','Lenno','','CO',1,'1840-01-01','2999-12-31'),
	(29437,'03','013',' 12','013126',13126,'Lezzeno','Lezzeno','','CO',1,'1840-01-01','2999-12-31'),
	(29438,'03','013',' 12','013128',13128,'Limido Comasco','Limido Comasco','','CO',1,'1840-01-01','2999-12-31'),
	(29439,'03','013',' 12','013129',13129,'Lipomo','Lipomo','','CO',1,'1840-01-01','2999-12-31'),
	(29440,'03','013',' 13','013130',13130,'Livo','Livo','','CO',1,'1840-01-01','2999-12-31'),
	(29441,'03','013',' 13','013131',13131,'Locate Varesino','Locate Varesino','','CO',1,'1840-01-01','2999-12-31'),
	(29442,'03','013',' 13','013133',13133,'Lomazzo','Lomazzo','','CO',1,'1840-01-01','2999-12-31'),
	(29443,'03','013',' 13','013134',13134,'Longone al Segrino','Longone al Segrino','','CO',1,'1840-01-01','2999-12-31'),
	(29444,'03','013',' 13','013135',13135,'Luisago','Luisago','','CO',1,'1840-01-01','2999-12-31'),
	(29445,'03','013',' 13','013136',13136,'Lurago d\'Erba','Lurago d\'Erba','','CO',1,'1840-01-01','2999-12-31'),
	(29446,'03','013',' 13','013137',13137,'Lurago Marinone','Lurago Marinone','','CO',1,'1840-01-01','2999-12-31'),
	(29447,'03','013',' 13','013138',13138,'Lurate Caccivio','Lurate Caccivio','','CO',1,'1840-01-01','2999-12-31'),
	(29448,'03','013',' 13','013139',13139,'Magreglio','Magreglio','','CO',1,'1840-01-01','2999-12-31'),
	(29449,'03','013',' 14','013143',13143,'Mariano Comense','Mariano Comense','','CO',1,'1840-01-01','2999-12-31'),
	(29450,'03','013',' 14','013144',13144,'Maslianico','Maslianico','','CO',1,'1840-01-01','2999-12-31'),
	(29451,'03','013',' 14','013145',13145,'Menaggio','Menaggio','','CO',1,'1840-01-01','2999-12-31'),
	(29452,'03','013',' 14','013147',13147,'Merone','Merone','','CO',1,'1840-01-01','2999-12-31'),
	(29453,'03','013',' 14','013148',13148,'Mezzegra','Mezzegra','','CO',1,'1840-01-01','2999-12-31'),
	(29454,'03','013',' 15','013152',13152,'Moltrasio','Moltrasio','','CO',1,'1840-01-01','2999-12-31'),
	(29455,'03','013',' 15','013153',13153,'Monguzzo','Monguzzo','','CO',1,'1840-01-01','2999-12-31'),
	(29456,'03','013',' 15','013154',13154,'Montano Lucino','Montano Lucino','','CO',1,'1840-01-01','2999-12-31'),
	(29457,'03','013',' 15','013155',13155,'Montemezzo','Montemezzo','','CO',1,'1840-01-01','2999-12-31'),
	(29458,'03','013',' 15','013157',13157,'Montorfano','Montorfano','','CO',1,'1840-01-01','2999-12-31'),
	(29459,'03','013',' 15','013159',13159,'Mozzate','Mozzate','','CO',1,'1840-01-01','2999-12-31'),
	(29460,'03','013',' 16','013160',13160,'Musso','Musso','','CO',1,'1840-01-01','2999-12-31'),
	(29461,'03','013',' 16','013161',13161,'Nesso','Nesso','','CO',1,'1840-01-01','2999-12-31'),
	(29462,'03','013',' 16','013163',13163,'Novedrate','Novedrate','','CO',1,'1840-01-01','2999-12-31'),
	(29463,'03','013',' 16','013165',13165,'Olgiate Comasco','Olgiate Comasco','','CO',1,'1840-01-01','2999-12-31'),
	(29464,'03','013',' 16','013169',13169,'Oltrona di San Mamette','Oltrona di San Mamette','','CO',1,'1840-01-01','2999-12-31'),
	(29465,'03','013',' 17','013170',13170,'Orsenigo','Orsenigo','','CO',1,'1840-01-01','2999-12-31'),
	(29466,'03','013',' 17','013172',13172,'Ossuccio','Ossuccio','','CO',1,'1840-01-01','2999-12-31'),
	(29467,'03','013',' 17','013175',13175,'Parè','Parè','','CO',1,'1840-01-01','2999-12-31'),
	(29468,'03','013',' 17','013178',13178,'Peglio','Peglio','','CO',1,'1840-01-01','2999-12-31'),
	(29469,'03','013',' 17','013179',13179,'Pellio Intelvi','Pellio Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29470,'03','013',' 18','013183',13183,'Pianello del Lario','Pianello del Lario','','CO',1,'1840-01-01','2999-12-31'),
	(29471,'03','013',' 18','013184',13184,'Pigra','Pigra','','CO',1,'1840-01-01','2999-12-31'),
	(29472,'03','013',' 18','013185',13185,'Plesio','Plesio','','CO',1,'1840-01-01','2999-12-31'),
	(29473,'03','013',' 18','013186',13186,'Pognana Lario','Pognana Lario','','CO',1,'1840-01-01','2999-12-31'),
	(29474,'03','013',' 18','013187',13187,'Ponna','Ponna','','CO',1,'1840-01-01','2999-12-31'),
	(29475,'03','013',' 18','013188',13188,'Ponte Lambro','Ponte Lambro','','CO',1,'1840-01-01','2999-12-31'),
	(29476,'03','013',' 18','013189',13189,'Porlezza','Porlezza','','CO',1,'1840-01-01','2999-12-31'),
	(29477,'03','013',' 19','013192',13192,'Proserpio','Proserpio','','CO',1,'1840-01-01','2999-12-31'),
	(29478,'03','013',' 19','013193',13193,'Pusiano','Pusiano','','CO',1,'1840-01-01','2999-12-31'),
	(29479,'03','013',' 19','013194',13194,'Ramponio Verna','Ramponio Verna','','CO',1,'1840-01-01','2999-12-31'),
	(29480,'03','013',' 19','013195',13195,'Rezzago','Rezzago','','CO',1,'1840-01-01','2999-12-31'),
	(29481,'03','013',' 19','013197',13197,'Rodero','Rodero','','CO',1,'1840-01-01','2999-12-31'),
	(29482,'03','013',' 19','013199',13199,'Ronago','Ronago','','CO',1,'1840-01-01','2999-12-31'),
	(29483,'03','013',' 20','013201',13201,'Rovellasca','Rovellasca','','CO',1,'1840-01-01','2999-12-31'),
	(29484,'03','013',' 20','013202',13202,'Rovello Porro','Rovello Porro','','CO',1,'1840-01-01','2999-12-31'),
	(29485,'03','013',' 20','013203',13203,'Sala Comacina','Sala Comacina','','CO',1,'1840-01-01','2999-12-31'),
	(29486,'03','013',' 20','013204',13204,'San Bartolomeo Val Cavargna','San Bartolomeo Val Cavargna','','CO',1,'1840-01-01','2999-12-31'),
	(29487,'03','013',' 20','013205',13205,'San Fedele Intelvi','San Fedele Intelvi','','CO',1,'1840-01-01','2999-12-31'),
	(29488,'03','013',' 20','013206',13206,'San Fermo della Battaglia','San Fermo della Battaglia','','CO',1,'1840-01-01','2999-12-31'),
	(29489,'03','013',' 20','013207',13207,'San Nazzaro Val Cavargna','San Nazzaro Val Cavargna','','CO',1,'1840-01-01','2999-12-31'),
	(29490,'03','013',' 21','013211',13211,'Schignano','Schignano','','CO',1,'1840-01-01','2999-12-31'),
	(29491,'03','013',' 21','013212',13212,'Senna Comasco','Senna Comasco','','CO',1,'1840-01-01','2999-12-31'),
	(29492,'03','013',' 21','013215',13215,'Solbiate','Solbiate','','CO',1,'1840-01-01','2999-12-31'),
	(29493,'03','013',' 21','013216',13216,'Sorico','Sorico','','CO',1,'1840-01-01','2999-12-31'),
	(29494,'03','013',' 21','013217',13217,'Sormano','Sormano','','CO',1,'1840-01-01','2999-12-31'),
	(29495,'03','013',' 21','013218',13218,'Stazzona','Stazzona','','CO',1,'1840-01-01','2999-12-31'),
	(29496,'03','013',' 22','013222',13222,'Tavernerio','Tavernerio','','CO',1,'1840-01-01','2999-12-31'),
	(29497,'03','013',' 22','013223',13223,'Torno','Torno','','CO',1,'1840-01-01','2999-12-31'),
	(29498,'03','013',' 22','013225',13225,'Tremezzo','Tremezzo','','CO',1,'1840-01-01','2999-12-31'),
	(29499,'03','013',' 22','013226',13226,'Trezzone','Trezzone','','CO',1,'1840-01-01','2999-12-31'),
	(29500,'03','013',' 22','013227',13227,'Turate','Turate','','CO',1,'1840-01-01','2999-12-31'),
	(29501,'03','013',' 22','013228',13228,'Uggiate-Trevano','Uggiate-Trevano','','CO',1,'1840-01-01','2999-12-31'),
	(29502,'03','013',' 22','013229',13229,'Valbrona','Valbrona','','CO',1,'1840-01-01','2999-12-31'),
	(29503,'03','013',' 23','013232',13232,'Valmorea','Valmorea','','CO',1,'1840-01-01','2999-12-31'),
	(29504,'03','013',' 23','013233',13233,'Val Rezzo','Val Rezzo','','CO',1,'1840-01-01','2999-12-31'),
	(29505,'03','013',' 23','013234',13234,'Valsolda','Valsolda','','CO',1,'1840-01-01','2999-12-31'),
	(29506,'03','013',' 23','013236',13236,'Veleso','Veleso','','CO',1,'1840-01-01','2999-12-31'),
	(29507,'03','013',' 23','013238',13238,'Veniano','Veniano','','CO',1,'1840-01-01','2999-12-31'),
	(29508,'03','013',' 23','013239',13239,'Vercana','Vercana','','CO',1,'1840-01-01','2999-12-31'),
	(29509,'03','013',' 24','013242',13242,'Vertemate con Minoprio','Vertemate con Minoprio','','CO',1,'1840-01-01','2999-12-31'),
	(29510,'03','013',' 24','013245',13245,'Villa Guardia','Villa Guardia','','CO',1,'1840-01-01','2999-12-31'),
	(29511,'03','013',' 24','013246',13246,'Zelbio','Zelbio','','CO',1,'1840-01-01','2999-12-31'),
	(29512,'03','013',' 24','013248',13248,'San Siro','San Siro','','CO',1,'1840-01-01','2999-12-31'),
	(29513,'03','014',' 00','014001',14001,'Albaredo per San Marco','Albaredo per San Marco','','SO',1,'1840-01-01','2999-12-31'),
	(29514,'03','014',' 00','014002',14002,'Albosaggia','Albosaggia','','SO',1,'1840-01-01','2999-12-31'),
	(29515,'03','014',' 00','014003',14003,'Andalo Valtellino','Andalo Valtellino','','SO',1,'1840-01-01','2999-12-31'),
	(29516,'03','014',' 00','014004',14004,'Aprica','Aprica','','SO',1,'1840-01-01','2999-12-31'),
	(29517,'03','014',' 00','014005',14005,'Ardenno','Ardenno','','SO',1,'1840-01-01','2999-12-31'),
	(29518,'03','014',' 00','014006',14006,'Bema','Bema','','SO',1,'1840-01-01','2999-12-31'),
	(29519,'03','014',' 00','014007',14007,'Berbenno di Valtellina','Berbenno di Valtellina','','SO',1,'1840-01-01','2999-12-31'),
	(29520,'03','014',' 00','014008',14008,'Bianzone','Bianzone','','SO',1,'1840-01-01','2999-12-31'),
	(29521,'03','014',' 00','014009',14009,'Bormio','Bormio','','SO',1,'1840-01-01','2999-12-31'),
	(29522,'03','014',' 01','014010',14010,'Buglio in Monte','Buglio in Monte','','SO',1,'1840-01-01','2999-12-31'),
	(29523,'03','014',' 01','014011',14011,'Caiolo','Caiolo','','SO',1,'1840-01-01','2999-12-31'),
	(29524,'03','014',' 01','014012',14012,'Campodolcino','Campodolcino','','SO',1,'1840-01-01','2999-12-31'),
	(29525,'03','014',' 01','014013',14013,'Caspoggio','Caspoggio','','SO',1,'1840-01-01','2999-12-31'),
	(29526,'03','014',' 01','014014',14014,'Castello dell\'Acqua','Castello dell\'Acqua','','SO',1,'1840-01-01','2999-12-31'),
	(29527,'03','014',' 01','014015',14015,'Castione Andevenno','Castione Andevenno','','SO',1,'1840-01-01','2999-12-31'),
	(29528,'03','014',' 01','014016',14016,'Cedrasco','Cedrasco','','SO',1,'1840-01-01','2999-12-31'),
	(29529,'03','014',' 01','014017',14017,'Cercino','Cercino','','SO',1,'1840-01-01','2999-12-31'),
	(29530,'03','014',' 01','014018',14018,'Chiavenna','Chiavenna','','SO',1,'1840-01-01','2999-12-31'),
	(29531,'03','014',' 01','014019',14019,'Chiesa in Valmalenco','Chiesa in Valmalenco','','SO',1,'1840-01-01','2999-12-31'),
	(29532,'03','014',' 02','014020',14020,'Chiuro','Chiuro','','SO',1,'1840-01-01','2999-12-31'),
	(29533,'03','014',' 02','014021',14021,'Cino','Cino','','SO',1,'1840-01-01','2999-12-31'),
	(29534,'03','014',' 02','014022',14022,'Civo','Civo','','SO',1,'1840-01-01','2999-12-31'),
	(29535,'03','014',' 02','014023',14023,'Colorina','Colorina','','SO',1,'1840-01-01','2999-12-31'),
	(29536,'03','014',' 02','014024',14024,'Cosio Valtellino','Cosio Valtellino','','SO',1,'1840-01-01','2999-12-31'),
	(29537,'03','014',' 02','014025',14025,'Dazio','Dazio','','SO',1,'1840-01-01','2999-12-31'),
	(29538,'03','014',' 02','014026',14026,'Delebio','Delebio','','SO',1,'1840-01-01','2999-12-31'),
	(29539,'03','014',' 02','014027',14027,'Dubino','Dubino','','SO',1,'1840-01-01','2999-12-31'),
	(29540,'03','014',' 02','014028',14028,'Faedo Valtellino','Faedo Valtellino','','SO',1,'1840-01-01','2999-12-31'),
	(29541,'03','014',' 02','014029',14029,'Forcola','Forcola','','SO',1,'1840-01-01','2999-12-31'),
	(29542,'03','014',' 03','014030',14030,'Fusine','Fusine','','SO',1,'1840-01-01','2999-12-31'),
	(29543,'03','014',' 03','014031',14031,'Gerola Alta','Gerola Alta','','SO',1,'1840-01-01','2999-12-31'),
	(29544,'03','014',' 03','014032',14032,'Gordona','Gordona','','SO',1,'1840-01-01','2999-12-31'),
	(29545,'03','014',' 03','014033',14033,'Grosio','Grosio','','SO',1,'1840-01-01','2999-12-31'),
	(29546,'03','014',' 03','014034',14034,'Grosotto','Grosotto','','SO',1,'1840-01-01','2999-12-31'),
	(29547,'03','014',' 03','014035',14035,'Madesimo','Madesimo','','SO',1,'1840-01-01','2999-12-31'),
	(29548,'03','014',' 03','014036',14036,'Lanzada','Lanzada','','SO',1,'1840-01-01','2999-12-31'),
	(29549,'03','014',' 03','014037',14037,'Livigno','Livigno','','SO',1,'1840-01-01','2999-12-31'),
	(29550,'03','014',' 03','014038',14038,'Lovero','Lovero','','SO',1,'1840-01-01','2999-12-31'),
	(29551,'03','014',' 03','014039',14039,'Mantello','Mantello','','SO',1,'1840-01-01','2999-12-31'),
	(29552,'03','014',' 04','014040',14040,'Mazzo di Valtellina','Mazzo di Valtellina','','SO',1,'1840-01-01','2999-12-31'),
	(29553,'03','014',' 04','014041',14041,'Mello','Mello','','SO',1,'1840-01-01','2999-12-31'),
	(29554,'03','014',' 04','014042',14042,'Menarola','Menarola','','SO',1,'1840-01-01','2999-12-31'),
	(29555,'03','014',' 04','014043',14043,'Mese','Mese','','SO',1,'1840-01-01','2999-12-31'),
	(29556,'03','014',' 04','014044',14044,'Montagna in Valtellina','Montagna in Valtellina','','SO',1,'1840-01-01','2999-12-31'),
	(29557,'03','014',' 04','014045',14045,'Morbegno','Morbegno','','SO',1,'1840-01-01','2999-12-31'),
	(29558,'03','014',' 04','014046',14046,'Novate Mezzola','Novate Mezzola','','SO',1,'1840-01-01','2999-12-31'),
	(29559,'03','014',' 04','014047',14047,'Pedesina','Pedesina','','SO',1,'1840-01-01','2999-12-31'),
	(29560,'03','014',' 04','014048',14048,'Piantedo','Piantedo','','SO',1,'1840-01-01','2999-12-31'),
	(29561,'03','014',' 04','014049',14049,'Piateda','Piateda','','SO',1,'1840-01-01','2999-12-31'),
	(29562,'03','014',' 05','014050',14050,'Piuro','Piuro','','SO',1,'1840-01-01','2999-12-31'),
	(29563,'03','014',' 05','014051',14051,'Poggiridenti','Poggiridenti','','SO',1,'1840-01-01','2999-12-31'),
	(29564,'03','014',' 05','014052',14052,'Ponte in Valtellina','Ponte in Valtellina','','SO',1,'1840-01-01','2999-12-31'),
	(29565,'03','014',' 05','014053',14053,'Postalesio','Postalesio','','SO',1,'1840-01-01','2999-12-31'),
	(29566,'03','014',' 05','014054',14054,'Prata Camportaccio','Prata Camportaccio','','SO',1,'1840-01-01','2999-12-31'),
	(29567,'03','014',' 05','014055',14055,'Rasura','Rasura','','SO',1,'1840-01-01','2999-12-31'),
	(29568,'03','014',' 05','014056',14056,'Rogolo','Rogolo','','SO',1,'1840-01-01','2999-12-31'),
	(29569,'03','014',' 05','014057',14057,'Samolaco','Samolaco','','SO',1,'1840-01-01','2999-12-31'),
	(29570,'03','014',' 05','014058',14058,'San Giacomo Filippo','San Giacomo Filippo','','SO',1,'1840-01-01','2999-12-31'),
	(29571,'03','014',' 05','014059',14059,'Sernio','Sernio','','SO',1,'1840-01-01','2999-12-31'),
	(29572,'03','014',' 06','014060',14060,'Sondalo','Sondalo','','SO',1,'1840-01-01','2999-12-31'),
	(29573,'03','014',' 06','014061',14061,'Sondrio','Sondrio','','SO',1,'1840-01-01','2999-12-31'),
	(29574,'03','014',' 06','014062',14062,'Spriana','Spriana','','SO',1,'1840-01-01','2999-12-31'),
	(29575,'03','014',' 06','014063',14063,'Talamona','Talamona','','SO',1,'1840-01-01','2999-12-31'),
	(29576,'03','014',' 06','014064',14064,'Tartano','Tartano','','SO',1,'1840-01-01','2999-12-31'),
	(29577,'03','014',' 06','014065',14065,'Teglio','Teglio','','SO',1,'1840-01-01','2999-12-31'),
	(29578,'03','014',' 06','014066',14066,'Tirano','Tirano','','SO',1,'1840-01-01','2999-12-31'),
	(29579,'03','014',' 06','014067',14067,'Torre di Santa Maria','Torre di Santa Maria','','SO',1,'1840-01-01','2999-12-31'),
	(29580,'03','014',' 06','014068',14068,'Tovo di Sant\'Agata','Tovo di Sant\'Agata','','SO',1,'1840-01-01','2999-12-31'),
	(29581,'03','014',' 06','014069',14069,'Traona','Traona','','SO',1,'1840-01-01','2999-12-31'),
	(29582,'03','014',' 07','014070',14070,'Tresivio','Tresivio','','SO',1,'1840-01-01','2999-12-31'),
	(29583,'03','014',' 07','014071',14071,'Valdidentro','Valdidentro','','SO',1,'1840-01-01','2999-12-31'),
	(29584,'03','014',' 07','014072',14072,'Valdisotto','Valdisotto','','SO',1,'1840-01-01','2999-12-31'),
	(29585,'03','014',' 07','014073',14073,'Valfurva','Valfurva','','SO',1,'1840-01-01','2999-12-31'),
	(29586,'03','014',' 07','014074',14074,'Val Masino','Val Masino','','SO',1,'1840-01-01','2999-12-31'),
	(29587,'03','014',' 07','014075',14075,'Verceia','Verceia','','SO',1,'1840-01-01','2999-12-31'),
	(29588,'03','014',' 07','014076',14076,'Vervio','Vervio','','SO',1,'1840-01-01','2999-12-31'),
	(29589,'03','014',' 07','014077',14077,'Villa di Chiavenna','Villa di Chiavenna','','SO',1,'1840-01-01','2999-12-31'),
	(29590,'03','014',' 07','014078',14078,'Villa di Tirano','Villa di Tirano','','SO',1,'1840-01-01','2999-12-31'),
	(29591,'03','015',' 00','015002',15002,'Abbiategrasso','Abbiategrasso','','MI',1,'1840-01-01','2999-12-31'),
	(29592,'03','015',' 00','015005',15005,'Albairate','Albairate','','MI',1,'1840-01-01','2999-12-31'),
	(29593,'03','015',' 00','015007',15007,'Arconate','Arconate','','MI',1,'1840-01-01','2999-12-31'),
	(29594,'03','015',' 00','015009',15009,'Arese','Arese','','MI',1,'1840-01-01','2999-12-31'),
	(29595,'03','015',' 01','015010',15010,'Arluno','Arluno','','MI',1,'1840-01-01','2999-12-31'),
	(29596,'03','015',' 01','015011',15011,'Assago','Assago','','MI',1,'1840-01-01','2999-12-31'),
	(29597,'03','015',' 01','015012',15012,'Bareggio','Bareggio','','MI',1,'1840-01-01','2999-12-31'),
	(29598,'03','015',' 01','015014',15014,'Basiano','Basiano','','MI',1,'1840-01-01','2999-12-31'),
	(29599,'03','015',' 01','015015',15015,'Basiglio','Basiglio','','MI',1,'1840-01-01','2999-12-31'),
	(29600,'03','015',' 01','015016',15016,'Bellinzago Lombardo','Bellinzago Lombardo','','MI',1,'1840-01-01','2999-12-31'),
	(29601,'03','015',' 01','015019',15019,'Bernate Ticino','Bernate Ticino','','MI',1,'1840-01-01','2999-12-31'),
	(29602,'03','015',' 02','015022',15022,'Besate','Besate','','MI',1,'1840-01-01','2999-12-31'),
	(29603,'03','015',' 02','015024',15024,'Binasco','Binasco','','MI',1,'1840-01-01','2999-12-31'),
	(29604,'03','015',' 02','015026',15026,'Boffalora sopra Ticino','Boffalora sopra Ticino','','MI',1,'1840-01-01','2999-12-31'),
	(29605,'03','015',' 02','015027',15027,'Bollate','Bollate','','MI',1,'1840-01-01','2999-12-31'),
	(29606,'03','015',' 03','015032',15032,'Bresso','Bresso','','MI',1,'1840-01-01','2999-12-31'),
	(29607,'03','015',' 03','015035',15035,'Bubbiano','Bubbiano','','MI',1,'1840-01-01','2999-12-31'),
	(29608,'03','015',' 03','015036',15036,'Buccinasco','Buccinasco','','MI',1,'1840-01-01','2999-12-31'),
	(29609,'03','015',' 03','015038',15038,'Buscate','Buscate','','MI',1,'1840-01-01','2999-12-31'),
	(29610,'03','015',' 04','015040',15040,'Bussero','Bussero','','MI',1,'1840-01-01','2999-12-31'),
	(29611,'03','015',' 04','015041',15041,'Busto Garolfo','Busto Garolfo','','MI',1,'1840-01-01','2999-12-31'),
	(29612,'03','015',' 04','015042',15042,'Calvignasco','Calvignasco','','MI',1,'1840-01-01','2999-12-31'),
	(29613,'03','015',' 04','015044',15044,'Cambiago','Cambiago','','MI',1,'1840-01-01','2999-12-31'),
	(29614,'03','015',' 04','015046',15046,'Canegrate','Canegrate','','MI',1,'1840-01-01','2999-12-31'),
	(29615,'03','015',' 05','015050',15050,'Carpiano','Carpiano','','MI',1,'1840-01-01','2999-12-31'),
	(29616,'03','015',' 05','015051',15051,'Carugate','Carugate','','MI',1,'1840-01-01','2999-12-31'),
	(29617,'03','015',' 05','015055',15055,'Casarile','Casarile','','MI',1,'1840-01-01','2999-12-31'),
	(29618,'03','015',' 05','015058',15058,'Casorezzo','Casorezzo','','MI',1,'1840-01-01','2999-12-31'),
	(29619,'03','015',' 05','015059',15059,'Cassano d\'Adda','Cassano d\'Adda','','MI',1,'1840-01-01','2999-12-31'),
	(29620,'03','015',' 06','015060',15060,'Cassina de\' Pecchi','Cassina de\' Pecchi','','MI',1,'1840-01-01','2999-12-31'),
	(29621,'03','015',' 06','015061',15061,'Cassinetta di Lugagnano','Cassinetta di Lugagnano','','MI',1,'1840-01-01','2999-12-31'),
	(29622,'03','015',' 06','015062',15062,'Castano Primo','Castano Primo','','MI',1,'1840-01-01','2999-12-31'),
	(29623,'03','015',' 07','015070',15070,'Cernusco sul Naviglio','Cernusco sul Naviglio','','MI',1,'1840-01-01','2999-12-31'),
	(29624,'03','015',' 07','015071',15071,'Cerro al Lambro','Cerro al Lambro','','MI',1,'1840-01-01','2999-12-31'),
	(29625,'03','015',' 07','015072',15072,'Cerro Maggiore','Cerro Maggiore','','MI',1,'1840-01-01','2999-12-31'),
	(29626,'03','015',' 07','015074',15074,'Cesano Boscone','Cesano Boscone','','MI',1,'1840-01-01','2999-12-31'),
	(29627,'03','015',' 07','015076',15076,'Cesate','Cesate','','MI',1,'1840-01-01','2999-12-31'),
	(29628,'03','015',' 07','015077',15077,'Cinisello Balsamo','Cinisello Balsamo','','MI',1,'1840-01-01','2999-12-31'),
	(29629,'03','015',' 07','015078',15078,'Cisliano','Cisliano','','MI',1,'1840-01-01','2999-12-31'),
	(29630,'03','015',' 08','015081',15081,'Cologno Monzese','Cologno Monzese','','MI',1,'1840-01-01','2999-12-31'),
	(29631,'03','015',' 08','015082',15082,'Colturano','Colturano','','MI',1,'1840-01-01','2999-12-31'),
	(29632,'03','015',' 08','015085',15085,'Corbetta','Corbetta','','MI',1,'1840-01-01','2999-12-31'),
	(29633,'03','015',' 08','015086',15086,'Cormano','Cormano','','MI',1,'1840-01-01','2999-12-31'),
	(29634,'03','015',' 08','015087',15087,'Cornaredo','Cornaredo','','MI',1,'1840-01-01','2999-12-31'),
	(29635,'03','015',' 09','015093',15093,'Corsico','Corsico','','MI',1,'1840-01-01','2999-12-31'),
	(29636,'03','015',' 09','015096',15096,'Cuggiono','Cuggiono','','MI',1,'1840-01-01','2999-12-31'),
	(29637,'03','015',' 09','015097',15097,'Cusago','Cusago','','MI',1,'1840-01-01','2999-12-31'),
	(29638,'03','015',' 09','015098',15098,'Cusano Milanino','Cusano Milanino','','MI',1,'1840-01-01','2999-12-31'),
	(29639,'03','015',' 09','015099',15099,'Dairago','Dairago','','MI',1,'1840-01-01','2999-12-31'),
	(29640,'03','015',' 10','015101',15101,'Dresano','Dresano','','MI',1,'1840-01-01','2999-12-31'),
	(29641,'03','015',' 10','015103',15103,'Gaggiano','Gaggiano','','MI',1,'1840-01-01','2999-12-31'),
	(29642,'03','015',' 10','015105',15105,'Garbagnate Milanese','Garbagnate Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29643,'03','015',' 10','015106',15106,'Gessate','Gessate','','MI',1,'1840-01-01','2999-12-31'),
	(29644,'03','015',' 10','015108',15108,'Gorgonzola','Gorgonzola','','MI',1,'1840-01-01','2999-12-31'),
	(29645,'03','015',' 11','015110',15110,'Grezzago','Grezzago','','MI',1,'1840-01-01','2999-12-31'),
	(29646,'03','015',' 11','015112',15112,'Gudo Visconti','Gudo Visconti','','MI',1,'1840-01-01','2999-12-31'),
	(29647,'03','015',' 11','015113',15113,'Inveruno','Inveruno','','MI',1,'1840-01-01','2999-12-31'),
	(29648,'03','015',' 11','015114',15114,'Inzago','Inzago','','MI',1,'1840-01-01','2999-12-31'),
	(29649,'03','015',' 11','015115',15115,'Lacchiarella','Lacchiarella','','MI',1,'1840-01-01','2999-12-31'),
	(29650,'03','015',' 11','015116',15116,'Lainate','Lainate','','MI',1,'1840-01-01','2999-12-31'),
	(29651,'03','015',' 11','015118',15118,'Legnano','Legnano','','MI',1,'1840-01-01','2999-12-31'),
	(29652,'03','015',' 12','015122',15122,'Liscate','Liscate','','MI',1,'1840-01-01','2999-12-31'),
	(29653,'03','015',' 12','015125',15125,'Locate di Triulzi','Locate di Triulzi','','MI',1,'1840-01-01','2999-12-31'),
	(29654,'03','015',' 13','015130',15130,'Magenta','Magenta','','MI',1,'1840-01-01','2999-12-31'),
	(29655,'03','015',' 13','015131',15131,'Magnago','Magnago','','MI',1,'1840-01-01','2999-12-31'),
	(29656,'03','015',' 13','015134',15134,'Marcallo con Casone','Marcallo con Casone','','MI',1,'1840-01-01','2999-12-31'),
	(29657,'03','015',' 13','015136',15136,'Masate','Masate','','MI',1,'1840-01-01','2999-12-31'),
	(29658,'03','015',' 13','015139',15139,'Mediglia','Mediglia','','MI',1,'1840-01-01','2999-12-31'),
	(29659,'03','015',' 14','015140',15140,'Melegnano','Melegnano','','MI',1,'1840-01-01','2999-12-31'),
	(29660,'03','015',' 14','015142',15142,'Melzo','Melzo','','MI',1,'1840-01-01','2999-12-31'),
	(29661,'03','015',' 14','015144',15144,'Mesero','Mesero','','MI',1,'1840-01-01','2999-12-31'),
	(29662,'03','015',' 14','015146',15146,'Milano','Milano','','MI',1,'1840-01-01','2999-12-31'),
	(29663,'03','015',' 15','015150',15150,'Morimondo','Morimondo','','MI',1,'1840-01-01','2999-12-31'),
	(29664,'03','015',' 15','015151',15151,'Motta Visconti','Motta Visconti','','MI',1,'1840-01-01','2999-12-31'),
	(29665,'03','015',' 15','015154',15154,'Nerviano','Nerviano','','MI',1,'1840-01-01','2999-12-31'),
	(29666,'03','015',' 15','015155',15155,'Nosate','Nosate','','MI',1,'1840-01-01','2999-12-31'),
	(29667,'03','015',' 15','015157',15157,'Novate Milanese','Novate Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29668,'03','015',' 15','015158',15158,'Noviglio','Noviglio','','MI',1,'1840-01-01','2999-12-31'),
	(29669,'03','015',' 15','015159',15159,'Opera','Opera','','MI',1,'1840-01-01','2999-12-31'),
	(29670,'03','015',' 16','015164',15164,'Ossona','Ossona','','MI',1,'1840-01-01','2999-12-31'),
	(29671,'03','015',' 16','015165',15165,'Ozzero','Ozzero','','MI',1,'1840-01-01','2999-12-31'),
	(29672,'03','015',' 16','015166',15166,'Paderno Dugnano','Paderno Dugnano','','MI',1,'1840-01-01','2999-12-31'),
	(29673,'03','015',' 16','015167',15167,'Pantigliate','Pantigliate','','MI',1,'1840-01-01','2999-12-31'),
	(29674,'03','015',' 16','015168',15168,'Parabiago','Parabiago','','MI',1,'1840-01-01','2999-12-31'),
	(29675,'03','015',' 16','015169',15169,'Paullo','Paullo','','MI',1,'1840-01-01','2999-12-31'),
	(29676,'03','015',' 17','015170',15170,'Pero','Pero','','MI',1,'1840-01-01','2999-12-31'),
	(29677,'03','015',' 17','015171',15171,'Peschiera Borromeo','Peschiera Borromeo','','MI',1,'1840-01-01','2999-12-31'),
	(29678,'03','015',' 17','015172',15172,'Pessano con Bornago','Pessano con Bornago','','MI',1,'1840-01-01','2999-12-31'),
	(29679,'03','015',' 17','015173',15173,'Pieve Emanuele','Pieve Emanuele','','MI',1,'1840-01-01','2999-12-31'),
	(29680,'03','015',' 17','015175',15175,'Pioltello','Pioltello','','MI',1,'1840-01-01','2999-12-31'),
	(29681,'03','015',' 17','015176',15176,'Pogliano Milanese','Pogliano Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29682,'03','015',' 17','015177',15177,'Pozzo d\'Adda','Pozzo d\'Adda','','MI',1,'1840-01-01','2999-12-31'),
	(29683,'03','015',' 17','015178',15178,'Pozzuolo Martesana','Pozzuolo Martesana','','MI',1,'1840-01-01','2999-12-31'),
	(29684,'03','015',' 17','015179',15179,'Pregnana Milanese','Pregnana Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29685,'03','015',' 18','015181',15181,'Rescaldina','Rescaldina','','MI',1,'1840-01-01','2999-12-31'),
	(29686,'03','015',' 18','015182',15182,'Rho','Rho','','MI',1,'1840-01-01','2999-12-31'),
	(29687,'03','015',' 18','015183',15183,'Robecchetto con Induno','Robecchetto con Induno','','MI',1,'1840-01-01','2999-12-31'),
	(29688,'03','015',' 18','015184',15184,'Robecco sul Naviglio','Robecco sul Naviglio','','MI',1,'1840-01-01','2999-12-31'),
	(29689,'03','015',' 18','015185',15185,'Rodano','Rodano','','MI',1,'1840-01-01','2999-12-31'),
	(29690,'03','015',' 18','015188',15188,'Rosate','Rosate','','MI',1,'1840-01-01','2999-12-31'),
	(29691,'03','015',' 18','015189',15189,'Rozzano','Rozzano','','MI',1,'1840-01-01','2999-12-31'),
	(29692,'03','015',' 19','015191',15191,'San Colombano al Lambro','San Colombano al Lambro','','MI',1,'1840-01-01','2999-12-31'),
	(29693,'03','015',' 19','015192',15192,'San Donato Milanese','San Donato Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29694,'03','015',' 19','015194',15194,'San Giorgio su Legnano','San Giorgio su Legnano','','MI',1,'1840-01-01','2999-12-31'),
	(29695,'03','015',' 19','015195',15195,'San Giuliano Milanese','San Giuliano Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29696,'03','015',' 20','015200',15200,'Santo Stefano Ticino','Santo Stefano Ticino','','MI',1,'1840-01-01','2999-12-31'),
	(29697,'03','015',' 20','015201',15201,'San Vittore Olona','San Vittore Olona','','MI',1,'1840-01-01','2999-12-31'),
	(29698,'03','015',' 20','015202',15202,'San Zenone al Lambro','San Zenone al Lambro','','MI',1,'1840-01-01','2999-12-31'),
	(29699,'03','015',' 20','015204',15204,'Sedriano','Sedriano','','MI',1,'1840-01-01','2999-12-31'),
	(29700,'03','015',' 20','015205',15205,'Segrate','Segrate','','MI',1,'1840-01-01','2999-12-31'),
	(29701,'03','015',' 20','015206',15206,'Senago','Senago','','MI',1,'1840-01-01','2999-12-31'),
	(29702,'03','015',' 20','015209',15209,'Sesto San Giovanni','Sesto San Giovanni','','MI',1,'1840-01-01','2999-12-31'),
	(29703,'03','015',' 21','015210',15210,'Settala','Settala','','MI',1,'1840-01-01','2999-12-31'),
	(29704,'03','015',' 21','015211',15211,'Settimo Milanese','Settimo Milanese','','MI',1,'1840-01-01','2999-12-31'),
	(29705,'03','015',' 21','015213',15213,'Solaro','Solaro','','MI',1,'1840-01-01','2999-12-31'),
	(29706,'03','015',' 21','015219',15219,'Trezzano Rosa','Trezzano Rosa','','MI',1,'1840-01-01','2999-12-31'),
	(29707,'03','015',' 22','015220',15220,'Trezzano sul Naviglio','Trezzano sul Naviglio','','MI',1,'1840-01-01','2999-12-31'),
	(29708,'03','015',' 22','015221',15221,'Trezzo sull\'Adda','Trezzo sull\'Adda','','MI',1,'1840-01-01','2999-12-31'),
	(29709,'03','015',' 22','015222',15222,'Tribiano','Tribiano','','MI',1,'1840-01-01','2999-12-31'),
	(29710,'03','015',' 22','015224',15224,'Truccazzano','Truccazzano','','MI',1,'1840-01-01','2999-12-31'),
	(29711,'03','015',' 22','015226',15226,'Turbigo','Turbigo','','MI',1,'1840-01-01','2999-12-31'),
	(29712,'03','015',' 22','015229',15229,'Vanzago','Vanzago','','MI',1,'1840-01-01','2999-12-31'),
	(29713,'03','015',' 23','015230',15230,'Vaprio d\'Adda','Vaprio d\'Adda','','MI',1,'1840-01-01','2999-12-31'),
	(29714,'03','015',' 23','015235',15235,'Vermezzo','Vermezzo','','MI',1,'1840-01-01','2999-12-31'),
	(29715,'03','015',' 23','015236',15236,'Vernate','Vernate','','MI',1,'1840-01-01','2999-12-31'),
	(29716,'03','015',' 23','015237',15237,'Vignate','Vignate','','MI',1,'1840-01-01','2999-12-31'),
	(29717,'03','015',' 24','015242',15242,'Vimodrone','Vimodrone','','MI',1,'1840-01-01','2999-12-31'),
	(29718,'03','015',' 24','015243',15243,'Vittuone','Vittuone','','MI',1,'1840-01-01','2999-12-31'),
	(29719,'03','015',' 24','015244',15244,'Vizzolo Predabissi','Vizzolo Predabissi','','MI',1,'1840-01-01','2999-12-31'),
	(29720,'03','015',' 24','015246',15246,'Zelo Surrigone','Zelo Surrigone','','MI',1,'1840-01-01','2999-12-31'),
	(29721,'03','015',' 24','015247',15247,'Zibido San Giacomo','Zibido San Giacomo','','MI',1,'1840-01-01','2999-12-31'),
	(29722,'03','015',' 24','015248',15248,'Villa Cortese','Villa Cortese','','MI',1,'1840-01-01','2999-12-31'),
	(29723,'03','015',' 24','015249',15249,'Vanzaghello','Vanzaghello','','MI',1,'1840-01-01','2999-12-31'),
	(29724,'03','015',' 25','015250',15250,'Baranzate','Baranzate','','MI',1,'1840-01-01','2999-12-31'),
	(29725,'03','016',' 00','016001',16001,'Adrara San Martino','Adrara San Martino','','BG',1,'1840-01-01','2999-12-31'),
	(29726,'03','016',' 00','016002',16002,'Adrara San Rocco','Adrara San Rocco','','BG',1,'1840-01-01','2999-12-31'),
	(29727,'03','016',' 00','016003',16003,'Albano Sant\'Alessandro','Albano Sant\'Alessandro','','BG',1,'1840-01-01','2999-12-31'),
	(29728,'03','016',' 00','016004',16004,'Albino','Albino','','BG',1,'1840-01-01','2999-12-31'),
	(29729,'03','016',' 00','016005',16005,'Almè','Almè','','BG',1,'1840-01-01','2999-12-31'),
	(29730,'03','016',' 00','016006',16006,'Almenno San Bartolomeo','Almenno San Bartolomeo','','BG',1,'1840-01-01','2999-12-31'),
	(29731,'03','016',' 00','016007',16007,'Almenno San Salvatore','Almenno San Salvatore','','BG',1,'1840-01-01','2999-12-31'),
	(29732,'03','016',' 00','016008',16008,'Alzano Lombardo','Alzano Lombardo','','BG',1,'1840-01-01','2999-12-31'),
	(29733,'03','016',' 00','016009',16009,'Ambivere','Ambivere','','BG',1,'1840-01-01','2999-12-31'),
	(29734,'03','016',' 01','016010',16010,'Antegnate','Antegnate','','BG',1,'1840-01-01','2999-12-31'),
	(29735,'03','016',' 01','016011',16011,'Arcene','Arcene','','BG',1,'1840-01-01','2999-12-31'),
	(29736,'03','016',' 01','016012',16012,'Ardesio','Ardesio','','BG',1,'1840-01-01','2999-12-31'),
	(29737,'03','016',' 01','016013',16013,'Arzago d\'Adda','Arzago d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29738,'03','016',' 01','016014',16014,'Averara','Averara','','BG',1,'1840-01-01','2999-12-31'),
	(29739,'03','016',' 01','016015',16015,'Aviatico','Aviatico','','BG',1,'1840-01-01','2999-12-31'),
	(29740,'03','016',' 01','016016',16016,'Azzano San Paolo','Azzano San Paolo','','BG',1,'1840-01-01','2999-12-31'),
	(29741,'03','016',' 01','016017',16017,'Azzone','Azzone','','BG',1,'1840-01-01','2999-12-31'),
	(29742,'03','016',' 01','016018',16018,'Bagnatica','Bagnatica','','BG',1,'1840-01-01','2999-12-31'),
	(29743,'03','016',' 01','016019',16019,'Barbata','Barbata','','BG',1,'1840-01-01','2999-12-31'),
	(29744,'03','016',' 02','016020',16020,'Bariano','Bariano','','BG',1,'1840-01-01','2999-12-31'),
	(29745,'03','016',' 02','016021',16021,'Barzana','Barzana','','BG',1,'1840-01-01','2999-12-31'),
	(29746,'03','016',' 02','016022',16022,'Bedulita','Bedulita','','BG',1,'1840-01-01','2999-12-31'),
	(29747,'03','016',' 02','016023',16023,'Berbenno','Berbenno','','BG',1,'1840-01-01','2999-12-31'),
	(29748,'03','016',' 02','016024',16024,'Bergamo','Bergamo','','BG',1,'1840-01-01','2999-12-31'),
	(29749,'03','016',' 02','016025',16025,'Berzo San Fermo','Berzo San Fermo','','BG',1,'1840-01-01','2999-12-31'),
	(29750,'03','016',' 02','016026',16026,'Bianzano','Bianzano','','BG',1,'1840-01-01','2999-12-31'),
	(29751,'03','016',' 02','016027',16027,'Blello','Blello','','BG',1,'1840-01-01','2999-12-31'),
	(29752,'03','016',' 02','016028',16028,'Bolgare','Bolgare','','BG',1,'1840-01-01','2999-12-31'),
	(29753,'03','016',' 02','016029',16029,'Boltiere','Boltiere','','BG',1,'1840-01-01','2999-12-31'),
	(29754,'03','016',' 03','016030',16030,'Bonate Sopra','Bonate Sopra','','BG',1,'1840-01-01','2999-12-31'),
	(29755,'03','016',' 03','016031',16031,'Bonate Sotto','Bonate Sotto','','BG',1,'1840-01-01','2999-12-31'),
	(29756,'03','016',' 03','016032',16032,'Borgo di Terzo','Borgo di Terzo','','BG',1,'1840-01-01','2999-12-31'),
	(29757,'03','016',' 03','016033',16033,'Bossico','Bossico','','BG',1,'1840-01-01','2999-12-31'),
	(29758,'03','016',' 03','016034',16034,'Bottanuco','Bottanuco','','BG',1,'1840-01-01','2999-12-31'),
	(29759,'03','016',' 03','016035',16035,'Bracca','Bracca','','BG',1,'1840-01-01','2999-12-31'),
	(29760,'03','016',' 03','016036',16036,'Branzi','Branzi','','BG',1,'1840-01-01','2999-12-31'),
	(29761,'03','016',' 03','016037',16037,'Brembate','Brembate','','BG',1,'1840-01-01','2999-12-31'),
	(29762,'03','016',' 03','016038',16038,'Brembate di Sopra','Brembate di Sopra','','BG',1,'1840-01-01','2999-12-31'),
	(29763,'03','016',' 03','016039',16039,'Brembilla','Brembilla','','BG',1,'1840-01-01','2999-12-31'),
	(29764,'03','016',' 04','016040',16040,'Brignano Gera d\'Adda','Brignano Gera d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29765,'03','016',' 04','016041',16041,'Brumano','Brumano','','BG',1,'1840-01-01','2999-12-31'),
	(29766,'03','016',' 04','016042',16042,'Brusaporto','Brusaporto','','BG',1,'1840-01-01','2999-12-31'),
	(29767,'03','016',' 04','016043',16043,'Calcinate','Calcinate','','BG',1,'1840-01-01','2999-12-31'),
	(29768,'03','016',' 04','016044',16044,'Calcio','Calcio','','BG',1,'1840-01-01','2999-12-31'),
	(29769,'03','016',' 04','016046',16046,'Calusco d\'Adda','Calusco d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29770,'03','016',' 04','016047',16047,'Calvenzano','Calvenzano','','BG',1,'1840-01-01','2999-12-31'),
	(29771,'03','016',' 04','016048',16048,'Camerata Cornello','Camerata Cornello','','BG',1,'1840-01-01','2999-12-31'),
	(29772,'03','016',' 04','016049',16049,'Canonica d\'Adda','Canonica d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29773,'03','016',' 05','016050',16050,'Capizzone','Capizzone','','BG',1,'1840-01-01','2999-12-31'),
	(29774,'03','016',' 05','016051',16051,'Capriate San Gervasio','Capriate San Gervasio','','BG',1,'1840-01-01','2999-12-31'),
	(29775,'03','016',' 05','016052',16052,'Caprino Bergamasco','Caprino Bergamasco','','BG',1,'1840-01-01','2999-12-31'),
	(29776,'03','016',' 05','016053',16053,'Caravaggio','Caravaggio','','BG',1,'1840-01-01','2999-12-31'),
	(29777,'03','016',' 05','016055',16055,'Carobbio degli Angeli','Carobbio degli Angeli','','BG',1,'1840-01-01','2999-12-31'),
	(29778,'03','016',' 05','016056',16056,'Carona','Carona','','BG',1,'1840-01-01','2999-12-31'),
	(29779,'03','016',' 05','016057',16057,'Carvico','Carvico','','BG',1,'1840-01-01','2999-12-31'),
	(29780,'03','016',' 05','016058',16058,'Casazza','Casazza','','BG',1,'1840-01-01','2999-12-31'),
	(29781,'03','016',' 05','016059',16059,'Casirate d\'Adda','Casirate d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29782,'03','016',' 06','016060',16060,'Casnigo','Casnigo','','BG',1,'1840-01-01','2999-12-31'),
	(29783,'03','016',' 06','016061',16061,'Cassiglio','Cassiglio','','BG',1,'1840-01-01','2999-12-31'),
	(29784,'03','016',' 06','016062',16062,'Castelli Calepio','Castelli Calepio','','BG',1,'1840-01-01','2999-12-31'),
	(29785,'03','016',' 06','016063',16063,'Castel Rozzone','Castel Rozzone','','BG',1,'1840-01-01','2999-12-31'),
	(29786,'03','016',' 06','016064',16064,'Castione della Presolana','Castione della Presolana','','BG',1,'1840-01-01','2999-12-31'),
	(29787,'03','016',' 06','016065',16065,'Castro','Castro','','BG',1,'1840-01-01','2999-12-31'),
	(29788,'03','016',' 06','016066',16066,'Cavernago','Cavernago','','BG',1,'1840-01-01','2999-12-31'),
	(29789,'03','016',' 06','016067',16067,'Cazzano Sant\'Andrea','Cazzano Sant\'Andrea','','BG',1,'1840-01-01','2999-12-31'),
	(29790,'03','016',' 06','016068',16068,'Cenate Sopra','Cenate Sopra','','BG',1,'1840-01-01','2999-12-31'),
	(29791,'03','016',' 06','016069',16069,'Cenate Sotto','Cenate Sotto','','BG',1,'1840-01-01','2999-12-31'),
	(29792,'03','016',' 07','016070',16070,'Cene','Cene','','BG',1,'1840-01-01','2999-12-31'),
	(29793,'03','016',' 07','016071',16071,'Cerete','Cerete','','BG',1,'1840-01-01','2999-12-31'),
	(29794,'03','016',' 07','016072',16072,'Chignolo d\'Isola','Chignolo d\'Isola','','BG',1,'1840-01-01','2999-12-31'),
	(29795,'03','016',' 07','016073',16073,'Chiuduno','Chiuduno','','BG',1,'1840-01-01','2999-12-31'),
	(29796,'03','016',' 07','016074',16074,'Cisano Bergamasco','Cisano Bergamasco','','BG',1,'1840-01-01','2999-12-31'),
	(29797,'03','016',' 07','016075',16075,'Ciserano','Ciserano','','BG',1,'1840-01-01','2999-12-31'),
	(29798,'03','016',' 07','016076',16076,'Cividate al Piano','Cividate al Piano','','BG',1,'1840-01-01','2999-12-31'),
	(29799,'03','016',' 07','016077',16077,'Clusone','Clusone','','BG',1,'1840-01-01','2999-12-31'),
	(29800,'03','016',' 07','016078',16078,'Colere','Colere','','BG',1,'1840-01-01','2999-12-31'),
	(29801,'03','016',' 07','016079',16079,'Cologno al Serio','Cologno al Serio','','BG',1,'1840-01-01','2999-12-31'),
	(29802,'03','016',' 08','016080',16080,'Colzate','Colzate','','BG',1,'1840-01-01','2999-12-31'),
	(29803,'03','016',' 08','016081',16081,'Comun Nuovo','Comun Nuovo','','BG',1,'1840-01-01','2999-12-31'),
	(29804,'03','016',' 08','016082',16082,'Corna Imagna','Corna Imagna','','BG',1,'1840-01-01','2999-12-31'),
	(29805,'03','016',' 08','016083',16083,'Cortenuova','Cortenuova','','BG',1,'1840-01-01','2999-12-31'),
	(29806,'03','016',' 08','016084',16084,'Costa di Mezzate','Costa di Mezzate','','BG',1,'1840-01-01','2999-12-31'),
	(29807,'03','016',' 08','016085',16085,'Costa Valle Imagna','Costa Valle Imagna','','BG',1,'1840-01-01','2999-12-31'),
	(29808,'03','016',' 08','016086',16086,'Costa Volpino','Costa Volpino','','BG',1,'1840-01-01','2999-12-31'),
	(29809,'03','016',' 08','016087',16087,'Covo','Covo','','BG',1,'1840-01-01','2999-12-31'),
	(29810,'03','016',' 08','016088',16088,'Credaro','Credaro','','BG',1,'1840-01-01','2999-12-31'),
	(29811,'03','016',' 08','016089',16089,'Curno','Curno','','BG',1,'1840-01-01','2999-12-31'),
	(29812,'03','016',' 09','016090',16090,'Cusio','Cusio','','BG',1,'1840-01-01','2999-12-31'),
	(29813,'03','016',' 09','016091',16091,'Dalmine','Dalmine','','BG',1,'1840-01-01','2999-12-31'),
	(29814,'03','016',' 09','016092',16092,'Dossena','Dossena','','BG',1,'1840-01-01','2999-12-31'),
	(29815,'03','016',' 09','016093',16093,'Endine Gaiano','Endine Gaiano','','BG',1,'1840-01-01','2999-12-31'),
	(29816,'03','016',' 09','016094',16094,'Entratico','Entratico','','BG',1,'1840-01-01','2999-12-31'),
	(29817,'03','016',' 09','016096',16096,'Fara Gera d\'Adda','Fara Gera d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29818,'03','016',' 09','016097',16097,'Fara Olivana con Sola','Fara Olivana con Sola','','BG',1,'1840-01-01','2999-12-31'),
	(29819,'03','016',' 09','016098',16098,'Filago','Filago','','BG',1,'1840-01-01','2999-12-31'),
	(29820,'03','016',' 09','016099',16099,'Fino del Monte','Fino del Monte','','BG',1,'1840-01-01','2999-12-31'),
	(29821,'03','016',' 10','016100',16100,'Fiorano al Serio','Fiorano al Serio','','BG',1,'1840-01-01','2999-12-31'),
	(29822,'03','016',' 10','016101',16101,'Fontanella','Fontanella','','BG',1,'1840-01-01','2999-12-31'),
	(29823,'03','016',' 10','016102',16102,'Fonteno','Fonteno','','BG',1,'1840-01-01','2999-12-31'),
	(29824,'03','016',' 10','016103',16103,'Foppolo','Foppolo','','BG',1,'1840-01-01','2999-12-31'),
	(29825,'03','016',' 10','016104',16104,'Foresto Sparso','Foresto Sparso','','BG',1,'1840-01-01','2999-12-31'),
	(29826,'03','016',' 10','016105',16105,'Fornovo San Giovanni','Fornovo San Giovanni','','BG',1,'1840-01-01','2999-12-31'),
	(29827,'03','016',' 10','016106',16106,'Fuipiano Valle Imagna','Fuipiano Valle Imagna','','BG',1,'1840-01-01','2999-12-31'),
	(29828,'03','016',' 10','016107',16107,'Gandellino','Gandellino','','BG',1,'1840-01-01','2999-12-31'),
	(29829,'03','016',' 10','016108',16108,'Gandino','Gandino','','BG',1,'1840-01-01','2999-12-31'),
	(29830,'03','016',' 10','016109',16109,'Gandosso','Gandosso','','BG',1,'1840-01-01','2999-12-31'),
	(29831,'03','016',' 11','016110',16110,'Gaverina Terme','Gaverina Terme','','BG',1,'1840-01-01','2999-12-31'),
	(29832,'03','016',' 11','016111',16111,'Gazzaniga','Gazzaniga','','BG',1,'1840-01-01','2999-12-31'),
	(29833,'03','016',' 11','016112',16112,'Gerosa','Gerosa','','BG',1,'1840-01-01','2999-12-31'),
	(29834,'03','016',' 11','016113',16113,'Ghisalba','Ghisalba','','BG',1,'1840-01-01','2999-12-31'),
	(29835,'03','016',' 11','016114',16114,'Gorlago','Gorlago','','BG',1,'1840-01-01','2999-12-31'),
	(29836,'03','016',' 11','016115',16115,'Gorle','Gorle','','BG',1,'1840-01-01','2999-12-31'),
	(29837,'03','016',' 11','016116',16116,'Gorno','Gorno','','BG',1,'1840-01-01','2999-12-31'),
	(29838,'03','016',' 11','016117',16117,'Grassobbio','Grassobbio','','BG',1,'1840-01-01','2999-12-31'),
	(29839,'03','016',' 11','016118',16118,'Gromo','Gromo','','BG',1,'1840-01-01','2999-12-31'),
	(29840,'03','016',' 11','016119',16119,'Grone','Grone','','BG',1,'1840-01-01','2999-12-31'),
	(29841,'03','016',' 12','016120',16120,'Grumello del Monte','Grumello del Monte','','BG',1,'1840-01-01','2999-12-31'),
	(29842,'03','016',' 12','016121',16121,'Isola di Fondra','Isola di Fondra','','BG',1,'1840-01-01','2999-12-31'),
	(29843,'03','016',' 12','016122',16122,'Isso','Isso','','BG',1,'1840-01-01','2999-12-31'),
	(29844,'03','016',' 12','016123',16123,'Lallio','Lallio','','BG',1,'1840-01-01','2999-12-31'),
	(29845,'03','016',' 12','016124',16124,'Leffe','Leffe','','BG',1,'1840-01-01','2999-12-31'),
	(29846,'03','016',' 12','016125',16125,'Lenna','Lenna','','BG',1,'1840-01-01','2999-12-31'),
	(29847,'03','016',' 12','016126',16126,'Levate','Levate','','BG',1,'1840-01-01','2999-12-31'),
	(29848,'03','016',' 12','016127',16127,'Locatello','Locatello','','BG',1,'1840-01-01','2999-12-31'),
	(29849,'03','016',' 12','016128',16128,'Lovere','Lovere','','BG',1,'1840-01-01','2999-12-31'),
	(29850,'03','016',' 12','016129',16129,'Lurano','Lurano','','BG',1,'1840-01-01','2999-12-31'),
	(29851,'03','016',' 13','016130',16130,'Luzzana','Luzzana','','BG',1,'1840-01-01','2999-12-31'),
	(29852,'03','016',' 13','016131',16131,'Madone','Madone','','BG',1,'1840-01-01','2999-12-31'),
	(29853,'03','016',' 13','016132',16132,'Mapello','Mapello','','BG',1,'1840-01-01','2999-12-31'),
	(29854,'03','016',' 13','016133',16133,'Martinengo','Martinengo','','BG',1,'1840-01-01','2999-12-31'),
	(29855,'03','016',' 13','016134',16134,'Mezzoldo','Mezzoldo','','BG',1,'1840-01-01','2999-12-31'),
	(29856,'03','016',' 13','016135',16135,'Misano di Gera d\'Adda','Misano di Gera d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29857,'03','016',' 13','016136',16136,'Moio de\' Calvi','Moio de\' Calvi','','BG',1,'1840-01-01','2999-12-31'),
	(29858,'03','016',' 13','016137',16137,'Monasterolo del Castello','Monasterolo del Castello','','BG',1,'1840-01-01','2999-12-31'),
	(29859,'03','016',' 13','016139',16139,'Montello','Montello','','BG',1,'1840-01-01','2999-12-31'),
	(29860,'03','016',' 14','016140',16140,'Morengo','Morengo','','BG',1,'1840-01-01','2999-12-31'),
	(29861,'03','016',' 14','016141',16141,'Mornico al Serio','Mornico al Serio','','BG',1,'1840-01-01','2999-12-31'),
	(29862,'03','016',' 14','016142',16142,'Mozzanica','Mozzanica','','BG',1,'1840-01-01','2999-12-31'),
	(29863,'03','016',' 14','016143',16143,'Mozzo','Mozzo','','BG',1,'1840-01-01','2999-12-31'),
	(29864,'03','016',' 14','016144',16144,'Nembro','Nembro','','BG',1,'1840-01-01','2999-12-31'),
	(29865,'03','016',' 14','016145',16145,'Olmo al Brembo','Olmo al Brembo','','BG',1,'1840-01-01','2999-12-31'),
	(29866,'03','016',' 14','016146',16146,'Oltre il Colle','Oltre il Colle','','BG',1,'1840-01-01','2999-12-31'),
	(29867,'03','016',' 14','016147',16147,'Oltressenda Alta','Oltressenda Alta','','BG',1,'1840-01-01','2999-12-31'),
	(29868,'03','016',' 14','016148',16148,'Oneta','Oneta','','BG',1,'1840-01-01','2999-12-31'),
	(29869,'03','016',' 14','016149',16149,'Onore','Onore','','BG',1,'1840-01-01','2999-12-31'),
	(29870,'03','016',' 15','016150',16150,'Orio al Serio','Orio al Serio','','BG',1,'1840-01-01','2999-12-31'),
	(29871,'03','016',' 15','016151',16151,'Ornica','Ornica','','BG',1,'1840-01-01','2999-12-31'),
	(29872,'03','016',' 15','016152',16152,'Osio Sopra','Osio Sopra','','BG',1,'1840-01-01','2999-12-31'),
	(29873,'03','016',' 15','016153',16153,'Osio Sotto','Osio Sotto','','BG',1,'1840-01-01','2999-12-31'),
	(29874,'03','016',' 15','016154',16154,'Pagazzano','Pagazzano','','BG',1,'1840-01-01','2999-12-31'),
	(29875,'03','016',' 15','016155',16155,'Paladina','Paladina','','BG',1,'1840-01-01','2999-12-31'),
	(29876,'03','016',' 15','016156',16156,'Palazzago','Palazzago','','BG',1,'1840-01-01','2999-12-31'),
	(29877,'03','016',' 15','016157',16157,'Palosco','Palosco','','BG',1,'1840-01-01','2999-12-31'),
	(29878,'03','016',' 15','016158',16158,'Parre','Parre','','BG',1,'1840-01-01','2999-12-31'),
	(29879,'03','016',' 15','016159',16159,'Parzanica','Parzanica','','BG',1,'1840-01-01','2999-12-31'),
	(29880,'03','016',' 16','016160',16160,'Pedrengo','Pedrengo','','BG',1,'1840-01-01','2999-12-31'),
	(29881,'03','016',' 16','016161',16161,'Peia','Peia','','BG',1,'1840-01-01','2999-12-31'),
	(29882,'03','016',' 16','016162',16162,'Pianico','Pianico','','BG',1,'1840-01-01','2999-12-31'),
	(29883,'03','016',' 16','016163',16163,'Piario','Piario','','BG',1,'1840-01-01','2999-12-31'),
	(29884,'03','016',' 16','016164',16164,'Piazza Brembana','Piazza Brembana','','BG',1,'1840-01-01','2999-12-31'),
	(29885,'03','016',' 16','016165',16165,'Piazzatorre','Piazzatorre','','BG',1,'1840-01-01','2999-12-31'),
	(29886,'03','016',' 16','016166',16166,'Piazzolo','Piazzolo','','BG',1,'1840-01-01','2999-12-31'),
	(29887,'03','016',' 16','016167',16167,'Pognano','Pognano','','BG',1,'1840-01-01','2999-12-31'),
	(29888,'03','016',' 16','016168',16168,'Ponte Nossa','Ponte Nossa','','BG',1,'1840-01-01','2999-12-31'),
	(29889,'03','016',' 16','016169',16169,'Ponteranica','Ponteranica','','BG',1,'1840-01-01','2999-12-31'),
	(29890,'03','016',' 17','016170',16170,'Ponte San Pietro','Ponte San Pietro','','BG',1,'1840-01-01','2999-12-31'),
	(29891,'03','016',' 17','016171',16171,'Pontida','Pontida','','BG',1,'1840-01-01','2999-12-31'),
	(29892,'03','016',' 17','016172',16172,'Pontirolo Nuovo','Pontirolo Nuovo','','BG',1,'1840-01-01','2999-12-31'),
	(29893,'03','016',' 17','016173',16173,'Pradalunga','Pradalunga','','BG',1,'1840-01-01','2999-12-31'),
	(29894,'03','016',' 17','016174',16174,'Predore','Predore','','BG',1,'1840-01-01','2999-12-31'),
	(29895,'03','016',' 17','016175',16175,'Premolo','Premolo','','BG',1,'1840-01-01','2999-12-31'),
	(29896,'03','016',' 17','016176',16176,'Presezzo','Presezzo','','BG',1,'1840-01-01','2999-12-31'),
	(29897,'03','016',' 17','016177',16177,'Pumenengo','Pumenengo','','BG',1,'1840-01-01','2999-12-31'),
	(29898,'03','016',' 17','016178',16178,'Ranica','Ranica','','BG',1,'1840-01-01','2999-12-31'),
	(29899,'03','016',' 17','016179',16179,'Ranzanico','Ranzanico','','BG',1,'1840-01-01','2999-12-31'),
	(29900,'03','016',' 18','016180',16180,'Riva di Solto','Riva di Solto','','BG',1,'1840-01-01','2999-12-31'),
	(29901,'03','016',' 18','016182',16182,'Rogno','Rogno','','BG',1,'1840-01-01','2999-12-31'),
	(29902,'03','016',' 18','016183',16183,'Romano di Lombardia','Romano di Lombardia','','BG',1,'1840-01-01','2999-12-31'),
	(29903,'03','016',' 18','016184',16184,'Roncobello','Roncobello','','BG',1,'1840-01-01','2999-12-31'),
	(29904,'03','016',' 18','016185',16185,'Roncola','Roncola','','BG',1,'1840-01-01','2999-12-31'),
	(29905,'03','016',' 18','016186',16186,'Rota d\'Imagna','Rota d\'Imagna','','BG',1,'1840-01-01','2999-12-31'),
	(29906,'03','016',' 18','016187',16187,'Rovetta','Rovetta','','BG',1,'1840-01-01','2999-12-31'),
	(29907,'03','016',' 18','016188',16188,'San Giovanni Bianco','San Giovanni Bianco','','BG',1,'1840-01-01','2999-12-31'),
	(29908,'03','016',' 18','016189',16189,'San Paolo d\'Argon','San Paolo d\'Argon','','BG',1,'1840-01-01','2999-12-31'),
	(29909,'03','016',' 19','016190',16190,'San Pellegrino Terme','San Pellegrino Terme','','BG',1,'1840-01-01','2999-12-31'),
	(29910,'03','016',' 19','016191',16191,'Santa Brigida','Santa Brigida','','BG',1,'1840-01-01','2999-12-31'),
	(29911,'03','016',' 19','016192',16192,'Sant\'Omobono Terme','Sant\'Omobono Terme','','BG',1,'1840-01-01','2999-12-31'),
	(29912,'03','016',' 19','016193',16193,'Sarnico','Sarnico','','BG',1,'1840-01-01','2999-12-31'),
	(29913,'03','016',' 19','016194',16194,'Scanzorosciate','Scanzorosciate','','BG',1,'1840-01-01','2999-12-31'),
	(29914,'03','016',' 19','016195',16195,'Schilpario','Schilpario','','BG',1,'1840-01-01','2999-12-31'),
	(29915,'03','016',' 19','016196',16196,'Sedrina','Sedrina','','BG',1,'1840-01-01','2999-12-31'),
	(29916,'03','016',' 19','016197',16197,'Selvino','Selvino','','BG',1,'1840-01-01','2999-12-31'),
	(29917,'03','016',' 19','016198',16198,'Seriate','Seriate','','BG',1,'1840-01-01','2999-12-31'),
	(29918,'03','016',' 19','016199',16199,'Serina','Serina','','BG',1,'1840-01-01','2999-12-31'),
	(29919,'03','016',' 20','016200',16200,'Solto Collina','Solto Collina','','BG',1,'1840-01-01','2999-12-31'),
	(29920,'03','016',' 20','016201',16201,'Songavazzo','Songavazzo','','BG',1,'1840-01-01','2999-12-31'),
	(29921,'03','016',' 20','016202',16202,'Sorisole','Sorisole','','BG',1,'1840-01-01','2999-12-31'),
	(29922,'03','016',' 20','016203',16203,'Sotto il Monte Giovanni XXIII','Sotto il Monte Giovanni XXIII','','BG',1,'1840-01-01','2999-12-31'),
	(29923,'03','016',' 20','016204',16204,'Sovere','Sovere','','BG',1,'1840-01-01','2999-12-31'),
	(29924,'03','016',' 20','016205',16205,'Spinone al Lago','Spinone al Lago','','BG',1,'1840-01-01','2999-12-31'),
	(29925,'03','016',' 20','016206',16206,'Spirano','Spirano','','BG',1,'1840-01-01','2999-12-31'),
	(29926,'03','016',' 20','016207',16207,'Stezzano','Stezzano','','BG',1,'1840-01-01','2999-12-31'),
	(29927,'03','016',' 20','016208',16208,'Strozza','Strozza','','BG',1,'1840-01-01','2999-12-31'),
	(29928,'03','016',' 20','016209',16209,'Suisio','Suisio','','BG',1,'1840-01-01','2999-12-31'),
	(29929,'03','016',' 21','016210',16210,'Taleggio','Taleggio','','BG',1,'1840-01-01','2999-12-31'),
	(29930,'03','016',' 21','016211',16211,'Tavernola Bergamasca','Tavernola Bergamasca','','BG',1,'1840-01-01','2999-12-31'),
	(29931,'03','016',' 21','016212',16212,'Telgate','Telgate','','BG',1,'1840-01-01','2999-12-31'),
	(29932,'03','016',' 21','016213',16213,'Terno d\'Isola','Terno d\'Isola','','BG',1,'1840-01-01','2999-12-31'),
	(29933,'03','016',' 21','016214',16214,'Torre Boldone','Torre Boldone','','BG',1,'1840-01-01','2999-12-31'),
	(29934,'03','016',' 21','016216',16216,'Torre de\' Roveri','Torre de\' Roveri','','BG',1,'1840-01-01','2999-12-31'),
	(29935,'03','016',' 21','016217',16217,'Torre Pallavicina','Torre Pallavicina','','BG',1,'1840-01-01','2999-12-31'),
	(29936,'03','016',' 21','016218',16218,'Trescore Balneario','Trescore Balneario','','BG',1,'1840-01-01','2999-12-31'),
	(29937,'03','016',' 21','016219',16219,'Treviglio','Treviglio','','BG',1,'1840-01-01','2999-12-31'),
	(29938,'03','016',' 22','016220',16220,'Treviolo','Treviolo','','BG',1,'1840-01-01','2999-12-31'),
	(29939,'03','016',' 22','016221',16221,'Ubiale Clanezzo','Ubiale Clanezzo','','BG',1,'1840-01-01','2999-12-31'),
	(29940,'03','016',' 22','016222',16222,'Urgnano','Urgnano','','BG',1,'1840-01-01','2999-12-31'),
	(29941,'03','016',' 22','016223',16223,'Valbondione','Valbondione','','BG',1,'1840-01-01','2999-12-31'),
	(29942,'03','016',' 22','016224',16224,'Valbrembo','Valbrembo','','BG',1,'1840-01-01','2999-12-31'),
	(29943,'03','016',' 22','016225',16225,'Valgoglio','Valgoglio','','BG',1,'1840-01-01','2999-12-31'),
	(29944,'03','016',' 22','016226',16226,'Valleve','Valleve','','BG',1,'1840-01-01','2999-12-31'),
	(29945,'03','016',' 22','016227',16227,'Valnegra','Valnegra','','BG',1,'1840-01-01','2999-12-31'),
	(29946,'03','016',' 22','016228',16228,'Valsecca','Valsecca','','BG',1,'1840-01-01','2999-12-31'),
	(29947,'03','016',' 22','016229',16229,'Valtorta','Valtorta','','BG',1,'1840-01-01','2999-12-31'),
	(29948,'03','016',' 23','016230',16230,'Vedeseta','Vedeseta','','BG',1,'1840-01-01','2999-12-31'),
	(29949,'03','016',' 23','016232',16232,'Verdellino','Verdellino','','BG',1,'1840-01-01','2999-12-31'),
	(29950,'03','016',' 23','016233',16233,'Verdello','Verdello','','BG',1,'1840-01-01','2999-12-31'),
	(29951,'03','016',' 23','016234',16234,'Vertova','Vertova','','BG',1,'1840-01-01','2999-12-31'),
	(29952,'03','016',' 23','016235',16235,'Viadanica','Viadanica','','BG',1,'1840-01-01','2999-12-31'),
	(29953,'03','016',' 23','016236',16236,'Vigano San Martino','Vigano San Martino','','BG',1,'1840-01-01','2999-12-31'),
	(29954,'03','016',' 23','016237',16237,'Vigolo','Vigolo','','BG',1,'1840-01-01','2999-12-31'),
	(29955,'03','016',' 23','016238',16238,'Villa d\'Adda','Villa d\'Adda','','BG',1,'1840-01-01','2999-12-31'),
	(29956,'03','016',' 23','016239',16239,'Villa d\'Almè','Villa d\'Almè','','BG',1,'1840-01-01','2999-12-31'),
	(29957,'03','016',' 24','016240',16240,'Villa di Serio','Villa di Serio','','BG',1,'1840-01-01','2999-12-31'),
	(29958,'03','016',' 24','016241',16241,'Villa d\'Ogna','Villa d\'Ogna','','BG',1,'1840-01-01','2999-12-31'),
	(29959,'03','016',' 24','016242',16242,'Villongo','Villongo','','BG',1,'1840-01-01','2999-12-31'),
	(29960,'03','016',' 24','016243',16243,'Vilminore di Scalve','Vilminore di Scalve','','BG',1,'1840-01-01','2999-12-31'),
	(29961,'03','016',' 24','016244',16244,'Zandobbio','Zandobbio','','BG',1,'1840-01-01','2999-12-31'),
	(29962,'03','016',' 24','016245',16245,'Zanica','Zanica','','BG',1,'1840-01-01','2999-12-31'),
	(29963,'03','016',' 24','016246',16246,'Zogno','Zogno','','BG',1,'1840-01-01','2999-12-31'),
	(29964,'03','016',' 24','016247',16247,'Costa Serina','Costa Serina','','BG',1,'1840-01-01','2999-12-31'),
	(29965,'03','016',' 24','016248',16248,'Algua','Algua','','BG',1,'1840-01-01','2999-12-31'),
	(29966,'03','016',' 24','016249',16249,'Cornalba','Cornalba','','BG',1,'1840-01-01','2999-12-31'),
	(29967,'03','016',' 25','016250',16250,'Medolago','Medolago','','BG',1,'1840-01-01','2999-12-31'),
	(29968,'03','016',' 25','016251',16251,'Solza','Solza','','BG',1,'1840-01-01','2999-12-31'),
	(29969,'03','017',' 00','017001',17001,'Acquafredda','Acquafredda','','BS',1,'1840-01-01','2999-12-31'),
	(29970,'03','017',' 00','017002',17002,'Adro','Adro','','BS',1,'1840-01-01','2999-12-31'),
	(29971,'03','017',' 00','017003',17003,'Agnosine','Agnosine','','BS',1,'1840-01-01','2999-12-31'),
	(29972,'03','017',' 00','017004',17004,'Alfianello','Alfianello','','BS',1,'1840-01-01','2999-12-31'),
	(29973,'03','017',' 00','017005',17005,'Anfo','Anfo','','BS',1,'1840-01-01','2999-12-31'),
	(29974,'03','017',' 00','017006',17006,'Angolo Terme','Angolo Terme','','BS',1,'1840-01-01','2999-12-31'),
	(29975,'03','017',' 00','017007',17007,'Artogne','Artogne','','BS',1,'1840-01-01','2999-12-31'),
	(29976,'03','017',' 00','017008',17008,'Azzano Mella','Azzano Mella','','BS',1,'1840-01-01','2999-12-31'),
	(29977,'03','017',' 00','017009',17009,'Bagnolo Mella','Bagnolo Mella','','BS',1,'1840-01-01','2999-12-31'),
	(29978,'03','017',' 01','017010',17010,'Bagolino','Bagolino','','BS',1,'1840-01-01','2999-12-31'),
	(29979,'03','017',' 01','017011',17011,'Barbariga','Barbariga','','BS',1,'1840-01-01','2999-12-31'),
	(29980,'03','017',' 01','017012',17012,'Barghe','Barghe','','BS',1,'1840-01-01','2999-12-31'),
	(29981,'03','017',' 01','017013',17013,'Bassano Bresciano','Bassano Bresciano','','BS',1,'1840-01-01','2999-12-31'),
	(29982,'03','017',' 01','017014',17014,'Bedizzole','Bedizzole','','BS',1,'1840-01-01','2999-12-31'),
	(29983,'03','017',' 01','017015',17015,'Berlingo','Berlingo','','BS',1,'1840-01-01','2999-12-31'),
	(29984,'03','017',' 01','017016',17016,'Berzo Demo','Berzo Demo','','BS',1,'1840-01-01','2999-12-31'),
	(29985,'03','017',' 01','017017',17017,'Berzo Inferiore','Berzo Inferiore','','BS',1,'1840-01-01','2999-12-31'),
	(29986,'03','017',' 01','017018',17018,'Bienno','Bienno','','BS',1,'1840-01-01','2999-12-31'),
	(29987,'03','017',' 01','017019',17019,'Bione','Bione','','BS',1,'1840-01-01','2999-12-31'),
	(29988,'03','017',' 02','017020',17020,'Borgo San Giacomo','Borgo San Giacomo','','BS',1,'1840-01-01','2999-12-31'),
	(29989,'03','017',' 02','017021',17021,'Borgosatollo','Borgosatollo','','BS',1,'1840-01-01','2999-12-31'),
	(29990,'03','017',' 02','017022',17022,'Borno','Borno','','BS',1,'1840-01-01','2999-12-31'),
	(29991,'03','017',' 02','017023',17023,'Botticino','Botticino','','BS',1,'1840-01-01','2999-12-31'),
	(29992,'03','017',' 02','017024',17024,'Bovegno','Bovegno','','BS',1,'1840-01-01','2999-12-31'),
	(29993,'03','017',' 02','017025',17025,'Bovezzo','Bovezzo','','BS',1,'1840-01-01','2999-12-31'),
	(29994,'03','017',' 02','017026',17026,'Brandico','Brandico','','BS',1,'1840-01-01','2999-12-31'),
	(29995,'03','017',' 02','017027',17027,'Braone','Braone','','BS',1,'1840-01-01','2999-12-31'),
	(29996,'03','017',' 02','017028',17028,'Breno','Breno','','BS',1,'1840-01-01','2999-12-31'),
	(29997,'03','017',' 02','017029',17029,'Brescia','Brescia','','BS',1,'1840-01-01','2999-12-31'),
	(29998,'03','017',' 03','017030',17030,'Brione','Brione','','BS',1,'1840-01-01','2999-12-31'),
	(29999,'03','017',' 03','017031',17031,'Caino','Caino','','BS',1,'1840-01-01','2999-12-31'),
	(30000,'03','017',' 03','017032',17032,'Calcinato','Calcinato','','BS',1,'1840-01-01','2999-12-31'),
	(30001,'03','017',' 03','017033',17033,'Calvagese della Riviera','Calvagese della Riviera','','BS',1,'1840-01-01','2999-12-31'),
	(30002,'03','017',' 03','017034',17034,'Calvisano','Calvisano','','BS',1,'1840-01-01','2999-12-31'),
	(30003,'03','017',' 03','017035',17035,'Capo di Ponte','Capo di Ponte','','BS',1,'1840-01-01','2999-12-31'),
	(30004,'03','017',' 03','017036',17036,'Capovalle','Capovalle','','BS',1,'1840-01-01','2999-12-31'),
	(30005,'03','017',' 03','017037',17037,'Capriano del Colle','Capriano del Colle','','BS',1,'1840-01-01','2999-12-31'),
	(30006,'03','017',' 03','017038',17038,'Capriolo','Capriolo','','BS',1,'1840-01-01','2999-12-31'),
	(30007,'03','017',' 03','017039',17039,'Carpenedolo','Carpenedolo','','BS',1,'1840-01-01','2999-12-31'),
	(30008,'03','017',' 04','017040',17040,'Castegnato','Castegnato','','BS',1,'1840-01-01','2999-12-31'),
	(30009,'03','017',' 04','017041',17041,'Castelcovati','Castelcovati','','BS',1,'1840-01-01','2999-12-31'),
	(30010,'03','017',' 04','017042',17042,'Castel Mella','Castel Mella','','BS',1,'1840-01-01','2999-12-31'),
	(30011,'03','017',' 04','017043',17043,'Castenedolo','Castenedolo','','BS',1,'1840-01-01','2999-12-31'),
	(30012,'03','017',' 04','017044',17044,'Casto','Casto','','BS',1,'1840-01-01','2999-12-31'),
	(30013,'03','017',' 04','017045',17045,'Castrezzato','Castrezzato','','BS',1,'1840-01-01','2999-12-31'),
	(30014,'03','017',' 04','017046',17046,'Cazzago San Martino','Cazzago San Martino','','BS',1,'1840-01-01','2999-12-31'),
	(30015,'03','017',' 04','017047',17047,'Cedegolo','Cedegolo','','BS',1,'1840-01-01','2999-12-31'),
	(30016,'03','017',' 04','017048',17048,'Cellatica','Cellatica','','BS',1,'1840-01-01','2999-12-31'),
	(30017,'03','017',' 04','017049',17049,'Cerveno','Cerveno','','BS',1,'1840-01-01','2999-12-31'),
	(30018,'03','017',' 05','017050',17050,'Ceto','Ceto','','BS',1,'1840-01-01','2999-12-31'),
	(30019,'03','017',' 05','017051',17051,'Cevo','Cevo','','BS',1,'1840-01-01','2999-12-31'),
	(30020,'03','017',' 05','017052',17052,'Chiari','Chiari','','BS',1,'1840-01-01','2999-12-31'),
	(30021,'03','017',' 05','017053',17053,'Cigole','Cigole','','BS',1,'1840-01-01','2999-12-31'),
	(30022,'03','017',' 05','017054',17054,'Cimbergo','Cimbergo','','BS',1,'1840-01-01','2999-12-31'),
	(30023,'03','017',' 05','017055',17055,'Cividate Camuno','Cividate Camuno','','BS',1,'1840-01-01','2999-12-31'),
	(30024,'03','017',' 05','017056',17056,'Coccaglio','Coccaglio','','BS',1,'1840-01-01','2999-12-31'),
	(30025,'03','017',' 05','017057',17057,'Collebeato','Collebeato','','BS',1,'1840-01-01','2999-12-31'),
	(30026,'03','017',' 05','017058',17058,'Collio','Collio','','BS',1,'1840-01-01','2999-12-31'),
	(30027,'03','017',' 05','017059',17059,'Cologne','Cologne','','BS',1,'1840-01-01','2999-12-31'),
	(30028,'03','017',' 06','017060',17060,'Comezzano-Cizzago','Comezzano-Cizzago','','BS',1,'1840-01-01','2999-12-31'),
	(30029,'03','017',' 06','017061',17061,'Concesio','Concesio','','BS',1,'1840-01-01','2999-12-31'),
	(30030,'03','017',' 06','017062',17062,'Corte Franca','Corte Franca','','BS',1,'1840-01-01','2999-12-31'),
	(30031,'03','017',' 06','017063',17063,'Corteno Golgi','Corteno Golgi','','BS',1,'1840-01-01','2999-12-31'),
	(30032,'03','017',' 06','017064',17064,'Corzano','Corzano','','BS',1,'1840-01-01','2999-12-31'),
	(30033,'03','017',' 06','017065',17065,'Darfo Boario Terme','Darfo Boario Terme','','BS',1,'1840-01-01','2999-12-31'),
	(30034,'03','017',' 06','017066',17066,'Dello','Dello','','BS',1,'1840-01-01','2999-12-31'),
	(30035,'03','017',' 06','017067',17067,'Desenzano del Garda','Desenzano del Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30036,'03','017',' 06','017068',17068,'Edolo','Edolo','','BS',1,'1840-01-01','2999-12-31'),
	(30037,'03','017',' 06','017069',17069,'Erbusco','Erbusco','','BS',1,'1840-01-01','2999-12-31'),
	(30038,'03','017',' 07','017070',17070,'Esine','Esine','','BS',1,'1840-01-01','2999-12-31'),
	(30039,'03','017',' 07','017071',17071,'Fiesse','Fiesse','','BS',1,'1840-01-01','2999-12-31'),
	(30040,'03','017',' 07','017072',17072,'Flero','Flero','','BS',1,'1840-01-01','2999-12-31'),
	(30041,'03','017',' 07','017073',17073,'Gambara','Gambara','','BS',1,'1840-01-01','2999-12-31'),
	(30042,'03','017',' 07','017074',17074,'Gardone Riviera','Gardone Riviera','','BS',1,'1840-01-01','2999-12-31'),
	(30043,'03','017',' 07','017075',17075,'Gardone Val Trompia','Gardone Val Trompia','','BS',1,'1840-01-01','2999-12-31'),
	(30044,'03','017',' 07','017076',17076,'Gargnano','Gargnano','','BS',1,'1840-01-01','2999-12-31'),
	(30045,'03','017',' 07','017077',17077,'Gavardo','Gavardo','','BS',1,'1840-01-01','2999-12-31'),
	(30046,'03','017',' 07','017078',17078,'Ghedi','Ghedi','','BS',1,'1840-01-01','2999-12-31'),
	(30047,'03','017',' 07','017079',17079,'Gianico','Gianico','','BS',1,'1840-01-01','2999-12-31'),
	(30048,'03','017',' 08','017080',17080,'Gottolengo','Gottolengo','','BS',1,'1840-01-01','2999-12-31'),
	(30049,'03','017',' 08','017081',17081,'Gussago','Gussago','','BS',1,'1840-01-01','2999-12-31'),
	(30050,'03','017',' 08','017082',17082,'Idro','Idro','','BS',1,'1840-01-01','2999-12-31'),
	(30051,'03','017',' 08','017083',17083,'Incudine','Incudine','','BS',1,'1840-01-01','2999-12-31'),
	(30052,'03','017',' 08','017084',17084,'Irma','Irma','','BS',1,'1840-01-01','2999-12-31'),
	(30053,'03','017',' 08','017085',17085,'Iseo','Iseo','','BS',1,'1840-01-01','2999-12-31'),
	(30054,'03','017',' 08','017086',17086,'Isorella','Isorella','','BS',1,'1840-01-01','2999-12-31'),
	(30055,'03','017',' 08','017087',17087,'Lavenone','Lavenone','','BS',1,'1840-01-01','2999-12-31'),
	(30056,'03','017',' 08','017088',17088,'Leno','Leno','','BS',1,'1840-01-01','2999-12-31'),
	(30057,'03','017',' 08','017089',17089,'Limone sul Garda','Limone sul Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30058,'03','017',' 09','017090',17090,'Lodrino','Lodrino','','BS',1,'1840-01-01','2999-12-31'),
	(30059,'03','017',' 09','017091',17091,'Lograto','Lograto','','BS',1,'1840-01-01','2999-12-31'),
	(30060,'03','017',' 09','017092',17092,'Lonato del Garda','Lonato del Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30061,'03','017',' 09','017093',17093,'Longhena','Longhena','','BS',1,'1840-01-01','2999-12-31'),
	(30062,'03','017',' 09','017094',17094,'Losine','Losine','','BS',1,'1840-01-01','2999-12-31'),
	(30063,'03','017',' 09','017095',17095,'Lozio','Lozio','','BS',1,'1840-01-01','2999-12-31'),
	(30064,'03','017',' 09','017096',17096,'Lumezzane','Lumezzane','','BS',1,'1840-01-01','2999-12-31'),
	(30065,'03','017',' 09','017097',17097,'Maclodio','Maclodio','','BS',1,'1840-01-01','2999-12-31'),
	(30066,'03','017',' 09','017098',17098,'Magasa','Magasa','','BS',1,'1840-01-01','2999-12-31'),
	(30067,'03','017',' 09','017099',17099,'Mairano','Mairano','','BS',1,'1840-01-01','2999-12-31'),
	(30068,'03','017',' 10','017100',17100,'Malegno','Malegno','','BS',1,'1840-01-01','2999-12-31'),
	(30069,'03','017',' 10','017101',17101,'Malonno','Malonno','','BS',1,'1840-01-01','2999-12-31'),
	(30070,'03','017',' 10','017102',17102,'Manerba del Garda','Manerba del Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30071,'03','017',' 10','017103',17103,'Manerbio','Manerbio','','BS',1,'1840-01-01','2999-12-31'),
	(30072,'03','017',' 10','017104',17104,'Marcheno','Marcheno','','BS',1,'1840-01-01','2999-12-31'),
	(30073,'03','017',' 10','017105',17105,'Marmentino','Marmentino','','BS',1,'1840-01-01','2999-12-31'),
	(30074,'03','017',' 10','017106',17106,'Marone','Marone','','BS',1,'1840-01-01','2999-12-31'),
	(30075,'03','017',' 10','017107',17107,'Mazzano','Mazzano','','BS',1,'1840-01-01','2999-12-31'),
	(30076,'03','017',' 10','017108',17108,'Milzano','Milzano','','BS',1,'1840-01-01','2999-12-31'),
	(30077,'03','017',' 10','017109',17109,'Moniga del Garda','Moniga del Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30078,'03','017',' 11','017110',17110,'Monno','Monno','','BS',1,'1840-01-01','2999-12-31'),
	(30079,'03','017',' 11','017111',17111,'Monte Isola','Monte Isola','','BS',1,'1840-01-01','2999-12-31'),
	(30080,'03','017',' 11','017112',17112,'Monticelli Brusati','Monticelli Brusati','','BS',1,'1840-01-01','2999-12-31'),
	(30081,'03','017',' 11','017113',17113,'Montichiari','Montichiari','','BS',1,'1840-01-01','2999-12-31'),
	(30082,'03','017',' 11','017114',17114,'Montirone','Montirone','','BS',1,'1840-01-01','2999-12-31'),
	(30083,'03','017',' 11','017115',17115,'Mura','Mura','','BS',1,'1840-01-01','2999-12-31'),
	(30084,'03','017',' 11','017116',17116,'Muscoline','Muscoline','','BS',1,'1840-01-01','2999-12-31'),
	(30085,'03','017',' 11','017117',17117,'Nave','Nave','','BS',1,'1840-01-01','2999-12-31'),
	(30086,'03','017',' 11','017118',17118,'Niardo','Niardo','','BS',1,'1840-01-01','2999-12-31'),
	(30087,'03','017',' 11','017119',17119,'Nuvolento','Nuvolento','','BS',1,'1840-01-01','2999-12-31'),
	(30088,'03','017',' 12','017120',17120,'Nuvolera','Nuvolera','','BS',1,'1840-01-01','2999-12-31'),
	(30089,'03','017',' 12','017121',17121,'Odolo','Odolo','','BS',1,'1840-01-01','2999-12-31'),
	(30090,'03','017',' 12','017122',17122,'Offlaga','Offlaga','','BS',1,'1840-01-01','2999-12-31'),
	(30091,'03','017',' 12','017123',17123,'Ome','Ome','','BS',1,'1840-01-01','2999-12-31'),
	(30092,'03','017',' 12','017124',17124,'Ono San Pietro','Ono San Pietro','','BS',1,'1840-01-01','2999-12-31'),
	(30093,'03','017',' 12','017125',17125,'Orzinuovi','Orzinuovi','','BS',1,'1840-01-01','2999-12-31'),
	(30094,'03','017',' 12','017126',17126,'Orzivecchi','Orzivecchi','','BS',1,'1840-01-01','2999-12-31'),
	(30095,'03','017',' 12','017127',17127,'Ospitaletto','Ospitaletto','','BS',1,'1840-01-01','2999-12-31'),
	(30096,'03','017',' 12','017128',17128,'Ossimo','Ossimo','','BS',1,'1840-01-01','2999-12-31'),
	(30097,'03','017',' 12','017129',17129,'Padenghe sul Garda','Padenghe sul Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30098,'03','017',' 13','017130',17130,'Paderno Franciacorta','Paderno Franciacorta','','BS',1,'1840-01-01','2999-12-31'),
	(30099,'03','017',' 13','017131',17131,'Paisco Loveno','Paisco Loveno','','BS',1,'1840-01-01','2999-12-31'),
	(30100,'03','017',' 13','017132',17132,'Paitone','Paitone','','BS',1,'1840-01-01','2999-12-31'),
	(30101,'03','017',' 13','017133',17133,'Palazzolo sull\'Oglio','Palazzolo sull\'Oglio','','BS',1,'1840-01-01','2999-12-31'),
	(30102,'03','017',' 13','017134',17134,'Paratico','Paratico','','BS',1,'1840-01-01','2999-12-31'),
	(30103,'03','017',' 13','017135',17135,'Paspardo','Paspardo','','BS',1,'1840-01-01','2999-12-31'),
	(30104,'03','017',' 13','017136',17136,'Passirano','Passirano','','BS',1,'1840-01-01','2999-12-31'),
	(30105,'03','017',' 13','017137',17137,'Pavone del Mella','Pavone del Mella','','BS',1,'1840-01-01','2999-12-31'),
	(30106,'03','017',' 13','017138',17138,'San Paolo','San Paolo','','BS',1,'1840-01-01','2999-12-31'),
	(30107,'03','017',' 13','017139',17139,'Pertica Alta','Pertica Alta','','BS',1,'1840-01-01','2999-12-31'),
	(30108,'03','017',' 14','017140',17140,'Pertica Bassa','Pertica Bassa','','BS',1,'1840-01-01','2999-12-31'),
	(30109,'03','017',' 14','017141',17141,'Pezzaze','Pezzaze','','BS',1,'1840-01-01','2999-12-31'),
	(30110,'03','017',' 14','017142',17142,'Pian Camuno','Pian Camuno','','BS',1,'1840-01-01','2999-12-31'),
	(30111,'03','017',' 14','017143',17143,'Pisogne','Pisogne','','BS',1,'1840-01-01','2999-12-31'),
	(30112,'03','017',' 14','017144',17144,'Polaveno','Polaveno','','BS',1,'1840-01-01','2999-12-31'),
	(30113,'03','017',' 14','017145',17145,'Polpenazze del Garda','Polpenazze del Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30114,'03','017',' 14','017146',17146,'Pompiano','Pompiano','','BS',1,'1840-01-01','2999-12-31'),
	(30115,'03','017',' 14','017147',17147,'Poncarale','Poncarale','','BS',1,'1840-01-01','2999-12-31'),
	(30116,'03','017',' 14','017148',17148,'Ponte di Legno','Ponte di Legno','','BS',1,'1840-01-01','2999-12-31'),
	(30117,'03','017',' 14','017149',17149,'Pontevico','Pontevico','','BS',1,'1840-01-01','2999-12-31'),
	(30118,'03','017',' 15','017150',17150,'Pontoglio','Pontoglio','','BS',1,'1840-01-01','2999-12-31'),
	(30119,'03','017',' 15','017151',17151,'Pozzolengo','Pozzolengo','','BS',1,'1840-01-01','2999-12-31'),
	(30120,'03','017',' 15','017152',17152,'Pralboino','Pralboino','','BS',1,'1840-01-01','2999-12-31'),
	(30121,'03','017',' 15','017153',17153,'Preseglie','Preseglie','','BS',1,'1840-01-01','2999-12-31'),
	(30122,'03','017',' 15','017154',17154,'Prestine','Prestine','','BS',1,'1840-01-01','2999-12-31'),
	(30123,'03','017',' 15','017155',17155,'Prevalle','Prevalle','','BS',1,'1840-01-01','2999-12-31'),
	(30124,'03','017',' 15','017156',17156,'Provaglio d\'Iseo','Provaglio d\'Iseo','','BS',1,'1840-01-01','2999-12-31'),
	(30125,'03','017',' 15','017157',17157,'Provaglio Val Sabbia','Provaglio Val Sabbia','','BS',1,'1840-01-01','2999-12-31'),
	(30126,'03','017',' 15','017158',17158,'Puegnago sul Garda','Puegnago sul Garda','','BS',1,'1840-01-01','2999-12-31'),
	(30127,'03','017',' 15','017159',17159,'Quinzano d\'Oglio','Quinzano d\'Oglio','','BS',1,'1840-01-01','2999-12-31'),
	(30128,'03','017',' 16','017160',17160,'Remedello','Remedello','','BS',1,'1840-01-01','2999-12-31'),
	(30129,'03','017',' 16','017161',17161,'Rezzato','Rezzato','','BS',1,'1840-01-01','2999-12-31'),
	(30130,'03','017',' 16','017162',17162,'Roccafranca','Roccafranca','','BS',1,'1840-01-01','2999-12-31'),
	(30131,'03','017',' 16','017163',17163,'Rodengo Saiano','Rodengo Saiano','','BS',1,'1840-01-01','2999-12-31'),
	(30132,'03','017',' 16','017164',17164,'Roè Volciano','Roè Volciano','','BS',1,'1840-01-01','2999-12-31'),
	(30133,'03','017',' 16','017165',17165,'Roncadelle','Roncadelle','','BS',1,'1840-01-01','2999-12-31'),
	(30134,'03','017',' 16','017166',17166,'Rovato','Rovato','','BS',1,'1840-01-01','2999-12-31'),
	(30135,'03','017',' 16','017167',17167,'Rudiano','Rudiano','','BS',1,'1840-01-01','2999-12-31'),
	(30136,'03','017',' 16','017168',17168,'Sabbio Chiese','Sabbio Chiese','','BS',1,'1840-01-01','2999-12-31'),
	(30137,'03','017',' 16','017169',17169,'Sale Marasino','Sale Marasino','','BS',1,'1840-01-01','2999-12-31'),
	(30138,'03','017',' 17','017170',17170,'Salò','Salò','','BS',1,'1840-01-01','2999-12-31'),
	(30139,'03','017',' 17','017171',17171,'San Felice del Benaco','San Felice del Benaco','','BS',1,'1840-01-01','2999-12-31'),
	(30140,'03','017',' 17','017172',17172,'San Gervasio Bresciano','San Gervasio Bresciano','','BS',1,'1840-01-01','2999-12-31'),
	(30141,'03','017',' 17','017173',17173,'San Zeno Naviglio','San Zeno Naviglio','','BS',1,'1840-01-01','2999-12-31'),
	(30142,'03','017',' 17','017174',17174,'Sarezzo','Sarezzo','','BS',1,'1840-01-01','2999-12-31'),
	(30143,'03','017',' 17','017175',17175,'Saviore dell\'Adamello','Saviore dell\'Adamello','','BS',1,'1840-01-01','2999-12-31'),
	(30144,'03','017',' 17','017176',17176,'Sellero','Sellero','','BS',1,'1840-01-01','2999-12-31'),
	(30145,'03','017',' 17','017177',17177,'Seniga','Seniga','','BS',1,'1840-01-01','2999-12-31'),
	(30146,'03','017',' 17','017178',17178,'Serle','Serle','','BS',1,'1840-01-01','2999-12-31'),
	(30147,'03','017',' 17','017179',17179,'Sirmione','Sirmione','','BS',1,'1840-01-01','2999-12-31'),
	(30148,'03','017',' 18','017180',17180,'Soiano del Lago','Soiano del Lago','','BS',1,'1840-01-01','2999-12-31'),
	(30149,'03','017',' 18','017181',17181,'Sonico','Sonico','','BS',1,'1840-01-01','2999-12-31'),
	(30150,'03','017',' 18','017182',17182,'Sulzano','Sulzano','','BS',1,'1840-01-01','2999-12-31'),
	(30151,'03','017',' 18','017183',17183,'Tavernole sul Mella','Tavernole sul Mella','','BS',1,'1840-01-01','2999-12-31'),
	(30152,'03','017',' 18','017184',17184,'Temù','Temù','','BS',1,'1840-01-01','2999-12-31'),
	(30153,'03','017',' 18','017185',17185,'Tignale','Tignale','','BS',1,'1840-01-01','2999-12-31'),
	(30154,'03','017',' 18','017186',17186,'Torbole Casaglia','Torbole Casaglia','','BS',1,'1840-01-01','2999-12-31'),
	(30155,'03','017',' 18','017187',17187,'Toscolano-Maderno','Toscolano-Maderno','','BS',1,'1840-01-01','2999-12-31'),
	(30156,'03','017',' 18','017188',17188,'Travagliato','Travagliato','','BS',1,'1840-01-01','2999-12-31'),
	(30157,'03','017',' 18','017189',17189,'Tremosine','Tremosine','','BS',1,'1840-01-01','2999-12-31'),
	(30158,'03','017',' 19','017190',17190,'Trenzano','Trenzano','','BS',1,'1840-01-01','2999-12-31'),
	(30159,'03','017',' 19','017191',17191,'Treviso Bresciano','Treviso Bresciano','','BS',1,'1840-01-01','2999-12-31'),
	(30160,'03','017',' 19','017192',17192,'Urago d\'Oglio','Urago d\'Oglio','','BS',1,'1840-01-01','2999-12-31'),
	(30161,'03','017',' 19','017193',17193,'Vallio Terme','Vallio Terme','','BS',1,'1840-01-01','2999-12-31'),
	(30162,'03','017',' 19','017194',17194,'Valvestino','Valvestino','','BS',1,'1840-01-01','2999-12-31'),
	(30163,'03','017',' 19','017195',17195,'Verolanuova','Verolanuova','','BS',1,'1840-01-01','2999-12-31'),
	(30164,'03','017',' 19','017196',17196,'Verolavecchia','Verolavecchia','','BS',1,'1840-01-01','2999-12-31'),
	(30165,'03','017',' 19','017197',17197,'Vestone','Vestone','','BS',1,'1840-01-01','2999-12-31'),
	(30166,'03','017',' 19','017198',17198,'Vezza d\'Oglio','Vezza d\'Oglio','','BS',1,'1840-01-01','2999-12-31'),
	(30167,'03','017',' 19','017199',17199,'Villa Carcina','Villa Carcina','','BS',1,'1840-01-01','2999-12-31'),
	(30168,'03','017',' 20','017200',17200,'Villachiara','Villachiara','','BS',1,'1840-01-01','2999-12-31'),
	(30169,'03','017',' 20','017201',17201,'Villanuova sul Clisi','Villanuova sul Clisi','','BS',1,'1840-01-01','2999-12-31'),
	(30170,'03','017',' 20','017202',17202,'Vione','Vione','','BS',1,'1840-01-01','2999-12-31'),
	(30171,'03','017',' 20','017203',17203,'Visano','Visano','','BS',1,'1840-01-01','2999-12-31'),
	(30172,'03','017',' 20','017204',17204,'Vobarno','Vobarno','','BS',1,'1840-01-01','2999-12-31'),
	(30173,'03','017',' 20','017205',17205,'Zone','Zone','','BS',1,'1840-01-01','2999-12-31'),
	(30174,'03','017',' 20','017206',17206,'Piancogno','Piancogno','','BS',1,'1840-01-01','2999-12-31'),
	(30175,'03','018',' 00','018001',18001,'Alagna','Alagna','','PV',1,'1840-01-01','2999-12-31'),
	(30176,'03','018',' 00','018002',18002,'Albaredo Arnaboldi','Albaredo Arnaboldi','','PV',1,'1840-01-01','2999-12-31'),
	(30177,'03','018',' 00','018003',18003,'Albonese','Albonese','','PV',1,'1840-01-01','2999-12-31'),
	(30178,'03','018',' 00','018004',18004,'Albuzzano','Albuzzano','','PV',1,'1840-01-01','2999-12-31'),
	(30179,'03','018',' 00','018005',18005,'Arena Po','Arena Po','','PV',1,'1840-01-01','2999-12-31'),
	(30180,'03','018',' 00','018006',18006,'Badia Pavese','Badia Pavese','','PV',1,'1840-01-01','2999-12-31'),
	(30181,'03','018',' 00','018007',18007,'Bagnaria','Bagnaria','','PV',1,'1840-01-01','2999-12-31'),
	(30182,'03','018',' 00','018008',18008,'Barbianello','Barbianello','','PV',1,'1840-01-01','2999-12-31'),
	(30183,'03','018',' 00','018009',18009,'Bascapè','Bascapè','','PV',1,'1840-01-01','2999-12-31'),
	(30184,'03','018',' 01','018010',18010,'Bastida de\' Dossi','Bastida de\' Dossi','','PV',1,'1840-01-01','2999-12-31'),
	(30185,'03','018',' 01','018011',18011,'Bastida Pancarana','Bastida Pancarana','','PV',1,'1840-01-01','2999-12-31'),
	(30186,'03','018',' 01','018012',18012,'Battuda','Battuda','','PV',1,'1840-01-01','2999-12-31'),
	(30187,'03','018',' 01','018013',18013,'Belgioioso','Belgioioso','','PV',1,'1840-01-01','2999-12-31'),
	(30188,'03','018',' 01','018014',18014,'Bereguardo','Bereguardo','','PV',1,'1840-01-01','2999-12-31'),
	(30189,'03','018',' 01','018015',18015,'Borgarello','Borgarello','','PV',1,'1840-01-01','2999-12-31'),
	(30190,'03','018',' 01','018016',18016,'Borgo Priolo','Borgo Priolo','','PV',1,'1840-01-01','2999-12-31'),
	(30191,'03','018',' 01','018017',18017,'Borgoratto Mormorolo','Borgoratto Mormorolo','','PV',1,'1840-01-01','2999-12-31'),
	(30192,'03','018',' 01','018018',18018,'Borgo San Siro','Borgo San Siro','','PV',1,'1840-01-01','2999-12-31'),
	(30193,'03','018',' 01','018019',18019,'Bornasco','Bornasco','','PV',1,'1840-01-01','2999-12-31'),
	(30194,'03','018',' 02','018020',18020,'Bosnasco','Bosnasco','','PV',1,'1840-01-01','2999-12-31'),
	(30195,'03','018',' 02','018021',18021,'Brallo di Pregola','Brallo di Pregola','','PV',1,'1840-01-01','2999-12-31'),
	(30196,'03','018',' 02','018022',18022,'Breme','Breme','','PV',1,'1840-01-01','2999-12-31'),
	(30197,'03','018',' 02','018023',18023,'Bressana Bottarone','Bressana Bottarone','','PV',1,'1840-01-01','2999-12-31'),
	(30198,'03','018',' 02','018024',18024,'Broni','Broni','','PV',1,'1840-01-01','2999-12-31'),
	(30199,'03','018',' 02','018025',18025,'Calvignano','Calvignano','','PV',1,'1840-01-01','2999-12-31'),
	(30200,'03','018',' 02','018026',18026,'Campospinoso','Campospinoso','','PV',1,'1840-01-01','2999-12-31'),
	(30201,'03','018',' 02','018027',18027,'Candia Lomellina','Candia Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30202,'03','018',' 02','018028',18028,'Canevino','Canevino','','PV',1,'1840-01-01','2999-12-31'),
	(30203,'03','018',' 02','018029',18029,'Canneto Pavese','Canneto Pavese','','PV',1,'1840-01-01','2999-12-31'),
	(30204,'03','018',' 03','018030',18030,'Carbonara al Ticino','Carbonara al Ticino','','PV',1,'1840-01-01','2999-12-31'),
	(30205,'03','018',' 03','018031',18031,'Casanova Lonati','Casanova Lonati','','PV',1,'1840-01-01','2999-12-31'),
	(30206,'03','018',' 03','018032',18032,'Casatisma','Casatisma','','PV',1,'1840-01-01','2999-12-31'),
	(30207,'03','018',' 03','018033',18033,'Casei Gerola','Casei Gerola','','PV',1,'1840-01-01','2999-12-31'),
	(30208,'03','018',' 03','018034',18034,'Casorate Primo','Casorate Primo','','PV',1,'1840-01-01','2999-12-31'),
	(30209,'03','018',' 03','018035',18035,'Cassolnovo','Cassolnovo','','PV',1,'1840-01-01','2999-12-31'),
	(30210,'03','018',' 03','018036',18036,'Castana','Castana','','PV',1,'1840-01-01','2999-12-31'),
	(30211,'03','018',' 03','018037',18037,'Casteggio','Casteggio','','PV',1,'1840-01-01','2999-12-31'),
	(30212,'03','018',' 03','018038',18038,'Castelletto di Branduzzo','Castelletto di Branduzzo','','PV',1,'1840-01-01','2999-12-31'),
	(30213,'03','018',' 03','018039',18039,'Castello d\'Agogna','Castello d\'Agogna','','PV',1,'1840-01-01','2999-12-31'),
	(30214,'03','018',' 04','018040',18040,'Castelnovetto','Castelnovetto','','PV',1,'1840-01-01','2999-12-31'),
	(30215,'03','018',' 04','018041',18041,'Cava Manara','Cava Manara','','PV',1,'1840-01-01','2999-12-31'),
	(30216,'03','018',' 04','018042',18042,'Cecima','Cecima','','PV',1,'1840-01-01','2999-12-31'),
	(30217,'03','018',' 04','018043',18043,'Ceranova','Ceranova','','PV',1,'1840-01-01','2999-12-31'),
	(30218,'03','018',' 04','018044',18044,'Ceretto Lomellina','Ceretto Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30219,'03','018',' 04','018045',18045,'Cergnago','Cergnago','','PV',1,'1840-01-01','2999-12-31'),
	(30220,'03','018',' 04','018046',18046,'Certosa di Pavia','Certosa di Pavia','','PV',1,'1840-01-01','2999-12-31'),
	(30221,'03','018',' 04','018047',18047,'Cervesina','Cervesina','','PV',1,'1840-01-01','2999-12-31'),
	(30222,'03','018',' 04','018048',18048,'Chignolo Po','Chignolo Po','','PV',1,'1840-01-01','2999-12-31'),
	(30223,'03','018',' 04','018049',18049,'Cigognola','Cigognola','','PV',1,'1840-01-01','2999-12-31'),
	(30224,'03','018',' 05','018050',18050,'Cilavegna','Cilavegna','','PV',1,'1840-01-01','2999-12-31'),
	(30225,'03','018',' 05','018051',18051,'Codevilla','Codevilla','','PV',1,'1840-01-01','2999-12-31'),
	(30226,'03','018',' 05','018052',18052,'Confienza','Confienza','','PV',1,'1840-01-01','2999-12-31'),
	(30227,'03','018',' 05','018053',18053,'Copiano','Copiano','','PV',1,'1840-01-01','2999-12-31'),
	(30228,'03','018',' 05','018054',18054,'Corana','Corana','','PV',1,'1840-01-01','2999-12-31'),
	(30229,'03','018',' 05','018055',18055,'Cornale','Cornale','','PV',1,'1840-01-01','2999-12-31'),
	(30230,'03','018',' 05','018056',18056,'Corteolona','Corteolona','','PV',1,'1840-01-01','2999-12-31'),
	(30231,'03','018',' 05','018057',18057,'Corvino San Quirico','Corvino San Quirico','','PV',1,'1840-01-01','2999-12-31'),
	(30232,'03','018',' 05','018058',18058,'Costa de\' Nobili','Costa de\' Nobili','','PV',1,'1840-01-01','2999-12-31'),
	(30233,'03','018',' 05','018059',18059,'Cozzo','Cozzo','','PV',1,'1840-01-01','2999-12-31'),
	(30234,'03','018',' 06','018060',18060,'Cura Carpignano','Cura Carpignano','','PV',1,'1840-01-01','2999-12-31'),
	(30235,'03','018',' 06','018061',18061,'Dorno','Dorno','','PV',1,'1840-01-01','2999-12-31'),
	(30236,'03','018',' 06','018062',18062,'Ferrera Erbognone','Ferrera Erbognone','','PV',1,'1840-01-01','2999-12-31'),
	(30237,'03','018',' 06','018063',18063,'Filighera','Filighera','','PV',1,'1840-01-01','2999-12-31'),
	(30238,'03','018',' 06','018064',18064,'Fortunago','Fortunago','','PV',1,'1840-01-01','2999-12-31'),
	(30239,'03','018',' 06','018065',18065,'Frascarolo','Frascarolo','','PV',1,'1840-01-01','2999-12-31'),
	(30240,'03','018',' 06','018066',18066,'Galliavola','Galliavola','','PV',1,'1840-01-01','2999-12-31'),
	(30241,'03','018',' 06','018067',18067,'Gambarana','Gambarana','','PV',1,'1840-01-01','2999-12-31'),
	(30242,'03','018',' 06','018068',18068,'Gambolò','Gambolò','','PV',1,'1840-01-01','2999-12-31'),
	(30243,'03','018',' 06','018069',18069,'Garlasco','Garlasco','','PV',1,'1840-01-01','2999-12-31'),
	(30244,'03','018',' 07','018070',18070,'Genzone','Genzone','','PV',1,'1840-01-01','2999-12-31'),
	(30245,'03','018',' 07','018071',18071,'Gerenzago','Gerenzago','','PV',1,'1840-01-01','2999-12-31'),
	(30246,'03','018',' 07','018072',18072,'Giussago','Giussago','','PV',1,'1840-01-01','2999-12-31'),
	(30247,'03','018',' 07','018073',18073,'Godiasco','Godiasco','','PV',1,'1840-01-01','2999-12-31'),
	(30248,'03','018',' 07','018074',18074,'Golferenzo','Golferenzo','','PV',1,'1840-01-01','2999-12-31'),
	(30249,'03','018',' 07','018075',18075,'Gravellona Lomellina','Gravellona Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30250,'03','018',' 07','018076',18076,'Gropello Cairoli','Gropello Cairoli','','PV',1,'1840-01-01','2999-12-31'),
	(30251,'03','018',' 07','018077',18077,'Inverno e Monteleone','Inverno e Monteleone','','PV',1,'1840-01-01','2999-12-31'),
	(30252,'03','018',' 07','018078',18078,'Landriano','Landriano','','PV',1,'1840-01-01','2999-12-31'),
	(30253,'03','018',' 07','018079',18079,'Langosco','Langosco','','PV',1,'1840-01-01','2999-12-31'),
	(30254,'03','018',' 08','018080',18080,'Lardirago','Lardirago','','PV',1,'1840-01-01','2999-12-31'),
	(30255,'03','018',' 08','018081',18081,'Linarolo','Linarolo','','PV',1,'1840-01-01','2999-12-31'),
	(30256,'03','018',' 08','018082',18082,'Lirio','Lirio','','PV',1,'1840-01-01','2999-12-31'),
	(30257,'03','018',' 08','018083',18083,'Lomello','Lomello','','PV',1,'1840-01-01','2999-12-31'),
	(30258,'03','018',' 08','018084',18084,'Lungavilla','Lungavilla','','PV',1,'1840-01-01','2999-12-31'),
	(30259,'03','018',' 08','018085',18085,'Magherno','Magherno','','PV',1,'1840-01-01','2999-12-31'),
	(30260,'03','018',' 08','018086',18086,'Marcignago','Marcignago','','PV',1,'1840-01-01','2999-12-31'),
	(30261,'03','018',' 08','018087',18087,'Marzano','Marzano','','PV',1,'1840-01-01','2999-12-31'),
	(30262,'03','018',' 08','018088',18088,'Mede','Mede','','PV',1,'1840-01-01','2999-12-31'),
	(30263,'03','018',' 08','018089',18089,'Menconico','Menconico','','PV',1,'1840-01-01','2999-12-31'),
	(30264,'03','018',' 09','018090',18090,'Mezzana Bigli','Mezzana Bigli','','PV',1,'1840-01-01','2999-12-31'),
	(30265,'03','018',' 09','018091',18091,'Mezzana Rabattone','Mezzana Rabattone','','PV',1,'1840-01-01','2999-12-31'),
	(30266,'03','018',' 09','018092',18092,'Mezzanino','Mezzanino','','PV',1,'1840-01-01','2999-12-31'),
	(30267,'03','018',' 09','018093',18093,'Miradolo Terme','Miradolo Terme','','PV',1,'1840-01-01','2999-12-31'),
	(30268,'03','018',' 09','018094',18094,'Montalto Pavese','Montalto Pavese','','PV',1,'1840-01-01','2999-12-31'),
	(30269,'03','018',' 09','018095',18095,'Montebello della Battaglia','Montebello della Battaglia','','PV',1,'1840-01-01','2999-12-31'),
	(30270,'03','018',' 09','018096',18096,'Montecalvo Versiggia','Montecalvo Versiggia','','PV',1,'1840-01-01','2999-12-31'),
	(30271,'03','018',' 09','018097',18097,'Montescano','Montescano','','PV',1,'1840-01-01','2999-12-31'),
	(30272,'03','018',' 09','018098',18098,'Montesegale','Montesegale','','PV',1,'1840-01-01','2999-12-31'),
	(30273,'03','018',' 09','018099',18099,'Monticelli Pavese','Monticelli Pavese','','PV',1,'1840-01-01','2999-12-31'),
	(30274,'03','018',' 10','018100',18100,'Montù Beccaria','Montù Beccaria','','PV',1,'1840-01-01','2999-12-31'),
	(30275,'03','018',' 10','018101',18101,'Mornico Losana','Mornico Losana','','PV',1,'1840-01-01','2999-12-31'),
	(30276,'03','018',' 10','018102',18102,'Mortara','Mortara','','PV',1,'1840-01-01','2999-12-31'),
	(30277,'03','018',' 10','018103',18103,'Nicorvo','Nicorvo','','PV',1,'1840-01-01','2999-12-31'),
	(30278,'03','018',' 10','018104',18104,'Olevano di Lomellina','Olevano di Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30279,'03','018',' 10','018105',18105,'Oliva Gessi','Oliva Gessi','','PV',1,'1840-01-01','2999-12-31'),
	(30280,'03','018',' 10','018106',18106,'Ottobiano','Ottobiano','','PV',1,'1840-01-01','2999-12-31'),
	(30281,'03','018',' 10','018107',18107,'Palestro','Palestro','','PV',1,'1840-01-01','2999-12-31'),
	(30282,'03','018',' 10','018108',18108,'Pancarana','Pancarana','','PV',1,'1840-01-01','2999-12-31'),
	(30283,'03','018',' 10','018109',18109,'Parona','Parona','','PV',1,'1840-01-01','2999-12-31'),
	(30284,'03','018',' 11','018110',18110,'Pavia','Pavia','','PV',1,'1840-01-01','2999-12-31'),
	(30285,'03','018',' 11','018111',18111,'Pietra de\' Giorgi','Pietra de\' Giorgi','','PV',1,'1840-01-01','2999-12-31'),
	(30286,'03','018',' 11','018112',18112,'Pieve Albignola','Pieve Albignola','','PV',1,'1840-01-01','2999-12-31'),
	(30287,'03','018',' 11','018113',18113,'Pieve del Cairo','Pieve del Cairo','','PV',1,'1840-01-01','2999-12-31'),
	(30288,'03','018',' 11','018114',18114,'Pieve Porto Morone','Pieve Porto Morone','','PV',1,'1840-01-01','2999-12-31'),
	(30289,'03','018',' 11','018115',18115,'Pinarolo Po','Pinarolo Po','','PV',1,'1840-01-01','2999-12-31'),
	(30290,'03','018',' 11','018116',18116,'Pizzale','Pizzale','','PV',1,'1840-01-01','2999-12-31'),
	(30291,'03','018',' 11','018117',18117,'Ponte Nizza','Ponte Nizza','','PV',1,'1840-01-01','2999-12-31'),
	(30292,'03','018',' 11','018118',18118,'Portalbera','Portalbera','','PV',1,'1840-01-01','2999-12-31'),
	(30293,'03','018',' 11','018119',18119,'Rea','Rea','','PV',1,'1840-01-01','2999-12-31'),
	(30294,'03','018',' 12','018120',18120,'Redavalle','Redavalle','','PV',1,'1840-01-01','2999-12-31'),
	(30295,'03','018',' 12','018121',18121,'Retorbido','Retorbido','','PV',1,'1840-01-01','2999-12-31'),
	(30296,'03','018',' 12','018122',18122,'Rivanazzano Terme','Rivanazzano Terme','','PV',1,'1840-01-01','2999-12-31'),
	(30297,'03','018',' 12','018123',18123,'Robbio','Robbio','','PV',1,'1840-01-01','2999-12-31'),
	(30298,'03','018',' 12','018124',18124,'Robecco Pavese','Robecco Pavese','','PV',1,'1840-01-01','2999-12-31'),
	(30299,'03','018',' 12','018125',18125,'Rocca de\' Giorgi','Rocca de\' Giorgi','','PV',1,'1840-01-01','2999-12-31'),
	(30300,'03','018',' 12','018126',18126,'Rocca Susella','Rocca Susella','','PV',1,'1840-01-01','2999-12-31'),
	(30301,'03','018',' 12','018127',18127,'Rognano','Rognano','','PV',1,'1840-01-01','2999-12-31'),
	(30302,'03','018',' 12','018128',18128,'Romagnese','Romagnese','','PV',1,'1840-01-01','2999-12-31');

INSERT INTO `COMUNI_ITALIANI` (`IDCOMUNE`, `CODICE_REGIONE`, `CODICE_PROVINCIA`, `CODICE_COMUNE`, `CODICE_ISTAT_A`, `CODICE_ISTAT_N`, `DENOMINAZIONE_IT_DE`, `DENOMINAZIONE_IT`, `DENOMINAZIONE_DE`, `SIGLA_PROVINCIA`, `STATUS`, `INIZIO_VALIDITA`, `FINE_VALIDITA`)
VALUES
	(30303,'03','018',' 12','018129',18129,'Roncaro','Roncaro','','PV',1,'1840-01-01','2999-12-31'),
	(30304,'03','018',' 13','018130',18130,'Rosasco','Rosasco','','PV',1,'1840-01-01','2999-12-31'),
	(30305,'03','018',' 13','018131',18131,'Rovescala','Rovescala','','PV',1,'1840-01-01','2999-12-31'),
	(30306,'03','018',' 13','018132',18132,'Ruino','Ruino','','PV',1,'1840-01-01','2999-12-31'),
	(30307,'03','018',' 13','018133',18133,'San Cipriano Po','San Cipriano Po','','PV',1,'1840-01-01','2999-12-31'),
	(30308,'03','018',' 13','018134',18134,'San Damiano al Colle','San Damiano al Colle','','PV',1,'1840-01-01','2999-12-31'),
	(30309,'03','018',' 13','018135',18135,'San Genesio ed Uniti','San Genesio ed Uniti','','PV',1,'1840-01-01','2999-12-31'),
	(30310,'03','018',' 13','018136',18136,'San Giorgio di Lomellina','San Giorgio di Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30311,'03','018',' 13','018137',18137,'San Martino Siccomario','San Martino Siccomario','','PV',1,'1840-01-01','2999-12-31'),
	(30312,'03','018',' 13','018138',18138,'Sannazzaro de\' Burgondi','Sannazzaro de\' Burgondi','','PV',1,'1840-01-01','2999-12-31'),
	(30313,'03','018',' 13','018139',18139,'Santa Cristina e Bissone','Santa Cristina e Bissone','','PV',1,'1840-01-01','2999-12-31'),
	(30314,'03','018',' 14','018140',18140,'Santa Giuletta','Santa Giuletta','','PV',1,'1840-01-01','2999-12-31'),
	(30315,'03','018',' 14','018141',18141,'Sant\'Alessio con Vialone','Sant\'Alessio con Vialone','','PV',1,'1840-01-01','2999-12-31'),
	(30316,'03','018',' 14','018142',18142,'Santa Margherita di Staffora','Santa Margherita di Staffora','','PV',1,'1840-01-01','2999-12-31'),
	(30317,'03','018',' 14','018143',18143,'Santa Maria della Versa','Santa Maria della Versa','','PV',1,'1840-01-01','2999-12-31'),
	(30318,'03','018',' 14','018144',18144,'Sant\'Angelo Lomellina','Sant\'Angelo Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30319,'03','018',' 14','018145',18145,'San Zenone al Po','San Zenone al Po','','PV',1,'1840-01-01','2999-12-31'),
	(30320,'03','018',' 14','018146',18146,'Sartirana Lomellina','Sartirana Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30321,'03','018',' 14','018147',18147,'Scaldasole','Scaldasole','','PV',1,'1840-01-01','2999-12-31'),
	(30322,'03','018',' 14','018148',18148,'Semiana','Semiana','','PV',1,'1840-01-01','2999-12-31'),
	(30323,'03','018',' 14','018149',18149,'Silvano Pietra','Silvano Pietra','','PV',1,'1840-01-01','2999-12-31'),
	(30324,'03','018',' 15','018150',18150,'Siziano','Siziano','','PV',1,'1840-01-01','2999-12-31'),
	(30325,'03','018',' 15','018151',18151,'Sommo','Sommo','','PV',1,'1840-01-01','2999-12-31'),
	(30326,'03','018',' 15','018152',18152,'Spessa','Spessa','','PV',1,'1840-01-01','2999-12-31'),
	(30327,'03','018',' 15','018153',18153,'Stradella','Stradella','','PV',1,'1840-01-01','2999-12-31'),
	(30328,'03','018',' 15','018154',18154,'Suardi','Suardi','','PV',1,'1840-01-01','2999-12-31'),
	(30329,'03','018',' 15','018155',18155,'Torrazza Coste','Torrazza Coste','','PV',1,'1840-01-01','2999-12-31'),
	(30330,'03','018',' 15','018156',18156,'Torre Beretti e Castellaro','Torre Beretti e Castellaro','','PV',1,'1840-01-01','2999-12-31'),
	(30331,'03','018',' 15','018157',18157,'Torre d\'Arese','Torre d\'Arese','','PV',1,'1840-01-01','2999-12-31'),
	(30332,'03','018',' 15','018158',18158,'Torre de\' Negri','Torre de\' Negri','','PV',1,'1840-01-01','2999-12-31'),
	(30333,'03','018',' 15','018159',18159,'Torre d\'Isola','Torre d\'Isola','','PV',1,'1840-01-01','2999-12-31'),
	(30334,'03','018',' 16','018160',18160,'Torrevecchia Pia','Torrevecchia Pia','','PV',1,'1840-01-01','2999-12-31'),
	(30335,'03','018',' 16','018161',18161,'Torricella Verzate','Torricella Verzate','','PV',1,'1840-01-01','2999-12-31'),
	(30336,'03','018',' 16','018162',18162,'Travacò Siccomario','Travacò Siccomario','','PV',1,'1840-01-01','2999-12-31'),
	(30337,'03','018',' 16','018163',18163,'Trivolzio','Trivolzio','','PV',1,'1840-01-01','2999-12-31'),
	(30338,'03','018',' 16','018164',18164,'Tromello','Tromello','','PV',1,'1840-01-01','2999-12-31'),
	(30339,'03','018',' 16','018165',18165,'Trovo','Trovo','','PV',1,'1840-01-01','2999-12-31'),
	(30340,'03','018',' 16','018166',18166,'Val di Nizza','Val di Nizza','','PV',1,'1840-01-01','2999-12-31'),
	(30341,'03','018',' 16','018167',18167,'Valeggio','Valeggio','','PV',1,'1840-01-01','2999-12-31'),
	(30342,'03','018',' 16','018168',18168,'Valle Lomellina','Valle Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30343,'03','018',' 16','018169',18169,'Valle Salimbene','Valle Salimbene','','PV',1,'1840-01-01','2999-12-31'),
	(30344,'03','018',' 17','018170',18170,'Valverde','Valverde','','PV',1,'1840-01-01','2999-12-31'),
	(30345,'03','018',' 17','018171',18171,'Varzi','Varzi','','PV',1,'1840-01-01','2999-12-31'),
	(30346,'03','018',' 17','018172',18172,'Velezzo Lomellina','Velezzo Lomellina','','PV',1,'1840-01-01','2999-12-31'),
	(30347,'03','018',' 17','018173',18173,'Vellezzo Bellini','Vellezzo Bellini','','PV',1,'1840-01-01','2999-12-31'),
	(30348,'03','018',' 17','018174',18174,'Verretto','Verretto','','PV',1,'1840-01-01','2999-12-31'),
	(30349,'03','018',' 17','018175',18175,'Verrua Po','Verrua Po','','PV',1,'1840-01-01','2999-12-31'),
	(30350,'03','018',' 17','018176',18176,'Vidigulfo','Vidigulfo','','PV',1,'1840-01-01','2999-12-31'),
	(30351,'03','018',' 17','018177',18177,'Vigevano','Vigevano','','PV',1,'1840-01-01','2999-12-31'),
	(30352,'03','018',' 17','018178',18178,'Villa Biscossi','Villa Biscossi','','PV',1,'1840-01-01','2999-12-31'),
	(30353,'03','018',' 17','018179',18179,'Villanova d\'Ardenghi','Villanova d\'Ardenghi','','PV',1,'1840-01-01','2999-12-31'),
	(30354,'03','018',' 18','018180',18180,'Villanterio','Villanterio','','PV',1,'1840-01-01','2999-12-31'),
	(30355,'03','018',' 18','018181',18181,'Vistarino','Vistarino','','PV',1,'1840-01-01','2999-12-31'),
	(30356,'03','018',' 18','018182',18182,'Voghera','Voghera','','PV',1,'1840-01-01','2999-12-31'),
	(30357,'03','018',' 18','018183',18183,'Volpara','Volpara','','PV',1,'1840-01-01','2999-12-31'),
	(30358,'03','018',' 18','018184',18184,'Zavattarello','Zavattarello','','PV',1,'1840-01-01','2999-12-31'),
	(30359,'03','018',' 18','018185',18185,'Zeccone','Zeccone','','PV',1,'1840-01-01','2999-12-31'),
	(30360,'03','018',' 18','018186',18186,'Zeme','Zeme','','PV',1,'1840-01-01','2999-12-31'),
	(30361,'03','018',' 18','018187',18187,'Zenevredo','Zenevredo','','PV',1,'1840-01-01','2999-12-31'),
	(30362,'03','018',' 18','018188',18188,'Zerbo','Zerbo','','PV',1,'1840-01-01','2999-12-31'),
	(30363,'03','018',' 18','018189',18189,'Zerbolò','Zerbolò','','PV',1,'1840-01-01','2999-12-31'),
	(30364,'03','018',' 19','018190',18190,'Zinasco','Zinasco','','PV',1,'1840-01-01','2999-12-31'),
	(30365,'03','019',' 00','019001',19001,'Acquanegra Cremonese','Acquanegra Cremonese','','CR',1,'1840-01-01','2999-12-31'),
	(30366,'03','019',' 00','019002',19002,'Agnadello','Agnadello','','CR',1,'1840-01-01','2999-12-31'),
	(30367,'03','019',' 00','019003',19003,'Annicco','Annicco','','CR',1,'1840-01-01','2999-12-31'),
	(30368,'03','019',' 00','019004',19004,'Azzanello','Azzanello','','CR',1,'1840-01-01','2999-12-31'),
	(30369,'03','019',' 00','019005',19005,'Bagnolo Cremasco','Bagnolo Cremasco','','CR',1,'1840-01-01','2999-12-31'),
	(30370,'03','019',' 00','019006',19006,'Bonemerse','Bonemerse','','CR',1,'1840-01-01','2999-12-31'),
	(30371,'03','019',' 00','019007',19007,'Bordolano','Bordolano','','CR',1,'1840-01-01','2999-12-31'),
	(30372,'03','019',' 00','019008',19008,'Ca\' d\'Andrea','Ca\' d\'Andrea','','CR',1,'1840-01-01','2999-12-31'),
	(30373,'03','019',' 00','019009',19009,'Calvatone','Calvatone','','CR',1,'1840-01-01','2999-12-31'),
	(30374,'03','019',' 01','019010',19010,'Camisano','Camisano','','CR',1,'1840-01-01','2999-12-31'),
	(30375,'03','019',' 01','019011',19011,'Campagnola Cremasca','Campagnola Cremasca','','CR',1,'1840-01-01','2999-12-31'),
	(30376,'03','019',' 01','019012',19012,'Capergnanica','Capergnanica','','CR',1,'1840-01-01','2999-12-31'),
	(30377,'03','019',' 01','019013',19013,'Cappella Cantone','Cappella Cantone','','CR',1,'1840-01-01','2999-12-31'),
	(30378,'03','019',' 01','019014',19014,'Cappella de\' Picenardi','Cappella de\' Picenardi','','CR',1,'1840-01-01','2999-12-31'),
	(30379,'03','019',' 01','019015',19015,'Capralba','Capralba','','CR',1,'1840-01-01','2999-12-31'),
	(30380,'03','019',' 01','019016',19016,'Casalbuttano ed Uniti','Casalbuttano ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30381,'03','019',' 01','019017',19017,'Casale Cremasco-Vidolasco','Casale Cremasco-Vidolasco','','CR',1,'1840-01-01','2999-12-31'),
	(30382,'03','019',' 01','019018',19018,'Casaletto Ceredano','Casaletto Ceredano','','CR',1,'1840-01-01','2999-12-31'),
	(30383,'03','019',' 01','019019',19019,'Casaletto di Sopra','Casaletto di Sopra','','CR',1,'1840-01-01','2999-12-31'),
	(30384,'03','019',' 02','019020',19020,'Casaletto Vaprio','Casaletto Vaprio','','CR',1,'1840-01-01','2999-12-31'),
	(30385,'03','019',' 02','019021',19021,'Casalmaggiore','Casalmaggiore','','CR',1,'1840-01-01','2999-12-31'),
	(30386,'03','019',' 02','019022',19022,'Casalmorano','Casalmorano','','CR',1,'1840-01-01','2999-12-31'),
	(30387,'03','019',' 02','019023',19023,'Casteldidone','Casteldidone','','CR',1,'1840-01-01','2999-12-31'),
	(30388,'03','019',' 02','019024',19024,'Castel Gabbiano','Castel Gabbiano','','CR',1,'1840-01-01','2999-12-31'),
	(30389,'03','019',' 02','019025',19025,'Castelleone','Castelleone','','CR',1,'1840-01-01','2999-12-31'),
	(30390,'03','019',' 02','019026',19026,'Castelverde','Castelverde','','CR',1,'1840-01-01','2999-12-31'),
	(30391,'03','019',' 02','019027',19027,'Castelvisconti','Castelvisconti','','CR',1,'1840-01-01','2999-12-31'),
	(30392,'03','019',' 02','019028',19028,'Cella Dati','Cella Dati','','CR',1,'1840-01-01','2999-12-31'),
	(30393,'03','019',' 02','019029',19029,'Chieve','Chieve','','CR',1,'1840-01-01','2999-12-31'),
	(30394,'03','019',' 03','019030',19030,'Cicognolo','Cicognolo','','CR',1,'1840-01-01','2999-12-31'),
	(30395,'03','019',' 03','019031',19031,'Cingia de\' Botti','Cingia de\' Botti','','CR',1,'1840-01-01','2999-12-31'),
	(30396,'03','019',' 03','019032',19032,'Corte de\' Cortesi con Cignone','Corte de\' Cortesi con Cignone','','CR',1,'1840-01-01','2999-12-31'),
	(30397,'03','019',' 03','019033',19033,'Corte de\' Frati','Corte de\' Frati','','CR',1,'1840-01-01','2999-12-31'),
	(30398,'03','019',' 03','019034',19034,'Credera Rubbiano','Credera Rubbiano','','CR',1,'1840-01-01','2999-12-31'),
	(30399,'03','019',' 03','019035',19035,'Crema','Crema','','CR',1,'1840-01-01','2999-12-31'),
	(30400,'03','019',' 03','019036',19036,'Cremona','Cremona','','CR',1,'1840-01-01','2999-12-31'),
	(30401,'03','019',' 03','019037',19037,'Cremosano','Cremosano','','CR',1,'1840-01-01','2999-12-31'),
	(30402,'03','019',' 03','019038',19038,'Crotta d\'Adda','Crotta d\'Adda','','CR',1,'1840-01-01','2999-12-31'),
	(30403,'03','019',' 03','019039',19039,'Cumignano sul Naviglio','Cumignano sul Naviglio','','CR',1,'1840-01-01','2999-12-31'),
	(30404,'03','019',' 04','019040',19040,'Derovere','Derovere','','CR',1,'1840-01-01','2999-12-31'),
	(30405,'03','019',' 04','019041',19041,'Dovera','Dovera','','CR',1,'1840-01-01','2999-12-31'),
	(30406,'03','019',' 04','019042',19042,'Drizzona','Drizzona','','CR',1,'1840-01-01','2999-12-31'),
	(30407,'03','019',' 04','019043',19043,'Fiesco','Fiesco','','CR',1,'1840-01-01','2999-12-31'),
	(30408,'03','019',' 04','019044',19044,'Formigara','Formigara','','CR',1,'1840-01-01','2999-12-31'),
	(30409,'03','019',' 04','019045',19045,'Gabbioneta-Binanuova','Gabbioneta-Binanuova','','CR',1,'1840-01-01','2999-12-31'),
	(30410,'03','019',' 04','019046',19046,'Gadesco-Pieve Delmona','Gadesco-Pieve Delmona','','CR',1,'1840-01-01','2999-12-31'),
	(30411,'03','019',' 04','019047',19047,'Genivolta','Genivolta','','CR',1,'1840-01-01','2999-12-31'),
	(30412,'03','019',' 04','019048',19048,'Gerre de\' Caprioli','Gerre de\' Caprioli','','CR',1,'1840-01-01','2999-12-31'),
	(30413,'03','019',' 04','019049',19049,'Gombito','Gombito','','CR',1,'1840-01-01','2999-12-31'),
	(30414,'03','019',' 05','019050',19050,'Grontardo','Grontardo','','CR',1,'1840-01-01','2999-12-31'),
	(30415,'03','019',' 05','019051',19051,'Grumello Cremonese ed Uniti','Grumello Cremonese ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30416,'03','019',' 05','019052',19052,'Gussola','Gussola','','CR',1,'1840-01-01','2999-12-31'),
	(30417,'03','019',' 05','019053',19053,'Isola Dovarese','Isola Dovarese','','CR',1,'1840-01-01','2999-12-31'),
	(30418,'03','019',' 05','019054',19054,'Izano','Izano','','CR',1,'1840-01-01','2999-12-31'),
	(30419,'03','019',' 05','019055',19055,'Madignano','Madignano','','CR',1,'1840-01-01','2999-12-31'),
	(30420,'03','019',' 05','019056',19056,'Malagnino','Malagnino','','CR',1,'1840-01-01','2999-12-31'),
	(30421,'03','019',' 05','019057',19057,'Martignana di Po','Martignana di Po','','CR',1,'1840-01-01','2999-12-31'),
	(30422,'03','019',' 05','019058',19058,'Monte Cremasco','Monte Cremasco','','CR',1,'1840-01-01','2999-12-31'),
	(30423,'03','019',' 05','019059',19059,'Montodine','Montodine','','CR',1,'1840-01-01','2999-12-31'),
	(30424,'03','019',' 06','019060',19060,'Moscazzano','Moscazzano','','CR',1,'1840-01-01','2999-12-31'),
	(30425,'03','019',' 06','019061',19061,'Motta Baluffi','Motta Baluffi','','CR',1,'1840-01-01','2999-12-31'),
	(30426,'03','019',' 06','019062',19062,'Offanengo','Offanengo','','CR',1,'1840-01-01','2999-12-31'),
	(30427,'03','019',' 06','019063',19063,'Olmeneta','Olmeneta','','CR',1,'1840-01-01','2999-12-31'),
	(30428,'03','019',' 06','019064',19064,'Ostiano','Ostiano','','CR',1,'1840-01-01','2999-12-31'),
	(30429,'03','019',' 06','019065',19065,'Paderno Ponchielli','Paderno Ponchielli','','CR',1,'1840-01-01','2999-12-31'),
	(30430,'03','019',' 06','019066',19066,'Palazzo Pignano','Palazzo Pignano','','CR',1,'1840-01-01','2999-12-31'),
	(30431,'03','019',' 06','019067',19067,'Pandino','Pandino','','CR',1,'1840-01-01','2999-12-31'),
	(30432,'03','019',' 06','019068',19068,'Persico Dosimo','Persico Dosimo','','CR',1,'1840-01-01','2999-12-31'),
	(30433,'03','019',' 06','019069',19069,'Pescarolo ed Uniti','Pescarolo ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30434,'03','019',' 07','019070',19070,'Pessina Cremonese','Pessina Cremonese','','CR',1,'1840-01-01','2999-12-31'),
	(30435,'03','019',' 07','019071',19071,'Piadena','Piadena','','CR',1,'1840-01-01','2999-12-31'),
	(30436,'03','019',' 07','019072',19072,'Pianengo','Pianengo','','CR',1,'1840-01-01','2999-12-31'),
	(30437,'03','019',' 07','019073',19073,'Pieranica','Pieranica','','CR',1,'1840-01-01','2999-12-31'),
	(30438,'03','019',' 07','019074',19074,'Pieve d\'Olmi','Pieve d\'Olmi','','CR',1,'1840-01-01','2999-12-31'),
	(30439,'03','019',' 07','019075',19075,'Pieve San Giacomo','Pieve San Giacomo','','CR',1,'1840-01-01','2999-12-31'),
	(30440,'03','019',' 07','019076',19076,'Pizzighettone','Pizzighettone','','CR',1,'1840-01-01','2999-12-31'),
	(30441,'03','019',' 07','019077',19077,'Pozzaglio ed Uniti','Pozzaglio ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30442,'03','019',' 07','019078',19078,'Quintano','Quintano','','CR',1,'1840-01-01','2999-12-31'),
	(30443,'03','019',' 07','019079',19079,'Ricengo','Ricengo','','CR',1,'1840-01-01','2999-12-31'),
	(30444,'03','019',' 08','019080',19080,'Ripalta Arpina','Ripalta Arpina','','CR',1,'1840-01-01','2999-12-31'),
	(30445,'03','019',' 08','019081',19081,'Ripalta Cremasca','Ripalta Cremasca','','CR',1,'1840-01-01','2999-12-31'),
	(30446,'03','019',' 08','019082',19082,'Ripalta Guerina','Ripalta Guerina','','CR',1,'1840-01-01','2999-12-31'),
	(30447,'03','019',' 08','019083',19083,'Rivarolo del Re ed Uniti','Rivarolo del Re ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30448,'03','019',' 08','019084',19084,'Rivolta d\'Adda','Rivolta d\'Adda','','CR',1,'1840-01-01','2999-12-31'),
	(30449,'03','019',' 08','019085',19085,'Robecco d\'Oglio','Robecco d\'Oglio','','CR',1,'1840-01-01','2999-12-31'),
	(30450,'03','019',' 08','019086',19086,'Romanengo','Romanengo','','CR',1,'1840-01-01','2999-12-31'),
	(30451,'03','019',' 08','019087',19087,'Salvirola','Salvirola','','CR',1,'1840-01-01','2999-12-31'),
	(30452,'03','019',' 08','019088',19088,'San Bassano','San Bassano','','CR',1,'1840-01-01','2999-12-31'),
	(30453,'03','019',' 08','019089',19089,'San Daniele Po','San Daniele Po','','CR',1,'1840-01-01','2999-12-31'),
	(30454,'03','019',' 09','019090',19090,'San Giovanni in Croce','San Giovanni in Croce','','CR',1,'1840-01-01','2999-12-31'),
	(30455,'03','019',' 09','019091',19091,'San Martino del Lago','San Martino del Lago','','CR',1,'1840-01-01','2999-12-31'),
	(30456,'03','019',' 09','019092',19092,'Scandolara Ravara','Scandolara Ravara','','CR',1,'1840-01-01','2999-12-31'),
	(30457,'03','019',' 09','019093',19093,'Scandolara Ripa d\'Oglio','Scandolara Ripa d\'Oglio','','CR',1,'1840-01-01','2999-12-31'),
	(30458,'03','019',' 09','019094',19094,'Sergnano','Sergnano','','CR',1,'1840-01-01','2999-12-31'),
	(30459,'03','019',' 09','019095',19095,'Sesto ed Uniti','Sesto ed Uniti','','CR',1,'1840-01-01','2999-12-31'),
	(30460,'03','019',' 09','019096',19096,'Solarolo Rainerio','Solarolo Rainerio','','CR',1,'1840-01-01','2999-12-31'),
	(30461,'03','019',' 09','019097',19097,'Soncino','Soncino','','CR',1,'1840-01-01','2999-12-31'),
	(30462,'03','019',' 09','019098',19098,'Soresina','Soresina','','CR',1,'1840-01-01','2999-12-31'),
	(30463,'03','019',' 09','019099',19099,'Sospiro','Sospiro','','CR',1,'1840-01-01','2999-12-31'),
	(30464,'03','019',' 10','019100',19100,'Spinadesco','Spinadesco','','CR',1,'1840-01-01','2999-12-31'),
	(30465,'03','019',' 10','019101',19101,'Spineda','Spineda','','CR',1,'1840-01-01','2999-12-31'),
	(30466,'03','019',' 10','019102',19102,'Spino d\'Adda','Spino d\'Adda','','CR',1,'1840-01-01','2999-12-31'),
	(30467,'03','019',' 10','019103',19103,'Stagno Lombardo','Stagno Lombardo','','CR',1,'1840-01-01','2999-12-31'),
	(30468,'03','019',' 10','019104',19104,'Ticengo','Ticengo','','CR',1,'1840-01-01','2999-12-31'),
	(30469,'03','019',' 10','019105',19105,'Torlino Vimercati','Torlino Vimercati','','CR',1,'1840-01-01','2999-12-31'),
	(30470,'03','019',' 10','019106',19106,'Tornata','Tornata','','CR',1,'1840-01-01','2999-12-31'),
	(30471,'03','019',' 10','019107',19107,'Torre de\' Picenardi','Torre de\' Picenardi','','CR',1,'1840-01-01','2999-12-31'),
	(30472,'03','019',' 10','019108',19108,'Torricella del Pizzo','Torricella del Pizzo','','CR',1,'1840-01-01','2999-12-31'),
	(30473,'03','019',' 10','019109',19109,'Trescore Cremasco','Trescore Cremasco','','CR',1,'1840-01-01','2999-12-31'),
	(30474,'03','019',' 11','019110',19110,'Trigolo','Trigolo','','CR',1,'1840-01-01','2999-12-31'),
	(30475,'03','019',' 11','019111',19111,'Vaiano Cremasco','Vaiano Cremasco','','CR',1,'1840-01-01','2999-12-31'),
	(30476,'03','019',' 11','019112',19112,'Vailate','Vailate','','CR',1,'1840-01-01','2999-12-31'),
	(30477,'03','019',' 11','019113',19113,'Vescovato','Vescovato','','CR',1,'1840-01-01','2999-12-31'),
	(30478,'03','019',' 11','019114',19114,'Volongo','Volongo','','CR',1,'1840-01-01','2999-12-31'),
	(30479,'03','019',' 11','019115',19115,'Voltido','Voltido','','CR',1,'1840-01-01','2999-12-31'),
	(30480,'03','020',' 00','020001',20001,'Acquanegra sul Chiese','Acquanegra sul Chiese','','MN',1,'1840-01-01','2999-12-31'),
	(30481,'03','020',' 00','020002',20002,'Asola','Asola','','MN',1,'1840-01-01','2999-12-31'),
	(30482,'03','020',' 00','020003',20003,'Bagnolo San Vito','Bagnolo San Vito','','MN',1,'1840-01-01','2999-12-31'),
	(30483,'03','020',' 00','020004',20004,'Bigarello','Bigarello','','MN',1,'1840-01-01','2999-12-31'),
	(30484,'03','020',' 00','020005',20005,'Borgoforte','Borgoforte','','MN',1,'1840-01-01','2999-12-31'),
	(30485,'03','020',' 00','020006',20006,'Borgofranco sul Po','Borgofranco sul Po','','MN',1,'1840-01-01','2999-12-31'),
	(30486,'03','020',' 00','020007',20007,'Bozzolo','Bozzolo','','MN',1,'1840-01-01','2999-12-31'),
	(30487,'03','020',' 00','020008',20008,'Canneto sull\'Oglio','Canneto sull\'Oglio','','MN',1,'1840-01-01','2999-12-31'),
	(30488,'03','020',' 00','020009',20009,'Carbonara di Po','Carbonara di Po','','MN',1,'1840-01-01','2999-12-31'),
	(30489,'03','020',' 01','020010',20010,'Casalmoro','Casalmoro','','MN',1,'1840-01-01','2999-12-31'),
	(30490,'03','020',' 01','020011',20011,'Casaloldo','Casaloldo','','MN',1,'1840-01-01','2999-12-31'),
	(30491,'03','020',' 01','020012',20012,'Casalromano','Casalromano','','MN',1,'1840-01-01','2999-12-31'),
	(30492,'03','020',' 01','020013',20013,'Castelbelforte','Castelbelforte','','MN',1,'1840-01-01','2999-12-31'),
	(30493,'03','020',' 01','020014',20014,'Castel d\'Ario','Castel d\'Ario','','MN',1,'1840-01-01','2999-12-31'),
	(30494,'03','020',' 01','020015',20015,'Castel Goffredo','Castel Goffredo','','MN',1,'1840-01-01','2999-12-31'),
	(30495,'03','020',' 01','020016',20016,'Castellucchio','Castellucchio','','MN',1,'1840-01-01','2999-12-31'),
	(30496,'03','020',' 01','020017',20017,'Castiglione delle Stiviere','Castiglione delle Stiviere','','MN',1,'1840-01-01','2999-12-31'),
	(30497,'03','020',' 01','020018',20018,'Cavriana','Cavriana','','MN',1,'1840-01-01','2999-12-31'),
	(30498,'03','020',' 01','020019',20019,'Ceresara','Ceresara','','MN',1,'1840-01-01','2999-12-31'),
	(30499,'03','020',' 02','020020',20020,'Commessaggio','Commessaggio','','MN',1,'1840-01-01','2999-12-31'),
	(30500,'03','020',' 02','020021',20021,'Curtatone','Curtatone','','MN',1,'1840-01-01','2999-12-31'),
	(30501,'03','020',' 02','020022',20022,'Dosolo','Dosolo','','MN',1,'1840-01-01','2999-12-31'),
	(30502,'03','020',' 02','020023',20023,'Felonica','Felonica','','MN',1,'1840-01-01','2999-12-31'),
	(30503,'03','020',' 02','020024',20024,'Gazoldo degli Ippoliti','Gazoldo degli Ippoliti','','MN',1,'1840-01-01','2999-12-31'),
	(30504,'03','020',' 02','020025',20025,'Gazzuolo','Gazzuolo','','MN',1,'1840-01-01','2999-12-31'),
	(30505,'03','020',' 02','020026',20026,'Goito','Goito','','MN',1,'1840-01-01','2999-12-31'),
	(30506,'03','020',' 02','020027',20027,'Gonzaga','Gonzaga','','MN',1,'1840-01-01','2999-12-31'),
	(30507,'03','020',' 02','020028',20028,'Guidizzolo','Guidizzolo','','MN',1,'1840-01-01','2999-12-31'),
	(30508,'03','020',' 02','020029',20029,'Magnacavallo','Magnacavallo','','MN',1,'1840-01-01','2999-12-31'),
	(30509,'03','020',' 03','020030',20030,'Mantova','Mantova','','MN',1,'1840-01-01','2999-12-31'),
	(30510,'03','020',' 03','020031',20031,'Marcaria','Marcaria','','MN',1,'1840-01-01','2999-12-31'),
	(30511,'03','020',' 03','020032',20032,'Mariana Mantovana','Mariana Mantovana','','MN',1,'1840-01-01','2999-12-31'),
	(30512,'03','020',' 03','020033',20033,'Marmirolo','Marmirolo','','MN',1,'1840-01-01','2999-12-31'),
	(30513,'03','020',' 03','020034',20034,'Medole','Medole','','MN',1,'1840-01-01','2999-12-31'),
	(30514,'03','020',' 03','020035',20035,'Moglia','Moglia','','MN',1,'1840-01-01','2999-12-31'),
	(30515,'03','020',' 03','020036',20036,'Monzambano','Monzambano','','MN',1,'1840-01-01','2999-12-31'),
	(30516,'03','020',' 03','020037',20037,'Motteggiana','Motteggiana','','MN',1,'1840-01-01','2999-12-31'),
	(30517,'03','020',' 03','020038',20038,'Ostiglia','Ostiglia','','MN',1,'1840-01-01','2999-12-31'),
	(30518,'03','020',' 03','020039',20039,'Pegognaga','Pegognaga','','MN',1,'1840-01-01','2999-12-31'),
	(30519,'03','020',' 04','020040',20040,'Pieve di Coriano','Pieve di Coriano','','MN',1,'1840-01-01','2999-12-31'),
	(30520,'03','020',' 04','020041',20041,'Piubega','Piubega','','MN',1,'1840-01-01','2999-12-31'),
	(30521,'03','020',' 04','020042',20042,'Poggio Rusco','Poggio Rusco','','MN',1,'1840-01-01','2999-12-31'),
	(30522,'03','020',' 04','020043',20043,'Pomponesco','Pomponesco','','MN',1,'1840-01-01','2999-12-31'),
	(30523,'03','020',' 04','020044',20044,'Ponti sul Mincio','Ponti sul Mincio','','MN',1,'1840-01-01','2999-12-31'),
	(30524,'03','020',' 04','020045',20045,'Porto Mantovano','Porto Mantovano','','MN',1,'1840-01-01','2999-12-31'),
	(30525,'03','020',' 04','020046',20046,'Quingentole','Quingentole','','MN',1,'1840-01-01','2999-12-31'),
	(30526,'03','020',' 04','020047',20047,'Quistello','Quistello','','MN',1,'1840-01-01','2999-12-31'),
	(30527,'03','020',' 04','020048',20048,'Redondesco','Redondesco','','MN',1,'1840-01-01','2999-12-31'),
	(30528,'03','020',' 04','020049',20049,'Revere','Revere','','MN',1,'1840-01-01','2999-12-31'),
	(30529,'03','020',' 05','020050',20050,'Rivarolo Mantovano','Rivarolo Mantovano','','MN',1,'1840-01-01','2999-12-31'),
	(30530,'03','020',' 05','020051',20051,'Rodigo','Rodigo','','MN',1,'1840-01-01','2999-12-31'),
	(30531,'03','020',' 05','020052',20052,'Roncoferraro','Roncoferraro','','MN',1,'1840-01-01','2999-12-31'),
	(30532,'03','020',' 05','020053',20053,'Roverbella','Roverbella','','MN',1,'1840-01-01','2999-12-31'),
	(30533,'03','020',' 05','020054',20054,'Sabbioneta','Sabbioneta','','MN',1,'1840-01-01','2999-12-31'),
	(30534,'03','020',' 05','020055',20055,'San Benedetto Po','San Benedetto Po','','MN',1,'1840-01-01','2999-12-31'),
	(30535,'03','020',' 05','020056',20056,'San Giacomo delle Segnate','San Giacomo delle Segnate','','MN',1,'1840-01-01','2999-12-31'),
	(30536,'03','020',' 05','020057',20057,'San Giorgio di Mantova','San Giorgio di Mantova','','MN',1,'1840-01-01','2999-12-31'),
	(30537,'03','020',' 05','020058',20058,'San Giovanni del Dosso','San Giovanni del Dosso','','MN',1,'1840-01-01','2999-12-31'),
	(30538,'03','020',' 05','020059',20059,'San Martino dall\'Argine','San Martino dall\'Argine','','MN',1,'1840-01-01','2999-12-31'),
	(30539,'03','020',' 06','020060',20060,'Schivenoglia','Schivenoglia','','MN',1,'1840-01-01','2999-12-31'),
	(30540,'03','020',' 06','020061',20061,'Sermide','Sermide','','MN',1,'1840-01-01','2999-12-31'),
	(30541,'03','020',' 06','020062',20062,'Serravalle a Po','Serravalle a Po','','MN',1,'1840-01-01','2999-12-31'),
	(30542,'03','020',' 06','020063',20063,'Solferino','Solferino','','MN',1,'1840-01-01','2999-12-31'),
	(30543,'03','020',' 06','020064',20064,'Sustinente','Sustinente','','MN',1,'1840-01-01','2999-12-31'),
	(30544,'03','020',' 06','020065',20065,'Suzzara','Suzzara','','MN',1,'1840-01-01','2999-12-31'),
	(30545,'03','020',' 06','020066',20066,'Viadana','Viadana','','MN',1,'1840-01-01','2999-12-31'),
	(30546,'03','020',' 06','020067',20067,'Villa Poma','Villa Poma','','MN',1,'1840-01-01','2999-12-31'),
	(30547,'03','020',' 06','020068',20068,'Villimpenta','Villimpenta','','MN',1,'1840-01-01','2999-12-31'),
	(30548,'03','020',' 06','020069',20069,'Virgilio','Virgilio','','MN',1,'1840-01-01','2999-12-31'),
	(30549,'03','020',' 07','020070',20070,'Volta Mantovana','Volta Mantovana','','MN',1,'1840-01-01','2999-12-31'),
	(30550,'04','021',' 00','021001',21001,'Aldino/Aldein','Aldino/Aldein','Aldein','BZ',1,'1840-01-01','2999-12-31'),
	(30551,'04','021',' 00','021002',21002,'Andriano/Andrian','Andriano/Andrian','Andrian','BZ',1,'1840-01-01','2999-12-31'),
	(30552,'04','021',' 00','021003',21003,'Anterivo/Altrei','Anterivo/Altrei','Altrei','BZ',1,'1840-01-01','2999-12-31'),
	(30553,'04','021',' 00','021004',21004,'Appiano sulla strada del vino/Eppan an der Weinstrasse','Appiano sulla strada del vino/Eppan an der Weinstrasse','Eppan an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30554,'04','021',' 00','021005',21005,'Avelengo/Hafling','Avelengo/Hafling','Hafling','BZ',1,'1840-01-01','2999-12-31'),
	(30555,'04','021',' 00','021006',21006,'Badia/Abtei','Badia/Abtei','Abtei','BZ',1,'1840-01-01','2999-12-31'),
	(30556,'04','021',' 00','021007',21007,'Barbiano/Barbian','Barbiano/Barbian','Barbian','BZ',1,'1840-01-01','2999-12-31'),
	(30557,'04','021',' 00','021008',21008,'Bolzano/Bozen','Bolzano/Bozen','Bozen','BZ',1,'1840-01-01','2999-12-31'),
	(30558,'04','021',' 00','021009',21009,'Braies/Prags','Braies/Prags','Prags','BZ',1,'1840-01-01','2999-12-31'),
	(30559,'04','021',' 01','021010',21010,'Brennero/Brenner','Brennero/Brenner','Brenner','BZ',1,'1840-01-01','2999-12-31'),
	(30560,'04','021',' 01','021011',21011,'Bressanone/Brixen','Bressanone/Brixen','Brixen','BZ',1,'1840-01-01','2999-12-31'),
	(30561,'04','021',' 01','021012',21012,'Bronzolo/Branzoll','Bronzolo/Branzoll','Branzoll','BZ',1,'1840-01-01','2999-12-31'),
	(30562,'04','021',' 01','021013',21013,'Brunico/Bruneck','Brunico/Bruneck','Bruneck','BZ',1,'1840-01-01','2999-12-31'),
	(30563,'04','021',' 01','021014',21014,'Caines/Kuens','Caines/Kuens','Kuens','BZ',1,'1840-01-01','2999-12-31'),
	(30564,'04','021',' 01','021015',21015,'Caldaro sulla strada del vino/Kaltern an der Weinstrasse','Caldaro sulla strada del vino/Kaltern an der Weinstrasse','Kaltern an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30565,'04','021',' 01','021016',21016,'Campo di Trens/Freienfeld','Campo di Trens/Freienfeld','Freienfeld','BZ',1,'1840-01-01','2999-12-31'),
	(30566,'04','021',' 01','021017',21017,'Campo Tures/Sand in Taufers','Campo Tures/Sand in Taufers','Sand in Taufers','BZ',1,'1840-01-01','2999-12-31'),
	(30567,'04','021',' 01','021018',21018,'Castelbello-Ciardes/Kastelbell-Tschars','Castelbello-Ciardes/Kastelbell-Tschars','Kastelbell-Tschars','BZ',1,'1840-01-01','2999-12-31'),
	(30568,'04','021',' 01','021019',21019,'Castelrotto/Kastelruth','Castelrotto/Kastelruth','Kastelruth','BZ',1,'1840-01-01','2999-12-31'),
	(30569,'04','021',' 02','021020',21020,'Cermes/Tscherms','Cermes/Tscherms','Tscherms','BZ',1,'1840-01-01','2999-12-31'),
	(30570,'04','021',' 02','021021',21021,'Chienes/Kiens','Chienes/Kiens','Kiens','BZ',1,'1840-01-01','2999-12-31'),
	(30571,'04','021',' 02','021022',21022,'Chiusa/Klausen','Chiusa/Klausen','Klausen','BZ',1,'1840-01-01','2999-12-31'),
	(30572,'04','021',' 02','021023',21023,'Cornedo all\'Isarco/Karneid','Cornedo all\'Isarco/Karneid','Karneid','BZ',1,'1840-01-01','2999-12-31'),
	(30573,'04','021',' 02','021024',21024,'Cortaccia sulla strada del vino/Kurtatsch an der Weinstrasse','Cortaccia sulla strada del vino/Kurtatsch an der Weinstrasse','Kurtatsch an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30574,'04','021',' 02','021025',21025,'Cortina sulla strada del vino/Kurtinig an der Weinstrasse','Cortina sulla strada del vino/Kurtinig an der Weinstrasse','Kurtinig an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30575,'04','021',' 02','021026',21026,'Corvara in Badia/Corvara','Corvara in Badia/Corvara','Corvara','BZ',1,'1840-01-01','2999-12-31'),
	(30576,'04','021',' 02','021027',21027,'Curon Venosta/Graun im Vinschgau','Curon Venosta/Graun im Vinschgau','Graun im Vinschgau','BZ',1,'1840-01-01','2999-12-31'),
	(30577,'04','021',' 02','021028',21028,'Dobbiaco/Toblach','Dobbiaco/Toblach','Toblach','BZ',1,'1840-01-01','2999-12-31'),
	(30578,'04','021',' 02','021029',21029,'Egna/Neumarkt','Egna/Neumarkt','Neumarkt','BZ',1,'1840-01-01','2999-12-31'),
	(30579,'04','021',' 03','021030',21030,'Falzes/Pfalzen','Falzes/Pfalzen','Pfalzen','BZ',1,'1840-01-01','2999-12-31'),
	(30580,'04','021',' 03','021031',21031,'Fiè allo Sciliar/Völs am Schlern','Fiè allo Sciliar/Völs am Schlern','Völs am Schlern','BZ',1,'1840-01-01','2999-12-31'),
	(30581,'04','021',' 03','021032',21032,'Fortezza/Franzensfeste','Fortezza/Franzensfeste','Franzensfeste','BZ',1,'1840-01-01','2999-12-31'),
	(30582,'04','021',' 03','021033',21033,'Funes/Villnoess','Funes/Villnoess','Villnöß','BZ',1,'1840-01-01','2999-12-31'),
	(30583,'04','021',' 03','021034',21034,'Gais/Gais','Gais/Gais','Gais','BZ',1,'1840-01-01','2999-12-31'),
	(30584,'04','021',' 03','021035',21035,'Gargazzone/Gargazon','Gargazzone/Gargazon','Gargazon','BZ',1,'1840-01-01','2999-12-31'),
	(30585,'04','021',' 03','021036',21036,'Glorenza/Glurns','Glorenza/Glurns','Glurns','BZ',1,'1840-01-01','2999-12-31'),
	(30586,'04','021',' 03','021037',21037,'Laces/Latsch','Laces/Latsch','Latsch','BZ',1,'1840-01-01','2999-12-31'),
	(30587,'04','021',' 03','021038',21038,'Lagundo/Algund','Lagundo/Algund','Algund','BZ',1,'1840-01-01','2999-12-31'),
	(30588,'04','021',' 03','021039',21039,'Laion/Lajen','Laion/Lajen','Lajen','BZ',1,'1840-01-01','2999-12-31'),
	(30589,'04','021',' 04','021040',21040,'Laives/Leifers','Laives/Leifers','Leifers','BZ',1,'1840-01-01','2999-12-31'),
	(30590,'04','021',' 04','021041',21041,'Lana/Lana','Lana/Lana','Lana','BZ',1,'1840-01-01','2999-12-31'),
	(30591,'04','021',' 04','021042',21042,'Lasa/Laas','Lasa/Laas','Laas','BZ',1,'1840-01-01','2999-12-31'),
	(30592,'04','021',' 04','021043',21043,'Lauregno/Laurein','Lauregno/Laurein','Laurein','BZ',1,'1840-01-01','2999-12-31'),
	(30593,'04','021',' 04','021044',21044,'Luson/Luesen','Luson/Luesen','Lüsen','BZ',1,'1840-01-01','2999-12-31'),
	(30594,'04','021',' 04','021045',21045,'Magrè sulla strada del vino/Margreid an der Weinstrasse','Magrè sulla strada del vino/Margreid an der Weinstrasse','Margreid an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30595,'04','021',' 04','021046',21046,'Malles Venosta/Mals','Malles Venosta/Mals','Mals','BZ',1,'1840-01-01','2999-12-31'),
	(30596,'04','021',' 04','021047',21047,'Marebbe/Enneberg','Marebbe/Enneberg','Enneberg','BZ',1,'1840-01-01','2999-12-31'),
	(30597,'04','021',' 04','021048',21048,'Marlengo/Marling','Marlengo/Marling','Marling','BZ',1,'1840-01-01','2999-12-31'),
	(30598,'04','021',' 04','021049',21049,'Martello/Martell','Martello/Martell','Martell','BZ',1,'1840-01-01','2999-12-31'),
	(30599,'04','021',' 05','021050',21050,'Meltina/Moelten','Meltina/Moelten','Mölten','BZ',1,'1840-01-01','2999-12-31'),
	(30600,'04','021',' 05','021051',21051,'Merano/Meran','Merano/Meran','Meran','BZ',1,'1840-01-01','2999-12-31'),
	(30601,'04','021',' 05','021052',21052,'Monguelfo-Tesido/Welsberg-Taisten','Monguelfo-Tesido/Welsberg-Taisten','Welsberg-Taisten','BZ',1,'1840-01-01','2999-12-31'),
	(30602,'04','021',' 05','021053',21053,'Montagna/Montan','Montagna/Montan','Montan','BZ',1,'1840-01-01','2999-12-31'),
	(30603,'04','021',' 05','021054',21054,'Moso in Passiria/Moos in Passeier','Moso in Passiria/Moos in Passeier','Moos in Passeier','BZ',1,'1840-01-01','2999-12-31'),
	(30604,'04','021',' 05','021055',21055,'Nalles/Nals','Nalles/Nals','Nals','BZ',1,'1840-01-01','2999-12-31'),
	(30605,'04','021',' 05','021056',21056,'Naturno/Naturns','Naturno/Naturns','Naturns','BZ',1,'1840-01-01','2999-12-31'),
	(30606,'04','021',' 05','021057',21057,'Naz-Sciaves/Natz-Schabs','Naz-Sciaves/Natz-Schabs','Natz-Schabs','BZ',1,'1840-01-01','2999-12-31'),
	(30607,'04','021',' 05','021058',21058,'Nova Levante/Welschnofen','Nova Levante/Welschnofen','Welschnofen','BZ',1,'1840-01-01','2999-12-31'),
	(30608,'04','021',' 05','021059',21059,'Nova Ponente/Deutschnofen','Nova Ponente/Deutschnofen','Deutschnofen','BZ',1,'1840-01-01','2999-12-31'),
	(30609,'04','021',' 06','021060',21060,'Ora/Auer','Ora/Auer','Auer','BZ',1,'1840-01-01','2999-12-31'),
	(30610,'04','021',' 06','021061',21061,'Ortisei/St. Ulrich','Ortisei/St. Ulrich','St. Ulrich','BZ',1,'1840-01-01','2999-12-31'),
	(30611,'04','021',' 06','021062',21062,'Parcines/Partschins','Parcines/Partschins','Partschins','BZ',1,'1840-01-01','2999-12-31'),
	(30612,'04','021',' 06','021063',21063,'Perca/Percha','Perca/Percha','Percha','BZ',1,'1840-01-01','2999-12-31'),
	(30613,'04','021',' 06','021064',21064,'Plaus/Plaus','Plaus/Plaus','Plaus','BZ',1,'1840-01-01','2999-12-31'),
	(30614,'04','021',' 06','021065',21065,'Ponte Gardena/Waidbruck','Ponte Gardena/Waidbruck','Waidbruck','BZ',1,'1840-01-01','2999-12-31'),
	(30615,'04','021',' 06','021066',21066,'Postal/Burgstall','Postal/Burgstall','Burgstall','BZ',1,'1840-01-01','2999-12-31'),
	(30616,'04','021',' 06','021067',21067,'Prato allo Stelvio/Prad am Stilfser Joch','Prato allo Stelvio/Prad am Stilfser Joch','Prad am Stilfser Joch','BZ',1,'1840-01-01','2999-12-31'),
	(30617,'04','021',' 06','021068',21068,'Predoi/Prettau','Predoi/Prettau','Prettau','BZ',1,'1840-01-01','2999-12-31'),
	(30618,'04','021',' 06','021069',21069,'Proves/Proveis','Proves/Proveis','Proveis','BZ',1,'1840-01-01','2999-12-31'),
	(30619,'04','021',' 07','021070',21070,'Racines/Ratschings','Racines/Ratschings','Ratschings','BZ',1,'1840-01-01','2999-12-31'),
	(30620,'04','021',' 07','021071',21071,'Rasun Anterselva/Rasen-Antholz','Rasun Anterselva/Rasen-Antholz','Rasen-Antholz','BZ',1,'1840-01-01','2999-12-31'),
	(30621,'04','021',' 07','021072',21072,'Renon/Ritten','Renon/Ritten','Ritten','BZ',1,'1840-01-01','2999-12-31'),
	(30622,'04','021',' 07','021073',21073,'Rifiano/Riffian','Rifiano/Riffian','Riffian','BZ',1,'1840-01-01','2999-12-31'),
	(30623,'04','021',' 07','021074',21074,'Rio di Pusteria/Muehlbach','Rio di Pusteria/Muehlbach','Mühlbach','BZ',1,'1840-01-01','2999-12-31'),
	(30624,'04','021',' 07','021075',21075,'Rodengo/Rodeneck','Rodengo/Rodeneck','Rodeneck','BZ',1,'1840-01-01','2999-12-31'),
	(30625,'04','021',' 07','021076',21076,'Salorno/Salurn','Salorno/Salurn','Salurn','BZ',1,'1840-01-01','2999-12-31'),
	(30626,'04','021',' 07','021077',21077,'San Candido/Innichen','San Candido/Innichen','Innichen','BZ',1,'1840-01-01','2999-12-31'),
	(30627,'04','021',' 07','021079',21079,'San Genesio Atesino/Jenesien','San Genesio Atesino/Jenesien','Jenesien','BZ',1,'1840-01-01','2999-12-31'),
	(30628,'04','021',' 08','021080',21080,'San Leonardo in Passiria/St. Leonhard in Passeier','San Leonardo in Passiria/St. Leonhard in Passeier','St. Leonhard in Passeier','BZ',1,'1840-01-01','2999-12-31'),
	(30629,'04','021',' 08','021081',21081,'San Lorenzo di Sebato/St. Lorenzen','San Lorenzo di Sebato/St. Lorenzen','St. Lorenzen','BZ',1,'1840-01-01','2999-12-31'),
	(30630,'04','021',' 08','021082',21082,'San Martino in Badia/St. Martin in Thurn','San Martino in Badia/St. Martin in Thurn','St. Martin in Thurn','BZ',1,'1840-01-01','2999-12-31'),
	(30631,'04','021',' 08','021083',21083,'San Martino in Passiria/St. Martin in Passeier','San Martino in Passiria/St. Martin in Passeier','St. Martin in Passeier','BZ',1,'1840-01-01','2999-12-31'),
	(30632,'04','021',' 08','021084',21084,'San Pancrazio/St. Pankraz','San Pancrazio/St. Pankraz','St. Pankraz','BZ',1,'1840-01-01','2999-12-31'),
	(30633,'04','021',' 08','021085',21085,'Santa Cristina Valgardena/St. Christina in Groeden','Santa Cristina Valgardena/St. Christina in Groeden','St. Christina in Gröden','BZ',1,'1840-01-01','2999-12-31'),
	(30634,'04','021',' 08','021086',21086,'Sarentino/Sarntal','Sarentino/Sarntal','Sarntal','BZ',1,'1840-01-01','2999-12-31'),
	(30635,'04','021',' 08','021087',21087,'Scena/Schenna','Scena/Schenna','Schenna','BZ',1,'1840-01-01','2999-12-31'),
	(30636,'04','021',' 08','021088',21088,'Selva dei Molini/Muehlwald','Selva dei Molini/Muehlwald','Mühlwald','BZ',1,'1840-01-01','2999-12-31'),
	(30637,'04','021',' 08','021089',21089,'Selva di Val Gardena/Wolkenstein in Groeden','Selva di Val Gardena/Wolkenstein in Groeden','Wolkenstein in Gröden','BZ',1,'1840-01-01','2999-12-31'),
	(30638,'04','021',' 09','021091',21091,'Senales/Schnals','Senales/Schnals','Schnals','BZ',1,'1840-01-01','2999-12-31'),
	(30639,'04','021',' 09','021092',21092,'Sesto/Sexten','Sesto/Sexten','Sexten','BZ',1,'1840-01-01','2999-12-31'),
	(30640,'04','021',' 09','021093',21093,'Silandro/Schlanders','Silandro/Schlanders','Schlanders','BZ',1,'1840-01-01','2999-12-31'),
	(30641,'04','021',' 09','021094',21094,'Sluderno/Schluderns','Sluderno/Schluderns','Schluderns','BZ',1,'1840-01-01','2999-12-31'),
	(30642,'04','021',' 09','021095',21095,'Stelvio/Stilfs','Stelvio/Stilfs','Stilfs','BZ',1,'1840-01-01','2999-12-31'),
	(30643,'04','021',' 09','021096',21096,'Terento/Terenten','Terento/Terenten','Terenten','BZ',1,'1840-01-01','2999-12-31'),
	(30644,'04','021',' 09','021097',21097,'Terlano/Terlan','Terlano/Terlan','Terlan','BZ',1,'1840-01-01','2999-12-31'),
	(30645,'04','021',' 09','021098',21098,'Termeno sulla strada del vino/Tramin an der Weinstrasse','Termeno sulla strada del vino/Tramin an der Weinstrasse','Tramin an der Weinstraße','BZ',1,'1840-01-01','2999-12-31'),
	(30646,'04','021',' 09','021099',21099,'Tesimo/Tisens','Tesimo/Tisens','Tisens','BZ',1,'1840-01-01','2999-12-31'),
	(30647,'04','021',' 10','021100',21100,'Tires/Tiers','Tires/Tiers','Tiers','BZ',1,'1840-01-01','2999-12-31'),
	(30648,'04','021',' 10','021101',21101,'Tirolo/Tirol','Tirolo/Tirol','Tirol','BZ',1,'1840-01-01','2999-12-31'),
	(30649,'04','021',' 10','021102',21102,'Trodena nel parco naturale/Truden im Naturpark','Trodena nel parco naturale/Truden im Naturpark','Truden im Naturpark','BZ',1,'1840-01-01','2999-12-31'),
	(30650,'04','021',' 10','021103',21103,'Tubre/Taufers im Muenstertal','Tubre/Taufers im Muenstertal','Taufers im Münstertal','BZ',1,'1840-01-01','2999-12-31'),
	(30651,'04','021',' 10','021104',21104,'Ultimo/Ulten','Ultimo/Ulten','Ulten','BZ',1,'1840-01-01','2999-12-31'),
	(30652,'04','021',' 10','021105',21105,'Vadena/Pfatten','Vadena/Pfatten','Pfatten','BZ',1,'1840-01-01','2999-12-31'),
	(30653,'04','021',' 10','021106',21106,'Valdaora/Olang','Valdaora/Olang','Olang','BZ',1,'1840-01-01','2999-12-31'),
	(30654,'04','021',' 10','021107',21107,'Val di Vizze/Pfitsch','Val di Vizze/Pfitsch','Pfitsch','BZ',1,'1840-01-01','2999-12-31'),
	(30655,'04','021',' 10','021108',21108,'Valle Aurina/Ahrntal','Valle Aurina/Ahrntal','Ahrntal','BZ',1,'1840-01-01','2999-12-31'),
	(30656,'04','021',' 10','021109',21109,'Valle di Casies/Gsies','Valle di Casies/Gsies','Gsies','BZ',1,'1840-01-01','2999-12-31'),
	(30657,'04','021',' 11','021110',21110,'Vandoies/Vintl','Vandoies/Vintl','Vintl','BZ',1,'1840-01-01','2999-12-31'),
	(30658,'04','021',' 11','021111',21111,'Varna/Vahrn','Varna/Vahrn','Vahrn','BZ',1,'1840-01-01','2999-12-31'),
	(30659,'04','021',' 11','021112',21112,'Verano/Voeran','Verano/Voeran','Vöran','BZ',1,'1840-01-01','2999-12-31'),
	(30660,'04','021',' 11','021113',21113,'Villabassa/Niederdorf','Villabassa/Niederdorf','Niederdorf','BZ',1,'1840-01-01','2999-12-31'),
	(30661,'04','021',' 11','021114',21114,'Villandro/Villanders','Villandro/Villanders','Villanders','BZ',1,'1840-01-01','2999-12-31'),
	(30662,'04','021',' 11','021115',21115,'Vipiteno/Sterzing','Vipiteno/Sterzing','Sterzing','BZ',1,'1840-01-01','2999-12-31'),
	(30663,'04','021',' 11','021116',21116,'Velturno/Feldthurns','Velturno/Feldthurns','Feldthurns','BZ',1,'1840-01-01','2999-12-31'),
	(30664,'04','021',' 11','021117',21117,'La Valle/Wengen','La Valle/Wengen','Wengen','BZ',1,'1840-01-01','2999-12-31'),
	(30665,'04','021',' 11','021118',21118,'Senale-San Felice/Unsere Liebe Frau im Walde-St. Felix','Senale-San Felice/Unsere Liebe Frau im Walde-St. Felix','Unsere Liebe Frau im Walde-St. Felix','BZ',1,'1840-01-01','2999-12-31'),
	(30666,'04','022',' 00','022001',22001,'Ala','Ala','','TN',1,'1840-01-01','2999-12-31'),
	(30667,'04','022',' 00','022002',22002,'Albiano','Albiano','','TN',1,'1840-01-01','2999-12-31'),
	(30668,'04','022',' 00','022003',22003,'Aldeno','Aldeno','','TN',1,'1840-01-01','2999-12-31'),
	(30669,'04','022',' 00','022004',22004,'Amblar','Amblar','','TN',1,'1840-01-01','2999-12-31'),
	(30670,'04','022',' 00','022005',22005,'Andalo','Andalo','','TN',1,'1840-01-01','2999-12-31'),
	(30671,'04','022',' 00','022006',22006,'Arco','Arco','','TN',1,'1840-01-01','2999-12-31'),
	(30672,'04','022',' 00','022007',22007,'Avio','Avio','','TN',1,'1840-01-01','2999-12-31'),
	(30673,'04','022',' 00','022009',22009,'Baselga di Pinè','Baselga di Pinè','','TN',1,'1840-01-01','2999-12-31'),
	(30674,'04','022',' 01','022011',22011,'Bedollo','Bedollo','','TN',1,'1840-01-01','2999-12-31'),
	(30675,'04','022',' 01','022012',22012,'Bersone','Bersone','','TN',1,'1840-01-01','2999-12-31'),
	(30676,'04','022',' 01','022013',22013,'Besenello','Besenello','','TN',1,'1840-01-01','2999-12-31'),
	(30677,'04','022',' 01','022015',22015,'Bieno','Bieno','','TN',1,'1840-01-01','2999-12-31'),
	(30678,'04','022',' 01','022017',22017,'Bleggio Superiore','Bleggio Superiore','','TN',1,'1840-01-01','2999-12-31'),
	(30679,'04','022',' 01','022018',22018,'Bocenago','Bocenago','','TN',1,'1840-01-01','2999-12-31'),
	(30680,'04','022',' 01','022019',22019,'Bolbeno','Bolbeno','','TN',1,'1840-01-01','2999-12-31'),
	(30681,'04','022',' 02','022020',22020,'Bondo','Bondo','','TN',1,'1840-01-01','2999-12-31'),
	(30682,'04','022',' 02','022021',22021,'Bondone','Bondone','','TN',1,'1840-01-01','2999-12-31'),
	(30683,'04','022',' 02','022022',22022,'Borgo Valsugana','Borgo Valsugana','','TN',1,'1840-01-01','2999-12-31'),
	(30684,'04','022',' 02','022023',22023,'Bosentino','Bosentino','','TN',1,'1840-01-01','2999-12-31'),
	(30685,'04','022',' 02','022024',22024,'Breguzzo','Breguzzo','','TN',1,'1840-01-01','2999-12-31'),
	(30686,'04','022',' 02','022025',22025,'Brentonico','Brentonico','','TN',1,'1840-01-01','2999-12-31'),
	(30687,'04','022',' 02','022026',22026,'Bresimo','Bresimo','','TN',1,'1840-01-01','2999-12-31'),
	(30688,'04','022',' 02','022027',22027,'Brez','Brez','','TN',1,'1840-01-01','2999-12-31'),
	(30689,'04','022',' 02','022028',22028,'Brione','Brione','','TN',1,'1840-01-01','2999-12-31'),
	(30690,'04','022',' 02','022029',22029,'Caderzone Terme','Caderzone Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30691,'04','022',' 03','022030',22030,'Cagnò','Cagnò','','TN',1,'1840-01-01','2999-12-31'),
	(30692,'04','022',' 03','022031',22031,'Calavino','Calavino','','TN',1,'1840-01-01','2999-12-31'),
	(30693,'04','022',' 03','022032',22032,'Calceranica al Lago','Calceranica al Lago','','TN',1,'1840-01-01','2999-12-31'),
	(30694,'04','022',' 03','022033',22033,'Caldes','Caldes','','TN',1,'1840-01-01','2999-12-31'),
	(30695,'04','022',' 03','022034',22034,'Caldonazzo','Caldonazzo','','TN',1,'1840-01-01','2999-12-31'),
	(30696,'04','022',' 03','022035',22035,'Calliano','Calliano','','TN',1,'1840-01-01','2999-12-31'),
	(30697,'04','022',' 03','022036',22036,'Campitello di Fassa','Campitello di Fassa','','TN',1,'1840-01-01','2999-12-31'),
	(30698,'04','022',' 03','022037',22037,'Campodenno','Campodenno','','TN',1,'1840-01-01','2999-12-31'),
	(30699,'04','022',' 03','022038',22038,'Canal San Bovo','Canal San Bovo','','TN',1,'1840-01-01','2999-12-31'),
	(30700,'04','022',' 03','022039',22039,'Canazei','Canazei','','TN',1,'1840-01-01','2999-12-31'),
	(30701,'04','022',' 04','022040',22040,'Capriana','Capriana','','TN',1,'1840-01-01','2999-12-31'),
	(30702,'04','022',' 04','022041',22041,'Carano','Carano','','TN',1,'1840-01-01','2999-12-31'),
	(30703,'04','022',' 04','022042',22042,'Carisolo','Carisolo','','TN',1,'1840-01-01','2999-12-31'),
	(30704,'04','022',' 04','022043',22043,'Carzano','Carzano','','TN',1,'1840-01-01','2999-12-31'),
	(30705,'04','022',' 04','022045',22045,'Castel Condino','Castel Condino','','TN',1,'1840-01-01','2999-12-31'),
	(30706,'04','022',' 04','022046',22046,'Castelfondo','Castelfondo','','TN',1,'1840-01-01','2999-12-31'),
	(30707,'04','022',' 04','022047',22047,'Castello-Molina di Fiemme','Castello-Molina di Fiemme','','TN',1,'1840-01-01','2999-12-31'),
	(30708,'04','022',' 04','022048',22048,'Castello Tesino','Castello Tesino','','TN',1,'1840-01-01','2999-12-31'),
	(30709,'04','022',' 04','022049',22049,'Castelnuovo','Castelnuovo','','TN',1,'1840-01-01','2999-12-31'),
	(30710,'04','022',' 05','022050',22050,'Cavalese','Cavalese','','TN',1,'1840-01-01','2999-12-31'),
	(30711,'04','022',' 05','022051',22051,'Cavareno','Cavareno','','TN',1,'1840-01-01','2999-12-31'),
	(30712,'04','022',' 05','022052',22052,'Cavedago','Cavedago','','TN',1,'1840-01-01','2999-12-31'),
	(30713,'04','022',' 05','022053',22053,'Cavedine','Cavedine','','TN',1,'1840-01-01','2999-12-31'),
	(30714,'04','022',' 05','022054',22054,'Cavizzana','Cavizzana','','TN',1,'1840-01-01','2999-12-31'),
	(30715,'04','022',' 05','022055',22055,'Cembra','Cembra','','TN',1,'1840-01-01','2999-12-31'),
	(30716,'04','022',' 05','022056',22056,'Centa San Nicolò','Centa San Nicolò','','TN',1,'1840-01-01','2999-12-31'),
	(30717,'04','022',' 05','022057',22057,'Cimego','Cimego','','TN',1,'1840-01-01','2999-12-31'),
	(30718,'04','022',' 05','022058',22058,'Cimone','Cimone','','TN',1,'1840-01-01','2999-12-31'),
	(30719,'04','022',' 05','022059',22059,'Cinte Tesino','Cinte Tesino','','TN',1,'1840-01-01','2999-12-31'),
	(30720,'04','022',' 06','022060',22060,'Cis','Cis','','TN',1,'1840-01-01','2999-12-31'),
	(30721,'04','022',' 06','022061',22061,'Civezzano','Civezzano','','TN',1,'1840-01-01','2999-12-31'),
	(30722,'04','022',' 06','022062',22062,'Cles','Cles','','TN',1,'1840-01-01','2999-12-31'),
	(30723,'04','022',' 06','022063',22063,'Cloz','Cloz','','TN',1,'1840-01-01','2999-12-31'),
	(30724,'04','022',' 06','022064',22064,'Commezzadura','Commezzadura','','TN',1,'1840-01-01','2999-12-31'),
	(30725,'04','022',' 06','022066',22066,'Condino','Condino','','TN',1,'1840-01-01','2999-12-31'),
	(30726,'04','022',' 06','022067',22067,'Coredo','Coredo','','TN',1,'1840-01-01','2999-12-31'),
	(30727,'04','022',' 06','022068',22068,'Croviana','Croviana','','TN',1,'1840-01-01','2999-12-31'),
	(30728,'04','022',' 06','022069',22069,'Cunevo','Cunevo','','TN',1,'1840-01-01','2999-12-31'),
	(30729,'04','022',' 07','022070',22070,'Daiano','Daiano','','TN',1,'1840-01-01','2999-12-31'),
	(30730,'04','022',' 07','022071',22071,'Dambel','Dambel','','TN',1,'1840-01-01','2999-12-31'),
	(30731,'04','022',' 07','022072',22072,'Daone','Daone','','TN',1,'1840-01-01','2999-12-31'),
	(30732,'04','022',' 07','022073',22073,'Darè','Darè','','TN',1,'1840-01-01','2999-12-31'),
	(30733,'04','022',' 07','022074',22074,'Denno','Denno','','TN',1,'1840-01-01','2999-12-31'),
	(30734,'04','022',' 07','022075',22075,'Dimaro','Dimaro','','TN',1,'1840-01-01','2999-12-31'),
	(30735,'04','022',' 07','022076',22076,'Don','Don','','TN',1,'1840-01-01','2999-12-31'),
	(30736,'04','022',' 07','022077',22077,'Dorsino','Dorsino','','TN',1,'1840-01-01','2999-12-31'),
	(30737,'04','022',' 07','022078',22078,'Drena','Drena','','TN',1,'1840-01-01','2999-12-31'),
	(30738,'04','022',' 07','022079',22079,'Dro','Dro','','TN',1,'1840-01-01','2999-12-31'),
	(30739,'04','022',' 08','022080',22080,'Faedo','Faedo','','TN',1,'1840-01-01','2999-12-31'),
	(30740,'04','022',' 08','022081',22081,'Fai della Paganella','Fai della Paganella','','TN',1,'1840-01-01','2999-12-31'),
	(30741,'04','022',' 08','022082',22082,'Faver','Faver','','TN',1,'1840-01-01','2999-12-31'),
	(30742,'04','022',' 08','022083',22083,'Fiavè','Fiavè','','TN',1,'1840-01-01','2999-12-31'),
	(30743,'04','022',' 08','022084',22084,'Fiera di Primiero','Fiera di Primiero','','TN',1,'1840-01-01','2999-12-31'),
	(30744,'04','022',' 08','022085',22085,'Fierozzo','Fierozzo','','TN',1,'1840-01-01','2999-12-31'),
	(30745,'04','022',' 08','022086',22086,'Flavon','Flavon','','TN',1,'1840-01-01','2999-12-31'),
	(30746,'04','022',' 08','022087',22087,'Folgaria','Folgaria','','TN',1,'1840-01-01','2999-12-31'),
	(30747,'04','022',' 08','022088',22088,'Fondo','Fondo','','TN',1,'1840-01-01','2999-12-31'),
	(30748,'04','022',' 08','022089',22089,'Fornace','Fornace','','TN',1,'1840-01-01','2999-12-31'),
	(30749,'04','022',' 09','022090',22090,'Frassilongo','Frassilongo','','TN',1,'1840-01-01','2999-12-31'),
	(30750,'04','022',' 09','022091',22091,'Garniga Terme','Garniga Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30751,'04','022',' 09','022092',22092,'Giovo','Giovo','','TN',1,'1840-01-01','2999-12-31'),
	(30752,'04','022',' 09','022093',22093,'Giustino','Giustino','','TN',1,'1840-01-01','2999-12-31'),
	(30753,'04','022',' 09','022094',22094,'Grauno','Grauno','','TN',1,'1840-01-01','2999-12-31'),
	(30754,'04','022',' 09','022095',22095,'Grigno','Grigno','','TN',1,'1840-01-01','2999-12-31'),
	(30755,'04','022',' 09','022096',22096,'Grumes','Grumes','','TN',1,'1840-01-01','2999-12-31'),
	(30756,'04','022',' 09','022097',22097,'Imer','Imer','','TN',1,'1840-01-01','2999-12-31'),
	(30757,'04','022',' 09','022098',22098,'Isera','Isera','','TN',1,'1840-01-01','2999-12-31'),
	(30758,'04','022',' 09','022099',22099,'Ivano-Fracena','Ivano-Fracena','','TN',1,'1840-01-01','2999-12-31'),
	(30759,'04','022',' 10','022100',22100,'Lardaro','Lardaro','','TN',1,'1840-01-01','2999-12-31'),
	(30760,'04','022',' 10','022101',22101,'Lasino','Lasino','','TN',1,'1840-01-01','2999-12-31'),
	(30761,'04','022',' 10','022102',22102,'Lavarone','Lavarone','','TN',1,'1840-01-01','2999-12-31'),
	(30762,'04','022',' 10','022103',22103,'Lavis','Lavis','','TN',1,'1840-01-01','2999-12-31'),
	(30763,'04','022',' 10','022104',22104,'Levico Terme','Levico Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30764,'04','022',' 10','022105',22105,'Lisignago','Lisignago','','TN',1,'1840-01-01','2999-12-31'),
	(30765,'04','022',' 10','022106',22106,'Livo','Livo','','TN',1,'1840-01-01','2999-12-31'),
	(30766,'04','022',' 10','022108',22108,'Lona-Lases','Lona-Lases','','TN',1,'1840-01-01','2999-12-31'),
	(30767,'04','022',' 10','022109',22109,'Luserna','Luserna','','TN',1,'1840-01-01','2999-12-31'),
	(30768,'04','022',' 11','022110',22110,'Malè','Malè','','TN',1,'1840-01-01','2999-12-31'),
	(30769,'04','022',' 11','022111',22111,'Malosco','Malosco','','TN',1,'1840-01-01','2999-12-31'),
	(30770,'04','022',' 11','022112',22112,'Massimeno','Massimeno','','TN',1,'1840-01-01','2999-12-31'),
	(30771,'04','022',' 11','022113',22113,'Mazzin','Mazzin','','TN',1,'1840-01-01','2999-12-31'),
	(30772,'04','022',' 11','022114',22114,'Mezzana','Mezzana','','TN',1,'1840-01-01','2999-12-31'),
	(30773,'04','022',' 11','022115',22115,'Mezzano','Mezzano','','TN',1,'1840-01-01','2999-12-31'),
	(30774,'04','022',' 11','022116',22116,'Mezzocorona','Mezzocorona','','TN',1,'1840-01-01','2999-12-31'),
	(30775,'04','022',' 11','022117',22117,'Mezzolombardo','Mezzolombardo','','TN',1,'1840-01-01','2999-12-31'),
	(30776,'04','022',' 11','022118',22118,'Moena','Moena','','TN',1,'1840-01-01','2999-12-31'),
	(30777,'04','022',' 12','022120',22120,'Molveno','Molveno','','TN',1,'1840-01-01','2999-12-31'),
	(30778,'04','022',' 12','022121',22121,'Monclassico','Monclassico','','TN',1,'1840-01-01','2999-12-31'),
	(30779,'04','022',' 12','022122',22122,'Montagne','Montagne','','TN',1,'1840-01-01','2999-12-31'),
	(30780,'04','022',' 12','022123',22123,'Mori','Mori','','TN',1,'1840-01-01','2999-12-31'),
	(30781,'04','022',' 12','022124',22124,'Nago-Torbole','Nago-Torbole','','TN',1,'1840-01-01','2999-12-31'),
	(30782,'04','022',' 12','022125',22125,'Nanno','Nanno','','TN',1,'1840-01-01','2999-12-31'),
	(30783,'04','022',' 12','022126',22126,'Nave San Rocco','Nave San Rocco','','TN',1,'1840-01-01','2999-12-31'),
	(30784,'04','022',' 12','022127',22127,'Nogaredo','Nogaredo','','TN',1,'1840-01-01','2999-12-31'),
	(30785,'04','022',' 12','022128',22128,'Nomi','Nomi','','TN',1,'1840-01-01','2999-12-31'),
	(30786,'04','022',' 12','022129',22129,'Novaledo','Novaledo','','TN',1,'1840-01-01','2999-12-31'),
	(30787,'04','022',' 13','022130',22130,'Ospedaletto','Ospedaletto','','TN',1,'1840-01-01','2999-12-31'),
	(30788,'04','022',' 13','022131',22131,'Ossana','Ossana','','TN',1,'1840-01-01','2999-12-31'),
	(30789,'04','022',' 13','022132',22132,'Padergnone','Padergnone','','TN',1,'1840-01-01','2999-12-31'),
	(30790,'04','022',' 13','022133',22133,'Palù del Fersina','Palù del Fersina','','TN',1,'1840-01-01','2999-12-31'),
	(30791,'04','022',' 13','022134',22134,'Panchià','Panchià','','TN',1,'1840-01-01','2999-12-31'),
	(30792,'04','022',' 13','022135',22135,'Ronzo-Chienis','Ronzo-Chienis','','TN',1,'1840-01-01','2999-12-31'),
	(30793,'04','022',' 13','022136',22136,'Peio','Peio','','TN',1,'1840-01-01','2999-12-31'),
	(30794,'04','022',' 13','022137',22137,'Pellizzano','Pellizzano','','TN',1,'1840-01-01','2999-12-31'),
	(30795,'04','022',' 13','022138',22138,'Pelugo','Pelugo','','TN',1,'1840-01-01','2999-12-31'),
	(30796,'04','022',' 13','022139',22139,'Pergine Valsugana','Pergine Valsugana','','TN',1,'1840-01-01','2999-12-31'),
	(30797,'04','022',' 14','022140',22140,'Pieve di Bono','Pieve di Bono','','TN',1,'1840-01-01','2999-12-31'),
	(30798,'04','022',' 14','022142',22142,'Pieve Tesino','Pieve Tesino','','TN',1,'1840-01-01','2999-12-31'),
	(30799,'04','022',' 14','022143',22143,'Pinzolo','Pinzolo','','TN',1,'1840-01-01','2999-12-31'),
	(30800,'04','022',' 14','022144',22144,'Pomarolo','Pomarolo','','TN',1,'1840-01-01','2999-12-31'),
	(30801,'04','022',' 14','022145',22145,'Pozza di Fassa','Pozza di Fassa','','TN',1,'1840-01-01','2999-12-31'),
	(30802,'04','022',' 14','022146',22146,'Praso','Praso','','TN',1,'1840-01-01','2999-12-31'),
	(30803,'04','022',' 14','022147',22147,'Predazzo','Predazzo','','TN',1,'1840-01-01','2999-12-31'),
	(30804,'04','022',' 14','022148',22148,'Preore','Preore','','TN',1,'1840-01-01','2999-12-31'),
	(30805,'04','022',' 14','022149',22149,'Prezzo','Prezzo','','TN',1,'1840-01-01','2999-12-31'),
	(30806,'04','022',' 15','022150',22150,'Rabbi','Rabbi','','TN',1,'1840-01-01','2999-12-31'),
	(30807,'04','022',' 15','022151',22151,'Ragoli','Ragoli','','TN',1,'1840-01-01','2999-12-31'),
	(30808,'04','022',' 15','022152',22152,'Revò','Revò','','TN',1,'1840-01-01','2999-12-31'),
	(30809,'04','022',' 15','022153',22153,'Riva del Garda','Riva del Garda','','TN',1,'1840-01-01','2999-12-31'),
	(30810,'04','022',' 15','022154',22154,'Romallo','Romallo','','TN',1,'1840-01-01','2999-12-31'),
	(30811,'04','022',' 15','022155',22155,'Romeno','Romeno','','TN',1,'1840-01-01','2999-12-31'),
	(30812,'04','022',' 15','022156',22156,'Roncegno Terme','Roncegno Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30813,'04','022',' 15','022157',22157,'Ronchi Valsugana','Ronchi Valsugana','','TN',1,'1840-01-01','2999-12-31'),
	(30814,'04','022',' 15','022158',22158,'Roncone','Roncone','','TN',1,'1840-01-01','2999-12-31'),
	(30815,'04','022',' 15','022159',22159,'Ronzone','Ronzone','','TN',1,'1840-01-01','2999-12-31'),
	(30816,'04','022',' 16','022160',22160,'Roverè della Luna','Roverè della Luna','','TN',1,'1840-01-01','2999-12-31'),
	(30817,'04','022',' 16','022161',22161,'Rovereto','Rovereto','','TN',1,'1840-01-01','2999-12-31'),
	(30818,'04','022',' 16','022162',22162,'Ruffrè-Mendola','Ruffrè-Mendola','','TN',1,'1840-01-01','2999-12-31'),
	(30819,'04','022',' 16','022163',22163,'Rumo','Rumo','','TN',1,'1840-01-01','2999-12-31'),
	(30820,'04','022',' 16','022164',22164,'Sagron Mis','Sagron Mis','','TN',1,'1840-01-01','2999-12-31'),
	(30821,'04','022',' 16','022165',22165,'Samone','Samone','','TN',1,'1840-01-01','2999-12-31'),
	(30822,'04','022',' 16','022166',22166,'San Lorenzo in Banale','San Lorenzo in Banale','','TN',1,'1840-01-01','2999-12-31'),
	(30823,'04','022',' 16','022167',22167,'San Michele all\'Adige','San Michele all\'Adige','','TN',1,'1840-01-01','2999-12-31'),
	(30824,'04','022',' 16','022168',22168,'Sant\'Orsola Terme','Sant\'Orsola Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30825,'04','022',' 16','022169',22169,'Sanzeno','Sanzeno','','TN',1,'1840-01-01','2999-12-31'),
	(30826,'04','022',' 17','022170',22170,'Sarnonico','Sarnonico','','TN',1,'1840-01-01','2999-12-31'),
	(30827,'04','022',' 17','022171',22171,'Scurelle','Scurelle','','TN',1,'1840-01-01','2999-12-31'),
	(30828,'04','022',' 17','022172',22172,'Segonzano','Segonzano','','TN',1,'1840-01-01','2999-12-31'),
	(30829,'04','022',' 17','022173',22173,'Sfruz','Sfruz','','TN',1,'1840-01-01','2999-12-31'),
	(30830,'04','022',' 17','022174',22174,'Siror','Siror','','TN',1,'1840-01-01','2999-12-31'),
	(30831,'04','022',' 17','022175',22175,'Smarano','Smarano','','TN',1,'1840-01-01','2999-12-31'),
	(30832,'04','022',' 17','022176',22176,'Soraga','Soraga','','TN',1,'1840-01-01','2999-12-31'),
	(30833,'04','022',' 17','022177',22177,'Sover','Sover','','TN',1,'1840-01-01','2999-12-31'),
	(30834,'04','022',' 17','022178',22178,'Spera','Spera','','TN',1,'1840-01-01','2999-12-31'),
	(30835,'04','022',' 17','022179',22179,'Spiazzo','Spiazzo','','TN',1,'1840-01-01','2999-12-31'),
	(30836,'04','022',' 18','022180',22180,'Spormaggiore','Spormaggiore','','TN',1,'1840-01-01','2999-12-31'),
	(30837,'04','022',' 18','022181',22181,'Sporminore','Sporminore','','TN',1,'1840-01-01','2999-12-31'),
	(30838,'04','022',' 18','022182',22182,'Stenico','Stenico','','TN',1,'1840-01-01','2999-12-31'),
	(30839,'04','022',' 18','022183',22183,'Storo','Storo','','TN',1,'1840-01-01','2999-12-31'),
	(30840,'04','022',' 18','022184',22184,'Strembo','Strembo','','TN',1,'1840-01-01','2999-12-31'),
	(30841,'04','022',' 18','022185',22185,'Strigno','Strigno','','TN',1,'1840-01-01','2999-12-31'),
	(30842,'04','022',' 18','022186',22186,'Taio','Taio','','TN',1,'1840-01-01','2999-12-31'),
	(30843,'04','022',' 18','022187',22187,'Tassullo','Tassullo','','TN',1,'1840-01-01','2999-12-31'),
	(30844,'04','022',' 18','022188',22188,'Telve','Telve','','TN',1,'1840-01-01','2999-12-31'),
	(30845,'04','022',' 18','022189',22189,'Telve di Sopra','Telve di Sopra','','TN',1,'1840-01-01','2999-12-31'),
	(30846,'04','022',' 19','022190',22190,'Tenna','Tenna','','TN',1,'1840-01-01','2999-12-31'),
	(30847,'04','022',' 19','022191',22191,'Tenno','Tenno','','TN',1,'1840-01-01','2999-12-31'),
	(30848,'04','022',' 19','022192',22192,'Terlago','Terlago','','TN',1,'1840-01-01','2999-12-31'),
	(30849,'04','022',' 19','022193',22193,'Terragnolo','Terragnolo','','TN',1,'1840-01-01','2999-12-31'),
	(30850,'04','022',' 19','022194',22194,'Terres','Terres','','TN',1,'1840-01-01','2999-12-31'),
	(30851,'04','022',' 19','022195',22195,'Terzolas','Terzolas','','TN',1,'1840-01-01','2999-12-31'),
	(30852,'04','022',' 19','022196',22196,'Tesero','Tesero','','TN',1,'1840-01-01','2999-12-31'),
	(30853,'04','022',' 19','022199',22199,'Tione di Trento','Tione di Trento','','TN',1,'1840-01-01','2999-12-31'),
	(30854,'04','022',' 20','022200',22200,'Ton','Ton','','TN',1,'1840-01-01','2999-12-31'),
	(30855,'04','022',' 20','022201',22201,'Tonadico','Tonadico','','TN',1,'1840-01-01','2999-12-31'),
	(30856,'04','022',' 20','022202',22202,'Torcegno','Torcegno','','TN',1,'1840-01-01','2999-12-31'),
	(30857,'04','022',' 20','022203',22203,'Trambileno','Trambileno','','TN',1,'1840-01-01','2999-12-31'),
	(30858,'04','022',' 20','022204',22204,'Transacqua','Transacqua','','TN',1,'1840-01-01','2999-12-31'),
	(30859,'04','022',' 20','022205',22205,'Trento','Trento','','TN',1,'1840-01-01','2999-12-31'),
	(30860,'04','022',' 20','022206',22206,'Tres','Tres','','TN',1,'1840-01-01','2999-12-31'),
	(30861,'04','022',' 20','022207',22207,'Tuenno','Tuenno','','TN',1,'1840-01-01','2999-12-31'),
	(30862,'04','022',' 20','022208',22208,'Valda','Valda','','TN',1,'1840-01-01','2999-12-31'),
	(30863,'04','022',' 20','022209',22209,'Valfloriana','Valfloriana','','TN',1,'1840-01-01','2999-12-31'),
	(30864,'04','022',' 21','022210',22210,'Vallarsa','Vallarsa','','TN',1,'1840-01-01','2999-12-31'),
	(30865,'04','022',' 21','022211',22211,'Varena','Varena','','TN',1,'1840-01-01','2999-12-31'),
	(30866,'04','022',' 21','022212',22212,'Vattaro','Vattaro','','TN',1,'1840-01-01','2999-12-31'),
	(30867,'04','022',' 21','022213',22213,'Vermiglio','Vermiglio','','TN',1,'1840-01-01','2999-12-31'),
	(30868,'04','022',' 21','022214',22214,'Vervò','Vervò','','TN',1,'1840-01-01','2999-12-31'),
	(30869,'04','022',' 21','022215',22215,'Vezzano','Vezzano','','TN',1,'1840-01-01','2999-12-31'),
	(30870,'04','022',' 21','022216',22216,'Vignola-Falesina','Vignola-Falesina','','TN',1,'1840-01-01','2999-12-31'),
	(30871,'04','022',' 21','022217',22217,'Vigo di Fassa','Vigo di Fassa','','TN',1,'1840-01-01','2999-12-31'),
	(30872,'04','022',' 21','022219',22219,'Vigolo Vattaro','Vigolo Vattaro','','TN',1,'1840-01-01','2999-12-31'),
	(30873,'04','022',' 22','022220',22220,'Vigo Rendena','Vigo Rendena','','TN',1,'1840-01-01','2999-12-31'),
	(30874,'04','022',' 22','022221',22221,'Villa Agnedo','Villa Agnedo','','TN',1,'1840-01-01','2999-12-31'),
	(30875,'04','022',' 22','022222',22222,'Villa Lagarina','Villa Lagarina','','TN',1,'1840-01-01','2999-12-31'),
	(30876,'04','022',' 22','022223',22223,'Villa Rendena','Villa Rendena','','TN',1,'1840-01-01','2999-12-31'),
	(30877,'04','022',' 22','022224',22224,'Volano','Volano','','TN',1,'1840-01-01','2999-12-31'),
	(30878,'04','022',' 22','022225',22225,'Zambana','Zambana','','TN',1,'1840-01-01','2999-12-31'),
	(30879,'04','022',' 22','022226',22226,'Ziano di Fiemme','Ziano di Fiemme','','TN',1,'1840-01-01','2999-12-31'),
	(30880,'04','022',' 22','022227',22227,'Zuclo','Zuclo','','TN',1,'1840-01-01','2999-12-31'),
	(30881,'04','022',' 22','022228',22228,'Comano Terme','Comano Terme','','TN',1,'1840-01-01','2999-12-31'),
	(30882,'04','022',' 22','022229',22229,'Ledro','Ledro','','TN',1,'1840-01-01','2999-12-31'),
	(30883,'05','023',' 00','023001',23001,'Affi','Affi','','VR',1,'1840-01-01','2999-12-31'),
	(30884,'05','023',' 00','023002',23002,'Albaredo d\'Adige','Albaredo d\'Adige','','VR',1,'1840-01-01','2999-12-31'),
	(30885,'05','023',' 00','023003',23003,'Angiari','Angiari','','VR',1,'1840-01-01','2999-12-31'),
	(30886,'05','023',' 00','023004',23004,'Arcole','Arcole','','VR',1,'1840-01-01','2999-12-31'),
	(30887,'05','023',' 00','023005',23005,'Badia Calavena','Badia Calavena','','VR',1,'1840-01-01','2999-12-31'),
	(30888,'05','023',' 00','023006',23006,'Bardolino','Bardolino','','VR',1,'1840-01-01','2999-12-31'),
	(30889,'05','023',' 00','023007',23007,'Belfiore','Belfiore','','VR',1,'1840-01-01','2999-12-31'),
	(30890,'05','023',' 00','023008',23008,'Bevilacqua','Bevilacqua','','VR',1,'1840-01-01','2999-12-31'),
	(30891,'05','023',' 00','023009',23009,'Bonavigo','Bonavigo','','VR',1,'1840-01-01','2999-12-31'),
	(30892,'05','023',' 01','023010',23010,'Boschi Sant\'Anna','Boschi Sant\'Anna','','VR',1,'1840-01-01','2999-12-31'),
	(30893,'05','023',' 01','023011',23011,'Bosco Chiesanuova','Bosco Chiesanuova','','VR',1,'1840-01-01','2999-12-31'),
	(30894,'05','023',' 01','023012',23012,'Bovolone','Bovolone','','VR',1,'1840-01-01','2999-12-31'),
	(30895,'05','023',' 01','023013',23013,'Brentino Belluno','Brentino Belluno','','VR',1,'1840-01-01','2999-12-31'),
	(30896,'05','023',' 01','023014',23014,'Brenzone','Brenzone','','VR',1,'1840-01-01','2999-12-31'),
	(30897,'05','023',' 01','023015',23015,'Bussolengo','Bussolengo','','VR',1,'1840-01-01','2999-12-31'),
	(30898,'05','023',' 01','023016',23016,'Buttapietra','Buttapietra','','VR',1,'1840-01-01','2999-12-31'),
	(30899,'05','023',' 01','023017',23017,'Caldiero','Caldiero','','VR',1,'1840-01-01','2999-12-31'),
	(30900,'05','023',' 01','023018',23018,'Caprino Veronese','Caprino Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30901,'05','023',' 01','023019',23019,'Casaleone','Casaleone','','VR',1,'1840-01-01','2999-12-31'),
	(30902,'05','023',' 02','023020',23020,'Castagnaro','Castagnaro','','VR',1,'1840-01-01','2999-12-31'),
	(30903,'05','023',' 02','023021',23021,'Castel d\'Azzano','Castel d\'Azzano','','VR',1,'1840-01-01','2999-12-31'),
	(30904,'05','023',' 02','023022',23022,'Castelnuovo del Garda','Castelnuovo del Garda','','VR',1,'1840-01-01','2999-12-31'),
	(30905,'05','023',' 02','023023',23023,'Cavaion Veronese','Cavaion Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30906,'05','023',' 02','023024',23024,'Cazzano di Tramigna','Cazzano di Tramigna','','VR',1,'1840-01-01','2999-12-31'),
	(30907,'05','023',' 02','023025',23025,'Cerea','Cerea','','VR',1,'1840-01-01','2999-12-31'),
	(30908,'05','023',' 02','023026',23026,'Cerro Veronese','Cerro Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30909,'05','023',' 02','023027',23027,'Cologna Veneta','Cologna Veneta','','VR',1,'1840-01-01','2999-12-31'),
	(30910,'05','023',' 02','023028',23028,'Colognola ai Colli','Colognola ai Colli','','VR',1,'1840-01-01','2999-12-31'),
	(30911,'05','023',' 02','023029',23029,'Concamarise','Concamarise','','VR',1,'1840-01-01','2999-12-31'),
	(30912,'05','023',' 03','023030',23030,'Costermano','Costermano','','VR',1,'1840-01-01','2999-12-31'),
	(30913,'05','023',' 03','023031',23031,'Dolcè','Dolcè','','VR',1,'1840-01-01','2999-12-31'),
	(30914,'05','023',' 03','023032',23032,'Erbè','Erbè','','VR',1,'1840-01-01','2999-12-31'),
	(30915,'05','023',' 03','023033',23033,'Erbezzo','Erbezzo','','VR',1,'1840-01-01','2999-12-31'),
	(30916,'05','023',' 03','023034',23034,'Ferrara di Monte Baldo','Ferrara di Monte Baldo','','VR',1,'1840-01-01','2999-12-31'),
	(30917,'05','023',' 03','023035',23035,'Fumane','Fumane','','VR',1,'1840-01-01','2999-12-31'),
	(30918,'05','023',' 03','023036',23036,'Garda','Garda','','VR',1,'1840-01-01','2999-12-31'),
	(30919,'05','023',' 03','023037',23037,'Gazzo Veronese','Gazzo Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30920,'05','023',' 03','023038',23038,'Grezzana','Grezzana','','VR',1,'1840-01-01','2999-12-31'),
	(30921,'05','023',' 03','023039',23039,'Illasi','Illasi','','VR',1,'1840-01-01','2999-12-31'),
	(30922,'05','023',' 04','023040',23040,'Isola della Scala','Isola della Scala','','VR',1,'1840-01-01','2999-12-31'),
	(30923,'05','023',' 04','023041',23041,'Isola Rizza','Isola Rizza','','VR',1,'1840-01-01','2999-12-31'),
	(30924,'05','023',' 04','023042',23042,'Lavagno','Lavagno','','VR',1,'1840-01-01','2999-12-31'),
	(30925,'05','023',' 04','023043',23043,'Lazise','Lazise','','VR',1,'1840-01-01','2999-12-31'),
	(30926,'05','023',' 04','023044',23044,'Legnago','Legnago','','VR',1,'1840-01-01','2999-12-31'),
	(30927,'05','023',' 04','023045',23045,'Malcesine','Malcesine','','VR',1,'1840-01-01','2999-12-31'),
	(30928,'05','023',' 04','023046',23046,'Marano di Valpolicella','Marano di Valpolicella','','VR',1,'1840-01-01','2999-12-31'),
	(30929,'05','023',' 04','023047',23047,'Mezzane di Sotto','Mezzane di Sotto','','VR',1,'1840-01-01','2999-12-31'),
	(30930,'05','023',' 04','023048',23048,'Minerbe','Minerbe','','VR',1,'1840-01-01','2999-12-31'),
	(30931,'05','023',' 04','023049',23049,'Montecchia di Crosara','Montecchia di Crosara','','VR',1,'1840-01-01','2999-12-31'),
	(30932,'05','023',' 05','023050',23050,'Monteforte d\'Alpone','Monteforte d\'Alpone','','VR',1,'1840-01-01','2999-12-31'),
	(30933,'05','023',' 05','023051',23051,'Mozzecane','Mozzecane','','VR',1,'1840-01-01','2999-12-31'),
	(30934,'05','023',' 05','023052',23052,'Negrar','Negrar','','VR',1,'1840-01-01','2999-12-31'),
	(30935,'05','023',' 05','023053',23053,'Nogara','Nogara','','VR',1,'1840-01-01','2999-12-31'),
	(30936,'05','023',' 05','023054',23054,'Nogarole Rocca','Nogarole Rocca','','VR',1,'1840-01-01','2999-12-31'),
	(30937,'05','023',' 05','023055',23055,'Oppeano','Oppeano','','VR',1,'1840-01-01','2999-12-31'),
	(30938,'05','023',' 05','023056',23056,'Palù','Palù','','VR',1,'1840-01-01','2999-12-31'),
	(30939,'05','023',' 05','023057',23057,'Pastrengo','Pastrengo','','VR',1,'1840-01-01','2999-12-31'),
	(30940,'05','023',' 05','023058',23058,'Pescantina','Pescantina','','VR',1,'1840-01-01','2999-12-31'),
	(30941,'05','023',' 05','023059',23059,'Peschiera del Garda','Peschiera del Garda','','VR',1,'1840-01-01','2999-12-31'),
	(30942,'05','023',' 06','023060',23060,'Povegliano Veronese','Povegliano Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30943,'05','023',' 06','023061',23061,'Pressana','Pressana','','VR',1,'1840-01-01','2999-12-31'),
	(30944,'05','023',' 06','023062',23062,'Rivoli Veronese','Rivoli Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30945,'05','023',' 06','023063',23063,'Roncà','Roncà','','VR',1,'1840-01-01','2999-12-31'),
	(30946,'05','023',' 06','023064',23064,'Ronco all\'Adige','Ronco all\'Adige','','VR',1,'1840-01-01','2999-12-31'),
	(30947,'05','023',' 06','023065',23065,'Roverchiara','Roverchiara','','VR',1,'1840-01-01','2999-12-31'),
	(30948,'05','023',' 06','023066',23066,'Roveredo di Guà','Roveredo di Guà','','VR',1,'1840-01-01','2999-12-31'),
	(30949,'05','023',' 06','023067',23067,'Roverè Veronese','Roverè Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30950,'05','023',' 06','023068',23068,'Salizzole','Salizzole','','VR',1,'1840-01-01','2999-12-31'),
	(30951,'05','023',' 06','023069',23069,'San Bonifacio','San Bonifacio','','VR',1,'1840-01-01','2999-12-31'),
	(30952,'05','023',' 07','023070',23070,'San Giovanni Ilarione','San Giovanni Ilarione','','VR',1,'1840-01-01','2999-12-31'),
	(30953,'05','023',' 07','023071',23071,'San Giovanni Lupatoto','San Giovanni Lupatoto','','VR',1,'1840-01-01','2999-12-31'),
	(30954,'05','023',' 07','023072',23072,'Sanguinetto','Sanguinetto','','VR',1,'1840-01-01','2999-12-31'),
	(30955,'05','023',' 07','023073',23073,'San Martino Buon Albergo','San Martino Buon Albergo','','VR',1,'1840-01-01','2999-12-31'),
	(30956,'05','023',' 07','023074',23074,'San Mauro di Saline','San Mauro di Saline','','VR',1,'1840-01-01','2999-12-31'),
	(30957,'05','023',' 07','023075',23075,'San Pietro di Morubio','San Pietro di Morubio','','VR',1,'1840-01-01','2999-12-31'),
	(30958,'05','023',' 07','023076',23076,'San Pietro in Cariano','San Pietro in Cariano','','VR',1,'1840-01-01','2999-12-31'),
	(30959,'05','023',' 07','023077',23077,'Sant\'Ambrogio di Valpolicella','Sant\'Ambrogio di Valpolicella','','VR',1,'1840-01-01','2999-12-31'),
	(30960,'05','023',' 07','023078',23078,'Sant\'Anna d\'Alfaedo','Sant\'Anna d\'Alfaedo','','VR',1,'1840-01-01','2999-12-31'),
	(30961,'05','023',' 07','023079',23079,'San Zeno di Montagna','San Zeno di Montagna','','VR',1,'1840-01-01','2999-12-31'),
	(30962,'05','023',' 08','023080',23080,'Selva di Progno','Selva di Progno','','VR',1,'1840-01-01','2999-12-31'),
	(30963,'05','023',' 08','023081',23081,'Soave','Soave','','VR',1,'1840-01-01','2999-12-31'),
	(30964,'05','023',' 08','023082',23082,'Sommacampagna','Sommacampagna','','VR',1,'1840-01-01','2999-12-31'),
	(30965,'05','023',' 08','023083',23083,'Sona','Sona','','VR',1,'1840-01-01','2999-12-31'),
	(30966,'05','023',' 08','023084',23084,'Sorgà','Sorgà','','VR',1,'1840-01-01','2999-12-31'),
	(30967,'05','023',' 08','023085',23085,'Terrazzo','Terrazzo','','VR',1,'1840-01-01','2999-12-31'),
	(30968,'05','023',' 08','023086',23086,'Torri del Benaco','Torri del Benaco','','VR',1,'1840-01-01','2999-12-31'),
	(30969,'05','023',' 08','023087',23087,'Tregnago','Tregnago','','VR',1,'1840-01-01','2999-12-31'),
	(30970,'05','023',' 08','023088',23088,'Trevenzuolo','Trevenzuolo','','VR',1,'1840-01-01','2999-12-31'),
	(30971,'05','023',' 08','023089',23089,'Valeggio sul Mincio','Valeggio sul Mincio','','VR',1,'1840-01-01','2999-12-31'),
	(30972,'05','023',' 09','023090',23090,'Velo Veronese','Velo Veronese','','VR',1,'1840-01-01','2999-12-31'),
	(30973,'05','023',' 09','023091',23091,'Verona','Verona','','VR',1,'1840-01-01','2999-12-31'),
	(30974,'05','023',' 09','023092',23092,'Veronella','Veronella','','VR',1,'1840-01-01','2999-12-31'),
	(30975,'05','023',' 09','023093',23093,'Vestenanova','Vestenanova','','VR',1,'1840-01-01','2999-12-31'),
	(30976,'05','023',' 09','023094',23094,'Vigasio','Vigasio','','VR',1,'1840-01-01','2999-12-31'),
	(30977,'05','023',' 09','023095',23095,'Villa Bartolomea','Villa Bartolomea','','VR',1,'1840-01-01','2999-12-31'),
	(30978,'05','023',' 09','023096',23096,'Villafranca di Verona','Villafranca di Verona','','VR',1,'1840-01-01','2999-12-31'),
	(30979,'05','023',' 09','023097',23097,'Zevio','Zevio','','VR',1,'1840-01-01','2999-12-31'),
	(30980,'05','023',' 09','023098',23098,'Zimella','Zimella','','VR',1,'1840-01-01','2999-12-31'),
	(30981,'05','024',' 00','024001',24001,'Agugliaro','Agugliaro','','VI',1,'1840-01-01','2999-12-31'),
	(30982,'05','024',' 00','024002',24002,'Albettone','Albettone','','VI',1,'1840-01-01','2999-12-31'),
	(30983,'05','024',' 00','024003',24003,'Alonte','Alonte','','VI',1,'1840-01-01','2999-12-31'),
	(30984,'05','024',' 00','024004',24004,'Altavilla Vicentina','Altavilla Vicentina','','VI',1,'1840-01-01','2999-12-31'),
	(30985,'05','024',' 00','024005',24005,'Altissimo','Altissimo','','VI',1,'1840-01-01','2999-12-31'),
	(30986,'05','024',' 00','024006',24006,'Arcugnano','Arcugnano','','VI',1,'1840-01-01','2999-12-31'),
	(30987,'05','024',' 00','024007',24007,'Arsiero','Arsiero','','VI',1,'1840-01-01','2999-12-31'),
	(30988,'05','024',' 00','024008',24008,'Arzignano','Arzignano','','VI',1,'1840-01-01','2999-12-31'),
	(30989,'05','024',' 00','024009',24009,'Asiago','Asiago','','VI',1,'1840-01-01','2999-12-31'),
	(30990,'05','024',' 01','024010',24010,'Asigliano Veneto','Asigliano Veneto','','VI',1,'1840-01-01','2999-12-31'),
	(30991,'05','024',' 01','024011',24011,'Barbarano Vicentino','Barbarano Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(30992,'05','024',' 01','024012',24012,'Bassano del Grappa','Bassano del Grappa','','VI',1,'1840-01-01','2999-12-31'),
	(30993,'05','024',' 01','024013',24013,'Bolzano Vicentino','Bolzano Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(30994,'05','024',' 01','024014',24014,'Breganze','Breganze','','VI',1,'1840-01-01','2999-12-31'),
	(30995,'05','024',' 01','024015',24015,'Brendola','Brendola','','VI',1,'1840-01-01','2999-12-31'),
	(30996,'05','024',' 01','024016',24016,'Bressanvido','Bressanvido','','VI',1,'1840-01-01','2999-12-31'),
	(30997,'05','024',' 01','024017',24017,'Brogliano','Brogliano','','VI',1,'1840-01-01','2999-12-31'),
	(30998,'05','024',' 01','024018',24018,'Caldogno','Caldogno','','VI',1,'1840-01-01','2999-12-31'),
	(30999,'05','024',' 01','024019',24019,'Caltrano','Caltrano','','VI',1,'1840-01-01','2999-12-31'),
	(31000,'05','024',' 02','024020',24020,'Calvene','Calvene','','VI',1,'1840-01-01','2999-12-31'),
	(31001,'05','024',' 02','024021',24021,'Camisano Vicentino','Camisano Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31002,'05','024',' 02','024022',24022,'Campiglia dei Berici','Campiglia dei Berici','','VI',1,'1840-01-01','2999-12-31'),
	(31003,'05','024',' 02','024023',24023,'Campolongo sul Brenta','Campolongo sul Brenta','','VI',1,'1840-01-01','2999-12-31'),
	(31004,'05','024',' 02','024024',24024,'Carrè','Carrè','','VI',1,'1840-01-01','2999-12-31'),
	(31005,'05','024',' 02','024025',24025,'Cartigliano','Cartigliano','','VI',1,'1840-01-01','2999-12-31'),
	(31006,'05','024',' 02','024026',24026,'Cassola','Cassola','','VI',1,'1840-01-01','2999-12-31'),
	(31007,'05','024',' 02','024027',24027,'Castegnero','Castegnero','','VI',1,'1840-01-01','2999-12-31'),
	(31008,'05','024',' 02','024028',24028,'Castelgomberto','Castelgomberto','','VI',1,'1840-01-01','2999-12-31'),
	(31009,'05','024',' 02','024029',24029,'Chiampo','Chiampo','','VI',1,'1840-01-01','2999-12-31'),
	(31010,'05','024',' 03','024030',24030,'Chiuppano','Chiuppano','','VI',1,'1840-01-01','2999-12-31'),
	(31011,'05','024',' 03','024031',24031,'Cismon del Grappa','Cismon del Grappa','','VI',1,'1840-01-01','2999-12-31'),
	(31012,'05','024',' 03','024032',24032,'Cogollo del Cengio','Cogollo del Cengio','','VI',1,'1840-01-01','2999-12-31'),
	(31013,'05','024',' 03','024033',24033,'Conco','Conco','','VI',1,'1840-01-01','2999-12-31'),
	(31014,'05','024',' 03','024034',24034,'Cornedo Vicentino','Cornedo Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31015,'05','024',' 03','024035',24035,'Costabissara','Costabissara','','VI',1,'1840-01-01','2999-12-31'),
	(31016,'05','024',' 03','024036',24036,'Creazzo','Creazzo','','VI',1,'1840-01-01','2999-12-31'),
	(31017,'05','024',' 03','024037',24037,'Crespadoro','Crespadoro','','VI',1,'1840-01-01','2999-12-31'),
	(31018,'05','024',' 03','024038',24038,'Dueville','Dueville','','VI',1,'1840-01-01','2999-12-31'),
	(31019,'05','024',' 03','024039',24039,'Enego','Enego','','VI',1,'1840-01-01','2999-12-31'),
	(31020,'05','024',' 04','024040',24040,'Fara Vicentino','Fara Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31021,'05','024',' 04','024041',24041,'Foza','Foza','','VI',1,'1840-01-01','2999-12-31'),
	(31022,'05','024',' 04','024042',24042,'Gallio','Gallio','','VI',1,'1840-01-01','2999-12-31'),
	(31023,'05','024',' 04','024043',24043,'Gambellara','Gambellara','','VI',1,'1840-01-01','2999-12-31'),
	(31024,'05','024',' 04','024044',24044,'Gambugliano','Gambugliano','','VI',1,'1840-01-01','2999-12-31'),
	(31025,'05','024',' 04','024045',24045,'Grancona','Grancona','','VI',1,'1840-01-01','2999-12-31'),
	(31026,'05','024',' 04','024046',24046,'Grisignano di Zocco','Grisignano di Zocco','','VI',1,'1840-01-01','2999-12-31'),
	(31027,'05','024',' 04','024047',24047,'Grumolo delle Abbadesse','Grumolo delle Abbadesse','','VI',1,'1840-01-01','2999-12-31'),
	(31028,'05','024',' 04','024048',24048,'Isola Vicentina','Isola Vicentina','','VI',1,'1840-01-01','2999-12-31'),
	(31029,'05','024',' 04','024049',24049,'Laghi','Laghi','','VI',1,'1840-01-01','2999-12-31'),
	(31030,'05','024',' 05','024050',24050,'Lastebasse','Lastebasse','','VI',1,'1840-01-01','2999-12-31'),
	(31031,'05','024',' 05','024051',24051,'Longare','Longare','','VI',1,'1840-01-01','2999-12-31'),
	(31032,'05','024',' 05','024052',24052,'Lonigo','Lonigo','','VI',1,'1840-01-01','2999-12-31'),
	(31033,'05','024',' 05','024053',24053,'Lugo di Vicenza','Lugo di Vicenza','','VI',1,'1840-01-01','2999-12-31'),
	(31034,'05','024',' 05','024054',24054,'Lusiana','Lusiana','','VI',1,'1840-01-01','2999-12-31'),
	(31035,'05','024',' 05','024055',24055,'Malo','Malo','','VI',1,'1840-01-01','2999-12-31'),
	(31036,'05','024',' 05','024056',24056,'Marano Vicentino','Marano Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31037,'05','024',' 05','024057',24057,'Marostica','Marostica','','VI',1,'1840-01-01','2999-12-31'),
	(31038,'05','024',' 05','024058',24058,'Mason Vicentino','Mason Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31039,'05','024',' 05','024059',24059,'Molvena','Molvena','','VI',1,'1840-01-01','2999-12-31'),
	(31040,'05','024',' 06','024060',24060,'Montebello Vicentino','Montebello Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31041,'05','024',' 06','024061',24061,'Montecchio Maggiore','Montecchio Maggiore','','VI',1,'1840-01-01','2999-12-31'),
	(31042,'05','024',' 06','024062',24062,'Montecchio Precalcino','Montecchio Precalcino','','VI',1,'1840-01-01','2999-12-31'),
	(31043,'05','024',' 06','024063',24063,'Monte di Malo','Monte di Malo','','VI',1,'1840-01-01','2999-12-31'),
	(31044,'05','024',' 06','024064',24064,'Montegalda','Montegalda','','VI',1,'1840-01-01','2999-12-31'),
	(31045,'05','024',' 06','024065',24065,'Montegaldella','Montegaldella','','VI',1,'1840-01-01','2999-12-31'),
	(31046,'05','024',' 06','024066',24066,'Monteviale','Monteviale','','VI',1,'1840-01-01','2999-12-31'),
	(31047,'05','024',' 06','024067',24067,'Monticello Conte Otto','Monticello Conte Otto','','VI',1,'1840-01-01','2999-12-31'),
	(31048,'05','024',' 06','024068',24068,'Montorso Vicentino','Montorso Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31049,'05','024',' 06','024069',24069,'Mossano','Mossano','','VI',1,'1840-01-01','2999-12-31'),
	(31050,'05','024',' 07','024070',24070,'Mussolente','Mussolente','','VI',1,'1840-01-01','2999-12-31'),
	(31051,'05','024',' 07','024071',24071,'Nanto','Nanto','','VI',1,'1840-01-01','2999-12-31'),
	(31052,'05','024',' 07','024072',24072,'Nogarole Vicentino','Nogarole Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31053,'05','024',' 07','024073',24073,'Nove','Nove','','VI',1,'1840-01-01','2999-12-31'),
	(31054,'05','024',' 07','024074',24074,'Noventa Vicentina','Noventa Vicentina','','VI',1,'1840-01-01','2999-12-31'),
	(31055,'05','024',' 07','024075',24075,'Orgiano','Orgiano','','VI',1,'1840-01-01','2999-12-31'),
	(31056,'05','024',' 07','024076',24076,'Pedemonte','Pedemonte','','VI',1,'1840-01-01','2999-12-31'),
	(31057,'05','024',' 07','024077',24077,'Pianezze','Pianezze','','VI',1,'1840-01-01','2999-12-31'),
	(31058,'05','024',' 07','024078',24078,'Piovene Rocchette','Piovene Rocchette','','VI',1,'1840-01-01','2999-12-31'),
	(31059,'05','024',' 07','024079',24079,'Pojana Maggiore','Pojana Maggiore','','VI',1,'1840-01-01','2999-12-31'),
	(31060,'05','024',' 08','024080',24080,'Posina','Posina','','VI',1,'1840-01-01','2999-12-31'),
	(31061,'05','024',' 08','024081',24081,'Pove del Grappa','Pove del Grappa','','VI',1,'1840-01-01','2999-12-31'),
	(31062,'05','024',' 08','024082',24082,'Pozzoleone','Pozzoleone','','VI',1,'1840-01-01','2999-12-31'),
	(31063,'05','024',' 08','024083',24083,'Quinto Vicentino','Quinto Vicentino','','VI',1,'1840-01-01','2999-12-31'),
	(31064,'05','024',' 08','024084',24084,'Recoaro Terme','Recoaro Terme','','VI',1,'1840-01-01','2999-12-31'),
	(31065,'05','024',' 08','024085',24085,'Roana','Roana','','VI',1,'1840-01-01','2999-12-31'),
	(31066,'05','024',' 08','024086',24086,'Romano d\'Ezzelino','Romano d\'Ezzelino','','VI',1,'1840-01-01','2999-12-31'),
	(31067,'05','024',' 08','024087',24087,'Rosà','Rosà','','VI',1,'1840-01-01','2999-12-31'),
	(31068,'05','024',' 08','024088',24088,'Rossano Veneto','Rossano Veneto','','VI',1,'1840-01-01','2999-12-31'),
	(31069,'05','024',' 08','024089',24089,'Rotzo','Rotzo','','VI',1,'1840-01-01','2999-12-31'),
	(31070,'05','024',' 09','024090',24090,'Salcedo','Salcedo','','VI',1,'1840-01-01','2999-12-31'),
	(31071,'05','024',' 09','024091',24091,'Sandrigo','Sandrigo','','VI',1,'1840-01-01','2999-12-31'),
	(31072,'05','024',' 09','024092',24092,'San Germano dei Berici','San Germano dei Berici','','VI',1,'1840-01-01','2999-12-31'),
	(31073,'05','024',' 09','024093',24093,'San Nazario','San Nazario','','VI',1,'1840-01-01','2999-12-31'),
	(31074,'05','024',' 09','024094',24094,'San Pietro Mussolino','San Pietro Mussolino','','VI',1,'1840-01-01','2999-12-31'),
	(31075,'05','024',' 09','024095',24095,'Santorso','Santorso','','VI',1,'1840-01-01','2999-12-31'),
	(31076,'05','024',' 09','024096',24096,'San Vito di Leguzzano','San Vito di Leguzzano','','VI',1,'1840-01-01','2999-12-31'),
	(31077,'05','024',' 09','024097',24097,'Sarcedo','Sarcedo','','VI',1,'1840-01-01','2999-12-31'),
	(31078,'05','024',' 09','024098',24098,'Sarego','Sarego','','VI',1,'1840-01-01','2999-12-31'),
	(31079,'05','024',' 09','024099',24099,'Schiavon','Schiavon','','VI',1,'1840-01-01','2999-12-31'),
	(31080,'05','024',' 10','024100',24100,'Schio','Schio','','VI',1,'1840-01-01','2999-12-31'),
	(31081,'05','024',' 10','024101',24101,'Solagna','Solagna','','VI',1,'1840-01-01','2999-12-31'),
	(31082,'05','024',' 10','024102',24102,'Sossano','Sossano','','VI',1,'1840-01-01','2999-12-31'),
	(31083,'05','024',' 10','024103',24103,'Sovizzo','Sovizzo','','VI',1,'1840-01-01','2999-12-31'),
	(31084,'05','024',' 10','024104',24104,'Tezze sul Brenta','Tezze sul Brenta','','VI',1,'1840-01-01','2999-12-31'),
	(31085,'05','024',' 10','024105',24105,'Thiene','Thiene','','VI',1,'1840-01-01','2999-12-31'),
	(31086,'05','024',' 10','024106',24106,'Tonezza del Cimone','Tonezza del Cimone','','VI',1,'1840-01-01','2999-12-31'),
	(31087,'05','024',' 10','024107',24107,'Torrebelvicino','Torrebelvicino','','VI',1,'1840-01-01','2999-12-31'),
	(31088,'05','024',' 10','024108',24108,'Torri di Quartesolo','Torri di Quartesolo','','VI',1,'1840-01-01','2999-12-31'),
	(31089,'05','024',' 11','024110',24110,'Trissino','Trissino','','VI',1,'1840-01-01','2999-12-31'),
	(31090,'05','024',' 11','024111',24111,'Valdagno','Valdagno','','VI',1,'1840-01-01','2999-12-31'),
	(31091,'05','024',' 11','024112',24112,'Valdastico','Valdastico','','VI',1,'1840-01-01','2999-12-31'),
	(31092,'05','024',' 11','024113',24113,'Valli del Pasubio','Valli del Pasubio','','VI',1,'1840-01-01','2999-12-31'),
	(31093,'05','024',' 11','024114',24114,'Valstagna','Valstagna','','VI',1,'1840-01-01','2999-12-31'),
	(31094,'05','024',' 11','024115',24115,'Velo d\'Astico','Velo d\'Astico','','VI',1,'1840-01-01','2999-12-31'),
	(31095,'05','024',' 11','024116',24116,'Vicenza','Vicenza','','VI',1,'1840-01-01','2999-12-31'),
	(31096,'05','024',' 11','024117',24117,'Villaga','Villaga','','VI',1,'1840-01-01','2999-12-31'),
	(31097,'05','024',' 11','024118',24118,'Villaverla','Villaverla','','VI',1,'1840-01-01','2999-12-31'),
	(31098,'05','024',' 11','024119',24119,'Zanè','Zanè','','VI',1,'1840-01-01','2999-12-31'),
	(31099,'05','024',' 12','024120',24120,'Zermeghedo','Zermeghedo','','VI',1,'1840-01-01','2999-12-31'),
	(31100,'05','024',' 12','024121',24121,'Zovencedo','Zovencedo','','VI',1,'1840-01-01','2999-12-31'),
	(31101,'05','024',' 12','024122',24122,'Zugliano','Zugliano','','VI',1,'1840-01-01','2999-12-31'),
	(31102,'05','025',' 00','025001',25001,'Agordo','Agordo','','BL',1,'1840-01-01','2999-12-31'),
	(31103,'05','025',' 00','025002',25002,'Alano di Piave','Alano di Piave','','BL',1,'1840-01-01','2999-12-31'),
	(31104,'05','025',' 00','025003',25003,'Alleghe','Alleghe','','BL',1,'1840-01-01','2999-12-31'),
	(31105,'05','025',' 00','025004',25004,'Arsiè','Arsiè','','BL',1,'1840-01-01','2999-12-31'),
	(31106,'05','025',' 00','025005',25005,'Auronzo di Cadore','Auronzo di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31107,'05','025',' 00','025006',25006,'Belluno','Belluno','','BL',1,'1840-01-01','2999-12-31'),
	(31108,'05','025',' 00','025007',25007,'Borca di Cadore','Borca di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31109,'05','025',' 00','025008',25008,'Calalzo di Cadore','Calalzo di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31110,'05','025',' 00','025009',25009,'Castellavazzo','Castellavazzo','','BL',1,'1840-01-01','2999-12-31'),
	(31111,'05','025',' 01','025010',25010,'Cencenighe Agordino','Cencenighe Agordino','','BL',1,'1840-01-01','2999-12-31'),
	(31112,'05','025',' 01','025011',25011,'Cesiomaggiore','Cesiomaggiore','','BL',1,'1840-01-01','2999-12-31'),
	(31113,'05','025',' 01','025012',25012,'Chies d\'Alpago','Chies d\'Alpago','','BL',1,'1840-01-01','2999-12-31'),
	(31114,'05','025',' 01','025013',25013,'Cibiana di Cadore','Cibiana di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31115,'05','025',' 01','025014',25014,'Colle Santa Lucia','Colle Santa Lucia','','BL',1,'1840-01-01','2999-12-31'),
	(31116,'05','025',' 01','025015',25015,'Comelico Superiore','Comelico Superiore','','BL',1,'1840-01-01','2999-12-31'),
	(31117,'05','025',' 01','025016',25016,'Cortina d\'Ampezzo','Cortina d\'Ampezzo','','BL',1,'1840-01-01','2999-12-31'),
	(31118,'05','025',' 01','025017',25017,'Danta di Cadore','Danta di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31119,'05','025',' 01','025018',25018,'Domegge di Cadore','Domegge di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31120,'05','025',' 01','025019',25019,'Falcade','Falcade','','BL',1,'1840-01-01','2999-12-31'),
	(31121,'05','025',' 02','025020',25020,'Farra d\'Alpago','Farra d\'Alpago','','BL',1,'1840-01-01','2999-12-31'),
	(31122,'05','025',' 02','025021',25021,'Feltre','Feltre','','BL',1,'1840-01-01','2999-12-31'),
	(31123,'05','025',' 02','025022',25022,'Fonzaso','Fonzaso','','BL',1,'1840-01-01','2999-12-31'),
	(31124,'05','025',' 02','025023',25023,'Canale d\'Agordo','Canale d\'Agordo','','BL',1,'1840-01-01','2999-12-31'),
	(31125,'05','025',' 02','025024',25024,'Forno di Zoldo','Forno di Zoldo','','BL',1,'1840-01-01','2999-12-31'),
	(31126,'05','025',' 02','025025',25025,'Gosaldo','Gosaldo','','BL',1,'1840-01-01','2999-12-31'),
	(31127,'05','025',' 02','025026',25026,'Lamon','Lamon','','BL',1,'1840-01-01','2999-12-31'),
	(31128,'05','025',' 02','025027',25027,'La Valle Agordina','La Valle Agordina','','BL',1,'1840-01-01','2999-12-31'),
	(31129,'05','025',' 02','025028',25028,'Lentiai','Lentiai','','BL',1,'1840-01-01','2999-12-31'),
	(31130,'05','025',' 02','025029',25029,'Limana','Limana','','BL',1,'1840-01-01','2999-12-31'),
	(31131,'05','025',' 03','025030',25030,'Livinallongo del Col di Lana','Livinallongo del Col di Lana','','BL',1,'1840-01-01','2999-12-31'),
	(31132,'05','025',' 03','025031',25031,'Longarone','Longarone','','BL',1,'1840-01-01','2999-12-31'),
	(31133,'05','025',' 03','025032',25032,'Lorenzago di Cadore','Lorenzago di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31134,'05','025',' 03','025033',25033,'Lozzo di Cadore','Lozzo di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31135,'05','025',' 03','025034',25034,'Mel','Mel','','BL',1,'1840-01-01','2999-12-31'),
	(31136,'05','025',' 03','025035',25035,'Ospitale di Cadore','Ospitale di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31137,'05','025',' 03','025036',25036,'Pedavena','Pedavena','','BL',1,'1840-01-01','2999-12-31'),
	(31138,'05','025',' 03','025037',25037,'Perarolo di Cadore','Perarolo di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31139,'05','025',' 03','025038',25038,'Pieve d\'Alpago','Pieve d\'Alpago','','BL',1,'1840-01-01','2999-12-31'),
	(31140,'05','025',' 03','025039',25039,'Pieve di Cadore','Pieve di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31141,'05','025',' 04','025040',25040,'Ponte nelle Alpi','Ponte nelle Alpi','','BL',1,'1840-01-01','2999-12-31'),
	(31142,'05','025',' 04','025041',25041,'Puos d\'Alpago','Puos d\'Alpago','','BL',1,'1840-01-01','2999-12-31'),
	(31143,'05','025',' 04','025042',25042,'Quero','Quero','','BL',1,'1840-01-01','2999-12-31'),
	(31144,'05','025',' 04','025043',25043,'Rivamonte Agordino','Rivamonte Agordino','','BL',1,'1840-01-01','2999-12-31'),
	(31145,'05','025',' 04','025044',25044,'Rocca Pietore','Rocca Pietore','','BL',1,'1840-01-01','2999-12-31'),
	(31146,'05','025',' 04','025045',25045,'San Gregorio nelle Alpi','San Gregorio nelle Alpi','','BL',1,'1840-01-01','2999-12-31'),
	(31147,'05','025',' 04','025046',25046,'San Nicolò di Comelico','San Nicolò di Comelico','','BL',1,'1840-01-01','2999-12-31'),
	(31148,'05','025',' 04','025047',25047,'San Pietro di Cadore','San Pietro di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31149,'05','025',' 04','025048',25048,'Santa Giustina','Santa Giustina','','BL',1,'1840-01-01','2999-12-31'),
	(31150,'05','025',' 04','025049',25049,'San Tomaso Agordino','San Tomaso Agordino','','BL',1,'1840-01-01','2999-12-31'),
	(31151,'05','025',' 05','025050',25050,'Santo Stefano di Cadore','Santo Stefano di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31152,'05','025',' 05','025051',25051,'San Vito di Cadore','San Vito di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31153,'05','025',' 05','025052',25052,'Sappada','Sappada','','BL',1,'1840-01-01','2999-12-31'),
	(31154,'05','025',' 05','025053',25053,'Sedico','Sedico','','BL',1,'1840-01-01','2999-12-31'),
	(31155,'05','025',' 05','025054',25054,'Selva di Cadore','Selva di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31156,'05','025',' 05','025055',25055,'Seren del Grappa','Seren del Grappa','','BL',1,'1840-01-01','2999-12-31'),
	(31157,'05','025',' 05','025056',25056,'Sospirolo','Sospirolo','','BL',1,'1840-01-01','2999-12-31'),
	(31158,'05','025',' 05','025057',25057,'Soverzene','Soverzene','','BL',1,'1840-01-01','2999-12-31'),
	(31159,'05','025',' 05','025058',25058,'Sovramonte','Sovramonte','','BL',1,'1840-01-01','2999-12-31'),
	(31160,'05','025',' 05','025059',25059,'Taibon Agordino','Taibon Agordino','','BL',1,'1840-01-01','2999-12-31'),
	(31161,'05','025',' 06','025060',25060,'Tambre','Tambre','','BL',1,'1840-01-01','2999-12-31'),
	(31162,'05','025',' 06','025061',25061,'Trichiana','Trichiana','','BL',1,'1840-01-01','2999-12-31'),
	(31163,'05','025',' 06','025062',25062,'Vallada Agordina','Vallada Agordina','','BL',1,'1840-01-01','2999-12-31'),
	(31164,'05','025',' 06','025063',25063,'Valle di Cadore','Valle di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31165,'05','025',' 06','025064',25064,'Vas','Vas','','BL',1,'1840-01-01','2999-12-31'),
	(31166,'05','025',' 06','025065',25065,'Vigo di Cadore','Vigo di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31167,'05','025',' 06','025066',25066,'Vodo Cadore','Vodo Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31168,'05','025',' 06','025067',25067,'Voltago Agordino','Voltago Agordino','','BL',1,'1840-01-01','2999-12-31'),
	(31169,'05','025',' 06','025068',25068,'Zoldo Alto','Zoldo Alto','','BL',1,'1840-01-01','2999-12-31'),
	(31170,'05','025',' 06','025069',25069,'Zoppè di Cadore','Zoppè di Cadore','','BL',1,'1840-01-01','2999-12-31'),
	(31171,'05','026',' 00','026001',26001,'Altivole','Altivole','','TV',1,'1840-01-01','2999-12-31'),
	(31172,'05','026',' 00','026002',26002,'Arcade','Arcade','','TV',1,'1840-01-01','2999-12-31'),
	(31173,'05','026',' 00','026003',26003,'Asolo','Asolo','','TV',1,'1840-01-01','2999-12-31'),
	(31174,'05','026',' 00','026004',26004,'Borso del Grappa','Borso del Grappa','','TV',1,'1840-01-01','2999-12-31'),
	(31175,'05','026',' 00','026005',26005,'Breda di Piave','Breda di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31176,'05','026',' 00','026006',26006,'Caerano di San Marco','Caerano di San Marco','','TV',1,'1840-01-01','2999-12-31'),
	(31177,'05','026',' 00','026007',26007,'Cappella Maggiore','Cappella Maggiore','','TV',1,'1840-01-01','2999-12-31'),
	(31178,'05','026',' 00','026008',26008,'Carbonera','Carbonera','','TV',1,'1840-01-01','2999-12-31'),
	(31179,'05','026',' 00','026009',26009,'Casale sul Sile','Casale sul Sile','','TV',1,'1840-01-01','2999-12-31'),
	(31180,'05','026',' 01','026010',26010,'Casier','Casier','','TV',1,'1840-01-01','2999-12-31'),
	(31181,'05','026',' 01','026011',26011,'Castelcucco','Castelcucco','','TV',1,'1840-01-01','2999-12-31'),
	(31182,'05','026',' 01','026012',26012,'Castelfranco Veneto','Castelfranco Veneto','','TV',1,'1840-01-01','2999-12-31'),
	(31183,'05','026',' 01','026013',26013,'Castello di Godego','Castello di Godego','','TV',1,'1840-01-01','2999-12-31'),
	(31184,'05','026',' 01','026014',26014,'Cavaso del Tomba','Cavaso del Tomba','','TV',1,'1840-01-01','2999-12-31'),
	(31185,'05','026',' 01','026015',26015,'Cessalto','Cessalto','','TV',1,'1840-01-01','2999-12-31'),
	(31186,'05','026',' 01','026016',26016,'Chiarano','Chiarano','','TV',1,'1840-01-01','2999-12-31'),
	(31187,'05','026',' 01','026017',26017,'Cimadolmo','Cimadolmo','','TV',1,'1840-01-01','2999-12-31'),
	(31188,'05','026',' 01','026018',26018,'Cison di Valmarino','Cison di Valmarino','','TV',1,'1840-01-01','2999-12-31'),
	(31189,'05','026',' 01','026019',26019,'Codognè','Codognè','','TV',1,'1840-01-01','2999-12-31'),
	(31190,'05','026',' 02','026020',26020,'Colle Umberto','Colle Umberto','','TV',1,'1840-01-01','2999-12-31'),
	(31191,'05','026',' 02','026021',26021,'Conegliano','Conegliano','','TV',1,'1840-01-01','2999-12-31'),
	(31192,'05','026',' 02','026022',26022,'Cordignano','Cordignano','','TV',1,'1840-01-01','2999-12-31'),
	(31193,'05','026',' 02','026023',26023,'Cornuda','Cornuda','','TV',1,'1840-01-01','2999-12-31'),
	(31194,'05','026',' 02','026024',26024,'Crespano del Grappa','Crespano del Grappa','','TV',1,'1840-01-01','2999-12-31'),
	(31195,'05','026',' 02','026025',26025,'Crocetta del Montello','Crocetta del Montello','','TV',1,'1840-01-01','2999-12-31'),
	(31196,'05','026',' 02','026026',26026,'Farra di Soligo','Farra di Soligo','','TV',1,'1840-01-01','2999-12-31'),
	(31197,'05','026',' 02','026027',26027,'Follina','Follina','','TV',1,'1840-01-01','2999-12-31'),
	(31198,'05','026',' 02','026028',26028,'Fontanelle','Fontanelle','','TV',1,'1840-01-01','2999-12-31'),
	(31199,'05','026',' 02','026029',26029,'Fonte','Fonte','','TV',1,'1840-01-01','2999-12-31'),
	(31200,'05','026',' 03','026030',26030,'Fregona','Fregona','','TV',1,'1840-01-01','2999-12-31'),
	(31201,'05','026',' 03','026031',26031,'Gaiarine','Gaiarine','','TV',1,'1840-01-01','2999-12-31'),
	(31202,'05','026',' 03','026032',26032,'Giavera del Montello','Giavera del Montello','','TV',1,'1840-01-01','2999-12-31'),
	(31203,'05','026',' 03','026033',26033,'Godega di Sant\'Urbano','Godega di Sant\'Urbano','','TV',1,'1840-01-01','2999-12-31'),
	(31204,'05','026',' 03','026034',26034,'Gorgo al Monticano','Gorgo al Monticano','','TV',1,'1840-01-01','2999-12-31'),
	(31205,'05','026',' 03','026035',26035,'Istrana','Istrana','','TV',1,'1840-01-01','2999-12-31'),
	(31206,'05','026',' 03','026036',26036,'Loria','Loria','','TV',1,'1840-01-01','2999-12-31'),
	(31207,'05','026',' 03','026037',26037,'Mansuè','Mansuè','','TV',1,'1840-01-01','2999-12-31'),
	(31208,'05','026',' 03','026038',26038,'Mareno di Piave','Mareno di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31209,'05','026',' 03','026039',26039,'Maser','Maser','','TV',1,'1840-01-01','2999-12-31'),
	(31210,'05','026',' 04','026040',26040,'Maserada sul Piave','Maserada sul Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31211,'05','026',' 04','026041',26041,'Meduna di Livenza','Meduna di Livenza','','TV',1,'1840-01-01','2999-12-31'),
	(31212,'05','026',' 04','026042',26042,'Miane','Miane','','TV',1,'1840-01-01','2999-12-31'),
	(31213,'05','026',' 04','026043',26043,'Mogliano Veneto','Mogliano Veneto','','TV',1,'1840-01-01','2999-12-31'),
	(31214,'05','026',' 04','026044',26044,'Monastier di Treviso','Monastier di Treviso','','TV',1,'1840-01-01','2999-12-31'),
	(31215,'05','026',' 04','026045',26045,'Monfumo','Monfumo','','TV',1,'1840-01-01','2999-12-31'),
	(31216,'05','026',' 04','026046',26046,'Montebelluna','Montebelluna','','TV',1,'1840-01-01','2999-12-31'),
	(31217,'05','026',' 04','026047',26047,'Morgano','Morgano','','TV',1,'1840-01-01','2999-12-31'),
	(31218,'05','026',' 04','026048',26048,'Moriago della Battaglia','Moriago della Battaglia','','TV',1,'1840-01-01','2999-12-31'),
	(31219,'05','026',' 04','026049',26049,'Motta di Livenza','Motta di Livenza','','TV',1,'1840-01-01','2999-12-31'),
	(31220,'05','026',' 05','026050',26050,'Nervesa della Battaglia','Nervesa della Battaglia','','TV',1,'1840-01-01','2999-12-31'),
	(31221,'05','026',' 05','026051',26051,'Oderzo','Oderzo','','TV',1,'1840-01-01','2999-12-31'),
	(31222,'05','026',' 05','026052',26052,'Ormelle','Ormelle','','TV',1,'1840-01-01','2999-12-31'),
	(31223,'05','026',' 05','026053',26053,'Orsago','Orsago','','TV',1,'1840-01-01','2999-12-31'),
	(31224,'05','026',' 05','026054',26054,'Paderno del Grappa','Paderno del Grappa','','TV',1,'1840-01-01','2999-12-31'),
	(31225,'05','026',' 05','026055',26055,'Paese','Paese','','TV',1,'1840-01-01','2999-12-31'),
	(31226,'05','026',' 05','026056',26056,'Pederobba','Pederobba','','TV',1,'1840-01-01','2999-12-31'),
	(31227,'05','026',' 05','026057',26057,'Pieve di Soligo','Pieve di Soligo','','TV',1,'1840-01-01','2999-12-31'),
	(31228,'05','026',' 05','026058',26058,'Ponte di Piave','Ponte di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31229,'05','026',' 05','026059',26059,'Ponzano Veneto','Ponzano Veneto','','TV',1,'1840-01-01','2999-12-31'),
	(31230,'05','026',' 06','026060',26060,'Portobuffolè','Portobuffolè','','TV',1,'1840-01-01','2999-12-31'),
	(31231,'05','026',' 06','026061',26061,'Possagno','Possagno','','TV',1,'1840-01-01','2999-12-31'),
	(31232,'05','026',' 06','026062',26062,'Povegliano','Povegliano','','TV',1,'1840-01-01','2999-12-31'),
	(31233,'05','026',' 06','026063',26063,'Preganziol','Preganziol','','TV',1,'1840-01-01','2999-12-31'),
	(31234,'05','026',' 06','026064',26064,'Quinto di Treviso','Quinto di Treviso','','TV',1,'1840-01-01','2999-12-31'),
	(31235,'05','026',' 06','026065',26065,'Refrontolo','Refrontolo','','TV',1,'1840-01-01','2999-12-31'),
	(31236,'05','026',' 06','026066',26066,'Resana','Resana','','TV',1,'1840-01-01','2999-12-31'),
	(31237,'05','026',' 06','026067',26067,'Revine Lago','Revine Lago','','TV',1,'1840-01-01','2999-12-31'),
	(31238,'05','026',' 06','026068',26068,'Riese Pio X','Riese Pio X','','TV',1,'1840-01-01','2999-12-31'),
	(31239,'05','026',' 06','026069',26069,'Roncade','Roncade','','TV',1,'1840-01-01','2999-12-31'),
	(31240,'05','026',' 07','026070',26070,'Salgareda','Salgareda','','TV',1,'1840-01-01','2999-12-31'),
	(31241,'05','026',' 07','026071',26071,'San Biagio di Callalta','San Biagio di Callalta','','TV',1,'1840-01-01','2999-12-31'),
	(31242,'05','026',' 07','026072',26072,'San Fior','San Fior','','TV',1,'1840-01-01','2999-12-31'),
	(31243,'05','026',' 07','026073',26073,'San Pietro di Feletto','San Pietro di Feletto','','TV',1,'1840-01-01','2999-12-31'),
	(31244,'05','026',' 07','026074',26074,'San Polo di Piave','San Polo di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31245,'05','026',' 07','026075',26075,'Santa Lucia di Piave','Santa Lucia di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31246,'05','026',' 07','026076',26076,'San Vendemiano','San Vendemiano','','TV',1,'1840-01-01','2999-12-31'),
	(31247,'05','026',' 07','026077',26077,'San Zenone degli Ezzelini','San Zenone degli Ezzelini','','TV',1,'1840-01-01','2999-12-31'),
	(31248,'05','026',' 07','026078',26078,'Sarmede','Sarmede','','TV',1,'1840-01-01','2999-12-31'),
	(31249,'05','026',' 07','026079',26079,'Segusino','Segusino','','TV',1,'1840-01-01','2999-12-31'),
	(31250,'05','026',' 08','026080',26080,'Sernaglia della Battaglia','Sernaglia della Battaglia','','TV',1,'1840-01-01','2999-12-31'),
	(31251,'05','026',' 08','026081',26081,'Silea','Silea','','TV',1,'1840-01-01','2999-12-31'),
	(31252,'05','026',' 08','026082',26082,'Spresiano','Spresiano','','TV',1,'1840-01-01','2999-12-31'),
	(31253,'05','026',' 08','026083',26083,'Susegana','Susegana','','TV',1,'1840-01-01','2999-12-31'),
	(31254,'05','026',' 08','026084',26084,'Tarzo','Tarzo','','TV',1,'1840-01-01','2999-12-31'),
	(31255,'05','026',' 08','026085',26085,'Trevignano','Trevignano','','TV',1,'1840-01-01','2999-12-31'),
	(31256,'05','026',' 08','026086',26086,'Treviso','Treviso','','TV',1,'1840-01-01','2999-12-31'),
	(31257,'05','026',' 08','026087',26087,'Valdobbiadene','Valdobbiadene','','TV',1,'1840-01-01','2999-12-31'),
	(31258,'05','026',' 08','026088',26088,'Vazzola','Vazzola','','TV',1,'1840-01-01','2999-12-31'),
	(31259,'05','026',' 08','026089',26089,'Vedelago','Vedelago','','TV',1,'1840-01-01','2999-12-31'),
	(31260,'05','026',' 09','026090',26090,'Vidor','Vidor','','TV',1,'1840-01-01','2999-12-31'),
	(31261,'05','026',' 09','026091',26091,'Villorba','Villorba','','TV',1,'1840-01-01','2999-12-31'),
	(31262,'05','026',' 09','026092',26092,'Vittorio Veneto','Vittorio Veneto','','TV',1,'1840-01-01','2999-12-31'),
	(31263,'05','026',' 09','026093',26093,'Volpago del Montello','Volpago del Montello','','TV',1,'1840-01-01','2999-12-31'),
	(31264,'05','026',' 09','026094',26094,'Zenson di Piave','Zenson di Piave','','TV',1,'1840-01-01','2999-12-31'),
	(31265,'05','026',' 09','026095',26095,'Zero Branco','Zero Branco','','TV',1,'1840-01-01','2999-12-31'),
	(31266,'05','027',' 00','027001',27001,'Annone Veneto','Annone Veneto','','VE',1,'1840-01-01','2999-12-31'),
	(31267,'05','027',' 00','027002',27002,'Campagna Lupia','Campagna Lupia','','VE',1,'1840-01-01','2999-12-31'),
	(31268,'05','027',' 00','027003',27003,'Campolongo Maggiore','Campolongo Maggiore','','VE',1,'1840-01-01','2999-12-31'),
	(31269,'05','027',' 00','027004',27004,'Camponogara','Camponogara','','VE',1,'1840-01-01','2999-12-31'),
	(31270,'05','027',' 00','027005',27005,'Caorle','Caorle','','VE',1,'1840-01-01','2999-12-31'),
	(31271,'05','027',' 00','027006',27006,'Cavarzere','Cavarzere','','VE',1,'1840-01-01','2999-12-31'),
	(31272,'05','027',' 00','027007',27007,'Ceggia','Ceggia','','VE',1,'1840-01-01','2999-12-31'),
	(31273,'05','027',' 00','027008',27008,'Chioggia','Chioggia','','VE',1,'1840-01-01','2999-12-31'),
	(31274,'05','027',' 00','027009',27009,'Cinto Caomaggiore','Cinto Caomaggiore','','VE',1,'1840-01-01','2999-12-31'),
	(31275,'05','027',' 01','027010',27010,'Cona','Cona','','VE',1,'1840-01-01','2999-12-31'),
	(31276,'05','027',' 01','027011',27011,'Concordia Sagittaria','Concordia Sagittaria','','VE',1,'1840-01-01','2999-12-31'),
	(31277,'05','027',' 01','027012',27012,'Dolo','Dolo','','VE',1,'1840-01-01','2999-12-31'),
	(31278,'05','027',' 01','027013',27013,'Eraclea','Eraclea','','VE',1,'1840-01-01','2999-12-31'),
	(31279,'05','027',' 01','027014',27014,'Fiesso d\'Artico','Fiesso d\'Artico','','VE',1,'1840-01-01','2999-12-31'),
	(31280,'05','027',' 01','027015',27015,'Fossalta di Piave','Fossalta di Piave','','VE',1,'1840-01-01','2999-12-31'),
	(31281,'05','027',' 01','027016',27016,'Fossalta di Portogruaro','Fossalta di Portogruaro','','VE',1,'1840-01-01','2999-12-31'),
	(31282,'05','027',' 01','027017',27017,'Fossò','Fossò','','VE',1,'1840-01-01','2999-12-31'),
	(31283,'05','027',' 01','027018',27018,'Gruaro','Gruaro','','VE',1,'1840-01-01','2999-12-31'),
	(31284,'05','027',' 01','027019',27019,'Jesolo','Jesolo','','VE',1,'1840-01-01','2999-12-31'),
	(31285,'05','027',' 02','027020',27020,'Marcon','Marcon','','VE',1,'1840-01-01','2999-12-31'),
	(31286,'05','027',' 02','027021',27021,'Martellago','Martellago','','VE',1,'1840-01-01','2999-12-31'),
	(31287,'05','027',' 02','027022',27022,'Meolo','Meolo','','VE',1,'1840-01-01','2999-12-31'),
	(31288,'05','027',' 02','027023',27023,'Mira','Mira','','VE',1,'1840-01-01','2999-12-31'),
	(31289,'05','027',' 02','027024',27024,'Mirano','Mirano','','VE',1,'1840-01-01','2999-12-31'),
	(31290,'05','027',' 02','027025',27025,'Musile di Piave','Musile di Piave','','VE',1,'1840-01-01','2999-12-31'),
	(31291,'05','027',' 02','027026',27026,'Noale','Noale','','VE',1,'1840-01-01','2999-12-31'),
	(31292,'05','027',' 02','027027',27027,'Noventa di Piave','Noventa di Piave','','VE',1,'1840-01-01','2999-12-31'),
	(31293,'05','027',' 02','027028',27028,'Pianiga','Pianiga','','VE',1,'1840-01-01','2999-12-31'),
	(31294,'05','027',' 02','027029',27029,'Portogruaro','Portogruaro','','VE',1,'1840-01-01','2999-12-31'),
	(31295,'05','027',' 03','027030',27030,'Pramaggiore','Pramaggiore','','VE',1,'1840-01-01','2999-12-31'),
	(31296,'05','027',' 03','027031',27031,'Quarto d\'Altino','Quarto d\'Altino','','VE',1,'1840-01-01','2999-12-31'),
	(31297,'05','027',' 03','027032',27032,'Salzano','Salzano','','VE',1,'1840-01-01','2999-12-31'),
	(31298,'05','027',' 03','027033',27033,'San Donà di Piave','San Donà di Piave','','VE',1,'1840-01-01','2999-12-31'),
	(31299,'05','027',' 03','027034',27034,'San Michele al Tagliamento','San Michele al Tagliamento','','VE',1,'1840-01-01','2999-12-31'),
	(31300,'05','027',' 03','027035',27035,'Santa Maria di Sala','Santa Maria di Sala','','VE',1,'1840-01-01','2999-12-31'),
	(31301,'05','027',' 03','027036',27036,'Santo Stino di Livenza','Santo Stino di Livenza','','VE',1,'1840-01-01','2999-12-31'),
	(31302,'05','027',' 03','027037',27037,'Scorzè','Scorzè','','VE',1,'1840-01-01','2999-12-31'),
	(31303,'05','027',' 03','027038',27038,'Spinea','Spinea','','VE',1,'1840-01-01','2999-12-31'),
	(31304,'05','027',' 03','027039',27039,'Stra','Stra','','VE',1,'1840-01-01','2999-12-31'),
	(31305,'05','027',' 04','027040',27040,'Teglio Veneto','Teglio Veneto','','VE',1,'1840-01-01','2999-12-31'),
	(31306,'05','027',' 04','027041',27041,'Torre di Mosto','Torre di Mosto','','VE',1,'1840-01-01','2999-12-31'),
	(31307,'05','027',' 04','027042',27042,'Venezia','Venezia','','VE',1,'1840-01-01','2999-12-31'),
	(31308,'05','027',' 04','027043',27043,'Vigonovo','Vigonovo','','VE',1,'1840-01-01','2999-12-31'),
	(31309,'05','027',' 04','027044',27044,'Cavallino-Treporti','Cavallino-Treporti','','VE',1,'1840-01-01','2999-12-31'),
	(31310,'05','028',' 00','028001',28001,'Abano Terme','Abano Terme','','PD',1,'1840-01-01','2999-12-31'),
	(31311,'05','028',' 00','028002',28002,'Agna','Agna','','PD',1,'1840-01-01','2999-12-31'),
	(31312,'05','028',' 00','028003',28003,'Albignasego','Albignasego','','PD',1,'1840-01-01','2999-12-31'),
	(31313,'05','028',' 00','028004',28004,'Anguillara Veneta','Anguillara Veneta','','PD',1,'1840-01-01','2999-12-31'),
	(31314,'05','028',' 00','028005',28005,'Arquà Petrarca','Arquà Petrarca','','PD',1,'1840-01-01','2999-12-31'),
	(31315,'05','028',' 00','028006',28006,'Arre','Arre','','PD',1,'1840-01-01','2999-12-31'),
	(31316,'05','028',' 00','028007',28007,'Arzergrande','Arzergrande','','PD',1,'1840-01-01','2999-12-31'),
	(31317,'05','028',' 00','028008',28008,'Bagnoli di Sopra','Bagnoli di Sopra','','PD',1,'1840-01-01','2999-12-31'),
	(31318,'05','028',' 00','028009',28009,'Baone','Baone','','PD',1,'1840-01-01','2999-12-31'),
	(31319,'05','028',' 01','028010',28010,'Barbona','Barbona','','PD',1,'1840-01-01','2999-12-31'),
	(31320,'05','028',' 01','028011',28011,'Battaglia Terme','Battaglia Terme','','PD',1,'1840-01-01','2999-12-31'),
	(31321,'05','028',' 01','028012',28012,'Boara Pisani','Boara Pisani','','PD',1,'1840-01-01','2999-12-31'),
	(31322,'05','028',' 01','028013',28013,'Borgoricco','Borgoricco','','PD',1,'1840-01-01','2999-12-31'),
	(31323,'05','028',' 01','028014',28014,'Bovolenta','Bovolenta','','PD',1,'1840-01-01','2999-12-31'),
	(31324,'05','028',' 01','028015',28015,'Brugine','Brugine','','PD',1,'1840-01-01','2999-12-31'),
	(31325,'05','028',' 01','028016',28016,'Cadoneghe','Cadoneghe','','PD',1,'1840-01-01','2999-12-31'),
	(31326,'05','028',' 01','028017',28017,'Campodarsego','Campodarsego','','PD',1,'1840-01-01','2999-12-31'),
	(31327,'05','028',' 01','028018',28018,'Campodoro','Campodoro','','PD',1,'1840-01-01','2999-12-31'),
	(31328,'05','028',' 01','028019',28019,'Camposampiero','Camposampiero','','PD',1,'1840-01-01','2999-12-31'),
	(31329,'05','028',' 02','028020',28020,'Campo San Martino','Campo San Martino','','PD',1,'1840-01-01','2999-12-31'),
	(31330,'05','028',' 02','028021',28021,'Candiana','Candiana','','PD',1,'1840-01-01','2999-12-31'),
	(31331,'05','028',' 02','028022',28022,'Carceri','Carceri','','PD',1,'1840-01-01','2999-12-31'),
	(31332,'05','028',' 02','028023',28023,'Carmignano di Brenta','Carmignano di Brenta','','PD',1,'1840-01-01','2999-12-31'),
	(31333,'05','028',' 02','028026',28026,'Cartura','Cartura','','PD',1,'1840-01-01','2999-12-31'),
	(31334,'05','028',' 02','028027',28027,'Casale di Scodosia','Casale di Scodosia','','PD',1,'1840-01-01','2999-12-31'),
	(31335,'05','028',' 02','028028',28028,'Casalserugo','Casalserugo','','PD',1,'1840-01-01','2999-12-31'),
	(31336,'05','028',' 02','028029',28029,'Castelbaldo','Castelbaldo','','PD',1,'1840-01-01','2999-12-31'),
	(31337,'05','028',' 03','028030',28030,'Cervarese Santa Croce','Cervarese Santa Croce','','PD',1,'1840-01-01','2999-12-31'),
	(31338,'05','028',' 03','028031',28031,'Cinto Euganeo','Cinto Euganeo','','PD',1,'1840-01-01','2999-12-31'),
	(31339,'05','028',' 03','028032',28032,'Cittadella','Cittadella','','PD',1,'1840-01-01','2999-12-31'),
	(31340,'05','028',' 03','028033',28033,'Codevigo','Codevigo','','PD',1,'1840-01-01','2999-12-31'),
	(31341,'05','028',' 03','028034',28034,'Conselve','Conselve','','PD',1,'1840-01-01','2999-12-31'),
	(31342,'05','028',' 03','028035',28035,'Correzzola','Correzzola','','PD',1,'1840-01-01','2999-12-31'),
	(31343,'05','028',' 03','028036',28036,'Curtarolo','Curtarolo','','PD',1,'1840-01-01','2999-12-31'),
	(31344,'05','028',' 03','028037',28037,'Este','Este','','PD',1,'1840-01-01','2999-12-31'),
	(31345,'05','028',' 03','028038',28038,'Fontaniva','Fontaniva','','PD',1,'1840-01-01','2999-12-31'),
	(31346,'05','028',' 03','028039',28039,'Galliera Veneta','Galliera Veneta','','PD',1,'1840-01-01','2999-12-31'),
	(31347,'05','028',' 04','028040',28040,'Galzignano Terme','Galzignano Terme','','PD',1,'1840-01-01','2999-12-31'),
	(31348,'05','028',' 04','028041',28041,'Gazzo','Gazzo','','PD',1,'1840-01-01','2999-12-31'),
	(31349,'05','028',' 04','028042',28042,'Grantorto','Grantorto','','PD',1,'1840-01-01','2999-12-31'),
	(31350,'05','028',' 04','028043',28043,'Granze','Granze','','PD',1,'1840-01-01','2999-12-31'),
	(31351,'05','028',' 04','028044',28044,'Legnaro','Legnaro','','PD',1,'1840-01-01','2999-12-31'),
	(31352,'05','028',' 04','028045',28045,'Limena','Limena','','PD',1,'1840-01-01','2999-12-31'),
	(31353,'05','028',' 04','028046',28046,'Loreggia','Loreggia','','PD',1,'1840-01-01','2999-12-31'),
	(31354,'05','028',' 04','028047',28047,'Lozzo Atestino','Lozzo Atestino','','PD',1,'1840-01-01','2999-12-31'),
	(31355,'05','028',' 04','028048',28048,'Maserà di Padova','Maserà di Padova','','PD',1,'1840-01-01','2999-12-31'),
	(31356,'05','028',' 04','028049',28049,'Masi','Masi','','PD',1,'1840-01-01','2999-12-31'),
	(31357,'05','028',' 05','028050',28050,'Massanzago','Massanzago','','PD',1,'1840-01-01','2999-12-31'),
	(31358,'05','028',' 05','028051',28051,'Megliadino San Fidenzio','Megliadino San Fidenzio','','PD',1,'1840-01-01','2999-12-31'),
	(31359,'05','028',' 05','028052',28052,'Megliadino San Vitale','Megliadino San Vitale','','PD',1,'1840-01-01','2999-12-31'),
	(31360,'05','028',' 05','028053',28053,'Merlara','Merlara','','PD',1,'1840-01-01','2999-12-31'),
	(31361,'05','028',' 05','028054',28054,'Mestrino','Mestrino','','PD',1,'1840-01-01','2999-12-31'),
	(31362,'05','028',' 05','028055',28055,'Monselice','Monselice','','PD',1,'1840-01-01','2999-12-31'),
	(31363,'05','028',' 05','028056',28056,'Montagnana','Montagnana','','PD',1,'1840-01-01','2999-12-31'),
	(31364,'05','028',' 05','028057',28057,'Montegrotto Terme','Montegrotto Terme','','PD',1,'1840-01-01','2999-12-31'),
	(31365,'05','028',' 05','028058',28058,'Noventa Padovana','Noventa Padovana','','PD',1,'1840-01-01','2999-12-31'),
	(31366,'05','028',' 05','028059',28059,'Ospedaletto Euganeo','Ospedaletto Euganeo','','PD',1,'1840-01-01','2999-12-31'),
	(31367,'05','028',' 06','028060',28060,'Padova','Padova','','PD',1,'1840-01-01','2999-12-31'),
	(31368,'05','028',' 06','028061',28061,'Pernumia','Pernumia','','PD',1,'1840-01-01','2999-12-31'),
	(31369,'05','028',' 06','028062',28062,'Piacenza d\'Adige','Piacenza d\'Adige','','PD',1,'1840-01-01','2999-12-31'),
	(31370,'05','028',' 06','028063',28063,'Piazzola sul Brenta','Piazzola sul Brenta','','PD',1,'1840-01-01','2999-12-31'),
	(31371,'05','028',' 06','028064',28064,'Piombino Dese','Piombino Dese','','PD',1,'1840-01-01','2999-12-31'),
	(31372,'05','028',' 06','028065',28065,'Piove di Sacco','Piove di Sacco','','PD',1,'1840-01-01','2999-12-31'),
	(31373,'05','028',' 06','028066',28066,'Polverara','Polverara','','PD',1,'1840-01-01','2999-12-31'),
	(31374,'05','028',' 06','028067',28067,'Ponso','Ponso','','PD',1,'1840-01-01','2999-12-31'),
	(31375,'05','028',' 06','028068',28068,'Pontelongo','Pontelongo','','PD',1,'1840-01-01','2999-12-31'),
	(31376,'05','028',' 06','028069',28069,'Ponte San Nicolò','Ponte San Nicolò','','PD',1,'1840-01-01','2999-12-31'),
	(31377,'05','028',' 07','028070',28070,'Pozzonovo','Pozzonovo','','PD',1,'1840-01-01','2999-12-31'),
	(31378,'05','028',' 07','028071',28071,'Rovolon','Rovolon','','PD',1,'1840-01-01','2999-12-31'),
	(31379,'05','028',' 07','028072',28072,'Rubano','Rubano','','PD',1,'1840-01-01','2999-12-31'),
	(31380,'05','028',' 07','028073',28073,'Saccolongo','Saccolongo','','PD',1,'1840-01-01','2999-12-31'),
	(31381,'05','028',' 07','028074',28074,'Saletto','Saletto','','PD',1,'1840-01-01','2999-12-31'),
	(31382,'05','028',' 07','028075',28075,'San Giorgio delle Pertiche','San Giorgio delle Pertiche','','PD',1,'1840-01-01','2999-12-31'),
	(31383,'05','028',' 07','028076',28076,'San Giorgio in Bosco','San Giorgio in Bosco','','PD',1,'1840-01-01','2999-12-31'),
	(31384,'05','028',' 07','028077',28077,'San Martino di Lupari','San Martino di Lupari','','PD',1,'1840-01-01','2999-12-31'),
	(31385,'05','028',' 07','028078',28078,'San Pietro in Gu','San Pietro in Gu','','PD',1,'1840-01-01','2999-12-31'),
	(31386,'05','028',' 07','028079',28079,'San Pietro Viminario','San Pietro Viminario','','PD',1,'1840-01-01','2999-12-31'),
	(31387,'05','028',' 08','028080',28080,'Santa Giustina in Colle','Santa Giustina in Colle','','PD',1,'1840-01-01','2999-12-31'),
	(31388,'05','028',' 08','028081',28081,'Santa Margherita d\'Adige','Santa Margherita d\'Adige','','PD',1,'1840-01-01','2999-12-31'),
	(31389,'05','028',' 08','028082',28082,'Sant\'Angelo di Piove di Sacco','Sant\'Angelo di Piove di Sacco','','PD',1,'1840-01-01','2999-12-31'),
	(31390,'05','028',' 08','028083',28083,'Sant\'Elena','Sant\'Elena','','PD',1,'1840-01-01','2999-12-31'),
	(31391,'05','028',' 08','028084',28084,'Sant\'Urbano','Sant\'Urbano','','PD',1,'1840-01-01','2999-12-31'),
	(31392,'05','028',' 08','028085',28085,'Saonara','Saonara','','PD',1,'1840-01-01','2999-12-31'),
	(31393,'05','028',' 08','028086',28086,'Selvazzano Dentro','Selvazzano Dentro','','PD',1,'1840-01-01','2999-12-31'),
	(31394,'05','028',' 08','028087',28087,'Solesino','Solesino','','PD',1,'1840-01-01','2999-12-31'),
	(31395,'05','028',' 08','028088',28088,'Stanghella','Stanghella','','PD',1,'1840-01-01','2999-12-31'),
	(31396,'05','028',' 08','028089',28089,'Teolo','Teolo','','PD',1,'1840-01-01','2999-12-31'),
	(31397,'05','028',' 09','028090',28090,'Terrassa Padovana','Terrassa Padovana','','PD',1,'1840-01-01','2999-12-31'),
	(31398,'05','028',' 09','028091',28091,'Tombolo','Tombolo','','PD',1,'1840-01-01','2999-12-31'),
	(31399,'05','028',' 09','028092',28092,'Torreglia','Torreglia','','PD',1,'1840-01-01','2999-12-31'),
	(31400,'05','028',' 09','028093',28093,'Trebaseleghe','Trebaseleghe','','PD',1,'1840-01-01','2999-12-31'),
	(31401,'05','028',' 09','028094',28094,'Tribano','Tribano','','PD',1,'1840-01-01','2999-12-31'),
	(31402,'05','028',' 09','028095',28095,'Urbana','Urbana','','PD',1,'1840-01-01','2999-12-31'),
	(31403,'05','028',' 09','028096',28096,'Veggiano','Veggiano','','PD',1,'1840-01-01','2999-12-31'),
	(31404,'05','028',' 09','028097',28097,'Vescovana','Vescovana','','PD',1,'1840-01-01','2999-12-31'),
	(31405,'05','028',' 09','028098',28098,'Vighizzolo d\'Este','Vighizzolo d\'Este','','PD',1,'1840-01-01','2999-12-31'),
	(31406,'05','028',' 09','028099',28099,'Vigodarzere','Vigodarzere','','PD',1,'1840-01-01','2999-12-31'),
	(31407,'05','028',' 10','028100',28100,'Vigonza','Vigonza','','PD',1,'1840-01-01','2999-12-31'),
	(31408,'05','028',' 10','028101',28101,'Villa del Conte','Villa del Conte','','PD',1,'1840-01-01','2999-12-31'),
	(31409,'05','028',' 10','028102',28102,'Villa Estense','Villa Estense','','PD',1,'1840-01-01','2999-12-31'),
	(31410,'05','028',' 10','028103',28103,'Villafranca Padovana','Villafranca Padovana','','PD',1,'1840-01-01','2999-12-31'),
	(31411,'05','028',' 10','028104',28104,'Villanova di Camposampiero','Villanova di Camposampiero','','PD',1,'1840-01-01','2999-12-31'),
	(31412,'05','028',' 10','028105',28105,'Vo\'','Vo\'','','PD',1,'1840-01-01','2999-12-31'),
	(31413,'05','028',' 10','028106',28106,'Due Carrare','Due Carrare','','PD',1,'1840-01-01','2999-12-31'),
	(31414,'05','029',' 00','029001',29001,'Adria','Adria','','RO',1,'1840-01-01','2999-12-31'),
	(31415,'05','029',' 00','029002',29002,'Ariano nel Polesine','Ariano nel Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31416,'05','029',' 00','029003',29003,'Arquà Polesine','Arquà Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31417,'05','029',' 00','029004',29004,'Badia Polesine','Badia Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31418,'05','029',' 00','029005',29005,'Bagnolo di Po','Bagnolo di Po','','RO',1,'1840-01-01','2999-12-31'),
	(31419,'05','029',' 00','029006',29006,'Bergantino','Bergantino','','RO',1,'1840-01-01','2999-12-31'),
	(31420,'05','029',' 00','029007',29007,'Bosaro','Bosaro','','RO',1,'1840-01-01','2999-12-31'),
	(31421,'05','029',' 00','029008',29008,'Calto','Calto','','RO',1,'1840-01-01','2999-12-31'),
	(31422,'05','029',' 00','029009',29009,'Canaro','Canaro','','RO',1,'1840-01-01','2999-12-31'),
	(31423,'05','029',' 01','029010',29010,'Canda','Canda','','RO',1,'1840-01-01','2999-12-31'),
	(31424,'05','029',' 01','029011',29011,'Castelguglielmo','Castelguglielmo','','RO',1,'1840-01-01','2999-12-31'),
	(31425,'05','029',' 01','029012',29012,'Castelmassa','Castelmassa','','RO',1,'1840-01-01','2999-12-31'),
	(31426,'05','029',' 01','029013',29013,'Castelnovo Bariano','Castelnovo Bariano','','RO',1,'1840-01-01','2999-12-31'),
	(31427,'05','029',' 01','029014',29014,'Ceneselli','Ceneselli','','RO',1,'1840-01-01','2999-12-31'),
	(31428,'05','029',' 01','029015',29015,'Ceregnano','Ceregnano','','RO',1,'1840-01-01','2999-12-31'),
	(31429,'05','029',' 01','029017',29017,'Corbola','Corbola','','RO',1,'1840-01-01','2999-12-31'),
	(31430,'05','029',' 01','029018',29018,'Costa di Rovigo','Costa di Rovigo','','RO',1,'1840-01-01','2999-12-31'),
	(31431,'05','029',' 01','029019',29019,'Crespino','Crespino','','RO',1,'1840-01-01','2999-12-31'),
	(31432,'05','029',' 02','029021',29021,'Ficarolo','Ficarolo','','RO',1,'1840-01-01','2999-12-31'),
	(31433,'05','029',' 02','029022',29022,'Fiesso Umbertiano','Fiesso Umbertiano','','RO',1,'1840-01-01','2999-12-31'),
	(31434,'05','029',' 02','029023',29023,'Frassinelle Polesine','Frassinelle Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31435,'05','029',' 02','029024',29024,'Fratta Polesine','Fratta Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31436,'05','029',' 02','029025',29025,'Gaiba','Gaiba','','RO',1,'1840-01-01','2999-12-31'),
	(31437,'05','029',' 02','029026',29026,'Gavello','Gavello','','RO',1,'1840-01-01','2999-12-31'),
	(31438,'05','029',' 02','029027',29027,'Giacciano con Baruchella','Giacciano con Baruchella','','RO',1,'1840-01-01','2999-12-31'),
	(31439,'05','029',' 02','029028',29028,'Guarda Veneta','Guarda Veneta','','RO',1,'1840-01-01','2999-12-31'),
	(31440,'05','029',' 02','029029',29029,'Lendinara','Lendinara','','RO',1,'1840-01-01','2999-12-31'),
	(31441,'05','029',' 03','029030',29030,'Loreo','Loreo','','RO',1,'1840-01-01','2999-12-31'),
	(31442,'05','029',' 03','029031',29031,'Lusia','Lusia','','RO',1,'1840-01-01','2999-12-31'),
	(31443,'05','029',' 03','029032',29032,'Melara','Melara','','RO',1,'1840-01-01','2999-12-31'),
	(31444,'05','029',' 03','029033',29033,'Occhiobello','Occhiobello','','RO',1,'1840-01-01','2999-12-31'),
	(31445,'05','029',' 03','029034',29034,'Papozze','Papozze','','RO',1,'1840-01-01','2999-12-31'),
	(31446,'05','029',' 03','029035',29035,'Pettorazza Grimani','Pettorazza Grimani','','RO',1,'1840-01-01','2999-12-31'),
	(31447,'05','029',' 03','029036',29036,'Pincara','Pincara','','RO',1,'1840-01-01','2999-12-31'),
	(31448,'05','029',' 03','029037',29037,'Polesella','Polesella','','RO',1,'1840-01-01','2999-12-31'),
	(31449,'05','029',' 03','029038',29038,'Pontecchio Polesine','Pontecchio Polesine','','RO',1,'1840-01-01','2999-12-31'),
	(31450,'05','029',' 03','029039',29039,'Porto Tolle','Porto Tolle','','RO',1,'1840-01-01','2999-12-31'),
	(31451,'05','029',' 04','029040',29040,'Rosolina','Rosolina','','RO',1,'1840-01-01','2999-12-31'),
	(31452,'05','029',' 04','029041',29041,'Rovigo','Rovigo','','RO',1,'1840-01-01','2999-12-31'),
	(31453,'05','029',' 04','029042',29042,'Salara','Salara','','RO',1,'1840-01-01','2999-12-31'),
	(31454,'05','029',' 04','029043',29043,'San Bellino','San Bellino','','RO',1,'1840-01-01','2999-12-31'),
	(31455,'05','029',' 04','029044',29044,'San Martino di Venezze','San Martino di Venezze','','RO',1,'1840-01-01','2999-12-31'),
	(31456,'05','029',' 04','029045',29045,'Stienta','Stienta','','RO',1,'1840-01-01','2999-12-31'),
	(31457,'05','029',' 04','029046',29046,'Taglio di Po','Taglio di Po','','RO',1,'1840-01-01','2999-12-31'),
	(31458,'05','029',' 04','029047',29047,'Trecenta','Trecenta','','RO',1,'1840-01-01','2999-12-31'),
	(31459,'05','029',' 04','029048',29048,'Villadose','Villadose','','RO',1,'1840-01-01','2999-12-31'),
	(31460,'05','029',' 04','029049',29049,'Villamarzana','Villamarzana','','RO',1,'1840-01-01','2999-12-31'),
	(31461,'05','029',' 05','029050',29050,'Villanova del Ghebbo','Villanova del Ghebbo','','RO',1,'1840-01-01','2999-12-31'),
	(31462,'05','029',' 05','029051',29051,'Villanova Marchesana','Villanova Marchesana','','RO',1,'1840-01-01','2999-12-31'),
	(31463,'05','029',' 05','029052',29052,'Porto Viro','Porto Viro','','RO',1,'1840-01-01','2999-12-31'),
	(31464,'06','030',' 00','030001',30001,'Aiello del Friuli','Aiello del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31465,'06','030',' 00','030002',30002,'Amaro','Amaro','','UD',1,'1840-01-01','2999-12-31'),
	(31466,'06','030',' 00','030003',30003,'Ampezzo','Ampezzo','','UD',1,'1840-01-01','2999-12-31'),
	(31467,'06','030',' 00','030004',30004,'Aquileia','Aquileia','','UD',1,'1840-01-01','2999-12-31'),
	(31468,'06','030',' 00','030005',30005,'Arta Terme','Arta Terme','','UD',1,'1840-01-01','2999-12-31'),
	(31469,'06','030',' 00','030006',30006,'Artegna','Artegna','','UD',1,'1840-01-01','2999-12-31'),
	(31470,'06','030',' 00','030007',30007,'Attimis','Attimis','','UD',1,'1840-01-01','2999-12-31'),
	(31471,'06','030',' 00','030008',30008,'Bagnaria Arsa','Bagnaria Arsa','','UD',1,'1840-01-01','2999-12-31'),
	(31472,'06','030',' 00','030009',30009,'Basiliano','Basiliano','','UD',1,'1840-01-01','2999-12-31'),
	(31473,'06','030',' 01','030010',30010,'Bertiolo','Bertiolo','','UD',1,'1840-01-01','2999-12-31'),
	(31474,'06','030',' 01','030011',30011,'Bicinicco','Bicinicco','','UD',1,'1840-01-01','2999-12-31'),
	(31475,'06','030',' 01','030012',30012,'Bordano','Bordano','','UD',1,'1840-01-01','2999-12-31'),
	(31476,'06','030',' 01','030013',30013,'Buja','Buja','','UD',1,'1840-01-01','2999-12-31'),
	(31477,'06','030',' 01','030014',30014,'Buttrio','Buttrio','','UD',1,'1840-01-01','2999-12-31'),
	(31478,'06','030',' 01','030015',30015,'Camino al Tagliamento','Camino al Tagliamento','','UD',1,'1840-01-01','2999-12-31'),
	(31479,'06','030',' 01','030016',30016,'Campoformido','Campoformido','','UD',1,'1840-01-01','2999-12-31'),
	(31480,'06','030',' 01','030018',30018,'Carlino','Carlino','','UD',1,'1840-01-01','2999-12-31'),
	(31481,'06','030',' 01','030019',30019,'Cassacco','Cassacco','','UD',1,'1840-01-01','2999-12-31'),
	(31482,'06','030',' 02','030020',30020,'Castions di Strada','Castions di Strada','','UD',1,'1840-01-01','2999-12-31'),
	(31483,'06','030',' 02','030021',30021,'Cavazzo Carnico','Cavazzo Carnico','','UD',1,'1840-01-01','2999-12-31'),
	(31484,'06','030',' 02','030022',30022,'Cercivento','Cercivento','','UD',1,'1840-01-01','2999-12-31'),
	(31485,'06','030',' 02','030023',30023,'Cervignano del Friuli','Cervignano del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31486,'06','030',' 02','030024',30024,'Chiopris-Viscone','Chiopris-Viscone','','UD',1,'1840-01-01','2999-12-31'),
	(31487,'06','030',' 02','030025',30025,'Chiusaforte','Chiusaforte','','UD',1,'1840-01-01','2999-12-31'),
	(31488,'06','030',' 02','030026',30026,'Cividale del Friuli','Cividale del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31489,'06','030',' 02','030027',30027,'Codroipo','Codroipo','','UD',1,'1840-01-01','2999-12-31'),
	(31490,'06','030',' 02','030028',30028,'Colloredo di Monte Albano','Colloredo di Monte Albano','','UD',1,'1840-01-01','2999-12-31'),
	(31491,'06','030',' 02','030029',30029,'Comeglians','Comeglians','','UD',1,'1840-01-01','2999-12-31'),
	(31492,'06','030',' 03','030030',30030,'Corno di Rosazzo','Corno di Rosazzo','','UD',1,'1840-01-01','2999-12-31'),
	(31493,'06','030',' 03','030031',30031,'Coseano','Coseano','','UD',1,'1840-01-01','2999-12-31'),
	(31494,'06','030',' 03','030032',30032,'Dignano','Dignano','','UD',1,'1840-01-01','2999-12-31'),
	(31495,'06','030',' 03','030033',30033,'Dogna','Dogna','','UD',1,'1840-01-01','2999-12-31'),
	(31496,'06','030',' 03','030034',30034,'Drenchia','Drenchia','','UD',1,'1840-01-01','2999-12-31'),
	(31497,'06','030',' 03','030035',30035,'Enemonzo','Enemonzo','','UD',1,'1840-01-01','2999-12-31'),
	(31498,'06','030',' 03','030036',30036,'Faedis','Faedis','','UD',1,'1840-01-01','2999-12-31'),
	(31499,'06','030',' 03','030037',30037,'Fagagna','Fagagna','','UD',1,'1840-01-01','2999-12-31'),
	(31500,'06','030',' 03','030038',30038,'Fiumicello','Fiumicello','','UD',1,'1840-01-01','2999-12-31'),
	(31501,'06','030',' 03','030039',30039,'Flaibano','Flaibano','','UD',1,'1840-01-01','2999-12-31'),
	(31502,'06','030',' 04','030040',30040,'Forni Avoltri','Forni Avoltri','','UD',1,'1840-01-01','2999-12-31'),
	(31503,'06','030',' 04','030041',30041,'Forni di Sopra','Forni di Sopra','','UD',1,'1840-01-01','2999-12-31'),
	(31504,'06','030',' 04','030042',30042,'Forni di Sotto','Forni di Sotto','','UD',1,'1840-01-01','2999-12-31'),
	(31505,'06','030',' 04','030043',30043,'Gemona del Friuli','Gemona del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31506,'06','030',' 04','030044',30044,'Gonars','Gonars','','UD',1,'1840-01-01','2999-12-31'),
	(31507,'06','030',' 04','030045',30045,'Grimacco','Grimacco','','UD',1,'1840-01-01','2999-12-31'),
	(31508,'06','030',' 04','030046',30046,'Latisana','Latisana','','UD',1,'1840-01-01','2999-12-31'),
	(31509,'06','030',' 04','030047',30047,'Lauco','Lauco','','UD',1,'1840-01-01','2999-12-31'),
	(31510,'06','030',' 04','030048',30048,'Lestizza','Lestizza','','UD',1,'1840-01-01','2999-12-31'),
	(31511,'06','030',' 04','030049',30049,'Lignano Sabbiadoro','Lignano Sabbiadoro','','UD',1,'1840-01-01','2999-12-31'),
	(31512,'06','030',' 05','030050',30050,'Ligosullo','Ligosullo','','UD',1,'1840-01-01','2999-12-31'),
	(31513,'06','030',' 05','030051',30051,'Lusevera','Lusevera','','UD',1,'1840-01-01','2999-12-31'),
	(31514,'06','030',' 05','030052',30052,'Magnano in Riviera','Magnano in Riviera','','UD',1,'1840-01-01','2999-12-31'),
	(31515,'06','030',' 05','030053',30053,'Majano','Majano','','UD',1,'1840-01-01','2999-12-31'),
	(31516,'06','030',' 05','030054',30054,'Malborghetto Valbruna','Malborghetto Valbruna','','UD',1,'1840-01-01','2999-12-31'),
	(31517,'06','030',' 05','030055',30055,'Manzano','Manzano','','UD',1,'1840-01-01','2999-12-31'),
	(31518,'06','030',' 05','030056',30056,'Marano Lagunare','Marano Lagunare','','UD',1,'1840-01-01','2999-12-31'),
	(31519,'06','030',' 05','030057',30057,'Martignacco','Martignacco','','UD',1,'1840-01-01','2999-12-31'),
	(31520,'06','030',' 05','030058',30058,'Mereto di Tomba','Mereto di Tomba','','UD',1,'1840-01-01','2999-12-31'),
	(31521,'06','030',' 05','030059',30059,'Moggio Udinese','Moggio Udinese','','UD',1,'1840-01-01','2999-12-31'),
	(31522,'06','030',' 06','030060',30060,'Moimacco','Moimacco','','UD',1,'1840-01-01','2999-12-31'),
	(31523,'06','030',' 06','030061',30061,'Montenars','Montenars','','UD',1,'1840-01-01','2999-12-31'),
	(31524,'06','030',' 06','030062',30062,'Mortegliano','Mortegliano','','UD',1,'1840-01-01','2999-12-31'),
	(31525,'06','030',' 06','030063',30063,'Moruzzo','Moruzzo','','UD',1,'1840-01-01','2999-12-31'),
	(31526,'06','030',' 06','030064',30064,'Muzzana del Turgnano','Muzzana del Turgnano','','UD',1,'1840-01-01','2999-12-31'),
	(31527,'06','030',' 06','030065',30065,'Nimis','Nimis','','UD',1,'1840-01-01','2999-12-31'),
	(31528,'06','030',' 06','030066',30066,'Osoppo','Osoppo','','UD',1,'1840-01-01','2999-12-31'),
	(31529,'06','030',' 06','030067',30067,'Ovaro','Ovaro','','UD',1,'1840-01-01','2999-12-31'),
	(31530,'06','030',' 06','030068',30068,'Pagnacco','Pagnacco','','UD',1,'1840-01-01','2999-12-31'),
	(31531,'06','030',' 06','030069',30069,'Palazzolo dello Stella','Palazzolo dello Stella','','UD',1,'1840-01-01','2999-12-31'),
	(31532,'06','030',' 07','030070',30070,'Palmanova','Palmanova','','UD',1,'1840-01-01','2999-12-31'),
	(31533,'06','030',' 07','030071',30071,'Paluzza','Paluzza','','UD',1,'1840-01-01','2999-12-31'),
	(31534,'06','030',' 07','030072',30072,'Pasian di Prato','Pasian di Prato','','UD',1,'1840-01-01','2999-12-31'),
	(31535,'06','030',' 07','030073',30073,'Paularo','Paularo','','UD',1,'1840-01-01','2999-12-31'),
	(31536,'06','030',' 07','030074',30074,'Pavia di Udine','Pavia di Udine','','UD',1,'1840-01-01','2999-12-31'),
	(31537,'06','030',' 07','030075',30075,'Pocenia','Pocenia','','UD',1,'1840-01-01','2999-12-31'),
	(31538,'06','030',' 07','030076',30076,'Pontebba','Pontebba','','UD',1,'1840-01-01','2999-12-31'),
	(31539,'06','030',' 07','030077',30077,'Porpetto','Porpetto','','UD',1,'1840-01-01','2999-12-31'),
	(31540,'06','030',' 07','030078',30078,'Povoletto','Povoletto','','UD',1,'1840-01-01','2999-12-31'),
	(31541,'06','030',' 07','030079',30079,'Pozzuolo del Friuli','Pozzuolo del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31542,'06','030',' 08','030080',30080,'Pradamano','Pradamano','','UD',1,'1840-01-01','2999-12-31'),
	(31543,'06','030',' 08','030081',30081,'Prato Carnico','Prato Carnico','','UD',1,'1840-01-01','2999-12-31'),
	(31544,'06','030',' 08','030082',30082,'Precenicco','Precenicco','','UD',1,'1840-01-01','2999-12-31'),
	(31545,'06','030',' 08','030083',30083,'Premariacco','Premariacco','','UD',1,'1840-01-01','2999-12-31'),
	(31546,'06','030',' 08','030084',30084,'Preone','Preone','','UD',1,'1840-01-01','2999-12-31'),
	(31547,'06','030',' 08','030085',30085,'Prepotto','Prepotto','','UD',1,'1840-01-01','2999-12-31'),
	(31548,'06','030',' 08','030086',30086,'Pulfero','Pulfero','','UD',1,'1840-01-01','2999-12-31'),
	(31549,'06','030',' 08','030087',30087,'Ragogna','Ragogna','','UD',1,'1840-01-01','2999-12-31'),
	(31550,'06','030',' 08','030088',30088,'Ravascletto','Ravascletto','','UD',1,'1840-01-01','2999-12-31'),
	(31551,'06','030',' 08','030089',30089,'Raveo','Raveo','','UD',1,'1840-01-01','2999-12-31'),
	(31552,'06','030',' 09','030090',30090,'Reana del Rojale','Reana del Rojale','','UD',1,'1840-01-01','2999-12-31'),
	(31553,'06','030',' 09','030091',30091,'Remanzacco','Remanzacco','','UD',1,'1840-01-01','2999-12-31'),
	(31554,'06','030',' 09','030092',30092,'Resia','Resia','','UD',1,'1840-01-01','2999-12-31'),
	(31555,'06','030',' 09','030093',30093,'Resiutta','Resiutta','','UD',1,'1840-01-01','2999-12-31'),
	(31556,'06','030',' 09','030094',30094,'Rigolato','Rigolato','','UD',1,'1840-01-01','2999-12-31'),
	(31557,'06','030',' 09','030095',30095,'Rive d\'Arcano','Rive d\'Arcano','','UD',1,'1840-01-01','2999-12-31'),
	(31558,'06','030',' 09','030096',30096,'Rivignano','Rivignano','','UD',1,'1840-01-01','2999-12-31'),
	(31559,'06','030',' 09','030097',30097,'Ronchis','Ronchis','','UD',1,'1840-01-01','2999-12-31'),
	(31560,'06','030',' 09','030098',30098,'Ruda','Ruda','','UD',1,'1840-01-01','2999-12-31'),
	(31561,'06','030',' 09','030099',30099,'San Daniele del Friuli','San Daniele del Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31562,'06','030',' 10','030100',30100,'San Giorgio di Nogaro','San Giorgio di Nogaro','','UD',1,'1840-01-01','2999-12-31'),
	(31563,'06','030',' 10','030101',30101,'San Giovanni al Natisone','San Giovanni al Natisone','','UD',1,'1840-01-01','2999-12-31'),
	(31564,'06','030',' 10','030102',30102,'San Leonardo','San Leonardo','','UD',1,'1840-01-01','2999-12-31'),
	(31565,'06','030',' 10','030103',30103,'San Pietro al Natisone','San Pietro al Natisone','','UD',1,'1840-01-01','2999-12-31'),
	(31566,'06','030',' 10','030104',30104,'Santa Maria la Longa','Santa Maria la Longa','','UD',1,'1840-01-01','2999-12-31'),
	(31567,'06','030',' 10','030105',30105,'San Vito al Torre','San Vito al Torre','','UD',1,'1840-01-01','2999-12-31'),
	(31568,'06','030',' 10','030106',30106,'San Vito di Fagagna','San Vito di Fagagna','','UD',1,'1840-01-01','2999-12-31'),
	(31569,'06','030',' 10','030107',30107,'Sauris','Sauris','','UD',1,'1840-01-01','2999-12-31'),
	(31570,'06','030',' 10','030108',30108,'Savogna','Savogna','','UD',1,'1840-01-01','2999-12-31'),
	(31571,'06','030',' 10','030109',30109,'Sedegliano','Sedegliano','','UD',1,'1840-01-01','2999-12-31'),
	(31572,'06','030',' 11','030110',30110,'Socchieve','Socchieve','','UD',1,'1840-01-01','2999-12-31'),
	(31573,'06','030',' 11','030111',30111,'Stregna','Stregna','','UD',1,'1840-01-01','2999-12-31'),
	(31574,'06','030',' 11','030112',30112,'Sutrio','Sutrio','','UD',1,'1840-01-01','2999-12-31'),
	(31575,'06','030',' 11','030113',30113,'Taipana','Taipana','','UD',1,'1840-01-01','2999-12-31'),
	(31576,'06','030',' 11','030114',30114,'Talmassons','Talmassons','','UD',1,'1840-01-01','2999-12-31'),
	(31577,'06','030',' 11','030116',30116,'Tarcento','Tarcento','','UD',1,'1840-01-01','2999-12-31'),
	(31578,'06','030',' 11','030117',30117,'Tarvisio','Tarvisio','','UD',1,'1840-01-01','2999-12-31'),
	(31579,'06','030',' 11','030118',30118,'Tavagnacco','Tavagnacco','','UD',1,'1840-01-01','2999-12-31'),
	(31580,'06','030',' 11','030119',30119,'Teor','Teor','','UD',1,'1840-01-01','2999-12-31'),
	(31581,'06','030',' 12','030120',30120,'Terzo d\'Aquileia','Terzo d\'Aquileia','','UD',1,'1840-01-01','2999-12-31'),
	(31582,'06','030',' 12','030121',30121,'Tolmezzo','Tolmezzo','','UD',1,'1840-01-01','2999-12-31'),
	(31583,'06','030',' 12','030122',30122,'Torreano','Torreano','','UD',1,'1840-01-01','2999-12-31'),
	(31584,'06','030',' 12','030123',30123,'Torviscosa','Torviscosa','','UD',1,'1840-01-01','2999-12-31'),
	(31585,'06','030',' 12','030124',30124,'Trasaghis','Trasaghis','','UD',1,'1840-01-01','2999-12-31'),
	(31586,'06','030',' 12','030125',30125,'Treppo Carnico','Treppo Carnico','','UD',1,'1840-01-01','2999-12-31'),
	(31587,'06','030',' 12','030126',30126,'Treppo Grande','Treppo Grande','','UD',1,'1840-01-01','2999-12-31'),
	(31588,'06','030',' 12','030127',30127,'Tricesimo','Tricesimo','','UD',1,'1840-01-01','2999-12-31'),
	(31589,'06','030',' 12','030128',30128,'Trivignano Udinese','Trivignano Udinese','','UD',1,'1840-01-01','2999-12-31'),
	(31590,'06','030',' 12','030129',30129,'Udine','Udine','','UD',1,'1840-01-01','2999-12-31'),
	(31591,'06','030',' 13','030130',30130,'Varmo','Varmo','','UD',1,'1840-01-01','2999-12-31'),
	(31592,'06','030',' 13','030131',30131,'Venzone','Venzone','','UD',1,'1840-01-01','2999-12-31'),
	(31593,'06','030',' 13','030132',30132,'Verzegnis','Verzegnis','','UD',1,'1840-01-01','2999-12-31'),
	(31594,'06','030',' 13','030133',30133,'Villa Santina','Villa Santina','','UD',1,'1840-01-01','2999-12-31'),
	(31595,'06','030',' 13','030134',30134,'Villa Vicentina','Villa Vicentina','','UD',1,'1840-01-01','2999-12-31'),
	(31596,'06','030',' 13','030135',30135,'Visco','Visco','','UD',1,'1840-01-01','2999-12-31'),
	(31597,'06','030',' 13','030136',30136,'Zuglio','Zuglio','','UD',1,'1840-01-01','2999-12-31'),
	(31598,'06','030',' 13','030137',30137,'Forgaria nel Friuli','Forgaria nel Friuli','','UD',1,'1840-01-01','2999-12-31'),
	(31599,'06','030',' 13','030138',30138,'Campolongo Tapogliano','Campolongo Tapogliano','','UD',1,'1840-01-01','2999-12-31'),
	(31600,'06','031',' 00','031001',31001,'Capriva del Friuli','Capriva del Friuli','','GO',1,'1840-01-01','2999-12-31'),
	(31601,'06','031',' 00','031002',31002,'Cormons','Cormons','','GO',1,'1840-01-01','2999-12-31'),
	(31602,'06','031',' 00','031003',31003,'Doberdò del Lago','Doberdò del Lago','','GO',1,'1840-01-01','2999-12-31'),
	(31603,'06','031',' 00','031004',31004,'Dolegna del Collio','Dolegna del Collio','','GO',1,'1840-01-01','2999-12-31'),
	(31604,'06','031',' 00','031005',31005,'Farra d\'Isonzo','Farra d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31605,'06','031',' 00','031006',31006,'Fogliano Redipuglia','Fogliano Redipuglia','','GO',1,'1840-01-01','2999-12-31'),
	(31606,'06','031',' 00','031007',31007,'Gorizia','Gorizia','','GO',1,'1840-01-01','2999-12-31'),
	(31607,'06','031',' 00','031008',31008,'Gradisca d\'Isonzo','Gradisca d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31608,'06','031',' 00','031009',31009,'Grado','Grado','','GO',1,'1840-01-01','2999-12-31'),
	(31609,'06','031',' 01','031010',31010,'Mariano del Friuli','Mariano del Friuli','','GO',1,'1840-01-01','2999-12-31'),
	(31610,'06','031',' 01','031011',31011,'Medea','Medea','','GO',1,'1840-01-01','2999-12-31'),
	(31611,'06','031',' 01','031012',31012,'Monfalcone','Monfalcone','','GO',1,'1840-01-01','2999-12-31'),
	(31612,'06','031',' 01','031013',31013,'Moraro','Moraro','','GO',1,'1840-01-01','2999-12-31'),
	(31613,'06','031',' 01','031014',31014,'Mossa','Mossa','','GO',1,'1840-01-01','2999-12-31'),
	(31614,'06','031',' 01','031015',31015,'Romans d\'Isonzo','Romans d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31615,'06','031',' 01','031016',31016,'Ronchi dei Legionari','Ronchi dei Legionari','','GO',1,'1840-01-01','2999-12-31'),
	(31616,'06','031',' 01','031017',31017,'Sagrado','Sagrado','','GO',1,'1840-01-01','2999-12-31'),
	(31617,'06','031',' 01','031018',31018,'San Canzian d\'Isonzo','San Canzian d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31618,'06','031',' 01','031019',31019,'San Floriano del Collio','San Floriano del Collio','','GO',1,'1840-01-01','2999-12-31'),
	(31619,'06','031',' 02','031020',31020,'San Lorenzo Isontino','San Lorenzo Isontino','','GO',1,'1840-01-01','2999-12-31'),
	(31620,'06','031',' 02','031021',31021,'San Pier d\'Isonzo','San Pier d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31621,'06','031',' 02','031022',31022,'Savogna d\'Isonzo','Savogna d\'Isonzo','','GO',1,'1840-01-01','2999-12-31'),
	(31622,'06','031',' 02','031023',31023,'Staranzano','Staranzano','','GO',1,'1840-01-01','2999-12-31'),
	(31623,'06','031',' 02','031024',31024,'Turriaco','Turriaco','','GO',1,'1840-01-01','2999-12-31'),
	(31624,'06','031',' 02','031025',31025,'Villesse','Villesse','','GO',1,'1840-01-01','2999-12-31'),
	(31625,'06','032',' 00','032001',32001,'Duino-Aurisina','Duino-Aurisina','','TS',1,'1840-01-01','2999-12-31'),
	(31626,'06','032',' 00','032002',32002,'Monrupino','Monrupino','','TS',1,'1840-01-01','2999-12-31'),
	(31627,'06','032',' 00','032003',32003,'Muggia','Muggia','','TS',1,'1840-01-01','2999-12-31'),
	(31628,'06','032',' 00','032004',32004,'San Dorligo della Valle - Dolina','San Dorligo della Valle - Dolina','','TS',1,'1840-01-01','2999-12-31'),
	(31629,'06','032',' 00','032005',32005,'Sgonico','Sgonico','','TS',1,'1840-01-01','2999-12-31'),
	(31630,'06','032',' 00','032006',32006,'Trieste','Trieste','','TS',1,'1840-01-01','2999-12-31'),
	(31631,'08','033',' 00','033001',33001,'Agazzano','Agazzano','','PC',1,'1840-01-01','2999-12-31'),
	(31632,'08','033',' 00','033002',33002,'Alseno','Alseno','','PC',1,'1840-01-01','2999-12-31'),
	(31633,'08','033',' 00','033003',33003,'Besenzone','Besenzone','','PC',1,'1840-01-01','2999-12-31'),
	(31634,'08','033',' 00','033004',33004,'Bettola','Bettola','','PC',1,'1840-01-01','2999-12-31'),
	(31635,'08','033',' 00','033005',33005,'Bobbio','Bobbio','','PC',1,'1840-01-01','2999-12-31'),
	(31636,'08','033',' 00','033006',33006,'Borgonovo Val Tidone','Borgonovo Val Tidone','','PC',1,'1840-01-01','2999-12-31'),
	(31637,'08','033',' 00','033007',33007,'Cadeo','Cadeo','','PC',1,'1840-01-01','2999-12-31'),
	(31638,'08','033',' 00','033008',33008,'Calendasco','Calendasco','','PC',1,'1840-01-01','2999-12-31'),
	(31639,'08','033',' 00','033009',33009,'Caminata','Caminata','','PC',1,'1840-01-01','2999-12-31'),
	(31640,'08','033',' 01','033010',33010,'Caorso','Caorso','','PC',1,'1840-01-01','2999-12-31'),
	(31641,'08','033',' 01','033011',33011,'Carpaneto Piacentino','Carpaneto Piacentino','','PC',1,'1840-01-01','2999-12-31'),
	(31642,'08','033',' 01','033012',33012,'Castell\'Arquato','Castell\'Arquato','','PC',1,'1840-01-01','2999-12-31'),
	(31643,'08','033',' 01','033013',33013,'Castel San Giovanni','Castel San Giovanni','','PC',1,'1840-01-01','2999-12-31'),
	(31644,'08','033',' 01','033014',33014,'Castelvetro Piacentino','Castelvetro Piacentino','','PC',1,'1840-01-01','2999-12-31'),
	(31645,'08','033',' 01','033015',33015,'Cerignale','Cerignale','','PC',1,'1840-01-01','2999-12-31'),
	(31646,'08','033',' 01','033016',33016,'Coli','Coli','','PC',1,'1840-01-01','2999-12-31'),
	(31647,'08','033',' 01','033017',33017,'Corte Brugnatella','Corte Brugnatella','','PC',1,'1840-01-01','2999-12-31'),
	(31648,'08','033',' 01','033018',33018,'Cortemaggiore','Cortemaggiore','','PC',1,'1840-01-01','2999-12-31'),
	(31649,'08','033',' 01','033019',33019,'Farini','Farini','','PC',1,'1840-01-01','2999-12-31'),
	(31650,'08','033',' 02','033020',33020,'Ferriere','Ferriere','','PC',1,'1840-01-01','2999-12-31'),
	(31651,'08','033',' 02','033021',33021,'Fiorenzuola d\'Arda','Fiorenzuola d\'Arda','','PC',1,'1840-01-01','2999-12-31'),
	(31652,'08','033',' 02','033022',33022,'Gazzola','Gazzola','','PC',1,'1840-01-01','2999-12-31'),
	(31653,'08','033',' 02','033023',33023,'Gossolengo','Gossolengo','','PC',1,'1840-01-01','2999-12-31'),
	(31654,'08','033',' 02','033024',33024,'Gragnano Trebbiense','Gragnano Trebbiense','','PC',1,'1840-01-01','2999-12-31'),
	(31655,'08','033',' 02','033025',33025,'Gropparello','Gropparello','','PC',1,'1840-01-01','2999-12-31'),
	(31656,'08','033',' 02','033026',33026,'Lugagnano Val d\'Arda','Lugagnano Val d\'Arda','','PC',1,'1840-01-01','2999-12-31'),
	(31657,'08','033',' 02','033027',33027,'Monticelli d\'Ongina','Monticelli d\'Ongina','','PC',1,'1840-01-01','2999-12-31'),
	(31658,'08','033',' 02','033028',33028,'Morfasso','Morfasso','','PC',1,'1840-01-01','2999-12-31'),
	(31659,'08','033',' 02','033029',33029,'Nibbiano','Nibbiano','','PC',1,'1840-01-01','2999-12-31'),
	(31660,'08','033',' 03','033030',33030,'Ottone','Ottone','','PC',1,'1840-01-01','2999-12-31'),
	(31661,'08','033',' 03','033031',33031,'Pecorara','Pecorara','','PC',1,'1840-01-01','2999-12-31'),
	(31662,'08','033',' 03','033032',33032,'Piacenza','Piacenza','','PC',1,'1840-01-01','2999-12-31'),
	(31663,'08','033',' 03','033033',33033,'Pianello Val Tidone','Pianello Val Tidone','','PC',1,'1840-01-01','2999-12-31'),
	(31664,'08','033',' 03','033034',33034,'Piozzano','Piozzano','','PC',1,'1840-01-01','2999-12-31'),
	(31665,'08','033',' 03','033035',33035,'Podenzano','Podenzano','','PC',1,'1840-01-01','2999-12-31'),
	(31666,'08','033',' 03','033036',33036,'Ponte dell\'Olio','Ponte dell\'Olio','','PC',1,'1840-01-01','2999-12-31'),
	(31667,'08','033',' 03','033037',33037,'Pontenure','Pontenure','','PC',1,'1840-01-01','2999-12-31'),
	(31668,'08','033',' 03','033038',33038,'Rivergaro','Rivergaro','','PC',1,'1840-01-01','2999-12-31'),
	(31669,'08','033',' 03','033039',33039,'Rottofreno','Rottofreno','','PC',1,'1840-01-01','2999-12-31'),
	(31670,'08','033',' 04','033040',33040,'San Giorgio Piacentino','San Giorgio Piacentino','','PC',1,'1840-01-01','2999-12-31'),
	(31671,'08','033',' 04','033041',33041,'San Pietro in Cerro','San Pietro in Cerro','','PC',1,'1840-01-01','2999-12-31'),
	(31672,'08','033',' 04','033042',33042,'Sarmato','Sarmato','','PC',1,'1840-01-01','2999-12-31'),
	(31673,'08','033',' 04','033043',33043,'Travo','Travo','','PC',1,'1840-01-01','2999-12-31'),
	(31674,'08','033',' 04','033044',33044,'Vernasca','Vernasca','','PC',1,'1840-01-01','2999-12-31'),
	(31675,'08','033',' 04','033045',33045,'Vigolzone','Vigolzone','','PC',1,'1840-01-01','2999-12-31'),
	(31676,'08','033',' 04','033046',33046,'Villanova sull\'Arda','Villanova sull\'Arda','','PC',1,'1840-01-01','2999-12-31'),
	(31677,'08','033',' 04','033047',33047,'Zerba','Zerba','','PC',1,'1840-01-01','2999-12-31'),
	(31678,'08','033',' 04','033048',33048,'Ziano Piacentino','Ziano Piacentino','','PC',1,'1840-01-01','2999-12-31'),
	(31679,'08','034',' 00','034001',34001,'Albareto','Albareto','','PR',1,'1840-01-01','2999-12-31'),
	(31680,'08','034',' 00','034002',34002,'Bardi','Bardi','','PR',1,'1840-01-01','2999-12-31'),
	(31681,'08','034',' 00','034003',34003,'Bedonia','Bedonia','','PR',1,'1840-01-01','2999-12-31'),
	(31682,'08','034',' 00','034004',34004,'Berceto','Berceto','','PR',1,'1840-01-01','2999-12-31'),
	(31683,'08','034',' 00','034005',34005,'Bore','Bore','','PR',1,'1840-01-01','2999-12-31'),
	(31684,'08','034',' 00','034006',34006,'Borgo Val di Taro','Borgo Val di Taro','','PR',1,'1840-01-01','2999-12-31'),
	(31685,'08','034',' 00','034007',34007,'Busseto','Busseto','','PR',1,'1840-01-01','2999-12-31'),
	(31686,'08','034',' 00','034008',34008,'Calestano','Calestano','','PR',1,'1840-01-01','2999-12-31'),
	(31687,'08','034',' 00','034009',34009,'Collecchio','Collecchio','','PR',1,'1840-01-01','2999-12-31'),
	(31688,'08','034',' 01','034010',34010,'Colorno','Colorno','','PR',1,'1840-01-01','2999-12-31'),
	(31689,'08','034',' 01','034011',34011,'Compiano','Compiano','','PR',1,'1840-01-01','2999-12-31'),
	(31690,'08','034',' 01','034012',34012,'Corniglio','Corniglio','','PR',1,'1840-01-01','2999-12-31'),
	(31691,'08','034',' 01','034013',34013,'Felino','Felino','','PR',1,'1840-01-01','2999-12-31'),
	(31692,'08','034',' 01','034014',34014,'Fidenza','Fidenza','','PR',1,'1840-01-01','2999-12-31'),
	(31693,'08','034',' 01','034015',34015,'Fontanellato','Fontanellato','','PR',1,'1840-01-01','2999-12-31'),
	(31694,'08','034',' 01','034016',34016,'Fontevivo','Fontevivo','','PR',1,'1840-01-01','2999-12-31'),
	(31695,'08','034',' 01','034017',34017,'Fornovo di Taro','Fornovo di Taro','','PR',1,'1840-01-01','2999-12-31'),
	(31696,'08','034',' 01','034018',34018,'Langhirano','Langhirano','','PR',1,'1840-01-01','2999-12-31'),
	(31697,'08','034',' 01','034019',34019,'Lesignano de\' Bagni','Lesignano de\' Bagni','','PR',1,'1840-01-01','2999-12-31'),
	(31698,'08','034',' 02','034020',34020,'Medesano','Medesano','','PR',1,'1840-01-01','2999-12-31'),
	(31699,'08','034',' 02','034021',34021,'Mezzani','Mezzani','','PR',1,'1840-01-01','2999-12-31'),
	(31700,'08','034',' 02','034022',34022,'Monchio delle Corti','Monchio delle Corti','','PR',1,'1840-01-01','2999-12-31'),
	(31701,'08','034',' 02','034023',34023,'Montechiarugolo','Montechiarugolo','','PR',1,'1840-01-01','2999-12-31'),
	(31702,'08','034',' 02','034024',34024,'Neviano degli Arduini','Neviano degli Arduini','','PR',1,'1840-01-01','2999-12-31'),
	(31703,'08','034',' 02','034025',34025,'Noceto','Noceto','','PR',1,'1840-01-01','2999-12-31'),
	(31704,'08','034',' 02','034026',34026,'Palanzano','Palanzano','','PR',1,'1840-01-01','2999-12-31'),
	(31705,'08','034',' 02','034027',34027,'Parma','Parma','','PR',1,'1840-01-01','2999-12-31'),
	(31706,'08','034',' 02','034028',34028,'Pellegrino Parmense','Pellegrino Parmense','','PR',1,'1840-01-01','2999-12-31'),
	(31707,'08','034',' 02','034029',34029,'Polesine Parmense','Polesine Parmense','','PR',1,'1840-01-01','2999-12-31'),
	(31708,'08','034',' 03','034030',34030,'Roccabianca','Roccabianca','','PR',1,'1840-01-01','2999-12-31'),
	(31709,'08','034',' 03','034031',34031,'Sala Baganza','Sala Baganza','','PR',1,'1840-01-01','2999-12-31'),
	(31710,'08','034',' 03','034032',34032,'Salsomaggiore Terme','Salsomaggiore Terme','','PR',1,'1840-01-01','2999-12-31'),
	(31711,'08','034',' 03','034033',34033,'San Secondo Parmense','San Secondo Parmense','','PR',1,'1840-01-01','2999-12-31'),
	(31712,'08','034',' 03','034034',34034,'Sissa','Sissa','','PR',1,'1840-01-01','2999-12-31'),
	(31713,'08','034',' 03','034035',34035,'Solignano','Solignano','','PR',1,'1840-01-01','2999-12-31'),
	(31714,'08','034',' 03','034036',34036,'Soragna','Soragna','','PR',1,'1840-01-01','2999-12-31'),
	(31715,'08','034',' 03','034037',34037,'Sorbolo','Sorbolo','','PR',1,'1840-01-01','2999-12-31'),
	(31716,'08','034',' 03','034038',34038,'Terenzo','Terenzo','','PR',1,'1840-01-01','2999-12-31'),
	(31717,'08','034',' 03','034039',34039,'Tizzano Val Parma','Tizzano Val Parma','','PR',1,'1840-01-01','2999-12-31'),
	(31718,'08','034',' 04','034040',34040,'Tornolo','Tornolo','','PR',1,'1840-01-01','2999-12-31'),
	(31719,'08','034',' 04','034041',34041,'Torrile','Torrile','','PR',1,'1840-01-01','2999-12-31'),
	(31720,'08','034',' 04','034042',34042,'Traversetolo','Traversetolo','','PR',1,'1840-01-01','2999-12-31'),
	(31721,'08','034',' 04','034043',34043,'Trecasali','Trecasali','','PR',1,'1840-01-01','2999-12-31'),
	(31722,'08','034',' 04','034044',34044,'Valmozzola','Valmozzola','','PR',1,'1840-01-01','2999-12-31'),
	(31723,'08','034',' 04','034045',34045,'Varano de\' Melegari','Varano de\' Melegari','','PR',1,'1840-01-01','2999-12-31'),
	(31724,'08','034',' 04','034046',34046,'Varsi','Varsi','','PR',1,'1840-01-01','2999-12-31'),
	(31725,'08','034',' 04','034048',34048,'Zibello','Zibello','','PR',1,'1840-01-01','2999-12-31'),
	(31726,'08','035',' 00','035001',35001,'Albinea','Albinea','','RE',1,'1840-01-01','2999-12-31'),
	(31727,'08','035',' 00','035002',35002,'Bagnolo in Piano','Bagnolo in Piano','','RE',1,'1840-01-01','2999-12-31'),
	(31728,'08','035',' 00','035003',35003,'Baiso','Baiso','','RE',1,'1840-01-01','2999-12-31'),
	(31729,'08','035',' 00','035004',35004,'Bibbiano','Bibbiano','','RE',1,'1840-01-01','2999-12-31'),
	(31730,'08','035',' 00','035005',35005,'Boretto','Boretto','','RE',1,'1840-01-01','2999-12-31'),
	(31731,'08','035',' 00','035006',35006,'Brescello','Brescello','','RE',1,'1840-01-01','2999-12-31'),
	(31732,'08','035',' 00','035007',35007,'Busana','Busana','','RE',1,'1840-01-01','2999-12-31'),
	(31733,'08','035',' 00','035008',35008,'Cadelbosco di Sopra','Cadelbosco di Sopra','','RE',1,'1840-01-01','2999-12-31'),
	(31734,'08','035',' 00','035009',35009,'Campagnola Emilia','Campagnola Emilia','','RE',1,'1840-01-01','2999-12-31'),
	(31735,'08','035',' 01','035010',35010,'Campegine','Campegine','','RE',1,'1840-01-01','2999-12-31'),
	(31736,'08','035',' 01','035011',35011,'Carpineti','Carpineti','','RE',1,'1840-01-01','2999-12-31'),
	(31737,'08','035',' 01','035012',35012,'Casalgrande','Casalgrande','','RE',1,'1840-01-01','2999-12-31'),
	(31738,'08','035',' 01','035013',35013,'Casina','Casina','','RE',1,'1840-01-01','2999-12-31'),
	(31739,'08','035',' 01','035014',35014,'Castellarano','Castellarano','','RE',1,'1840-01-01','2999-12-31'),
	(31740,'08','035',' 01','035015',35015,'Castelnovo di Sotto','Castelnovo di Sotto','','RE',1,'1840-01-01','2999-12-31'),
	(31741,'08','035',' 01','035016',35016,'Castelnovo ne\' Monti','Castelnovo ne\' Monti','','RE',1,'1840-01-01','2999-12-31'),
	(31742,'08','035',' 01','035017',35017,'Cavriago','Cavriago','','RE',1,'1840-01-01','2999-12-31'),
	(31743,'08','035',' 01','035018',35018,'Canossa','Canossa','','RE',1,'1840-01-01','2999-12-31'),
	(31744,'08','035',' 01','035019',35019,'Collagna','Collagna','','RE',1,'1840-01-01','2999-12-31'),
	(31745,'08','035',' 02','035020',35020,'Correggio','Correggio','','RE',1,'1840-01-01','2999-12-31'),
	(31746,'08','035',' 02','035021',35021,'Fabbrico','Fabbrico','','RE',1,'1840-01-01','2999-12-31'),
	(31747,'08','035',' 02','035022',35022,'Gattatico','Gattatico','','RE',1,'1840-01-01','2999-12-31'),
	(31748,'08','035',' 02','035023',35023,'Gualtieri','Gualtieri','','RE',1,'1840-01-01','2999-12-31'),
	(31749,'08','035',' 02','035024',35024,'Guastalla','Guastalla','','RE',1,'1840-01-01','2999-12-31'),
	(31750,'08','035',' 02','035025',35025,'Ligonchio','Ligonchio','','RE',1,'1840-01-01','2999-12-31'),
	(31751,'08','035',' 02','035026',35026,'Luzzara','Luzzara','','RE',1,'1840-01-01','2999-12-31'),
	(31752,'08','035',' 02','035027',35027,'Montecchio Emilia','Montecchio Emilia','','RE',1,'1840-01-01','2999-12-31'),
	(31753,'08','035',' 02','035028',35028,'Novellara','Novellara','','RE',1,'1840-01-01','2999-12-31'),
	(31754,'08','035',' 02','035029',35029,'Poviglio','Poviglio','','RE',1,'1840-01-01','2999-12-31'),
	(31755,'08','035',' 03','035030',35030,'Quattro Castella','Quattro Castella','','RE',1,'1840-01-01','2999-12-31'),
	(31756,'08','035',' 03','035031',35031,'Ramiseto','Ramiseto','','RE',1,'1840-01-01','2999-12-31'),
	(31757,'08','035',' 03','035032',35032,'Reggiolo','Reggiolo','','RE',1,'1840-01-01','2999-12-31'),
	(31758,'08','035',' 03','035033',35033,'Reggio nell\'Emilia','Reggio nell\'Emilia','','RE',1,'1840-01-01','2999-12-31'),
	(31759,'08','035',' 03','035034',35034,'Rio Saliceto','Rio Saliceto','','RE',1,'1840-01-01','2999-12-31'),
	(31760,'08','035',' 03','035035',35035,'Rolo','Rolo','','RE',1,'1840-01-01','2999-12-31'),
	(31761,'08','035',' 03','035036',35036,'Rubiera','Rubiera','','RE',1,'1840-01-01','2999-12-31'),
	(31762,'08','035',' 03','035037',35037,'San Martino in Rio','San Martino in Rio','','RE',1,'1840-01-01','2999-12-31'),
	(31763,'08','035',' 03','035038',35038,'San Polo d\'Enza','San Polo d\'Enza','','RE',1,'1840-01-01','2999-12-31'),
	(31764,'08','035',' 03','035039',35039,'Sant\'Ilario d\'Enza','Sant\'Ilario d\'Enza','','RE',1,'1840-01-01','2999-12-31'),
	(31765,'08','035',' 04','035040',35040,'Scandiano','Scandiano','','RE',1,'1840-01-01','2999-12-31'),
	(31766,'08','035',' 04','035041',35041,'Toano','Toano','','RE',1,'1840-01-01','2999-12-31'),
	(31767,'08','035',' 04','035042',35042,'Vetto','Vetto','','RE',1,'1840-01-01','2999-12-31'),
	(31768,'08','035',' 04','035043',35043,'Vezzano sul Crostolo','Vezzano sul Crostolo','','RE',1,'1840-01-01','2999-12-31'),
	(31769,'08','035',' 04','035044',35044,'Viano','Viano','','RE',1,'1840-01-01','2999-12-31'),
	(31770,'08','035',' 04','035045',35045,'Villa Minozzo','Villa Minozzo','','RE',1,'1840-01-01','2999-12-31'),
	(31771,'08','036',' 00','036001',36001,'Bastiglia','Bastiglia','','MO',1,'1840-01-01','2999-12-31'),
	(31772,'08','036',' 00','036002',36002,'Bomporto','Bomporto','','MO',1,'1840-01-01','2999-12-31'),
	(31773,'08','036',' 00','036003',36003,'Campogalliano','Campogalliano','','MO',1,'1840-01-01','2999-12-31'),
	(31774,'08','036',' 00','036004',36004,'Camposanto','Camposanto','','MO',1,'1840-01-01','2999-12-31'),
	(31775,'08','036',' 00','036005',36005,'Carpi','Carpi','','MO',1,'1840-01-01','2999-12-31'),
	(31776,'08','036',' 00','036006',36006,'Castelfranco Emilia','Castelfranco Emilia','','MO',1,'1840-01-01','2999-12-31'),
	(31777,'08','036',' 00','036007',36007,'Castelnuovo Rangone','Castelnuovo Rangone','','MO',1,'1840-01-01','2999-12-31'),
	(31778,'08','036',' 00','036008',36008,'Castelvetro di Modena','Castelvetro di Modena','','MO',1,'1840-01-01','2999-12-31'),
	(31779,'08','036',' 00','036009',36009,'Cavezzo','Cavezzo','','MO',1,'1840-01-01','2999-12-31'),
	(31780,'08','036',' 01','036010',36010,'Concordia sulla Secchia','Concordia sulla Secchia','','MO',1,'1840-01-01','2999-12-31'),
	(31781,'08','036',' 01','036011',36011,'Fanano','Fanano','','MO',1,'1840-01-01','2999-12-31'),
	(31782,'08','036',' 01','036012',36012,'Finale Emilia','Finale Emilia','','MO',1,'1840-01-01','2999-12-31'),
	(31783,'08','036',' 01','036013',36013,'Fiorano Modenese','Fiorano Modenese','','MO',1,'1840-01-01','2999-12-31'),
	(31784,'08','036',' 01','036014',36014,'Fiumalbo','Fiumalbo','','MO',1,'1840-01-01','2999-12-31'),
	(31785,'08','036',' 01','036015',36015,'Formigine','Formigine','','MO',1,'1840-01-01','2999-12-31'),
	(31786,'08','036',' 01','036016',36016,'Frassinoro','Frassinoro','','MO',1,'1840-01-01','2999-12-31'),
	(31787,'08','036',' 01','036017',36017,'Guiglia','Guiglia','','MO',1,'1840-01-01','2999-12-31'),
	(31788,'08','036',' 01','036018',36018,'Lama Mocogno','Lama Mocogno','','MO',1,'1840-01-01','2999-12-31'),
	(31789,'08','036',' 01','036019',36019,'Maranello','Maranello','','MO',1,'1840-01-01','2999-12-31'),
	(31790,'08','036',' 02','036020',36020,'Marano sul Panaro','Marano sul Panaro','','MO',1,'1840-01-01','2999-12-31'),
	(31791,'08','036',' 02','036021',36021,'Medolla','Medolla','','MO',1,'1840-01-01','2999-12-31'),
	(31792,'08','036',' 02','036022',36022,'Mirandola','Mirandola','','MO',1,'1840-01-01','2999-12-31'),
	(31793,'08','036',' 02','036023',36023,'Modena','Modena','','MO',1,'1840-01-01','2999-12-31'),
	(31794,'08','036',' 02','036024',36024,'Montecreto','Montecreto','','MO',1,'1840-01-01','2999-12-31'),
	(31795,'08','036',' 02','036025',36025,'Montefiorino','Montefiorino','','MO',1,'1840-01-01','2999-12-31'),
	(31796,'08','036',' 02','036026',36026,'Montese','Montese','','MO',1,'1840-01-01','2999-12-31'),
	(31797,'08','036',' 02','036027',36027,'Nonantola','Nonantola','','MO',1,'1840-01-01','2999-12-31'),
	(31798,'08','036',' 02','036028',36028,'Novi di Modena','Novi di Modena','','MO',1,'1840-01-01','2999-12-31'),
	(31799,'08','036',' 02','036029',36029,'Palagano','Palagano','','MO',1,'1840-01-01','2999-12-31'),
	(31800,'08','036',' 03','036030',36030,'Pavullo nel Frignano','Pavullo nel Frignano','','MO',1,'1840-01-01','2999-12-31'),
	(31801,'08','036',' 03','036031',36031,'Pievepelago','Pievepelago','','MO',1,'1840-01-01','2999-12-31'),
	(31802,'08','036',' 03','036032',36032,'Polinago','Polinago','','MO',1,'1840-01-01','2999-12-31'),
	(31803,'08','036',' 03','036033',36033,'Prignano sulla Secchia','Prignano sulla Secchia','','MO',1,'1840-01-01','2999-12-31'),
	(31804,'08','036',' 03','036034',36034,'Ravarino','Ravarino','','MO',1,'1840-01-01','2999-12-31'),
	(31805,'08','036',' 03','036035',36035,'Riolunato','Riolunato','','MO',1,'1840-01-01','2999-12-31'),
	(31806,'08','036',' 03','036036',36036,'San Cesario sul Panaro','San Cesario sul Panaro','','MO',1,'1840-01-01','2999-12-31'),
	(31807,'08','036',' 03','036037',36037,'San Felice sul Panaro','San Felice sul Panaro','','MO',1,'1840-01-01','2999-12-31'),
	(31808,'08','036',' 03','036038',36038,'San Possidonio','San Possidonio','','MO',1,'1840-01-01','2999-12-31'),
	(31809,'08','036',' 03','036039',36039,'San Prospero','San Prospero','','MO',1,'1840-01-01','2999-12-31'),
	(31810,'08','036',' 04','036040',36040,'Sassuolo','Sassuolo','','MO',1,'1840-01-01','2999-12-31'),
	(31811,'08','036',' 04','036041',36041,'Savignano sul Panaro','Savignano sul Panaro','','MO',1,'1840-01-01','2999-12-31'),
	(31812,'08','036',' 04','036042',36042,'Serramazzoni','Serramazzoni','','MO',1,'1840-01-01','2999-12-31'),
	(31813,'08','036',' 04','036043',36043,'Sestola','Sestola','','MO',1,'1840-01-01','2999-12-31'),
	(31814,'08','036',' 04','036044',36044,'Soliera','Soliera','','MO',1,'1840-01-01','2999-12-31'),
	(31815,'08','036',' 04','036045',36045,'Spilamberto','Spilamberto','','MO',1,'1840-01-01','2999-12-31'),
	(31816,'08','036',' 04','036046',36046,'Vignola','Vignola','','MO',1,'1840-01-01','2999-12-31'),
	(31817,'08','036',' 04','036047',36047,'Zocca','Zocca','','MO',1,'1840-01-01','2999-12-31'),
	(31818,'08','037',' 00','037001',37001,'Anzola dell\'Emilia','Anzola dell\'Emilia','','BO',1,'1840-01-01','2999-12-31'),
	(31819,'08','037',' 00','037002',37002,'Argelato','Argelato','','BO',1,'1840-01-01','2999-12-31'),
	(31820,'08','037',' 00','037003',37003,'Baricella','Baricella','','BO',1,'1840-01-01','2999-12-31'),
	(31821,'08','037',' 00','037004',37004,'Bazzano','Bazzano','','BO',1,'1840-01-01','2999-12-31'),
	(31822,'08','037',' 00','037005',37005,'Bentivoglio','Bentivoglio','','BO',1,'1840-01-01','2999-12-31'),
	(31823,'08','037',' 00','037006',37006,'Bologna','Bologna','','BO',1,'1840-01-01','2999-12-31'),
	(31824,'08','037',' 00','037007',37007,'Borgo Tossignano','Borgo Tossignano','','BO',1,'1840-01-01','2999-12-31'),
	(31825,'08','037',' 00','037008',37008,'Budrio','Budrio','','BO',1,'1840-01-01','2999-12-31'),
	(31826,'08','037',' 00','037009',37009,'Calderara di Reno','Calderara di Reno','','BO',1,'1840-01-01','2999-12-31'),
	(31827,'08','037',' 01','037010',37010,'Camugnano','Camugnano','','BO',1,'1840-01-01','2999-12-31'),
	(31828,'08','037',' 01','037011',37011,'Casalecchio di Reno','Casalecchio di Reno','','BO',1,'1840-01-01','2999-12-31'),
	(31829,'08','037',' 01','037012',37012,'Casalfiumanese','Casalfiumanese','','BO',1,'1840-01-01','2999-12-31'),
	(31830,'08','037',' 01','037013',37013,'Castel d\'Aiano','Castel d\'Aiano','','BO',1,'1840-01-01','2999-12-31'),
	(31831,'08','037',' 01','037014',37014,'Castel del Rio','Castel del Rio','','BO',1,'1840-01-01','2999-12-31'),
	(31832,'08','037',' 01','037015',37015,'Castel di Casio','Castel di Casio','','BO',1,'1840-01-01','2999-12-31'),
	(31833,'08','037',' 01','037016',37016,'Castel Guelfo di Bologna','Castel Guelfo di Bologna','','BO',1,'1840-01-01','2999-12-31'),
	(31834,'08','037',' 01','037017',37017,'Castello d\'Argile','Castello d\'Argile','','BO',1,'1840-01-01','2999-12-31'),
	(31835,'08','037',' 01','037018',37018,'Castello di Serravalle','Castello di Serravalle','','BO',1,'1840-01-01','2999-12-31'),
	(31836,'08','037',' 01','037019',37019,'Castel Maggiore','Castel Maggiore','','BO',1,'1840-01-01','2999-12-31'),
	(31837,'08','037',' 02','037020',37020,'Castel San Pietro Terme','Castel San Pietro Terme','','BO',1,'1840-01-01','2999-12-31'),
	(31838,'08','037',' 02','037021',37021,'Castenaso','Castenaso','','BO',1,'1840-01-01','2999-12-31'),
	(31839,'08','037',' 02','037022',37022,'Castiglione dei Pepoli','Castiglione dei Pepoli','','BO',1,'1840-01-01','2999-12-31'),
	(31840,'08','037',' 02','037023',37023,'Crespellano','Crespellano','','BO',1,'1840-01-01','2999-12-31'),
	(31841,'08','037',' 02','037024',37024,'Crevalcore','Crevalcore','','BO',1,'1840-01-01','2999-12-31'),
	(31842,'08','037',' 02','037025',37025,'Dozza','Dozza','','BO',1,'1840-01-01','2999-12-31'),
	(31843,'08','037',' 02','037026',37026,'Fontanelice','Fontanelice','','BO',1,'1840-01-01','2999-12-31'),
	(31844,'08','037',' 02','037027',37027,'Gaggio Montano','Gaggio Montano','','BO',1,'1840-01-01','2999-12-31'),
	(31845,'08','037',' 02','037028',37028,'Galliera','Galliera','','BO',1,'1840-01-01','2999-12-31'),
	(31846,'08','037',' 02','037029',37029,'Granaglione','Granaglione','','BO',1,'1840-01-01','2999-12-31'),
	(31847,'08','037',' 03','037030',37030,'Granarolo dell\'Emilia','Granarolo dell\'Emilia','','BO',1,'1840-01-01','2999-12-31'),
	(31848,'08','037',' 03','037031',37031,'Grizzana Morandi','Grizzana Morandi','','BO',1,'1840-01-01','2999-12-31'),
	(31849,'08','037',' 03','037032',37032,'Imola','Imola','','BO',1,'1840-01-01','2999-12-31'),
	(31850,'08','037',' 03','037033',37033,'Lizzano in Belvedere','Lizzano in Belvedere','','BO',1,'1840-01-01','2999-12-31'),
	(31851,'08','037',' 03','037034',37034,'Loiano','Loiano','','BO',1,'1840-01-01','2999-12-31'),
	(31852,'08','037',' 03','037035',37035,'Malalbergo','Malalbergo','','BO',1,'1840-01-01','2999-12-31'),
	(31853,'08','037',' 03','037036',37036,'Marzabotto','Marzabotto','','BO',1,'1840-01-01','2999-12-31'),
	(31854,'08','037',' 03','037037',37037,'Medicina','Medicina','','BO',1,'1840-01-01','2999-12-31'),
	(31855,'08','037',' 03','037038',37038,'Minerbio','Minerbio','','BO',1,'1840-01-01','2999-12-31'),
	(31856,'08','037',' 03','037039',37039,'Molinella','Molinella','','BO',1,'1840-01-01','2999-12-31'),
	(31857,'08','037',' 04','037040',37040,'Monghidoro','Monghidoro','','BO',1,'1840-01-01','2999-12-31'),
	(31858,'08','037',' 04','037041',37041,'Monterenzio','Monterenzio','','BO',1,'1840-01-01','2999-12-31'),
	(31859,'08','037',' 04','037042',37042,'Monte San Pietro','Monte San Pietro','','BO',1,'1840-01-01','2999-12-31'),
	(31860,'08','037',' 04','037043',37043,'Monteveglio','Monteveglio','','BO',1,'1840-01-01','2999-12-31'),
	(31861,'08','037',' 04','037044',37044,'Monzuno','Monzuno','','BO',1,'1840-01-01','2999-12-31'),
	(31862,'08','037',' 04','037045',37045,'Mordano','Mordano','','BO',1,'1840-01-01','2999-12-31'),
	(31863,'08','037',' 04','037046',37046,'Ozzano dell\'Emilia','Ozzano dell\'Emilia','','BO',1,'1840-01-01','2999-12-31'),
	(31864,'08','037',' 04','037047',37047,'Pianoro','Pianoro','','BO',1,'1840-01-01','2999-12-31'),
	(31865,'08','037',' 04','037048',37048,'Pieve di Cento','Pieve di Cento','','BO',1,'1840-01-01','2999-12-31'),
	(31866,'08','037',' 04','037049',37049,'Porretta Terme','Porretta Terme','','BO',1,'1840-01-01','2999-12-31'),
	(31867,'08','037',' 05','037050',37050,'Sala Bolognese','Sala Bolognese','','BO',1,'1840-01-01','2999-12-31'),
	(31868,'08','037',' 05','037051',37051,'San Benedetto Val di Sambro','San Benedetto Val di Sambro','','BO',1,'1840-01-01','2999-12-31'),
	(31869,'08','037',' 05','037052',37052,'San Giorgio di Piano','San Giorgio di Piano','','BO',1,'1840-01-01','2999-12-31'),
	(31870,'08','037',' 05','037053',37053,'San Giovanni in Persiceto','San Giovanni in Persiceto','','BO',1,'1840-01-01','2999-12-31'),
	(31871,'08','037',' 05','037054',37054,'San Lazzaro di Savena','San Lazzaro di Savena','','BO',1,'1840-01-01','2999-12-31'),
	(31872,'08','037',' 05','037055',37055,'San Pietro in Casale','San Pietro in Casale','','BO',1,'1840-01-01','2999-12-31'),
	(31873,'08','037',' 05','037056',37056,'Sant\'Agata Bolognese','Sant\'Agata Bolognese','','BO',1,'1840-01-01','2999-12-31'),
	(31874,'08','037',' 05','037057',37057,'Sasso Marconi','Sasso Marconi','','BO',1,'1840-01-01','2999-12-31'),
	(31875,'08','037',' 05','037058',37058,'Savigno','Savigno','','BO',1,'1840-01-01','2999-12-31'),
	(31876,'08','037',' 05','037059',37059,'Vergato','Vergato','','BO',1,'1840-01-01','2999-12-31'),
	(31877,'08','037',' 06','037060',37060,'Zola Predosa','Zola Predosa','','BO',1,'1840-01-01','2999-12-31'),
	(31878,'08','038',' 00','038001',38001,'Argenta','Argenta','','FE',1,'1840-01-01','2999-12-31'),
	(31879,'08','038',' 00','038002',38002,'Berra','Berra','','FE',1,'1840-01-01','2999-12-31'),
	(31880,'08','038',' 00','038003',38003,'Bondeno','Bondeno','','FE',1,'1840-01-01','2999-12-31'),
	(31881,'08','038',' 00','038004',38004,'Cento','Cento','','FE',1,'1840-01-01','2999-12-31'),
	(31882,'08','038',' 00','038005',38005,'Codigoro','Codigoro','','FE',1,'1840-01-01','2999-12-31'),
	(31883,'08','038',' 00','038006',38006,'Comacchio','Comacchio','','FE',1,'1840-01-01','2999-12-31'),
	(31884,'08','038',' 00','038007',38007,'Copparo','Copparo','','FE',1,'1840-01-01','2999-12-31'),
	(31885,'08','038',' 00','038008',38008,'Ferrara','Ferrara','','FE',1,'1840-01-01','2999-12-31'),
	(31886,'08','038',' 00','038009',38009,'Formignana','Formignana','','FE',1,'1840-01-01','2999-12-31'),
	(31887,'08','038',' 01','038010',38010,'Jolanda di Savoia','Jolanda di Savoia','','FE',1,'1840-01-01','2999-12-31'),
	(31888,'08','038',' 01','038011',38011,'Lagosanto','Lagosanto','','FE',1,'1840-01-01','2999-12-31'),
	(31889,'08','038',' 01','038012',38012,'Masi Torello','Masi Torello','','FE',1,'1840-01-01','2999-12-31'),
	(31890,'08','038',' 01','038013',38013,'Massa Fiscaglia','Massa Fiscaglia','','FE',1,'1840-01-01','2999-12-31'),
	(31891,'08','038',' 01','038014',38014,'Mesola','Mesola','','FE',1,'1840-01-01','2999-12-31'),
	(31892,'08','038',' 01','038015',38015,'Migliarino','Migliarino','','FE',1,'1840-01-01','2999-12-31'),
	(31893,'08','038',' 01','038016',38016,'Mirabello','Mirabello','','FE',1,'1840-01-01','2999-12-31'),
	(31894,'08','038',' 01','038017',38017,'Ostellato','Ostellato','','FE',1,'1840-01-01','2999-12-31'),
	(31895,'08','038',' 01','038018',38018,'Poggio Renatico','Poggio Renatico','','FE',1,'1840-01-01','2999-12-31'),
	(31896,'08','038',' 01','038019',38019,'Portomaggiore','Portomaggiore','','FE',1,'1840-01-01','2999-12-31'),
	(31897,'08','038',' 02','038020',38020,'Ro','Ro','','FE',1,'1840-01-01','2999-12-31'),
	(31898,'08','038',' 02','038021',38021,'Sant\'Agostino','Sant\'Agostino','','FE',1,'1840-01-01','2999-12-31'),
	(31899,'08','038',' 02','038022',38022,'Vigarano Mainarda','Vigarano Mainarda','','FE',1,'1840-01-01','2999-12-31'),
	(31900,'08','038',' 02','038023',38023,'Voghiera','Voghiera','','FE',1,'1840-01-01','2999-12-31'),
	(31901,'08','038',' 02','038024',38024,'Tresigallo','Tresigallo','','FE',1,'1840-01-01','2999-12-31'),
	(31902,'08','038',' 02','038025',38025,'Goro','Goro','','FE',1,'1840-01-01','2999-12-31'),
	(31903,'08','038',' 02','038026',38026,'Migliaro','Migliaro','','FE',1,'1840-01-01','2999-12-31'),
	(31904,'08','039',' 00','039001',39001,'Alfonsine','Alfonsine','','RA',1,'1840-01-01','2999-12-31'),
	(31905,'08','039',' 00','039002',39002,'Bagnacavallo','Bagnacavallo','','RA',1,'1840-01-01','2999-12-31'),
	(31906,'08','039',' 00','039003',39003,'Bagnara di Romagna','Bagnara di Romagna','','RA',1,'1840-01-01','2999-12-31'),
	(31907,'08','039',' 00','039004',39004,'Brisighella','Brisighella','','RA',1,'1840-01-01','2999-12-31'),
	(31908,'08','039',' 00','039005',39005,'Casola Valsenio','Casola Valsenio','','RA',1,'1840-01-01','2999-12-31'),
	(31909,'08','039',' 00','039006',39006,'Castel Bolognese','Castel Bolognese','','RA',1,'1840-01-01','2999-12-31'),
	(31910,'08','039',' 00','039007',39007,'Cervia','Cervia','','RA',1,'1840-01-01','2999-12-31'),
	(31911,'08','039',' 00','039008',39008,'Conselice','Conselice','','RA',1,'1840-01-01','2999-12-31'),
	(31912,'08','039',' 00','039009',39009,'Cotignola','Cotignola','','RA',1,'1840-01-01','2999-12-31'),
	(31913,'08','039',' 01','039010',39010,'Faenza','Faenza','','RA',1,'1840-01-01','2999-12-31'),
	(31914,'08','039',' 01','039011',39011,'Fusignano','Fusignano','','RA',1,'1840-01-01','2999-12-31'),
	(31915,'08','039',' 01','039012',39012,'Lugo','Lugo','','RA',1,'1840-01-01','2999-12-31'),
	(31916,'08','039',' 01','039013',39013,'Massa Lombarda','Massa Lombarda','','RA',1,'1840-01-01','2999-12-31'),
	(31917,'08','039',' 01','039014',39014,'Ravenna','Ravenna','','RA',1,'1840-01-01','2999-12-31'),
	(31918,'08','039',' 01','039015',39015,'Riolo Terme','Riolo Terme','','RA',1,'1840-01-01','2999-12-31'),
	(31919,'08','039',' 01','039016',39016,'Russi','Russi','','RA',1,'1840-01-01','2999-12-31'),
	(31920,'08','039',' 01','039017',39017,'Sant\'Agata sul Santerno','Sant\'Agata sul Santerno','','RA',1,'1840-01-01','2999-12-31'),
	(31921,'08','039',' 01','039018',39018,'Solarolo','Solarolo','','RA',1,'1840-01-01','2999-12-31'),
	(31922,'08','040',' 00','040001',40001,'Bagno di Romagna','Bagno di Romagna','','FC',1,'1840-01-01','2999-12-31'),
	(31923,'08','040',' 00','040003',40003,'Bertinoro','Bertinoro','','FC',1,'1840-01-01','2999-12-31'),
	(31924,'08','040',' 00','040004',40004,'Borghi','Borghi','','FC',1,'1840-01-01','2999-12-31'),
	(31925,'08','040',' 00','040005',40005,'Castrocaro Terme e Terra del Sole','Castrocaro Terme e Terra del Sole','','FC',1,'1840-01-01','2999-12-31'),
	(31926,'08','040',' 00','040007',40007,'Cesena','Cesena','','FC',1,'1840-01-01','2999-12-31'),
	(31927,'08','040',' 00','040008',40008,'Cesenatico','Cesenatico','','FC',1,'1840-01-01','2999-12-31'),
	(31928,'08','040',' 00','040009',40009,'Civitella di Romagna','Civitella di Romagna','','FC',1,'1840-01-01','2999-12-31'),
	(31929,'08','040',' 01','040011',40011,'Dovadola','Dovadola','','FC',1,'1840-01-01','2999-12-31'),
	(31930,'08','040',' 01','040012',40012,'Forlì','Forlì','','FC',1,'1840-01-01','2999-12-31'),
	(31931,'08','040',' 01','040013',40013,'Forlimpopoli','Forlimpopoli','','FC',1,'1840-01-01','2999-12-31'),
	(31932,'08','040',' 01','040014',40014,'Galeata','Galeata','','FC',1,'1840-01-01','2999-12-31'),
	(31933,'08','040',' 01','040015',40015,'Gambettola','Gambettola','','FC',1,'1840-01-01','2999-12-31'),
	(31934,'08','040',' 01','040016',40016,'Gatteo','Gatteo','','FC',1,'1840-01-01','2999-12-31'),
	(31935,'08','040',' 01','040018',40018,'Longiano','Longiano','','FC',1,'1840-01-01','2999-12-31'),
	(31936,'08','040',' 01','040019',40019,'Meldola','Meldola','','FC',1,'1840-01-01','2999-12-31'),
	(31937,'08','040',' 02','040020',40020,'Mercato Saraceno','Mercato Saraceno','','FC',1,'1840-01-01','2999-12-31'),
	(31938,'08','040',' 02','040022',40022,'Modigliana','Modigliana','','FC',1,'1840-01-01','2999-12-31'),
	(31939,'08','040',' 02','040028',40028,'Montiano','Montiano','','FC',1,'1840-01-01','2999-12-31'),
	(31940,'08','040',' 03','040031',40031,'Portico e San Benedetto','Portico e San Benedetto','','FC',1,'1840-01-01','2999-12-31'),
	(31941,'08','040',' 03','040032',40032,'Predappio','Predappio','','FC',1,'1840-01-01','2999-12-31'),
	(31942,'08','040',' 03','040033',40033,'Premilcuore','Premilcuore','','FC',1,'1840-01-01','2999-12-31'),
	(31943,'08','040',' 03','040036',40036,'Rocca San Casciano','Rocca San Casciano','','FC',1,'1840-01-01','2999-12-31'),
	(31944,'08','040',' 03','040037',40037,'Roncofreddo','Roncofreddo','','FC',1,'1840-01-01','2999-12-31'),
	(31945,'08','040',' 04','040041',40041,'San Mauro Pascoli','San Mauro Pascoli','','FC',1,'1840-01-01','2999-12-31'),
	(31946,'08','040',' 04','040043',40043,'Santa Sofia','Santa Sofia','','FC',1,'1840-01-01','2999-12-31'),
	(31947,'08','040',' 04','040044',40044,'Sarsina','Sarsina','','FC',1,'1840-01-01','2999-12-31'),
	(31948,'08','040',' 04','040045',40045,'Savignano sul Rubicone','Savignano sul Rubicone','','FC',1,'1840-01-01','2999-12-31'),
	(31949,'08','040',' 04','040046',40046,'Sogliano al Rubicone','Sogliano al Rubicone','','FC',1,'1840-01-01','2999-12-31'),
	(31950,'08','040',' 04','040049',40049,'Tredozio','Tredozio','','FC',1,'1840-01-01','2999-12-31'),
	(31951,'08','040',' 05','040050',40050,'Verghereto','Verghereto','','FC',1,'1840-01-01','2999-12-31'),
	(31952,'11','041',' 00','041001',41001,'Acqualagna','Acqualagna','','PU',1,'1840-01-01','2999-12-31'),
	(31953,'11','041',' 00','041002',41002,'Apecchio','Apecchio','','PU',1,'1840-01-01','2999-12-31'),
	(31954,'11','041',' 00','041003',41003,'Auditore','Auditore','','PU',1,'1840-01-01','2999-12-31'),
	(31955,'11','041',' 00','041004',41004,'Barchi','Barchi','','PU',1,'1840-01-01','2999-12-31'),
	(31956,'11','041',' 00','041005',41005,'Belforte all\'Isauro','Belforte all\'Isauro','','PU',1,'1840-01-01','2999-12-31'),
	(31957,'11','041',' 00','041006',41006,'Borgo Pace','Borgo Pace','','PU',1,'1840-01-01','2999-12-31'),
	(31958,'11','041',' 00','041007',41007,'Cagli','Cagli','','PU',1,'1840-01-01','2999-12-31'),
	(31959,'11','041',' 00','041008',41008,'Cantiano','Cantiano','','PU',1,'1840-01-01','2999-12-31'),
	(31960,'11','041',' 00','041009',41009,'Carpegna','Carpegna','','PU',1,'1840-01-01','2999-12-31'),
	(31961,'11','041',' 01','041010',41010,'Cartoceto','Cartoceto','','PU',1,'1840-01-01','2999-12-31'),
	(31962,'11','041',' 01','041012',41012,'Colbordolo','Colbordolo','','PU',1,'1840-01-01','2999-12-31'),
	(31963,'11','041',' 01','041013',41013,'Fano','Fano','','PU',1,'1840-01-01','2999-12-31'),
	(31964,'11','041',' 01','041014',41014,'Fermignano','Fermignano','','PU',1,'1840-01-01','2999-12-31'),
	(31965,'11','041',' 01','041015',41015,'Fossombrone','Fossombrone','','PU',1,'1840-01-01','2999-12-31'),
	(31966,'11','041',' 01','041016',41016,'Fratte Rosa','Fratte Rosa','','PU',1,'1840-01-01','2999-12-31'),
	(31967,'11','041',' 01','041017',41017,'Frontino','Frontino','','PU',1,'1840-01-01','2999-12-31'),
	(31968,'11','041',' 01','041018',41018,'Frontone','Frontone','','PU',1,'1840-01-01','2999-12-31'),
	(31969,'11','041',' 01','041019',41019,'Gabicce Mare','Gabicce Mare','','PU',1,'1840-01-01','2999-12-31'),
	(31970,'11','041',' 02','041020',41020,'Gradara','Gradara','','PU',1,'1840-01-01','2999-12-31'),
	(31971,'11','041',' 02','041021',41021,'Isola del Piano','Isola del Piano','','PU',1,'1840-01-01','2999-12-31'),
	(31972,'11','041',' 02','041022',41022,'Lunano','Lunano','','PU',1,'1840-01-01','2999-12-31'),
	(31973,'11','041',' 02','041023',41023,'Macerata Feltria','Macerata Feltria','','PU',1,'1840-01-01','2999-12-31'),
	(31974,'11','041',' 02','041025',41025,'Mercatello sul Metauro','Mercatello sul Metauro','','PU',1,'1840-01-01','2999-12-31'),
	(31975,'11','041',' 02','041026',41026,'Mercatino Conca','Mercatino Conca','','PU',1,'1840-01-01','2999-12-31'),
	(31976,'11','041',' 02','041027',41027,'Mombaroccio','Mombaroccio','','PU',1,'1840-01-01','2999-12-31'),
	(31977,'11','041',' 02','041028',41028,'Mondavio','Mondavio','','PU',1,'1840-01-01','2999-12-31'),
	(31978,'11','041',' 02','041029',41029,'Mondolfo','Mondolfo','','PU',1,'1840-01-01','2999-12-31'),
	(31979,'11','041',' 03','041030',41030,'Montecalvo in Foglia','Montecalvo in Foglia','','PU',1,'1840-01-01','2999-12-31'),
	(31980,'11','041',' 03','041031',41031,'Monte Cerignone','Monte Cerignone','','PU',1,'1840-01-01','2999-12-31'),
	(31981,'11','041',' 03','041032',41032,'Monteciccardo','Monteciccardo','','PU',1,'1840-01-01','2999-12-31'),
	(31982,'11','041',' 03','041033',41033,'Montecopiolo','Montecopiolo','','PU',1,'1840-01-01','2999-12-31'),
	(31983,'11','041',' 03','041034',41034,'Montefelcino','Montefelcino','','PU',1,'1840-01-01','2999-12-31'),
	(31984,'11','041',' 03','041035',41035,'Monte Grimano Terme','Monte Grimano Terme','','PU',1,'1840-01-01','2999-12-31'),
	(31985,'11','041',' 03','041036',41036,'Montelabbate','Montelabbate','','PU',1,'1840-01-01','2999-12-31'),
	(31986,'11','041',' 03','041037',41037,'Montemaggiore al Metauro','Montemaggiore al Metauro','','PU',1,'1840-01-01','2999-12-31'),
	(31987,'11','041',' 03','041038',41038,'Monte Porzio','Monte Porzio','','PU',1,'1840-01-01','2999-12-31'),
	(31988,'11','041',' 04','041040',41040,'Orciano di Pesaro','Orciano di Pesaro','','PU',1,'1840-01-01','2999-12-31'),
	(31989,'11','041',' 04','041041',41041,'Peglio','Peglio','','PU',1,'1840-01-01','2999-12-31'),
	(31990,'11','041',' 04','041043',41043,'Pergola','Pergola','','PU',1,'1840-01-01','2999-12-31'),
	(31991,'11','041',' 04','041044',41044,'Pesaro','Pesaro','','PU',1,'1840-01-01','2999-12-31'),
	(31992,'11','041',' 04','041045',41045,'Petriano','Petriano','','PU',1,'1840-01-01','2999-12-31'),
	(31993,'11','041',' 04','041046',41046,'Piagge','Piagge','','PU',1,'1840-01-01','2999-12-31'),
	(31994,'11','041',' 04','041047',41047,'Piandimeleto','Piandimeleto','','PU',1,'1840-01-01','2999-12-31'),
	(31995,'11','041',' 04','041048',41048,'Pietrarubbia','Pietrarubbia','','PU',1,'1840-01-01','2999-12-31'),
	(31996,'11','041',' 04','041049',41049,'Piobbico','Piobbico','','PU',1,'1840-01-01','2999-12-31'),
	(31997,'11','041',' 05','041050',41050,'Saltara','Saltara','','PU',1,'1840-01-01','2999-12-31'),
	(31998,'11','041',' 05','041051',41051,'San Costanzo','San Costanzo','','PU',1,'1840-01-01','2999-12-31'),
	(31999,'11','041',' 05','041052',41052,'San Giorgio di Pesaro','San Giorgio di Pesaro','','PU',1,'1840-01-01','2999-12-31'),
	(32000,'11','041',' 05','041054',41054,'San Lorenzo in Campo','San Lorenzo in Campo','','PU',1,'1840-01-01','2999-12-31'),
	(32001,'11','041',' 05','041056',41056,'Sant\'Angelo in Lizzola','Sant\'Angelo in Lizzola','','PU',1,'1840-01-01','2999-12-31'),
	(32002,'11','041',' 05','041057',41057,'Sant\'Angelo in Vado','Sant\'Angelo in Vado','','PU',1,'1840-01-01','2999-12-31'),
	(32003,'11','041',' 05','041058',41058,'Sant\'Ippolito','Sant\'Ippolito','','PU',1,'1840-01-01','2999-12-31'),
	(32004,'11','041',' 05','041059',41059,'Sassocorvaro','Sassocorvaro','','PU',1,'1840-01-01','2999-12-31'),
	(32005,'11','041',' 06','041060',41060,'Sassofeltrio','Sassofeltrio','','PU',1,'1840-01-01','2999-12-31'),
	(32006,'11','041',' 06','041061',41061,'Serra Sant\'Abbondio','Serra Sant\'Abbondio','','PU',1,'1840-01-01','2999-12-31'),
	(32007,'11','041',' 06','041062',41062,'Serrungarina','Serrungarina','','PU',1,'1840-01-01','2999-12-31'),
	(32008,'11','041',' 06','041064',41064,'Tavoleto','Tavoleto','','PU',1,'1840-01-01','2999-12-31'),
	(32009,'11','041',' 06','041065',41065,'Tavullia','Tavullia','','PU',1,'1840-01-01','2999-12-31'),
	(32010,'11','041',' 06','041066',41066,'Urbania','Urbania','','PU',1,'1840-01-01','2999-12-31'),
	(32011,'11','041',' 06','041067',41067,'Urbino','Urbino','','PU',1,'1840-01-01','2999-12-31'),
	(32012,'11','042',' 00','042001',42001,'Agugliano','Agugliano','','AN',1,'1840-01-01','2999-12-31'),
	(32013,'11','042',' 00','042002',42002,'Ancona','Ancona','','AN',1,'1840-01-01','2999-12-31'),
	(32014,'11','042',' 00','042003',42003,'Arcevia','Arcevia','','AN',1,'1840-01-01','2999-12-31'),
	(32015,'11','042',' 00','042004',42004,'Barbara','Barbara','','AN',1,'1840-01-01','2999-12-31'),
	(32016,'11','042',' 00','042005',42005,'Belvedere Ostrense','Belvedere Ostrense','','AN',1,'1840-01-01','2999-12-31'),
	(32017,'11','042',' 00','042006',42006,'Camerano','Camerano','','AN',1,'1840-01-01','2999-12-31'),
	(32018,'11','042',' 00','042007',42007,'Camerata Picena','Camerata Picena','','AN',1,'1840-01-01','2999-12-31'),
	(32019,'11','042',' 00','042008',42008,'Castelbellino','Castelbellino','','AN',1,'1840-01-01','2999-12-31'),
	(32020,'11','042',' 00','042009',42009,'Castel Colonna','Castel Colonna','','AN',1,'1840-01-01','2999-12-31'),
	(32021,'11','042',' 01','042010',42010,'Castelfidardo','Castelfidardo','','AN',1,'1840-01-01','2999-12-31'),
	(32022,'11','042',' 01','042011',42011,'Castelleone di Suasa','Castelleone di Suasa','','AN',1,'1840-01-01','2999-12-31'),
	(32023,'11','042',' 01','042012',42012,'Castelplanio','Castelplanio','','AN',1,'1840-01-01','2999-12-31'),
	(32024,'11','042',' 01','042013',42013,'Cerreto d\'Esi','Cerreto d\'Esi','','AN',1,'1840-01-01','2999-12-31'),
	(32025,'11','042',' 01','042014',42014,'Chiaravalle','Chiaravalle','','AN',1,'1840-01-01','2999-12-31'),
	(32026,'11','042',' 01','042015',42015,'Corinaldo','Corinaldo','','AN',1,'1840-01-01','2999-12-31'),
	(32027,'11','042',' 01','042016',42016,'Cupramontana','Cupramontana','','AN',1,'1840-01-01','2999-12-31'),
	(32028,'11','042',' 01','042017',42017,'Fabriano','Fabriano','','AN',1,'1840-01-01','2999-12-31'),
	(32029,'11','042',' 01','042018',42018,'Falconara Marittima','Falconara Marittima','','AN',1,'1840-01-01','2999-12-31'),
	(32030,'11','042',' 01','042019',42019,'Filottrano','Filottrano','','AN',1,'1840-01-01','2999-12-31'),
	(32031,'11','042',' 02','042020',42020,'Genga','Genga','','AN',1,'1840-01-01','2999-12-31'),
	(32032,'11','042',' 02','042021',42021,'Jesi','Jesi','','AN',1,'1840-01-01','2999-12-31'),
	(32033,'11','042',' 02','042022',42022,'Loreto','Loreto','','AN',1,'1840-01-01','2999-12-31'),
	(32034,'11','042',' 02','042023',42023,'Maiolati Spontini','Maiolati Spontini','','AN',1,'1840-01-01','2999-12-31'),
	(32035,'11','042',' 02','042024',42024,'Mergo','Mergo','','AN',1,'1840-01-01','2999-12-31'),
	(32036,'11','042',' 02','042025',42025,'Monsano','Monsano','','AN',1,'1840-01-01','2999-12-31'),
	(32037,'11','042',' 02','042026',42026,'Montecarotto','Montecarotto','','AN',1,'1840-01-01','2999-12-31'),
	(32038,'11','042',' 02','042027',42027,'Montemarciano','Montemarciano','','AN',1,'1840-01-01','2999-12-31'),
	(32039,'11','042',' 02','042028',42028,'Monterado','Monterado','','AN',1,'1840-01-01','2999-12-31'),
	(32040,'11','042',' 02','042029',42029,'Monte Roberto','Monte Roberto','','AN',1,'1840-01-01','2999-12-31'),
	(32041,'11','042',' 03','042030',42030,'Monte San Vito','Monte San Vito','','AN',1,'1840-01-01','2999-12-31'),
	(32042,'11','042',' 03','042031',42031,'Morro d\'Alba','Morro d\'Alba','','AN',1,'1840-01-01','2999-12-31'),
	(32043,'11','042',' 03','042032',42032,'Numana','Numana','','AN',1,'1840-01-01','2999-12-31'),
	(32044,'11','042',' 03','042033',42033,'Offagna','Offagna','','AN',1,'1840-01-01','2999-12-31'),
	(32045,'11','042',' 03','042034',42034,'Osimo','Osimo','','AN',1,'1840-01-01','2999-12-31'),
	(32046,'11','042',' 03','042035',42035,'Ostra','Ostra','','AN',1,'1840-01-01','2999-12-31'),
	(32047,'11','042',' 03','042036',42036,'Ostra Vetere','Ostra Vetere','','AN',1,'1840-01-01','2999-12-31'),
	(32048,'11','042',' 03','042037',42037,'Poggio San Marcello','Poggio San Marcello','','AN',1,'1840-01-01','2999-12-31'),
	(32049,'11','042',' 03','042038',42038,'Polverigi','Polverigi','','AN',1,'1840-01-01','2999-12-31'),
	(32050,'11','042',' 03','042039',42039,'Ripe','Ripe','','AN',1,'1840-01-01','2999-12-31'),
	(32051,'11','042',' 04','042040',42040,'Rosora','Rosora','','AN',1,'1840-01-01','2999-12-31'),
	(32052,'11','042',' 04','042041',42041,'San Marcello','San Marcello','','AN',1,'1840-01-01','2999-12-31'),
	(32053,'11','042',' 04','042042',42042,'San Paolo di Jesi','San Paolo di Jesi','','AN',1,'1840-01-01','2999-12-31'),
	(32054,'11','042',' 04','042043',42043,'Santa Maria Nuova','Santa Maria Nuova','','AN',1,'1840-01-01','2999-12-31'),
	(32055,'11','042',' 04','042044',42044,'Sassoferrato','Sassoferrato','','AN',1,'1840-01-01','2999-12-31'),
	(32056,'11','042',' 04','042045',42045,'Senigallia','Senigallia','','AN',1,'1840-01-01','2999-12-31'),
	(32057,'11','042',' 04','042046',42046,'Serra de\' Conti','Serra de\' Conti','','AN',1,'1840-01-01','2999-12-31'),
	(32058,'11','042',' 04','042047',42047,'Serra San Quirico','Serra San Quirico','','AN',1,'1840-01-01','2999-12-31'),
	(32059,'11','042',' 04','042048',42048,'Sirolo','Sirolo','','AN',1,'1840-01-01','2999-12-31'),
	(32060,'11','042',' 04','042049',42049,'Staffolo','Staffolo','','AN',1,'1840-01-01','2999-12-31'),
	(32061,'11','043',' 00','043001',43001,'Acquacanina','Acquacanina','','MC',1,'1840-01-01','2999-12-31'),
	(32062,'11','043',' 00','043002',43002,'Apiro','Apiro','','MC',1,'1840-01-01','2999-12-31'),
	(32063,'11','043',' 00','043003',43003,'Appignano','Appignano','','MC',1,'1840-01-01','2999-12-31'),
	(32064,'11','043',' 00','043004',43004,'Belforte del Chienti','Belforte del Chienti','','MC',1,'1840-01-01','2999-12-31'),
	(32065,'11','043',' 00','043005',43005,'Bolognola','Bolognola','','MC',1,'1840-01-01','2999-12-31'),
	(32066,'11','043',' 00','043006',43006,'Caldarola','Caldarola','','MC',1,'1840-01-01','2999-12-31'),
	(32067,'11','043',' 00','043007',43007,'Camerino','Camerino','','MC',1,'1840-01-01','2999-12-31'),
	(32068,'11','043',' 00','043008',43008,'Camporotondo di Fiastrone','Camporotondo di Fiastrone','','MC',1,'1840-01-01','2999-12-31'),
	(32069,'11','043',' 00','043009',43009,'Castelraimondo','Castelraimondo','','MC',1,'1840-01-01','2999-12-31'),
	(32070,'11','043',' 01','043010',43010,'Castelsantangelo sul Nera','Castelsantangelo sul Nera','','MC',1,'1840-01-01','2999-12-31'),
	(32071,'11','043',' 01','043011',43011,'Cessapalombo','Cessapalombo','','MC',1,'1840-01-01','2999-12-31'),
	(32072,'11','043',' 01','043012',43012,'Cingoli','Cingoli','','MC',1,'1840-01-01','2999-12-31'),
	(32073,'11','043',' 01','043013',43013,'Civitanova Marche','Civitanova Marche','','MC',1,'1840-01-01','2999-12-31'),
	(32074,'11','043',' 01','043014',43014,'Colmurano','Colmurano','','MC',1,'1840-01-01','2999-12-31'),
	(32075,'11','043',' 01','043015',43015,'Corridonia','Corridonia','','MC',1,'1840-01-01','2999-12-31'),
	(32076,'11','043',' 01','043016',43016,'Esanatoglia','Esanatoglia','','MC',1,'1840-01-01','2999-12-31'),
	(32077,'11','043',' 01','043017',43017,'Fiastra','Fiastra','','MC',1,'1840-01-01','2999-12-31'),
	(32078,'11','043',' 01','043018',43018,'Fiordimonte','Fiordimonte','','MC',1,'1840-01-01','2999-12-31'),
	(32079,'11','043',' 01','043019',43019,'Fiuminata','Fiuminata','','MC',1,'1840-01-01','2999-12-31'),
	(32080,'11','043',' 02','043020',43020,'Gagliole','Gagliole','','MC',1,'1840-01-01','2999-12-31'),
	(32081,'11','043',' 02','043021',43021,'Gualdo','Gualdo','','MC',1,'1840-01-01','2999-12-31'),
	(32082,'11','043',' 02','043022',43022,'Loro Piceno','Loro Piceno','','MC',1,'1840-01-01','2999-12-31'),
	(32083,'11','043',' 02','043023',43023,'Macerata','Macerata','','MC',1,'1840-01-01','2999-12-31'),
	(32084,'11','043',' 02','043024',43024,'Matelica','Matelica','','MC',1,'1840-01-01','2999-12-31'),
	(32085,'11','043',' 02','043025',43025,'Mogliano','Mogliano','','MC',1,'1840-01-01','2999-12-31'),
	(32086,'11','043',' 02','043026',43026,'Montecassiano','Montecassiano','','MC',1,'1840-01-01','2999-12-31'),
	(32087,'11','043',' 02','043027',43027,'Monte Cavallo','Monte Cavallo','','MC',1,'1840-01-01','2999-12-31'),
	(32088,'11','043',' 02','043028',43028,'Montecosaro','Montecosaro','','MC',1,'1840-01-01','2999-12-31'),
	(32089,'11','043',' 02','043029',43029,'Montefano','Montefano','','MC',1,'1840-01-01','2999-12-31'),
	(32090,'11','043',' 03','043030',43030,'Montelupone','Montelupone','','MC',1,'1840-01-01','2999-12-31'),
	(32091,'11','043',' 03','043031',43031,'Monte San Giusto','Monte San Giusto','','MC',1,'1840-01-01','2999-12-31'),
	(32092,'11','043',' 03','043032',43032,'Monte San Martino','Monte San Martino','','MC',1,'1840-01-01','2999-12-31'),
	(32093,'11','043',' 03','043033',43033,'Morrovalle','Morrovalle','','MC',1,'1840-01-01','2999-12-31'),
	(32094,'11','043',' 03','043034',43034,'Muccia','Muccia','','MC',1,'1840-01-01','2999-12-31'),
	(32095,'11','043',' 03','043035',43035,'Penna San Giovanni','Penna San Giovanni','','MC',1,'1840-01-01','2999-12-31'),
	(32096,'11','043',' 03','043036',43036,'Petriolo','Petriolo','','MC',1,'1840-01-01','2999-12-31'),
	(32097,'11','043',' 03','043037',43037,'Pievebovigliana','Pievebovigliana','','MC',1,'1840-01-01','2999-12-31'),
	(32098,'11','043',' 03','043038',43038,'Pieve Torina','Pieve Torina','','MC',1,'1840-01-01','2999-12-31'),
	(32099,'11','043',' 03','043039',43039,'Pioraco','Pioraco','','MC',1,'1840-01-01','2999-12-31'),
	(32100,'11','043',' 04','043040',43040,'Poggio San Vicino','Poggio San Vicino','','MC',1,'1840-01-01','2999-12-31'),
	(32101,'11','043',' 04','043041',43041,'Pollenza','Pollenza','','MC',1,'1840-01-01','2999-12-31'),
	(32102,'11','043',' 04','043042',43042,'Porto Recanati','Porto Recanati','','MC',1,'1840-01-01','2999-12-31'),
	(32103,'11','043',' 04','043043',43043,'Potenza Picena','Potenza Picena','','MC',1,'1840-01-01','2999-12-31'),
	(32104,'11','043',' 04','043044',43044,'Recanati','Recanati','','MC',1,'1840-01-01','2999-12-31'),
	(32105,'11','043',' 04','043045',43045,'Ripe San Ginesio','Ripe San Ginesio','','MC',1,'1840-01-01','2999-12-31'),
	(32106,'11','043',' 04','043046',43046,'San Ginesio','San Ginesio','','MC',1,'1840-01-01','2999-12-31'),
	(32107,'11','043',' 04','043047',43047,'San Severino Marche','San Severino Marche','','MC',1,'1840-01-01','2999-12-31'),
	(32108,'11','043',' 04','043048',43048,'Sant\'Angelo in Pontano','Sant\'Angelo in Pontano','','MC',1,'1840-01-01','2999-12-31'),
	(32109,'11','043',' 04','043049',43049,'Sarnano','Sarnano','','MC',1,'1840-01-01','2999-12-31'),
	(32110,'11','043',' 05','043050',43050,'Sefro','Sefro','','MC',1,'1840-01-01','2999-12-31'),
	(32111,'11','043',' 05','043051',43051,'Serrapetrona','Serrapetrona','','MC',1,'1840-01-01','2999-12-31'),
	(32112,'11','043',' 05','043052',43052,'Serravalle di Chienti','Serravalle di Chienti','','MC',1,'1840-01-01','2999-12-31'),
	(32113,'11','043',' 05','043053',43053,'Tolentino','Tolentino','','MC',1,'1840-01-01','2999-12-31'),
	(32114,'11','043',' 05','043054',43054,'Treia','Treia','','MC',1,'1840-01-01','2999-12-31'),
	(32115,'11','043',' 05','043055',43055,'Urbisaglia','Urbisaglia','','MC',1,'1840-01-01','2999-12-31'),
	(32116,'11','043',' 05','043056',43056,'Ussita','Ussita','','MC',1,'1840-01-01','2999-12-31'),
	(32117,'11','043',' 05','043057',43057,'Visso','Visso','','MC',1,'1840-01-01','2999-12-31'),
	(32118,'11','044',' 00','044001',44001,'Acquasanta Terme','Acquasanta Terme','','AP',1,'1840-01-01','2999-12-31'),
	(32119,'11','044',' 00','044002',44002,'Acquaviva Picena','Acquaviva Picena','','AP',1,'1840-01-01','2999-12-31'),
	(32120,'11','044',' 00','044005',44005,'Appignano del Tronto','Appignano del Tronto','','AP',1,'1840-01-01','2999-12-31'),
	(32121,'11','044',' 00','044006',44006,'Arquata del Tronto','Arquata del Tronto','','AP',1,'1840-01-01','2999-12-31'),
	(32122,'11','044',' 00','044007',44007,'Ascoli Piceno','Ascoli Piceno','','AP',1,'1840-01-01','2999-12-31'),
	(32123,'11','044',' 01','044010',44010,'Carassai','Carassai','','AP',1,'1840-01-01','2999-12-31'),
	(32124,'11','044',' 01','044011',44011,'Castel di Lama','Castel di Lama','','AP',1,'1840-01-01','2999-12-31'),
	(32125,'11','044',' 01','044012',44012,'Castignano','Castignano','','AP',1,'1840-01-01','2999-12-31'),
	(32126,'11','044',' 01','044013',44013,'Castorano','Castorano','','AP',1,'1840-01-01','2999-12-31'),
	(32127,'11','044',' 01','044014',44014,'Colli del Tronto','Colli del Tronto','','AP',1,'1840-01-01','2999-12-31'),
	(32128,'11','044',' 01','044015',44015,'Comunanza','Comunanza','','AP',1,'1840-01-01','2999-12-31'),
	(32129,'11','044',' 01','044016',44016,'Cossignano','Cossignano','','AP',1,'1840-01-01','2999-12-31'),
	(32130,'11','044',' 01','044017',44017,'Cupra Marittima','Cupra Marittima','','AP',1,'1840-01-01','2999-12-31'),
	(32131,'11','044',' 02','044020',44020,'Folignano','Folignano','','AP',1,'1840-01-01','2999-12-31'),
	(32132,'11','044',' 02','044021',44021,'Force','Force','','AP',1,'1840-01-01','2999-12-31'),
	(32133,'11','044',' 02','044023',44023,'Grottammare','Grottammare','','AP',1,'1840-01-01','2999-12-31'),
	(32134,'11','044',' 02','044027',44027,'Maltignano','Maltignano','','AP',1,'1840-01-01','2999-12-31'),
	(32135,'11','044',' 02','044029',44029,'Massignano','Massignano','','AP',1,'1840-01-01','2999-12-31'),
	(32136,'11','044',' 03','044031',44031,'Monsampolo del Tronto','Monsampolo del Tronto','','AP',1,'1840-01-01','2999-12-31'),
	(32137,'11','044',' 03','044032',44032,'Montalto delle Marche','Montalto delle Marche','','AP',1,'1840-01-01','2999-12-31'),
	(32138,'11','044',' 03','044034',44034,'Montedinove','Montedinove','','AP',1,'1840-01-01','2999-12-31'),
	(32139,'11','044',' 03','044036',44036,'Montefiore dell\'Aso','Montefiore dell\'Aso','','AP',1,'1840-01-01','2999-12-31'),
	(32140,'11','044',' 03','044038',44038,'Montegallo','Montegallo','','AP',1,'1840-01-01','2999-12-31'),
	(32141,'11','044',' 04','044044',44044,'Montemonaco','Montemonaco','','AP',1,'1840-01-01','2999-12-31'),
	(32142,'11','044',' 04','044045',44045,'Monteprandone','Monteprandone','','AP',1,'1840-01-01','2999-12-31'),
	(32143,'11','044',' 05','044054',44054,'Offida','Offida','','AP',1,'1840-01-01','2999-12-31'),
	(32144,'11','044',' 05','044056',44056,'Palmiano','Palmiano','','AP',1,'1840-01-01','2999-12-31'),
	(32145,'11','044',' 06','044063',44063,'Ripatransone','Ripatransone','','AP',1,'1840-01-01','2999-12-31'),
	(32146,'11','044',' 06','044064',44064,'Roccafluvione','Roccafluvione','','AP',1,'1840-01-01','2999-12-31'),
	(32147,'11','044',' 06','044065',44065,'Rotella','Rotella','','AP',1,'1840-01-01','2999-12-31'),
	(32148,'11','044',' 06','044066',44066,'San Benedetto del Tronto','San Benedetto del Tronto','','AP',1,'1840-01-01','2999-12-31'),
	(32149,'11','044',' 07','044071',44071,'Spinetoli','Spinetoli','','AP',1,'1840-01-01','2999-12-31'),
	(32150,'11','044',' 07','044073',44073,'Venarotta','Venarotta','','AP',1,'1840-01-01','2999-12-31'),
	(32151,'09','045',' 00','045001',45001,'Aulla','Aulla','','MS',1,'1840-01-01','2999-12-31'),
	(32152,'09','045',' 00','045002',45002,'Bagnone','Bagnone','','MS',1,'1840-01-01','2999-12-31'),
	(32153,'09','045',' 00','045003',45003,'Carrara','Carrara','','MS',1,'1840-01-01','2999-12-31'),
	(32154,'09','045',' 00','045004',45004,'Casola in Lunigiana','Casola in Lunigiana','','MS',1,'1840-01-01','2999-12-31'),
	(32155,'09','045',' 00','045005',45005,'Comano','Comano','','MS',1,'1840-01-01','2999-12-31'),
	(32156,'09','045',' 00','045006',45006,'Filattiera','Filattiera','','MS',1,'1840-01-01','2999-12-31'),
	(32157,'09','045',' 00','045007',45007,'Fivizzano','Fivizzano','','MS',1,'1840-01-01','2999-12-31'),
	(32158,'09','045',' 00','045008',45008,'Fosdinovo','Fosdinovo','','MS',1,'1840-01-01','2999-12-31'),
	(32159,'09','045',' 00','045009',45009,'Licciana Nardi','Licciana Nardi','','MS',1,'1840-01-01','2999-12-31'),
	(32160,'09','045',' 01','045010',45010,'Massa','Massa','','MS',1,'1840-01-01','2999-12-31'),
	(32161,'09','045',' 01','045011',45011,'Montignoso','Montignoso','','MS',1,'1840-01-01','2999-12-31'),
	(32162,'09','045',' 01','045012',45012,'Mulazzo','Mulazzo','','MS',1,'1840-01-01','2999-12-31'),
	(32163,'09','045',' 01','045013',45013,'Podenzana','Podenzana','','MS',1,'1840-01-01','2999-12-31'),
	(32164,'09','045',' 01','045014',45014,'Pontremoli','Pontremoli','','MS',1,'1840-01-01','2999-12-31'),
	(32165,'09','045',' 01','045015',45015,'Tresana','Tresana','','MS',1,'1840-01-01','2999-12-31'),
	(32166,'09','045',' 01','045016',45016,'Villafranca in Lunigiana','Villafranca in Lunigiana','','MS',1,'1840-01-01','2999-12-31'),
	(32167,'09','045',' 01','045017',45017,'Zeri','Zeri','','MS',1,'1840-01-01','2999-12-31'),
	(32168,'09','046',' 00','046001',46001,'Altopascio','Altopascio','','LU',1,'1840-01-01','2999-12-31'),
	(32169,'09','046',' 00','046002',46002,'Bagni di Lucca','Bagni di Lucca','','LU',1,'1840-01-01','2999-12-31'),
	(32170,'09','046',' 00','046003',46003,'Barga','Barga','','LU',1,'1840-01-01','2999-12-31'),
	(32171,'09','046',' 00','046004',46004,'Borgo a Mozzano','Borgo a Mozzano','','LU',1,'1840-01-01','2999-12-31'),
	(32172,'09','046',' 00','046005',46005,'Camaiore','Camaiore','','LU',1,'1840-01-01','2999-12-31'),
	(32173,'09','046',' 00','046006',46006,'Camporgiano','Camporgiano','','LU',1,'1840-01-01','2999-12-31'),
	(32174,'09','046',' 00','046007',46007,'Capannori','Capannori','','LU',1,'1840-01-01','2999-12-31'),
	(32175,'09','046',' 00','046008',46008,'Careggine','Careggine','','LU',1,'1840-01-01','2999-12-31'),
	(32176,'09','046',' 00','046009',46009,'Castelnuovo di Garfagnana','Castelnuovo di Garfagnana','','LU',1,'1840-01-01','2999-12-31'),
	(32177,'09','046',' 01','046010',46010,'Castiglione di Garfagnana','Castiglione di Garfagnana','','LU',1,'1840-01-01','2999-12-31'),
	(32178,'09','046',' 01','046011',46011,'Coreglia Antelminelli','Coreglia Antelminelli','','LU',1,'1840-01-01','2999-12-31'),
	(32179,'09','046',' 01','046012',46012,'Fabbriche di Vallico','Fabbriche di Vallico','','LU',1,'1840-01-01','2999-12-31'),
	(32180,'09','046',' 01','046013',46013,'Forte dei Marmi','Forte dei Marmi','','LU',1,'1840-01-01','2999-12-31'),
	(32181,'09','046',' 01','046014',46014,'Fosciandora','Fosciandora','','LU',1,'1840-01-01','2999-12-31'),
	(32182,'09','046',' 01','046015',46015,'Gallicano','Gallicano','','LU',1,'1840-01-01','2999-12-31'),
	(32183,'09','046',' 01','046016',46016,'Giuncugnano','Giuncugnano','','LU',1,'1840-01-01','2999-12-31'),
	(32184,'09','046',' 01','046017',46017,'Lucca','Lucca','','LU',1,'1840-01-01','2999-12-31'),
	(32185,'09','046',' 01','046018',46018,'Massarosa','Massarosa','','LU',1,'1840-01-01','2999-12-31'),
	(32186,'09','046',' 01','046019',46019,'Minucciano','Minucciano','','LU',1,'1840-01-01','2999-12-31'),
	(32187,'09','046',' 02','046020',46020,'Molazzana','Molazzana','','LU',1,'1840-01-01','2999-12-31'),
	(32188,'09','046',' 02','046021',46021,'Montecarlo','Montecarlo','','LU',1,'1840-01-01','2999-12-31'),
	(32189,'09','046',' 02','046022',46022,'Pescaglia','Pescaglia','','LU',1,'1840-01-01','2999-12-31'),
	(32190,'09','046',' 02','046023',46023,'Piazza al Serchio','Piazza al Serchio','','LU',1,'1840-01-01','2999-12-31'),
	(32191,'09','046',' 02','046024',46024,'Pietrasanta','Pietrasanta','','LU',1,'1840-01-01','2999-12-31'),
	(32192,'09','046',' 02','046025',46025,'Pieve Fosciana','Pieve Fosciana','','LU',1,'1840-01-01','2999-12-31'),
	(32193,'09','046',' 02','046026',46026,'Porcari','Porcari','','LU',1,'1840-01-01','2999-12-31'),
	(32194,'09','046',' 02','046027',46027,'San Romano in Garfagnana','San Romano in Garfagnana','','LU',1,'1840-01-01','2999-12-31'),
	(32195,'09','046',' 02','046028',46028,'Seravezza','Seravezza','','LU',1,'1840-01-01','2999-12-31'),
	(32196,'09','046',' 02','046029',46029,'Sillano','Sillano','','LU',1,'1840-01-01','2999-12-31'),
	(32197,'09','046',' 03','046030',46030,'Stazzema','Stazzema','','LU',1,'1840-01-01','2999-12-31'),
	(32198,'09','046',' 03','046031',46031,'Vagli Sotto','Vagli Sotto','','LU',1,'1840-01-01','2999-12-31'),
	(32199,'09','046',' 03','046032',46032,'Vergemoli','Vergemoli','','LU',1,'1840-01-01','2999-12-31'),
	(32200,'09','046',' 03','046033',46033,'Viareggio','Viareggio','','LU',1,'1840-01-01','2999-12-31'),
	(32201,'09','046',' 03','046034',46034,'Villa Basilica','Villa Basilica','','LU',1,'1840-01-01','2999-12-31'),
	(32202,'09','046',' 03','046035',46035,'Villa Collemandina','Villa Collemandina','','LU',1,'1840-01-01','2999-12-31'),
	(32203,'09','047',' 00','047001',47001,'Abetone','Abetone','','PT',1,'1840-01-01','2999-12-31'),
	(32204,'09','047',' 00','047002',47002,'Agliana','Agliana','','PT',1,'1840-01-01','2999-12-31'),
	(32205,'09','047',' 00','047003',47003,'Buggiano','Buggiano','','PT',1,'1840-01-01','2999-12-31'),
	(32206,'09','047',' 00','047004',47004,'Cutigliano','Cutigliano','','PT',1,'1840-01-01','2999-12-31'),
	(32207,'09','047',' 00','047005',47005,'Lamporecchio','Lamporecchio','','PT',1,'1840-01-01','2999-12-31'),
	(32208,'09','047',' 00','047006',47006,'Larciano','Larciano','','PT',1,'1840-01-01','2999-12-31'),
	(32209,'09','047',' 00','047007',47007,'Marliana','Marliana','','PT',1,'1840-01-01','2999-12-31'),
	(32210,'09','047',' 00','047008',47008,'Massa e Cozzile','Massa e Cozzile','','PT',1,'1840-01-01','2999-12-31'),
	(32211,'09','047',' 00','047009',47009,'Monsummano Terme','Monsummano Terme','','PT',1,'1840-01-01','2999-12-31'),
	(32212,'09','047',' 01','047010',47010,'Montale','Montale','','PT',1,'1840-01-01','2999-12-31'),
	(32213,'09','047',' 01','047011',47011,'Montecatini-Terme','Montecatini-Terme','','PT',1,'1840-01-01','2999-12-31'),
	(32214,'09','047',' 01','047012',47012,'Pescia','Pescia','','PT',1,'1840-01-01','2999-12-31'),
	(32215,'09','047',' 01','047013',47013,'Pieve a Nievole','Pieve a Nievole','','PT',1,'1840-01-01','2999-12-31'),
	(32216,'09','047',' 01','047014',47014,'Pistoia','Pistoia','','PT',1,'1840-01-01','2999-12-31'),
	(32217,'09','047',' 01','047015',47015,'Piteglio','Piteglio','','PT',1,'1840-01-01','2999-12-31'),
	(32218,'09','047',' 01','047016',47016,'Ponte Buggianese','Ponte Buggianese','','PT',1,'1840-01-01','2999-12-31'),
	(32219,'09','047',' 01','047017',47017,'Quarrata','Quarrata','','PT',1,'1840-01-01','2999-12-31'),
	(32220,'09','047',' 01','047018',47018,'Sambuca Pistoiese','Sambuca Pistoiese','','PT',1,'1840-01-01','2999-12-31'),
	(32221,'09','047',' 01','047019',47019,'San Marcello Pistoiese','San Marcello Pistoiese','','PT',1,'1840-01-01','2999-12-31'),
	(32222,'09','047',' 02','047020',47020,'Serravalle Pistoiese','Serravalle Pistoiese','','PT',1,'1840-01-01','2999-12-31'),
	(32223,'09','047',' 02','047021',47021,'Uzzano','Uzzano','','PT',1,'1840-01-01','2999-12-31'),
	(32224,'09','047',' 02','047022',47022,'Chiesina Uzzanese','Chiesina Uzzanese','','PT',1,'1840-01-01','2999-12-31'),
	(32225,'09','048',' 00','048001',48001,'Bagno a Ripoli','Bagno a Ripoli','','FI',1,'1840-01-01','2999-12-31'),
	(32226,'09','048',' 00','048002',48002,'Barberino di Mugello','Barberino di Mugello','','FI',1,'1840-01-01','2999-12-31'),
	(32227,'09','048',' 00','048003',48003,'Barberino Val d\'Elsa','Barberino Val d\'Elsa','','FI',1,'1840-01-01','2999-12-31'),
	(32228,'09','048',' 00','048004',48004,'Borgo San Lorenzo','Borgo San Lorenzo','','FI',1,'1840-01-01','2999-12-31'),
	(32229,'09','048',' 00','048005',48005,'Calenzano','Calenzano','','FI',1,'1840-01-01','2999-12-31'),
	(32230,'09','048',' 00','048006',48006,'Campi Bisenzio','Campi Bisenzio','','FI',1,'1840-01-01','2999-12-31'),
	(32231,'09','048',' 00','048008',48008,'Capraia e Limite','Capraia e Limite','','FI',1,'1840-01-01','2999-12-31'),
	(32232,'09','048',' 01','048010',48010,'Castelfiorentino','Castelfiorentino','','FI',1,'1840-01-01','2999-12-31'),
	(32233,'09','048',' 01','048011',48011,'Cerreto Guidi','Cerreto Guidi','','FI',1,'1840-01-01','2999-12-31'),
	(32234,'09','048',' 01','048012',48012,'Certaldo','Certaldo','','FI',1,'1840-01-01','2999-12-31'),
	(32235,'09','048',' 01','048013',48013,'Dicomano','Dicomano','','FI',1,'1840-01-01','2999-12-31'),
	(32236,'09','048',' 01','048014',48014,'Empoli','Empoli','','FI',1,'1840-01-01','2999-12-31'),
	(32237,'09','048',' 01','048015',48015,'Fiesole','Fiesole','','FI',1,'1840-01-01','2999-12-31'),
	(32238,'09','048',' 01','048016',48016,'Figline Valdarno','Figline Valdarno','','FI',1,'1840-01-01','2999-12-31'),
	(32239,'09','048',' 01','048017',48017,'Firenze','Firenze','','FI',1,'1840-01-01','2999-12-31'),
	(32240,'09','048',' 01','048018',48018,'Firenzuola','Firenzuola','','FI',1,'1840-01-01','2999-12-31'),
	(32241,'09','048',' 01','048019',48019,'Fucecchio','Fucecchio','','FI',1,'1840-01-01','2999-12-31'),
	(32242,'09','048',' 02','048020',48020,'Gambassi Terme','Gambassi Terme','','FI',1,'1840-01-01','2999-12-31'),
	(32243,'09','048',' 02','048021',48021,'Greve in Chianti','Greve in Chianti','','FI',1,'1840-01-01','2999-12-31'),
	(32244,'09','048',' 02','048022',48022,'Impruneta','Impruneta','','FI',1,'1840-01-01','2999-12-31'),
	(32245,'09','048',' 02','048023',48023,'Incisa in Val d\'Arno','Incisa in Val d\'Arno','','FI',1,'1840-01-01','2999-12-31'),
	(32246,'09','048',' 02','048024',48024,'Lastra a Signa','Lastra a Signa','','FI',1,'1840-01-01','2999-12-31'),
	(32247,'09','048',' 02','048025',48025,'Londa','Londa','','FI',1,'1840-01-01','2999-12-31'),
	(32248,'09','048',' 02','048026',48026,'Marradi','Marradi','','FI',1,'1840-01-01','2999-12-31'),
	(32249,'09','048',' 02','048027',48027,'Montaione','Montaione','','FI',1,'1840-01-01','2999-12-31'),
	(32250,'09','048',' 02','048028',48028,'Montelupo Fiorentino','Montelupo Fiorentino','','FI',1,'1840-01-01','2999-12-31'),
	(32251,'09','048',' 03','048030',48030,'Montespertoli','Montespertoli','','FI',1,'1840-01-01','2999-12-31'),
	(32252,'09','048',' 03','048031',48031,'Palazzuolo sul Senio','Palazzuolo sul Senio','','FI',1,'1840-01-01','2999-12-31'),
	(32253,'09','048',' 03','048032',48032,'Pelago','Pelago','','FI',1,'1840-01-01','2999-12-31'),
	(32254,'09','048',' 03','048033',48033,'Pontassieve','Pontassieve','','FI',1,'1840-01-01','2999-12-31'),
	(32255,'09','048',' 03','048035',48035,'Reggello','Reggello','','FI',1,'1840-01-01','2999-12-31'),
	(32256,'09','048',' 03','048036',48036,'Rignano sull\'Arno','Rignano sull\'Arno','','FI',1,'1840-01-01','2999-12-31'),
	(32257,'09','048',' 03','048037',48037,'Rufina','Rufina','','FI',1,'1840-01-01','2999-12-31'),
	(32258,'09','048',' 03','048038',48038,'San Casciano in Val di Pesa','San Casciano in Val di Pesa','','FI',1,'1840-01-01','2999-12-31'),
	(32259,'09','048',' 03','048039',48039,'San Godenzo','San Godenzo','','FI',1,'1840-01-01','2999-12-31'),
	(32260,'09','048',' 04','048040',48040,'San Piero a Sieve','San Piero a Sieve','','FI',1,'1840-01-01','2999-12-31'),
	(32261,'09','048',' 04','048041',48041,'Scandicci','Scandicci','','FI',1,'1840-01-01','2999-12-31'),
	(32262,'09','048',' 04','048042',48042,'Scarperia','Scarperia','','FI',1,'1840-01-01','2999-12-31'),
	(32263,'09','048',' 04','048043',48043,'Sesto Fiorentino','Sesto Fiorentino','','FI',1,'1840-01-01','2999-12-31'),
	(32264,'09','048',' 04','048044',48044,'Signa','Signa','','FI',1,'1840-01-01','2999-12-31'),
	(32265,'09','048',' 04','048045',48045,'Tavarnelle Val di Pesa','Tavarnelle Val di Pesa','','FI',1,'1840-01-01','2999-12-31'),
	(32266,'09','048',' 04','048046',48046,'Vaglia','Vaglia','','FI',1,'1840-01-01','2999-12-31'),
	(32267,'09','048',' 04','048049',48049,'Vicchio','Vicchio','','FI',1,'1840-01-01','2999-12-31'),
	(32268,'09','048',' 05','048050',48050,'Vinci','Vinci','','FI',1,'1840-01-01','2999-12-31'),
	(32269,'09','049',' 00','049001',49001,'Bibbona','Bibbona','','LI',1,'1840-01-01','2999-12-31'),
	(32270,'09','049',' 00','049002',49002,'Campiglia Marittima','Campiglia Marittima','','LI',1,'1840-01-01','2999-12-31'),
	(32271,'09','049',' 00','049003',49003,'Campo nell\'Elba','Campo nell\'Elba','','LI',1,'1840-01-01','2999-12-31'),
	(32272,'09','049',' 00','049004',49004,'Capoliveri','Capoliveri','','LI',1,'1840-01-01','2999-12-31'),
	(32273,'09','049',' 00','049005',49005,'Capraia Isola','Capraia Isola','','LI',1,'1840-01-01','2999-12-31'),
	(32274,'09','049',' 00','049006',49006,'Castagneto Carducci','Castagneto Carducci','','LI',1,'1840-01-01','2999-12-31'),
	(32275,'09','049',' 00','049007',49007,'Cecina','Cecina','','LI',1,'1840-01-01','2999-12-31'),
	(32276,'09','049',' 00','049008',49008,'Collesalvetti','Collesalvetti','','LI',1,'1840-01-01','2999-12-31'),
	(32277,'09','049',' 00','049009',49009,'Livorno','Livorno','','LI',1,'1840-01-01','2999-12-31'),
	(32278,'09','049',' 01','049010',49010,'Marciana','Marciana','','LI',1,'1840-01-01','2999-12-31'),
	(32279,'09','049',' 01','049011',49011,'Marciana Marina','Marciana Marina','','LI',1,'1840-01-01','2999-12-31'),
	(32280,'09','049',' 01','049012',49012,'Piombino','Piombino','','LI',1,'1840-01-01','2999-12-31'),
	(32281,'09','049',' 01','049013',49013,'Porto Azzurro','Porto Azzurro','','LI',1,'1840-01-01','2999-12-31'),
	(32282,'09','049',' 01','049014',49014,'Portoferraio','Portoferraio','','LI',1,'1840-01-01','2999-12-31'),
	(32283,'09','049',' 01','049015',49015,'Rio Marina','Rio Marina','','LI',1,'1840-01-01','2999-12-31'),
	(32284,'09','049',' 01','049016',49016,'Rio nell\'Elba','Rio nell\'Elba','','LI',1,'1840-01-01','2999-12-31'),
	(32285,'09','049',' 01','049017',49017,'Rosignano Marittimo','Rosignano Marittimo','','LI',1,'1840-01-01','2999-12-31'),
	(32286,'09','049',' 01','049018',49018,'San Vincenzo','San Vincenzo','','LI',1,'1840-01-01','2999-12-31'),
	(32287,'09','049',' 01','049019',49019,'Sassetta','Sassetta','','LI',1,'1840-01-01','2999-12-31'),
	(32288,'09','049',' 02','049020',49020,'Suvereto','Suvereto','','LI',1,'1840-01-01','2999-12-31'),
	(32289,'09','050',' 00','050001',50001,'Bientina','Bientina','','PI',1,'1840-01-01','2999-12-31'),
	(32290,'09','050',' 00','050002',50002,'Buti','Buti','','PI',1,'1840-01-01','2999-12-31'),
	(32291,'09','050',' 00','050003',50003,'Calci','Calci','','PI',1,'1840-01-01','2999-12-31'),
	(32292,'09','050',' 00','050004',50004,'Calcinaia','Calcinaia','','PI',1,'1840-01-01','2999-12-31'),
	(32293,'09','050',' 00','050005',50005,'Capannoli','Capannoli','','PI',1,'1840-01-01','2999-12-31'),
	(32294,'09','050',' 00','050006',50006,'Casale Marittimo','Casale Marittimo','','PI',1,'1840-01-01','2999-12-31'),
	(32295,'09','050',' 00','050007',50007,'Casciana Terme','Casciana Terme','','PI',1,'1840-01-01','2999-12-31'),
	(32296,'09','050',' 00','050008',50008,'Cascina','Cascina','','PI',1,'1840-01-01','2999-12-31'),
	(32297,'09','050',' 00','050009',50009,'Castelfranco di Sotto','Castelfranco di Sotto','','PI',1,'1840-01-01','2999-12-31'),
	(32298,'09','050',' 01','050010',50010,'Castellina Marittima','Castellina Marittima','','PI',1,'1840-01-01','2999-12-31'),
	(32299,'09','050',' 01','050011',50011,'Castelnuovo di Val di Cecina','Castelnuovo di Val di Cecina','','PI',1,'1840-01-01','2999-12-31'),
	(32300,'09','050',' 01','050012',50012,'Chianni','Chianni','','PI',1,'1840-01-01','2999-12-31'),
	(32301,'09','050',' 01','050013',50013,'Crespina','Crespina','','PI',1,'1840-01-01','2999-12-31'),
	(32302,'09','050',' 01','050014',50014,'Fauglia','Fauglia','','PI',1,'1840-01-01','2999-12-31'),
	(32303,'09','050',' 01','050015',50015,'Guardistallo','Guardistallo','','PI',1,'1840-01-01','2999-12-31'),
	(32304,'09','050',' 01','050016',50016,'Lajatico','Lajatico','','PI',1,'1840-01-01','2999-12-31'),
	(32305,'09','050',' 01','050017',50017,'Lari','Lari','','PI',1,'1840-01-01','2999-12-31'),
	(32306,'09','050',' 01','050018',50018,'Lorenzana','Lorenzana','','PI',1,'1840-01-01','2999-12-31'),
	(32307,'09','050',' 01','050019',50019,'Montecatini Val di Cecina','Montecatini Val di Cecina','','PI',1,'1840-01-01','2999-12-31'),
	(32308,'09','050',' 02','050020',50020,'Montescudaio','Montescudaio','','PI',1,'1840-01-01','2999-12-31'),
	(32309,'09','050',' 02','050021',50021,'Monteverdi Marittimo','Monteverdi Marittimo','','PI',1,'1840-01-01','2999-12-31'),
	(32310,'09','050',' 02','050022',50022,'Montopoli in Val d\'Arno','Montopoli in Val d\'Arno','','PI',1,'1840-01-01','2999-12-31'),
	(32311,'09','050',' 02','050023',50023,'Orciano Pisano','Orciano Pisano','','PI',1,'1840-01-01','2999-12-31'),
	(32312,'09','050',' 02','050024',50024,'Palaia','Palaia','','PI',1,'1840-01-01','2999-12-31'),
	(32313,'09','050',' 02','050025',50025,'Peccioli','Peccioli','','PI',1,'1840-01-01','2999-12-31'),
	(32314,'09','050',' 02','050026',50026,'Pisa','Pisa','','PI',1,'1840-01-01','2999-12-31'),
	(32315,'09','050',' 02','050027',50027,'Pomarance','Pomarance','','PI',1,'1840-01-01','2999-12-31'),
	(32316,'09','050',' 02','050028',50028,'Ponsacco','Ponsacco','','PI',1,'1840-01-01','2999-12-31'),
	(32317,'09','050',' 02','050029',50029,'Pontedera','Pontedera','','PI',1,'1840-01-01','2999-12-31'),
	(32318,'09','050',' 03','050030',50030,'Riparbella','Riparbella','','PI',1,'1840-01-01','2999-12-31'),
	(32319,'09','050',' 03','050031',50031,'San Giuliano Terme','San Giuliano Terme','','PI',1,'1840-01-01','2999-12-31'),
	(32320,'09','050',' 03','050032',50032,'San Miniato','San Miniato','','PI',1,'1840-01-01','2999-12-31'),
	(32321,'09','050',' 03','050033',50033,'Santa Croce sull\'Arno','Santa Croce sull\'Arno','','PI',1,'1840-01-01','2999-12-31'),
	(32322,'09','050',' 03','050034',50034,'Santa Luce','Santa Luce','','PI',1,'1840-01-01','2999-12-31'),
	(32323,'09','050',' 03','050035',50035,'Santa Maria a Monte','Santa Maria a Monte','','PI',1,'1840-01-01','2999-12-31'),
	(32324,'09','050',' 03','050036',50036,'Terricciola','Terricciola','','PI',1,'1840-01-01','2999-12-31'),
	(32325,'09','050',' 03','050037',50037,'Vecchiano','Vecchiano','','PI',1,'1840-01-01','2999-12-31'),
	(32326,'09','050',' 03','050038',50038,'Vicopisano','Vicopisano','','PI',1,'1840-01-01','2999-12-31'),
	(32327,'09','050',' 03','050039',50039,'Volterra','Volterra','','PI',1,'1840-01-01','2999-12-31'),
	(32328,'09','051',' 00','051001',51001,'Anghiari','Anghiari','','AR',1,'1840-01-01','2999-12-31'),
	(32329,'09','051',' 00','051002',51002,'Arezzo','Arezzo','','AR',1,'1840-01-01','2999-12-31'),
	(32330,'09','051',' 00','051003',51003,'Badia Tedalda','Badia Tedalda','','AR',1,'1840-01-01','2999-12-31'),
	(32331,'09','051',' 00','051004',51004,'Bibbiena','Bibbiena','','AR',1,'1840-01-01','2999-12-31'),
	(32332,'09','051',' 00','051005',51005,'Bucine','Bucine','','AR',1,'1840-01-01','2999-12-31'),
	(32333,'09','051',' 00','051006',51006,'Capolona','Capolona','','AR',1,'1840-01-01','2999-12-31'),
	(32334,'09','051',' 00','051007',51007,'Caprese Michelangelo','Caprese Michelangelo','','AR',1,'1840-01-01','2999-12-31'),
	(32335,'09','051',' 00','051008',51008,'Castel Focognano','Castel Focognano','','AR',1,'1840-01-01','2999-12-31'),
	(32336,'09','051',' 00','051009',51009,'Castelfranco di Sopra','Castelfranco di Sopra','','AR',1,'1840-01-01','2999-12-31'),
	(32337,'09','051',' 01','051010',51010,'Castel San Niccolò','Castel San Niccolò','','AR',1,'1840-01-01','2999-12-31'),
	(32338,'09','051',' 01','051011',51011,'Castiglion Fibocchi','Castiglion Fibocchi','','AR',1,'1840-01-01','2999-12-31'),
	(32339,'09','051',' 01','051012',51012,'Castiglion Fiorentino','Castiglion Fiorentino','','AR',1,'1840-01-01','2999-12-31'),
	(32340,'09','051',' 01','051013',51013,'Cavriglia','Cavriglia','','AR',1,'1840-01-01','2999-12-31'),
	(32341,'09','051',' 01','051014',51014,'Chitignano','Chitignano','','AR',1,'1840-01-01','2999-12-31'),
	(32342,'09','051',' 01','051015',51015,'Chiusi della Verna','Chiusi della Verna','','AR',1,'1840-01-01','2999-12-31'),
	(32343,'09','051',' 01','051016',51016,'Civitella in Val di Chiana','Civitella in Val di Chiana','','AR',1,'1840-01-01','2999-12-31'),
	(32344,'09','051',' 01','051017',51017,'Cortona','Cortona','','AR',1,'1840-01-01','2999-12-31'),
	(32345,'09','051',' 01','051018',51018,'Foiano della Chiana','Foiano della Chiana','','AR',1,'1840-01-01','2999-12-31'),
	(32346,'09','051',' 01','051019',51019,'Laterina','Laterina','','AR',1,'1840-01-01','2999-12-31'),
	(32347,'09','051',' 02','051020',51020,'Loro Ciuffenna','Loro Ciuffenna','','AR',1,'1840-01-01','2999-12-31'),
	(32348,'09','051',' 02','051021',51021,'Lucignano','Lucignano','','AR',1,'1840-01-01','2999-12-31'),
	(32349,'09','051',' 02','051022',51022,'Marciano della Chiana','Marciano della Chiana','','AR',1,'1840-01-01','2999-12-31'),
	(32350,'09','051',' 02','051023',51023,'Montemignaio','Montemignaio','','AR',1,'1840-01-01','2999-12-31'),
	(32351,'09','051',' 02','051024',51024,'Monterchi','Monterchi','','AR',1,'1840-01-01','2999-12-31'),
	(32352,'09','051',' 02','051025',51025,'Monte San Savino','Monte San Savino','','AR',1,'1840-01-01','2999-12-31'),
	(32353,'09','051',' 02','051026',51026,'Montevarchi','Montevarchi','','AR',1,'1840-01-01','2999-12-31'),
	(32354,'09','051',' 02','051027',51027,'Ortignano Raggiolo','Ortignano Raggiolo','','AR',1,'1840-01-01','2999-12-31'),
	(32355,'09','051',' 02','051028',51028,'Pergine Valdarno','Pergine Valdarno','','AR',1,'1840-01-01','2999-12-31'),
	(32356,'09','051',' 02','051029',51029,'Pian di Sco','Pian di Sco','','AR',1,'1840-01-01','2999-12-31'),
	(32357,'09','051',' 03','051030',51030,'Pieve Santo Stefano','Pieve Santo Stefano','','AR',1,'1840-01-01','2999-12-31'),
	(32358,'09','051',' 03','051031',51031,'Poppi','Poppi','','AR',1,'1840-01-01','2999-12-31'),
	(32359,'09','051',' 03','051032',51032,'Pratovecchio','Pratovecchio','','AR',1,'1840-01-01','2999-12-31'),
	(32360,'09','051',' 03','051033',51033,'San Giovanni Valdarno','San Giovanni Valdarno','','AR',1,'1840-01-01','2999-12-31'),
	(32361,'09','051',' 03','051034',51034,'Sansepolcro','Sansepolcro','','AR',1,'1840-01-01','2999-12-31'),
	(32362,'09','051',' 03','051035',51035,'Sestino','Sestino','','AR',1,'1840-01-01','2999-12-31'),
	(32363,'09','051',' 03','051036',51036,'Stia','Stia','','AR',1,'1840-01-01','2999-12-31'),
	(32364,'09','051',' 03','051037',51037,'Subbiano','Subbiano','','AR',1,'1840-01-01','2999-12-31'),
	(32365,'09','051',' 03','051038',51038,'Talla','Talla','','AR',1,'1840-01-01','2999-12-31'),
	(32366,'09','051',' 03','051039',51039,'Terranuova Bracciolini','Terranuova Bracciolini','','AR',1,'1840-01-01','2999-12-31'),
	(32367,'09','052',' 00','052001',52001,'Abbadia San Salvatore','Abbadia San Salvatore','','SI',1,'1840-01-01','2999-12-31'),
	(32368,'09','052',' 00','052002',52002,'Asciano','Asciano','','SI',1,'1840-01-01','2999-12-31'),
	(32369,'09','052',' 00','052003',52003,'Buonconvento','Buonconvento','','SI',1,'1840-01-01','2999-12-31'),
	(32370,'09','052',' 00','052004',52004,'Casole d\'Elsa','Casole d\'Elsa','','SI',1,'1840-01-01','2999-12-31'),
	(32371,'09','052',' 00','052005',52005,'Castellina in Chianti','Castellina in Chianti','','SI',1,'1840-01-01','2999-12-31'),
	(32372,'09','052',' 00','052006',52006,'Castelnuovo Berardenga','Castelnuovo Berardenga','','SI',1,'1840-01-01','2999-12-31'),
	(32373,'09','052',' 00','052007',52007,'Castiglione d\'Orcia','Castiglione d\'Orcia','','SI',1,'1840-01-01','2999-12-31'),
	(32374,'09','052',' 00','052008',52008,'Cetona','Cetona','','SI',1,'1840-01-01','2999-12-31'),
	(32375,'09','052',' 00','052009',52009,'Chianciano Terme','Chianciano Terme','','SI',1,'1840-01-01','2999-12-31'),
	(32376,'09','052',' 01','052010',52010,'Chiusdino','Chiusdino','','SI',1,'1840-01-01','2999-12-31'),
	(32377,'09','052',' 01','052011',52011,'Chiusi','Chiusi','','SI',1,'1840-01-01','2999-12-31'),
	(32378,'09','052',' 01','052012',52012,'Colle di Val d\'Elsa','Colle di Val d\'Elsa','','SI',1,'1840-01-01','2999-12-31'),
	(32379,'09','052',' 01','052013',52013,'Gaiole in Chianti','Gaiole in Chianti','','SI',1,'1840-01-01','2999-12-31'),
	(32380,'09','052',' 01','052014',52014,'Montalcino','Montalcino','','SI',1,'1840-01-01','2999-12-31'),
	(32381,'09','052',' 01','052015',52015,'Montepulciano','Montepulciano','','SI',1,'1840-01-01','2999-12-31'),
	(32382,'09','052',' 01','052016',52016,'Monteriggioni','Monteriggioni','','SI',1,'1840-01-01','2999-12-31'),
	(32383,'09','052',' 01','052017',52017,'Monteroni d\'Arbia','Monteroni d\'Arbia','','SI',1,'1840-01-01','2999-12-31'),
	(32384,'09','052',' 01','052018',52018,'Monticiano','Monticiano','','SI',1,'1840-01-01','2999-12-31'),
	(32385,'09','052',' 01','052019',52019,'Murlo','Murlo','','SI',1,'1840-01-01','2999-12-31'),
	(32386,'09','052',' 02','052020',52020,'Piancastagnaio','Piancastagnaio','','SI',1,'1840-01-01','2999-12-31'),
	(32387,'09','052',' 02','052021',52021,'Pienza','Pienza','','SI',1,'1840-01-01','2999-12-31'),
	(32388,'09','052',' 02','052022',52022,'Poggibonsi','Poggibonsi','','SI',1,'1840-01-01','2999-12-31'),
	(32389,'09','052',' 02','052023',52023,'Radda in Chianti','Radda in Chianti','','SI',1,'1840-01-01','2999-12-31'),
	(32390,'09','052',' 02','052024',52024,'Radicofani','Radicofani','','SI',1,'1840-01-01','2999-12-31'),
	(32391,'09','052',' 02','052025',52025,'Radicondoli','Radicondoli','','SI',1,'1840-01-01','2999-12-31'),
	(32392,'09','052',' 02','052026',52026,'Rapolano Terme','Rapolano Terme','','SI',1,'1840-01-01','2999-12-31'),
	(32393,'09','052',' 02','052027',52027,'San Casciano dei Bagni','San Casciano dei Bagni','','SI',1,'1840-01-01','2999-12-31'),
	(32394,'09','052',' 02','052028',52028,'San Gimignano','San Gimignano','','SI',1,'1840-01-01','2999-12-31'),
	(32395,'09','052',' 02','052029',52029,'San Giovanni d\'Asso','San Giovanni d\'Asso','','SI',1,'1840-01-01','2999-12-31'),
	(32396,'09','052',' 03','052030',52030,'San Quirico d\'Orcia','San Quirico d\'Orcia','','SI',1,'1840-01-01','2999-12-31'),
	(32397,'09','052',' 03','052031',52031,'Sarteano','Sarteano','','SI',1,'1840-01-01','2999-12-31'),
	(32398,'09','052',' 03','052032',52032,'Siena','Siena','','SI',1,'1840-01-01','2999-12-31'),
	(32399,'09','052',' 03','052033',52033,'Sinalunga','Sinalunga','','SI',1,'1840-01-01','2999-12-31'),
	(32400,'09','052',' 03','052034',52034,'Sovicille','Sovicille','','SI',1,'1840-01-01','2999-12-31'),
	(32401,'09','052',' 03','052035',52035,'Torrita di Siena','Torrita di Siena','','SI',1,'1840-01-01','2999-12-31'),
	(32402,'09','052',' 03','052036',52036,'Trequanda','Trequanda','','SI',1,'1840-01-01','2999-12-31'),
	(32403,'09','053',' 00','053001',53001,'Arcidosso','Arcidosso','','GR',1,'1840-01-01','2999-12-31'),
	(32404,'09','053',' 00','053002',53002,'Campagnatico','Campagnatico','','GR',1,'1840-01-01','2999-12-31'),
	(32405,'09','053',' 00','053003',53003,'Capalbio','Capalbio','','GR',1,'1840-01-01','2999-12-31'),
	(32406,'09','053',' 00','053004',53004,'Castel del Piano','Castel del Piano','','GR',1,'1840-01-01','2999-12-31'),
	(32407,'09','053',' 00','053005',53005,'Castell\'Azzara','Castell\'Azzara','','GR',1,'1840-01-01','2999-12-31'),
	(32408,'09','053',' 00','053006',53006,'Castiglione della Pescaia','Castiglione della Pescaia','','GR',1,'1840-01-01','2999-12-31'),
	(32409,'09','053',' 00','053007',53007,'Cinigiano','Cinigiano','','GR',1,'1840-01-01','2999-12-31'),
	(32410,'09','053',' 00','053008',53008,'Civitella Paganico','Civitella Paganico','','GR',1,'1840-01-01','2999-12-31'),
	(32411,'09','053',' 00','053009',53009,'Follonica','Follonica','','GR',1,'1840-01-01','2999-12-31'),
	(32412,'09','053',' 01','053010',53010,'Gavorrano','Gavorrano','','GR',1,'1840-01-01','2999-12-31'),
	(32413,'09','053',' 01','053011',53011,'Grosseto','Grosseto','','GR',1,'1840-01-01','2999-12-31'),
	(32414,'09','053',' 01','053012',53012,'Isola del Giglio','Isola del Giglio','','GR',1,'1840-01-01','2999-12-31'),
	(32415,'09','053',' 01','053013',53013,'Magliano in Toscana','Magliano in Toscana','','GR',1,'1840-01-01','2999-12-31'),
	(32416,'09','053',' 01','053014',53014,'Manciano','Manciano','','GR',1,'1840-01-01','2999-12-31'),
	(32417,'09','053',' 01','053015',53015,'Massa Marittima','Massa Marittima','','GR',1,'1840-01-01','2999-12-31'),
	(32418,'09','053',' 01','053016',53016,'Monte Argentario','Monte Argentario','','GR',1,'1840-01-01','2999-12-31'),
	(32419,'09','053',' 01','053017',53017,'Montieri','Montieri','','GR',1,'1840-01-01','2999-12-31'),
	(32420,'09','053',' 01','053018',53018,'Orbetello','Orbetello','','GR',1,'1840-01-01','2999-12-31'),
	(32421,'09','053',' 01','053019',53019,'Pitigliano','Pitigliano','','GR',1,'1840-01-01','2999-12-31'),
	(32422,'09','053',' 02','053020',53020,'Roccalbegna','Roccalbegna','','GR',1,'1840-01-01','2999-12-31'),
	(32423,'09','053',' 02','053021',53021,'Roccastrada','Roccastrada','','GR',1,'1840-01-01','2999-12-31'),
	(32424,'09','053',' 02','053022',53022,'Santa Fiora','Santa Fiora','','GR',1,'1840-01-01','2999-12-31'),
	(32425,'09','053',' 02','053023',53023,'Scansano','Scansano','','GR',1,'1840-01-01','2999-12-31'),
	(32426,'09','053',' 02','053024',53024,'Scarlino','Scarlino','','GR',1,'1840-01-01','2999-12-31'),
	(32427,'09','053',' 02','053025',53025,'Seggiano','Seggiano','','GR',1,'1840-01-01','2999-12-31'),
	(32428,'09','053',' 02','053026',53026,'Sorano','Sorano','','GR',1,'1840-01-01','2999-12-31'),
	(32429,'09','053',' 02','053027',53027,'Monterotondo Marittimo','Monterotondo Marittimo','','GR',1,'1840-01-01','2999-12-31'),
	(32430,'09','053',' 02','053028',53028,'Semproniano','Semproniano','','GR',1,'1840-01-01','2999-12-31'),
	(32431,'10','054',' 00','054001',54001,'Assisi','Assisi','','PG',1,'1840-01-01','2999-12-31'),
	(32432,'10','054',' 00','054002',54002,'Bastia Umbra','Bastia Umbra','','PG',1,'1840-01-01','2999-12-31'),
	(32433,'10','054',' 00','054003',54003,'Bettona','Bettona','','PG',1,'1840-01-01','2999-12-31'),
	(32434,'10','054',' 00','054004',54004,'Bevagna','Bevagna','','PG',1,'1840-01-01','2999-12-31'),
	(32435,'10','054',' 00','054005',54005,'Campello sul Clitunno','Campello sul Clitunno','','PG',1,'1840-01-01','2999-12-31'),
	(32436,'10','054',' 00','054006',54006,'Cannara','Cannara','','PG',1,'1840-01-01','2999-12-31'),
	(32437,'10','054',' 00','054007',54007,'Cascia','Cascia','','PG',1,'1840-01-01','2999-12-31'),
	(32438,'10','054',' 00','054008',54008,'Castel Ritaldi','Castel Ritaldi','','PG',1,'1840-01-01','2999-12-31'),
	(32439,'10','054',' 00','054009',54009,'Castiglione del Lago','Castiglione del Lago','','PG',1,'1840-01-01','2999-12-31'),
	(32440,'10','054',' 01','054010',54010,'Cerreto di Spoleto','Cerreto di Spoleto','','PG',1,'1840-01-01','2999-12-31'),
	(32441,'10','054',' 01','054011',54011,'Citerna','Citerna','','PG',1,'1840-01-01','2999-12-31'),
	(32442,'10','054',' 01','054012',54012,'Città della Pieve','Città della Pieve','','PG',1,'1840-01-01','2999-12-31'),
	(32443,'10','054',' 01','054013',54013,'Città di Castello','Città di Castello','','PG',1,'1840-01-01','2999-12-31'),
	(32444,'10','054',' 01','054014',54014,'Collazzone','Collazzone','','PG',1,'1840-01-01','2999-12-31'),
	(32445,'10','054',' 01','054015',54015,'Corciano','Corciano','','PG',1,'1840-01-01','2999-12-31'),
	(32446,'10','054',' 01','054016',54016,'Costacciaro','Costacciaro','','PG',1,'1840-01-01','2999-12-31'),
	(32447,'10','054',' 01','054017',54017,'Deruta','Deruta','','PG',1,'1840-01-01','2999-12-31'),
	(32448,'10','054',' 01','054018',54018,'Foligno','Foligno','','PG',1,'1840-01-01','2999-12-31'),
	(32449,'10','054',' 01','054019',54019,'Fossato di Vico','Fossato di Vico','','PG',1,'1840-01-01','2999-12-31'),
	(32450,'10','054',' 02','054020',54020,'Fratta Todina','Fratta Todina','','PG',1,'1840-01-01','2999-12-31'),
	(32451,'10','054',' 02','054021',54021,'Giano dell\'Umbria','Giano dell\'Umbria','','PG',1,'1840-01-01','2999-12-31'),
	(32452,'10','054',' 02','054022',54022,'Gualdo Cattaneo','Gualdo Cattaneo','','PG',1,'1840-01-01','2999-12-31'),
	(32453,'10','054',' 02','054023',54023,'Gualdo Tadino','Gualdo Tadino','','PG',1,'1840-01-01','2999-12-31'),
	(32454,'10','054',' 02','054024',54024,'Gubbio','Gubbio','','PG',1,'1840-01-01','2999-12-31'),
	(32455,'10','054',' 02','054025',54025,'Lisciano Niccone','Lisciano Niccone','','PG',1,'1840-01-01','2999-12-31'),
	(32456,'10','054',' 02','054026',54026,'Magione','Magione','','PG',1,'1840-01-01','2999-12-31'),
	(32457,'10','054',' 02','054027',54027,'Marsciano','Marsciano','','PG',1,'1840-01-01','2999-12-31'),
	(32458,'10','054',' 02','054028',54028,'Massa Martana','Massa Martana','','PG',1,'1840-01-01','2999-12-31'),
	(32459,'10','054',' 02','054029',54029,'Monte Castello di Vibio','Monte Castello di Vibio','','PG',1,'1840-01-01','2999-12-31'),
	(32460,'10','054',' 03','054030',54030,'Montefalco','Montefalco','','PG',1,'1840-01-01','2999-12-31'),
	(32461,'10','054',' 03','054031',54031,'Monteleone di Spoleto','Monteleone di Spoleto','','PG',1,'1840-01-01','2999-12-31'),
	(32462,'10','054',' 03','054032',54032,'Monte Santa Maria Tiberina','Monte Santa Maria Tiberina','','PG',1,'1840-01-01','2999-12-31'),
	(32463,'10','054',' 03','054033',54033,'Montone','Montone','','PG',1,'1840-01-01','2999-12-31'),
	(32464,'10','054',' 03','054034',54034,'Nocera Umbra','Nocera Umbra','','PG',1,'1840-01-01','2999-12-31'),
	(32465,'10','054',' 03','054035',54035,'Norcia','Norcia','','PG',1,'1840-01-01','2999-12-31'),
	(32466,'10','054',' 03','054036',54036,'Paciano','Paciano','','PG',1,'1840-01-01','2999-12-31'),
	(32467,'10','054',' 03','054037',54037,'Panicale','Panicale','','PG',1,'1840-01-01','2999-12-31'),
	(32468,'10','054',' 03','054038',54038,'Passignano sul Trasimeno','Passignano sul Trasimeno','','PG',1,'1840-01-01','2999-12-31'),
	(32469,'10','054',' 03','054039',54039,'Perugia','Perugia','','PG',1,'1840-01-01','2999-12-31'),
	(32470,'10','054',' 04','054040',54040,'Piegaro','Piegaro','','PG',1,'1840-01-01','2999-12-31'),
	(32471,'10','054',' 04','054041',54041,'Pietralunga','Pietralunga','','PG',1,'1840-01-01','2999-12-31'),
	(32472,'10','054',' 04','054042',54042,'Poggiodomo','Poggiodomo','','PG',1,'1840-01-01','2999-12-31'),
	(32473,'10','054',' 04','054043',54043,'Preci','Preci','','PG',1,'1840-01-01','2999-12-31'),
	(32474,'10','054',' 04','054044',54044,'San Giustino','San Giustino','','PG',1,'1840-01-01','2999-12-31'),
	(32475,'10','054',' 04','054045',54045,'Sant\'Anatolia di Narco','Sant\'Anatolia di Narco','','PG',1,'1840-01-01','2999-12-31'),
	(32476,'10','054',' 04','054046',54046,'Scheggia e Pascelupo','Scheggia e Pascelupo','','PG',1,'1840-01-01','2999-12-31'),
	(32477,'10','054',' 04','054047',54047,'Scheggino','Scheggino','','PG',1,'1840-01-01','2999-12-31'),
	(32478,'10','054',' 04','054048',54048,'Sellano','Sellano','','PG',1,'1840-01-01','2999-12-31'),
	(32479,'10','054',' 04','054049',54049,'Sigillo','Sigillo','','PG',1,'1840-01-01','2999-12-31'),
	(32480,'10','054',' 05','054050',54050,'Spello','Spello','','PG',1,'1840-01-01','2999-12-31'),
	(32481,'10','054',' 05','054051',54051,'Spoleto','Spoleto','','PG',1,'1840-01-01','2999-12-31'),
	(32482,'10','054',' 05','054052',54052,'Todi','Todi','','PG',1,'1840-01-01','2999-12-31'),
	(32483,'10','054',' 05','054053',54053,'Torgiano','Torgiano','','PG',1,'1840-01-01','2999-12-31'),
	(32484,'10','054',' 05','054054',54054,'Trevi','Trevi','','PG',1,'1840-01-01','2999-12-31'),
	(32485,'10','054',' 05','054055',54055,'Tuoro sul Trasimeno','Tuoro sul Trasimeno','','PG',1,'1840-01-01','2999-12-31'),
	(32486,'10','054',' 05','054056',54056,'Umbertide','Umbertide','','PG',1,'1840-01-01','2999-12-31'),
	(32487,'10','054',' 05','054057',54057,'Valfabbrica','Valfabbrica','','PG',1,'1840-01-01','2999-12-31'),
	(32488,'10','054',' 05','054058',54058,'Vallo di Nera','Vallo di Nera','','PG',1,'1840-01-01','2999-12-31'),
	(32489,'10','054',' 05','054059',54059,'Valtopina','Valtopina','','PG',1,'1840-01-01','2999-12-31'),
	(32490,'10','055',' 00','055001',55001,'Acquasparta','Acquasparta','','TR',1,'1840-01-01','2999-12-31'),
	(32491,'10','055',' 00','055002',55002,'Allerona','Allerona','','TR',1,'1840-01-01','2999-12-31'),
	(32492,'10','055',' 00','055003',55003,'Alviano','Alviano','','TR',1,'1840-01-01','2999-12-31'),
	(32493,'10','055',' 00','055004',55004,'Amelia','Amelia','','TR',1,'1840-01-01','2999-12-31'),
	(32494,'10','055',' 00','055005',55005,'Arrone','Arrone','','TR',1,'1840-01-01','2999-12-31'),
	(32495,'10','055',' 00','055006',55006,'Attigliano','Attigliano','','TR',1,'1840-01-01','2999-12-31'),
	(32496,'10','055',' 00','055007',55007,'Baschi','Baschi','','TR',1,'1840-01-01','2999-12-31'),
	(32497,'10','055',' 00','055008',55008,'Calvi dell\'Umbria','Calvi dell\'Umbria','','TR',1,'1840-01-01','2999-12-31'),
	(32498,'10','055',' 00','055009',55009,'Castel Giorgio','Castel Giorgio','','TR',1,'1840-01-01','2999-12-31'),
	(32499,'10','055',' 01','055010',55010,'Castel Viscardo','Castel Viscardo','','TR',1,'1840-01-01','2999-12-31'),
	(32500,'10','055',' 01','055011',55011,'Fabro','Fabro','','TR',1,'1840-01-01','2999-12-31'),
	(32501,'10','055',' 01','055012',55012,'Ferentillo','Ferentillo','','TR',1,'1840-01-01','2999-12-31'),
	(32502,'10','055',' 01','055013',55013,'Ficulle','Ficulle','','TR',1,'1840-01-01','2999-12-31'),
	(32503,'10','055',' 01','055014',55014,'Giove','Giove','','TR',1,'1840-01-01','2999-12-31'),
	(32504,'10','055',' 01','055015',55015,'Guardea','Guardea','','TR',1,'1840-01-01','2999-12-31'),
	(32505,'10','055',' 01','055016',55016,'Lugnano in Teverina','Lugnano in Teverina','','TR',1,'1840-01-01','2999-12-31'),
	(32506,'10','055',' 01','055017',55017,'Montecastrilli','Montecastrilli','','TR',1,'1840-01-01','2999-12-31'),
	(32507,'10','055',' 01','055018',55018,'Montecchio','Montecchio','','TR',1,'1840-01-01','2999-12-31'),
	(32508,'10','055',' 01','055019',55019,'Montefranco','Montefranco','','TR',1,'1840-01-01','2999-12-31'),
	(32509,'10','055',' 02','055020',55020,'Montegabbione','Montegabbione','','TR',1,'1840-01-01','2999-12-31'),
	(32510,'10','055',' 02','055021',55021,'Monteleone d\'Orvieto','Monteleone d\'Orvieto','','TR',1,'1840-01-01','2999-12-31'),
	(32511,'10','055',' 02','055022',55022,'Narni','Narni','','TR',1,'1840-01-01','2999-12-31'),
	(32512,'10','055',' 02','055023',55023,'Orvieto','Orvieto','','TR',1,'1840-01-01','2999-12-31'),
	(32513,'10','055',' 02','055024',55024,'Otricoli','Otricoli','','TR',1,'1840-01-01','2999-12-31'),
	(32514,'10','055',' 02','055025',55025,'Parrano','Parrano','','TR',1,'1840-01-01','2999-12-31'),
	(32515,'10','055',' 02','055026',55026,'Penna in Teverina','Penna in Teverina','','TR',1,'1840-01-01','2999-12-31'),
	(32516,'10','055',' 02','055027',55027,'Polino','Polino','','TR',1,'1840-01-01','2999-12-31'),
	(32517,'10','055',' 02','055028',55028,'Porano','Porano','','TR',1,'1840-01-01','2999-12-31'),
	(32518,'10','055',' 02','055029',55029,'San Gemini','San Gemini','','TR',1,'1840-01-01','2999-12-31'),
	(32519,'10','055',' 03','055030',55030,'San Venanzo','San Venanzo','','TR',1,'1840-01-01','2999-12-31'),
	(32520,'10','055',' 03','055031',55031,'Stroncone','Stroncone','','TR',1,'1840-01-01','2999-12-31'),
	(32521,'10','055',' 03','055032',55032,'Terni','Terni','','TR',1,'1840-01-01','2999-12-31'),
	(32522,'10','055',' 03','055033',55033,'Avigliano Umbro','Avigliano Umbro','','TR',1,'1840-01-01','2999-12-31'),
	(32523,'12','056',' 00','056001',56001,'Acquapendente','Acquapendente','','VT',1,'1840-01-01','2999-12-31'),
	(32524,'12','056',' 00','056002',56002,'Arlena di Castro','Arlena di Castro','','VT',1,'1840-01-01','2999-12-31'),
	(32525,'12','056',' 00','056003',56003,'Bagnoregio','Bagnoregio','','VT',1,'1840-01-01','2999-12-31'),
	(32526,'12','056',' 00','056004',56004,'Barbarano Romano','Barbarano Romano','','VT',1,'1840-01-01','2999-12-31'),
	(32527,'12','056',' 00','056005',56005,'Bassano Romano','Bassano Romano','','VT',1,'1840-01-01','2999-12-31'),
	(32528,'12','056',' 00','056006',56006,'Bassano in Teverina','Bassano in Teverina','','VT',1,'1840-01-01','2999-12-31'),
	(32529,'12','056',' 00','056007',56007,'Blera','Blera','','VT',1,'1840-01-01','2999-12-31'),
	(32530,'12','056',' 00','056008',56008,'Bolsena','Bolsena','','VT',1,'1840-01-01','2999-12-31'),
	(32531,'12','056',' 00','056009',56009,'Bomarzo','Bomarzo','','VT',1,'1840-01-01','2999-12-31'),
	(32532,'12','056',' 01','056010',56010,'Calcata','Calcata','','VT',1,'1840-01-01','2999-12-31'),
	(32533,'12','056',' 01','056011',56011,'Canepina','Canepina','','VT',1,'1840-01-01','2999-12-31'),
	(32534,'12','056',' 01','056012',56012,'Canino','Canino','','VT',1,'1840-01-01','2999-12-31'),
	(32535,'12','056',' 01','056013',56013,'Capodimonte','Capodimonte','','VT',1,'1840-01-01','2999-12-31'),
	(32536,'12','056',' 01','056014',56014,'Capranica','Capranica','','VT',1,'1840-01-01','2999-12-31'),
	(32537,'12','056',' 01','056015',56015,'Caprarola','Caprarola','','VT',1,'1840-01-01','2999-12-31'),
	(32538,'12','056',' 01','056016',56016,'Carbognano','Carbognano','','VT',1,'1840-01-01','2999-12-31'),
	(32539,'12','056',' 01','056017',56017,'Castel Sant\'Elia','Castel Sant\'Elia','','VT',1,'1840-01-01','2999-12-31'),
	(32540,'12','056',' 01','056018',56018,'Castiglione in Teverina','Castiglione in Teverina','','VT',1,'1840-01-01','2999-12-31'),
	(32541,'12','056',' 01','056019',56019,'Celleno','Celleno','','VT',1,'1840-01-01','2999-12-31'),
	(32542,'12','056',' 02','056020',56020,'Cellere','Cellere','','VT',1,'1840-01-01','2999-12-31'),
	(32543,'12','056',' 02','056021',56021,'Civita Castellana','Civita Castellana','','VT',1,'1840-01-01','2999-12-31'),
	(32544,'12','056',' 02','056022',56022,'Civitella d\'Agliano','Civitella d\'Agliano','','VT',1,'1840-01-01','2999-12-31'),
	(32545,'12','056',' 02','056023',56023,'Corchiano','Corchiano','','VT',1,'1840-01-01','2999-12-31'),
	(32546,'12','056',' 02','056024',56024,'Fabrica di Roma','Fabrica di Roma','','VT',1,'1840-01-01','2999-12-31'),
	(32547,'12','056',' 02','056025',56025,'Faleria','Faleria','','VT',1,'1840-01-01','2999-12-31'),
	(32548,'12','056',' 02','056026',56026,'Farnese','Farnese','','VT',1,'1840-01-01','2999-12-31'),
	(32549,'12','056',' 02','056027',56027,'Gallese','Gallese','','VT',1,'1840-01-01','2999-12-31'),
	(32550,'12','056',' 02','056028',56028,'Gradoli','Gradoli','','VT',1,'1840-01-01','2999-12-31'),
	(32551,'12','056',' 02','056029',56029,'Graffignano','Graffignano','','VT',1,'1840-01-01','2999-12-31'),
	(32552,'12','056',' 03','056030',56030,'Grotte di Castro','Grotte di Castro','','VT',1,'1840-01-01','2999-12-31'),
	(32553,'12','056',' 03','056031',56031,'Ischia di Castro','Ischia di Castro','','VT',1,'1840-01-01','2999-12-31'),
	(32554,'12','056',' 03','056032',56032,'Latera','Latera','','VT',1,'1840-01-01','2999-12-31'),
	(32555,'12','056',' 03','056033',56033,'Lubriano','Lubriano','','VT',1,'1840-01-01','2999-12-31'),
	(32556,'12','056',' 03','056034',56034,'Marta','Marta','','VT',1,'1840-01-01','2999-12-31'),
	(32557,'12','056',' 03','056035',56035,'Montalto di Castro','Montalto di Castro','','VT',1,'1840-01-01','2999-12-31'),
	(32558,'12','056',' 03','056036',56036,'Montefiascone','Montefiascone','','VT',1,'1840-01-01','2999-12-31'),
	(32559,'12','056',' 03','056037',56037,'Monte Romano','Monte Romano','','VT',1,'1840-01-01','2999-12-31'),
	(32560,'12','056',' 03','056038',56038,'Monterosi','Monterosi','','VT',1,'1840-01-01','2999-12-31'),
	(32561,'12','056',' 03','056039',56039,'Nepi','Nepi','','VT',1,'1840-01-01','2999-12-31'),
	(32562,'12','056',' 04','056040',56040,'Onano','Onano','','VT',1,'1840-01-01','2999-12-31'),
	(32563,'12','056',' 04','056041',56041,'Oriolo Romano','Oriolo Romano','','VT',1,'1840-01-01','2999-12-31'),
	(32564,'12','056',' 04','056042',56042,'Orte','Orte','','VT',1,'1840-01-01','2999-12-31'),
	(32565,'12','056',' 04','056043',56043,'Piansano','Piansano','','VT',1,'1840-01-01','2999-12-31'),
	(32566,'12','056',' 04','056044',56044,'Proceno','Proceno','','VT',1,'1840-01-01','2999-12-31'),
	(32567,'12','056',' 04','056045',56045,'Ronciglione','Ronciglione','','VT',1,'1840-01-01','2999-12-31'),
	(32568,'12','056',' 04','056046',56046,'Villa San Giovanni in Tuscia','Villa San Giovanni in Tuscia','','VT',1,'1840-01-01','2999-12-31'),
	(32569,'12','056',' 04','056047',56047,'San Lorenzo Nuovo','San Lorenzo Nuovo','','VT',1,'1840-01-01','2999-12-31'),
	(32570,'12','056',' 04','056048',56048,'Soriano nel Cimino','Soriano nel Cimino','','VT',1,'1840-01-01','2999-12-31'),
	(32571,'12','056',' 04','056049',56049,'Sutri','Sutri','','VT',1,'1840-01-01','2999-12-31'),
	(32572,'12','056',' 05','056050',56050,'Tarquinia','Tarquinia','','VT',1,'1840-01-01','2999-12-31'),
	(32573,'12','056',' 05','056051',56051,'Tessennano','Tessennano','','VT',1,'1840-01-01','2999-12-31'),
	(32574,'12','056',' 05','056052',56052,'Tuscania','Tuscania','','VT',1,'1840-01-01','2999-12-31'),
	(32575,'12','056',' 05','056053',56053,'Valentano','Valentano','','VT',1,'1840-01-01','2999-12-31'),
	(32576,'12','056',' 05','056054',56054,'Vallerano','Vallerano','','VT',1,'1840-01-01','2999-12-31'),
	(32577,'12','056',' 05','056055',56055,'Vasanello','Vasanello','','VT',1,'1840-01-01','2999-12-31'),
	(32578,'12','056',' 05','056056',56056,'Vejano','Vejano','','VT',1,'1840-01-01','2999-12-31'),
	(32579,'12','056',' 05','056057',56057,'Vetralla','Vetralla','','VT',1,'1840-01-01','2999-12-31'),
	(32580,'12','056',' 05','056058',56058,'Vignanello','Vignanello','','VT',1,'1840-01-01','2999-12-31'),
	(32581,'12','056',' 05','056059',56059,'Viterbo','Viterbo','','VT',1,'1840-01-01','2999-12-31'),
	(32582,'12','056',' 06','056060',56060,'Vitorchiano','Vitorchiano','','VT',1,'1840-01-01','2999-12-31'),
	(32583,'12','057',' 00','057001',57001,'Accumoli','Accumoli','','RI',1,'1840-01-01','2999-12-31'),
	(32584,'12','057',' 00','057002',57002,'Amatrice','Amatrice','','RI',1,'1840-01-01','2999-12-31'),
	(32585,'12','057',' 00','057003',57003,'Antrodoco','Antrodoco','','RI',1,'1840-01-01','2999-12-31'),
	(32586,'12','057',' 00','057004',57004,'Ascrea','Ascrea','','RI',1,'1840-01-01','2999-12-31'),
	(32587,'12','057',' 00','057005',57005,'Belmonte in Sabina','Belmonte in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32588,'12','057',' 00','057006',57006,'Borbona','Borbona','','RI',1,'1840-01-01','2999-12-31'),
	(32589,'12','057',' 00','057007',57007,'Borgorose','Borgorose','','RI',1,'1840-01-01','2999-12-31'),
	(32590,'12','057',' 00','057008',57008,'Borgo Velino','Borgo Velino','','RI',1,'1840-01-01','2999-12-31'),
	(32591,'12','057',' 00','057009',57009,'Cantalice','Cantalice','','RI',1,'1840-01-01','2999-12-31'),
	(32592,'12','057',' 01','057010',57010,'Cantalupo in Sabina','Cantalupo in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32593,'12','057',' 01','057011',57011,'Casaprota','Casaprota','','RI',1,'1840-01-01','2999-12-31'),
	(32594,'12','057',' 01','057012',57012,'Casperia','Casperia','','RI',1,'1840-01-01','2999-12-31'),
	(32595,'12','057',' 01','057013',57013,'Castel di Tora','Castel di Tora','','RI',1,'1840-01-01','2999-12-31'),
	(32596,'12','057',' 01','057014',57014,'Castelnuovo di Farfa','Castelnuovo di Farfa','','RI',1,'1840-01-01','2999-12-31'),
	(32597,'12','057',' 01','057015',57015,'Castel Sant\'Angelo','Castel Sant\'Angelo','','RI',1,'1840-01-01','2999-12-31'),
	(32598,'12','057',' 01','057016',57016,'Cittaducale','Cittaducale','','RI',1,'1840-01-01','2999-12-31'),
	(32599,'12','057',' 01','057017',57017,'Cittareale','Cittareale','','RI',1,'1840-01-01','2999-12-31'),
	(32600,'12','057',' 01','057018',57018,'Collalto Sabino','Collalto Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32601,'12','057',' 01','057019',57019,'Colle di Tora','Colle di Tora','','RI',1,'1840-01-01','2999-12-31'),
	(32602,'12','057',' 02','057020',57020,'Collegiove','Collegiove','','RI',1,'1840-01-01','2999-12-31'),
	(32603,'12','057',' 02','057021',57021,'Collevecchio','Collevecchio','','RI',1,'1840-01-01','2999-12-31'),
	(32604,'12','057',' 02','057022',57022,'Colli sul Velino','Colli sul Velino','','RI',1,'1840-01-01','2999-12-31'),
	(32605,'12','057',' 02','057023',57023,'Concerviano','Concerviano','','RI',1,'1840-01-01','2999-12-31'),
	(32606,'12','057',' 02','057024',57024,'Configni','Configni','','RI',1,'1840-01-01','2999-12-31'),
	(32607,'12','057',' 02','057025',57025,'Contigliano','Contigliano','','RI',1,'1840-01-01','2999-12-31'),
	(32608,'12','057',' 02','057026',57026,'Cottanello','Cottanello','','RI',1,'1840-01-01','2999-12-31'),
	(32609,'12','057',' 02','057027',57027,'Fara in Sabina','Fara in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32610,'12','057',' 02','057028',57028,'Fiamignano','Fiamignano','','RI',1,'1840-01-01','2999-12-31'),
	(32611,'12','057',' 02','057029',57029,'Forano','Forano','','RI',1,'1840-01-01','2999-12-31'),
	(32612,'12','057',' 03','057030',57030,'Frasso Sabino','Frasso Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32613,'12','057',' 03','057031',57031,'Greccio','Greccio','','RI',1,'1840-01-01','2999-12-31'),
	(32614,'12','057',' 03','057032',57032,'Labro','Labro','','RI',1,'1840-01-01','2999-12-31'),
	(32615,'12','057',' 03','057033',57033,'Leonessa','Leonessa','','RI',1,'1840-01-01','2999-12-31'),
	(32616,'12','057',' 03','057034',57034,'Longone Sabino','Longone Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32617,'12','057',' 03','057035',57035,'Magliano Sabina','Magliano Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32618,'12','057',' 03','057036',57036,'Marcetelli','Marcetelli','','RI',1,'1840-01-01','2999-12-31'),
	(32619,'12','057',' 03','057037',57037,'Micigliano','Micigliano','','RI',1,'1840-01-01','2999-12-31'),
	(32620,'12','057',' 03','057038',57038,'Mompeo','Mompeo','','RI',1,'1840-01-01','2999-12-31'),
	(32621,'12','057',' 03','057039',57039,'Montasola','Montasola','','RI',1,'1840-01-01','2999-12-31'),
	(32622,'12','057',' 04','057040',57040,'Montebuono','Montebuono','','RI',1,'1840-01-01','2999-12-31'),
	(32623,'12','057',' 04','057041',57041,'Monteleone Sabino','Monteleone Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32624,'12','057',' 04','057042',57042,'Montenero Sabino','Montenero Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32625,'12','057',' 04','057043',57043,'Monte San Giovanni in Sabina','Monte San Giovanni in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32626,'12','057',' 04','057044',57044,'Montopoli di Sabina','Montopoli di Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32627,'12','057',' 04','057045',57045,'Morro Reatino','Morro Reatino','','RI',1,'1840-01-01','2999-12-31'),
	(32628,'12','057',' 04','057046',57046,'Nespolo','Nespolo','','RI',1,'1840-01-01','2999-12-31'),
	(32629,'12','057',' 04','057047',57047,'Orvinio','Orvinio','','RI',1,'1840-01-01','2999-12-31'),
	(32630,'12','057',' 04','057048',57048,'Paganico Sabino','Paganico Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32631,'12','057',' 04','057049',57049,'Pescorocchiano','Pescorocchiano','','RI',1,'1840-01-01','2999-12-31'),
	(32632,'12','057',' 05','057050',57050,'Petrella Salto','Petrella Salto','','RI',1,'1840-01-01','2999-12-31'),
	(32633,'12','057',' 05','057051',57051,'Poggio Bustone','Poggio Bustone','','RI',1,'1840-01-01','2999-12-31'),
	(32634,'12','057',' 05','057052',57052,'Poggio Catino','Poggio Catino','','RI',1,'1840-01-01','2999-12-31'),
	(32635,'12','057',' 05','057053',57053,'Poggio Mirteto','Poggio Mirteto','','RI',1,'1840-01-01','2999-12-31'),
	(32636,'12','057',' 05','057054',57054,'Poggio Moiano','Poggio Moiano','','RI',1,'1840-01-01','2999-12-31'),
	(32637,'12','057',' 05','057055',57055,'Poggio Nativo','Poggio Nativo','','RI',1,'1840-01-01','2999-12-31'),
	(32638,'12','057',' 05','057056',57056,'Poggio San Lorenzo','Poggio San Lorenzo','','RI',1,'1840-01-01','2999-12-31'),
	(32639,'12','057',' 05','057057',57057,'Posta','Posta','','RI',1,'1840-01-01','2999-12-31'),
	(32640,'12','057',' 05','057058',57058,'Pozzaglia Sabina','Pozzaglia Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32641,'12','057',' 05','057059',57059,'Rieti','Rieti','','RI',1,'1840-01-01','2999-12-31'),
	(32642,'12','057',' 06','057060',57060,'Rivodutri','Rivodutri','','RI',1,'1840-01-01','2999-12-31'),
	(32643,'12','057',' 06','057061',57061,'Roccantica','Roccantica','','RI',1,'1840-01-01','2999-12-31'),
	(32644,'12','057',' 06','057062',57062,'Rocca Sinibalda','Rocca Sinibalda','','RI',1,'1840-01-01','2999-12-31'),
	(32645,'12','057',' 06','057063',57063,'Salisano','Salisano','','RI',1,'1840-01-01','2999-12-31'),
	(32646,'12','057',' 06','057064',57064,'Scandriglia','Scandriglia','','RI',1,'1840-01-01','2999-12-31'),
	(32647,'12','057',' 06','057065',57065,'Selci','Selci','','RI',1,'1840-01-01','2999-12-31'),
	(32648,'12','057',' 06','057066',57066,'Stimigliano','Stimigliano','','RI',1,'1840-01-01','2999-12-31'),
	(32649,'12','057',' 06','057067',57067,'Tarano','Tarano','','RI',1,'1840-01-01','2999-12-31'),
	(32650,'12','057',' 06','057068',57068,'Toffia','Toffia','','RI',1,'1840-01-01','2999-12-31'),
	(32651,'12','057',' 06','057069',57069,'Torricella in Sabina','Torricella in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32652,'12','057',' 07','057070',57070,'Torri in Sabina','Torri in Sabina','','RI',1,'1840-01-01','2999-12-31'),
	(32653,'12','057',' 07','057071',57071,'Turania','Turania','','RI',1,'1840-01-01','2999-12-31'),
	(32654,'12','057',' 07','057072',57072,'Vacone','Vacone','','RI',1,'1840-01-01','2999-12-31'),
	(32655,'12','057',' 07','057073',57073,'Varco Sabino','Varco Sabino','','RI',1,'1840-01-01','2999-12-31'),
	(32656,'12','058',' 00','058001',58001,'Affile','Affile','','RM',1,'1840-01-01','2999-12-31'),
	(32657,'12','058',' 00','058002',58002,'Agosta','Agosta','','RM',1,'1840-01-01','2999-12-31'),
	(32658,'12','058',' 00','058003',58003,'Albano Laziale','Albano Laziale','','RM',1,'1840-01-01','2999-12-31'),
	(32659,'12','058',' 00','058004',58004,'Allumiere','Allumiere','','RM',1,'1840-01-01','2999-12-31'),
	(32660,'12','058',' 00','058005',58005,'Anguillara Sabazia','Anguillara Sabazia','','RM',1,'1840-01-01','2999-12-31'),
	(32661,'12','058',' 00','058006',58006,'Anticoli Corrado','Anticoli Corrado','','RM',1,'1840-01-01','2999-12-31'),
	(32662,'12','058',' 00','058007',58007,'Anzio','Anzio','','RM',1,'1840-01-01','2999-12-31'),
	(32663,'12','058',' 00','058008',58008,'Arcinazzo Romano','Arcinazzo Romano','','RM',1,'1840-01-01','2999-12-31');

INSERT INTO `COMUNI_ITALIANI` (`IDCOMUNE`, `CODICE_REGIONE`, `CODICE_PROVINCIA`, `CODICE_COMUNE`, `CODICE_ISTAT_A`, `CODICE_ISTAT_N`, `DENOMINAZIONE_IT_DE`, `DENOMINAZIONE_IT`, `DENOMINAZIONE_DE`, `SIGLA_PROVINCIA`, `STATUS`, `INIZIO_VALIDITA`, `FINE_VALIDITA`)
VALUES
	(32664,'12','058',' 00','058009',58009,'Ariccia','Ariccia','','RM',1,'1840-01-01','2999-12-31'),
	(32665,'12','058',' 01','058010',58010,'Arsoli','Arsoli','','RM',1,'1840-01-01','2999-12-31'),
	(32666,'12','058',' 01','058011',58011,'Artena','Artena','','RM',1,'1840-01-01','2999-12-31'),
	(32667,'12','058',' 01','058012',58012,'Bellegra','Bellegra','','RM',1,'1840-01-01','2999-12-31'),
	(32668,'12','058',' 01','058013',58013,'Bracciano','Bracciano','','RM',1,'1840-01-01','2999-12-31'),
	(32669,'12','058',' 01','058014',58014,'Camerata Nuova','Camerata Nuova','','RM',1,'1840-01-01','2999-12-31'),
	(32670,'12','058',' 01','058015',58015,'Campagnano di Roma','Campagnano di Roma','','RM',1,'1840-01-01','2999-12-31'),
	(32671,'12','058',' 01','058016',58016,'Canale Monterano','Canale Monterano','','RM',1,'1840-01-01','2999-12-31'),
	(32672,'12','058',' 01','058017',58017,'Canterano','Canterano','','RM',1,'1840-01-01','2999-12-31'),
	(32673,'12','058',' 01','058018',58018,'Capena','Capena','','RM',1,'1840-01-01','2999-12-31'),
	(32674,'12','058',' 01','058019',58019,'Capranica Prenestina','Capranica Prenestina','','RM',1,'1840-01-01','2999-12-31'),
	(32675,'12','058',' 02','058020',58020,'Carpineto Romano','Carpineto Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32676,'12','058',' 02','058021',58021,'Casape','Casape','','RM',1,'1840-01-01','2999-12-31'),
	(32677,'12','058',' 02','058022',58022,'Castel Gandolfo','Castel Gandolfo','','RM',1,'1840-01-01','2999-12-31'),
	(32678,'12','058',' 02','058023',58023,'Castel Madama','Castel Madama','','RM',1,'1840-01-01','2999-12-31'),
	(32679,'12','058',' 02','058024',58024,'Castelnuovo di Porto','Castelnuovo di Porto','','RM',1,'1840-01-01','2999-12-31'),
	(32680,'12','058',' 02','058025',58025,'Castel San Pietro Romano','Castel San Pietro Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32681,'12','058',' 02','058026',58026,'Cave','Cave','','RM',1,'1840-01-01','2999-12-31'),
	(32682,'12','058',' 02','058027',58027,'Cerreto Laziale','Cerreto Laziale','','RM',1,'1840-01-01','2999-12-31'),
	(32683,'12','058',' 02','058028',58028,'Cervara di Roma','Cervara di Roma','','RM',1,'1840-01-01','2999-12-31'),
	(32684,'12','058',' 02','058029',58029,'Cerveteri','Cerveteri','','RM',1,'1840-01-01','2999-12-31'),
	(32685,'12','058',' 03','058030',58030,'Ciciliano','Ciciliano','','RM',1,'1840-01-01','2999-12-31'),
	(32686,'12','058',' 03','058031',58031,'Cineto Romano','Cineto Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32687,'12','058',' 03','058032',58032,'Civitavecchia','Civitavecchia','','RM',1,'1840-01-01','2999-12-31'),
	(32688,'12','058',' 03','058033',58033,'Civitella San Paolo','Civitella San Paolo','','RM',1,'1840-01-01','2999-12-31'),
	(32689,'12','058',' 03','058034',58034,'Colleferro','Colleferro','','RM',1,'1840-01-01','2999-12-31'),
	(32690,'12','058',' 03','058035',58035,'Colonna','Colonna','','RM',1,'1840-01-01','2999-12-31'),
	(32691,'12','058',' 03','058036',58036,'Fiano Romano','Fiano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32692,'12','058',' 03','058037',58037,'Filacciano','Filacciano','','RM',1,'1840-01-01','2999-12-31'),
	(32693,'12','058',' 03','058038',58038,'Formello','Formello','','RM',1,'1840-01-01','2999-12-31'),
	(32694,'12','058',' 03','058039',58039,'Frascati','Frascati','','RM',1,'1840-01-01','2999-12-31'),
	(32695,'12','058',' 04','058040',58040,'Gallicano nel Lazio','Gallicano nel Lazio','','RM',1,'1840-01-01','2999-12-31'),
	(32696,'12','058',' 04','058041',58041,'Gavignano','Gavignano','','RM',1,'1840-01-01','2999-12-31'),
	(32697,'12','058',' 04','058042',58042,'Genazzano','Genazzano','','RM',1,'1840-01-01','2999-12-31'),
	(32698,'12','058',' 04','058043',58043,'Genzano di Roma','Genzano di Roma','','RM',1,'1840-01-01','2999-12-31'),
	(32699,'12','058',' 04','058044',58044,'Gerano','Gerano','','RM',1,'1840-01-01','2999-12-31'),
	(32700,'12','058',' 04','058045',58045,'Gorga','Gorga','','RM',1,'1840-01-01','2999-12-31'),
	(32701,'12','058',' 04','058046',58046,'Grottaferrata','Grottaferrata','','RM',1,'1840-01-01','2999-12-31'),
	(32702,'12','058',' 04','058047',58047,'Guidonia Montecelio','Guidonia Montecelio','','RM',1,'1840-01-01','2999-12-31'),
	(32703,'12','058',' 04','058048',58048,'Jenne','Jenne','','RM',1,'1840-01-01','2999-12-31'),
	(32704,'12','058',' 04','058049',58049,'Labico','Labico','','RM',1,'1840-01-01','2999-12-31'),
	(32705,'12','058',' 05','058050',58050,'Lanuvio','Lanuvio','','RM',1,'1840-01-01','2999-12-31'),
	(32706,'12','058',' 05','058051',58051,'Licenza','Licenza','','RM',1,'1840-01-01','2999-12-31'),
	(32707,'12','058',' 05','058052',58052,'Magliano Romano','Magliano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32708,'12','058',' 05','058053',58053,'Mandela','Mandela','','RM',1,'1840-01-01','2999-12-31'),
	(32709,'12','058',' 05','058054',58054,'Manziana','Manziana','','RM',1,'1840-01-01','2999-12-31'),
	(32710,'12','058',' 05','058055',58055,'Marano Equo','Marano Equo','','RM',1,'1840-01-01','2999-12-31'),
	(32711,'12','058',' 05','058056',58056,'Marcellina','Marcellina','','RM',1,'1840-01-01','2999-12-31'),
	(32712,'12','058',' 05','058057',58057,'Marino','Marino','','RM',1,'1840-01-01','2999-12-31'),
	(32713,'12','058',' 05','058058',58058,'Mazzano Romano','Mazzano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32714,'12','058',' 05','058059',58059,'Mentana','Mentana','','RM',1,'1840-01-01','2999-12-31'),
	(32715,'12','058',' 06','058060',58060,'Monte Compatri','Monte Compatri','','RM',1,'1840-01-01','2999-12-31'),
	(32716,'12','058',' 06','058061',58061,'Monteflavio','Monteflavio','','RM',1,'1840-01-01','2999-12-31'),
	(32717,'12','058',' 06','058062',58062,'Montelanico','Montelanico','','RM',1,'1840-01-01','2999-12-31'),
	(32718,'12','058',' 06','058063',58063,'Montelibretti','Montelibretti','','RM',1,'1840-01-01','2999-12-31'),
	(32719,'12','058',' 06','058064',58064,'Monte Porzio Catone','Monte Porzio Catone','','RM',1,'1840-01-01','2999-12-31'),
	(32720,'12','058',' 06','058065',58065,'Monterotondo','Monterotondo','','RM',1,'1840-01-01','2999-12-31'),
	(32721,'12','058',' 06','058066',58066,'Montorio Romano','Montorio Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32722,'12','058',' 06','058067',58067,'Moricone','Moricone','','RM',1,'1840-01-01','2999-12-31'),
	(32723,'12','058',' 06','058068',58068,'Morlupo','Morlupo','','RM',1,'1840-01-01','2999-12-31'),
	(32724,'12','058',' 06','058069',58069,'Nazzano','Nazzano','','RM',1,'1840-01-01','2999-12-31'),
	(32725,'12','058',' 07','058070',58070,'Nemi','Nemi','','RM',1,'1840-01-01','2999-12-31'),
	(32726,'12','058',' 07','058071',58071,'Nerola','Nerola','','RM',1,'1840-01-01','2999-12-31'),
	(32727,'12','058',' 07','058072',58072,'Nettuno','Nettuno','','RM',1,'1840-01-01','2999-12-31'),
	(32728,'12','058',' 07','058073',58073,'Olevano Romano','Olevano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32729,'12','058',' 07','058074',58074,'Palestrina','Palestrina','','RM',1,'1840-01-01','2999-12-31'),
	(32730,'12','058',' 07','058075',58075,'Palombara Sabina','Palombara Sabina','','RM',1,'1840-01-01','2999-12-31'),
	(32731,'12','058',' 07','058076',58076,'Percile','Percile','','RM',1,'1840-01-01','2999-12-31'),
	(32732,'12','058',' 07','058077',58077,'Pisoniano','Pisoniano','','RM',1,'1840-01-01','2999-12-31'),
	(32733,'12','058',' 07','058078',58078,'Poli','Poli','','RM',1,'1840-01-01','2999-12-31'),
	(32734,'12','058',' 07','058079',58079,'Pomezia','Pomezia','','RM',1,'1840-01-01','2999-12-31'),
	(32735,'12','058',' 08','058080',58080,'Ponzano Romano','Ponzano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32736,'12','058',' 08','058081',58081,'Riano','Riano','','RM',1,'1840-01-01','2999-12-31'),
	(32737,'12','058',' 08','058082',58082,'Rignano Flaminio','Rignano Flaminio','','RM',1,'1840-01-01','2999-12-31'),
	(32738,'12','058',' 08','058083',58083,'Riofreddo','Riofreddo','','RM',1,'1840-01-01','2999-12-31'),
	(32739,'12','058',' 08','058084',58084,'Rocca Canterano','Rocca Canterano','','RM',1,'1840-01-01','2999-12-31'),
	(32740,'12','058',' 08','058085',58085,'Rocca di Cave','Rocca di Cave','','RM',1,'1840-01-01','2999-12-31'),
	(32741,'12','058',' 08','058086',58086,'Rocca di Papa','Rocca di Papa','','RM',1,'1840-01-01','2999-12-31'),
	(32742,'12','058',' 08','058087',58087,'Roccagiovine','Roccagiovine','','RM',1,'1840-01-01','2999-12-31'),
	(32743,'12','058',' 08','058088',58088,'Rocca Priora','Rocca Priora','','RM',1,'1840-01-01','2999-12-31'),
	(32744,'12','058',' 08','058089',58089,'Rocca Santo Stefano','Rocca Santo Stefano','','RM',1,'1840-01-01','2999-12-31'),
	(32745,'12','058',' 09','058090',58090,'Roiate','Roiate','','RM',1,'1840-01-01','2999-12-31'),
	(32746,'12','058',' 09','058091',58091,'Roma','Roma','','RM',1,'1840-01-01','2999-12-31'),
	(32747,'12','058',' 09','058092',58092,'Roviano','Roviano','','RM',1,'1840-01-01','2999-12-31'),
	(32748,'12','058',' 09','058093',58093,'Sacrofano','Sacrofano','','RM',1,'1840-01-01','2999-12-31'),
	(32749,'12','058',' 09','058094',58094,'Sambuci','Sambuci','','RM',1,'1840-01-01','2999-12-31'),
	(32750,'12','058',' 09','058095',58095,'San Gregorio da Sassola','San Gregorio da Sassola','','RM',1,'1840-01-01','2999-12-31'),
	(32751,'12','058',' 09','058096',58096,'San Polo dei Cavalieri','San Polo dei Cavalieri','','RM',1,'1840-01-01','2999-12-31'),
	(32752,'12','058',' 09','058097',58097,'Santa Marinella','Santa Marinella','','RM',1,'1840-01-01','2999-12-31'),
	(32753,'12','058',' 09','058098',58098,'Sant\'Angelo Romano','Sant\'Angelo Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32754,'12','058',' 09','058099',58099,'Sant\'Oreste','Sant\'Oreste','','RM',1,'1840-01-01','2999-12-31'),
	(32755,'12','058',' 10','058100',58100,'San Vito Romano','San Vito Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32756,'12','058',' 10','058101',58101,'Saracinesco','Saracinesco','','RM',1,'1840-01-01','2999-12-31'),
	(32757,'12','058',' 10','058102',58102,'Segni','Segni','','RM',1,'1840-01-01','2999-12-31'),
	(32758,'12','058',' 10','058103',58103,'Subiaco','Subiaco','','RM',1,'1840-01-01','2999-12-31'),
	(32759,'12','058',' 10','058104',58104,'Tivoli','Tivoli','','RM',1,'1840-01-01','2999-12-31'),
	(32760,'12','058',' 10','058105',58105,'Tolfa','Tolfa','','RM',1,'1840-01-01','2999-12-31'),
	(32761,'12','058',' 10','058106',58106,'Torrita Tiberina','Torrita Tiberina','','RM',1,'1840-01-01','2999-12-31'),
	(32762,'12','058',' 10','058107',58107,'Trevignano Romano','Trevignano Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32763,'12','058',' 10','058108',58108,'Vallepietra','Vallepietra','','RM',1,'1840-01-01','2999-12-31'),
	(32764,'12','058',' 10','058109',58109,'Vallinfreda','Vallinfreda','','RM',1,'1840-01-01','2999-12-31'),
	(32765,'12','058',' 11','058110',58110,'Valmontone','Valmontone','','RM',1,'1840-01-01','2999-12-31'),
	(32766,'12','058',' 11','058111',58111,'Velletri','Velletri','','RM',1,'1840-01-01','2999-12-31'),
	(32767,'12','058',' 11','058112',58112,'Vicovaro','Vicovaro','','RM',1,'1840-01-01','2999-12-31'),
	(32768,'12','058',' 11','058113',58113,'Vivaro Romano','Vivaro Romano','','RM',1,'1840-01-01','2999-12-31'),
	(32769,'12','058',' 11','058114',58114,'Zagarolo','Zagarolo','','RM',1,'1840-01-01','2999-12-31'),
	(32770,'12','058',' 11','058115',58115,'Lariano','Lariano','','RM',1,'1840-01-01','2999-12-31'),
	(32771,'12','058',' 11','058116',58116,'Ladispoli','Ladispoli','','RM',1,'1840-01-01','2999-12-31'),
	(32772,'12','058',' 11','058117',58117,'Ardea','Ardea','','RM',1,'1840-01-01','2999-12-31'),
	(32773,'12','058',' 11','058118',58118,'Ciampino','Ciampino','','RM',1,'1840-01-01','2999-12-31'),
	(32774,'12','058',' 11','058119',58119,'San Cesareo','San Cesareo','','RM',1,'1840-01-01','2999-12-31'),
	(32775,'12','058',' 12','058120',58120,'Fiumicino','Fiumicino','','RM',1,'1840-01-01','2999-12-31'),
	(32776,'12','058',' 12','058122',58122,'Fonte Nuova','Fonte Nuova','','RM',1,'1840-01-01','2999-12-31'),
	(32777,'12','059',' 00','059001',59001,'Aprilia','Aprilia','','LT',1,'1840-01-01','2999-12-31'),
	(32778,'12','059',' 00','059002',59002,'Bassiano','Bassiano','','LT',1,'1840-01-01','2999-12-31'),
	(32779,'12','059',' 00','059003',59003,'Campodimele','Campodimele','','LT',1,'1840-01-01','2999-12-31'),
	(32780,'12','059',' 00','059004',59004,'Castelforte','Castelforte','','LT',1,'1840-01-01','2999-12-31'),
	(32781,'12','059',' 00','059005',59005,'Cisterna di Latina','Cisterna di Latina','','LT',1,'1840-01-01','2999-12-31'),
	(32782,'12','059',' 00','059006',59006,'Cori','Cori','','LT',1,'1840-01-01','2999-12-31'),
	(32783,'12','059',' 00','059007',59007,'Fondi','Fondi','','LT',1,'1840-01-01','2999-12-31'),
	(32784,'12','059',' 00','059008',59008,'Formia','Formia','','LT',1,'1840-01-01','2999-12-31'),
	(32785,'12','059',' 00','059009',59009,'Gaeta','Gaeta','','LT',1,'1840-01-01','2999-12-31'),
	(32786,'12','059',' 01','059010',59010,'Itri','Itri','','LT',1,'1840-01-01','2999-12-31'),
	(32787,'12','059',' 01','059011',59011,'Latina','Latina','','LT',1,'1840-01-01','2999-12-31'),
	(32788,'12','059',' 01','059012',59012,'Lenola','Lenola','','LT',1,'1840-01-01','2999-12-31'),
	(32789,'12','059',' 01','059013',59013,'Maenza','Maenza','','LT',1,'1840-01-01','2999-12-31'),
	(32790,'12','059',' 01','059014',59014,'Minturno','Minturno','','LT',1,'1840-01-01','2999-12-31'),
	(32791,'12','059',' 01','059015',59015,'Monte San Biagio','Monte San Biagio','','LT',1,'1840-01-01','2999-12-31'),
	(32792,'12','059',' 01','059016',59016,'Norma','Norma','','LT',1,'1840-01-01','2999-12-31'),
	(32793,'12','059',' 01','059017',59017,'Pontinia','Pontinia','','LT',1,'1840-01-01','2999-12-31'),
	(32794,'12','059',' 01','059018',59018,'Ponza','Ponza','','LT',1,'1840-01-01','2999-12-31'),
	(32795,'12','059',' 01','059019',59019,'Priverno','Priverno','','LT',1,'1840-01-01','2999-12-31'),
	(32796,'12','059',' 02','059020',59020,'Prossedi','Prossedi','','LT',1,'1840-01-01','2999-12-31'),
	(32797,'12','059',' 02','059021',59021,'Roccagorga','Roccagorga','','LT',1,'1840-01-01','2999-12-31'),
	(32798,'12','059',' 02','059022',59022,'Rocca Massima','Rocca Massima','','LT',1,'1840-01-01','2999-12-31'),
	(32799,'12','059',' 02','059023',59023,'Roccasecca dei Volsci','Roccasecca dei Volsci','','LT',1,'1840-01-01','2999-12-31'),
	(32800,'12','059',' 02','059024',59024,'Sabaudia','Sabaudia','','LT',1,'1840-01-01','2999-12-31'),
	(32801,'12','059',' 02','059025',59025,'San Felice Circeo','San Felice Circeo','','LT',1,'1840-01-01','2999-12-31'),
	(32802,'12','059',' 02','059026',59026,'Santi Cosma e Damiano','Santi Cosma e Damiano','','LT',1,'1840-01-01','2999-12-31'),
	(32803,'12','059',' 02','059027',59027,'Sermoneta','Sermoneta','','LT',1,'1840-01-01','2999-12-31'),
	(32804,'12','059',' 02','059028',59028,'Sezze','Sezze','','LT',1,'1840-01-01','2999-12-31'),
	(32805,'12','059',' 02','059029',59029,'Sonnino','Sonnino','','LT',1,'1840-01-01','2999-12-31'),
	(32806,'12','059',' 03','059030',59030,'Sperlonga','Sperlonga','','LT',1,'1840-01-01','2999-12-31'),
	(32807,'12','059',' 03','059031',59031,'Spigno Saturnia','Spigno Saturnia','','LT',1,'1840-01-01','2999-12-31'),
	(32808,'12','059',' 03','059032',59032,'Terracina','Terracina','','LT',1,'1840-01-01','2999-12-31'),
	(32809,'12','059',' 03','059033',59033,'Ventotene','Ventotene','','LT',1,'1840-01-01','2999-12-31'),
	(32810,'12','060',' 00','060001',60001,'Acquafondata','Acquafondata','','FR',1,'1840-01-01','2999-12-31'),
	(32811,'12','060',' 00','060002',60002,'Acuto','Acuto','','FR',1,'1840-01-01','2999-12-31'),
	(32812,'12','060',' 00','060003',60003,'Alatri','Alatri','','FR',1,'1840-01-01','2999-12-31'),
	(32813,'12','060',' 00','060004',60004,'Alvito','Alvito','','FR',1,'1840-01-01','2999-12-31'),
	(32814,'12','060',' 00','060005',60005,'Amaseno','Amaseno','','FR',1,'1840-01-01','2999-12-31'),
	(32815,'12','060',' 00','060006',60006,'Anagni','Anagni','','FR',1,'1840-01-01','2999-12-31'),
	(32816,'12','060',' 00','060007',60007,'Aquino','Aquino','','FR',1,'1840-01-01','2999-12-31'),
	(32817,'12','060',' 00','060008',60008,'Arce','Arce','','FR',1,'1840-01-01','2999-12-31'),
	(32818,'12','060',' 00','060009',60009,'Arnara','Arnara','','FR',1,'1840-01-01','2999-12-31'),
	(32819,'12','060',' 01','060010',60010,'Arpino','Arpino','','FR',1,'1840-01-01','2999-12-31'),
	(32820,'12','060',' 01','060011',60011,'Atina','Atina','','FR',1,'1840-01-01','2999-12-31'),
	(32821,'12','060',' 01','060012',60012,'Ausonia','Ausonia','','FR',1,'1840-01-01','2999-12-31'),
	(32822,'12','060',' 01','060013',60013,'Belmonte Castello','Belmonte Castello','','FR',1,'1840-01-01','2999-12-31'),
	(32823,'12','060',' 01','060014',60014,'Boville Ernica','Boville Ernica','','FR',1,'1840-01-01','2999-12-31'),
	(32824,'12','060',' 01','060015',60015,'Broccostella','Broccostella','','FR',1,'1840-01-01','2999-12-31'),
	(32825,'12','060',' 01','060016',60016,'Campoli Appennino','Campoli Appennino','','FR',1,'1840-01-01','2999-12-31'),
	(32826,'12','060',' 01','060017',60017,'Casalattico','Casalattico','','FR',1,'1840-01-01','2999-12-31'),
	(32827,'12','060',' 01','060018',60018,'Casalvieri','Casalvieri','','FR',1,'1840-01-01','2999-12-31'),
	(32828,'12','060',' 01','060019',60019,'Cassino','Cassino','','FR',1,'1840-01-01','2999-12-31'),
	(32829,'12','060',' 02','060020',60020,'Castelliri','Castelliri','','FR',1,'1840-01-01','2999-12-31'),
	(32830,'12','060',' 02','060021',60021,'Castelnuovo Parano','Castelnuovo Parano','','FR',1,'1840-01-01','2999-12-31'),
	(32831,'12','060',' 02','060022',60022,'Castrocielo','Castrocielo','','FR',1,'1840-01-01','2999-12-31'),
	(32832,'12','060',' 02','060023',60023,'Castro dei Volsci','Castro dei Volsci','','FR',1,'1840-01-01','2999-12-31'),
	(32833,'12','060',' 02','060024',60024,'Ceccano','Ceccano','','FR',1,'1840-01-01','2999-12-31'),
	(32834,'12','060',' 02','060025',60025,'Ceprano','Ceprano','','FR',1,'1840-01-01','2999-12-31'),
	(32835,'12','060',' 02','060026',60026,'Cervaro','Cervaro','','FR',1,'1840-01-01','2999-12-31'),
	(32836,'12','060',' 02','060027',60027,'Colfelice','Colfelice','','FR',1,'1840-01-01','2999-12-31'),
	(32837,'12','060',' 02','060028',60028,'Collepardo','Collepardo','','FR',1,'1840-01-01','2999-12-31'),
	(32838,'12','060',' 02','060029',60029,'Colle San Magno','Colle San Magno','','FR',1,'1840-01-01','2999-12-31'),
	(32839,'12','060',' 03','060030',60030,'Coreno Ausonio','Coreno Ausonio','','FR',1,'1840-01-01','2999-12-31'),
	(32840,'12','060',' 03','060031',60031,'Esperia','Esperia','','FR',1,'1840-01-01','2999-12-31'),
	(32841,'12','060',' 03','060032',60032,'Falvaterra','Falvaterra','','FR',1,'1840-01-01','2999-12-31'),
	(32842,'12','060',' 03','060033',60033,'Ferentino','Ferentino','','FR',1,'1840-01-01','2999-12-31'),
	(32843,'12','060',' 03','060034',60034,'Filettino','Filettino','','FR',1,'1840-01-01','2999-12-31'),
	(32844,'12','060',' 03','060035',60035,'Fiuggi','Fiuggi','','FR',1,'1840-01-01','2999-12-31'),
	(32845,'12','060',' 03','060036',60036,'Fontana Liri','Fontana Liri','','FR',1,'1840-01-01','2999-12-31'),
	(32846,'12','060',' 03','060037',60037,'Fontechiari','Fontechiari','','FR',1,'1840-01-01','2999-12-31'),
	(32847,'12','060',' 03','060038',60038,'Frosinone','Frosinone','','FR',1,'1840-01-01','2999-12-31'),
	(32848,'12','060',' 03','060039',60039,'Fumone','Fumone','','FR',1,'1840-01-01','2999-12-31'),
	(32849,'12','060',' 04','060040',60040,'Gallinaro','Gallinaro','','FR',1,'1840-01-01','2999-12-31'),
	(32850,'12','060',' 04','060041',60041,'Giuliano di Roma','Giuliano di Roma','','FR',1,'1840-01-01','2999-12-31'),
	(32851,'12','060',' 04','060042',60042,'Guarcino','Guarcino','','FR',1,'1840-01-01','2999-12-31'),
	(32852,'12','060',' 04','060043',60043,'Isola del Liri','Isola del Liri','','FR',1,'1840-01-01','2999-12-31'),
	(32853,'12','060',' 04','060044',60044,'Monte San Giovanni Campano','Monte San Giovanni Campano','','FR',1,'1840-01-01','2999-12-31'),
	(32854,'12','060',' 04','060045',60045,'Morolo','Morolo','','FR',1,'1840-01-01','2999-12-31'),
	(32855,'12','060',' 04','060046',60046,'Paliano','Paliano','','FR',1,'1840-01-01','2999-12-31'),
	(32856,'12','060',' 04','060047',60047,'Pastena','Pastena','','FR',1,'1840-01-01','2999-12-31'),
	(32857,'12','060',' 04','060048',60048,'Patrica','Patrica','','FR',1,'1840-01-01','2999-12-31'),
	(32858,'12','060',' 04','060049',60049,'Pescosolido','Pescosolido','','FR',1,'1840-01-01','2999-12-31'),
	(32859,'12','060',' 05','060050',60050,'Picinisco','Picinisco','','FR',1,'1840-01-01','2999-12-31'),
	(32860,'12','060',' 05','060051',60051,'Pico','Pico','','FR',1,'1840-01-01','2999-12-31'),
	(32861,'12','060',' 05','060052',60052,'Piedimonte San Germano','Piedimonte San Germano','','FR',1,'1840-01-01','2999-12-31'),
	(32862,'12','060',' 05','060053',60053,'Piglio','Piglio','','FR',1,'1840-01-01','2999-12-31'),
	(32863,'12','060',' 05','060054',60054,'Pignataro Interamna','Pignataro Interamna','','FR',1,'1840-01-01','2999-12-31'),
	(32864,'12','060',' 05','060055',60055,'Pofi','Pofi','','FR',1,'1840-01-01','2999-12-31'),
	(32865,'12','060',' 05','060056',60056,'Pontecorvo','Pontecorvo','','FR',1,'1840-01-01','2999-12-31'),
	(32866,'12','060',' 05','060057',60057,'Posta Fibreno','Posta Fibreno','','FR',1,'1840-01-01','2999-12-31'),
	(32867,'12','060',' 05','060058',60058,'Ripi','Ripi','','FR',1,'1840-01-01','2999-12-31'),
	(32868,'12','060',' 05','060059',60059,'Rocca d\'Arce','Rocca d\'Arce','','FR',1,'1840-01-01','2999-12-31'),
	(32869,'12','060',' 06','060060',60060,'Roccasecca','Roccasecca','','FR',1,'1840-01-01','2999-12-31'),
	(32870,'12','060',' 06','060061',60061,'San Biagio Saracinisco','San Biagio Saracinisco','','FR',1,'1840-01-01','2999-12-31'),
	(32871,'12','060',' 06','060062',60062,'San Donato Val di Comino','San Donato Val di Comino','','FR',1,'1840-01-01','2999-12-31'),
	(32872,'12','060',' 06','060063',60063,'San Giorgio a Liri','San Giorgio a Liri','','FR',1,'1840-01-01','2999-12-31'),
	(32873,'12','060',' 06','060064',60064,'San Giovanni Incarico','San Giovanni Incarico','','FR',1,'1840-01-01','2999-12-31'),
	(32874,'12','060',' 06','060065',60065,'Sant\'Ambrogio sul Garigliano','Sant\'Ambrogio sul Garigliano','','FR',1,'1840-01-01','2999-12-31'),
	(32875,'12','060',' 06','060066',60066,'Sant\'Andrea del Garigliano','Sant\'Andrea del Garigliano','','FR',1,'1840-01-01','2999-12-31'),
	(32876,'12','060',' 06','060067',60067,'Sant\'Apollinare','Sant\'Apollinare','','FR',1,'1840-01-01','2999-12-31'),
	(32877,'12','060',' 06','060068',60068,'Sant\'Elia Fiumerapido','Sant\'Elia Fiumerapido','','FR',1,'1840-01-01','2999-12-31'),
	(32878,'12','060',' 06','060069',60069,'Santopadre','Santopadre','','FR',1,'1840-01-01','2999-12-31'),
	(32879,'12','060',' 07','060070',60070,'San Vittore del Lazio','San Vittore del Lazio','','FR',1,'1840-01-01','2999-12-31'),
	(32880,'12','060',' 07','060071',60071,'Serrone','Serrone','','FR',1,'1840-01-01','2999-12-31'),
	(32881,'12','060',' 07','060072',60072,'Settefrati','Settefrati','','FR',1,'1840-01-01','2999-12-31'),
	(32882,'12','060',' 07','060073',60073,'Sgurgola','Sgurgola','','FR',1,'1840-01-01','2999-12-31'),
	(32883,'12','060',' 07','060074',60074,'Sora','Sora','','FR',1,'1840-01-01','2999-12-31'),
	(32884,'12','060',' 07','060075',60075,'Strangolagalli','Strangolagalli','','FR',1,'1840-01-01','2999-12-31'),
	(32885,'12','060',' 07','060076',60076,'Supino','Supino','','FR',1,'1840-01-01','2999-12-31'),
	(32886,'12','060',' 07','060077',60077,'Terelle','Terelle','','FR',1,'1840-01-01','2999-12-31'),
	(32887,'12','060',' 07','060078',60078,'Torre Cajetani','Torre Cajetani','','FR',1,'1840-01-01','2999-12-31'),
	(32888,'12','060',' 07','060079',60079,'Torrice','Torrice','','FR',1,'1840-01-01','2999-12-31'),
	(32889,'12','060',' 08','060080',60080,'Trevi nel Lazio','Trevi nel Lazio','','FR',1,'1840-01-01','2999-12-31'),
	(32890,'12','060',' 08','060081',60081,'Trivigliano','Trivigliano','','FR',1,'1840-01-01','2999-12-31'),
	(32891,'12','060',' 08','060082',60082,'Vallecorsa','Vallecorsa','','FR',1,'1840-01-01','2999-12-31'),
	(32892,'12','060',' 08','060083',60083,'Vallemaio','Vallemaio','','FR',1,'1840-01-01','2999-12-31'),
	(32893,'12','060',' 08','060084',60084,'Vallerotonda','Vallerotonda','','FR',1,'1840-01-01','2999-12-31'),
	(32894,'12','060',' 08','060085',60085,'Veroli','Veroli','','FR',1,'1840-01-01','2999-12-31'),
	(32895,'12','060',' 08','060086',60086,'Vicalvi','Vicalvi','','FR',1,'1840-01-01','2999-12-31'),
	(32896,'12','060',' 08','060087',60087,'Vico nel Lazio','Vico nel Lazio','','FR',1,'1840-01-01','2999-12-31'),
	(32897,'12','060',' 08','060088',60088,'Villa Latina','Villa Latina','','FR',1,'1840-01-01','2999-12-31'),
	(32898,'12','060',' 08','060089',60089,'Villa Santa Lucia','Villa Santa Lucia','','FR',1,'1840-01-01','2999-12-31'),
	(32899,'12','060',' 09','060090',60090,'Villa Santo Stefano','Villa Santo Stefano','','FR',1,'1840-01-01','2999-12-31'),
	(32900,'12','060',' 09','060091',60091,'Viticuso','Viticuso','','FR',1,'1840-01-01','2999-12-31'),
	(32901,'15','061',' 00','061001',61001,'Ailano','Ailano','','CE',1,'1840-01-01','2999-12-31'),
	(32902,'15','061',' 00','061002',61002,'Alife','Alife','','CE',1,'1840-01-01','2999-12-31'),
	(32903,'15','061',' 00','061003',61003,'Alvignano','Alvignano','','CE',1,'1840-01-01','2999-12-31'),
	(32904,'15','061',' 00','061004',61004,'Arienzo','Arienzo','','CE',1,'1840-01-01','2999-12-31'),
	(32905,'15','061',' 00','061005',61005,'Aversa','Aversa','','CE',1,'1840-01-01','2999-12-31'),
	(32906,'15','061',' 00','061006',61006,'Baia e Latina','Baia e Latina','','CE',1,'1840-01-01','2999-12-31'),
	(32907,'15','061',' 00','061007',61007,'Bellona','Bellona','','CE',1,'1840-01-01','2999-12-31'),
	(32908,'15','061',' 00','061008',61008,'Caianello','Caianello','','CE',1,'1840-01-01','2999-12-31'),
	(32909,'15','061',' 00','061009',61009,'Caiazzo','Caiazzo','','CE',1,'1840-01-01','2999-12-31'),
	(32910,'15','061',' 01','061010',61010,'Calvi Risorta','Calvi Risorta','','CE',1,'1840-01-01','2999-12-31'),
	(32911,'15','061',' 01','061011',61011,'Camigliano','Camigliano','','CE',1,'1840-01-01','2999-12-31'),
	(32912,'15','061',' 01','061012',61012,'Cancello ed Arnone','Cancello ed Arnone','','CE',1,'1840-01-01','2999-12-31'),
	(32913,'15','061',' 01','061013',61013,'Capodrise','Capodrise','','CE',1,'1840-01-01','2999-12-31'),
	(32914,'15','061',' 01','061014',61014,'Capriati a Volturno','Capriati a Volturno','','CE',1,'1840-01-01','2999-12-31'),
	(32915,'15','061',' 01','061015',61015,'Capua','Capua','','CE',1,'1840-01-01','2999-12-31'),
	(32916,'15','061',' 01','061016',61016,'Carinaro','Carinaro','','CE',1,'1840-01-01','2999-12-31'),
	(32917,'15','061',' 01','061017',61017,'Carinola','Carinola','','CE',1,'1840-01-01','2999-12-31'),
	(32918,'15','061',' 01','061018',61018,'Casagiove','Casagiove','','CE',1,'1840-01-01','2999-12-31'),
	(32919,'15','061',' 01','061019',61019,'Casal di Principe','Casal di Principe','','CE',1,'1840-01-01','2999-12-31'),
	(32920,'15','061',' 02','061020',61020,'Casaluce','Casaluce','','CE',1,'1840-01-01','2999-12-31'),
	(32921,'15','061',' 02','061021',61021,'Casapulla','Casapulla','','CE',1,'1840-01-01','2999-12-31'),
	(32922,'15','061',' 02','061022',61022,'Caserta','Caserta','','CE',1,'1840-01-01','2999-12-31'),
	(32923,'15','061',' 02','061023',61023,'Castel Campagnano','Castel Campagnano','','CE',1,'1840-01-01','2999-12-31'),
	(32924,'15','061',' 02','061024',61024,'Castel di Sasso','Castel di Sasso','','CE',1,'1840-01-01','2999-12-31'),
	(32925,'15','061',' 02','061025',61025,'Castello del Matese','Castello del Matese','','CE',1,'1840-01-01','2999-12-31'),
	(32926,'15','061',' 02','061026',61026,'Castel Morrone','Castel Morrone','','CE',1,'1840-01-01','2999-12-31'),
	(32927,'15','061',' 02','061027',61027,'Castel Volturno','Castel Volturno','','CE',1,'1840-01-01','2999-12-31'),
	(32928,'15','061',' 02','061028',61028,'Cervino','Cervino','','CE',1,'1840-01-01','2999-12-31'),
	(32929,'15','061',' 02','061029',61029,'Cesa','Cesa','','CE',1,'1840-01-01','2999-12-31'),
	(32930,'15','061',' 03','061030',61030,'Ciorlano','Ciorlano','','CE',1,'1840-01-01','2999-12-31'),
	(32931,'15','061',' 03','061031',61031,'Conca della Campania','Conca della Campania','','CE',1,'1840-01-01','2999-12-31'),
	(32932,'15','061',' 03','061032',61032,'Curti','Curti','','CE',1,'1840-01-01','2999-12-31'),
	(32933,'15','061',' 03','061033',61033,'Dragoni','Dragoni','','CE',1,'1840-01-01','2999-12-31'),
	(32934,'15','061',' 03','061034',61034,'Fontegreca','Fontegreca','','CE',1,'1840-01-01','2999-12-31'),
	(32935,'15','061',' 03','061035',61035,'Formicola','Formicola','','CE',1,'1840-01-01','2999-12-31'),
	(32936,'15','061',' 03','061036',61036,'Francolise','Francolise','','CE',1,'1840-01-01','2999-12-31'),
	(32937,'15','061',' 03','061037',61037,'Frignano','Frignano','','CE',1,'1840-01-01','2999-12-31'),
	(32938,'15','061',' 03','061038',61038,'Gallo Matese','Gallo Matese','','CE',1,'1840-01-01','2999-12-31'),
	(32939,'15','061',' 03','061039',61039,'Galluccio','Galluccio','','CE',1,'1840-01-01','2999-12-31'),
	(32940,'15','061',' 04','061040',61040,'Giano Vetusto','Giano Vetusto','','CE',1,'1840-01-01','2999-12-31'),
	(32941,'15','061',' 04','061041',61041,'Gioia Sannitica','Gioia Sannitica','','CE',1,'1840-01-01','2999-12-31'),
	(32942,'15','061',' 04','061042',61042,'Grazzanise','Grazzanise','','CE',1,'1840-01-01','2999-12-31'),
	(32943,'15','061',' 04','061043',61043,'Gricignano di Aversa','Gricignano di Aversa','','CE',1,'1840-01-01','2999-12-31'),
	(32944,'15','061',' 04','061044',61044,'Letino','Letino','','CE',1,'1840-01-01','2999-12-31'),
	(32945,'15','061',' 04','061045',61045,'Liberi','Liberi','','CE',1,'1840-01-01','2999-12-31'),
	(32946,'15','061',' 04','061046',61046,'Lusciano','Lusciano','','CE',1,'1840-01-01','2999-12-31'),
	(32947,'15','061',' 04','061047',61047,'Macerata Campania','Macerata Campania','','CE',1,'1840-01-01','2999-12-31'),
	(32948,'15','061',' 04','061048',61048,'Maddaloni','Maddaloni','','CE',1,'1840-01-01','2999-12-31'),
	(32949,'15','061',' 04','061049',61049,'Marcianise','Marcianise','','CE',1,'1840-01-01','2999-12-31'),
	(32950,'15','061',' 05','061050',61050,'Marzano Appio','Marzano Appio','','CE',1,'1840-01-01','2999-12-31'),
	(32951,'15','061',' 05','061051',61051,'Mignano Monte Lungo','Mignano Monte Lungo','','CE',1,'1840-01-01','2999-12-31'),
	(32952,'15','061',' 05','061052',61052,'Mondragone','Mondragone','','CE',1,'1840-01-01','2999-12-31'),
	(32953,'15','061',' 05','061053',61053,'Orta di Atella','Orta di Atella','','CE',1,'1840-01-01','2999-12-31'),
	(32954,'15','061',' 05','061054',61054,'Parete','Parete','','CE',1,'1840-01-01','2999-12-31'),
	(32955,'15','061',' 05','061055',61055,'Pastorano','Pastorano','','CE',1,'1840-01-01','2999-12-31'),
	(32956,'15','061',' 05','061056',61056,'Piana di Monte Verna','Piana di Monte Verna','','CE',1,'1840-01-01','2999-12-31'),
	(32957,'15','061',' 05','061057',61057,'Piedimonte Matese','Piedimonte Matese','','CE',1,'1840-01-01','2999-12-31'),
	(32958,'15','061',' 05','061058',61058,'Pietramelara','Pietramelara','','CE',1,'1840-01-01','2999-12-31'),
	(32959,'15','061',' 05','061059',61059,'Pietravairano','Pietravairano','','CE',1,'1840-01-01','2999-12-31'),
	(32960,'15','061',' 06','061060',61060,'Pignataro Maggiore','Pignataro Maggiore','','CE',1,'1840-01-01','2999-12-31'),
	(32961,'15','061',' 06','061061',61061,'Pontelatone','Pontelatone','','CE',1,'1840-01-01','2999-12-31'),
	(32962,'15','061',' 06','061062',61062,'Portico di Caserta','Portico di Caserta','','CE',1,'1840-01-01','2999-12-31'),
	(32963,'15','061',' 06','061063',61063,'Prata Sannita','Prata Sannita','','CE',1,'1840-01-01','2999-12-31'),
	(32964,'15','061',' 06','061064',61064,'Pratella','Pratella','','CE',1,'1840-01-01','2999-12-31'),
	(32965,'15','061',' 06','061065',61065,'Presenzano','Presenzano','','CE',1,'1840-01-01','2999-12-31'),
	(32966,'15','061',' 06','061066',61066,'Raviscanina','Raviscanina','','CE',1,'1840-01-01','2999-12-31'),
	(32967,'15','061',' 06','061067',61067,'Recale','Recale','','CE',1,'1840-01-01','2999-12-31'),
	(32968,'15','061',' 06','061068',61068,'Riardo','Riardo','','CE',1,'1840-01-01','2999-12-31'),
	(32969,'15','061',' 06','061069',61069,'Rocca d\'Evandro','Rocca d\'Evandro','','CE',1,'1840-01-01','2999-12-31'),
	(32970,'15','061',' 07','061070',61070,'Roccamonfina','Roccamonfina','','CE',1,'1840-01-01','2999-12-31'),
	(32971,'15','061',' 07','061071',61071,'Roccaromana','Roccaromana','','CE',1,'1840-01-01','2999-12-31'),
	(32972,'15','061',' 07','061072',61072,'Rocchetta e Croce','Rocchetta e Croce','','CE',1,'1840-01-01','2999-12-31'),
	(32973,'15','061',' 07','061073',61073,'Ruviano','Ruviano','','CE',1,'1840-01-01','2999-12-31'),
	(32974,'15','061',' 07','061074',61074,'San Cipriano d\'Aversa','San Cipriano d\'Aversa','','CE',1,'1840-01-01','2999-12-31'),
	(32975,'15','061',' 07','061075',61075,'San Felice a Cancello','San Felice a Cancello','','CE',1,'1840-01-01','2999-12-31'),
	(32976,'15','061',' 07','061076',61076,'San Gregorio Matese','San Gregorio Matese','','CE',1,'1840-01-01','2999-12-31'),
	(32977,'15','061',' 07','061077',61077,'San Marcellino','San Marcellino','','CE',1,'1840-01-01','2999-12-31'),
	(32978,'15','061',' 07','061078',61078,'San Nicola la Strada','San Nicola la Strada','','CE',1,'1840-01-01','2999-12-31'),
	(32979,'15','061',' 07','061079',61079,'San Pietro Infine','San Pietro Infine','','CE',1,'1840-01-01','2999-12-31'),
	(32980,'15','061',' 08','061080',61080,'San Potito Sannitico','San Potito Sannitico','','CE',1,'1840-01-01','2999-12-31'),
	(32981,'15','061',' 08','061081',61081,'San Prisco','San Prisco','','CE',1,'1840-01-01','2999-12-31'),
	(32982,'15','061',' 08','061082',61082,'Santa Maria a Vico','Santa Maria a Vico','','CE',1,'1840-01-01','2999-12-31'),
	(32983,'15','061',' 08','061083',61083,'Santa Maria Capua Vetere','Santa Maria Capua Vetere','','CE',1,'1840-01-01','2999-12-31'),
	(32984,'15','061',' 08','061084',61084,'Santa Maria la Fossa','Santa Maria la Fossa','','CE',1,'1840-01-01','2999-12-31'),
	(32985,'15','061',' 08','061085',61085,'San Tammaro','San Tammaro','','CE',1,'1840-01-01','2999-12-31'),
	(32986,'15','061',' 08','061086',61086,'Sant\'Angelo d\'Alife','Sant\'Angelo d\'Alife','','CE',1,'1840-01-01','2999-12-31'),
	(32987,'15','061',' 08','061087',61087,'Sant\'Arpino','Sant\'Arpino','','CE',1,'1840-01-01','2999-12-31'),
	(32988,'15','061',' 08','061088',61088,'Sessa Aurunca','Sessa Aurunca','','CE',1,'1840-01-01','2999-12-31'),
	(32989,'15','061',' 08','061089',61089,'Sparanise','Sparanise','','CE',1,'1840-01-01','2999-12-31'),
	(32990,'15','061',' 09','061090',61090,'Succivo','Succivo','','CE',1,'1840-01-01','2999-12-31'),
	(32991,'15','061',' 09','061091',61091,'Teano','Teano','','CE',1,'1840-01-01','2999-12-31'),
	(32992,'15','061',' 09','061092',61092,'Teverola','Teverola','','CE',1,'1840-01-01','2999-12-31'),
	(32993,'15','061',' 09','061093',61093,'Tora e Piccilli','Tora e Piccilli','','CE',1,'1840-01-01','2999-12-31'),
	(32994,'15','061',' 09','061094',61094,'Trentola-Ducenta','Trentola-Ducenta','','CE',1,'1840-01-01','2999-12-31'),
	(32995,'15','061',' 09','061095',61095,'Vairano Patenora','Vairano Patenora','','CE',1,'1840-01-01','2999-12-31'),
	(32996,'15','061',' 09','061096',61096,'Valle Agricola','Valle Agricola','','CE',1,'1840-01-01','2999-12-31'),
	(32997,'15','061',' 09','061097',61097,'Valle di Maddaloni','Valle di Maddaloni','','CE',1,'1840-01-01','2999-12-31'),
	(32998,'15','061',' 09','061098',61098,'Villa di Briano','Villa di Briano','','CE',1,'1840-01-01','2999-12-31'),
	(32999,'15','061',' 09','061099',61099,'Villa Literno','Villa Literno','','CE',1,'1840-01-01','2999-12-31'),
	(33000,'15','061',' 10','061100',61100,'Vitulazio','Vitulazio','','CE',1,'1840-01-01','2999-12-31'),
	(33001,'15','061',' 10','061101',61101,'Falciano del Massico','Falciano del Massico','','CE',1,'1840-01-01','2999-12-31'),
	(33002,'15','061',' 10','061102',61102,'Cellole','Cellole','','CE',1,'1840-01-01','2999-12-31'),
	(33003,'15','061',' 10','061103',61103,'Casapesenna','Casapesenna','','CE',1,'1840-01-01','2999-12-31'),
	(33004,'15','061',' 10','061104',61104,'San Marco Evangelista','San Marco Evangelista','','CE',1,'1840-01-01','2999-12-31'),
	(33005,'15','062',' 00','062001',62001,'Airola','Airola','','BN',1,'1840-01-01','2999-12-31'),
	(33006,'15','062',' 00','062002',62002,'Amorosi','Amorosi','','BN',1,'1840-01-01','2999-12-31'),
	(33007,'15','062',' 00','062003',62003,'Apice','Apice','','BN',1,'1840-01-01','2999-12-31'),
	(33008,'15','062',' 00','062004',62004,'Apollosa','Apollosa','','BN',1,'1840-01-01','2999-12-31'),
	(33009,'15','062',' 00','062005',62005,'Arpaia','Arpaia','','BN',1,'1840-01-01','2999-12-31'),
	(33010,'15','062',' 00','062006',62006,'Arpaise','Arpaise','','BN',1,'1840-01-01','2999-12-31'),
	(33011,'15','062',' 00','062007',62007,'Baselice','Baselice','','BN',1,'1840-01-01','2999-12-31'),
	(33012,'15','062',' 00','062008',62008,'Benevento','Benevento','','BN',1,'1840-01-01','2999-12-31'),
	(33013,'15','062',' 00','062009',62009,'Bonea','Bonea','','BN',1,'1840-01-01','2999-12-31'),
	(33014,'15','062',' 01','062010',62010,'Bucciano','Bucciano','','BN',1,'1840-01-01','2999-12-31'),
	(33015,'15','062',' 01','062011',62011,'Buonalbergo','Buonalbergo','','BN',1,'1840-01-01','2999-12-31'),
	(33016,'15','062',' 01','062012',62012,'Calvi','Calvi','','BN',1,'1840-01-01','2999-12-31'),
	(33017,'15','062',' 01','062013',62013,'Campolattaro','Campolattaro','','BN',1,'1840-01-01','2999-12-31'),
	(33018,'15','062',' 01','062014',62014,'Campoli del Monte Taburno','Campoli del Monte Taburno','','BN',1,'1840-01-01','2999-12-31'),
	(33019,'15','062',' 01','062015',62015,'Casalduni','Casalduni','','BN',1,'1840-01-01','2999-12-31'),
	(33020,'15','062',' 01','062016',62016,'Castelfranco in Miscano','Castelfranco in Miscano','','BN',1,'1840-01-01','2999-12-31'),
	(33021,'15','062',' 01','062017',62017,'Castelpagano','Castelpagano','','BN',1,'1840-01-01','2999-12-31'),
	(33022,'15','062',' 01','062018',62018,'Castelpoto','Castelpoto','','BN',1,'1840-01-01','2999-12-31'),
	(33023,'15','062',' 01','062019',62019,'Castelvenere','Castelvenere','','BN',1,'1840-01-01','2999-12-31'),
	(33024,'15','062',' 02','062020',62020,'Castelvetere in Val Fortore','Castelvetere in Val Fortore','','BN',1,'1840-01-01','2999-12-31'),
	(33025,'15','062',' 02','062021',62021,'Cautano','Cautano','','BN',1,'1840-01-01','2999-12-31'),
	(33026,'15','062',' 02','062022',62022,'Ceppaloni','Ceppaloni','','BN',1,'1840-01-01','2999-12-31'),
	(33027,'15','062',' 02','062023',62023,'Cerreto Sannita','Cerreto Sannita','','BN',1,'1840-01-01','2999-12-31'),
	(33028,'15','062',' 02','062024',62024,'Circello','Circello','','BN',1,'1840-01-01','2999-12-31'),
	(33029,'15','062',' 02','062025',62025,'Colle Sannita','Colle Sannita','','BN',1,'1840-01-01','2999-12-31'),
	(33030,'15','062',' 02','062026',62026,'Cusano Mutri','Cusano Mutri','','BN',1,'1840-01-01','2999-12-31'),
	(33031,'15','062',' 02','062027',62027,'Dugenta','Dugenta','','BN',1,'1840-01-01','2999-12-31'),
	(33032,'15','062',' 02','062028',62028,'Durazzano','Durazzano','','BN',1,'1840-01-01','2999-12-31'),
	(33033,'15','062',' 02','062029',62029,'Faicchio','Faicchio','','BN',1,'1840-01-01','2999-12-31'),
	(33034,'15','062',' 03','062030',62030,'Foglianise','Foglianise','','BN',1,'1840-01-01','2999-12-31'),
	(33035,'15','062',' 03','062031',62031,'Foiano di Val Fortore','Foiano di Val Fortore','','BN',1,'1840-01-01','2999-12-31'),
	(33036,'15','062',' 03','062032',62032,'Forchia','Forchia','','BN',1,'1840-01-01','2999-12-31'),
	(33037,'15','062',' 03','062033',62033,'Fragneto l\'Abate','Fragneto l\'Abate','','BN',1,'1840-01-01','2999-12-31'),
	(33038,'15','062',' 03','062034',62034,'Fragneto Monforte','Fragneto Monforte','','BN',1,'1840-01-01','2999-12-31'),
	(33039,'15','062',' 03','062035',62035,'Frasso Telesino','Frasso Telesino','','BN',1,'1840-01-01','2999-12-31'),
	(33040,'15','062',' 03','062036',62036,'Ginestra degli Schiavoni','Ginestra degli Schiavoni','','BN',1,'1840-01-01','2999-12-31'),
	(33041,'15','062',' 03','062037',62037,'Guardia Sanframondi','Guardia Sanframondi','','BN',1,'1840-01-01','2999-12-31'),
	(33042,'15','062',' 03','062038',62038,'Limatola','Limatola','','BN',1,'1840-01-01','2999-12-31'),
	(33043,'15','062',' 03','062039',62039,'Melizzano','Melizzano','','BN',1,'1840-01-01','2999-12-31'),
	(33044,'15','062',' 04','062040',62040,'Moiano','Moiano','','BN',1,'1840-01-01','2999-12-31'),
	(33045,'15','062',' 04','062041',62041,'Molinara','Molinara','','BN',1,'1840-01-01','2999-12-31'),
	(33046,'15','062',' 04','062042',62042,'Montefalcone di Val Fortore','Montefalcone di Val Fortore','','BN',1,'1840-01-01','2999-12-31'),
	(33047,'15','062',' 04','062043',62043,'Montesarchio','Montesarchio','','BN',1,'1840-01-01','2999-12-31'),
	(33048,'15','062',' 04','062044',62044,'Morcone','Morcone','','BN',1,'1840-01-01','2999-12-31'),
	(33049,'15','062',' 04','062045',62045,'Paduli','Paduli','','BN',1,'1840-01-01','2999-12-31'),
	(33050,'15','062',' 04','062046',62046,'Pago Veiano','Pago Veiano','','BN',1,'1840-01-01','2999-12-31'),
	(33051,'15','062',' 04','062047',62047,'Pannarano','Pannarano','','BN',1,'1840-01-01','2999-12-31'),
	(33052,'15','062',' 04','062048',62048,'Paolisi','Paolisi','','BN',1,'1840-01-01','2999-12-31'),
	(33053,'15','062',' 04','062049',62049,'Paupisi','Paupisi','','BN',1,'1840-01-01','2999-12-31'),
	(33054,'15','062',' 05','062050',62050,'Pesco Sannita','Pesco Sannita','','BN',1,'1840-01-01','2999-12-31'),
	(33055,'15','062',' 05','062051',62051,'Pietraroja','Pietraroja','','BN',1,'1840-01-01','2999-12-31'),
	(33056,'15','062',' 05','062052',62052,'Pietrelcina','Pietrelcina','','BN',1,'1840-01-01','2999-12-31'),
	(33057,'15','062',' 05','062053',62053,'Ponte','Ponte','','BN',1,'1840-01-01','2999-12-31'),
	(33058,'15','062',' 05','062054',62054,'Pontelandolfo','Pontelandolfo','','BN',1,'1840-01-01','2999-12-31'),
	(33059,'15','062',' 05','062055',62055,'Puglianello','Puglianello','','BN',1,'1840-01-01','2999-12-31'),
	(33060,'15','062',' 05','062056',62056,'Reino','Reino','','BN',1,'1840-01-01','2999-12-31'),
	(33061,'15','062',' 05','062057',62057,'San Bartolomeo in Galdo','San Bartolomeo in Galdo','','BN',1,'1840-01-01','2999-12-31'),
	(33062,'15','062',' 05','062058',62058,'San Giorgio del Sannio','San Giorgio del Sannio','','BN',1,'1840-01-01','2999-12-31'),
	(33063,'15','062',' 05','062059',62059,'San Giorgio La Molara','San Giorgio La Molara','','BN',1,'1840-01-01','2999-12-31'),
	(33064,'15','062',' 06','062060',62060,'San Leucio del Sannio','San Leucio del Sannio','','BN',1,'1840-01-01','2999-12-31'),
	(33065,'15','062',' 06','062061',62061,'San Lorenzello','San Lorenzello','','BN',1,'1840-01-01','2999-12-31'),
	(33066,'15','062',' 06','062062',62062,'San Lorenzo Maggiore','San Lorenzo Maggiore','','BN',1,'1840-01-01','2999-12-31'),
	(33067,'15','062',' 06','062063',62063,'San Lupo','San Lupo','','BN',1,'1840-01-01','2999-12-31'),
	(33068,'15','062',' 06','062064',62064,'San Marco dei Cavoti','San Marco dei Cavoti','','BN',1,'1840-01-01','2999-12-31'),
	(33069,'15','062',' 06','062065',62065,'San Martino Sannita','San Martino Sannita','','BN',1,'1840-01-01','2999-12-31'),
	(33070,'15','062',' 06','062066',62066,'San Nazzaro','San Nazzaro','','BN',1,'1840-01-01','2999-12-31'),
	(33071,'15','062',' 06','062067',62067,'San Nicola Manfredi','San Nicola Manfredi','','BN',1,'1840-01-01','2999-12-31'),
	(33072,'15','062',' 06','062068',62068,'San Salvatore Telesino','San Salvatore Telesino','','BN',1,'1840-01-01','2999-12-31'),
	(33073,'15','062',' 06','062069',62069,'Santa Croce del Sannio','Santa Croce del Sannio','','BN',1,'1840-01-01','2999-12-31'),
	(33074,'15','062',' 07','062070',62070,'Sant\'Agata de\' Goti','Sant\'Agata de\' Goti','','BN',1,'1840-01-01','2999-12-31'),
	(33075,'15','062',' 07','062071',62071,'Sant\'Angelo a Cupolo','Sant\'Angelo a Cupolo','','BN',1,'1840-01-01','2999-12-31'),
	(33076,'15','062',' 07','062072',62072,'Sassinoro','Sassinoro','','BN',1,'1840-01-01','2999-12-31'),
	(33077,'15','062',' 07','062073',62073,'Solopaca','Solopaca','','BN',1,'1840-01-01','2999-12-31'),
	(33078,'15','062',' 07','062074',62074,'Telese Terme','Telese Terme','','BN',1,'1840-01-01','2999-12-31'),
	(33079,'15','062',' 07','062075',62075,'Tocco Caudio','Tocco Caudio','','BN',1,'1840-01-01','2999-12-31'),
	(33080,'15','062',' 07','062076',62076,'Torrecuso','Torrecuso','','BN',1,'1840-01-01','2999-12-31'),
	(33081,'15','062',' 07','062077',62077,'Vitulano','Vitulano','','BN',1,'1840-01-01','2999-12-31'),
	(33082,'15','062',' 07','062078',62078,'Sant\'Arcangelo Trimonte','Sant\'Arcangelo Trimonte','','BN',1,'1840-01-01','2999-12-31'),
	(33083,'15','063',' 00','063001',63001,'Acerra','Acerra','','NA',1,'1840-01-01','2999-12-31'),
	(33084,'15','063',' 00','063002',63002,'Afragola','Afragola','','NA',1,'1840-01-01','2999-12-31'),
	(33085,'15','063',' 00','063003',63003,'Agerola','Agerola','','NA',1,'1840-01-01','2999-12-31'),
	(33086,'15','063',' 00','063004',63004,'Anacapri','Anacapri','','NA',1,'1840-01-01','2999-12-31'),
	(33087,'15','063',' 00','063005',63005,'Arzano','Arzano','','NA',1,'1840-01-01','2999-12-31'),
	(33088,'15','063',' 00','063006',63006,'Bacoli','Bacoli','','NA',1,'1840-01-01','2999-12-31'),
	(33089,'15','063',' 00','063007',63007,'Barano d\'Ischia','Barano d\'Ischia','','NA',1,'1840-01-01','2999-12-31'),
	(33090,'15','063',' 00','063008',63008,'Boscoreale','Boscoreale','','NA',1,'1840-01-01','2999-12-31'),
	(33091,'15','063',' 00','063009',63009,'Boscotrecase','Boscotrecase','','NA',1,'1840-01-01','2999-12-31'),
	(33092,'15','063',' 01','063010',63010,'Brusciano','Brusciano','','NA',1,'1840-01-01','2999-12-31'),
	(33093,'15','063',' 01','063011',63011,'Caivano','Caivano','','NA',1,'1840-01-01','2999-12-31'),
	(33094,'15','063',' 01','063012',63012,'Calvizzano','Calvizzano','','NA',1,'1840-01-01','2999-12-31'),
	(33095,'15','063',' 01','063013',63013,'Camposano','Camposano','','NA',1,'1840-01-01','2999-12-31'),
	(33096,'15','063',' 01','063014',63014,'Capri','Capri','','NA',1,'1840-01-01','2999-12-31'),
	(33097,'15','063',' 01','063015',63015,'Carbonara di Nola','Carbonara di Nola','','NA',1,'1840-01-01','2999-12-31'),
	(33098,'15','063',' 01','063016',63016,'Cardito','Cardito','','NA',1,'1840-01-01','2999-12-31'),
	(33099,'15','063',' 01','063017',63017,'Casalnuovo di Napoli','Casalnuovo di Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33100,'15','063',' 01','063018',63018,'Casamarciano','Casamarciano','','NA',1,'1840-01-01','2999-12-31'),
	(33101,'15','063',' 01','063019',63019,'Casamicciola Terme','Casamicciola Terme','','NA',1,'1840-01-01','2999-12-31'),
	(33102,'15','063',' 02','063020',63020,'Casandrino','Casandrino','','NA',1,'1840-01-01','2999-12-31'),
	(33103,'15','063',' 02','063021',63021,'Casavatore','Casavatore','','NA',1,'1840-01-01','2999-12-31'),
	(33104,'15','063',' 02','063022',63022,'Casola di Napoli','Casola di Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33105,'15','063',' 02','063023',63023,'Casoria','Casoria','','NA',1,'1840-01-01','2999-12-31'),
	(33106,'15','063',' 02','063024',63024,'Castellammare di Stabia','Castellammare di Stabia','','NA',1,'1840-01-01','2999-12-31'),
	(33107,'15','063',' 02','063025',63025,'Castello di Cisterna','Castello di Cisterna','','NA',1,'1840-01-01','2999-12-31'),
	(33108,'15','063',' 02','063026',63026,'Cercola','Cercola','','NA',1,'1840-01-01','2999-12-31'),
	(33109,'15','063',' 02','063027',63027,'Cicciano','Cicciano','','NA',1,'1840-01-01','2999-12-31'),
	(33110,'15','063',' 02','063028',63028,'Cimitile','Cimitile','','NA',1,'1840-01-01','2999-12-31'),
	(33111,'15','063',' 02','063029',63029,'Comiziano','Comiziano','','NA',1,'1840-01-01','2999-12-31'),
	(33112,'15','063',' 03','063030',63030,'Crispano','Crispano','','NA',1,'1840-01-01','2999-12-31'),
	(33113,'15','063',' 03','063031',63031,'Forio','Forio','','NA',1,'1840-01-01','2999-12-31'),
	(33114,'15','063',' 03','063032',63032,'Frattamaggiore','Frattamaggiore','','NA',1,'1840-01-01','2999-12-31'),
	(33115,'15','063',' 03','063033',63033,'Frattaminore','Frattaminore','','NA',1,'1840-01-01','2999-12-31'),
	(33116,'15','063',' 03','063034',63034,'Giugliano in Campania','Giugliano in Campania','','NA',1,'1840-01-01','2999-12-31'),
	(33117,'15','063',' 03','063035',63035,'Gragnano','Gragnano','','NA',1,'1840-01-01','2999-12-31'),
	(33118,'15','063',' 03','063036',63036,'Grumo Nevano','Grumo Nevano','','NA',1,'1840-01-01','2999-12-31'),
	(33119,'15','063',' 03','063037',63037,'Ischia','Ischia','','NA',1,'1840-01-01','2999-12-31'),
	(33120,'15','063',' 03','063038',63038,'Lacco Ameno','Lacco Ameno','','NA',1,'1840-01-01','2999-12-31'),
	(33121,'15','063',' 03','063039',63039,'Lettere','Lettere','','NA',1,'1840-01-01','2999-12-31'),
	(33122,'15','063',' 04','063040',63040,'Liveri','Liveri','','NA',1,'1840-01-01','2999-12-31'),
	(33123,'15','063',' 04','063041',63041,'Marano di Napoli','Marano di Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33124,'15','063',' 04','063042',63042,'Mariglianella','Mariglianella','','NA',1,'1840-01-01','2999-12-31'),
	(33125,'15','063',' 04','063043',63043,'Marigliano','Marigliano','','NA',1,'1840-01-01','2999-12-31'),
	(33126,'15','063',' 04','063044',63044,'Massa Lubrense','Massa Lubrense','','NA',1,'1840-01-01','2999-12-31'),
	(33127,'15','063',' 04','063045',63045,'Melito di Napoli','Melito di Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33128,'15','063',' 04','063046',63046,'Meta','Meta','','NA',1,'1840-01-01','2999-12-31'),
	(33129,'15','063',' 04','063047',63047,'Monte di Procida','Monte di Procida','','NA',1,'1840-01-01','2999-12-31'),
	(33130,'15','063',' 04','063048',63048,'Mugnano di Napoli','Mugnano di Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33131,'15','063',' 04','063049',63049,'Napoli','Napoli','','NA',1,'1840-01-01','2999-12-31'),
	(33132,'15','063',' 05','063050',63050,'Nola','Nola','','NA',1,'1840-01-01','2999-12-31'),
	(33133,'15','063',' 05','063051',63051,'Ottaviano','Ottaviano','','NA',1,'1840-01-01','2999-12-31'),
	(33134,'15','063',' 05','063052',63052,'Palma Campania','Palma Campania','','NA',1,'1840-01-01','2999-12-31'),
	(33135,'15','063',' 05','063053',63053,'Piano di Sorrento','Piano di Sorrento','','NA',1,'1840-01-01','2999-12-31'),
	(33136,'15','063',' 05','063054',63054,'Pimonte','Pimonte','','NA',1,'1840-01-01','2999-12-31'),
	(33137,'15','063',' 05','063055',63055,'Poggiomarino','Poggiomarino','','NA',1,'1840-01-01','2999-12-31'),
	(33138,'15','063',' 05','063056',63056,'Pollena Trocchia','Pollena Trocchia','','NA',1,'1840-01-01','2999-12-31'),
	(33139,'15','063',' 05','063057',63057,'Pomigliano d\'Arco','Pomigliano d\'Arco','','NA',1,'1840-01-01','2999-12-31'),
	(33140,'15','063',' 05','063058',63058,'Pompei','Pompei','','NA',1,'1840-01-01','2999-12-31'),
	(33141,'15','063',' 05','063059',63059,'Portici','Portici','','NA',1,'1840-01-01','2999-12-31'),
	(33142,'15','063',' 06','063060',63060,'Pozzuoli','Pozzuoli','','NA',1,'1840-01-01','2999-12-31'),
	(33143,'15','063',' 06','063061',63061,'Procida','Procida','','NA',1,'1840-01-01','2999-12-31'),
	(33144,'15','063',' 06','063062',63062,'Qualiano','Qualiano','','NA',1,'1840-01-01','2999-12-31'),
	(33145,'15','063',' 06','063063',63063,'Quarto','Quarto','','NA',1,'1840-01-01','2999-12-31'),
	(33146,'15','063',' 06','063064',63064,'Ercolano','Ercolano','','NA',1,'1840-01-01','2999-12-31'),
	(33147,'15','063',' 06','063065',63065,'Roccarainola','Roccarainola','','NA',1,'1840-01-01','2999-12-31'),
	(33148,'15','063',' 06','063066',63066,'San Gennaro Vesuviano','San Gennaro Vesuviano','','NA',1,'1840-01-01','2999-12-31'),
	(33149,'15','063',' 06','063067',63067,'San Giorgio a Cremano','San Giorgio a Cremano','','NA',1,'1840-01-01','2999-12-31'),
	(33150,'15','063',' 06','063068',63068,'San Giuseppe Vesuviano','San Giuseppe Vesuviano','','NA',1,'1840-01-01','2999-12-31'),
	(33151,'15','063',' 06','063069',63069,'San Paolo Bel Sito','San Paolo Bel Sito','','NA',1,'1840-01-01','2999-12-31'),
	(33152,'15','063',' 07','063070',63070,'San Sebastiano al Vesuvio','San Sebastiano al Vesuvio','','NA',1,'1840-01-01','2999-12-31'),
	(33153,'15','063',' 07','063071',63071,'Sant\'Agnello','Sant\'Agnello','','NA',1,'1840-01-01','2999-12-31'),
	(33154,'15','063',' 07','063072',63072,'Sant\'Anastasia','Sant\'Anastasia','','NA',1,'1840-01-01','2999-12-31'),
	(33155,'15','063',' 07','063073',63073,'Sant\'Antimo','Sant\'Antimo','','NA',1,'1840-01-01','2999-12-31'),
	(33156,'15','063',' 07','063074',63074,'Sant\'Antonio Abate','Sant\'Antonio Abate','','NA',1,'1840-01-01','2999-12-31'),
	(33157,'15','063',' 07','063075',63075,'San Vitaliano','San Vitaliano','','NA',1,'1840-01-01','2999-12-31'),
	(33158,'15','063',' 07','063076',63076,'Saviano','Saviano','','NA',1,'1840-01-01','2999-12-31'),
	(33159,'15','063',' 07','063077',63077,'Scisciano','Scisciano','','NA',1,'1840-01-01','2999-12-31'),
	(33160,'15','063',' 07','063078',63078,'Serrara Fontana','Serrara Fontana','','NA',1,'1840-01-01','2999-12-31'),
	(33161,'15','063',' 07','063079',63079,'Somma Vesuviana','Somma Vesuviana','','NA',1,'1840-01-01','2999-12-31'),
	(33162,'15','063',' 08','063080',63080,'Sorrento','Sorrento','','NA',1,'1840-01-01','2999-12-31'),
	(33163,'15','063',' 08','063081',63081,'Striano','Striano','','NA',1,'1840-01-01','2999-12-31'),
	(33164,'15','063',' 08','063082',63082,'Terzigno','Terzigno','','NA',1,'1840-01-01','2999-12-31'),
	(33165,'15','063',' 08','063083',63083,'Torre Annunziata','Torre Annunziata','','NA',1,'1840-01-01','2999-12-31'),
	(33166,'15','063',' 08','063084',63084,'Torre del Greco','Torre del Greco','','NA',1,'1840-01-01','2999-12-31'),
	(33167,'15','063',' 08','063085',63085,'Tufino','Tufino','','NA',1,'1840-01-01','2999-12-31'),
	(33168,'15','063',' 08','063086',63086,'Vico Equense','Vico Equense','','NA',1,'1840-01-01','2999-12-31'),
	(33169,'15','063',' 08','063087',63087,'Villaricca','Villaricca','','NA',1,'1840-01-01','2999-12-31'),
	(33170,'15','063',' 08','063088',63088,'Visciano','Visciano','','NA',1,'1840-01-01','2999-12-31'),
	(33171,'15','063',' 08','063089',63089,'Volla','Volla','','NA',1,'1840-01-01','2999-12-31'),
	(33172,'15','063',' 09','063090',63090,'Santa Maria la Carità','Santa Maria la Carità','','NA',1,'1840-01-01','2999-12-31'),
	(33173,'15','063',' 09','063091',63091,'Trecase','Trecase','','NA',1,'1840-01-01','2999-12-31'),
	(33174,'15','063',' 09','063092',63092,'Massa di Somma','Massa di Somma','','NA',1,'1840-01-01','2999-12-31'),
	(33175,'15','064',' 00','064001',64001,'Aiello del Sabato','Aiello del Sabato','','AV',1,'1840-01-01','2999-12-31'),
	(33176,'15','064',' 00','064002',64002,'Altavilla Irpina','Altavilla Irpina','','AV',1,'1840-01-01','2999-12-31'),
	(33177,'15','064',' 00','064003',64003,'Andretta','Andretta','','AV',1,'1840-01-01','2999-12-31'),
	(33178,'15','064',' 00','064004',64004,'Aquilonia','Aquilonia','','AV',1,'1840-01-01','2999-12-31'),
	(33179,'15','064',' 00','064005',64005,'Ariano Irpino','Ariano Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33180,'15','064',' 00','064006',64006,'Atripalda','Atripalda','','AV',1,'1840-01-01','2999-12-31'),
	(33181,'15','064',' 00','064007',64007,'Avella','Avella','','AV',1,'1840-01-01','2999-12-31'),
	(33182,'15','064',' 00','064008',64008,'Avellino','Avellino','','AV',1,'1840-01-01','2999-12-31'),
	(33183,'15','064',' 00','064009',64009,'Bagnoli Irpino','Bagnoli Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33184,'15','064',' 01','064010',64010,'Baiano','Baiano','','AV',1,'1840-01-01','2999-12-31'),
	(33185,'15','064',' 01','064011',64011,'Bisaccia','Bisaccia','','AV',1,'1840-01-01','2999-12-31'),
	(33186,'15','064',' 01','064012',64012,'Bonito','Bonito','','AV',1,'1840-01-01','2999-12-31'),
	(33187,'15','064',' 01','064013',64013,'Cairano','Cairano','','AV',1,'1840-01-01','2999-12-31'),
	(33188,'15','064',' 01','064014',64014,'Calabritto','Calabritto','','AV',1,'1840-01-01','2999-12-31'),
	(33189,'15','064',' 01','064015',64015,'Calitri','Calitri','','AV',1,'1840-01-01','2999-12-31'),
	(33190,'15','064',' 01','064016',64016,'Candida','Candida','','AV',1,'1840-01-01','2999-12-31'),
	(33191,'15','064',' 01','064017',64017,'Caposele','Caposele','','AV',1,'1840-01-01','2999-12-31'),
	(33192,'15','064',' 01','064018',64018,'Capriglia Irpina','Capriglia Irpina','','AV',1,'1840-01-01','2999-12-31'),
	(33193,'15','064',' 01','064019',64019,'Carife','Carife','','AV',1,'1840-01-01','2999-12-31'),
	(33194,'15','064',' 02','064020',64020,'Casalbore','Casalbore','','AV',1,'1840-01-01','2999-12-31'),
	(33195,'15','064',' 02','064021',64021,'Cassano Irpino','Cassano Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33196,'15','064',' 02','064022',64022,'Castel Baronia','Castel Baronia','','AV',1,'1840-01-01','2999-12-31'),
	(33197,'15','064',' 02','064023',64023,'Castelfranci','Castelfranci','','AV',1,'1840-01-01','2999-12-31'),
	(33198,'15','064',' 02','064024',64024,'Castelvetere sul Calore','Castelvetere sul Calore','','AV',1,'1840-01-01','2999-12-31'),
	(33199,'15','064',' 02','064025',64025,'Cervinara','Cervinara','','AV',1,'1840-01-01','2999-12-31'),
	(33200,'15','064',' 02','064026',64026,'Cesinali','Cesinali','','AV',1,'1840-01-01','2999-12-31'),
	(33201,'15','064',' 02','064027',64027,'Chianche','Chianche','','AV',1,'1840-01-01','2999-12-31'),
	(33202,'15','064',' 02','064028',64028,'Chiusano di San Domenico','Chiusano di San Domenico','','AV',1,'1840-01-01','2999-12-31'),
	(33203,'15','064',' 02','064029',64029,'Contrada','Contrada','','AV',1,'1840-01-01','2999-12-31'),
	(33204,'15','064',' 03','064030',64030,'Conza della Campania','Conza della Campania','','AV',1,'1840-01-01','2999-12-31'),
	(33205,'15','064',' 03','064031',64031,'Domicella','Domicella','','AV',1,'1840-01-01','2999-12-31'),
	(33206,'15','064',' 03','064032',64032,'Flumeri','Flumeri','','AV',1,'1840-01-01','2999-12-31'),
	(33207,'15','064',' 03','064033',64033,'Fontanarosa','Fontanarosa','','AV',1,'1840-01-01','2999-12-31'),
	(33208,'15','064',' 03','064034',64034,'Forino','Forino','','AV',1,'1840-01-01','2999-12-31'),
	(33209,'15','064',' 03','064035',64035,'Frigento','Frigento','','AV',1,'1840-01-01','2999-12-31'),
	(33210,'15','064',' 03','064036',64036,'Gesualdo','Gesualdo','','AV',1,'1840-01-01','2999-12-31'),
	(33211,'15','064',' 03','064037',64037,'Greci','Greci','','AV',1,'1840-01-01','2999-12-31'),
	(33212,'15','064',' 03','064038',64038,'Grottaminarda','Grottaminarda','','AV',1,'1840-01-01','2999-12-31'),
	(33213,'15','064',' 03','064039',64039,'Grottolella','Grottolella','','AV',1,'1840-01-01','2999-12-31'),
	(33214,'15','064',' 04','064040',64040,'Guardia Lombardi','Guardia Lombardi','','AV',1,'1840-01-01','2999-12-31'),
	(33215,'15','064',' 04','064041',64041,'Lacedonia','Lacedonia','','AV',1,'1840-01-01','2999-12-31'),
	(33216,'15','064',' 04','064042',64042,'Lapio','Lapio','','AV',1,'1840-01-01','2999-12-31'),
	(33217,'15','064',' 04','064043',64043,'Lauro','Lauro','','AV',1,'1840-01-01','2999-12-31'),
	(33218,'15','064',' 04','064044',64044,'Lioni','Lioni','','AV',1,'1840-01-01','2999-12-31'),
	(33219,'15','064',' 04','064045',64045,'Luogosano','Luogosano','','AV',1,'1840-01-01','2999-12-31'),
	(33220,'15','064',' 04','064046',64046,'Manocalzati','Manocalzati','','AV',1,'1840-01-01','2999-12-31'),
	(33221,'15','064',' 04','064047',64047,'Marzano di Nola','Marzano di Nola','','AV',1,'1840-01-01','2999-12-31'),
	(33222,'15','064',' 04','064048',64048,'Melito Irpino','Melito Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33223,'15','064',' 04','064049',64049,'Mercogliano','Mercogliano','','AV',1,'1840-01-01','2999-12-31'),
	(33224,'15','064',' 05','064050',64050,'Mirabella Eclano','Mirabella Eclano','','AV',1,'1840-01-01','2999-12-31'),
	(33225,'15','064',' 05','064051',64051,'Montaguto','Montaguto','','AV',1,'1840-01-01','2999-12-31'),
	(33226,'15','064',' 05','064052',64052,'Montecalvo Irpino','Montecalvo Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33227,'15','064',' 05','064053',64053,'Montefalcione','Montefalcione','','AV',1,'1840-01-01','2999-12-31'),
	(33228,'15','064',' 05','064054',64054,'Monteforte Irpino','Monteforte Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33229,'15','064',' 05','064055',64055,'Montefredane','Montefredane','','AV',1,'1840-01-01','2999-12-31'),
	(33230,'15','064',' 05','064056',64056,'Montefusco','Montefusco','','AV',1,'1840-01-01','2999-12-31'),
	(33231,'15','064',' 05','064057',64057,'Montella','Montella','','AV',1,'1840-01-01','2999-12-31'),
	(33232,'15','064',' 05','064058',64058,'Montemarano','Montemarano','','AV',1,'1840-01-01','2999-12-31'),
	(33233,'15','064',' 05','064059',64059,'Montemiletto','Montemiletto','','AV',1,'1840-01-01','2999-12-31'),
	(33234,'15','064',' 06','064060',64060,'Monteverde','Monteverde','','AV',1,'1840-01-01','2999-12-31'),
	(33235,'15','064',' 06','064061',64061,'Montoro Inferiore','Montoro Inferiore','','AV',1,'1840-01-01','2999-12-31'),
	(33236,'15','064',' 06','064062',64062,'Montoro Superiore','Montoro Superiore','','AV',1,'1840-01-01','2999-12-31'),
	(33237,'15','064',' 06','064063',64063,'Morra De Sanctis','Morra De Sanctis','','AV',1,'1840-01-01','2999-12-31'),
	(33238,'15','064',' 06','064064',64064,'Moschiano','Moschiano','','AV',1,'1840-01-01','2999-12-31'),
	(33239,'15','064',' 06','064065',64065,'Mugnano del Cardinale','Mugnano del Cardinale','','AV',1,'1840-01-01','2999-12-31'),
	(33240,'15','064',' 06','064066',64066,'Nusco','Nusco','','AV',1,'1840-01-01','2999-12-31'),
	(33241,'15','064',' 06','064067',64067,'Ospedaletto d\'Alpinolo','Ospedaletto d\'Alpinolo','','AV',1,'1840-01-01','2999-12-31'),
	(33242,'15','064',' 06','064068',64068,'Pago del Vallo di Lauro','Pago del Vallo di Lauro','','AV',1,'1840-01-01','2999-12-31'),
	(33243,'15','064',' 06','064069',64069,'Parolise','Parolise','','AV',1,'1840-01-01','2999-12-31'),
	(33244,'15','064',' 07','064070',64070,'Paternopoli','Paternopoli','','AV',1,'1840-01-01','2999-12-31'),
	(33245,'15','064',' 07','064071',64071,'Petruro Irpino','Petruro Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33246,'15','064',' 07','064072',64072,'Pietradefusi','Pietradefusi','','AV',1,'1840-01-01','2999-12-31'),
	(33247,'15','064',' 07','064073',64073,'Pietrastornina','Pietrastornina','','AV',1,'1840-01-01','2999-12-31'),
	(33248,'15','064',' 07','064074',64074,'Prata di Principato Ultra','Prata di Principato Ultra','','AV',1,'1840-01-01','2999-12-31'),
	(33249,'15','064',' 07','064075',64075,'Pratola Serra','Pratola Serra','','AV',1,'1840-01-01','2999-12-31'),
	(33250,'15','064',' 07','064076',64076,'Quadrelle','Quadrelle','','AV',1,'1840-01-01','2999-12-31'),
	(33251,'15','064',' 07','064077',64077,'Quindici','Quindici','','AV',1,'1840-01-01','2999-12-31'),
	(33252,'15','064',' 07','064078',64078,'Roccabascerana','Roccabascerana','','AV',1,'1840-01-01','2999-12-31'),
	(33253,'15','064',' 07','064079',64079,'Rocca San Felice','Rocca San Felice','','AV',1,'1840-01-01','2999-12-31'),
	(33254,'15','064',' 08','064080',64080,'Rotondi','Rotondi','','AV',1,'1840-01-01','2999-12-31'),
	(33255,'15','064',' 08','064081',64081,'Salza Irpina','Salza Irpina','','AV',1,'1840-01-01','2999-12-31'),
	(33256,'15','064',' 08','064082',64082,'San Mango sul Calore','San Mango sul Calore','','AV',1,'1840-01-01','2999-12-31'),
	(33257,'15','064',' 08','064083',64083,'San Martino Valle Caudina','San Martino Valle Caudina','','AV',1,'1840-01-01','2999-12-31'),
	(33258,'15','064',' 08','064084',64084,'San Michele di Serino','San Michele di Serino','','AV',1,'1840-01-01','2999-12-31'),
	(33259,'15','064',' 08','064085',64085,'San Nicola Baronia','San Nicola Baronia','','AV',1,'1840-01-01','2999-12-31'),
	(33260,'15','064',' 08','064086',64086,'San Potito Ultra','San Potito Ultra','','AV',1,'1840-01-01','2999-12-31'),
	(33261,'15','064',' 08','064087',64087,'San Sossio Baronia','San Sossio Baronia','','AV',1,'1840-01-01','2999-12-31'),
	(33262,'15','064',' 08','064088',64088,'Santa Lucia di Serino','Santa Lucia di Serino','','AV',1,'1840-01-01','2999-12-31'),
	(33263,'15','064',' 08','064089',64089,'Sant\'Andrea di Conza','Sant\'Andrea di Conza','','AV',1,'1840-01-01','2999-12-31'),
	(33264,'15','064',' 09','064090',64090,'Sant\'Angelo all\'Esca','Sant\'Angelo all\'Esca','','AV',1,'1840-01-01','2999-12-31'),
	(33265,'15','064',' 09','064091',64091,'Sant\'Angelo a Scala','Sant\'Angelo a Scala','','AV',1,'1840-01-01','2999-12-31'),
	(33266,'15','064',' 09','064092',64092,'Sant\'Angelo dei Lombardi','Sant\'Angelo dei Lombardi','','AV',1,'1840-01-01','2999-12-31'),
	(33267,'15','064',' 09','064093',64093,'Santa Paolina','Santa Paolina','','AV',1,'1840-01-01','2999-12-31'),
	(33268,'15','064',' 09','064095',64095,'Santo Stefano del Sole','Santo Stefano del Sole','','AV',1,'1840-01-01','2999-12-31'),
	(33269,'15','064',' 09','064096',64096,'Savignano Irpino','Savignano Irpino','','AV',1,'1840-01-01','2999-12-31'),
	(33270,'15','064',' 09','064097',64097,'Scampitella','Scampitella','','AV',1,'1840-01-01','2999-12-31'),
	(33271,'15','064',' 09','064098',64098,'Senerchia','Senerchia','','AV',1,'1840-01-01','2999-12-31'),
	(33272,'15','064',' 09','064099',64099,'Serino','Serino','','AV',1,'1840-01-01','2999-12-31'),
	(33273,'15','064',' 10','064100',64100,'Sirignano','Sirignano','','AV',1,'1840-01-01','2999-12-31'),
	(33274,'15','064',' 10','064101',64101,'Solofra','Solofra','','AV',1,'1840-01-01','2999-12-31'),
	(33275,'15','064',' 10','064102',64102,'Sorbo Serpico','Sorbo Serpico','','AV',1,'1840-01-01','2999-12-31'),
	(33276,'15','064',' 10','064103',64103,'Sperone','Sperone','','AV',1,'1840-01-01','2999-12-31'),
	(33277,'15','064',' 10','064104',64104,'Sturno','Sturno','','AV',1,'1840-01-01','2999-12-31'),
	(33278,'15','064',' 10','064105',64105,'Summonte','Summonte','','AV',1,'1840-01-01','2999-12-31'),
	(33279,'15','064',' 10','064106',64106,'Taurano','Taurano','','AV',1,'1840-01-01','2999-12-31'),
	(33280,'15','064',' 10','064107',64107,'Taurasi','Taurasi','','AV',1,'1840-01-01','2999-12-31'),
	(33281,'15','064',' 10','064108',64108,'Teora','Teora','','AV',1,'1840-01-01','2999-12-31'),
	(33282,'15','064',' 10','064109',64109,'Torella dei Lombardi','Torella dei Lombardi','','AV',1,'1840-01-01','2999-12-31'),
	(33283,'15','064',' 11','064110',64110,'Torre Le Nocelle','Torre Le Nocelle','','AV',1,'1840-01-01','2999-12-31'),
	(33284,'15','064',' 11','064111',64111,'Torrioni','Torrioni','','AV',1,'1840-01-01','2999-12-31'),
	(33285,'15','064',' 11','064112',64112,'Trevico','Trevico','','AV',1,'1840-01-01','2999-12-31'),
	(33286,'15','064',' 11','064113',64113,'Tufo','Tufo','','AV',1,'1840-01-01','2999-12-31'),
	(33287,'15','064',' 11','064114',64114,'Vallata','Vallata','','AV',1,'1840-01-01','2999-12-31'),
	(33288,'15','064',' 11','064115',64115,'Vallesaccarda','Vallesaccarda','','AV',1,'1840-01-01','2999-12-31'),
	(33289,'15','064',' 11','064116',64116,'Venticano','Venticano','','AV',1,'1840-01-01','2999-12-31'),
	(33290,'15','064',' 11','064117',64117,'Villamaina','Villamaina','','AV',1,'1840-01-01','2999-12-31'),
	(33291,'15','064',' 11','064118',64118,'Villanova del Battista','Villanova del Battista','','AV',1,'1840-01-01','2999-12-31'),
	(33292,'15','064',' 11','064119',64119,'Volturara Irpina','Volturara Irpina','','AV',1,'1840-01-01','2999-12-31'),
	(33293,'15','064',' 12','064120',64120,'Zungoli','Zungoli','','AV',1,'1840-01-01','2999-12-31'),
	(33294,'15','065',' 00','065001',65001,'Acerno','Acerno','','SA',1,'1840-01-01','2999-12-31'),
	(33295,'15','065',' 00','065002',65002,'Agropoli','Agropoli','','SA',1,'1840-01-01','2999-12-31'),
	(33296,'15','065',' 00','065003',65003,'Albanella','Albanella','','SA',1,'1840-01-01','2999-12-31'),
	(33297,'15','065',' 00','065004',65004,'Alfano','Alfano','','SA',1,'1840-01-01','2999-12-31'),
	(33298,'15','065',' 00','065005',65005,'Altavilla Silentina','Altavilla Silentina','','SA',1,'1840-01-01','2999-12-31'),
	(33299,'15','065',' 00','065006',65006,'Amalfi','Amalfi','','SA',1,'1840-01-01','2999-12-31'),
	(33300,'15','065',' 00','065007',65007,'Angri','Angri','','SA',1,'1840-01-01','2999-12-31'),
	(33301,'15','065',' 00','065008',65008,'Aquara','Aquara','','SA',1,'1840-01-01','2999-12-31'),
	(33302,'15','065',' 00','065009',65009,'Ascea','Ascea','','SA',1,'1840-01-01','2999-12-31'),
	(33303,'15','065',' 01','065010',65010,'Atena Lucana','Atena Lucana','','SA',1,'1840-01-01','2999-12-31'),
	(33304,'15','065',' 01','065011',65011,'Atrani','Atrani','','SA',1,'1840-01-01','2999-12-31'),
	(33305,'15','065',' 01','065012',65012,'Auletta','Auletta','','SA',1,'1840-01-01','2999-12-31'),
	(33306,'15','065',' 01','065013',65013,'Baronissi','Baronissi','','SA',1,'1840-01-01','2999-12-31'),
	(33307,'15','065',' 01','065014',65014,'Battipaglia','Battipaglia','','SA',1,'1840-01-01','2999-12-31'),
	(33308,'15','065',' 01','065015',65015,'Bellosguardo','Bellosguardo','','SA',1,'1840-01-01','2999-12-31'),
	(33309,'15','065',' 01','065016',65016,'Bracigliano','Bracigliano','','SA',1,'1840-01-01','2999-12-31'),
	(33310,'15','065',' 01','065017',65017,'Buccino','Buccino','','SA',1,'1840-01-01','2999-12-31'),
	(33311,'15','065',' 01','065018',65018,'Buonabitacolo','Buonabitacolo','','SA',1,'1840-01-01','2999-12-31'),
	(33312,'15','065',' 01','065019',65019,'Caggiano','Caggiano','','SA',1,'1840-01-01','2999-12-31'),
	(33313,'15','065',' 02','065020',65020,'Calvanico','Calvanico','','SA',1,'1840-01-01','2999-12-31'),
	(33314,'15','065',' 02','065021',65021,'Camerota','Camerota','','SA',1,'1840-01-01','2999-12-31'),
	(33315,'15','065',' 02','065022',65022,'Campagna','Campagna','','SA',1,'1840-01-01','2999-12-31'),
	(33316,'15','065',' 02','065023',65023,'Campora','Campora','','SA',1,'1840-01-01','2999-12-31'),
	(33317,'15','065',' 02','065024',65024,'Cannalonga','Cannalonga','','SA',1,'1840-01-01','2999-12-31'),
	(33318,'15','065',' 02','065025',65025,'Capaccio','Capaccio','','SA',1,'1840-01-01','2999-12-31'),
	(33319,'15','065',' 02','065026',65026,'Casalbuono','Casalbuono','','SA',1,'1840-01-01','2999-12-31'),
	(33320,'15','065',' 02','065027',65027,'Casaletto Spartano','Casaletto Spartano','','SA',1,'1840-01-01','2999-12-31'),
	(33321,'15','065',' 02','065028',65028,'Casal Velino','Casal Velino','','SA',1,'1840-01-01','2999-12-31'),
	(33322,'15','065',' 02','065029',65029,'Caselle in Pittari','Caselle in Pittari','','SA',1,'1840-01-01','2999-12-31'),
	(33323,'15','065',' 03','065030',65030,'Castelcivita','Castelcivita','','SA',1,'1840-01-01','2999-12-31'),
	(33324,'15','065',' 03','065031',65031,'Castellabate','Castellabate','','SA',1,'1840-01-01','2999-12-31'),
	(33325,'15','065',' 03','065032',65032,'Castelnuovo Cilento','Castelnuovo Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33326,'15','065',' 03','065033',65033,'Castelnuovo di Conza','Castelnuovo di Conza','','SA',1,'1840-01-01','2999-12-31'),
	(33327,'15','065',' 03','065034',65034,'Castel San Giorgio','Castel San Giorgio','','SA',1,'1840-01-01','2999-12-31'),
	(33328,'15','065',' 03','065035',65035,'Castel San Lorenzo','Castel San Lorenzo','','SA',1,'1840-01-01','2999-12-31'),
	(33329,'15','065',' 03','065036',65036,'Castiglione del Genovesi','Castiglione del Genovesi','','SA',1,'1840-01-01','2999-12-31'),
	(33330,'15','065',' 03','065037',65037,'Cava de\' Tirreni','Cava de\' Tirreni','','SA',1,'1840-01-01','2999-12-31'),
	(33331,'15','065',' 03','065038',65038,'Celle di Bulgheria','Celle di Bulgheria','','SA',1,'1840-01-01','2999-12-31'),
	(33332,'15','065',' 03','065039',65039,'Centola','Centola','','SA',1,'1840-01-01','2999-12-31'),
	(33333,'15','065',' 04','065040',65040,'Ceraso','Ceraso','','SA',1,'1840-01-01','2999-12-31'),
	(33334,'15','065',' 04','065041',65041,'Cetara','Cetara','','SA',1,'1840-01-01','2999-12-31'),
	(33335,'15','065',' 04','065042',65042,'Cicerale','Cicerale','','SA',1,'1840-01-01','2999-12-31'),
	(33336,'15','065',' 04','065043',65043,'Colliano','Colliano','','SA',1,'1840-01-01','2999-12-31'),
	(33337,'15','065',' 04','065044',65044,'Conca dei Marini','Conca dei Marini','','SA',1,'1840-01-01','2999-12-31'),
	(33338,'15','065',' 04','065045',65045,'Controne','Controne','','SA',1,'1840-01-01','2999-12-31'),
	(33339,'15','065',' 04','065046',65046,'Contursi Terme','Contursi Terme','','SA',1,'1840-01-01','2999-12-31'),
	(33340,'15','065',' 04','065047',65047,'Corbara','Corbara','','SA',1,'1840-01-01','2999-12-31'),
	(33341,'15','065',' 04','065048',65048,'Corleto Monforte','Corleto Monforte','','SA',1,'1840-01-01','2999-12-31'),
	(33342,'15','065',' 04','065049',65049,'Cuccaro Vetere','Cuccaro Vetere','','SA',1,'1840-01-01','2999-12-31'),
	(33343,'15','065',' 05','065050',65050,'Eboli','Eboli','','SA',1,'1840-01-01','2999-12-31'),
	(33344,'15','065',' 05','065051',65051,'Felitto','Felitto','','SA',1,'1840-01-01','2999-12-31'),
	(33345,'15','065',' 05','065052',65052,'Fisciano','Fisciano','','SA',1,'1840-01-01','2999-12-31'),
	(33346,'15','065',' 05','065053',65053,'Furore','Furore','','SA',1,'1840-01-01','2999-12-31'),
	(33347,'15','065',' 05','065054',65054,'Futani','Futani','','SA',1,'1840-01-01','2999-12-31'),
	(33348,'15','065',' 05','065055',65055,'Giffoni Sei Casali','Giffoni Sei Casali','','SA',1,'1840-01-01','2999-12-31'),
	(33349,'15','065',' 05','065056',65056,'Giffoni Valle Piana','Giffoni Valle Piana','','SA',1,'1840-01-01','2999-12-31'),
	(33350,'15','065',' 05','065057',65057,'Gioi','Gioi','','SA',1,'1840-01-01','2999-12-31'),
	(33351,'15','065',' 05','065058',65058,'Giungano','Giungano','','SA',1,'1840-01-01','2999-12-31'),
	(33352,'15','065',' 05','065059',65059,'Ispani','Ispani','','SA',1,'1840-01-01','2999-12-31'),
	(33353,'15','065',' 06','065060',65060,'Laureana Cilento','Laureana Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33354,'15','065',' 06','065061',65061,'Laurino','Laurino','','SA',1,'1840-01-01','2999-12-31'),
	(33355,'15','065',' 06','065062',65062,'Laurito','Laurito','','SA',1,'1840-01-01','2999-12-31'),
	(33356,'15','065',' 06','065063',65063,'Laviano','Laviano','','SA',1,'1840-01-01','2999-12-31'),
	(33357,'15','065',' 06','065064',65064,'Lustra','Lustra','','SA',1,'1840-01-01','2999-12-31'),
	(33358,'15','065',' 06','065065',65065,'Magliano Vetere','Magliano Vetere','','SA',1,'1840-01-01','2999-12-31'),
	(33359,'15','065',' 06','065066',65066,'Maiori','Maiori','','SA',1,'1840-01-01','2999-12-31'),
	(33360,'15','065',' 06','065067',65067,'Mercato San Severino','Mercato San Severino','','SA',1,'1840-01-01','2999-12-31'),
	(33361,'15','065',' 06','065068',65068,'Minori','Minori','','SA',1,'1840-01-01','2999-12-31'),
	(33362,'15','065',' 06','065069',65069,'Moio della Civitella','Moio della Civitella','','SA',1,'1840-01-01','2999-12-31'),
	(33363,'15','065',' 07','065070',65070,'Montano Antilia','Montano Antilia','','SA',1,'1840-01-01','2999-12-31'),
	(33364,'15','065',' 07','065071',65071,'Montecorice','Montecorice','','SA',1,'1840-01-01','2999-12-31'),
	(33365,'15','065',' 07','065072',65072,'Montecorvino Pugliano','Montecorvino Pugliano','','SA',1,'1840-01-01','2999-12-31'),
	(33366,'15','065',' 07','065073',65073,'Montecorvino Rovella','Montecorvino Rovella','','SA',1,'1840-01-01','2999-12-31'),
	(33367,'15','065',' 07','065074',65074,'Monteforte Cilento','Monteforte Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33368,'15','065',' 07','065075',65075,'Monte San Giacomo','Monte San Giacomo','','SA',1,'1840-01-01','2999-12-31'),
	(33369,'15','065',' 07','065076',65076,'Montesano sulla Marcellana','Montesano sulla Marcellana','','SA',1,'1840-01-01','2999-12-31'),
	(33370,'15','065',' 07','065077',65077,'Morigerati','Morigerati','','SA',1,'1840-01-01','2999-12-31'),
	(33371,'15','065',' 07','065078',65078,'Nocera Inferiore','Nocera Inferiore','','SA',1,'1840-01-01','2999-12-31'),
	(33372,'15','065',' 07','065079',65079,'Nocera Superiore','Nocera Superiore','','SA',1,'1840-01-01','2999-12-31'),
	(33373,'15','065',' 08','065080',65080,'Novi Velia','Novi Velia','','SA',1,'1840-01-01','2999-12-31'),
	(33374,'15','065',' 08','065081',65081,'Ogliastro Cilento','Ogliastro Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33375,'15','065',' 08','065082',65082,'Olevano sul Tusciano','Olevano sul Tusciano','','SA',1,'1840-01-01','2999-12-31'),
	(33376,'15','065',' 08','065083',65083,'Oliveto Citra','Oliveto Citra','','SA',1,'1840-01-01','2999-12-31'),
	(33377,'15','065',' 08','065084',65084,'Omignano','Omignano','','SA',1,'1840-01-01','2999-12-31'),
	(33378,'15','065',' 08','065085',65085,'Orria','Orria','','SA',1,'1840-01-01','2999-12-31'),
	(33379,'15','065',' 08','065086',65086,'Ottati','Ottati','','SA',1,'1840-01-01','2999-12-31'),
	(33380,'15','065',' 08','065087',65087,'Padula','Padula','','SA',1,'1840-01-01','2999-12-31'),
	(33381,'15','065',' 08','065088',65088,'Pagani','Pagani','','SA',1,'1840-01-01','2999-12-31'),
	(33382,'15','065',' 08','065089',65089,'Palomonte','Palomonte','','SA',1,'1840-01-01','2999-12-31'),
	(33383,'15','065',' 09','065090',65090,'Pellezzano','Pellezzano','','SA',1,'1840-01-01','2999-12-31'),
	(33384,'15','065',' 09','065091',65091,'Perdifumo','Perdifumo','','SA',1,'1840-01-01','2999-12-31'),
	(33385,'15','065',' 09','065092',65092,'Perito','Perito','','SA',1,'1840-01-01','2999-12-31'),
	(33386,'15','065',' 09','065093',65093,'Pertosa','Pertosa','','SA',1,'1840-01-01','2999-12-31'),
	(33387,'15','065',' 09','065094',65094,'Petina','Petina','','SA',1,'1840-01-01','2999-12-31'),
	(33388,'15','065',' 09','065095',65095,'Piaggine','Piaggine','','SA',1,'1840-01-01','2999-12-31'),
	(33389,'15','065',' 09','065096',65096,'Pisciotta','Pisciotta','','SA',1,'1840-01-01','2999-12-31'),
	(33390,'15','065',' 09','065097',65097,'Polla','Polla','','SA',1,'1840-01-01','2999-12-31'),
	(33391,'15','065',' 09','065098',65098,'Pollica','Pollica','','SA',1,'1840-01-01','2999-12-31'),
	(33392,'15','065',' 09','065099',65099,'Pontecagnano Faiano','Pontecagnano Faiano','','SA',1,'1840-01-01','2999-12-31'),
	(33393,'15','065',' 10','065100',65100,'Positano','Positano','','SA',1,'1840-01-01','2999-12-31'),
	(33394,'15','065',' 10','065101',65101,'Postiglione','Postiglione','','SA',1,'1840-01-01','2999-12-31'),
	(33395,'15','065',' 10','065102',65102,'Praiano','Praiano','','SA',1,'1840-01-01','2999-12-31'),
	(33396,'15','065',' 10','065103',65103,'Prignano Cilento','Prignano Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33397,'15','065',' 10','065104',65104,'Ravello','Ravello','','SA',1,'1840-01-01','2999-12-31'),
	(33398,'15','065',' 10','065105',65105,'Ricigliano','Ricigliano','','SA',1,'1840-01-01','2999-12-31'),
	(33399,'15','065',' 10','065106',65106,'Roccadaspide','Roccadaspide','','SA',1,'1840-01-01','2999-12-31'),
	(33400,'15','065',' 10','065107',65107,'Roccagloriosa','Roccagloriosa','','SA',1,'1840-01-01','2999-12-31'),
	(33401,'15','065',' 10','065108',65108,'Roccapiemonte','Roccapiemonte','','SA',1,'1840-01-01','2999-12-31'),
	(33402,'15','065',' 10','065109',65109,'Rofrano','Rofrano','','SA',1,'1840-01-01','2999-12-31'),
	(33403,'15','065',' 11','065110',65110,'Romagnano al Monte','Romagnano al Monte','','SA',1,'1840-01-01','2999-12-31'),
	(33404,'15','065',' 11','065111',65111,'Roscigno','Roscigno','','SA',1,'1840-01-01','2999-12-31'),
	(33405,'15','065',' 11','065112',65112,'Rutino','Rutino','','SA',1,'1840-01-01','2999-12-31'),
	(33406,'15','065',' 11','065113',65113,'Sacco','Sacco','','SA',1,'1840-01-01','2999-12-31'),
	(33407,'15','065',' 11','065114',65114,'Sala Consilina','Sala Consilina','','SA',1,'1840-01-01','2999-12-31'),
	(33408,'15','065',' 11','065115',65115,'Salento','Salento','','SA',1,'1840-01-01','2999-12-31'),
	(33409,'15','065',' 11','065116',65116,'Salerno','Salerno','','SA',1,'1840-01-01','2999-12-31'),
	(33410,'15','065',' 11','065117',65117,'Salvitelle','Salvitelle','','SA',1,'1840-01-01','2999-12-31'),
	(33411,'15','065',' 11','065118',65118,'San Cipriano Picentino','San Cipriano Picentino','','SA',1,'1840-01-01','2999-12-31'),
	(33412,'15','065',' 11','065119',65119,'San Giovanni a Piro','San Giovanni a Piro','','SA',1,'1840-01-01','2999-12-31'),
	(33413,'15','065',' 12','065120',65120,'San Gregorio Magno','San Gregorio Magno','','SA',1,'1840-01-01','2999-12-31'),
	(33414,'15','065',' 12','065121',65121,'San Mango Piemonte','San Mango Piemonte','','SA',1,'1840-01-01','2999-12-31'),
	(33415,'15','065',' 12','065122',65122,'San Marzano sul Sarno','San Marzano sul Sarno','','SA',1,'1840-01-01','2999-12-31'),
	(33416,'15','065',' 12','065123',65123,'San Mauro Cilento','San Mauro Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33417,'15','065',' 12','065124',65124,'San Mauro la Bruca','San Mauro la Bruca','','SA',1,'1840-01-01','2999-12-31'),
	(33418,'15','065',' 12','065125',65125,'San Pietro al Tanagro','San Pietro al Tanagro','','SA',1,'1840-01-01','2999-12-31'),
	(33419,'15','065',' 12','065126',65126,'San Rufo','San Rufo','','SA',1,'1840-01-01','2999-12-31'),
	(33420,'15','065',' 12','065127',65127,'Santa Marina','Santa Marina','','SA',1,'1840-01-01','2999-12-31'),
	(33421,'15','065',' 12','065128',65128,'Sant\'Angelo a Fasanella','Sant\'Angelo a Fasanella','','SA',1,'1840-01-01','2999-12-31'),
	(33422,'15','065',' 12','065129',65129,'Sant\'Arsenio','Sant\'Arsenio','','SA',1,'1840-01-01','2999-12-31'),
	(33423,'15','065',' 13','065130',65130,'Sant\'Egidio del Monte Albino','Sant\'Egidio del Monte Albino','','SA',1,'1840-01-01','2999-12-31'),
	(33424,'15','065',' 13','065131',65131,'Santomenna','Santomenna','','SA',1,'1840-01-01','2999-12-31'),
	(33425,'15','065',' 13','065132',65132,'San Valentino Torio','San Valentino Torio','','SA',1,'1840-01-01','2999-12-31'),
	(33426,'15','065',' 13','065133',65133,'Sanza','Sanza','','SA',1,'1840-01-01','2999-12-31'),
	(33427,'15','065',' 13','065134',65134,'Sapri','Sapri','','SA',1,'1840-01-01','2999-12-31'),
	(33428,'15','065',' 13','065135',65135,'Sarno','Sarno','','SA',1,'1840-01-01','2999-12-31'),
	(33429,'15','065',' 13','065136',65136,'Sassano','Sassano','','SA',1,'1840-01-01','2999-12-31'),
	(33430,'15','065',' 13','065137',65137,'Scafati','Scafati','','SA',1,'1840-01-01','2999-12-31'),
	(33431,'15','065',' 13','065138',65138,'Scala','Scala','','SA',1,'1840-01-01','2999-12-31'),
	(33432,'15','065',' 13','065139',65139,'Serramezzana','Serramezzana','','SA',1,'1840-01-01','2999-12-31'),
	(33433,'15','065',' 14','065140',65140,'Serre','Serre','','SA',1,'1840-01-01','2999-12-31'),
	(33434,'15','065',' 14','065141',65141,'Sessa Cilento','Sessa Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33435,'15','065',' 14','065142',65142,'Siano','Siano','','SA',1,'1840-01-01','2999-12-31'),
	(33436,'15','065',' 14','065143',65143,'Sicignano degli Alburni','Sicignano degli Alburni','','SA',1,'1840-01-01','2999-12-31'),
	(33437,'15','065',' 14','065144',65144,'Stella Cilento','Stella Cilento','','SA',1,'1840-01-01','2999-12-31'),
	(33438,'15','065',' 14','065145',65145,'Stio','Stio','','SA',1,'1840-01-01','2999-12-31'),
	(33439,'15','065',' 14','065146',65146,'Teggiano','Teggiano','','SA',1,'1840-01-01','2999-12-31'),
	(33440,'15','065',' 14','065147',65147,'Torchiara','Torchiara','','SA',1,'1840-01-01','2999-12-31'),
	(33441,'15','065',' 14','065148',65148,'Torraca','Torraca','','SA',1,'1840-01-01','2999-12-31'),
	(33442,'15','065',' 14','065149',65149,'Torre Orsaia','Torre Orsaia','','SA',1,'1840-01-01','2999-12-31'),
	(33443,'15','065',' 15','065150',65150,'Tortorella','Tortorella','','SA',1,'1840-01-01','2999-12-31'),
	(33444,'15','065',' 15','065151',65151,'Tramonti','Tramonti','','SA',1,'1840-01-01','2999-12-31'),
	(33445,'15','065',' 15','065152',65152,'Trentinara','Trentinara','','SA',1,'1840-01-01','2999-12-31'),
	(33446,'15','065',' 15','065153',65153,'Valle dell\'Angelo','Valle dell\'Angelo','','SA',1,'1840-01-01','2999-12-31'),
	(33447,'15','065',' 15','065154',65154,'Vallo della Lucania','Vallo della Lucania','','SA',1,'1840-01-01','2999-12-31'),
	(33448,'15','065',' 15','065155',65155,'Valva','Valva','','SA',1,'1840-01-01','2999-12-31'),
	(33449,'15','065',' 15','065156',65156,'Vibonati','Vibonati','','SA',1,'1840-01-01','2999-12-31'),
	(33450,'15','065',' 15','065157',65157,'Vietri sul Mare','Vietri sul Mare','','SA',1,'1840-01-01','2999-12-31'),
	(33451,'15','065',' 15','065158',65158,'Bellizzi','Bellizzi','','SA',1,'1840-01-01','2999-12-31'),
	(33452,'13','066',' 00','066001',66001,'Acciano','Acciano','','AQ',1,'1840-01-01','2999-12-31'),
	(33453,'13','066',' 00','066002',66002,'Aielli','Aielli','','AQ',1,'1840-01-01','2999-12-31'),
	(33454,'13','066',' 00','066003',66003,'Alfedena','Alfedena','','AQ',1,'1840-01-01','2999-12-31'),
	(33455,'13','066',' 00','066004',66004,'Anversa degli Abruzzi','Anversa degli Abruzzi','','AQ',1,'1840-01-01','2999-12-31'),
	(33456,'13','066',' 00','066005',66005,'Ateleta','Ateleta','','AQ',1,'1840-01-01','2999-12-31'),
	(33457,'13','066',' 00','066006',66006,'Avezzano','Avezzano','','AQ',1,'1840-01-01','2999-12-31'),
	(33458,'13','066',' 00','066007',66007,'Balsorano','Balsorano','','AQ',1,'1840-01-01','2999-12-31'),
	(33459,'13','066',' 00','066008',66008,'Barete','Barete','','AQ',1,'1840-01-01','2999-12-31'),
	(33460,'13','066',' 00','066009',66009,'Barisciano','Barisciano','','AQ',1,'1840-01-01','2999-12-31'),
	(33461,'13','066',' 01','066010',66010,'Barrea','Barrea','','AQ',1,'1840-01-01','2999-12-31'),
	(33462,'13','066',' 01','066011',66011,'Bisegna','Bisegna','','AQ',1,'1840-01-01','2999-12-31'),
	(33463,'13','066',' 01','066012',66012,'Bugnara','Bugnara','','AQ',1,'1840-01-01','2999-12-31'),
	(33464,'13','066',' 01','066013',66013,'Cagnano Amiterno','Cagnano Amiterno','','AQ',1,'1840-01-01','2999-12-31'),
	(33465,'13','066',' 01','066014',66014,'Calascio','Calascio','','AQ',1,'1840-01-01','2999-12-31'),
	(33466,'13','066',' 01','066015',66015,'Campo di Giove','Campo di Giove','','AQ',1,'1840-01-01','2999-12-31'),
	(33467,'13','066',' 01','066016',66016,'Campotosto','Campotosto','','AQ',1,'1840-01-01','2999-12-31'),
	(33468,'13','066',' 01','066017',66017,'Canistro','Canistro','','AQ',1,'1840-01-01','2999-12-31'),
	(33469,'13','066',' 01','066018',66018,'Cansano','Cansano','','AQ',1,'1840-01-01','2999-12-31'),
	(33470,'13','066',' 01','066019',66019,'Capestrano','Capestrano','','AQ',1,'1840-01-01','2999-12-31'),
	(33471,'13','066',' 02','066020',66020,'Capistrello','Capistrello','','AQ',1,'1840-01-01','2999-12-31'),
	(33472,'13','066',' 02','066021',66021,'Capitignano','Capitignano','','AQ',1,'1840-01-01','2999-12-31'),
	(33473,'13','066',' 02','066022',66022,'Caporciano','Caporciano','','AQ',1,'1840-01-01','2999-12-31'),
	(33474,'13','066',' 02','066023',66023,'Cappadocia','Cappadocia','','AQ',1,'1840-01-01','2999-12-31'),
	(33475,'13','066',' 02','066024',66024,'Carapelle Calvisio','Carapelle Calvisio','','AQ',1,'1840-01-01','2999-12-31'),
	(33476,'13','066',' 02','066025',66025,'Carsoli','Carsoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33477,'13','066',' 02','066026',66026,'Castel del Monte','Castel del Monte','','AQ',1,'1840-01-01','2999-12-31'),
	(33478,'13','066',' 02','066027',66027,'Castel di Ieri','Castel di Ieri','','AQ',1,'1840-01-01','2999-12-31'),
	(33479,'13','066',' 02','066028',66028,'Castel di Sangro','Castel di Sangro','','AQ',1,'1840-01-01','2999-12-31'),
	(33480,'13','066',' 02','066029',66029,'Castellafiume','Castellafiume','','AQ',1,'1840-01-01','2999-12-31'),
	(33481,'13','066',' 03','066030',66030,'Castelvecchio Calvisio','Castelvecchio Calvisio','','AQ',1,'1840-01-01','2999-12-31'),
	(33482,'13','066',' 03','066031',66031,'Castelvecchio Subequo','Castelvecchio Subequo','','AQ',1,'1840-01-01','2999-12-31'),
	(33483,'13','066',' 03','066032',66032,'Celano','Celano','','AQ',1,'1840-01-01','2999-12-31'),
	(33484,'13','066',' 03','066033',66033,'Cerchio','Cerchio','','AQ',1,'1840-01-01','2999-12-31'),
	(33485,'13','066',' 03','066034',66034,'Civita d\'Antino','Civita d\'Antino','','AQ',1,'1840-01-01','2999-12-31'),
	(33486,'13','066',' 03','066035',66035,'Civitella Alfedena','Civitella Alfedena','','AQ',1,'1840-01-01','2999-12-31'),
	(33487,'13','066',' 03','066036',66036,'Civitella Roveto','Civitella Roveto','','AQ',1,'1840-01-01','2999-12-31'),
	(33488,'13','066',' 03','066037',66037,'Cocullo','Cocullo','','AQ',1,'1840-01-01','2999-12-31'),
	(33489,'13','066',' 03','066038',66038,'Collarmele','Collarmele','','AQ',1,'1840-01-01','2999-12-31'),
	(33490,'13','066',' 03','066039',66039,'Collelongo','Collelongo','','AQ',1,'1840-01-01','2999-12-31'),
	(33491,'13','066',' 04','066040',66040,'Collepietro','Collepietro','','AQ',1,'1840-01-01','2999-12-31'),
	(33492,'13','066',' 04','066041',66041,'Corfinio','Corfinio','','AQ',1,'1840-01-01','2999-12-31'),
	(33493,'13','066',' 04','066042',66042,'Fagnano Alto','Fagnano Alto','','AQ',1,'1840-01-01','2999-12-31'),
	(33494,'13','066',' 04','066043',66043,'Fontecchio','Fontecchio','','AQ',1,'1840-01-01','2999-12-31'),
	(33495,'13','066',' 04','066044',66044,'Fossa','Fossa','','AQ',1,'1840-01-01','2999-12-31'),
	(33496,'13','066',' 04','066045',66045,'Gagliano Aterno','Gagliano Aterno','','AQ',1,'1840-01-01','2999-12-31'),
	(33497,'13','066',' 04','066046',66046,'Gioia dei Marsi','Gioia dei Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33498,'13','066',' 04','066047',66047,'Goriano Sicoli','Goriano Sicoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33499,'13','066',' 04','066048',66048,'Introdacqua','Introdacqua','','AQ',1,'1840-01-01','2999-12-31'),
	(33500,'13','066',' 04','066049',66049,'L\'Aquila','L\'Aquila','','AQ',1,'1840-01-01','2999-12-31'),
	(33501,'13','066',' 05','066050',66050,'Lecce nei Marsi','Lecce nei Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33502,'13','066',' 05','066051',66051,'Luco dei Marsi','Luco dei Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33503,'13','066',' 05','066052',66052,'Lucoli','Lucoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33504,'13','066',' 05','066053',66053,'Magliano de\' Marsi','Magliano de\' Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33505,'13','066',' 05','066054',66054,'Massa d\'Albe','Massa d\'Albe','','AQ',1,'1840-01-01','2999-12-31'),
	(33506,'13','066',' 05','066055',66055,'Molina Aterno','Molina Aterno','','AQ',1,'1840-01-01','2999-12-31'),
	(33507,'13','066',' 05','066056',66056,'Montereale','Montereale','','AQ',1,'1840-01-01','2999-12-31'),
	(33508,'13','066',' 05','066057',66057,'Morino','Morino','','AQ',1,'1840-01-01','2999-12-31'),
	(33509,'13','066',' 05','066058',66058,'Navelli','Navelli','','AQ',1,'1840-01-01','2999-12-31'),
	(33510,'13','066',' 05','066059',66059,'Ocre','Ocre','','AQ',1,'1840-01-01','2999-12-31'),
	(33511,'13','066',' 06','066060',66060,'Ofena','Ofena','','AQ',1,'1840-01-01','2999-12-31'),
	(33512,'13','066',' 06','066061',66061,'Opi','Opi','','AQ',1,'1840-01-01','2999-12-31'),
	(33513,'13','066',' 06','066062',66062,'Oricola','Oricola','','AQ',1,'1840-01-01','2999-12-31'),
	(33514,'13','066',' 06','066063',66063,'Ortona dei Marsi','Ortona dei Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33515,'13','066',' 06','066064',66064,'Ortucchio','Ortucchio','','AQ',1,'1840-01-01','2999-12-31'),
	(33516,'13','066',' 06','066065',66065,'Ovindoli','Ovindoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33517,'13','066',' 06','066066',66066,'Pacentro','Pacentro','','AQ',1,'1840-01-01','2999-12-31'),
	(33518,'13','066',' 06','066067',66067,'Pereto','Pereto','','AQ',1,'1840-01-01','2999-12-31'),
	(33519,'13','066',' 06','066068',66068,'Pescasseroli','Pescasseroli','','AQ',1,'1840-01-01','2999-12-31'),
	(33520,'13','066',' 06','066069',66069,'Pescina','Pescina','','AQ',1,'1840-01-01','2999-12-31'),
	(33521,'13','066',' 07','066070',66070,'Pescocostanzo','Pescocostanzo','','AQ',1,'1840-01-01','2999-12-31'),
	(33522,'13','066',' 07','066071',66071,'Pettorano sul Gizio','Pettorano sul Gizio','','AQ',1,'1840-01-01','2999-12-31'),
	(33523,'13','066',' 07','066072',66072,'Pizzoli','Pizzoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33524,'13','066',' 07','066073',66073,'Poggio Picenze','Poggio Picenze','','AQ',1,'1840-01-01','2999-12-31'),
	(33525,'13','066',' 07','066074',66074,'Prata d\'Ansidonia','Prata d\'Ansidonia','','AQ',1,'1840-01-01','2999-12-31'),
	(33526,'13','066',' 07','066075',66075,'Pratola Peligna','Pratola Peligna','','AQ',1,'1840-01-01','2999-12-31'),
	(33527,'13','066',' 07','066076',66076,'Prezza','Prezza','','AQ',1,'1840-01-01','2999-12-31'),
	(33528,'13','066',' 07','066077',66077,'Raiano','Raiano','','AQ',1,'1840-01-01','2999-12-31'),
	(33529,'13','066',' 07','066078',66078,'Rivisondoli','Rivisondoli','','AQ',1,'1840-01-01','2999-12-31'),
	(33530,'13','066',' 07','066079',66079,'Roccacasale','Roccacasale','','AQ',1,'1840-01-01','2999-12-31'),
	(33531,'13','066',' 08','066080',66080,'Rocca di Botte','Rocca di Botte','','AQ',1,'1840-01-01','2999-12-31'),
	(33532,'13','066',' 08','066081',66081,'Rocca di Cambio','Rocca di Cambio','','AQ',1,'1840-01-01','2999-12-31'),
	(33533,'13','066',' 08','066082',66082,'Rocca di Mezzo','Rocca di Mezzo','','AQ',1,'1840-01-01','2999-12-31'),
	(33534,'13','066',' 08','066083',66083,'Rocca Pia','Rocca Pia','','AQ',1,'1840-01-01','2999-12-31'),
	(33535,'13','066',' 08','066084',66084,'Roccaraso','Roccaraso','','AQ',1,'1840-01-01','2999-12-31'),
	(33536,'13','066',' 08','066085',66085,'San Benedetto dei Marsi','San Benedetto dei Marsi','','AQ',1,'1840-01-01','2999-12-31'),
	(33537,'13','066',' 08','066086',66086,'San Benedetto in Perillis','San Benedetto in Perillis','','AQ',1,'1840-01-01','2999-12-31'),
	(33538,'13','066',' 08','066087',66087,'San Demetrio ne\' Vestini','San Demetrio ne\' Vestini','','AQ',1,'1840-01-01','2999-12-31'),
	(33539,'13','066',' 08','066088',66088,'San Pio delle Camere','San Pio delle Camere','','AQ',1,'1840-01-01','2999-12-31'),
	(33540,'13','066',' 08','066089',66089,'Sante Marie','Sante Marie','','AQ',1,'1840-01-01','2999-12-31'),
	(33541,'13','066',' 09','066090',66090,'Sant\'Eusanio Forconese','Sant\'Eusanio Forconese','','AQ',1,'1840-01-01','2999-12-31'),
	(33542,'13','066',' 09','066091',66091,'Santo Stefano di Sessanio','Santo Stefano di Sessanio','','AQ',1,'1840-01-01','2999-12-31'),
	(33543,'13','066',' 09','066092',66092,'San Vincenzo Valle Roveto','San Vincenzo Valle Roveto','','AQ',1,'1840-01-01','2999-12-31'),
	(33544,'13','066',' 09','066093',66093,'Scanno','Scanno','','AQ',1,'1840-01-01','2999-12-31'),
	(33545,'13','066',' 09','066094',66094,'Scontrone','Scontrone','','AQ',1,'1840-01-01','2999-12-31'),
	(33546,'13','066',' 09','066095',66095,'Scoppito','Scoppito','','AQ',1,'1840-01-01','2999-12-31'),
	(33547,'13','066',' 09','066096',66096,'Scurcola Marsicana','Scurcola Marsicana','','AQ',1,'1840-01-01','2999-12-31'),
	(33548,'13','066',' 09','066097',66097,'Secinaro','Secinaro','','AQ',1,'1840-01-01','2999-12-31'),
	(33549,'13','066',' 09','066098',66098,'Sulmona','Sulmona','','AQ',1,'1840-01-01','2999-12-31'),
	(33550,'13','066',' 09','066099',66099,'Tagliacozzo','Tagliacozzo','','AQ',1,'1840-01-01','2999-12-31'),
	(33551,'13','066',' 10','066100',66100,'Tione degli Abruzzi','Tione degli Abruzzi','','AQ',1,'1840-01-01','2999-12-31'),
	(33552,'13','066',' 10','066101',66101,'Tornimparte','Tornimparte','','AQ',1,'1840-01-01','2999-12-31'),
	(33553,'13','066',' 10','066102',66102,'Trasacco','Trasacco','','AQ',1,'1840-01-01','2999-12-31'),
	(33554,'13','066',' 10','066103',66103,'Villalago','Villalago','','AQ',1,'1840-01-01','2999-12-31'),
	(33555,'13','066',' 10','066104',66104,'Villa Santa Lucia degli Abruzzi','Villa Santa Lucia degli Abruzzi','','AQ',1,'1840-01-01','2999-12-31'),
	(33556,'13','066',' 10','066105',66105,'Villa Sant\'Angelo','Villa Sant\'Angelo','','AQ',1,'1840-01-01','2999-12-31'),
	(33557,'13','066',' 10','066106',66106,'Villavallelonga','Villavallelonga','','AQ',1,'1840-01-01','2999-12-31'),
	(33558,'13','066',' 10','066107',66107,'Villetta Barrea','Villetta Barrea','','AQ',1,'1840-01-01','2999-12-31'),
	(33559,'13','066',' 10','066108',66108,'Vittorito','Vittorito','','AQ',1,'1840-01-01','2999-12-31'),
	(33560,'13','067',' 00','067001',67001,'Alba Adriatica','Alba Adriatica','','TE',1,'1840-01-01','2999-12-31'),
	(33561,'13','067',' 00','067002',67002,'Ancarano','Ancarano','','TE',1,'1840-01-01','2999-12-31'),
	(33562,'13','067',' 00','067003',67003,'Arsita','Arsita','','TE',1,'1840-01-01','2999-12-31'),
	(33563,'13','067',' 00','067004',67004,'Atri','Atri','','TE',1,'1840-01-01','2999-12-31'),
	(33564,'13','067',' 00','067005',67005,'Basciano','Basciano','','TE',1,'1840-01-01','2999-12-31'),
	(33565,'13','067',' 00','067006',67006,'Bellante','Bellante','','TE',1,'1840-01-01','2999-12-31'),
	(33566,'13','067',' 00','067007',67007,'Bisenti','Bisenti','','TE',1,'1840-01-01','2999-12-31'),
	(33567,'13','067',' 00','067008',67008,'Campli','Campli','','TE',1,'1840-01-01','2999-12-31'),
	(33568,'13','067',' 00','067009',67009,'Canzano','Canzano','','TE',1,'1840-01-01','2999-12-31'),
	(33569,'13','067',' 01','067010',67010,'Castel Castagna','Castel Castagna','','TE',1,'1840-01-01','2999-12-31'),
	(33570,'13','067',' 01','067011',67011,'Castellalto','Castellalto','','TE',1,'1840-01-01','2999-12-31'),
	(33571,'13','067',' 01','067012',67012,'Castelli','Castelli','','TE',1,'1840-01-01','2999-12-31'),
	(33572,'13','067',' 01','067013',67013,'Castiglione Messer Raimondo','Castiglione Messer Raimondo','','TE',1,'1840-01-01','2999-12-31'),
	(33573,'13','067',' 01','067014',67014,'Castilenti','Castilenti','','TE',1,'1840-01-01','2999-12-31'),
	(33574,'13','067',' 01','067015',67015,'Cellino Attanasio','Cellino Attanasio','','TE',1,'1840-01-01','2999-12-31'),
	(33575,'13','067',' 01','067016',67016,'Cermignano','Cermignano','','TE',1,'1840-01-01','2999-12-31'),
	(33576,'13','067',' 01','067017',67017,'Civitella del Tronto','Civitella del Tronto','','TE',1,'1840-01-01','2999-12-31'),
	(33577,'13','067',' 01','067018',67018,'Colledara','Colledara','','TE',1,'1840-01-01','2999-12-31'),
	(33578,'13','067',' 01','067019',67019,'Colonnella','Colonnella','','TE',1,'1840-01-01','2999-12-31'),
	(33579,'13','067',' 02','067020',67020,'Controguerra','Controguerra','','TE',1,'1840-01-01','2999-12-31'),
	(33580,'13','067',' 02','067021',67021,'Corropoli','Corropoli','','TE',1,'1840-01-01','2999-12-31'),
	(33581,'13','067',' 02','067022',67022,'Cortino','Cortino','','TE',1,'1840-01-01','2999-12-31'),
	(33582,'13','067',' 02','067023',67023,'Crognaleto','Crognaleto','','TE',1,'1840-01-01','2999-12-31'),
	(33583,'13','067',' 02','067024',67024,'Fano Adriano','Fano Adriano','','TE',1,'1840-01-01','2999-12-31'),
	(33584,'13','067',' 02','067025',67025,'Giulianova','Giulianova','','TE',1,'1840-01-01','2999-12-31'),
	(33585,'13','067',' 02','067026',67026,'Isola del Gran Sasso d\'Italia','Isola del Gran Sasso d\'Italia','','TE',1,'1840-01-01','2999-12-31'),
	(33586,'13','067',' 02','067027',67027,'Montefino','Montefino','','TE',1,'1840-01-01','2999-12-31'),
	(33587,'13','067',' 02','067028',67028,'Montorio al Vomano','Montorio al Vomano','','TE',1,'1840-01-01','2999-12-31'),
	(33588,'13','067',' 02','067029',67029,'Morro d\'Oro','Morro d\'Oro','','TE',1,'1840-01-01','2999-12-31'),
	(33589,'13','067',' 03','067030',67030,'Mosciano Sant\'Angelo','Mosciano Sant\'Angelo','','TE',1,'1840-01-01','2999-12-31'),
	(33590,'13','067',' 03','067031',67031,'Nereto','Nereto','','TE',1,'1840-01-01','2999-12-31'),
	(33591,'13','067',' 03','067032',67032,'Notaresco','Notaresco','','TE',1,'1840-01-01','2999-12-31'),
	(33592,'13','067',' 03','067033',67033,'Penna Sant\'Andrea','Penna Sant\'Andrea','','TE',1,'1840-01-01','2999-12-31'),
	(33593,'13','067',' 03','067034',67034,'Pietracamela','Pietracamela','','TE',1,'1840-01-01','2999-12-31'),
	(33594,'13','067',' 03','067035',67035,'Pineto','Pineto','','TE',1,'1840-01-01','2999-12-31'),
	(33595,'13','067',' 03','067036',67036,'Rocca Santa Maria','Rocca Santa Maria','','TE',1,'1840-01-01','2999-12-31'),
	(33596,'13','067',' 03','067037',67037,'Roseto degli Abruzzi','Roseto degli Abruzzi','','TE',1,'1840-01-01','2999-12-31'),
	(33597,'13','067',' 03','067038',67038,'Sant\'Egidio alla Vibrata','Sant\'Egidio alla Vibrata','','TE',1,'1840-01-01','2999-12-31'),
	(33598,'13','067',' 03','067039',67039,'Sant\'Omero','Sant\'Omero','','TE',1,'1840-01-01','2999-12-31'),
	(33599,'13','067',' 04','067040',67040,'Silvi','Silvi','','TE',1,'1840-01-01','2999-12-31'),
	(33600,'13','067',' 04','067041',67041,'Teramo','Teramo','','TE',1,'1840-01-01','2999-12-31'),
	(33601,'13','067',' 04','067042',67042,'Torano Nuovo','Torano Nuovo','','TE',1,'1840-01-01','2999-12-31'),
	(33602,'13','067',' 04','067043',67043,'Torricella Sicura','Torricella Sicura','','TE',1,'1840-01-01','2999-12-31'),
	(33603,'13','067',' 04','067044',67044,'Tortoreto','Tortoreto','','TE',1,'1840-01-01','2999-12-31'),
	(33604,'13','067',' 04','067045',67045,'Tossicia','Tossicia','','TE',1,'1840-01-01','2999-12-31'),
	(33605,'13','067',' 04','067046',67046,'Valle Castellana','Valle Castellana','','TE',1,'1840-01-01','2999-12-31'),
	(33606,'13','067',' 04','067047',67047,'Martinsicuro','Martinsicuro','','TE',1,'1840-01-01','2999-12-31'),
	(33607,'13','068',' 00','068001',68001,'Abbateggio','Abbateggio','','PE',1,'1840-01-01','2999-12-31'),
	(33608,'13','068',' 00','068002',68002,'Alanno','Alanno','','PE',1,'1840-01-01','2999-12-31'),
	(33609,'13','068',' 00','068003',68003,'Bolognano','Bolognano','','PE',1,'1840-01-01','2999-12-31'),
	(33610,'13','068',' 00','068004',68004,'Brittoli','Brittoli','','PE',1,'1840-01-01','2999-12-31'),
	(33611,'13','068',' 00','068005',68005,'Bussi sul Tirino','Bussi sul Tirino','','PE',1,'1840-01-01','2999-12-31'),
	(33612,'13','068',' 00','068006',68006,'Cappelle sul Tavo','Cappelle sul Tavo','','PE',1,'1840-01-01','2999-12-31'),
	(33613,'13','068',' 00','068007',68007,'Caramanico Terme','Caramanico Terme','','PE',1,'1840-01-01','2999-12-31'),
	(33614,'13','068',' 00','068008',68008,'Carpineto della Nora','Carpineto della Nora','','PE',1,'1840-01-01','2999-12-31'),
	(33615,'13','068',' 00','068009',68009,'Castiglione a Casauria','Castiglione a Casauria','','PE',1,'1840-01-01','2999-12-31'),
	(33616,'13','068',' 01','068010',68010,'Catignano','Catignano','','PE',1,'1840-01-01','2999-12-31'),
	(33617,'13','068',' 01','068011',68011,'Cepagatti','Cepagatti','','PE',1,'1840-01-01','2999-12-31'),
	(33618,'13','068',' 01','068012',68012,'Città Sant\'Angelo','Città Sant\'Angelo','','PE',1,'1840-01-01','2999-12-31'),
	(33619,'13','068',' 01','068013',68013,'Civitaquana','Civitaquana','','PE',1,'1840-01-01','2999-12-31'),
	(33620,'13','068',' 01','068014',68014,'Civitella Casanova','Civitella Casanova','','PE',1,'1840-01-01','2999-12-31'),
	(33621,'13','068',' 01','068015',68015,'Collecorvino','Collecorvino','','PE',1,'1840-01-01','2999-12-31'),
	(33622,'13','068',' 01','068016',68016,'Corvara','Corvara','','PE',1,'1840-01-01','2999-12-31'),
	(33623,'13','068',' 01','068017',68017,'Cugnoli','Cugnoli','','PE',1,'1840-01-01','2999-12-31'),
	(33624,'13','068',' 01','068018',68018,'Elice','Elice','','PE',1,'1840-01-01','2999-12-31'),
	(33625,'13','068',' 01','068019',68019,'Farindola','Farindola','','PE',1,'1840-01-01','2999-12-31'),
	(33626,'13','068',' 02','068020',68020,'Lettomanoppello','Lettomanoppello','','PE',1,'1840-01-01','2999-12-31'),
	(33627,'13','068',' 02','068021',68021,'Loreto Aprutino','Loreto Aprutino','','PE',1,'1840-01-01','2999-12-31'),
	(33628,'13','068',' 02','068022',68022,'Manoppello','Manoppello','','PE',1,'1840-01-01','2999-12-31'),
	(33629,'13','068',' 02','068023',68023,'Montebello di Bertona','Montebello di Bertona','','PE',1,'1840-01-01','2999-12-31'),
	(33630,'13','068',' 02','068024',68024,'Montesilvano','Montesilvano','','PE',1,'1840-01-01','2999-12-31'),
	(33631,'13','068',' 02','068025',68025,'Moscufo','Moscufo','','PE',1,'1840-01-01','2999-12-31'),
	(33632,'13','068',' 02','068026',68026,'Nocciano','Nocciano','','PE',1,'1840-01-01','2999-12-31'),
	(33633,'13','068',' 02','068027',68027,'Penne','Penne','','PE',1,'1840-01-01','2999-12-31'),
	(33634,'13','068',' 02','068028',68028,'Pescara','Pescara','','PE',1,'1840-01-01','2999-12-31'),
	(33635,'13','068',' 02','068029',68029,'Pescosansonesco','Pescosansonesco','','PE',1,'1840-01-01','2999-12-31'),
	(33636,'13','068',' 03','068030',68030,'Pianella','Pianella','','PE',1,'1840-01-01','2999-12-31'),
	(33637,'13','068',' 03','068031',68031,'Picciano','Picciano','','PE',1,'1840-01-01','2999-12-31'),
	(33638,'13','068',' 03','068032',68032,'Pietranico','Pietranico','','PE',1,'1840-01-01','2999-12-31'),
	(33639,'13','068',' 03','068033',68033,'Popoli','Popoli','','PE',1,'1840-01-01','2999-12-31'),
	(33640,'13','068',' 03','068034',68034,'Roccamorice','Roccamorice','','PE',1,'1840-01-01','2999-12-31'),
	(33641,'13','068',' 03','068035',68035,'Rosciano','Rosciano','','PE',1,'1840-01-01','2999-12-31'),
	(33642,'13','068',' 03','068036',68036,'Salle','Salle','','PE',1,'1840-01-01','2999-12-31'),
	(33643,'13','068',' 03','068037',68037,'Sant\'Eufemia a Maiella','Sant\'Eufemia a Maiella','','PE',1,'1840-01-01','2999-12-31'),
	(33644,'13','068',' 03','068038',68038,'San Valentino in Abruzzo Citeriore','San Valentino in Abruzzo Citeriore','','PE',1,'1840-01-01','2999-12-31'),
	(33645,'13','068',' 03','068039',68039,'Scafa','Scafa','','PE',1,'1840-01-01','2999-12-31'),
	(33646,'13','068',' 04','068040',68040,'Serramonacesca','Serramonacesca','','PE',1,'1840-01-01','2999-12-31'),
	(33647,'13','068',' 04','068041',68041,'Spoltore','Spoltore','','PE',1,'1840-01-01','2999-12-31'),
	(33648,'13','068',' 04','068042',68042,'Tocco da Casauria','Tocco da Casauria','','PE',1,'1840-01-01','2999-12-31'),
	(33649,'13','068',' 04','068043',68043,'Torre de\' Passeri','Torre de\' Passeri','','PE',1,'1840-01-01','2999-12-31'),
	(33650,'13','068',' 04','068044',68044,'Turrivalignani','Turrivalignani','','PE',1,'1840-01-01','2999-12-31'),
	(33651,'13','068',' 04','068045',68045,'Vicoli','Vicoli','','PE',1,'1840-01-01','2999-12-31'),
	(33652,'13','068',' 04','068046',68046,'Villa Celiera','Villa Celiera','','PE',1,'1840-01-01','2999-12-31'),
	(33653,'13','069',' 00','069001',69001,'Altino','Altino','','CH',1,'1840-01-01','2999-12-31'),
	(33654,'13','069',' 00','069002',69002,'Archi','Archi','','CH',1,'1840-01-01','2999-12-31'),
	(33655,'13','069',' 00','069003',69003,'Ari','Ari','','CH',1,'1840-01-01','2999-12-31'),
	(33656,'13','069',' 00','069004',69004,'Arielli','Arielli','','CH',1,'1840-01-01','2999-12-31'),
	(33657,'13','069',' 00','069005',69005,'Atessa','Atessa','','CH',1,'1840-01-01','2999-12-31'),
	(33658,'13','069',' 00','069006',69006,'Bomba','Bomba','','CH',1,'1840-01-01','2999-12-31'),
	(33659,'13','069',' 00','069007',69007,'Borrello','Borrello','','CH',1,'1840-01-01','2999-12-31'),
	(33660,'13','069',' 00','069008',69008,'Bucchianico','Bucchianico','','CH',1,'1840-01-01','2999-12-31'),
	(33661,'13','069',' 00','069009',69009,'Montebello sul Sangro','Montebello sul Sangro','','CH',1,'1840-01-01','2999-12-31'),
	(33662,'13','069',' 01','069010',69010,'Canosa Sannita','Canosa Sannita','','CH',1,'1840-01-01','2999-12-31'),
	(33663,'13','069',' 01','069011',69011,'Carpineto Sinello','Carpineto Sinello','','CH',1,'1840-01-01','2999-12-31'),
	(33664,'13','069',' 01','069012',69012,'Carunchio','Carunchio','','CH',1,'1840-01-01','2999-12-31'),
	(33665,'13','069',' 01','069013',69013,'Casacanditella','Casacanditella','','CH',1,'1840-01-01','2999-12-31'),
	(33666,'13','069',' 01','069014',69014,'Casalanguida','Casalanguida','','CH',1,'1840-01-01','2999-12-31'),
	(33667,'13','069',' 01','069015',69015,'Casalbordino','Casalbordino','','CH',1,'1840-01-01','2999-12-31'),
	(33668,'13','069',' 01','069016',69016,'Casalincontrada','Casalincontrada','','CH',1,'1840-01-01','2999-12-31'),
	(33669,'13','069',' 01','069017',69017,'Casoli','Casoli','','CH',1,'1840-01-01','2999-12-31'),
	(33670,'13','069',' 01','069018',69018,'Castel Frentano','Castel Frentano','','CH',1,'1840-01-01','2999-12-31'),
	(33671,'13','069',' 01','069019',69019,'Castelguidone','Castelguidone','','CH',1,'1840-01-01','2999-12-31'),
	(33672,'13','069',' 02','069020',69020,'Castiglione Messer Marino','Castiglione Messer Marino','','CH',1,'1840-01-01','2999-12-31'),
	(33673,'13','069',' 02','069021',69021,'Celenza sul Trigno','Celenza sul Trigno','','CH',1,'1840-01-01','2999-12-31'),
	(33674,'13','069',' 02','069022',69022,'Chieti','Chieti','','CH',1,'1840-01-01','2999-12-31'),
	(33675,'13','069',' 02','069023',69023,'Civitaluparella','Civitaluparella','','CH',1,'1840-01-01','2999-12-31'),
	(33676,'13','069',' 02','069024',69024,'Civitella Messer Raimondo','Civitella Messer Raimondo','','CH',1,'1840-01-01','2999-12-31'),
	(33677,'13','069',' 02','069025',69025,'Colledimacine','Colledimacine','','CH',1,'1840-01-01','2999-12-31'),
	(33678,'13','069',' 02','069026',69026,'Colledimezzo','Colledimezzo','','CH',1,'1840-01-01','2999-12-31'),
	(33679,'13','069',' 02','069027',69027,'Crecchio','Crecchio','','CH',1,'1840-01-01','2999-12-31'),
	(33680,'13','069',' 02','069028',69028,'Cupello','Cupello','','CH',1,'1840-01-01','2999-12-31'),
	(33681,'13','069',' 02','069029',69029,'Dogliola','Dogliola','','CH',1,'1840-01-01','2999-12-31'),
	(33682,'13','069',' 03','069030',69030,'Fara Filiorum Petri','Fara Filiorum Petri','','CH',1,'1840-01-01','2999-12-31'),
	(33683,'13','069',' 03','069031',69031,'Fara San Martino','Fara San Martino','','CH',1,'1840-01-01','2999-12-31'),
	(33684,'13','069',' 03','069032',69032,'Filetto','Filetto','','CH',1,'1840-01-01','2999-12-31'),
	(33685,'13','069',' 03','069033',69033,'Fossacesia','Fossacesia','','CH',1,'1840-01-01','2999-12-31'),
	(33686,'13','069',' 03','069034',69034,'Fraine','Fraine','','CH',1,'1840-01-01','2999-12-31'),
	(33687,'13','069',' 03','069035',69035,'Francavilla al Mare','Francavilla al Mare','','CH',1,'1840-01-01','2999-12-31'),
	(33688,'13','069',' 03','069036',69036,'Fresagrandinaria','Fresagrandinaria','','CH',1,'1840-01-01','2999-12-31'),
	(33689,'13','069',' 03','069037',69037,'Frisa','Frisa','','CH',1,'1840-01-01','2999-12-31'),
	(33690,'13','069',' 03','069038',69038,'Furci','Furci','','CH',1,'1840-01-01','2999-12-31'),
	(33691,'13','069',' 03','069039',69039,'Gamberale','Gamberale','','CH',1,'1840-01-01','2999-12-31'),
	(33692,'13','069',' 04','069040',69040,'Gessopalena','Gessopalena','','CH',1,'1840-01-01','2999-12-31'),
	(33693,'13','069',' 04','069041',69041,'Gissi','Gissi','','CH',1,'1840-01-01','2999-12-31'),
	(33694,'13','069',' 04','069042',69042,'Giuliano Teatino','Giuliano Teatino','','CH',1,'1840-01-01','2999-12-31'),
	(33695,'13','069',' 04','069043',69043,'Guardiagrele','Guardiagrele','','CH',1,'1840-01-01','2999-12-31'),
	(33696,'13','069',' 04','069044',69044,'Guilmi','Guilmi','','CH',1,'1840-01-01','2999-12-31'),
	(33697,'13','069',' 04','069045',69045,'Lama dei Peligni','Lama dei Peligni','','CH',1,'1840-01-01','2999-12-31'),
	(33698,'13','069',' 04','069046',69046,'Lanciano','Lanciano','','CH',1,'1840-01-01','2999-12-31'),
	(33699,'13','069',' 04','069047',69047,'Lentella','Lentella','','CH',1,'1840-01-01','2999-12-31'),
	(33700,'13','069',' 04','069048',69048,'Lettopalena','Lettopalena','','CH',1,'1840-01-01','2999-12-31'),
	(33701,'13','069',' 04','069049',69049,'Liscia','Liscia','','CH',1,'1840-01-01','2999-12-31'),
	(33702,'13','069',' 05','069050',69050,'Miglianico','Miglianico','','CH',1,'1840-01-01','2999-12-31'),
	(33703,'13','069',' 05','069051',69051,'Montazzoli','Montazzoli','','CH',1,'1840-01-01','2999-12-31'),
	(33704,'13','069',' 05','069052',69052,'Monteferrante','Monteferrante','','CH',1,'1840-01-01','2999-12-31'),
	(33705,'13','069',' 05','069053',69053,'Montelapiano','Montelapiano','','CH',1,'1840-01-01','2999-12-31'),
	(33706,'13','069',' 05','069054',69054,'Montenerodomo','Montenerodomo','','CH',1,'1840-01-01','2999-12-31'),
	(33707,'13','069',' 05','069055',69055,'Monteodorisio','Monteodorisio','','CH',1,'1840-01-01','2999-12-31'),
	(33708,'13','069',' 05','069056',69056,'Mozzagrogna','Mozzagrogna','','CH',1,'1840-01-01','2999-12-31'),
	(33709,'13','069',' 05','069057',69057,'Orsogna','Orsogna','','CH',1,'1840-01-01','2999-12-31'),
	(33710,'13','069',' 05','069058',69058,'Ortona','Ortona','','CH',1,'1840-01-01','2999-12-31'),
	(33711,'13','069',' 05','069059',69059,'Paglieta','Paglieta','','CH',1,'1840-01-01','2999-12-31'),
	(33712,'13','069',' 06','069060',69060,'Palena','Palena','','CH',1,'1840-01-01','2999-12-31'),
	(33713,'13','069',' 06','069061',69061,'Palmoli','Palmoli','','CH',1,'1840-01-01','2999-12-31'),
	(33714,'13','069',' 06','069062',69062,'Palombaro','Palombaro','','CH',1,'1840-01-01','2999-12-31'),
	(33715,'13','069',' 06','069063',69063,'Pennadomo','Pennadomo','','CH',1,'1840-01-01','2999-12-31'),
	(33716,'13','069',' 06','069064',69064,'Pennapiedimonte','Pennapiedimonte','','CH',1,'1840-01-01','2999-12-31'),
	(33717,'13','069',' 06','069065',69065,'Perano','Perano','','CH',1,'1840-01-01','2999-12-31'),
	(33718,'13','069',' 06','069066',69066,'Pizzoferrato','Pizzoferrato','','CH',1,'1840-01-01','2999-12-31'),
	(33719,'13','069',' 06','069067',69067,'Poggiofiorito','Poggiofiorito','','CH',1,'1840-01-01','2999-12-31'),
	(33720,'13','069',' 06','069068',69068,'Pollutri','Pollutri','','CH',1,'1840-01-01','2999-12-31'),
	(33721,'13','069',' 06','069069',69069,'Pretoro','Pretoro','','CH',1,'1840-01-01','2999-12-31'),
	(33722,'13','069',' 07','069070',69070,'Quadri','Quadri','','CH',1,'1840-01-01','2999-12-31'),
	(33723,'13','069',' 07','069071',69071,'Rapino','Rapino','','CH',1,'1840-01-01','2999-12-31'),
	(33724,'13','069',' 07','069072',69072,'Ripa Teatina','Ripa Teatina','','CH',1,'1840-01-01','2999-12-31'),
	(33725,'13','069',' 07','069073',69073,'Roccamontepiano','Roccamontepiano','','CH',1,'1840-01-01','2999-12-31'),
	(33726,'13','069',' 07','069074',69074,'Rocca San Giovanni','Rocca San Giovanni','','CH',1,'1840-01-01','2999-12-31'),
	(33727,'13','069',' 07','069075',69075,'Roccascalegna','Roccascalegna','','CH',1,'1840-01-01','2999-12-31'),
	(33728,'13','069',' 07','069076',69076,'Roccaspinalveti','Roccaspinalveti','','CH',1,'1840-01-01','2999-12-31'),
	(33729,'13','069',' 07','069077',69077,'Roio del Sangro','Roio del Sangro','','CH',1,'1840-01-01','2999-12-31'),
	(33730,'13','069',' 07','069078',69078,'Rosello','Rosello','','CH',1,'1840-01-01','2999-12-31'),
	(33731,'13','069',' 07','069079',69079,'San Buono','San Buono','','CH',1,'1840-01-01','2999-12-31'),
	(33732,'13','069',' 08','069080',69080,'San Giovanni Lipioni','San Giovanni Lipioni','','CH',1,'1840-01-01','2999-12-31'),
	(33733,'13','069',' 08','069081',69081,'San Giovanni Teatino','San Giovanni Teatino','','CH',1,'1840-01-01','2999-12-31'),
	(33734,'13','069',' 08','069082',69082,'San Martino sulla Marrucina','San Martino sulla Marrucina','','CH',1,'1840-01-01','2999-12-31'),
	(33735,'13','069',' 08','069083',69083,'San Salvo','San Salvo','','CH',1,'1840-01-01','2999-12-31'),
	(33736,'13','069',' 08','069084',69084,'Santa Maria Imbaro','Santa Maria Imbaro','','CH',1,'1840-01-01','2999-12-31'),
	(33737,'13','069',' 08','069085',69085,'Sant\'Eusanio del Sangro','Sant\'Eusanio del Sangro','','CH',1,'1840-01-01','2999-12-31'),
	(33738,'13','069',' 08','069086',69086,'San Vito Chietino','San Vito Chietino','','CH',1,'1840-01-01','2999-12-31'),
	(33739,'13','069',' 08','069087',69087,'Scerni','Scerni','','CH',1,'1840-01-01','2999-12-31'),
	(33740,'13','069',' 08','069088',69088,'Schiavi di Abruzzo','Schiavi di Abruzzo','','CH',1,'1840-01-01','2999-12-31'),
	(33741,'13','069',' 08','069089',69089,'Taranta Peligna','Taranta Peligna','','CH',1,'1840-01-01','2999-12-31'),
	(33742,'13','069',' 09','069090',69090,'Tollo','Tollo','','CH',1,'1840-01-01','2999-12-31'),
	(33743,'13','069',' 09','069091',69091,'Torino di Sangro','Torino di Sangro','','CH',1,'1840-01-01','2999-12-31'),
	(33744,'13','069',' 09','069092',69092,'Tornareccio','Tornareccio','','CH',1,'1840-01-01','2999-12-31'),
	(33745,'13','069',' 09','069093',69093,'Torrebruna','Torrebruna','','CH',1,'1840-01-01','2999-12-31'),
	(33746,'13','069',' 09','069094',69094,'Torrevecchia Teatina','Torrevecchia Teatina','','CH',1,'1840-01-01','2999-12-31'),
	(33747,'13','069',' 09','069095',69095,'Torricella Peligna','Torricella Peligna','','CH',1,'1840-01-01','2999-12-31'),
	(33748,'13','069',' 09','069096',69096,'Treglio','Treglio','','CH',1,'1840-01-01','2999-12-31'),
	(33749,'13','069',' 09','069097',69097,'Tufillo','Tufillo','','CH',1,'1840-01-01','2999-12-31'),
	(33750,'13','069',' 09','069098',69098,'Vacri','Vacri','','CH',1,'1840-01-01','2999-12-31'),
	(33751,'13','069',' 09','069099',69099,'Vasto','Vasto','','CH',1,'1840-01-01','2999-12-31'),
	(33752,'13','069',' 10','069100',69100,'Villalfonsina','Villalfonsina','','CH',1,'1840-01-01','2999-12-31'),
	(33753,'13','069',' 10','069101',69101,'Villamagna','Villamagna','','CH',1,'1840-01-01','2999-12-31'),
	(33754,'13','069',' 10','069102',69102,'Villa Santa Maria','Villa Santa Maria','','CH',1,'1840-01-01','2999-12-31'),
	(33755,'13','069',' 10','069103',69103,'Pietraferrazzana','Pietraferrazzana','','CH',1,'1840-01-01','2999-12-31'),
	(33756,'13','069',' 10','069104',69104,'Fallo','Fallo','','CH',1,'1840-01-01','2999-12-31'),
	(33757,'14','070',' 00','070001',70001,'Acquaviva Collecroce','Acquaviva Collecroce','','CB',1,'1840-01-01','2999-12-31'),
	(33758,'14','070',' 00','070002',70002,'Baranello','Baranello','','CB',1,'1840-01-01','2999-12-31'),
	(33759,'14','070',' 00','070003',70003,'Bojano','Bojano','','CB',1,'1840-01-01','2999-12-31'),
	(33760,'14','070',' 00','070004',70004,'Bonefro','Bonefro','','CB',1,'1840-01-01','2999-12-31'),
	(33761,'14','070',' 00','070005',70005,'Busso','Busso','','CB',1,'1840-01-01','2999-12-31'),
	(33762,'14','070',' 00','070006',70006,'Campobasso','Campobasso','','CB',1,'1840-01-01','2999-12-31'),
	(33763,'14','070',' 00','070007',70007,'Campochiaro','Campochiaro','','CB',1,'1840-01-01','2999-12-31'),
	(33764,'14','070',' 00','070008',70008,'Campodipietra','Campodipietra','','CB',1,'1840-01-01','2999-12-31'),
	(33765,'14','070',' 00','070009',70009,'Campolieto','Campolieto','','CB',1,'1840-01-01','2999-12-31'),
	(33766,'14','070',' 01','070010',70010,'Campomarino','Campomarino','','CB',1,'1840-01-01','2999-12-31'),
	(33767,'14','070',' 01','070011',70011,'Casacalenda','Casacalenda','','CB',1,'1840-01-01','2999-12-31'),
	(33768,'14','070',' 01','070012',70012,'Casalciprano','Casalciprano','','CB',1,'1840-01-01','2999-12-31'),
	(33769,'14','070',' 01','070013',70013,'Castelbottaccio','Castelbottaccio','','CB',1,'1840-01-01','2999-12-31'),
	(33770,'14','070',' 01','070014',70014,'Castellino del Biferno','Castellino del Biferno','','CB',1,'1840-01-01','2999-12-31'),
	(33771,'14','070',' 01','070015',70015,'Castelmauro','Castelmauro','','CB',1,'1840-01-01','2999-12-31'),
	(33772,'14','070',' 01','070016',70016,'Castropignano','Castropignano','','CB',1,'1840-01-01','2999-12-31'),
	(33773,'14','070',' 01','070017',70017,'Cercemaggiore','Cercemaggiore','','CB',1,'1840-01-01','2999-12-31'),
	(33774,'14','070',' 01','070018',70018,'Cercepiccola','Cercepiccola','','CB',1,'1840-01-01','2999-12-31'),
	(33775,'14','070',' 01','070019',70019,'Civitacampomarano','Civitacampomarano','','CB',1,'1840-01-01','2999-12-31'),
	(33776,'14','070',' 02','070020',70020,'Colle d\'Anchise','Colle d\'Anchise','','CB',1,'1840-01-01','2999-12-31'),
	(33777,'14','070',' 02','070021',70021,'Colletorto','Colletorto','','CB',1,'1840-01-01','2999-12-31'),
	(33778,'14','070',' 02','070022',70022,'Duronia','Duronia','','CB',1,'1840-01-01','2999-12-31'),
	(33779,'14','070',' 02','070023',70023,'Ferrazzano','Ferrazzano','','CB',1,'1840-01-01','2999-12-31'),
	(33780,'14','070',' 02','070024',70024,'Fossalto','Fossalto','','CB',1,'1840-01-01','2999-12-31'),
	(33781,'14','070',' 02','070025',70025,'Gambatesa','Gambatesa','','CB',1,'1840-01-01','2999-12-31'),
	(33782,'14','070',' 02','070026',70026,'Gildone','Gildone','','CB',1,'1840-01-01','2999-12-31'),
	(33783,'14','070',' 02','070027',70027,'Guardialfiera','Guardialfiera','','CB',1,'1840-01-01','2999-12-31'),
	(33784,'14','070',' 02','070028',70028,'Guardiaregia','Guardiaregia','','CB',1,'1840-01-01','2999-12-31'),
	(33785,'14','070',' 02','070029',70029,'Guglionesi','Guglionesi','','CB',1,'1840-01-01','2999-12-31'),
	(33786,'14','070',' 03','070030',70030,'Jelsi','Jelsi','','CB',1,'1840-01-01','2999-12-31'),
	(33787,'14','070',' 03','070031',70031,'Larino','Larino','','CB',1,'1840-01-01','2999-12-31'),
	(33788,'14','070',' 03','070032',70032,'Limosano','Limosano','','CB',1,'1840-01-01','2999-12-31'),
	(33789,'14','070',' 03','070033',70033,'Lucito','Lucito','','CB',1,'1840-01-01','2999-12-31'),
	(33790,'14','070',' 03','070034',70034,'Lupara','Lupara','','CB',1,'1840-01-01','2999-12-31'),
	(33791,'14','070',' 03','070035',70035,'Macchia Valfortore','Macchia Valfortore','','CB',1,'1840-01-01','2999-12-31'),
	(33792,'14','070',' 03','070036',70036,'Mafalda','Mafalda','','CB',1,'1840-01-01','2999-12-31'),
	(33793,'14','070',' 03','070037',70037,'Matrice','Matrice','','CB',1,'1840-01-01','2999-12-31'),
	(33794,'14','070',' 03','070038',70038,'Mirabello Sannitico','Mirabello Sannitico','','CB',1,'1840-01-01','2999-12-31'),
	(33795,'14','070',' 03','070039',70039,'Molise','Molise','','CB',1,'1840-01-01','2999-12-31'),
	(33796,'14','070',' 04','070040',70040,'Monacilioni','Monacilioni','','CB',1,'1840-01-01','2999-12-31'),
	(33797,'14','070',' 04','070041',70041,'Montagano','Montagano','','CB',1,'1840-01-01','2999-12-31'),
	(33798,'14','070',' 04','070042',70042,'Montecilfone','Montecilfone','','CB',1,'1840-01-01','2999-12-31'),
	(33799,'14','070',' 04','070043',70043,'Montefalcone nel Sannio','Montefalcone nel Sannio','','CB',1,'1840-01-01','2999-12-31'),
	(33800,'14','070',' 04','070044',70044,'Montelongo','Montelongo','','CB',1,'1840-01-01','2999-12-31'),
	(33801,'14','070',' 04','070045',70045,'Montemitro','Montemitro','','CB',1,'1840-01-01','2999-12-31'),
	(33802,'14','070',' 04','070046',70046,'Montenero di Bisaccia','Montenero di Bisaccia','','CB',1,'1840-01-01','2999-12-31'),
	(33803,'14','070',' 04','070047',70047,'Montorio nei Frentani','Montorio nei Frentani','','CB',1,'1840-01-01','2999-12-31'),
	(33804,'14','070',' 04','070048',70048,'Morrone del Sannio','Morrone del Sannio','','CB',1,'1840-01-01','2999-12-31'),
	(33805,'14','070',' 04','070049',70049,'Oratino','Oratino','','CB',1,'1840-01-01','2999-12-31'),
	(33806,'14','070',' 05','070050',70050,'Palata','Palata','','CB',1,'1840-01-01','2999-12-31'),
	(33807,'14','070',' 05','070051',70051,'Petacciato','Petacciato','','CB',1,'1840-01-01','2999-12-31'),
	(33808,'14','070',' 05','070052',70052,'Petrella Tifernina','Petrella Tifernina','','CB',1,'1840-01-01','2999-12-31'),
	(33809,'14','070',' 05','070053',70053,'Pietracatella','Pietracatella','','CB',1,'1840-01-01','2999-12-31'),
	(33810,'14','070',' 05','070054',70054,'Pietracupa','Pietracupa','','CB',1,'1840-01-01','2999-12-31'),
	(33811,'14','070',' 05','070055',70055,'Portocannone','Portocannone','','CB',1,'1840-01-01','2999-12-31'),
	(33812,'14','070',' 05','070056',70056,'Provvidenti','Provvidenti','','CB',1,'1840-01-01','2999-12-31'),
	(33813,'14','070',' 05','070057',70057,'Riccia','Riccia','','CB',1,'1840-01-01','2999-12-31'),
	(33814,'14','070',' 05','070058',70058,'Ripabottoni','Ripabottoni','','CB',1,'1840-01-01','2999-12-31'),
	(33815,'14','070',' 05','070059',70059,'Ripalimosani','Ripalimosani','','CB',1,'1840-01-01','2999-12-31'),
	(33816,'14','070',' 06','070060',70060,'Roccavivara','Roccavivara','','CB',1,'1840-01-01','2999-12-31'),
	(33817,'14','070',' 06','070061',70061,'Rotello','Rotello','','CB',1,'1840-01-01','2999-12-31'),
	(33818,'14','070',' 06','070062',70062,'Salcito','Salcito','','CB',1,'1840-01-01','2999-12-31'),
	(33819,'14','070',' 06','070063',70063,'San Biase','San Biase','','CB',1,'1840-01-01','2999-12-31'),
	(33820,'14','070',' 06','070064',70064,'San Felice del Molise','San Felice del Molise','','CB',1,'1840-01-01','2999-12-31'),
	(33821,'14','070',' 06','070065',70065,'San Giacomo degli Schiavoni','San Giacomo degli Schiavoni','','CB',1,'1840-01-01','2999-12-31'),
	(33822,'14','070',' 06','070066',70066,'San Giovanni in Galdo','San Giovanni in Galdo','','CB',1,'1840-01-01','2999-12-31'),
	(33823,'14','070',' 06','070067',70067,'San Giuliano del Sannio','San Giuliano del Sannio','','CB',1,'1840-01-01','2999-12-31'),
	(33824,'14','070',' 06','070068',70068,'San Giuliano di Puglia','San Giuliano di Puglia','','CB',1,'1840-01-01','2999-12-31'),
	(33825,'14','070',' 06','070069',70069,'San Martino in Pensilis','San Martino in Pensilis','','CB',1,'1840-01-01','2999-12-31'),
	(33826,'14','070',' 07','070070',70070,'San Massimo','San Massimo','','CB',1,'1840-01-01','2999-12-31'),
	(33827,'14','070',' 07','070071',70071,'San Polo Matese','San Polo Matese','','CB',1,'1840-01-01','2999-12-31'),
	(33828,'14','070',' 07','070072',70072,'Santa Croce di Magliano','Santa Croce di Magliano','','CB',1,'1840-01-01','2999-12-31'),
	(33829,'14','070',' 07','070073',70073,'Sant\'Angelo Limosano','Sant\'Angelo Limosano','','CB',1,'1840-01-01','2999-12-31'),
	(33830,'14','070',' 07','070074',70074,'Sant\'Elia a Pianisi','Sant\'Elia a Pianisi','','CB',1,'1840-01-01','2999-12-31'),
	(33831,'14','070',' 07','070075',70075,'Sepino','Sepino','','CB',1,'1840-01-01','2999-12-31'),
	(33832,'14','070',' 07','070076',70076,'Spinete','Spinete','','CB',1,'1840-01-01','2999-12-31'),
	(33833,'14','070',' 07','070077',70077,'Tavenna','Tavenna','','CB',1,'1840-01-01','2999-12-31'),
	(33834,'14','070',' 07','070078',70078,'Termoli','Termoli','','CB',1,'1840-01-01','2999-12-31'),
	(33835,'14','070',' 07','070079',70079,'Torella del Sannio','Torella del Sannio','','CB',1,'1840-01-01','2999-12-31'),
	(33836,'14','070',' 08','070080',70080,'Toro','Toro','','CB',1,'1840-01-01','2999-12-31'),
	(33837,'14','070',' 08','070081',70081,'Trivento','Trivento','','CB',1,'1840-01-01','2999-12-31'),
	(33838,'14','070',' 08','070082',70082,'Tufara','Tufara','','CB',1,'1840-01-01','2999-12-31'),
	(33839,'14','070',' 08','070083',70083,'Ururi','Ururi','','CB',1,'1840-01-01','2999-12-31'),
	(33840,'14','070',' 08','070084',70084,'Vinchiaturo','Vinchiaturo','','CB',1,'1840-01-01','2999-12-31'),
	(33841,'16','071',' 00','071001',71001,'Accadia','Accadia','','FG',1,'1840-01-01','2999-12-31'),
	(33842,'16','071',' 00','071002',71002,'Alberona','Alberona','','FG',1,'1840-01-01','2999-12-31'),
	(33843,'16','071',' 00','071003',71003,'Anzano di Puglia','Anzano di Puglia','','FG',1,'1840-01-01','2999-12-31'),
	(33844,'16','071',' 00','071004',71004,'Apricena','Apricena','','FG',1,'1840-01-01','2999-12-31'),
	(33845,'16','071',' 00','071005',71005,'Ascoli Satriano','Ascoli Satriano','','FG',1,'1840-01-01','2999-12-31'),
	(33846,'16','071',' 00','071006',71006,'Biccari','Biccari','','FG',1,'1840-01-01','2999-12-31'),
	(33847,'16','071',' 00','071007',71007,'Bovino','Bovino','','FG',1,'1840-01-01','2999-12-31'),
	(33848,'16','071',' 00','071008',71008,'Cagnano Varano','Cagnano Varano','','FG',1,'1840-01-01','2999-12-31'),
	(33849,'16','071',' 00','071009',71009,'Candela','Candela','','FG',1,'1840-01-01','2999-12-31'),
	(33850,'16','071',' 01','071010',71010,'Carapelle','Carapelle','','FG',1,'1840-01-01','2999-12-31'),
	(33851,'16','071',' 01','071011',71011,'Carlantino','Carlantino','','FG',1,'1840-01-01','2999-12-31'),
	(33852,'16','071',' 01','071012',71012,'Carpino','Carpino','','FG',1,'1840-01-01','2999-12-31'),
	(33853,'16','071',' 01','071013',71013,'Casalnuovo Monterotaro','Casalnuovo Monterotaro','','FG',1,'1840-01-01','2999-12-31'),
	(33854,'16','071',' 01','071014',71014,'Casalvecchio di Puglia','Casalvecchio di Puglia','','FG',1,'1840-01-01','2999-12-31'),
	(33855,'16','071',' 01','071015',71015,'Castelluccio dei Sauri','Castelluccio dei Sauri','','FG',1,'1840-01-01','2999-12-31'),
	(33856,'16','071',' 01','071016',71016,'Castelluccio Valmaggiore','Castelluccio Valmaggiore','','FG',1,'1840-01-01','2999-12-31'),
	(33857,'16','071',' 01','071017',71017,'Castelnuovo della Daunia','Castelnuovo della Daunia','','FG',1,'1840-01-01','2999-12-31'),
	(33858,'16','071',' 01','071018',71018,'Celenza Valfortore','Celenza Valfortore','','FG',1,'1840-01-01','2999-12-31'),
	(33859,'16','071',' 01','071019',71019,'Celle di San Vito','Celle di San Vito','','FG',1,'1840-01-01','2999-12-31'),
	(33860,'16','071',' 02','071020',71020,'Cerignola','Cerignola','','FG',1,'1840-01-01','2999-12-31'),
	(33861,'16','071',' 02','071021',71021,'Chieuti','Chieuti','','FG',1,'1840-01-01','2999-12-31'),
	(33862,'16','071',' 02','071022',71022,'Deliceto','Deliceto','','FG',1,'1840-01-01','2999-12-31'),
	(33863,'16','071',' 02','071023',71023,'Faeto','Faeto','','FG',1,'1840-01-01','2999-12-31'),
	(33864,'16','071',' 02','071024',71024,'Foggia','Foggia','','FG',1,'1840-01-01','2999-12-31'),
	(33865,'16','071',' 02','071025',71025,'Ischitella','Ischitella','','FG',1,'1840-01-01','2999-12-31'),
	(33866,'16','071',' 02','071026',71026,'Isole Tremiti','Isole Tremiti','','FG',1,'1840-01-01','2999-12-31'),
	(33867,'16','071',' 02','071027',71027,'Lesina','Lesina','','FG',1,'1840-01-01','2999-12-31'),
	(33868,'16','071',' 02','071028',71028,'Lucera','Lucera','','FG',1,'1840-01-01','2999-12-31'),
	(33869,'16','071',' 02','071029',71029,'Manfredonia','Manfredonia','','FG',1,'1840-01-01','2999-12-31'),
	(33870,'16','071',' 03','071031',71031,'Mattinata','Mattinata','','FG',1,'1840-01-01','2999-12-31'),
	(33871,'16','071',' 03','071032',71032,'Monteleone di Puglia','Monteleone di Puglia','','FG',1,'1840-01-01','2999-12-31'),
	(33872,'16','071',' 03','071033',71033,'Monte Sant\'Angelo','Monte Sant\'Angelo','','FG',1,'1840-01-01','2999-12-31'),
	(33873,'16','071',' 03','071034',71034,'Motta Montecorvino','Motta Montecorvino','','FG',1,'1840-01-01','2999-12-31'),
	(33874,'16','071',' 03','071035',71035,'Orsara di Puglia','Orsara di Puglia','','FG',1,'1840-01-01','2999-12-31'),
	(33875,'16','071',' 03','071036',71036,'Orta Nova','Orta Nova','','FG',1,'1840-01-01','2999-12-31'),
	(33876,'16','071',' 03','071037',71037,'Panni','Panni','','FG',1,'1840-01-01','2999-12-31'),
	(33877,'16','071',' 03','071038',71038,'Peschici','Peschici','','FG',1,'1840-01-01','2999-12-31'),
	(33878,'16','071',' 03','071039',71039,'Pietramontecorvino','Pietramontecorvino','','FG',1,'1840-01-01','2999-12-31'),
	(33879,'16','071',' 04','071040',71040,'Poggio Imperiale','Poggio Imperiale','','FG',1,'1840-01-01','2999-12-31'),
	(33880,'16','071',' 04','071041',71041,'Rignano Garganico','Rignano Garganico','','FG',1,'1840-01-01','2999-12-31'),
	(33881,'16','071',' 04','071042',71042,'Rocchetta Sant\'Antonio','Rocchetta Sant\'Antonio','','FG',1,'1840-01-01','2999-12-31'),
	(33882,'16','071',' 04','071043',71043,'Rodi Garganico','Rodi Garganico','','FG',1,'1840-01-01','2999-12-31'),
	(33883,'16','071',' 04','071044',71044,'Roseto Valfortore','Roseto Valfortore','','FG',1,'1840-01-01','2999-12-31'),
	(33884,'16','071',' 04','071046',71046,'San Giovanni Rotondo','San Giovanni Rotondo','','FG',1,'1840-01-01','2999-12-31'),
	(33885,'16','071',' 04','071047',71047,'San Marco in Lamis','San Marco in Lamis','','FG',1,'1840-01-01','2999-12-31'),
	(33886,'16','071',' 04','071048',71048,'San Marco la Catola','San Marco la Catola','','FG',1,'1840-01-01','2999-12-31'),
	(33887,'16','071',' 04','071049',71049,'San Nicandro Garganico','San Nicandro Garganico','','FG',1,'1840-01-01','2999-12-31'),
	(33888,'16','071',' 05','071050',71050,'San Paolo di Civitate','San Paolo di Civitate','','FG',1,'1840-01-01','2999-12-31'),
	(33889,'16','071',' 05','071051',71051,'San Severo','San Severo','','FG',1,'1840-01-01','2999-12-31'),
	(33890,'16','071',' 05','071052',71052,'Sant\'Agata di Puglia','Sant\'Agata di Puglia','','FG',1,'1840-01-01','2999-12-31'),
	(33891,'16','071',' 05','071053',71053,'Serracapriola','Serracapriola','','FG',1,'1840-01-01','2999-12-31'),
	(33892,'16','071',' 05','071054',71054,'Stornara','Stornara','','FG',1,'1840-01-01','2999-12-31'),
	(33893,'16','071',' 05','071055',71055,'Stornarella','Stornarella','','FG',1,'1840-01-01','2999-12-31'),
	(33894,'16','071',' 05','071056',71056,'Torremaggiore','Torremaggiore','','FG',1,'1840-01-01','2999-12-31'),
	(33895,'16','071',' 05','071058',71058,'Troia','Troia','','FG',1,'1840-01-01','2999-12-31'),
	(33896,'16','071',' 05','071059',71059,'Vico del Gargano','Vico del Gargano','','FG',1,'1840-01-01','2999-12-31'),
	(33897,'16','071',' 06','071060',71060,'Vieste','Vieste','','FG',1,'1840-01-01','2999-12-31'),
	(33898,'16','071',' 06','071061',71061,'Volturara Appula','Volturara Appula','','FG',1,'1840-01-01','2999-12-31'),
	(33899,'16','071',' 06','071062',71062,'Volturino','Volturino','','FG',1,'1840-01-01','2999-12-31'),
	(33900,'16','071',' 06','071063',71063,'Ordona','Ordona','','FG',1,'1840-01-01','2999-12-31'),
	(33901,'16','071',' 06','071064',71064,'Zapponeta','Zapponeta','','FG',1,'1840-01-01','2999-12-31'),
	(33902,'16','072',' 00','072001',72001,'Acquaviva delle Fonti','Acquaviva delle Fonti','','BA',1,'1840-01-01','2999-12-31'),
	(33903,'16','072',' 00','072002',72002,'Adelfia','Adelfia','','BA',1,'1840-01-01','2999-12-31'),
	(33904,'16','072',' 00','072003',72003,'Alberobello','Alberobello','','BA',1,'1840-01-01','2999-12-31'),
	(33905,'16','072',' 00','072004',72004,'Altamura','Altamura','','BA',1,'1840-01-01','2999-12-31'),
	(33906,'16','072',' 00','072006',72006,'Bari','Bari','','BA',1,'1840-01-01','2999-12-31'),
	(33907,'16','072',' 00','072008',72008,'Binetto','Binetto','','BA',1,'1840-01-01','2999-12-31'),
	(33908,'16','072',' 01','072010',72010,'Bitetto','Bitetto','','BA',1,'1840-01-01','2999-12-31'),
	(33909,'16','072',' 01','072011',72011,'Bitonto','Bitonto','','BA',1,'1840-01-01','2999-12-31'),
	(33910,'16','072',' 01','072012',72012,'Bitritto','Bitritto','','BA',1,'1840-01-01','2999-12-31'),
	(33911,'16','072',' 01','072014',72014,'Capurso','Capurso','','BA',1,'1840-01-01','2999-12-31'),
	(33912,'16','072',' 01','072015',72015,'Casamassima','Casamassima','','BA',1,'1840-01-01','2999-12-31'),
	(33913,'16','072',' 01','072016',72016,'Cassano delle Murge','Cassano delle Murge','','BA',1,'1840-01-01','2999-12-31'),
	(33914,'16','072',' 01','072017',72017,'Castellana Grotte','Castellana Grotte','','BA',1,'1840-01-01','2999-12-31'),
	(33915,'16','072',' 01','072018',72018,'Cellamare','Cellamare','','BA',1,'1840-01-01','2999-12-31'),
	(33916,'16','072',' 01','072019',72019,'Conversano','Conversano','','BA',1,'1840-01-01','2999-12-31'),
	(33917,'16','072',' 02','072020',72020,'Corato','Corato','','BA',1,'1840-01-01','2999-12-31'),
	(33918,'16','072',' 02','072021',72021,'Gioia del Colle','Gioia del Colle','','BA',1,'1840-01-01','2999-12-31'),
	(33919,'16','072',' 02','072022',72022,'Giovinazzo','Giovinazzo','','BA',1,'1840-01-01','2999-12-31'),
	(33920,'16','072',' 02','072023',72023,'Gravina in Puglia','Gravina in Puglia','','BA',1,'1840-01-01','2999-12-31'),
	(33921,'16','072',' 02','072024',72024,'Grumo Appula','Grumo Appula','','BA',1,'1840-01-01','2999-12-31'),
	(33922,'16','072',' 02','072025',72025,'Locorotondo','Locorotondo','','BA',1,'1840-01-01','2999-12-31'),
	(33923,'16','072',' 02','072027',72027,'Modugno','Modugno','','BA',1,'1840-01-01','2999-12-31'),
	(33924,'16','072',' 02','072028',72028,'Mola di Bari','Mola di Bari','','BA',1,'1840-01-01','2999-12-31'),
	(33925,'16','072',' 02','072029',72029,'Molfetta','Molfetta','','BA',1,'1840-01-01','2999-12-31'),
	(33926,'16','072',' 03','072030',72030,'Monopoli','Monopoli','','BA',1,'1840-01-01','2999-12-31'),
	(33927,'16','072',' 03','072031',72031,'Noci','Noci','','BA',1,'1840-01-01','2999-12-31'),
	(33928,'16','072',' 03','072032',72032,'Noicattaro','Noicattaro','','BA',1,'1840-01-01','2999-12-31'),
	(33929,'16','072',' 03','072033',72033,'Palo del Colle','Palo del Colle','','BA',1,'1840-01-01','2999-12-31'),
	(33930,'16','072',' 03','072034',72034,'Poggiorsini','Poggiorsini','','BA',1,'1840-01-01','2999-12-31'),
	(33931,'16','072',' 03','072035',72035,'Polignano a Mare','Polignano a Mare','','BA',1,'1840-01-01','2999-12-31'),
	(33932,'16','072',' 03','072036',72036,'Putignano','Putignano','','BA',1,'1840-01-01','2999-12-31'),
	(33933,'16','072',' 03','072037',72037,'Rutigliano','Rutigliano','','BA',1,'1840-01-01','2999-12-31'),
	(33934,'16','072',' 03','072038',72038,'Ruvo di Puglia','Ruvo di Puglia','','BA',1,'1840-01-01','2999-12-31'),
	(33935,'16','072',' 03','072039',72039,'Sammichele di Bari','Sammichele di Bari','','BA',1,'1840-01-01','2999-12-31'),
	(33936,'16','072',' 04','072040',72040,'Sannicandro di Bari','Sannicandro di Bari','','BA',1,'1840-01-01','2999-12-31'),
	(33937,'16','072',' 04','072041',72041,'Santeramo in Colle','Santeramo in Colle','','BA',1,'1840-01-01','2999-12-31'),
	(33938,'16','072',' 04','072043',72043,'Terlizzi','Terlizzi','','BA',1,'1840-01-01','2999-12-31'),
	(33939,'16','072',' 04','072044',72044,'Toritto','Toritto','','BA',1,'1840-01-01','2999-12-31'),
	(33940,'16','072',' 04','072046',72046,'Triggiano','Triggiano','','BA',1,'1840-01-01','2999-12-31'),
	(33941,'16','072',' 04','072047',72047,'Turi','Turi','','BA',1,'1840-01-01','2999-12-31'),
	(33942,'16','072',' 04','072048',72048,'Valenzano','Valenzano','','BA',1,'1840-01-01','2999-12-31'),
	(33943,'16','073',' 00','073001',73001,'Avetrana','Avetrana','','TA',1,'1840-01-01','2999-12-31'),
	(33944,'16','073',' 00','073002',73002,'Carosino','Carosino','','TA',1,'1840-01-01','2999-12-31'),
	(33945,'16','073',' 00','073003',73003,'Castellaneta','Castellaneta','','TA',1,'1840-01-01','2999-12-31'),
	(33946,'16','073',' 00','073004',73004,'Crispiano','Crispiano','','TA',1,'1840-01-01','2999-12-31'),
	(33947,'16','073',' 00','073005',73005,'Faggiano','Faggiano','','TA',1,'1840-01-01','2999-12-31'),
	(33948,'16','073',' 00','073006',73006,'Fragagnano','Fragagnano','','TA',1,'1840-01-01','2999-12-31'),
	(33949,'16','073',' 00','073007',73007,'Ginosa','Ginosa','','TA',1,'1840-01-01','2999-12-31'),
	(33950,'16','073',' 00','073008',73008,'Grottaglie','Grottaglie','','TA',1,'1840-01-01','2999-12-31'),
	(33951,'16','073',' 00','073009',73009,'Laterza','Laterza','','TA',1,'1840-01-01','2999-12-31'),
	(33952,'16','073',' 01','073010',73010,'Leporano','Leporano','','TA',1,'1840-01-01','2999-12-31'),
	(33953,'16','073',' 01','073011',73011,'Lizzano','Lizzano','','TA',1,'1840-01-01','2999-12-31'),
	(33954,'16','073',' 01','073012',73012,'Manduria','Manduria','','TA',1,'1840-01-01','2999-12-31'),
	(33955,'16','073',' 01','073013',73013,'Martina Franca','Martina Franca','','TA',1,'1840-01-01','2999-12-31'),
	(33956,'16','073',' 01','073014',73014,'Maruggio','Maruggio','','TA',1,'1840-01-01','2999-12-31'),
	(33957,'16','073',' 01','073015',73015,'Massafra','Massafra','','TA',1,'1840-01-01','2999-12-31'),
	(33958,'16','073',' 01','073016',73016,'Monteiasi','Monteiasi','','TA',1,'1840-01-01','2999-12-31'),
	(33959,'16','073',' 01','073017',73017,'Montemesola','Montemesola','','TA',1,'1840-01-01','2999-12-31'),
	(33960,'16','073',' 01','073018',73018,'Monteparano','Monteparano','','TA',1,'1840-01-01','2999-12-31'),
	(33961,'16','073',' 01','073019',73019,'Mottola','Mottola','','TA',1,'1840-01-01','2999-12-31'),
	(33962,'16','073',' 02','073020',73020,'Palagianello','Palagianello','','TA',1,'1840-01-01','2999-12-31'),
	(33963,'16','073',' 02','073021',73021,'Palagiano','Palagiano','','TA',1,'1840-01-01','2999-12-31'),
	(33964,'16','073',' 02','073022',73022,'Pulsano','Pulsano','','TA',1,'1840-01-01','2999-12-31'),
	(33965,'16','073',' 02','073023',73023,'Roccaforzata','Roccaforzata','','TA',1,'1840-01-01','2999-12-31'),
	(33966,'16','073',' 02','073024',73024,'San Giorgio Ionico','San Giorgio Ionico','','TA',1,'1840-01-01','2999-12-31'),
	(33967,'16','073',' 02','073025',73025,'San Marzano di San Giuseppe','San Marzano di San Giuseppe','','TA',1,'1840-01-01','2999-12-31'),
	(33968,'16','073',' 02','073026',73026,'Sava','Sava','','TA',1,'1840-01-01','2999-12-31'),
	(33969,'16','073',' 02','073027',73027,'Taranto','Taranto','','TA',1,'1840-01-01','2999-12-31'),
	(33970,'16','073',' 02','073028',73028,'Torricella','Torricella','','TA',1,'1840-01-01','2999-12-31'),
	(33971,'16','073',' 02','073029',73029,'Statte','Statte','','TA',1,'1840-01-01','2999-12-31'),
	(33972,'16','074',' 00','074001',74001,'Brindisi','Brindisi','','BR',1,'1840-01-01','2999-12-31'),
	(33973,'16','074',' 00','074002',74002,'Carovigno','Carovigno','','BR',1,'1840-01-01','2999-12-31'),
	(33974,'16','074',' 00','074003',74003,'Ceglie Messapica','Ceglie Messapica','','BR',1,'1840-01-01','2999-12-31'),
	(33975,'16','074',' 00','074004',74004,'Cellino San Marco','Cellino San Marco','','BR',1,'1840-01-01','2999-12-31'),
	(33976,'16','074',' 00','074005',74005,'Cisternino','Cisternino','','BR',1,'1840-01-01','2999-12-31'),
	(33977,'16','074',' 00','074006',74006,'Erchie','Erchie','','BR',1,'1840-01-01','2999-12-31'),
	(33978,'16','074',' 00','074007',74007,'Fasano','Fasano','','BR',1,'1840-01-01','2999-12-31'),
	(33979,'16','074',' 00','074008',74008,'Francavilla Fontana','Francavilla Fontana','','BR',1,'1840-01-01','2999-12-31'),
	(33980,'16','074',' 00','074009',74009,'Latiano','Latiano','','BR',1,'1840-01-01','2999-12-31'),
	(33981,'16','074',' 01','074010',74010,'Mesagne','Mesagne','','BR',1,'1840-01-01','2999-12-31'),
	(33982,'16','074',' 01','074011',74011,'Oria','Oria','','BR',1,'1840-01-01','2999-12-31'),
	(33983,'16','074',' 01','074012',74012,'Ostuni','Ostuni','','BR',1,'1840-01-01','2999-12-31'),
	(33984,'16','074',' 01','074013',74013,'San Donaci','San Donaci','','BR',1,'1840-01-01','2999-12-31'),
	(33985,'16','074',' 01','074014',74014,'San Michele Salentino','San Michele Salentino','','BR',1,'1840-01-01','2999-12-31'),
	(33986,'16','074',' 01','074015',74015,'San Pancrazio Salentino','San Pancrazio Salentino','','BR',1,'1840-01-01','2999-12-31'),
	(33987,'16','074',' 01','074016',74016,'San Pietro Vernotico','San Pietro Vernotico','','BR',1,'1840-01-01','2999-12-31'),
	(33988,'16','074',' 01','074017',74017,'San Vito dei Normanni','San Vito dei Normanni','','BR',1,'1840-01-01','2999-12-31'),
	(33989,'16','074',' 01','074018',74018,'Torchiarolo','Torchiarolo','','BR',1,'1840-01-01','2999-12-31'),
	(33990,'16','074',' 01','074019',74019,'Torre Santa Susanna','Torre Santa Susanna','','BR',1,'1840-01-01','2999-12-31'),
	(33991,'16','074',' 02','074020',74020,'Villa Castelli','Villa Castelli','','BR',1,'1840-01-01','2999-12-31'),
	(33992,'16','075',' 00','075001',75001,'Acquarica del Capo','Acquarica del Capo','','LE',1,'1840-01-01','2999-12-31'),
	(33993,'16','075',' 00','075002',75002,'Alessano','Alessano','','LE',1,'1840-01-01','2999-12-31'),
	(33994,'16','075',' 00','075003',75003,'Alezio','Alezio','','LE',1,'1840-01-01','2999-12-31'),
	(33995,'16','075',' 00','075004',75004,'Alliste','Alliste','','LE',1,'1840-01-01','2999-12-31'),
	(33996,'16','075',' 00','075005',75005,'Andrano','Andrano','','LE',1,'1840-01-01','2999-12-31'),
	(33997,'16','075',' 00','075006',75006,'Aradeo','Aradeo','','LE',1,'1840-01-01','2999-12-31'),
	(33998,'16','075',' 00','075007',75007,'Arnesano','Arnesano','','LE',1,'1840-01-01','2999-12-31'),
	(33999,'16','075',' 00','075008',75008,'Bagnolo del Salento','Bagnolo del Salento','','LE',1,'1840-01-01','2999-12-31'),
	(34000,'16','075',' 00','075009',75009,'Botrugno','Botrugno','','LE',1,'1840-01-01','2999-12-31'),
	(34001,'16','075',' 01','075010',75010,'Calimera','Calimera','','LE',1,'1840-01-01','2999-12-31'),
	(34002,'16','075',' 01','075011',75011,'Campi Salentina','Campi Salentina','','LE',1,'1840-01-01','2999-12-31'),
	(34003,'16','075',' 01','075012',75012,'Cannole','Cannole','','LE',1,'1840-01-01','2999-12-31'),
	(34004,'16','075',' 01','075013',75013,'Caprarica di Lecce','Caprarica di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34005,'16','075',' 01','075014',75014,'Carmiano','Carmiano','','LE',1,'1840-01-01','2999-12-31'),
	(34006,'16','075',' 01','075015',75015,'Carpignano Salentino','Carpignano Salentino','','LE',1,'1840-01-01','2999-12-31'),
	(34007,'16','075',' 01','075016',75016,'Casarano','Casarano','','LE',1,'1840-01-01','2999-12-31'),
	(34008,'16','075',' 01','075017',75017,'Castri di Lecce','Castri di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34009,'16','075',' 01','075018',75018,'Castrignano de\' Greci','Castrignano de\' Greci','','LE',1,'1840-01-01','2999-12-31'),
	(34010,'16','075',' 01','075019',75019,'Castrignano del Capo','Castrignano del Capo','','LE',1,'1840-01-01','2999-12-31'),
	(34011,'16','075',' 02','075020',75020,'Cavallino','Cavallino','','LE',1,'1840-01-01','2999-12-31'),
	(34012,'16','075',' 02','075021',75021,'Collepasso','Collepasso','','LE',1,'1840-01-01','2999-12-31'),
	(34013,'16','075',' 02','075022',75022,'Copertino','Copertino','','LE',1,'1840-01-01','2999-12-31'),
	(34014,'16','075',' 02','075023',75023,'Corigliano d\'Otranto','Corigliano d\'Otranto','','LE',1,'1840-01-01','2999-12-31'),
	(34015,'16','075',' 02','075024',75024,'Corsano','Corsano','','LE',1,'1840-01-01','2999-12-31'),
	(34016,'16','075',' 02','075025',75025,'Cursi','Cursi','','LE',1,'1840-01-01','2999-12-31'),
	(34017,'16','075',' 02','075026',75026,'Cutrofiano','Cutrofiano','','LE',1,'1840-01-01','2999-12-31'),
	(34018,'16','075',' 02','075027',75027,'Diso','Diso','','LE',1,'1840-01-01','2999-12-31'),
	(34019,'16','075',' 02','075028',75028,'Gagliano del Capo','Gagliano del Capo','','LE',1,'1840-01-01','2999-12-31'),
	(34020,'16','075',' 02','075029',75029,'Galatina','Galatina','','LE',1,'1840-01-01','2999-12-31'),
	(34021,'16','075',' 03','075030',75030,'Galatone','Galatone','','LE',1,'1840-01-01','2999-12-31'),
	(34022,'16','075',' 03','075031',75031,'Gallipoli','Gallipoli','','LE',1,'1840-01-01','2999-12-31'),
	(34023,'16','075',' 03','075032',75032,'Giuggianello','Giuggianello','','LE',1,'1840-01-01','2999-12-31'),
	(34024,'16','075',' 03','075033',75033,'Giurdignano','Giurdignano','','LE',1,'1840-01-01','2999-12-31'),
	(34025,'16','075',' 03','075034',75034,'Guagnano','Guagnano','','LE',1,'1840-01-01','2999-12-31'),
	(34026,'16','075',' 03','075035',75035,'Lecce','Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34027,'16','075',' 03','075036',75036,'Lequile','Lequile','','LE',1,'1840-01-01','2999-12-31'),
	(34028,'16','075',' 03','075037',75037,'Leverano','Leverano','','LE',1,'1840-01-01','2999-12-31'),
	(34029,'16','075',' 03','075038',75038,'Lizzanello','Lizzanello','','LE',1,'1840-01-01','2999-12-31'),
	(34030,'16','075',' 03','075039',75039,'Maglie','Maglie','','LE',1,'1840-01-01','2999-12-31'),
	(34031,'16','075',' 04','075040',75040,'Martano','Martano','','LE',1,'1840-01-01','2999-12-31'),
	(34032,'16','075',' 04','075041',75041,'Martignano','Martignano','','LE',1,'1840-01-01','2999-12-31'),
	(34033,'16','075',' 04','075042',75042,'Matino','Matino','','LE',1,'1840-01-01','2999-12-31'),
	(34034,'16','075',' 04','075043',75043,'Melendugno','Melendugno','','LE',1,'1840-01-01','2999-12-31'),
	(34035,'16','075',' 04','075044',75044,'Melissano','Melissano','','LE',1,'1840-01-01','2999-12-31'),
	(34036,'16','075',' 04','075045',75045,'Melpignano','Melpignano','','LE',1,'1840-01-01','2999-12-31'),
	(34037,'16','075',' 04','075046',75046,'Miggiano','Miggiano','','LE',1,'1840-01-01','2999-12-31'),
	(34038,'16','075',' 04','075047',75047,'Minervino di Lecce','Minervino di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34039,'16','075',' 04','075048',75048,'Monteroni di Lecce','Monteroni di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34040,'16','075',' 04','075049',75049,'Montesano Salentino','Montesano Salentino','','LE',1,'1840-01-01','2999-12-31'),
	(34041,'16','075',' 05','075050',75050,'Morciano di Leuca','Morciano di Leuca','','LE',1,'1840-01-01','2999-12-31'),
	(34042,'16','075',' 05','075051',75051,'Muro Leccese','Muro Leccese','','LE',1,'1840-01-01','2999-12-31'),
	(34043,'16','075',' 05','075052',75052,'Nardò','Nardò','','LE',1,'1840-01-01','2999-12-31'),
	(34044,'16','075',' 05','075053',75053,'Neviano','Neviano','','LE',1,'1840-01-01','2999-12-31'),
	(34045,'16','075',' 05','075054',75054,'Nociglia','Nociglia','','LE',1,'1840-01-01','2999-12-31'),
	(34046,'16','075',' 05','075055',75055,'Novoli','Novoli','','LE',1,'1840-01-01','2999-12-31'),
	(34047,'16','075',' 05','075056',75056,'Ortelle','Ortelle','','LE',1,'1840-01-01','2999-12-31'),
	(34048,'16','075',' 05','075057',75057,'Otranto','Otranto','','LE',1,'1840-01-01','2999-12-31'),
	(34049,'16','075',' 05','075058',75058,'Palmariggi','Palmariggi','','LE',1,'1840-01-01','2999-12-31'),
	(34050,'16','075',' 05','075059',75059,'Parabita','Parabita','','LE',1,'1840-01-01','2999-12-31'),
	(34051,'16','075',' 06','075060',75060,'Patù','Patù','','LE',1,'1840-01-01','2999-12-31'),
	(34052,'16','075',' 06','075061',75061,'Poggiardo','Poggiardo','','LE',1,'1840-01-01','2999-12-31'),
	(34053,'16','075',' 06','075062',75062,'Presicce','Presicce','','LE',1,'1840-01-01','2999-12-31'),
	(34054,'16','075',' 06','075063',75063,'Racale','Racale','','LE',1,'1840-01-01','2999-12-31'),
	(34055,'16','075',' 06','075064',75064,'Ruffano','Ruffano','','LE',1,'1840-01-01','2999-12-31'),
	(34056,'16','075',' 06','075065',75065,'Salice Salentino','Salice Salentino','','LE',1,'1840-01-01','2999-12-31'),
	(34057,'16','075',' 06','075066',75066,'Salve','Salve','','LE',1,'1840-01-01','2999-12-31'),
	(34058,'16','075',' 06','075067',75067,'Sanarica','Sanarica','','LE',1,'1840-01-01','2999-12-31'),
	(34059,'16','075',' 06','075068',75068,'San Cesario di Lecce','San Cesario di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34060,'16','075',' 06','075069',75069,'San Donato di Lecce','San Donato di Lecce','','LE',1,'1840-01-01','2999-12-31'),
	(34061,'16','075',' 07','075070',75070,'Sannicola','Sannicola','','LE',1,'1840-01-01','2999-12-31'),
	(34062,'16','075',' 07','075071',75071,'San Pietro in Lama','San Pietro in Lama','','LE',1,'1840-01-01','2999-12-31'),
	(34063,'16','075',' 07','075072',75072,'Santa Cesarea Terme','Santa Cesarea Terme','','LE',1,'1840-01-01','2999-12-31'),
	(34064,'16','075',' 07','075073',75073,'Scorrano','Scorrano','','LE',1,'1840-01-01','2999-12-31'),
	(34065,'16','075',' 07','075074',75074,'Seclì','Seclì','','LE',1,'1840-01-01','2999-12-31'),
	(34066,'16','075',' 07','075075',75075,'Sogliano Cavour','Sogliano Cavour','','LE',1,'1840-01-01','2999-12-31'),
	(34067,'16','075',' 07','075076',75076,'Soleto','Soleto','','LE',1,'1840-01-01','2999-12-31'),
	(34068,'16','075',' 07','075077',75077,'Specchia','Specchia','','LE',1,'1840-01-01','2999-12-31'),
	(34069,'16','075',' 07','075078',75078,'Spongano','Spongano','','LE',1,'1840-01-01','2999-12-31'),
	(34070,'16','075',' 07','075079',75079,'Squinzano','Squinzano','','LE',1,'1840-01-01','2999-12-31'),
	(34071,'16','075',' 08','075080',75080,'Sternatia','Sternatia','','LE',1,'1840-01-01','2999-12-31'),
	(34072,'16','075',' 08','075081',75081,'Supersano','Supersano','','LE',1,'1840-01-01','2999-12-31'),
	(34073,'16','075',' 08','075082',75082,'Surano','Surano','','LE',1,'1840-01-01','2999-12-31'),
	(34074,'16','075',' 08','075083',75083,'Surbo','Surbo','','LE',1,'1840-01-01','2999-12-31'),
	(34075,'16','075',' 08','075084',75084,'Taurisano','Taurisano','','LE',1,'1840-01-01','2999-12-31'),
	(34076,'16','075',' 08','075085',75085,'Taviano','Taviano','','LE',1,'1840-01-01','2999-12-31'),
	(34077,'16','075',' 08','075086',75086,'Tiggiano','Tiggiano','','LE',1,'1840-01-01','2999-12-31'),
	(34078,'16','075',' 08','075087',75087,'Trepuzzi','Trepuzzi','','LE',1,'1840-01-01','2999-12-31'),
	(34079,'16','075',' 08','075088',75088,'Tricase','Tricase','','LE',1,'1840-01-01','2999-12-31'),
	(34080,'16','075',' 08','075089',75089,'Tuglie','Tuglie','','LE',1,'1840-01-01','2999-12-31'),
	(34081,'16','075',' 09','075090',75090,'Ugento','Ugento','','LE',1,'1840-01-01','2999-12-31'),
	(34082,'16','075',' 09','075091',75091,'Uggiano la Chiesa','Uggiano la Chiesa','','LE',1,'1840-01-01','2999-12-31'),
	(34083,'16','075',' 09','075092',75092,'Veglie','Veglie','','LE',1,'1840-01-01','2999-12-31'),
	(34084,'16','075',' 09','075093',75093,'Vernole','Vernole','','LE',1,'1840-01-01','2999-12-31'),
	(34085,'16','075',' 09','075094',75094,'Zollino','Zollino','','LE',1,'1840-01-01','2999-12-31'),
	(34086,'16','075',' 09','075095',75095,'San Cassiano','San Cassiano','','LE',1,'1840-01-01','2999-12-31'),
	(34087,'16','075',' 09','075096',75096,'Castro','Castro','','LE',1,'1840-01-01','2999-12-31'),
	(34088,'16','075',' 09','075097',75097,'Porto Cesareo','Porto Cesareo','','LE',1,'1840-01-01','2999-12-31'),
	(34089,'17','076',' 00','076001',76001,'Abriola','Abriola','','PZ',1,'1840-01-01','2999-12-31'),
	(34090,'17','076',' 00','076002',76002,'Acerenza','Acerenza','','PZ',1,'1840-01-01','2999-12-31'),
	(34091,'17','076',' 00','076003',76003,'Albano di Lucania','Albano di Lucania','','PZ',1,'1840-01-01','2999-12-31'),
	(34092,'17','076',' 00','076004',76004,'Anzi','Anzi','','PZ',1,'1840-01-01','2999-12-31'),
	(34093,'17','076',' 00','076005',76005,'Armento','Armento','','PZ',1,'1840-01-01','2999-12-31'),
	(34094,'17','076',' 00','076006',76006,'Atella','Atella','','PZ',1,'1840-01-01','2999-12-31'),
	(34095,'17','076',' 00','076007',76007,'Avigliano','Avigliano','','PZ',1,'1840-01-01','2999-12-31'),
	(34096,'17','076',' 00','076008',76008,'Balvano','Balvano','','PZ',1,'1840-01-01','2999-12-31'),
	(34097,'17','076',' 00','076009',76009,'Banzi','Banzi','','PZ',1,'1840-01-01','2999-12-31'),
	(34098,'17','076',' 01','076010',76010,'Baragiano','Baragiano','','PZ',1,'1840-01-01','2999-12-31'),
	(34099,'17','076',' 01','076011',76011,'Barile','Barile','','PZ',1,'1840-01-01','2999-12-31'),
	(34100,'17','076',' 01','076012',76012,'Bella','Bella','','PZ',1,'1840-01-01','2999-12-31'),
	(34101,'17','076',' 01','076013',76013,'Brienza','Brienza','','PZ',1,'1840-01-01','2999-12-31'),
	(34102,'17','076',' 01','076014',76014,'Brindisi Montagna','Brindisi Montagna','','PZ',1,'1840-01-01','2999-12-31'),
	(34103,'17','076',' 01','076015',76015,'Calvello','Calvello','','PZ',1,'1840-01-01','2999-12-31'),
	(34104,'17','076',' 01','076016',76016,'Calvera','Calvera','','PZ',1,'1840-01-01','2999-12-31'),
	(34105,'17','076',' 01','076017',76017,'Campomaggiore','Campomaggiore','','PZ',1,'1840-01-01','2999-12-31'),
	(34106,'17','076',' 01','076018',76018,'Cancellara','Cancellara','','PZ',1,'1840-01-01','2999-12-31'),
	(34107,'17','076',' 01','076019',76019,'Carbone','Carbone','','PZ',1,'1840-01-01','2999-12-31'),
	(34108,'17','076',' 02','076020',76020,'San Paolo Albanese','San Paolo Albanese','','PZ',1,'1840-01-01','2999-12-31'),
	(34109,'17','076',' 02','076021',76021,'Castelgrande','Castelgrande','','PZ',1,'1840-01-01','2999-12-31'),
	(34110,'17','076',' 02','076022',76022,'Castelluccio Inferiore','Castelluccio Inferiore','','PZ',1,'1840-01-01','2999-12-31'),
	(34111,'17','076',' 02','076023',76023,'Castelluccio Superiore','Castelluccio Superiore','','PZ',1,'1840-01-01','2999-12-31'),
	(34112,'17','076',' 02','076024',76024,'Castelmezzano','Castelmezzano','','PZ',1,'1840-01-01','2999-12-31'),
	(34113,'17','076',' 02','076025',76025,'Castelsaraceno','Castelsaraceno','','PZ',1,'1840-01-01','2999-12-31'),
	(34114,'17','076',' 02','076026',76026,'Castronuovo di Sant\'Andrea','Castronuovo di Sant\'Andrea','','PZ',1,'1840-01-01','2999-12-31'),
	(34115,'17','076',' 02','076027',76027,'Cersosimo','Cersosimo','','PZ',1,'1840-01-01','2999-12-31'),
	(34116,'17','076',' 02','076028',76028,'Chiaromonte','Chiaromonte','','PZ',1,'1840-01-01','2999-12-31'),
	(34117,'17','076',' 02','076029',76029,'Corleto Perticara','Corleto Perticara','','PZ',1,'1840-01-01','2999-12-31'),
	(34118,'17','076',' 03','076030',76030,'Episcopia','Episcopia','','PZ',1,'1840-01-01','2999-12-31'),
	(34119,'17','076',' 03','076031',76031,'Fardella','Fardella','','PZ',1,'1840-01-01','2999-12-31'),
	(34120,'17','076',' 03','076032',76032,'Filiano','Filiano','','PZ',1,'1840-01-01','2999-12-31'),
	(34121,'17','076',' 03','076033',76033,'Forenza','Forenza','','PZ',1,'1840-01-01','2999-12-31'),
	(34122,'17','076',' 03','076034',76034,'Francavilla in Sinni','Francavilla in Sinni','','PZ',1,'1840-01-01','2999-12-31'),
	(34123,'17','076',' 03','076035',76035,'Gallicchio','Gallicchio','','PZ',1,'1840-01-01','2999-12-31'),
	(34124,'17','076',' 03','076036',76036,'Genzano di Lucania','Genzano di Lucania','','PZ',1,'1840-01-01','2999-12-31'),
	(34125,'17','076',' 03','076037',76037,'Grumento Nova','Grumento Nova','','PZ',1,'1840-01-01','2999-12-31'),
	(34126,'17','076',' 03','076038',76038,'Guardia Perticara','Guardia Perticara','','PZ',1,'1840-01-01','2999-12-31'),
	(34127,'17','076',' 03','076039',76039,'Lagonegro','Lagonegro','','PZ',1,'1840-01-01','2999-12-31'),
	(34128,'17','076',' 04','076040',76040,'Latronico','Latronico','','PZ',1,'1840-01-01','2999-12-31'),
	(34129,'17','076',' 04','076041',76041,'Laurenzana','Laurenzana','','PZ',1,'1840-01-01','2999-12-31'),
	(34130,'17','076',' 04','076042',76042,'Lauria','Lauria','','PZ',1,'1840-01-01','2999-12-31'),
	(34131,'17','076',' 04','076043',76043,'Lavello','Lavello','','PZ',1,'1840-01-01','2999-12-31'),
	(34132,'17','076',' 04','076044',76044,'Maratea','Maratea','','PZ',1,'1840-01-01','2999-12-31'),
	(34133,'17','076',' 04','076045',76045,'Marsico Nuovo','Marsico Nuovo','','PZ',1,'1840-01-01','2999-12-31'),
	(34134,'17','076',' 04','076046',76046,'Marsicovetere','Marsicovetere','','PZ',1,'1840-01-01','2999-12-31'),
	(34135,'17','076',' 04','076047',76047,'Maschito','Maschito','','PZ',1,'1840-01-01','2999-12-31'),
	(34136,'17','076',' 04','076048',76048,'Melfi','Melfi','','PZ',1,'1840-01-01','2999-12-31'),
	(34137,'17','076',' 04','076049',76049,'Missanello','Missanello','','PZ',1,'1840-01-01','2999-12-31'),
	(34138,'17','076',' 05','076050',76050,'Moliterno','Moliterno','','PZ',1,'1840-01-01','2999-12-31'),
	(34139,'17','076',' 05','076051',76051,'Montemilone','Montemilone','','PZ',1,'1840-01-01','2999-12-31'),
	(34140,'17','076',' 05','076052',76052,'Montemurro','Montemurro','','PZ',1,'1840-01-01','2999-12-31'),
	(34141,'17','076',' 05','076053',76053,'Muro Lucano','Muro Lucano','','PZ',1,'1840-01-01','2999-12-31'),
	(34142,'17','076',' 05','076054',76054,'Nemoli','Nemoli','','PZ',1,'1840-01-01','2999-12-31'),
	(34143,'17','076',' 05','076055',76055,'Noepoli','Noepoli','','PZ',1,'1840-01-01','2999-12-31'),
	(34144,'17','076',' 05','076056',76056,'Oppido Lucano','Oppido Lucano','','PZ',1,'1840-01-01','2999-12-31'),
	(34145,'17','076',' 05','076057',76057,'Palazzo San Gervasio','Palazzo San Gervasio','','PZ',1,'1840-01-01','2999-12-31'),
	(34146,'17','076',' 05','076058',76058,'Pescopagano','Pescopagano','','PZ',1,'1840-01-01','2999-12-31'),
	(34147,'17','076',' 05','076059',76059,'Picerno','Picerno','','PZ',1,'1840-01-01','2999-12-31'),
	(34148,'17','076',' 06','076060',76060,'Pietragalla','Pietragalla','','PZ',1,'1840-01-01','2999-12-31'),
	(34149,'17','076',' 06','076061',76061,'Pietrapertosa','Pietrapertosa','','PZ',1,'1840-01-01','2999-12-31'),
	(34150,'17','076',' 06','076062',76062,'Pignola','Pignola','','PZ',1,'1840-01-01','2999-12-31'),
	(34151,'17','076',' 06','076063',76063,'Potenza','Potenza','','PZ',1,'1840-01-01','2999-12-31'),
	(34152,'17','076',' 06','076064',76064,'Rapolla','Rapolla','','PZ',1,'1840-01-01','2999-12-31'),
	(34153,'17','076',' 06','076065',76065,'Rapone','Rapone','','PZ',1,'1840-01-01','2999-12-31'),
	(34154,'17','076',' 06','076066',76066,'Rionero in Vulture','Rionero in Vulture','','PZ',1,'1840-01-01','2999-12-31'),
	(34155,'17','076',' 06','076067',76067,'Ripacandida','Ripacandida','','PZ',1,'1840-01-01','2999-12-31'),
	(34156,'17','076',' 06','076068',76068,'Rivello','Rivello','','PZ',1,'1840-01-01','2999-12-31'),
	(34157,'17','076',' 06','076069',76069,'Roccanova','Roccanova','','PZ',1,'1840-01-01','2999-12-31'),
	(34158,'17','076',' 07','076070',76070,'Rotonda','Rotonda','','PZ',1,'1840-01-01','2999-12-31'),
	(34159,'17','076',' 07','076071',76071,'Ruoti','Ruoti','','PZ',1,'1840-01-01','2999-12-31'),
	(34160,'17','076',' 07','076072',76072,'Ruvo del Monte','Ruvo del Monte','','PZ',1,'1840-01-01','2999-12-31'),
	(34161,'17','076',' 07','076073',76073,'San Chirico Nuovo','San Chirico Nuovo','','PZ',1,'1840-01-01','2999-12-31'),
	(34162,'17','076',' 07','076074',76074,'San Chirico Raparo','San Chirico Raparo','','PZ',1,'1840-01-01','2999-12-31'),
	(34163,'17','076',' 07','076075',76075,'San Costantino Albanese','San Costantino Albanese','','PZ',1,'1840-01-01','2999-12-31'),
	(34164,'17','076',' 07','076076',76076,'San Fele','San Fele','','PZ',1,'1840-01-01','2999-12-31'),
	(34165,'17','076',' 07','076077',76077,'San Martino d\'Agri','San Martino d\'Agri','','PZ',1,'1840-01-01','2999-12-31'),
	(34166,'17','076',' 07','076078',76078,'San Severino Lucano','San Severino Lucano','','PZ',1,'1840-01-01','2999-12-31'),
	(34167,'17','076',' 07','076079',76079,'Sant\'Angelo Le Fratte','Sant\'Angelo Le Fratte','','PZ',1,'1840-01-01','2999-12-31'),
	(34168,'17','076',' 08','076080',76080,'Sant\'Arcangelo','Sant\'Arcangelo','','PZ',1,'1840-01-01','2999-12-31'),
	(34169,'17','076',' 08','076081',76081,'Sarconi','Sarconi','','PZ',1,'1840-01-01','2999-12-31'),
	(34170,'17','076',' 08','076082',76082,'Sasso di Castalda','Sasso di Castalda','','PZ',1,'1840-01-01','2999-12-31'),
	(34171,'17','076',' 08','076083',76083,'Satriano di Lucania','Satriano di Lucania','','PZ',1,'1840-01-01','2999-12-31'),
	(34172,'17','076',' 08','076084',76084,'Savoia di Lucania','Savoia di Lucania','','PZ',1,'1840-01-01','2999-12-31'),
	(34173,'17','076',' 08','076085',76085,'Senise','Senise','','PZ',1,'1840-01-01','2999-12-31'),
	(34174,'17','076',' 08','076086',76086,'Spinoso','Spinoso','','PZ',1,'1840-01-01','2999-12-31'),
	(34175,'17','076',' 08','076087',76087,'Teana','Teana','','PZ',1,'1840-01-01','2999-12-31'),
	(34176,'17','076',' 08','076088',76088,'Terranova di Pollino','Terranova di Pollino','','PZ',1,'1840-01-01','2999-12-31'),
	(34177,'17','076',' 08','076089',76089,'Tito','Tito','','PZ',1,'1840-01-01','2999-12-31'),
	(34178,'17','076',' 09','076090',76090,'Tolve','Tolve','','PZ',1,'1840-01-01','2999-12-31'),
	(34179,'17','076',' 09','076091',76091,'Tramutola','Tramutola','','PZ',1,'1840-01-01','2999-12-31'),
	(34180,'17','076',' 09','076092',76092,'Trecchina','Trecchina','','PZ',1,'1840-01-01','2999-12-31'),
	(34181,'17','076',' 09','076093',76093,'Trivigno','Trivigno','','PZ',1,'1840-01-01','2999-12-31'),
	(34182,'17','076',' 09','076094',76094,'Vaglio Basilicata','Vaglio Basilicata','','PZ',1,'1840-01-01','2999-12-31'),
	(34183,'17','076',' 09','076095',76095,'Venosa','Venosa','','PZ',1,'1840-01-01','2999-12-31'),
	(34184,'17','076',' 09','076096',76096,'Vietri di Potenza','Vietri di Potenza','','PZ',1,'1840-01-01','2999-12-31'),
	(34185,'17','076',' 09','076097',76097,'Viggianello','Viggianello','','PZ',1,'1840-01-01','2999-12-31'),
	(34186,'17','076',' 09','076098',76098,'Viggiano','Viggiano','','PZ',1,'1840-01-01','2999-12-31'),
	(34187,'17','076',' 09','076099',76099,'Ginestra','Ginestra','','PZ',1,'1840-01-01','2999-12-31'),
	(34188,'17','076',' 10','076100',76100,'Paterno','Paterno','','PZ',1,'1840-01-01','2999-12-31'),
	(34189,'17','077',' 00','077001',77001,'Accettura','Accettura','','MT',1,'1840-01-01','2999-12-31'),
	(34190,'17','077',' 00','077002',77002,'Aliano','Aliano','','MT',1,'1840-01-01','2999-12-31'),
	(34191,'17','077',' 00','077003',77003,'Bernalda','Bernalda','','MT',1,'1840-01-01','2999-12-31'),
	(34192,'17','077',' 00','077004',77004,'Calciano','Calciano','','MT',1,'1840-01-01','2999-12-31'),
	(34193,'17','077',' 00','077005',77005,'Cirigliano','Cirigliano','','MT',1,'1840-01-01','2999-12-31'),
	(34194,'17','077',' 00','077006',77006,'Colobraro','Colobraro','','MT',1,'1840-01-01','2999-12-31'),
	(34195,'17','077',' 00','077007',77007,'Craco','Craco','','MT',1,'1840-01-01','2999-12-31'),
	(34196,'17','077',' 00','077008',77008,'Ferrandina','Ferrandina','','MT',1,'1840-01-01','2999-12-31'),
	(34197,'17','077',' 00','077009',77009,'Garaguso','Garaguso','','MT',1,'1840-01-01','2999-12-31'),
	(34198,'17','077',' 01','077010',77010,'Gorgoglione','Gorgoglione','','MT',1,'1840-01-01','2999-12-31'),
	(34199,'17','077',' 01','077011',77011,'Grassano','Grassano','','MT',1,'1840-01-01','2999-12-31'),
	(34200,'17','077',' 01','077012',77012,'Grottole','Grottole','','MT',1,'1840-01-01','2999-12-31'),
	(34201,'17','077',' 01','077013',77013,'Irsina','Irsina','','MT',1,'1840-01-01','2999-12-31'),
	(34202,'17','077',' 01','077014',77014,'Matera','Matera','','MT',1,'1840-01-01','2999-12-31'),
	(34203,'17','077',' 01','077015',77015,'Miglionico','Miglionico','','MT',1,'1840-01-01','2999-12-31'),
	(34204,'17','077',' 01','077016',77016,'Montalbano Jonico','Montalbano Jonico','','MT',1,'1840-01-01','2999-12-31'),
	(34205,'17','077',' 01','077017',77017,'Montescaglioso','Montescaglioso','','MT',1,'1840-01-01','2999-12-31'),
	(34206,'17','077',' 01','077018',77018,'Nova Siri','Nova Siri','','MT',1,'1840-01-01','2999-12-31'),
	(34207,'17','077',' 01','077019',77019,'Oliveto Lucano','Oliveto Lucano','','MT',1,'1840-01-01','2999-12-31'),
	(34208,'17','077',' 02','077020',77020,'Pisticci','Pisticci','','MT',1,'1840-01-01','2999-12-31'),
	(34209,'17','077',' 02','077021',77021,'Policoro','Policoro','','MT',1,'1840-01-01','2999-12-31'),
	(34210,'17','077',' 02','077022',77022,'Pomarico','Pomarico','','MT',1,'1840-01-01','2999-12-31'),
	(34211,'17','077',' 02','077023',77023,'Rotondella','Rotondella','','MT',1,'1840-01-01','2999-12-31'),
	(34212,'17','077',' 02','077024',77024,'Salandra','Salandra','','MT',1,'1840-01-01','2999-12-31'),
	(34213,'17','077',' 02','077025',77025,'San Giorgio Lucano','San Giorgio Lucano','','MT',1,'1840-01-01','2999-12-31'),
	(34214,'17','077',' 02','077026',77026,'San Mauro Forte','San Mauro Forte','','MT',1,'1840-01-01','2999-12-31'),
	(34215,'17','077',' 02','077027',77027,'Stigliano','Stigliano','','MT',1,'1840-01-01','2999-12-31'),
	(34216,'17','077',' 02','077028',77028,'Tricarico','Tricarico','','MT',1,'1840-01-01','2999-12-31'),
	(34217,'17','077',' 02','077029',77029,'Tursi','Tursi','','MT',1,'1840-01-01','2999-12-31'),
	(34218,'17','077',' 03','077030',77030,'Valsinni','Valsinni','','MT',1,'1840-01-01','2999-12-31'),
	(34219,'17','077',' 03','077031',77031,'Scanzano Jonico','Scanzano Jonico','','MT',1,'1840-01-01','2999-12-31'),
	(34220,'18','078',' 00','078001',78001,'Acquaformosa','Acquaformosa','','CS',1,'1840-01-01','2999-12-31'),
	(34221,'18','078',' 00','078002',78002,'Acquappesa','Acquappesa','','CS',1,'1840-01-01','2999-12-31'),
	(34222,'18','078',' 00','078003',78003,'Acri','Acri','','CS',1,'1840-01-01','2999-12-31'),
	(34223,'18','078',' 00','078004',78004,'Aiello Calabro','Aiello Calabro','','CS',1,'1840-01-01','2999-12-31'),
	(34224,'18','078',' 00','078005',78005,'Aieta','Aieta','','CS',1,'1840-01-01','2999-12-31'),
	(34225,'18','078',' 00','078006',78006,'Albidona','Albidona','','CS',1,'1840-01-01','2999-12-31'),
	(34226,'18','078',' 00','078007',78007,'Alessandria del Carretto','Alessandria del Carretto','','CS',1,'1840-01-01','2999-12-31'),
	(34227,'18','078',' 00','078008',78008,'Altilia','Altilia','','CS',1,'1840-01-01','2999-12-31'),
	(34228,'18','078',' 00','078009',78009,'Altomonte','Altomonte','','CS',1,'1840-01-01','2999-12-31'),
	(34229,'18','078',' 01','078010',78010,'Amantea','Amantea','','CS',1,'1840-01-01','2999-12-31'),
	(34230,'18','078',' 01','078011',78011,'Amendolara','Amendolara','','CS',1,'1840-01-01','2999-12-31'),
	(34231,'18','078',' 01','078012',78012,'Aprigliano','Aprigliano','','CS',1,'1840-01-01','2999-12-31'),
	(34232,'18','078',' 01','078013',78013,'Belmonte Calabro','Belmonte Calabro','','CS',1,'1840-01-01','2999-12-31'),
	(34233,'18','078',' 01','078014',78014,'Belsito','Belsito','','CS',1,'1840-01-01','2999-12-31'),
	(34234,'18','078',' 01','078015',78015,'Belvedere Marittimo','Belvedere Marittimo','','CS',1,'1840-01-01','2999-12-31'),
	(34235,'18','078',' 01','078016',78016,'Bianchi','Bianchi','','CS',1,'1840-01-01','2999-12-31'),
	(34236,'18','078',' 01','078017',78017,'Bisignano','Bisignano','','CS',1,'1840-01-01','2999-12-31'),
	(34237,'18','078',' 01','078018',78018,'Bocchigliero','Bocchigliero','','CS',1,'1840-01-01','2999-12-31'),
	(34238,'18','078',' 01','078019',78019,'Bonifati','Bonifati','','CS',1,'1840-01-01','2999-12-31'),
	(34239,'18','078',' 02','078020',78020,'Buonvicino','Buonvicino','','CS',1,'1840-01-01','2999-12-31'),
	(34240,'18','078',' 02','078021',78021,'Calopezzati','Calopezzati','','CS',1,'1840-01-01','2999-12-31'),
	(34241,'18','078',' 02','078022',78022,'Caloveto','Caloveto','','CS',1,'1840-01-01','2999-12-31'),
	(34242,'18','078',' 02','078023',78023,'Campana','Campana','','CS',1,'1840-01-01','2999-12-31'),
	(34243,'18','078',' 02','078024',78024,'Canna','Canna','','CS',1,'1840-01-01','2999-12-31'),
	(34244,'18','078',' 02','078025',78025,'Cariati','Cariati','','CS',1,'1840-01-01','2999-12-31'),
	(34245,'18','078',' 02','078026',78026,'Carolei','Carolei','','CS',1,'1840-01-01','2999-12-31'),
	(34246,'18','078',' 02','078027',78027,'Carpanzano','Carpanzano','','CS',1,'1840-01-01','2999-12-31'),
	(34247,'18','078',' 02','078028',78028,'Casole Bruzio','Casole Bruzio','','CS',1,'1840-01-01','2999-12-31'),
	(34248,'18','078',' 02','078029',78029,'Cassano all\'Ionio','Cassano all\'Ionio','','CS',1,'1840-01-01','2999-12-31'),
	(34249,'18','078',' 03','078030',78030,'Castiglione Cosentino','Castiglione Cosentino','','CS',1,'1840-01-01','2999-12-31'),
	(34250,'18','078',' 03','078031',78031,'Castrolibero','Castrolibero','','CS',1,'1840-01-01','2999-12-31'),
	(34251,'18','078',' 03','078032',78032,'Castroregio','Castroregio','','CS',1,'1840-01-01','2999-12-31'),
	(34252,'18','078',' 03','078033',78033,'Castrovillari','Castrovillari','','CS',1,'1840-01-01','2999-12-31'),
	(34253,'18','078',' 03','078034',78034,'Celico','Celico','','CS',1,'1840-01-01','2999-12-31'),
	(34254,'18','078',' 03','078035',78035,'Cellara','Cellara','','CS',1,'1840-01-01','2999-12-31'),
	(34255,'18','078',' 03','078036',78036,'Cerchiara di Calabria','Cerchiara di Calabria','','CS',1,'1840-01-01','2999-12-31'),
	(34256,'18','078',' 03','078037',78037,'Cerisano','Cerisano','','CS',1,'1840-01-01','2999-12-31'),
	(34257,'18','078',' 03','078038',78038,'Cervicati','Cervicati','','CS',1,'1840-01-01','2999-12-31'),
	(34258,'18','078',' 03','078039',78039,'Cerzeto','Cerzeto','','CS',1,'1840-01-01','2999-12-31'),
	(34259,'18','078',' 04','078040',78040,'Cetraro','Cetraro','','CS',1,'1840-01-01','2999-12-31'),
	(34260,'18','078',' 04','078041',78041,'Civita','Civita','','CS',1,'1840-01-01','2999-12-31'),
	(34261,'18','078',' 04','078042',78042,'Cleto','Cleto','','CS',1,'1840-01-01','2999-12-31'),
	(34262,'18','078',' 04','078043',78043,'Colosimi','Colosimi','','CS',1,'1840-01-01','2999-12-31'),
	(34263,'18','078',' 04','078044',78044,'Corigliano Calabro','Corigliano Calabro','','CS',1,'1840-01-01','2999-12-31'),
	(34264,'18','078',' 04','078045',78045,'Cosenza','Cosenza','','CS',1,'1840-01-01','2999-12-31'),
	(34265,'18','078',' 04','078046',78046,'Cropalati','Cropalati','','CS',1,'1840-01-01','2999-12-31'),
	(34266,'18','078',' 04','078047',78047,'Crosia','Crosia','','CS',1,'1840-01-01','2999-12-31'),
	(34267,'18','078',' 04','078048',78048,'Diamante','Diamante','','CS',1,'1840-01-01','2999-12-31'),
	(34268,'18','078',' 04','078049',78049,'Dipignano','Dipignano','','CS',1,'1840-01-01','2999-12-31'),
	(34269,'18','078',' 05','078050',78050,'Domanico','Domanico','','CS',1,'1840-01-01','2999-12-31'),
	(34270,'18','078',' 05','078051',78051,'Fagnano Castello','Fagnano Castello','','CS',1,'1840-01-01','2999-12-31'),
	(34271,'18','078',' 05','078052',78052,'Falconara Albanese','Falconara Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34272,'18','078',' 05','078053',78053,'Figline Vegliaturo','Figline Vegliaturo','','CS',1,'1840-01-01','2999-12-31'),
	(34273,'18','078',' 05','078054',78054,'Firmo','Firmo','','CS',1,'1840-01-01','2999-12-31'),
	(34274,'18','078',' 05','078055',78055,'Fiumefreddo Bruzio','Fiumefreddo Bruzio','','CS',1,'1840-01-01','2999-12-31'),
	(34275,'18','078',' 05','078056',78056,'Francavilla Marittima','Francavilla Marittima','','CS',1,'1840-01-01','2999-12-31'),
	(34276,'18','078',' 05','078057',78057,'Frascineto','Frascineto','','CS',1,'1840-01-01','2999-12-31'),
	(34277,'18','078',' 05','078058',78058,'Fuscaldo','Fuscaldo','','CS',1,'1840-01-01','2999-12-31'),
	(34278,'18','078',' 05','078059',78059,'Grimaldi','Grimaldi','','CS',1,'1840-01-01','2999-12-31'),
	(34279,'18','078',' 06','078060',78060,'Grisolia','Grisolia','','CS',1,'1840-01-01','2999-12-31'),
	(34280,'18','078',' 06','078061',78061,'Guardia Piemontese','Guardia Piemontese','','CS',1,'1840-01-01','2999-12-31'),
	(34281,'18','078',' 06','078062',78062,'Lago','Lago','','CS',1,'1840-01-01','2999-12-31'),
	(34282,'18','078',' 06','078063',78063,'Laino Borgo','Laino Borgo','','CS',1,'1840-01-01','2999-12-31'),
	(34283,'18','078',' 06','078064',78064,'Laino Castello','Laino Castello','','CS',1,'1840-01-01','2999-12-31'),
	(34284,'18','078',' 06','078065',78065,'Lappano','Lappano','','CS',1,'1840-01-01','2999-12-31'),
	(34285,'18','078',' 06','078066',78066,'Lattarico','Lattarico','','CS',1,'1840-01-01','2999-12-31'),
	(34286,'18','078',' 06','078067',78067,'Longobardi','Longobardi','','CS',1,'1840-01-01','2999-12-31'),
	(34287,'18','078',' 06','078068',78068,'Longobucco','Longobucco','','CS',1,'1840-01-01','2999-12-31'),
	(34288,'18','078',' 06','078069',78069,'Lungro','Lungro','','CS',1,'1840-01-01','2999-12-31'),
	(34289,'18','078',' 07','078070',78070,'Luzzi','Luzzi','','CS',1,'1840-01-01','2999-12-31'),
	(34290,'18','078',' 07','078071',78071,'Maierà','Maierà','','CS',1,'1840-01-01','2999-12-31'),
	(34291,'18','078',' 07','078072',78072,'Malito','Malito','','CS',1,'1840-01-01','2999-12-31'),
	(34292,'18','078',' 07','078073',78073,'Malvito','Malvito','','CS',1,'1840-01-01','2999-12-31'),
	(34293,'18','078',' 07','078074',78074,'Mandatoriccio','Mandatoriccio','','CS',1,'1840-01-01','2999-12-31'),
	(34294,'18','078',' 07','078075',78075,'Mangone','Mangone','','CS',1,'1840-01-01','2999-12-31'),
	(34295,'18','078',' 07','078076',78076,'Marano Marchesato','Marano Marchesato','','CS',1,'1840-01-01','2999-12-31'),
	(34296,'18','078',' 07','078077',78077,'Marano Principato','Marano Principato','','CS',1,'1840-01-01','2999-12-31'),
	(34297,'18','078',' 07','078078',78078,'Marzi','Marzi','','CS',1,'1840-01-01','2999-12-31'),
	(34298,'18','078',' 07','078079',78079,'Mendicino','Mendicino','','CS',1,'1840-01-01','2999-12-31'),
	(34299,'18','078',' 08','078080',78080,'Mongrassano','Mongrassano','','CS',1,'1840-01-01','2999-12-31'),
	(34300,'18','078',' 08','078081',78081,'Montalto Uffugo','Montalto Uffugo','','CS',1,'1840-01-01','2999-12-31'),
	(34301,'18','078',' 08','078082',78082,'Montegiordano','Montegiordano','','CS',1,'1840-01-01','2999-12-31'),
	(34302,'18','078',' 08','078083',78083,'Morano Calabro','Morano Calabro','','CS',1,'1840-01-01','2999-12-31'),
	(34303,'18','078',' 08','078084',78084,'Mormanno','Mormanno','','CS',1,'1840-01-01','2999-12-31'),
	(34304,'18','078',' 08','078085',78085,'Mottafollone','Mottafollone','','CS',1,'1840-01-01','2999-12-31'),
	(34305,'18','078',' 08','078086',78086,'Nocara','Nocara','','CS',1,'1840-01-01','2999-12-31'),
	(34306,'18','078',' 08','078087',78087,'Oriolo','Oriolo','','CS',1,'1840-01-01','2999-12-31'),
	(34307,'18','078',' 08','078088',78088,'Orsomarso','Orsomarso','','CS',1,'1840-01-01','2999-12-31'),
	(34308,'18','078',' 08','078089',78089,'Paludi','Paludi','','CS',1,'1840-01-01','2999-12-31'),
	(34309,'18','078',' 09','078090',78090,'Panettieri','Panettieri','','CS',1,'1840-01-01','2999-12-31'),
	(34310,'18','078',' 09','078091',78091,'Paola','Paola','','CS',1,'1840-01-01','2999-12-31'),
	(34311,'18','078',' 09','078092',78092,'Papasidero','Papasidero','','CS',1,'1840-01-01','2999-12-31'),
	(34312,'18','078',' 09','078093',78093,'Parenti','Parenti','','CS',1,'1840-01-01','2999-12-31'),
	(34313,'18','078',' 09','078094',78094,'Paterno Calabro','Paterno Calabro','','CS',1,'1840-01-01','2999-12-31'),
	(34314,'18','078',' 09','078095',78095,'Pedace','Pedace','','CS',1,'1840-01-01','2999-12-31'),
	(34315,'18','078',' 09','078096',78096,'Pedivigliano','Pedivigliano','','CS',1,'1840-01-01','2999-12-31'),
	(34316,'18','078',' 09','078097',78097,'Piane Crati','Piane Crati','','CS',1,'1840-01-01','2999-12-31'),
	(34317,'18','078',' 09','078098',78098,'Pietrafitta','Pietrafitta','','CS',1,'1840-01-01','2999-12-31'),
	(34318,'18','078',' 09','078099',78099,'Pietrapaola','Pietrapaola','','CS',1,'1840-01-01','2999-12-31'),
	(34319,'18','078',' 10','078100',78100,'Plataci','Plataci','','CS',1,'1840-01-01','2999-12-31'),
	(34320,'18','078',' 10','078101',78101,'Praia a Mare','Praia a Mare','','CS',1,'1840-01-01','2999-12-31'),
	(34321,'18','078',' 10','078102',78102,'Rende','Rende','','CS',1,'1840-01-01','2999-12-31'),
	(34322,'18','078',' 10','078103',78103,'Rocca Imperiale','Rocca Imperiale','','CS',1,'1840-01-01','2999-12-31'),
	(34323,'18','078',' 10','078104',78104,'Roggiano Gravina','Roggiano Gravina','','CS',1,'1840-01-01','2999-12-31'),
	(34324,'18','078',' 10','078105',78105,'Rogliano','Rogliano','','CS',1,'1840-01-01','2999-12-31'),
	(34325,'18','078',' 10','078106',78106,'Rose','Rose','','CS',1,'1840-01-01','2999-12-31'),
	(34326,'18','078',' 10','078107',78107,'Roseto Capo Spulico','Roseto Capo Spulico','','CS',1,'1840-01-01','2999-12-31'),
	(34327,'18','078',' 10','078108',78108,'Rossano','Rossano','','CS',1,'1840-01-01','2999-12-31'),
	(34328,'18','078',' 10','078109',78109,'Rota Greca','Rota Greca','','CS',1,'1840-01-01','2999-12-31'),
	(34329,'18','078',' 11','078110',78110,'Rovito','Rovito','','CS',1,'1840-01-01','2999-12-31'),
	(34330,'18','078',' 11','078111',78111,'San Basile','San Basile','','CS',1,'1840-01-01','2999-12-31'),
	(34331,'18','078',' 11','078112',78112,'San Benedetto Ullano','San Benedetto Ullano','','CS',1,'1840-01-01','2999-12-31'),
	(34332,'18','078',' 11','078113',78113,'San Cosmo Albanese','San Cosmo Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34333,'18','078',' 11','078114',78114,'San Demetrio Corone','San Demetrio Corone','','CS',1,'1840-01-01','2999-12-31'),
	(34334,'18','078',' 11','078115',78115,'San Donato di Ninea','San Donato di Ninea','','CS',1,'1840-01-01','2999-12-31'),
	(34335,'18','078',' 11','078116',78116,'San Fili','San Fili','','CS',1,'1840-01-01','2999-12-31'),
	(34336,'18','078',' 11','078117',78117,'Sangineto','Sangineto','','CS',1,'1840-01-01','2999-12-31'),
	(34337,'18','078',' 11','078118',78118,'San Giorgio Albanese','San Giorgio Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34338,'18','078',' 11','078119',78119,'San Giovanni in Fiore','San Giovanni in Fiore','','CS',1,'1840-01-01','2999-12-31'),
	(34339,'18','078',' 12','078120',78120,'San Lorenzo Bellizzi','San Lorenzo Bellizzi','','CS',1,'1840-01-01','2999-12-31'),
	(34340,'18','078',' 12','078121',78121,'San Lorenzo del Vallo','San Lorenzo del Vallo','','CS',1,'1840-01-01','2999-12-31'),
	(34341,'18','078',' 12','078122',78122,'San Lucido','San Lucido','','CS',1,'1840-01-01','2999-12-31'),
	(34342,'18','078',' 12','078123',78123,'San Marco Argentano','San Marco Argentano','','CS',1,'1840-01-01','2999-12-31'),
	(34343,'18','078',' 12','078124',78124,'San Martino di Finita','San Martino di Finita','','CS',1,'1840-01-01','2999-12-31'),
	(34344,'18','078',' 12','078125',78125,'San Nicola Arcella','San Nicola Arcella','','CS',1,'1840-01-01','2999-12-31'),
	(34345,'18','078',' 12','078126',78126,'San Pietro in Amantea','San Pietro in Amantea','','CS',1,'1840-01-01','2999-12-31'),
	(34346,'18','078',' 12','078127',78127,'San Pietro in Guarano','San Pietro in Guarano','','CS',1,'1840-01-01','2999-12-31'),
	(34347,'18','078',' 12','078128',78128,'San Sosti','San Sosti','','CS',1,'1840-01-01','2999-12-31'),
	(34348,'18','078',' 12','078129',78129,'Santa Caterina Albanese','Santa Caterina Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34349,'18','078',' 13','078130',78130,'Santa Domenica Talao','Santa Domenica Talao','','CS',1,'1840-01-01','2999-12-31'),
	(34350,'18','078',' 13','078131',78131,'Sant\'Agata di Esaro','Sant\'Agata di Esaro','','CS',1,'1840-01-01','2999-12-31'),
	(34351,'18','078',' 13','078132',78132,'Santa Maria del Cedro','Santa Maria del Cedro','','CS',1,'1840-01-01','2999-12-31'),
	(34352,'18','078',' 13','078133',78133,'Santa Sofia d\'Epiro','Santa Sofia d\'Epiro','','CS',1,'1840-01-01','2999-12-31'),
	(34353,'18','078',' 13','078134',78134,'Santo Stefano di Rogliano','Santo Stefano di Rogliano','','CS',1,'1840-01-01','2999-12-31'),
	(34354,'18','078',' 13','078135',78135,'San Vincenzo La Costa','San Vincenzo La Costa','','CS',1,'1840-01-01','2999-12-31'),
	(34355,'18','078',' 13','078136',78136,'Saracena','Saracena','','CS',1,'1840-01-01','2999-12-31'),
	(34356,'18','078',' 13','078137',78137,'Scala Coeli','Scala Coeli','','CS',1,'1840-01-01','2999-12-31'),
	(34357,'18','078',' 13','078138',78138,'Scalea','Scalea','','CS',1,'1840-01-01','2999-12-31'),
	(34358,'18','078',' 13','078139',78139,'Scigliano','Scigliano','','CS',1,'1840-01-01','2999-12-31'),
	(34359,'18','078',' 14','078140',78140,'Serra d\'Aiello','Serra d\'Aiello','','CS',1,'1840-01-01','2999-12-31'),
	(34360,'18','078',' 14','078141',78141,'Serra Pedace','Serra Pedace','','CS',1,'1840-01-01','2999-12-31'),
	(34361,'18','078',' 14','078142',78142,'Spezzano Albanese','Spezzano Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34362,'18','078',' 14','078143',78143,'Spezzano della Sila','Spezzano della Sila','','CS',1,'1840-01-01','2999-12-31'),
	(34363,'18','078',' 14','078144',78144,'Spezzano Piccolo','Spezzano Piccolo','','CS',1,'1840-01-01','2999-12-31'),
	(34364,'18','078',' 14','078145',78145,'Tarsia','Tarsia','','CS',1,'1840-01-01','2999-12-31'),
	(34365,'18','078',' 14','078146',78146,'Terranova da Sibari','Terranova da Sibari','','CS',1,'1840-01-01','2999-12-31'),
	(34366,'18','078',' 14','078147',78147,'Terravecchia','Terravecchia','','CS',1,'1840-01-01','2999-12-31'),
	(34367,'18','078',' 14','078148',78148,'Torano Castello','Torano Castello','','CS',1,'1840-01-01','2999-12-31'),
	(34368,'18','078',' 14','078149',78149,'Tortora','Tortora','','CS',1,'1840-01-01','2999-12-31'),
	(34369,'18','078',' 15','078150',78150,'Trebisacce','Trebisacce','','CS',1,'1840-01-01','2999-12-31'),
	(34370,'18','078',' 15','078151',78151,'Trenta','Trenta','','CS',1,'1840-01-01','2999-12-31'),
	(34371,'18','078',' 15','078152',78152,'Vaccarizzo Albanese','Vaccarizzo Albanese','','CS',1,'1840-01-01','2999-12-31'),
	(34372,'18','078',' 15','078153',78153,'Verbicaro','Verbicaro','','CS',1,'1840-01-01','2999-12-31'),
	(34373,'18','078',' 15','078154',78154,'Villapiana','Villapiana','','CS',1,'1840-01-01','2999-12-31'),
	(34374,'18','078',' 15','078155',78155,'Zumpano','Zumpano','','CS',1,'1840-01-01','2999-12-31'),
	(34375,'18','079',' 00','079002',79002,'Albi','Albi','','CZ',1,'1840-01-01','2999-12-31'),
	(34376,'18','079',' 00','079003',79003,'Amaroni','Amaroni','','CZ',1,'1840-01-01','2999-12-31'),
	(34377,'18','079',' 00','079004',79004,'Amato','Amato','','CZ',1,'1840-01-01','2999-12-31'),
	(34378,'18','079',' 00','079005',79005,'Andali','Andali','','CZ',1,'1840-01-01','2999-12-31'),
	(34379,'18','079',' 00','079007',79007,'Argusto','Argusto','','CZ',1,'1840-01-01','2999-12-31'),
	(34380,'18','079',' 00','079008',79008,'Badolato','Badolato','','CZ',1,'1840-01-01','2999-12-31'),
	(34381,'18','079',' 00','079009',79009,'Belcastro','Belcastro','','CZ',1,'1840-01-01','2999-12-31'),
	(34382,'18','079',' 01','079011',79011,'Borgia','Borgia','','CZ',1,'1840-01-01','2999-12-31'),
	(34383,'18','079',' 01','079012',79012,'Botricello','Botricello','','CZ',1,'1840-01-01','2999-12-31'),
	(34384,'18','079',' 01','079017',79017,'Caraffa di Catanzaro','Caraffa di Catanzaro','','CZ',1,'1840-01-01','2999-12-31'),
	(34385,'18','079',' 01','079018',79018,'Cardinale','Cardinale','','CZ',1,'1840-01-01','2999-12-31'),
	(34386,'18','079',' 02','079020',79020,'Carlopoli','Carlopoli','','CZ',1,'1840-01-01','2999-12-31'),
	(34387,'18','079',' 02','079023',79023,'Catanzaro','Catanzaro','','CZ',1,'1840-01-01','2999-12-31'),
	(34388,'18','079',' 02','079024',79024,'Cenadi','Cenadi','','CZ',1,'1840-01-01','2999-12-31'),
	(34389,'18','079',' 02','079025',79025,'Centrache','Centrache','','CZ',1,'1840-01-01','2999-12-31'),
	(34390,'18','079',' 02','079027',79027,'Cerva','Cerva','','CZ',1,'1840-01-01','2999-12-31'),
	(34391,'18','079',' 02','079029',79029,'Chiaravalle Centrale','Chiaravalle Centrale','','CZ',1,'1840-01-01','2999-12-31'),
	(34392,'18','079',' 03','079030',79030,'Cicala','Cicala','','CZ',1,'1840-01-01','2999-12-31'),
	(34393,'18','079',' 03','079033',79033,'Conflenti','Conflenti','','CZ',1,'1840-01-01','2999-12-31'),
	(34394,'18','079',' 03','079034',79034,'Cortale','Cortale','','CZ',1,'1840-01-01','2999-12-31'),
	(34395,'18','079',' 03','079036',79036,'Cropani','Cropani','','CZ',1,'1840-01-01','2999-12-31'),
	(34396,'18','079',' 03','079039',79039,'Curinga','Curinga','','CZ',1,'1840-01-01','2999-12-31'),
	(34397,'18','079',' 04','079042',79042,'Davoli','Davoli','','CZ',1,'1840-01-01','2999-12-31'),
	(34398,'18','079',' 04','079043',79043,'Decollatura','Decollatura','','CZ',1,'1840-01-01','2999-12-31'),
	(34399,'18','079',' 04','079047',79047,'Falerna','Falerna','','CZ',1,'1840-01-01','2999-12-31'),
	(34400,'18','079',' 04','079048',79048,'Feroleto Antico','Feroleto Antico','','CZ',1,'1840-01-01','2999-12-31'),
	(34401,'18','079',' 05','079052',79052,'Fossato Serralta','Fossato Serralta','','CZ',1,'1840-01-01','2999-12-31'),
	(34402,'18','079',' 05','079055',79055,'Gagliato','Gagliato','','CZ',1,'1840-01-01','2999-12-31'),
	(34403,'18','079',' 05','079056',79056,'Gasperina','Gasperina','','CZ',1,'1840-01-01','2999-12-31'),
	(34404,'18','079',' 05','079058',79058,'Gimigliano','Gimigliano','','CZ',1,'1840-01-01','2999-12-31'),
	(34405,'18','079',' 05','079059',79059,'Girifalco','Girifalco','','CZ',1,'1840-01-01','2999-12-31'),
	(34406,'18','079',' 06','079060',79060,'Gizzeria','Gizzeria','','CZ',1,'1840-01-01','2999-12-31'),
	(34407,'18','079',' 06','079061',79061,'Guardavalle','Guardavalle','','CZ',1,'1840-01-01','2999-12-31'),
	(34408,'18','079',' 06','079063',79063,'Isca sullo Ionio','Isca sullo Ionio','','CZ',1,'1840-01-01','2999-12-31'),
	(34409,'18','079',' 06','079065',79065,'Jacurso','Jacurso','','CZ',1,'1840-01-01','2999-12-31'),
	(34410,'18','079',' 06','079068',79068,'Magisano','Magisano','','CZ',1,'1840-01-01','2999-12-31'),
	(34411,'18','079',' 06','079069',79069,'Maida','Maida','','CZ',1,'1840-01-01','2999-12-31'),
	(34412,'18','079',' 07','079071',79071,'Marcedusa','Marcedusa','','CZ',1,'1840-01-01','2999-12-31'),
	(34413,'18','079',' 07','079072',79072,'Marcellinara','Marcellinara','','CZ',1,'1840-01-01','2999-12-31'),
	(34414,'18','079',' 07','079073',79073,'Martirano','Martirano','','CZ',1,'1840-01-01','2999-12-31'),
	(34415,'18','079',' 07','079074',79074,'Martirano Lombardo','Martirano Lombardo','','CZ',1,'1840-01-01','2999-12-31'),
	(34416,'18','079',' 07','079077',79077,'Miglierina','Miglierina','','CZ',1,'1840-01-01','2999-12-31'),
	(34417,'18','079',' 08','079080',79080,'Montauro','Montauro','','CZ',1,'1840-01-01','2999-12-31'),
	(34418,'18','079',' 08','079081',79081,'Montepaone','Montepaone','','CZ',1,'1840-01-01','2999-12-31'),
	(34419,'18','079',' 08','079083',79083,'Motta Santa Lucia','Motta Santa Lucia','','CZ',1,'1840-01-01','2999-12-31'),
	(34420,'18','079',' 08','079087',79087,'Nocera Terinese','Nocera Terinese','','CZ',1,'1840-01-01','2999-12-31'),
	(34421,'18','079',' 08','079088',79088,'Olivadi','Olivadi','','CZ',1,'1840-01-01','2999-12-31'),
	(34422,'18','079',' 08','079089',79089,'Palermiti','Palermiti','','CZ',1,'1840-01-01','2999-12-31'),
	(34423,'18','079',' 09','079092',79092,'Pentone','Pentone','','CZ',1,'1840-01-01','2999-12-31'),
	(34424,'18','079',' 09','079094',79094,'Petrizzi','Petrizzi','','CZ',1,'1840-01-01','2999-12-31'),
	(34425,'18','079',' 09','079095',79095,'Petronà','Petronà','','CZ',1,'1840-01-01','2999-12-31'),
	(34426,'18','079',' 09','079096',79096,'Pianopoli','Pianopoli','','CZ',1,'1840-01-01','2999-12-31'),
	(34427,'18','079',' 09','079099',79099,'Platania','Platania','','CZ',1,'1840-01-01','2999-12-31'),
	(34428,'18','079',' 10','079108',79108,'San Floro','San Floro','','CZ',1,'1840-01-01','2999-12-31'),
	(34429,'18','079',' 11','079110',79110,'San Mango d\'Aquino','San Mango d\'Aquino','','CZ',1,'1840-01-01','2999-12-31'),
	(34430,'18','079',' 11','079114',79114,'San Pietro a Maida','San Pietro a Maida','','CZ',1,'1840-01-01','2999-12-31'),
	(34431,'18','079',' 11','079115',79115,'San Pietro Apostolo','San Pietro Apostolo','','CZ',1,'1840-01-01','2999-12-31'),
	(34432,'18','079',' 11','079116',79116,'San Sostene','San Sostene','','CZ',1,'1840-01-01','2999-12-31'),
	(34433,'18','079',' 11','079117',79117,'Santa Caterina dello Ionio','Santa Caterina dello Ionio','','CZ',1,'1840-01-01','2999-12-31'),
	(34434,'18','079',' 11','079118',79118,'Sant\'Andrea Apostolo dello Ionio','Sant\'Andrea Apostolo dello Ionio','','CZ',1,'1840-01-01','2999-12-31'),
	(34435,'18','079',' 12','079122',79122,'San Vito sullo Ionio','San Vito sullo Ionio','','CZ',1,'1840-01-01','2999-12-31'),
	(34436,'18','079',' 12','079123',79123,'Satriano','Satriano','','CZ',1,'1840-01-01','2999-12-31'),
	(34437,'18','079',' 12','079126',79126,'Sellia','Sellia','','CZ',1,'1840-01-01','2999-12-31'),
	(34438,'18','079',' 12','079127',79127,'Sellia Marina','Sellia Marina','','CZ',1,'1840-01-01','2999-12-31'),
	(34439,'18','079',' 12','079129',79129,'Serrastretta','Serrastretta','','CZ',1,'1840-01-01','2999-12-31'),
	(34440,'18','079',' 13','079130',79130,'Sersale','Sersale','','CZ',1,'1840-01-01','2999-12-31'),
	(34441,'18','079',' 13','079131',79131,'Settingiano','Settingiano','','CZ',1,'1840-01-01','2999-12-31'),
	(34442,'18','079',' 13','079133',79133,'Simeri Crichi','Simeri Crichi','','CZ',1,'1840-01-01','2999-12-31'),
	(34443,'18','079',' 13','079134',79134,'Sorbo San Basile','Sorbo San Basile','','CZ',1,'1840-01-01','2999-12-31'),
	(34444,'18','079',' 13','079137',79137,'Soverato','Soverato','','CZ',1,'1840-01-01','2999-12-31'),
	(34445,'18','079',' 13','079138',79138,'Soveria Mannelli','Soveria Mannelli','','CZ',1,'1840-01-01','2999-12-31'),
	(34446,'18','079',' 13','079139',79139,'Soveria Simeri','Soveria Simeri','','CZ',1,'1840-01-01','2999-12-31'),
	(34447,'18','079',' 14','079142',79142,'Squillace','Squillace','','CZ',1,'1840-01-01','2999-12-31'),
	(34448,'18','079',' 14','079143',79143,'Stalettì','Stalettì','','CZ',1,'1840-01-01','2999-12-31'),
	(34449,'18','079',' 14','079146',79146,'Taverna','Taverna','','CZ',1,'1840-01-01','2999-12-31'),
	(34450,'18','079',' 14','079147',79147,'Tiriolo','Tiriolo','','CZ',1,'1840-01-01','2999-12-31'),
	(34451,'18','079',' 14','079148',79148,'Torre di Ruggiero','Torre di Ruggiero','','CZ',1,'1840-01-01','2999-12-31'),
	(34452,'18','079',' 15','079151',79151,'Vallefiorita','Vallefiorita','','CZ',1,'1840-01-01','2999-12-31'),
	(34453,'18','079',' 15','079157',79157,'Zagarise','Zagarise','','CZ',1,'1840-01-01','2999-12-31'),
	(34454,'18','079',' 16','079160',79160,'Lamezia Terme','Lamezia Terme','','CZ',1,'1840-01-01','2999-12-31'),
	(34455,'18','080',' 00','080001',80001,'Africo','Africo','','RC',1,'1840-01-01','2999-12-31'),
	(34456,'18','080',' 00','080002',80002,'Agnana Calabra','Agnana Calabra','','RC',1,'1840-01-01','2999-12-31'),
	(34457,'18','080',' 00','080003',80003,'Anoia','Anoia','','RC',1,'1840-01-01','2999-12-31'),
	(34458,'18','080',' 00','080004',80004,'Antonimina','Antonimina','','RC',1,'1840-01-01','2999-12-31'),
	(34459,'18','080',' 00','080005',80005,'Ardore','Ardore','','RC',1,'1840-01-01','2999-12-31'),
	(34460,'18','080',' 00','080006',80006,'Bagaladi','Bagaladi','','RC',1,'1840-01-01','2999-12-31'),
	(34461,'18','080',' 00','080007',80007,'Bagnara Calabra','Bagnara Calabra','','RC',1,'1840-01-01','2999-12-31'),
	(34462,'18','080',' 00','080008',80008,'Benestare','Benestare','','RC',1,'1840-01-01','2999-12-31'),
	(34463,'18','080',' 00','080009',80009,'Bianco','Bianco','','RC',1,'1840-01-01','2999-12-31'),
	(34464,'18','080',' 01','080010',80010,'Bivongi','Bivongi','','RC',1,'1840-01-01','2999-12-31'),
	(34465,'18','080',' 01','080011',80011,'Bova','Bova','','RC',1,'1840-01-01','2999-12-31'),
	(34466,'18','080',' 01','080012',80012,'Bovalino','Bovalino','','RC',1,'1840-01-01','2999-12-31'),
	(34467,'18','080',' 01','080013',80013,'Bova Marina','Bova Marina','','RC',1,'1840-01-01','2999-12-31'),
	(34468,'18','080',' 01','080014',80014,'Brancaleone','Brancaleone','','RC',1,'1840-01-01','2999-12-31'),
	(34469,'18','080',' 01','080015',80015,'Bruzzano Zeffirio','Bruzzano Zeffirio','','RC',1,'1840-01-01','2999-12-31'),
	(34470,'18','080',' 01','080016',80016,'Calanna','Calanna','','RC',1,'1840-01-01','2999-12-31'),
	(34471,'18','080',' 01','080017',80017,'Camini','Camini','','RC',1,'1840-01-01','2999-12-31'),
	(34472,'18','080',' 01','080018',80018,'Campo Calabro','Campo Calabro','','RC',1,'1840-01-01','2999-12-31'),
	(34473,'18','080',' 01','080019',80019,'Candidoni','Candidoni','','RC',1,'1840-01-01','2999-12-31'),
	(34474,'18','080',' 02','080020',80020,'Canolo','Canolo','','RC',1,'1840-01-01','2999-12-31'),
	(34475,'18','080',' 02','080021',80021,'Caraffa del Bianco','Caraffa del Bianco','','RC',1,'1840-01-01','2999-12-31'),
	(34476,'18','080',' 02','080022',80022,'Cardeto','Cardeto','','RC',1,'1840-01-01','2999-12-31'),
	(34477,'18','080',' 02','080023',80023,'Careri','Careri','','RC',1,'1840-01-01','2999-12-31'),
	(34478,'18','080',' 02','080024',80024,'Casignana','Casignana','','RC',1,'1840-01-01','2999-12-31'),
	(34479,'18','080',' 02','080025',80025,'Caulonia','Caulonia','','RC',1,'1840-01-01','2999-12-31'),
	(34480,'18','080',' 02','080026',80026,'Ciminà','Ciminà','','RC',1,'1840-01-01','2999-12-31'),
	(34481,'18','080',' 02','080027',80027,'Cinquefrondi','Cinquefrondi','','RC',1,'1840-01-01','2999-12-31'),
	(34482,'18','080',' 02','080028',80028,'Cittanova','Cittanova','','RC',1,'1840-01-01','2999-12-31'),
	(34483,'18','080',' 02','080029',80029,'Condofuri','Condofuri','','RC',1,'1840-01-01','2999-12-31'),
	(34484,'18','080',' 03','080030',80030,'Cosoleto','Cosoleto','','RC',1,'1840-01-01','2999-12-31'),
	(34485,'18','080',' 03','080031',80031,'Delianuova','Delianuova','','RC',1,'1840-01-01','2999-12-31'),
	(34486,'18','080',' 03','080032',80032,'Feroleto della Chiesa','Feroleto della Chiesa','','RC',1,'1840-01-01','2999-12-31'),
	(34487,'18','080',' 03','080033',80033,'Ferruzzano','Ferruzzano','','RC',1,'1840-01-01','2999-12-31'),
	(34488,'18','080',' 03','080034',80034,'Fiumara','Fiumara','','RC',1,'1840-01-01','2999-12-31'),
	(34489,'18','080',' 03','080035',80035,'Galatro','Galatro','','RC',1,'1840-01-01','2999-12-31'),
	(34490,'18','080',' 03','080036',80036,'Gerace','Gerace','','RC',1,'1840-01-01','2999-12-31'),
	(34491,'18','080',' 03','080037',80037,'Giffone','Giffone','','RC',1,'1840-01-01','2999-12-31'),
	(34492,'18','080',' 03','080038',80038,'Gioia Tauro','Gioia Tauro','','RC',1,'1840-01-01','2999-12-31'),
	(34493,'18','080',' 03','080039',80039,'Gioiosa Ionica','Gioiosa Ionica','','RC',1,'1840-01-01','2999-12-31'),
	(34494,'18','080',' 04','080040',80040,'Grotteria','Grotteria','','RC',1,'1840-01-01','2999-12-31'),
	(34495,'18','080',' 04','080041',80041,'Laganadi','Laganadi','','RC',1,'1840-01-01','2999-12-31'),
	(34496,'18','080',' 04','080042',80042,'Laureana di Borrello','Laureana di Borrello','','RC',1,'1840-01-01','2999-12-31'),
	(34497,'18','080',' 04','080043',80043,'Locri','Locri','','RC',1,'1840-01-01','2999-12-31'),
	(34498,'18','080',' 04','080044',80044,'Mammola','Mammola','','RC',1,'1840-01-01','2999-12-31'),
	(34499,'18','080',' 04','080045',80045,'Marina di Gioiosa Ionica','Marina di Gioiosa Ionica','','RC',1,'1840-01-01','2999-12-31'),
	(34500,'18','080',' 04','080046',80046,'Maropati','Maropati','','RC',1,'1840-01-01','2999-12-31'),
	(34501,'18','080',' 04','080047',80047,'Martone','Martone','','RC',1,'1840-01-01','2999-12-31'),
	(34502,'18','080',' 04','080048',80048,'Melicuccà','Melicuccà','','RC',1,'1840-01-01','2999-12-31'),
	(34503,'18','080',' 04','080049',80049,'Melicucco','Melicucco','','RC',1,'1840-01-01','2999-12-31'),
	(34504,'18','080',' 05','080050',80050,'Melito di Porto Salvo','Melito di Porto Salvo','','RC',1,'1840-01-01','2999-12-31'),
	(34505,'18','080',' 05','080051',80051,'Molochio','Molochio','','RC',1,'1840-01-01','2999-12-31'),
	(34506,'18','080',' 05','080052',80052,'Monasterace','Monasterace','','RC',1,'1840-01-01','2999-12-31'),
	(34507,'18','080',' 05','080053',80053,'Montebello Ionico','Montebello Ionico','','RC',1,'1840-01-01','2999-12-31'),
	(34508,'18','080',' 05','080054',80054,'Motta San Giovanni','Motta San Giovanni','','RC',1,'1840-01-01','2999-12-31'),
	(34509,'18','080',' 05','080055',80055,'Oppido Mamertina','Oppido Mamertina','','RC',1,'1840-01-01','2999-12-31'),
	(34510,'18','080',' 05','080056',80056,'Palizzi','Palizzi','','RC',1,'1840-01-01','2999-12-31'),
	(34511,'18','080',' 05','080057',80057,'Palmi','Palmi','','RC',1,'1840-01-01','2999-12-31'),
	(34512,'18','080',' 05','080058',80058,'Pazzano','Pazzano','','RC',1,'1840-01-01','2999-12-31'),
	(34513,'18','080',' 05','080059',80059,'Placanica','Placanica','','RC',1,'1840-01-01','2999-12-31'),
	(34514,'18','080',' 06','080060',80060,'Platì','Platì','','RC',1,'1840-01-01','2999-12-31'),
	(34515,'18','080',' 06','080061',80061,'Polistena','Polistena','','RC',1,'1840-01-01','2999-12-31'),
	(34516,'18','080',' 06','080062',80062,'Portigliola','Portigliola','','RC',1,'1840-01-01','2999-12-31'),
	(34517,'18','080',' 06','080063',80063,'Reggio di Calabria','Reggio di Calabria','','RC',1,'1840-01-01','2999-12-31'),
	(34518,'18','080',' 06','080064',80064,'Riace','Riace','','RC',1,'1840-01-01','2999-12-31'),
	(34519,'18','080',' 06','080065',80065,'Rizziconi','Rizziconi','','RC',1,'1840-01-01','2999-12-31'),
	(34520,'18','080',' 06','080066',80066,'Roccaforte del Greco','Roccaforte del Greco','','RC',1,'1840-01-01','2999-12-31'),
	(34521,'18','080',' 06','080067',80067,'Roccella Ionica','Roccella Ionica','','RC',1,'1840-01-01','2999-12-31'),
	(34522,'18','080',' 06','080068',80068,'Roghudi','Roghudi','','RC',1,'1840-01-01','2999-12-31'),
	(34523,'18','080',' 06','080069',80069,'Rosarno','Rosarno','','RC',1,'1840-01-01','2999-12-31'),
	(34524,'18','080',' 07','080070',80070,'Samo','Samo','','RC',1,'1840-01-01','2999-12-31'),
	(34525,'18','080',' 07','080071',80071,'San Giorgio Morgeto','San Giorgio Morgeto','','RC',1,'1840-01-01','2999-12-31'),
	(34526,'18','080',' 07','080072',80072,'San Giovanni di Gerace','San Giovanni di Gerace','','RC',1,'1840-01-01','2999-12-31'),
	(34527,'18','080',' 07','080073',80073,'San Lorenzo','San Lorenzo','','RC',1,'1840-01-01','2999-12-31'),
	(34528,'18','080',' 07','080074',80074,'San Luca','San Luca','','RC',1,'1840-01-01','2999-12-31'),
	(34529,'18','080',' 07','080075',80075,'San Pietro di Caridà','San Pietro di Caridà','','RC',1,'1840-01-01','2999-12-31'),
	(34530,'18','080',' 07','080076',80076,'San Procopio','San Procopio','','RC',1,'1840-01-01','2999-12-31'),
	(34531,'18','080',' 07','080077',80077,'San Roberto','San Roberto','','RC',1,'1840-01-01','2999-12-31'),
	(34532,'18','080',' 07','080078',80078,'Santa Cristina d\'Aspromonte','Santa Cristina d\'Aspromonte','','RC',1,'1840-01-01','2999-12-31'),
	(34533,'18','080',' 07','080079',80079,'Sant\'Agata del Bianco','Sant\'Agata del Bianco','','RC',1,'1840-01-01','2999-12-31'),
	(34534,'18','080',' 08','080080',80080,'Sant\'Alessio in Aspromonte','Sant\'Alessio in Aspromonte','','RC',1,'1840-01-01','2999-12-31'),
	(34535,'18','080',' 08','080081',80081,'Sant\'Eufemia d\'Aspromonte','Sant\'Eufemia d\'Aspromonte','','RC',1,'1840-01-01','2999-12-31'),
	(34536,'18','080',' 08','080082',80082,'Sant\'Ilario dello Ionio','Sant\'Ilario dello Ionio','','RC',1,'1840-01-01','2999-12-31'),
	(34537,'18','080',' 08','080083',80083,'Santo Stefano in Aspromonte','Santo Stefano in Aspromonte','','RC',1,'1840-01-01','2999-12-31'),
	(34538,'18','080',' 08','080084',80084,'Scido','Scido','','RC',1,'1840-01-01','2999-12-31'),
	(34539,'18','080',' 08','080085',80085,'Scilla','Scilla','','RC',1,'1840-01-01','2999-12-31'),
	(34540,'18','080',' 08','080086',80086,'Seminara','Seminara','','RC',1,'1840-01-01','2999-12-31'),
	(34541,'18','080',' 08','080087',80087,'Serrata','Serrata','','RC',1,'1840-01-01','2999-12-31'),
	(34542,'18','080',' 08','080088',80088,'Siderno','Siderno','','RC',1,'1840-01-01','2999-12-31'),
	(34543,'18','080',' 08','080089',80089,'Sinopoli','Sinopoli','','RC',1,'1840-01-01','2999-12-31'),
	(34544,'18','080',' 09','080090',80090,'Staiti','Staiti','','RC',1,'1840-01-01','2999-12-31'),
	(34545,'18','080',' 09','080091',80091,'Stignano','Stignano','','RC',1,'1840-01-01','2999-12-31'),
	(34546,'18','080',' 09','080092',80092,'Stilo','Stilo','','RC',1,'1840-01-01','2999-12-31'),
	(34547,'18','080',' 09','080093',80093,'Taurianova','Taurianova','','RC',1,'1840-01-01','2999-12-31'),
	(34548,'18','080',' 09','080094',80094,'Terranova Sappo Minulio','Terranova Sappo Minulio','','RC',1,'1840-01-01','2999-12-31'),
	(34549,'18','080',' 09','080095',80095,'Varapodio','Varapodio','','RC',1,'1840-01-01','2999-12-31'),
	(34550,'18','080',' 09','080096',80096,'Villa San Giovanni','Villa San Giovanni','','RC',1,'1840-01-01','2999-12-31'),
	(34551,'18','080',' 09','080097',80097,'San Ferdinando','San Ferdinando','','RC',1,'1840-01-01','2999-12-31'),
	(34552,'19','081',' 00','081001',81001,'Alcamo','Alcamo','','TP',1,'1840-01-01','2999-12-31'),
	(34553,'19','081',' 00','081002',81002,'Buseto Palizzolo','Buseto Palizzolo','','TP',1,'1840-01-01','2999-12-31'),
	(34554,'19','081',' 00','081003',81003,'Calatafimi-Segesta','Calatafimi-Segesta','','TP',1,'1840-01-01','2999-12-31'),
	(34555,'19','081',' 00','081004',81004,'Campobello di Mazara','Campobello di Mazara','','TP',1,'1840-01-01','2999-12-31'),
	(34556,'19','081',' 00','081005',81005,'Castellammare del Golfo','Castellammare del Golfo','','TP',1,'1840-01-01','2999-12-31'),
	(34557,'19','081',' 00','081006',81006,'Castelvetrano','Castelvetrano','','TP',1,'1840-01-01','2999-12-31'),
	(34558,'19','081',' 00','081007',81007,'Custonaci','Custonaci','','TP',1,'1840-01-01','2999-12-31'),
	(34559,'19','081',' 00','081008',81008,'Erice','Erice','','TP',1,'1840-01-01','2999-12-31'),
	(34560,'19','081',' 00','081009',81009,'Favignana','Favignana','','TP',1,'1840-01-01','2999-12-31'),
	(34561,'19','081',' 01','081010',81010,'Gibellina','Gibellina','','TP',1,'1840-01-01','2999-12-31'),
	(34562,'19','081',' 01','081011',81011,'Marsala','Marsala','','TP',1,'1840-01-01','2999-12-31'),
	(34563,'19','081',' 01','081012',81012,'Mazara del Vallo','Mazara del Vallo','','TP',1,'1840-01-01','2999-12-31'),
	(34564,'19','081',' 01','081013',81013,'Paceco','Paceco','','TP',1,'1840-01-01','2999-12-31'),
	(34565,'19','081',' 01','081014',81014,'Pantelleria','Pantelleria','','TP',1,'1840-01-01','2999-12-31'),
	(34566,'19','081',' 01','081015',81015,'Partanna','Partanna','','TP',1,'1840-01-01','2999-12-31'),
	(34567,'19','081',' 01','081016',81016,'Poggioreale','Poggioreale','','TP',1,'1840-01-01','2999-12-31'),
	(34568,'19','081',' 01','081017',81017,'Salaparuta','Salaparuta','','TP',1,'1840-01-01','2999-12-31'),
	(34569,'19','081',' 01','081018',81018,'Salemi','Salemi','','TP',1,'1840-01-01','2999-12-31'),
	(34570,'19','081',' 01','081019',81019,'Santa Ninfa','Santa Ninfa','','TP',1,'1840-01-01','2999-12-31'),
	(34571,'19','081',' 02','081020',81020,'San Vito Lo Capo','San Vito Lo Capo','','TP',1,'1840-01-01','2999-12-31'),
	(34572,'19','081',' 02','081021',81021,'Trapani','Trapani','','TP',1,'1840-01-01','2999-12-31'),
	(34573,'19','081',' 02','081022',81022,'Valderice','Valderice','','TP',1,'1840-01-01','2999-12-31'),
	(34574,'19','081',' 02','081023',81023,'Vita','Vita','','TP',1,'1840-01-01','2999-12-31'),
	(34575,'19','081',' 02','081024',81024,'Petrosino','Petrosino','','TP',1,'1840-01-01','2999-12-31'),
	(34576,'19','082',' 00','082001',82001,'Alia','Alia','','PA',1,'1840-01-01','2999-12-31'),
	(34577,'19','082',' 00','082002',82002,'Alimena','Alimena','','PA',1,'1840-01-01','2999-12-31'),
	(34578,'19','082',' 00','082003',82003,'Aliminusa','Aliminusa','','PA',1,'1840-01-01','2999-12-31'),
	(34579,'19','082',' 00','082004',82004,'Altavilla Milicia','Altavilla Milicia','','PA',1,'1840-01-01','2999-12-31'),
	(34580,'19','082',' 00','082005',82005,'Altofonte','Altofonte','','PA',1,'1840-01-01','2999-12-31'),
	(34581,'19','082',' 00','082006',82006,'Bagheria','Bagheria','','PA',1,'1840-01-01','2999-12-31'),
	(34582,'19','082',' 00','082007',82007,'Balestrate','Balestrate','','PA',1,'1840-01-01','2999-12-31'),
	(34583,'19','082',' 00','082008',82008,'Baucina','Baucina','','PA',1,'1840-01-01','2999-12-31'),
	(34584,'19','082',' 00','082009',82009,'Belmonte Mezzagno','Belmonte Mezzagno','','PA',1,'1840-01-01','2999-12-31'),
	(34585,'19','082',' 01','082010',82010,'Bisacquino','Bisacquino','','PA',1,'1840-01-01','2999-12-31'),
	(34586,'19','082',' 01','082011',82011,'Bolognetta','Bolognetta','','PA',1,'1840-01-01','2999-12-31'),
	(34587,'19','082',' 01','082012',82012,'Bompietro','Bompietro','','PA',1,'1840-01-01','2999-12-31'),
	(34588,'19','082',' 01','082013',82013,'Borgetto','Borgetto','','PA',1,'1840-01-01','2999-12-31'),
	(34589,'19','082',' 01','082014',82014,'Caccamo','Caccamo','','PA',1,'1840-01-01','2999-12-31'),
	(34590,'19','082',' 01','082015',82015,'Caltavuturo','Caltavuturo','','PA',1,'1840-01-01','2999-12-31'),
	(34591,'19','082',' 01','082016',82016,'Campofelice di Fitalia','Campofelice di Fitalia','','PA',1,'1840-01-01','2999-12-31'),
	(34592,'19','082',' 01','082017',82017,'Campofelice di Roccella','Campofelice di Roccella','','PA',1,'1840-01-01','2999-12-31'),
	(34593,'19','082',' 01','082018',82018,'Campofiorito','Campofiorito','','PA',1,'1840-01-01','2999-12-31'),
	(34594,'19','082',' 01','082019',82019,'Camporeale','Camporeale','','PA',1,'1840-01-01','2999-12-31'),
	(34595,'19','082',' 02','082020',82020,'Capaci','Capaci','','PA',1,'1840-01-01','2999-12-31'),
	(34596,'19','082',' 02','082021',82021,'Carini','Carini','','PA',1,'1840-01-01','2999-12-31'),
	(34597,'19','082',' 02','082022',82022,'Castelbuono','Castelbuono','','PA',1,'1840-01-01','2999-12-31'),
	(34598,'19','082',' 02','082023',82023,'Casteldaccia','Casteldaccia','','PA',1,'1840-01-01','2999-12-31'),
	(34599,'19','082',' 02','082024',82024,'Castellana Sicula','Castellana Sicula','','PA',1,'1840-01-01','2999-12-31'),
	(34600,'19','082',' 02','082025',82025,'Castronovo di Sicilia','Castronovo di Sicilia','','PA',1,'1840-01-01','2999-12-31'),
	(34601,'19','082',' 02','082026',82026,'Cefalà Diana','Cefalà Diana','','PA',1,'1840-01-01','2999-12-31'),
	(34602,'19','082',' 02','082027',82027,'Cefalù','Cefalù','','PA',1,'1840-01-01','2999-12-31'),
	(34603,'19','082',' 02','082028',82028,'Cerda','Cerda','','PA',1,'1840-01-01','2999-12-31'),
	(34604,'19','082',' 02','082029',82029,'Chiusa Sclafani','Chiusa Sclafani','','PA',1,'1840-01-01','2999-12-31'),
	(34605,'19','082',' 03','082030',82030,'Ciminna','Ciminna','','PA',1,'1840-01-01','2999-12-31'),
	(34606,'19','082',' 03','082031',82031,'Cinisi','Cinisi','','PA',1,'1840-01-01','2999-12-31'),
	(34607,'19','082',' 03','082032',82032,'Collesano','Collesano','','PA',1,'1840-01-01','2999-12-31'),
	(34608,'19','082',' 03','082033',82033,'Contessa Entellina','Contessa Entellina','','PA',1,'1840-01-01','2999-12-31'),
	(34609,'19','082',' 03','082034',82034,'Corleone','Corleone','','PA',1,'1840-01-01','2999-12-31'),
	(34610,'19','082',' 03','082035',82035,'Ficarazzi','Ficarazzi','','PA',1,'1840-01-01','2999-12-31'),
	(34611,'19','082',' 03','082036',82036,'Gangi','Gangi','','PA',1,'1840-01-01','2999-12-31'),
	(34612,'19','082',' 03','082037',82037,'Geraci Siculo','Geraci Siculo','','PA',1,'1840-01-01','2999-12-31'),
	(34613,'19','082',' 03','082038',82038,'Giardinello','Giardinello','','PA',1,'1840-01-01','2999-12-31'),
	(34614,'19','082',' 03','082039',82039,'Giuliana','Giuliana','','PA',1,'1840-01-01','2999-12-31'),
	(34615,'19','082',' 04','082040',82040,'Godrano','Godrano','','PA',1,'1840-01-01','2999-12-31'),
	(34616,'19','082',' 04','082041',82041,'Gratteri','Gratteri','','PA',1,'1840-01-01','2999-12-31'),
	(34617,'19','082',' 04','082042',82042,'Isnello','Isnello','','PA',1,'1840-01-01','2999-12-31'),
	(34618,'19','082',' 04','082043',82043,'Isola delle Femmine','Isola delle Femmine','','PA',1,'1840-01-01','2999-12-31'),
	(34619,'19','082',' 04','082044',82044,'Lascari','Lascari','','PA',1,'1840-01-01','2999-12-31'),
	(34620,'19','082',' 04','082045',82045,'Lercara Friddi','Lercara Friddi','','PA',1,'1840-01-01','2999-12-31'),
	(34621,'19','082',' 04','082046',82046,'Marineo','Marineo','','PA',1,'1840-01-01','2999-12-31'),
	(34622,'19','082',' 04','082047',82047,'Mezzojuso','Mezzojuso','','PA',1,'1840-01-01','2999-12-31'),
	(34623,'19','082',' 04','082048',82048,'Misilmeri','Misilmeri','','PA',1,'1840-01-01','2999-12-31'),
	(34624,'19','082',' 04','082049',82049,'Monreale','Monreale','','PA',1,'1840-01-01','2999-12-31'),
	(34625,'19','082',' 05','082050',82050,'Montelepre','Montelepre','','PA',1,'1840-01-01','2999-12-31'),
	(34626,'19','082',' 05','082051',82051,'Montemaggiore Belsito','Montemaggiore Belsito','','PA',1,'1840-01-01','2999-12-31'),
	(34627,'19','082',' 05','082052',82052,'Palazzo Adriano','Palazzo Adriano','','PA',1,'1840-01-01','2999-12-31'),
	(34628,'19','082',' 05','082053',82053,'Palermo','Palermo','','PA',1,'1840-01-01','2999-12-31'),
	(34629,'19','082',' 05','082054',82054,'Partinico','Partinico','','PA',1,'1840-01-01','2999-12-31'),
	(34630,'19','082',' 05','082055',82055,'Petralia Soprana','Petralia Soprana','','PA',1,'1840-01-01','2999-12-31'),
	(34631,'19','082',' 05','082056',82056,'Petralia Sottana','Petralia Sottana','','PA',1,'1840-01-01','2999-12-31'),
	(34632,'19','082',' 05','082057',82057,'Piana degli Albanesi','Piana degli Albanesi','','PA',1,'1840-01-01','2999-12-31'),
	(34633,'19','082',' 05','082058',82058,'Polizzi Generosa','Polizzi Generosa','','PA',1,'1840-01-01','2999-12-31'),
	(34634,'19','082',' 05','082059',82059,'Pollina','Pollina','','PA',1,'1840-01-01','2999-12-31'),
	(34635,'19','082',' 06','082060',82060,'Prizzi','Prizzi','','PA',1,'1840-01-01','2999-12-31'),
	(34636,'19','082',' 06','082061',82061,'Roccamena','Roccamena','','PA',1,'1840-01-01','2999-12-31'),
	(34637,'19','082',' 06','082062',82062,'Roccapalumba','Roccapalumba','','PA',1,'1840-01-01','2999-12-31'),
	(34638,'19','082',' 06','082063',82063,'San Cipirello','San Cipirello','','PA',1,'1840-01-01','2999-12-31'),
	(34639,'19','082',' 06','082064',82064,'San Giuseppe Jato','San Giuseppe Jato','','PA',1,'1840-01-01','2999-12-31'),
	(34640,'19','082',' 06','082065',82065,'San Mauro Castelverde','San Mauro Castelverde','','PA',1,'1840-01-01','2999-12-31'),
	(34641,'19','082',' 06','082066',82066,'Santa Cristina Gela','Santa Cristina Gela','','PA',1,'1840-01-01','2999-12-31'),
	(34642,'19','082',' 06','082067',82067,'Santa Flavia','Santa Flavia','','PA',1,'1840-01-01','2999-12-31'),
	(34643,'19','082',' 06','082068',82068,'Sciara','Sciara','','PA',1,'1840-01-01','2999-12-31'),
	(34644,'19','082',' 06','082069',82069,'Sclafani Bagni','Sclafani Bagni','','PA',1,'1840-01-01','2999-12-31'),
	(34645,'19','082',' 07','082070',82070,'Termini Imerese','Termini Imerese','','PA',1,'1840-01-01','2999-12-31'),
	(34646,'19','082',' 07','082071',82071,'Terrasini','Terrasini','','PA',1,'1840-01-01','2999-12-31'),
	(34647,'19','082',' 07','082072',82072,'Torretta','Torretta','','PA',1,'1840-01-01','2999-12-31'),
	(34648,'19','082',' 07','082073',82073,'Trabia','Trabia','','PA',1,'1840-01-01','2999-12-31'),
	(34649,'19','082',' 07','082074',82074,'Trappeto','Trappeto','','PA',1,'1840-01-01','2999-12-31'),
	(34650,'19','082',' 07','082075',82075,'Ustica','Ustica','','PA',1,'1840-01-01','2999-12-31'),
	(34651,'19','082',' 07','082076',82076,'Valledolmo','Valledolmo','','PA',1,'1840-01-01','2999-12-31'),
	(34652,'19','082',' 07','082077',82077,'Ventimiglia di Sicilia','Ventimiglia di Sicilia','','PA',1,'1840-01-01','2999-12-31'),
	(34653,'19','082',' 07','082078',82078,'Vicari','Vicari','','PA',1,'1840-01-01','2999-12-31'),
	(34654,'19','082',' 07','082079',82079,'Villabate','Villabate','','PA',1,'1840-01-01','2999-12-31'),
	(34655,'19','082',' 08','082080',82080,'Villafrati','Villafrati','','PA',1,'1840-01-01','2999-12-31'),
	(34656,'19','082',' 08','082081',82081,'Scillato','Scillato','','PA',1,'1840-01-01','2999-12-31'),
	(34657,'19','082',' 08','082082',82082,'Blufi','Blufi','','PA',1,'1840-01-01','2999-12-31'),
	(34658,'19','083',' 00','083001',83001,'Alcara li Fusi','Alcara li Fusi','','ME',1,'1840-01-01','2999-12-31'),
	(34659,'19','083',' 00','083002',83002,'Alì','Alì','','ME',1,'1840-01-01','2999-12-31'),
	(34660,'19','083',' 00','083003',83003,'Alì Terme','Alì Terme','','ME',1,'1840-01-01','2999-12-31'),
	(34661,'19','083',' 00','083004',83004,'Antillo','Antillo','','ME',1,'1840-01-01','2999-12-31'),
	(34662,'19','083',' 00','083005',83005,'Barcellona Pozzo di Gotto','Barcellona Pozzo di Gotto','','ME',1,'1840-01-01','2999-12-31'),
	(34663,'19','083',' 00','083006',83006,'Basicò','Basicò','','ME',1,'1840-01-01','2999-12-31'),
	(34664,'19','083',' 00','083007',83007,'Brolo','Brolo','','ME',1,'1840-01-01','2999-12-31'),
	(34665,'19','083',' 00','083008',83008,'Capizzi','Capizzi','','ME',1,'1840-01-01','2999-12-31'),
	(34666,'19','083',' 00','083009',83009,'Capo d\'Orlando','Capo d\'Orlando','','ME',1,'1840-01-01','2999-12-31'),
	(34667,'19','083',' 01','083010',83010,'Capri Leone','Capri Leone','','ME',1,'1840-01-01','2999-12-31'),
	(34668,'19','083',' 01','083011',83011,'Caronia','Caronia','','ME',1,'1840-01-01','2999-12-31'),
	(34669,'19','083',' 01','083012',83012,'Casalvecchio Siculo','Casalvecchio Siculo','','ME',1,'1840-01-01','2999-12-31'),
	(34670,'19','083',' 01','083013',83013,'Castel di Lucio','Castel di Lucio','','ME',1,'1840-01-01','2999-12-31'),
	(34671,'19','083',' 01','083014',83014,'Castell\'Umberto','Castell\'Umberto','','ME',1,'1840-01-01','2999-12-31'),
	(34672,'19','083',' 01','083015',83015,'Castelmola','Castelmola','','ME',1,'1840-01-01','2999-12-31'),
	(34673,'19','083',' 01','083016',83016,'Castroreale','Castroreale','','ME',1,'1840-01-01','2999-12-31'),
	(34674,'19','083',' 01','083017',83017,'Cesarò','Cesarò','','ME',1,'1840-01-01','2999-12-31'),
	(34675,'19','083',' 01','083018',83018,'Condrò','Condrò','','ME',1,'1840-01-01','2999-12-31'),
	(34676,'19','083',' 01','083019',83019,'Falcone','Falcone','','ME',1,'1840-01-01','2999-12-31'),
	(34677,'19','083',' 02','083020',83020,'Ficarra','Ficarra','','ME',1,'1840-01-01','2999-12-31'),
	(34678,'19','083',' 02','083021',83021,'Fiumedinisi','Fiumedinisi','','ME',1,'1840-01-01','2999-12-31'),
	(34679,'19','083',' 02','083022',83022,'Floresta','Floresta','','ME',1,'1840-01-01','2999-12-31'),
	(34680,'19','083',' 02','083023',83023,'Fondachelli-Fantina','Fondachelli-Fantina','','ME',1,'1840-01-01','2999-12-31'),
	(34681,'19','083',' 02','083024',83024,'Forza d\'Agrò','Forza d\'Agrò','','ME',1,'1840-01-01','2999-12-31'),
	(34682,'19','083',' 02','083025',83025,'Francavilla di Sicilia','Francavilla di Sicilia','','ME',1,'1840-01-01','2999-12-31'),
	(34683,'19','083',' 02','083026',83026,'Frazzanò','Frazzanò','','ME',1,'1840-01-01','2999-12-31'),
	(34684,'19','083',' 02','083027',83027,'Furci Siculo','Furci Siculo','','ME',1,'1840-01-01','2999-12-31'),
	(34685,'19','083',' 02','083028',83028,'Furnari','Furnari','','ME',1,'1840-01-01','2999-12-31'),
	(34686,'19','083',' 02','083029',83029,'Gaggi','Gaggi','','ME',1,'1840-01-01','2999-12-31'),
	(34687,'19','083',' 03','083030',83030,'Galati Mamertino','Galati Mamertino','','ME',1,'1840-01-01','2999-12-31'),
	(34688,'19','083',' 03','083031',83031,'Gallodoro','Gallodoro','','ME',1,'1840-01-01','2999-12-31'),
	(34689,'19','083',' 03','083032',83032,'Giardini-Naxos','Giardini-Naxos','','ME',1,'1840-01-01','2999-12-31'),
	(34690,'19','083',' 03','083033',83033,'Gioiosa Marea','Gioiosa Marea','','ME',1,'1840-01-01','2999-12-31'),
	(34691,'19','083',' 03','083034',83034,'Graniti','Graniti','','ME',1,'1840-01-01','2999-12-31'),
	(34692,'19','083',' 03','083035',83035,'Gualtieri Sicaminò','Gualtieri Sicaminò','','ME',1,'1840-01-01','2999-12-31'),
	(34693,'19','083',' 03','083036',83036,'Itala','Itala','','ME',1,'1840-01-01','2999-12-31'),
	(34694,'19','083',' 03','083037',83037,'Leni','Leni','','ME',1,'1840-01-01','2999-12-31'),
	(34695,'19','083',' 03','083038',83038,'Letojanni','Letojanni','','ME',1,'1840-01-01','2999-12-31'),
	(34696,'19','083',' 03','083039',83039,'Librizzi','Librizzi','','ME',1,'1840-01-01','2999-12-31'),
	(34697,'19','083',' 04','083040',83040,'Limina','Limina','','ME',1,'1840-01-01','2999-12-31'),
	(34698,'19','083',' 04','083041',83041,'Lipari','Lipari','','ME',1,'1840-01-01','2999-12-31'),
	(34699,'19','083',' 04','083042',83042,'Longi','Longi','','ME',1,'1840-01-01','2999-12-31'),
	(34700,'19','083',' 04','083043',83043,'Malfa','Malfa','','ME',1,'1840-01-01','2999-12-31'),
	(34701,'19','083',' 04','083044',83044,'Malvagna','Malvagna','','ME',1,'1840-01-01','2999-12-31'),
	(34702,'19','083',' 04','083045',83045,'Mandanici','Mandanici','','ME',1,'1840-01-01','2999-12-31'),
	(34703,'19','083',' 04','083046',83046,'Mazzarrà Sant\'Andrea','Mazzarrà Sant\'Andrea','','ME',1,'1840-01-01','2999-12-31'),
	(34704,'19','083',' 04','083047',83047,'Merì','Merì','','ME',1,'1840-01-01','2999-12-31'),
	(34705,'19','083',' 04','083048',83048,'Messina','Messina','','ME',1,'1840-01-01','2999-12-31'),
	(34706,'19','083',' 04','083049',83049,'Milazzo','Milazzo','','ME',1,'1840-01-01','2999-12-31'),
	(34707,'19','083',' 05','083050',83050,'Militello Rosmarino','Militello Rosmarino','','ME',1,'1840-01-01','2999-12-31'),
	(34708,'19','083',' 05','083051',83051,'Mirto','Mirto','','ME',1,'1840-01-01','2999-12-31'),
	(34709,'19','083',' 05','083052',83052,'Mistretta','Mistretta','','ME',1,'1840-01-01','2999-12-31'),
	(34710,'19','083',' 05','083053',83053,'Moio Alcantara','Moio Alcantara','','ME',1,'1840-01-01','2999-12-31'),
	(34711,'19','083',' 05','083054',83054,'Monforte San Giorgio','Monforte San Giorgio','','ME',1,'1840-01-01','2999-12-31'),
	(34712,'19','083',' 05','083055',83055,'Mongiuffi Melia','Mongiuffi Melia','','ME',1,'1840-01-01','2999-12-31'),
	(34713,'19','083',' 05','083056',83056,'Montagnareale','Montagnareale','','ME',1,'1840-01-01','2999-12-31'),
	(34714,'19','083',' 05','083057',83057,'Montalbano Elicona','Montalbano Elicona','','ME',1,'1840-01-01','2999-12-31'),
	(34715,'19','083',' 05','083058',83058,'Motta Camastra','Motta Camastra','','ME',1,'1840-01-01','2999-12-31'),
	(34716,'19','083',' 05','083059',83059,'Motta d\'Affermo','Motta d\'Affermo','','ME',1,'1840-01-01','2999-12-31'),
	(34717,'19','083',' 06','083060',83060,'Naso','Naso','','ME',1,'1840-01-01','2999-12-31'),
	(34718,'19','083',' 06','083061',83061,'Nizza di Sicilia','Nizza di Sicilia','','ME',1,'1840-01-01','2999-12-31'),
	(34719,'19','083',' 06','083062',83062,'Novara di Sicilia','Novara di Sicilia','','ME',1,'1840-01-01','2999-12-31'),
	(34720,'19','083',' 06','083063',83063,'Oliveri','Oliveri','','ME',1,'1840-01-01','2999-12-31'),
	(34721,'19','083',' 06','083064',83064,'Pace del Mela','Pace del Mela','','ME',1,'1840-01-01','2999-12-31'),
	(34722,'19','083',' 06','083065',83065,'Pagliara','Pagliara','','ME',1,'1840-01-01','2999-12-31'),
	(34723,'19','083',' 06','083066',83066,'Patti','Patti','','ME',1,'1840-01-01','2999-12-31'),
	(34724,'19','083',' 06','083067',83067,'Pettineo','Pettineo','','ME',1,'1840-01-01','2999-12-31'),
	(34725,'19','083',' 06','083068',83068,'Piraino','Piraino','','ME',1,'1840-01-01','2999-12-31'),
	(34726,'19','083',' 06','083069',83069,'Raccuja','Raccuja','','ME',1,'1840-01-01','2999-12-31'),
	(34727,'19','083',' 07','083070',83070,'Reitano','Reitano','','ME',1,'1840-01-01','2999-12-31'),
	(34728,'19','083',' 07','083071',83071,'Roccafiorita','Roccafiorita','','ME',1,'1840-01-01','2999-12-31'),
	(34729,'19','083',' 07','083072',83072,'Roccalumera','Roccalumera','','ME',1,'1840-01-01','2999-12-31'),
	(34730,'19','083',' 07','083073',83073,'Roccavaldina','Roccavaldina','','ME',1,'1840-01-01','2999-12-31'),
	(34731,'19','083',' 07','083074',83074,'Roccella Valdemone','Roccella Valdemone','','ME',1,'1840-01-01','2999-12-31'),
	(34732,'19','083',' 07','083075',83075,'Rodì Milici','Rodì Milici','','ME',1,'1840-01-01','2999-12-31'),
	(34733,'19','083',' 07','083076',83076,'Rometta','Rometta','','ME',1,'1840-01-01','2999-12-31'),
	(34734,'19','083',' 07','083077',83077,'San Filippo del Mela','San Filippo del Mela','','ME',1,'1840-01-01','2999-12-31'),
	(34735,'19','083',' 07','083078',83078,'San Fratello','San Fratello','','ME',1,'1840-01-01','2999-12-31'),
	(34736,'19','083',' 07','083079',83079,'San Marco d\'Alunzio','San Marco d\'Alunzio','','ME',1,'1840-01-01','2999-12-31'),
	(34737,'19','083',' 08','083080',83080,'San Pier Niceto','San Pier Niceto','','ME',1,'1840-01-01','2999-12-31'),
	(34738,'19','083',' 08','083081',83081,'San Piero Patti','San Piero Patti','','ME',1,'1840-01-01','2999-12-31'),
	(34739,'19','083',' 08','083082',83082,'San Salvatore di Fitalia','San Salvatore di Fitalia','','ME',1,'1840-01-01','2999-12-31'),
	(34740,'19','083',' 08','083083',83083,'Santa Domenica Vittoria','Santa Domenica Vittoria','','ME',1,'1840-01-01','2999-12-31'),
	(34741,'19','083',' 08','083084',83084,'Sant\'Agata di Militello','Sant\'Agata di Militello','','ME',1,'1840-01-01','2999-12-31'),
	(34742,'19','083',' 08','083085',83085,'Sant\'Alessio Siculo','Sant\'Alessio Siculo','','ME',1,'1840-01-01','2999-12-31'),
	(34743,'19','083',' 08','083086',83086,'Santa Lucia del Mela','Santa Lucia del Mela','','ME',1,'1840-01-01','2999-12-31'),
	(34744,'19','083',' 08','083087',83087,'Santa Marina Salina','Santa Marina Salina','','ME',1,'1840-01-01','2999-12-31'),
	(34745,'19','083',' 08','083088',83088,'Sant\'Angelo di Brolo','Sant\'Angelo di Brolo','','ME',1,'1840-01-01','2999-12-31'),
	(34746,'19','083',' 08','083089',83089,'Santa Teresa di Riva','Santa Teresa di Riva','','ME',1,'1840-01-01','2999-12-31'),
	(34747,'19','083',' 09','083090',83090,'San Teodoro','San Teodoro','','ME',1,'1840-01-01','2999-12-31'),
	(34748,'19','083',' 09','083091',83091,'Santo Stefano di Camastra','Santo Stefano di Camastra','','ME',1,'1840-01-01','2999-12-31'),
	(34749,'19','083',' 09','083092',83092,'Saponara','Saponara','','ME',1,'1840-01-01','2999-12-31'),
	(34750,'19','083',' 09','083093',83093,'Savoca','Savoca','','ME',1,'1840-01-01','2999-12-31'),
	(34751,'19','083',' 09','083094',83094,'Scaletta Zanclea','Scaletta Zanclea','','ME',1,'1840-01-01','2999-12-31'),
	(34752,'19','083',' 09','083095',83095,'Sinagra','Sinagra','','ME',1,'1840-01-01','2999-12-31'),
	(34753,'19','083',' 09','083096',83096,'Spadafora','Spadafora','','ME',1,'1840-01-01','2999-12-31'),
	(34754,'19','083',' 09','083097',83097,'Taormina','Taormina','','ME',1,'1840-01-01','2999-12-31'),
	(34755,'19','083',' 09','083098',83098,'Torregrotta','Torregrotta','','ME',1,'1840-01-01','2999-12-31'),
	(34756,'19','083',' 09','083099',83099,'Tortorici','Tortorici','','ME',1,'1840-01-01','2999-12-31'),
	(34757,'19','083',' 10','083100',83100,'Tripi','Tripi','','ME',1,'1840-01-01','2999-12-31'),
	(34758,'19','083',' 10','083101',83101,'Tusa','Tusa','','ME',1,'1840-01-01','2999-12-31'),
	(34759,'19','083',' 10','083102',83102,'Ucria','Ucria','','ME',1,'1840-01-01','2999-12-31'),
	(34760,'19','083',' 10','083103',83103,'Valdina','Valdina','','ME',1,'1840-01-01','2999-12-31'),
	(34761,'19','083',' 10','083104',83104,'Venetico','Venetico','','ME',1,'1840-01-01','2999-12-31'),
	(34762,'19','083',' 10','083105',83105,'Villafranca Tirrena','Villafranca Tirrena','','ME',1,'1840-01-01','2999-12-31'),
	(34763,'19','083',' 10','083106',83106,'Terme Vigliatore','Terme Vigliatore','','ME',1,'1840-01-01','2999-12-31'),
	(34764,'19','083',' 10','083107',83107,'Acquedolci','Acquedolci','','ME',1,'1840-01-01','2999-12-31'),
	(34765,'19','083',' 10','083108',83108,'Torrenova','Torrenova','','ME',1,'1840-01-01','2999-12-31'),
	(34766,'19','084',' 00','084001',84001,'Agrigento','Agrigento','','AG',1,'1840-01-01','2999-12-31'),
	(34767,'19','084',' 00','084002',84002,'Alessandria della Rocca','Alessandria della Rocca','','AG',1,'1840-01-01','2999-12-31'),
	(34768,'19','084',' 00','084003',84003,'Aragona','Aragona','','AG',1,'1840-01-01','2999-12-31'),
	(34769,'19','084',' 00','084004',84004,'Bivona','Bivona','','AG',1,'1840-01-01','2999-12-31'),
	(34770,'19','084',' 00','084005',84005,'Burgio','Burgio','','AG',1,'1840-01-01','2999-12-31'),
	(34771,'19','084',' 00','084006',84006,'Calamonaci','Calamonaci','','AG',1,'1840-01-01','2999-12-31'),
	(34772,'19','084',' 00','084007',84007,'Caltabellotta','Caltabellotta','','AG',1,'1840-01-01','2999-12-31'),
	(34773,'19','084',' 00','084008',84008,'Camastra','Camastra','','AG',1,'1840-01-01','2999-12-31'),
	(34774,'19','084',' 00','084009',84009,'Cammarata','Cammarata','','AG',1,'1840-01-01','2999-12-31'),
	(34775,'19','084',' 01','084010',84010,'Campobello di Licata','Campobello di Licata','','AG',1,'1840-01-01','2999-12-31'),
	(34776,'19','084',' 01','084011',84011,'Canicattì','Canicattì','','AG',1,'1840-01-01','2999-12-31'),
	(34777,'19','084',' 01','084012',84012,'Casteltermini','Casteltermini','','AG',1,'1840-01-01','2999-12-31'),
	(34778,'19','084',' 01','084013',84013,'Castrofilippo','Castrofilippo','','AG',1,'1840-01-01','2999-12-31'),
	(34779,'19','084',' 01','084014',84014,'Cattolica Eraclea','Cattolica Eraclea','','AG',1,'1840-01-01','2999-12-31'),
	(34780,'19','084',' 01','084015',84015,'Cianciana','Cianciana','','AG',1,'1840-01-01','2999-12-31'),
	(34781,'19','084',' 01','084016',84016,'Comitini','Comitini','','AG',1,'1840-01-01','2999-12-31'),
	(34782,'19','084',' 01','084017',84017,'Favara','Favara','','AG',1,'1840-01-01','2999-12-31'),
	(34783,'19','084',' 01','084018',84018,'Grotte','Grotte','','AG',1,'1840-01-01','2999-12-31'),
	(34784,'19','084',' 01','084019',84019,'Joppolo Giancaxio','Joppolo Giancaxio','','AG',1,'1840-01-01','2999-12-31'),
	(34785,'19','084',' 02','084020',84020,'Lampedusa e Linosa','Lampedusa e Linosa','','AG',1,'1840-01-01','2999-12-31'),
	(34786,'19','084',' 02','084021',84021,'Licata','Licata','','AG',1,'1840-01-01','2999-12-31'),
	(34787,'19','084',' 02','084022',84022,'Lucca Sicula','Lucca Sicula','','AG',1,'1840-01-01','2999-12-31'),
	(34788,'19','084',' 02','084023',84023,'Menfi','Menfi','','AG',1,'1840-01-01','2999-12-31'),
	(34789,'19','084',' 02','084024',84024,'Montallegro','Montallegro','','AG',1,'1840-01-01','2999-12-31'),
	(34790,'19','084',' 02','084025',84025,'Montevago','Montevago','','AG',1,'1840-01-01','2999-12-31'),
	(34791,'19','084',' 02','084026',84026,'Naro','Naro','','AG',1,'1840-01-01','2999-12-31'),
	(34792,'19','084',' 02','084027',84027,'Palma di Montechiaro','Palma di Montechiaro','','AG',1,'1840-01-01','2999-12-31'),
	(34793,'19','084',' 02','084028',84028,'Porto Empedocle','Porto Empedocle','','AG',1,'1840-01-01','2999-12-31'),
	(34794,'19','084',' 02','084029',84029,'Racalmuto','Racalmuto','','AG',1,'1840-01-01','2999-12-31'),
	(34795,'19','084',' 03','084030',84030,'Raffadali','Raffadali','','AG',1,'1840-01-01','2999-12-31'),
	(34796,'19','084',' 03','084031',84031,'Ravanusa','Ravanusa','','AG',1,'1840-01-01','2999-12-31'),
	(34797,'19','084',' 03','084032',84032,'Realmonte','Realmonte','','AG',1,'1840-01-01','2999-12-31'),
	(34798,'19','084',' 03','084033',84033,'Ribera','Ribera','','AG',1,'1840-01-01','2999-12-31'),
	(34799,'19','084',' 03','084034',84034,'Sambuca di Sicilia','Sambuca di Sicilia','','AG',1,'1840-01-01','2999-12-31'),
	(34800,'19','084',' 03','084035',84035,'San Biagio Platani','San Biagio Platani','','AG',1,'1840-01-01','2999-12-31'),
	(34801,'19','084',' 03','084036',84036,'San Giovanni Gemini','San Giovanni Gemini','','AG',1,'1840-01-01','2999-12-31'),
	(34802,'19','084',' 03','084037',84037,'Santa Elisabetta','Santa Elisabetta','','AG',1,'1840-01-01','2999-12-31'),
	(34803,'19','084',' 03','084038',84038,'Santa Margherita di Belice','Santa Margherita di Belice','','AG',1,'1840-01-01','2999-12-31'),
	(34804,'19','084',' 03','084039',84039,'Sant\'Angelo Muxaro','Sant\'Angelo Muxaro','','AG',1,'1840-01-01','2999-12-31'),
	(34805,'19','084',' 04','084040',84040,'Santo Stefano Quisquina','Santo Stefano Quisquina','','AG',1,'1840-01-01','2999-12-31'),
	(34806,'19','084',' 04','084041',84041,'Sciacca','Sciacca','','AG',1,'1840-01-01','2999-12-31'),
	(34807,'19','084',' 04','084042',84042,'Siculiana','Siculiana','','AG',1,'1840-01-01','2999-12-31'),
	(34808,'19','084',' 04','084043',84043,'Villafranca Sicula','Villafranca Sicula','','AG',1,'1840-01-01','2999-12-31'),
	(34809,'19','085',' 00','085001',85001,'Acquaviva Platani','Acquaviva Platani','','CL',1,'1840-01-01','2999-12-31'),
	(34810,'19','085',' 00','085002',85002,'Bompensiere','Bompensiere','','CL',1,'1840-01-01','2999-12-31'),
	(34811,'19','085',' 00','085003',85003,'Butera','Butera','','CL',1,'1840-01-01','2999-12-31'),
	(34812,'19','085',' 00','085004',85004,'Caltanissetta','Caltanissetta','','CL',1,'1840-01-01','2999-12-31'),
	(34813,'19','085',' 00','085005',85005,'Campofranco','Campofranco','','CL',1,'1840-01-01','2999-12-31'),
	(34814,'19','085',' 00','085006',85006,'Delia','Delia','','CL',1,'1840-01-01','2999-12-31'),
	(34815,'19','085',' 00','085007',85007,'Gela','Gela','','CL',1,'1840-01-01','2999-12-31'),
	(34816,'19','085',' 00','085008',85008,'Marianopoli','Marianopoli','','CL',1,'1840-01-01','2999-12-31'),
	(34817,'19','085',' 00','085009',85009,'Mazzarino','Mazzarino','','CL',1,'1840-01-01','2999-12-31'),
	(34818,'19','085',' 01','085010',85010,'Milena','Milena','','CL',1,'1840-01-01','2999-12-31'),
	(34819,'19','085',' 01','085011',85011,'Montedoro','Montedoro','','CL',1,'1840-01-01','2999-12-31'),
	(34820,'19','085',' 01','085012',85012,'Mussomeli','Mussomeli','','CL',1,'1840-01-01','2999-12-31'),
	(34821,'19','085',' 01','085013',85013,'Niscemi','Niscemi','','CL',1,'1840-01-01','2999-12-31'),
	(34822,'19','085',' 01','085014',85014,'Resuttano','Resuttano','','CL',1,'1840-01-01','2999-12-31'),
	(34823,'19','085',' 01','085015',85015,'Riesi','Riesi','','CL',1,'1840-01-01','2999-12-31'),
	(34824,'19','085',' 01','085016',85016,'San Cataldo','San Cataldo','','CL',1,'1840-01-01','2999-12-31'),
	(34825,'19','085',' 01','085017',85017,'Santa Caterina Villarmosa','Santa Caterina Villarmosa','','CL',1,'1840-01-01','2999-12-31'),
	(34826,'19','085',' 01','085018',85018,'Serradifalco','Serradifalco','','CL',1,'1840-01-01','2999-12-31'),
	(34827,'19','085',' 01','085019',85019,'Sommatino','Sommatino','','CL',1,'1840-01-01','2999-12-31'),
	(34828,'19','085',' 02','085020',85020,'Sutera','Sutera','','CL',1,'1840-01-01','2999-12-31'),
	(34829,'19','085',' 02','085021',85021,'Vallelunga Pratameno','Vallelunga Pratameno','','CL',1,'1840-01-01','2999-12-31'),
	(34830,'19','085',' 02','085022',85022,'Villalba','Villalba','','CL',1,'1840-01-01','2999-12-31'),
	(34831,'19','086',' 00','086001',86001,'Agira','Agira','','EN',1,'1840-01-01','2999-12-31'),
	(34832,'19','086',' 00','086002',86002,'Aidone','Aidone','','EN',1,'1840-01-01','2999-12-31'),
	(34833,'19','086',' 00','086003',86003,'Assoro','Assoro','','EN',1,'1840-01-01','2999-12-31'),
	(34834,'19','086',' 00','086004',86004,'Barrafranca','Barrafranca','','EN',1,'1840-01-01','2999-12-31'),
	(34835,'19','086',' 00','086005',86005,'Calascibetta','Calascibetta','','EN',1,'1840-01-01','2999-12-31'),
	(34836,'19','086',' 00','086006',86006,'Catenanuova','Catenanuova','','EN',1,'1840-01-01','2999-12-31'),
	(34837,'19','086',' 00','086007',86007,'Centuripe','Centuripe','','EN',1,'1840-01-01','2999-12-31'),
	(34838,'19','086',' 00','086008',86008,'Cerami','Cerami','','EN',1,'1840-01-01','2999-12-31'),
	(34839,'19','086',' 00','086009',86009,'Enna','Enna','','EN',1,'1840-01-01','2999-12-31'),
	(34840,'19','086',' 01','086010',86010,'Gagliano Castelferrato','Gagliano Castelferrato','','EN',1,'1840-01-01','2999-12-31'),
	(34841,'19','086',' 01','086011',86011,'Leonforte','Leonforte','','EN',1,'1840-01-01','2999-12-31'),
	(34842,'19','086',' 01','086012',86012,'Nicosia','Nicosia','','EN',1,'1840-01-01','2999-12-31'),
	(34843,'19','086',' 01','086013',86013,'Nissoria','Nissoria','','EN',1,'1840-01-01','2999-12-31'),
	(34844,'19','086',' 01','086014',86014,'Piazza Armerina','Piazza Armerina','','EN',1,'1840-01-01','2999-12-31'),
	(34845,'19','086',' 01','086015',86015,'Pietraperzia','Pietraperzia','','EN',1,'1840-01-01','2999-12-31'),
	(34846,'19','086',' 01','086016',86016,'Regalbuto','Regalbuto','','EN',1,'1840-01-01','2999-12-31'),
	(34847,'19','086',' 01','086017',86017,'Sperlinga','Sperlinga','','EN',1,'1840-01-01','2999-12-31'),
	(34848,'19','086',' 01','086018',86018,'Troina','Troina','','EN',1,'1840-01-01','2999-12-31'),
	(34849,'19','086',' 01','086019',86019,'Valguarnera Caropepe','Valguarnera Caropepe','','EN',1,'1840-01-01','2999-12-31'),
	(34850,'19','086',' 02','086020',86020,'Villarosa','Villarosa','','EN',1,'1840-01-01','2999-12-31'),
	(34851,'19','087',' 00','087001',87001,'Aci Bonaccorsi','Aci Bonaccorsi','','CT',1,'1840-01-01','2999-12-31'),
	(34852,'19','087',' 00','087002',87002,'Aci Castello','Aci Castello','','CT',1,'1840-01-01','2999-12-31'),
	(34853,'19','087',' 00','087003',87003,'Aci Catena','Aci Catena','','CT',1,'1840-01-01','2999-12-31'),
	(34854,'19','087',' 00','087004',87004,'Acireale','Acireale','','CT',1,'1840-01-01','2999-12-31'),
	(34855,'19','087',' 00','087005',87005,'Aci Sant\'Antonio','Aci Sant\'Antonio','','CT',1,'1840-01-01','2999-12-31'),
	(34856,'19','087',' 00','087006',87006,'Adrano','Adrano','','CT',1,'1840-01-01','2999-12-31'),
	(34857,'19','087',' 00','087007',87007,'Belpasso','Belpasso','','CT',1,'1840-01-01','2999-12-31'),
	(34858,'19','087',' 00','087008',87008,'Biancavilla','Biancavilla','','CT',1,'1840-01-01','2999-12-31'),
	(34859,'19','087',' 00','087009',87009,'Bronte','Bronte','','CT',1,'1840-01-01','2999-12-31'),
	(34860,'19','087',' 01','087010',87010,'Calatabiano','Calatabiano','','CT',1,'1840-01-01','2999-12-31'),
	(34861,'19','087',' 01','087011',87011,'Caltagirone','Caltagirone','','CT',1,'1840-01-01','2999-12-31'),
	(34862,'19','087',' 01','087012',87012,'Camporotondo Etneo','Camporotondo Etneo','','CT',1,'1840-01-01','2999-12-31'),
	(34863,'19','087',' 01','087013',87013,'Castel di Iudica','Castel di Iudica','','CT',1,'1840-01-01','2999-12-31'),
	(34864,'19','087',' 01','087014',87014,'Castiglione di Sicilia','Castiglione di Sicilia','','CT',1,'1840-01-01','2999-12-31'),
	(34865,'19','087',' 01','087015',87015,'Catania','Catania','','CT',1,'1840-01-01','2999-12-31'),
	(34866,'19','087',' 01','087016',87016,'Fiumefreddo di Sicilia','Fiumefreddo di Sicilia','','CT',1,'1840-01-01','2999-12-31'),
	(34867,'19','087',' 01','087017',87017,'Giarre','Giarre','','CT',1,'1840-01-01','2999-12-31'),
	(34868,'19','087',' 01','087018',87018,'Grammichele','Grammichele','','CT',1,'1840-01-01','2999-12-31'),
	(34869,'19','087',' 01','087019',87019,'Gravina di Catania','Gravina di Catania','','CT',1,'1840-01-01','2999-12-31'),
	(34870,'19','087',' 02','087020',87020,'Licodia Eubea','Licodia Eubea','','CT',1,'1840-01-01','2999-12-31'),
	(34871,'19','087',' 02','087021',87021,'Linguaglossa','Linguaglossa','','CT',1,'1840-01-01','2999-12-31'),
	(34872,'19','087',' 02','087022',87022,'Maletto','Maletto','','CT',1,'1840-01-01','2999-12-31'),
	(34873,'19','087',' 02','087023',87023,'Mascali','Mascali','','CT',1,'1840-01-01','2999-12-31'),
	(34874,'19','087',' 02','087024',87024,'Mascalucia','Mascalucia','','CT',1,'1840-01-01','2999-12-31'),
	(34875,'19','087',' 02','087025',87025,'Militello in Val di Catania','Militello in Val di Catania','','CT',1,'1840-01-01','2999-12-31'),
	(34876,'19','087',' 02','087026',87026,'Milo','Milo','','CT',1,'1840-01-01','2999-12-31'),
	(34877,'19','087',' 02','087027',87027,'Mineo','Mineo','','CT',1,'1840-01-01','2999-12-31'),
	(34878,'19','087',' 02','087028',87028,'Mirabella Imbaccari','Mirabella Imbaccari','','CT',1,'1840-01-01','2999-12-31'),
	(34879,'19','087',' 02','087029',87029,'Misterbianco','Misterbianco','','CT',1,'1840-01-01','2999-12-31'),
	(34880,'19','087',' 03','087030',87030,'Motta Sant\'Anastasia','Motta Sant\'Anastasia','','CT',1,'1840-01-01','2999-12-31'),
	(34881,'19','087',' 03','087031',87031,'Nicolosi','Nicolosi','','CT',1,'1840-01-01','2999-12-31'),
	(34882,'19','087',' 03','087032',87032,'Palagonia','Palagonia','','CT',1,'1840-01-01','2999-12-31'),
	(34883,'19','087',' 03','087033',87033,'Paternò','Paternò','','CT',1,'1840-01-01','2999-12-31'),
	(34884,'19','087',' 03','087034',87034,'Pedara','Pedara','','CT',1,'1840-01-01','2999-12-31'),
	(34885,'19','087',' 03','087035',87035,'Piedimonte Etneo','Piedimonte Etneo','','CT',1,'1840-01-01','2999-12-31'),
	(34886,'19','087',' 03','087036',87036,'Raddusa','Raddusa','','CT',1,'1840-01-01','2999-12-31'),
	(34887,'19','087',' 03','087037',87037,'Ramacca','Ramacca','','CT',1,'1840-01-01','2999-12-31'),
	(34888,'19','087',' 03','087038',87038,'Randazzo','Randazzo','','CT',1,'1840-01-01','2999-12-31'),
	(34889,'19','087',' 03','087039',87039,'Riposto','Riposto','','CT',1,'1840-01-01','2999-12-31'),
	(34890,'19','087',' 04','087040',87040,'San Cono','San Cono','','CT',1,'1840-01-01','2999-12-31'),
	(34891,'19','087',' 04','087041',87041,'San Giovanni la Punta','San Giovanni la Punta','','CT',1,'1840-01-01','2999-12-31'),
	(34892,'19','087',' 04','087042',87042,'San Gregorio di Catania','San Gregorio di Catania','','CT',1,'1840-01-01','2999-12-31'),
	(34893,'19','087',' 04','087043',87043,'San Michele di Ganzaria','San Michele di Ganzaria','','CT',1,'1840-01-01','2999-12-31'),
	(34894,'19','087',' 04','087044',87044,'San Pietro Clarenza','San Pietro Clarenza','','CT',1,'1840-01-01','2999-12-31'),
	(34895,'19','087',' 04','087045',87045,'Sant\'Agata li Battiati','Sant\'Agata li Battiati','','CT',1,'1840-01-01','2999-12-31'),
	(34896,'19','087',' 04','087046',87046,'Sant\'Alfio','Sant\'Alfio','','CT',1,'1840-01-01','2999-12-31'),
	(34897,'19','087',' 04','087047',87047,'Santa Maria di Licodia','Santa Maria di Licodia','','CT',1,'1840-01-01','2999-12-31'),
	(34898,'19','087',' 04','087048',87048,'Santa Venerina','Santa Venerina','','CT',1,'1840-01-01','2999-12-31'),
	(34899,'19','087',' 04','087049',87049,'Scordia','Scordia','','CT',1,'1840-01-01','2999-12-31'),
	(34900,'19','087',' 05','087050',87050,'Trecastagni','Trecastagni','','CT',1,'1840-01-01','2999-12-31'),
	(34901,'19','087',' 05','087051',87051,'Tremestieri Etneo','Tremestieri Etneo','','CT',1,'1840-01-01','2999-12-31'),
	(34902,'19','087',' 05','087052',87052,'Valverde','Valverde','','CT',1,'1840-01-01','2999-12-31'),
	(34903,'19','087',' 05','087053',87053,'Viagrande','Viagrande','','CT',1,'1840-01-01','2999-12-31'),
	(34904,'19','087',' 05','087054',87054,'Vizzini','Vizzini','','CT',1,'1840-01-01','2999-12-31'),
	(34905,'19','087',' 05','087055',87055,'Zafferana Etnea','Zafferana Etnea','','CT',1,'1840-01-01','2999-12-31'),
	(34906,'19','087',' 05','087056',87056,'Mazzarrone','Mazzarrone','','CT',1,'1840-01-01','2999-12-31'),
	(34907,'19','087',' 05','087057',87057,'Maniace','Maniace','','CT',1,'1840-01-01','2999-12-31'),
	(34908,'19','087',' 05','087058',87058,'Ragalna','Ragalna','','CT',1,'1840-01-01','2999-12-31'),
	(34909,'19','088',' 00','088001',88001,'Acate','Acate','','RG',1,'1840-01-01','2999-12-31'),
	(34910,'19','088',' 00','088002',88002,'Chiaramonte Gulfi','Chiaramonte Gulfi','','RG',1,'1840-01-01','2999-12-31'),
	(34911,'19','088',' 00','088003',88003,'Comiso','Comiso','','RG',1,'1840-01-01','2999-12-31'),
	(34912,'19','088',' 00','088004',88004,'Giarratana','Giarratana','','RG',1,'1840-01-01','2999-12-31'),
	(34913,'19','088',' 00','088005',88005,'Ispica','Ispica','','RG',1,'1840-01-01','2999-12-31'),
	(34914,'19','088',' 00','088006',88006,'Modica','Modica','','RG',1,'1840-01-01','2999-12-31'),
	(34915,'19','088',' 00','088007',88007,'Monterosso Almo','Monterosso Almo','','RG',1,'1840-01-01','2999-12-31'),
	(34916,'19','088',' 00','088008',88008,'Pozzallo','Pozzallo','','RG',1,'1840-01-01','2999-12-31'),
	(34917,'19','088',' 00','088009',88009,'Ragusa','Ragusa','','RG',1,'1840-01-01','2999-12-31'),
	(34918,'19','088',' 01','088010',88010,'Santa Croce Camerina','Santa Croce Camerina','','RG',1,'1840-01-01','2999-12-31'),
	(34919,'19','088',' 01','088011',88011,'Scicli','Scicli','','RG',1,'1840-01-01','2999-12-31'),
	(34920,'19','088',' 01','088012',88012,'Vittoria','Vittoria','','RG',1,'1840-01-01','2999-12-31'),
	(34921,'19','089',' 00','089001',89001,'Augusta','Augusta','','SR',1,'1840-01-01','2999-12-31'),
	(34922,'19','089',' 00','089002',89002,'Avola','Avola','','SR',1,'1840-01-01','2999-12-31'),
	(34923,'19','089',' 00','089003',89003,'Buccheri','Buccheri','','SR',1,'1840-01-01','2999-12-31'),
	(34924,'19','089',' 00','089004',89004,'Buscemi','Buscemi','','SR',1,'1840-01-01','2999-12-31'),
	(34925,'19','089',' 00','089005',89005,'Canicattini Bagni','Canicattini Bagni','','SR',1,'1840-01-01','2999-12-31'),
	(34926,'19','089',' 00','089006',89006,'Carlentini','Carlentini','','SR',1,'1840-01-01','2999-12-31'),
	(34927,'19','089',' 00','089007',89007,'Cassaro','Cassaro','','SR',1,'1840-01-01','2999-12-31'),
	(34928,'19','089',' 00','089008',89008,'Ferla','Ferla','','SR',1,'1840-01-01','2999-12-31'),
	(34929,'19','089',' 00','089009',89009,'Floridia','Floridia','','SR',1,'1840-01-01','2999-12-31'),
	(34930,'19','089',' 01','089010',89010,'Francofonte','Francofonte','','SR',1,'1840-01-01','2999-12-31'),
	(34931,'19','089',' 01','089011',89011,'Lentini','Lentini','','SR',1,'1840-01-01','2999-12-31'),
	(34932,'19','089',' 01','089012',89012,'Melilli','Melilli','','SR',1,'1840-01-01','2999-12-31'),
	(34933,'19','089',' 01','089013',89013,'Noto','Noto','','SR',1,'1840-01-01','2999-12-31'),
	(34934,'19','089',' 01','089014',89014,'Pachino','Pachino','','SR',1,'1840-01-01','2999-12-31'),
	(34935,'19','089',' 01','089015',89015,'Palazzolo Acreide','Palazzolo Acreide','','SR',1,'1840-01-01','2999-12-31'),
	(34936,'19','089',' 01','089016',89016,'Rosolini','Rosolini','','SR',1,'1840-01-01','2999-12-31'),
	(34937,'19','089',' 01','089017',89017,'Siracusa','Siracusa','','SR',1,'1840-01-01','2999-12-31'),
	(34938,'19','089',' 01','089018',89018,'Solarino','Solarino','','SR',1,'1840-01-01','2999-12-31'),
	(34939,'19','089',' 01','089019',89019,'Sortino','Sortino','','SR',1,'1840-01-01','2999-12-31'),
	(34940,'19','089',' 02','089020',89020,'Portopalo di Capo Passero','Portopalo di Capo Passero','','SR',1,'1840-01-01','2999-12-31'),
	(34941,'19','089',' 02','089021',89021,'Priolo Gargallo','Priolo Gargallo','','SR',1,'1840-01-01','2999-12-31'),
	(34942,'20','090',' 00','090003',90003,'Alghero','Alghero','','SS',1,'1840-01-01','2999-12-31'),
	(34943,'20','090',' 00','090004',90004,'Anela','Anela','','SS',1,'1840-01-01','2999-12-31'),
	(34944,'20','090',' 00','090005',90005,'Ardara','Ardara','','SS',1,'1840-01-01','2999-12-31'),
	(34945,'20','090',' 00','090007',90007,'Banari','Banari','','SS',1,'1840-01-01','2999-12-31'),
	(34946,'20','090',' 00','090008',90008,'Benetutti','Benetutti','','SS',1,'1840-01-01','2999-12-31'),
	(34947,'20','090',' 01','090010',90010,'Bessude','Bessude','','SS',1,'1840-01-01','2999-12-31'),
	(34948,'20','090',' 01','090011',90011,'Bonnanaro','Bonnanaro','','SS',1,'1840-01-01','2999-12-31'),
	(34949,'20','090',' 01','090012',90012,'Bono','Bono','','SS',1,'1840-01-01','2999-12-31'),
	(34950,'20','090',' 01','090013',90013,'Bonorva','Bonorva','','SS',1,'1840-01-01','2999-12-31'),
	(34951,'20','090',' 01','090015',90015,'Borutta','Borutta','','SS',1,'1840-01-01','2999-12-31'),
	(34952,'20','090',' 01','090016',90016,'Bottidda','Bottidda','','SS',1,'1840-01-01','2999-12-31'),
	(34953,'20','090',' 01','090018',90018,'Bultei','Bultei','','SS',1,'1840-01-01','2999-12-31'),
	(34954,'20','090',' 01','090019',90019,'Bulzi','Bulzi','','SS',1,'1840-01-01','2999-12-31'),
	(34955,'20','090',' 02','090020',90020,'Burgos','Burgos','','SS',1,'1840-01-01','2999-12-31'),
	(34956,'20','090',' 02','090022',90022,'Cargeghe','Cargeghe','','SS',1,'1840-01-01','2999-12-31'),
	(34957,'20','090',' 02','090023',90023,'Castelsardo','Castelsardo','','SS',1,'1840-01-01','2999-12-31'),
	(34958,'20','090',' 02','090024',90024,'Cheremule','Cheremule','','SS',1,'1840-01-01','2999-12-31'),
	(34959,'20','090',' 02','090025',90025,'Chiaramonti','Chiaramonti','','SS',1,'1840-01-01','2999-12-31'),
	(34960,'20','090',' 02','090026',90026,'Codrongianos','Codrongianos','','SS',1,'1840-01-01','2999-12-31'),
	(34961,'20','090',' 02','090027',90027,'Cossoine','Cossoine','','SS',1,'1840-01-01','2999-12-31'),
	(34962,'20','090',' 02','090028',90028,'Esporlatu','Esporlatu','','SS',1,'1840-01-01','2999-12-31'),
	(34963,'20','090',' 02','090029',90029,'Florinas','Florinas','','SS',1,'1840-01-01','2999-12-31'),
	(34964,'20','090',' 03','090030',90030,'Giave','Giave','','SS',1,'1840-01-01','2999-12-31'),
	(34965,'20','090',' 03','090031',90031,'Illorai','Illorai','','SS',1,'1840-01-01','2999-12-31'),
	(34966,'20','090',' 03','090032',90032,'Ittireddu','Ittireddu','','SS',1,'1840-01-01','2999-12-31'),
	(34967,'20','090',' 03','090033',90033,'Ittiri','Ittiri','','SS',1,'1840-01-01','2999-12-31'),
	(34968,'20','090',' 03','090034',90034,'Laerru','Laerru','','SS',1,'1840-01-01','2999-12-31'),
	(34969,'20','090',' 03','090038',90038,'Mara','Mara','','SS',1,'1840-01-01','2999-12-31'),
	(34970,'20','090',' 03','090039',90039,'Martis','Martis','','SS',1,'1840-01-01','2999-12-31'),
	(34971,'20','090',' 04','090040',90040,'Monteleone Rocca Doria','Monteleone Rocca Doria','','SS',1,'1840-01-01','2999-12-31'),
	(34972,'20','090',' 04','090042',90042,'Mores','Mores','','SS',1,'1840-01-01','2999-12-31'),
	(34973,'20','090',' 04','090043',90043,'Muros','Muros','','SS',1,'1840-01-01','2999-12-31'),
	(34974,'20','090',' 04','090044',90044,'Nughedu San Nicolò','Nughedu San Nicolò','','SS',1,'1840-01-01','2999-12-31'),
	(34975,'20','090',' 04','090045',90045,'Nule','Nule','','SS',1,'1840-01-01','2999-12-31'),
	(34976,'20','090',' 04','090046',90046,'Nulvi','Nulvi','','SS',1,'1840-01-01','2999-12-31'),
	(34977,'20','090',' 04','090048',90048,'Olmedo','Olmedo','','SS',1,'1840-01-01','2999-12-31'),
	(34978,'20','090',' 05','090050',90050,'Osilo','Osilo','','SS',1,'1840-01-01','2999-12-31'),
	(34979,'20','090',' 05','090051',90051,'Ossi','Ossi','','SS',1,'1840-01-01','2999-12-31'),
	(34980,'20','090',' 05','090052',90052,'Ozieri','Ozieri','','SS',1,'1840-01-01','2999-12-31'),
	(34981,'20','090',' 05','090053',90053,'Padria','Padria','','SS',1,'1840-01-01','2999-12-31'),
	(34982,'20','090',' 05','090055',90055,'Pattada','Pattada','','SS',1,'1840-01-01','2999-12-31'),
	(34983,'20','090',' 05','090056',90056,'Perfugas','Perfugas','','SS',1,'1840-01-01','2999-12-31'),
	(34984,'20','090',' 05','090057',90057,'Ploaghe','Ploaghe','','SS',1,'1840-01-01','2999-12-31'),
	(34985,'20','090',' 05','090058',90058,'Porto Torres','Porto Torres','','SS',1,'1840-01-01','2999-12-31'),
	(34986,'20','090',' 05','090059',90059,'Pozzomaggiore','Pozzomaggiore','','SS',1,'1840-01-01','2999-12-31'),
	(34987,'20','090',' 06','090060',90060,'Putifigari','Putifigari','','SS',1,'1840-01-01','2999-12-31'),
	(34988,'20','090',' 06','090061',90061,'Romana','Romana','','SS',1,'1840-01-01','2999-12-31'),
	(34989,'20','090',' 06','090064',90064,'Sassari','Sassari','','SS',1,'1840-01-01','2999-12-31'),
	(34990,'20','090',' 06','090065',90065,'Sedini','Sedini','','SS',1,'1840-01-01','2999-12-31'),
	(34991,'20','090',' 06','090066',90066,'Semestene','Semestene','','SS',1,'1840-01-01','2999-12-31'),
	(34992,'20','090',' 06','090067',90067,'Sennori','Sennori','','SS',1,'1840-01-01','2999-12-31'),
	(34993,'20','090',' 06','090068',90068,'Siligo','Siligo','','SS',1,'1840-01-01','2999-12-31'),
	(34994,'20','090',' 06','090069',90069,'Sorso','Sorso','','SS',1,'1840-01-01','2999-12-31'),
	(34995,'20','090',' 07','090071',90071,'Thiesi','Thiesi','','SS',1,'1840-01-01','2999-12-31'),
	(34996,'20','090',' 07','090072',90072,'Tissi','Tissi','','SS',1,'1840-01-01','2999-12-31'),
	(34997,'20','090',' 07','090073',90073,'Torralba','Torralba','','SS',1,'1840-01-01','2999-12-31'),
	(34998,'20','090',' 07','090075',90075,'Tula','Tula','','SS',1,'1840-01-01','2999-12-31'),
	(34999,'20','090',' 07','090076',90076,'Uri','Uri','','SS',1,'1840-01-01','2999-12-31'),
	(35000,'20','090',' 07','090077',90077,'Usini','Usini','','SS',1,'1840-01-01','2999-12-31'),
	(35001,'20','090',' 07','090078',90078,'Villanova Monteleone','Villanova Monteleone','','SS',1,'1840-01-01','2999-12-31'),
	(35002,'20','090',' 07','090079',90079,'Valledoria','Valledoria','','SS',1,'1840-01-01','2999-12-31'),
	(35003,'20','090',' 08','090082',90082,'Viddalba','Viddalba','','SS',1,'1840-01-01','2999-12-31'),
	(35004,'20','090',' 08','090086',90086,'Tergu','Tergu','','SS',1,'1840-01-01','2999-12-31'),
	(35005,'20','090',' 08','090087',90087,'Santa Maria Coghinas','Santa Maria Coghinas','','SS',1,'1840-01-01','2999-12-31'),
	(35006,'20','090',' 08','090088',90088,'Erula','Erula','','SS',1,'1840-01-01','2999-12-31'),
	(35007,'20','090',' 08','090089',90089,'Stintino','Stintino','','SS',1,'1840-01-01','2999-12-31'),
	(35008,'20','091',' 00','091001',91001,'Aritzo','Aritzo','','NU',1,'1840-01-01','2999-12-31'),
	(35009,'20','091',' 00','091003',91003,'Atzara','Atzara','','NU',1,'1840-01-01','2999-12-31'),
	(35010,'20','091',' 00','091004',91004,'Austis','Austis','','NU',1,'1840-01-01','2999-12-31'),
	(35011,'20','091',' 00','091007',91007,'Belvì','Belvì','','NU',1,'1840-01-01','2999-12-31'),
	(35012,'20','091',' 00','091008',91008,'Birori','Birori','','NU',1,'1840-01-01','2999-12-31'),
	(35013,'20','091',' 00','091009',91009,'Bitti','Bitti','','NU',1,'1840-01-01','2999-12-31'),
	(35014,'20','091',' 01','091010',91010,'Bolotana','Bolotana','','NU',1,'1840-01-01','2999-12-31'),
	(35015,'20','091',' 01','091011',91011,'Borore','Borore','','NU',1,'1840-01-01','2999-12-31'),
	(35016,'20','091',' 01','091012',91012,'Bortigali','Bortigali','','NU',1,'1840-01-01','2999-12-31'),
	(35017,'20','091',' 01','091016',91016,'Desulo','Desulo','','NU',1,'1840-01-01','2999-12-31'),
	(35018,'20','091',' 01','091017',91017,'Dorgali','Dorgali','','NU',1,'1840-01-01','2999-12-31'),
	(35019,'20','091',' 01','091018',91018,'Dualchi','Dualchi','','NU',1,'1840-01-01','2999-12-31'),
	(35020,'20','091',' 02','091024',91024,'Fonni','Fonni','','NU',1,'1840-01-01','2999-12-31'),
	(35021,'20','091',' 02','091025',91025,'Gadoni','Gadoni','','NU',1,'1840-01-01','2999-12-31'),
	(35022,'20','091',' 02','091027',91027,'Galtellì','Galtellì','','NU',1,'1840-01-01','2999-12-31'),
	(35023,'20','091',' 02','091028',91028,'Gavoi','Gavoi','','NU',1,'1840-01-01','2999-12-31'),
	(35024,'20','091',' 03','091033',91033,'Irgoli','Irgoli','','NU',1,'1840-01-01','2999-12-31'),
	(35025,'20','091',' 03','091038',91038,'Lei','Lei','','NU',1,'1840-01-01','2999-12-31'),
	(35026,'20','091',' 04','091040',91040,'Loculi','Loculi','','NU',1,'1840-01-01','2999-12-31'),
	(35027,'20','091',' 04','091041',91041,'Lodè','Lodè','','NU',1,'1840-01-01','2999-12-31'),
	(35028,'20','091',' 04','091043',91043,'Lula','Lula','','NU',1,'1840-01-01','2999-12-31'),
	(35029,'20','091',' 04','091044',91044,'Macomer','Macomer','','NU',1,'1840-01-01','2999-12-31'),
	(35030,'20','091',' 04','091046',91046,'Mamoiada','Mamoiada','','NU',1,'1840-01-01','2999-12-31'),
	(35031,'20','091',' 04','091047',91047,'Meana Sardo','Meana Sardo','','NU',1,'1840-01-01','2999-12-31'),
	(35032,'20','091',' 05','091050',91050,'Noragugume','Noragugume','','NU',1,'1840-01-01','2999-12-31'),
	(35033,'20','091',' 05','091051',91051,'Nuoro','Nuoro','','NU',1,'1840-01-01','2999-12-31'),
	(35034,'20','091',' 05','091055',91055,'Oliena','Oliena','','NU',1,'1840-01-01','2999-12-31'),
	(35035,'20','091',' 05','091056',91056,'Ollolai','Ollolai','','NU',1,'1840-01-01','2999-12-31'),
	(35036,'20','091',' 05','091057',91057,'Olzai','Olzai','','NU',1,'1840-01-01','2999-12-31'),
	(35037,'20','091',' 05','091058',91058,'Onanì','Onanì','','NU',1,'1840-01-01','2999-12-31'),
	(35038,'20','091',' 05','091059',91059,'Onifai','Onifai','','NU',1,'1840-01-01','2999-12-31'),
	(35039,'20','091',' 06','091060',91060,'Oniferi','Oniferi','','NU',1,'1840-01-01','2999-12-31'),
	(35040,'20','091',' 06','091061',91061,'Orani','Orani','','NU',1,'1840-01-01','2999-12-31'),
	(35041,'20','091',' 06','091062',91062,'Orgosolo','Orgosolo','','NU',1,'1840-01-01','2999-12-31'),
	(35042,'20','091',' 06','091063',91063,'Orosei','Orosei','','NU',1,'1840-01-01','2999-12-31'),
	(35043,'20','091',' 06','091064',91064,'Orotelli','Orotelli','','NU',1,'1840-01-01','2999-12-31'),
	(35044,'20','091',' 06','091066',91066,'Ortueri','Ortueri','','NU',1,'1840-01-01','2999-12-31'),
	(35045,'20','091',' 06','091067',91067,'Orune','Orune','','NU',1,'1840-01-01','2999-12-31'),
	(35046,'20','091',' 06','091068',91068,'Osidda','Osidda','','NU',1,'1840-01-01','2999-12-31'),
	(35047,'20','091',' 07','091070',91070,'Ottana','Ottana','','NU',1,'1840-01-01','2999-12-31'),
	(35048,'20','091',' 07','091071',91071,'Ovodda','Ovodda','','NU',1,'1840-01-01','2999-12-31'),
	(35049,'20','091',' 07','091073',91073,'Posada','Posada','','NU',1,'1840-01-01','2999-12-31'),
	(35050,'20','091',' 07','091077',91077,'Sarule','Sarule','','NU',1,'1840-01-01','2999-12-31'),
	(35051,'20','091',' 08','091083',91083,'Silanus','Silanus','','NU',1,'1840-01-01','2999-12-31'),
	(35052,'20','091',' 08','091084',91084,'Sindia','Sindia','','NU',1,'1840-01-01','2999-12-31'),
	(35053,'20','091',' 08','091085',91085,'Siniscola','Siniscola','','NU',1,'1840-01-01','2999-12-31'),
	(35054,'20','091',' 08','091086',91086,'Sorgono','Sorgono','','NU',1,'1840-01-01','2999-12-31'),
	(35055,'20','091',' 09','091090',91090,'Teti','Teti','','NU',1,'1840-01-01','2999-12-31'),
	(35056,'20','091',' 09','091091',91091,'Tiana','Tiana','','NU',1,'1840-01-01','2999-12-31'),
	(35057,'20','091',' 09','091093',91093,'Tonara','Tonara','','NU',1,'1840-01-01','2999-12-31'),
	(35058,'20','091',' 09','091094',91094,'Torpè','Torpè','','NU',1,'1840-01-01','2999-12-31'),
	(35059,'20','091',' 10','091104',91104,'Lodine','Lodine','','NU',1,'1840-01-01','2999-12-31'),
	(35060,'20','092',' 00','092002',92002,'Armungia','Armungia','','CA',1,'1840-01-01','2999-12-31'),
	(35061,'20','092',' 00','092003',92003,'Assemini','Assemini','','CA',1,'1840-01-01','2999-12-31'),
	(35062,'20','092',' 00','092004',92004,'Ballao','Ballao','','CA',1,'1840-01-01','2999-12-31'),
	(35063,'20','092',' 00','092005',92005,'Barrali','Barrali','','CA',1,'1840-01-01','2999-12-31'),
	(35064,'20','092',' 00','092008',92008,'Burcei','Burcei','','CA',1,'1840-01-01','2999-12-31'),
	(35065,'20','092',' 00','092009',92009,'Cagliari','Cagliari','','CA',1,'1840-01-01','2999-12-31'),
	(35066,'20','092',' 01','092011',92011,'Capoterra','Capoterra','','CA',1,'1840-01-01','2999-12-31'),
	(35067,'20','092',' 01','092015',92015,'Decimomannu','Decimomannu','','CA',1,'1840-01-01','2999-12-31'),
	(35068,'20','092',' 01','092016',92016,'Decimoputzu','Decimoputzu','','CA',1,'1840-01-01','2999-12-31');

INSERT INTO `COMUNI_ITALIANI` (`IDCOMUNE`, `CODICE_REGIONE`, `CODICE_PROVINCIA`, `CODICE_COMUNE`, `CODICE_ISTAT_A`, `CODICE_ISTAT_N`, `DENOMINAZIONE_IT_DE`, `DENOMINAZIONE_IT`, `DENOMINAZIONE_DE`, `SIGLA_PROVINCIA`, `STATUS`, `INIZIO_VALIDITA`, `FINE_VALIDITA`)
VALUES
	(35069,'20','092',' 01','092017',92017,'Dolianova','Dolianova','','CA',1,'1840-01-01','2999-12-31'),
	(35070,'20','092',' 01','092018',92018,'Domus de Maria','Domus de Maria','','CA',1,'1840-01-01','2999-12-31'),
	(35071,'20','092',' 02','092020',92020,'Donori','Donori','','CA',1,'1840-01-01','2999-12-31'),
	(35072,'20','092',' 02','092024',92024,'Gesico','Gesico','','CA',1,'1840-01-01','2999-12-31'),
	(35073,'20','092',' 02','092027',92027,'Goni','Goni','','CA',1,'1840-01-01','2999-12-31'),
	(35074,'20','092',' 03','092030',92030,'Guamaggiore','Guamaggiore','','CA',1,'1840-01-01','2999-12-31'),
	(35075,'20','092',' 03','092031',92031,'Guasila','Guasila','','CA',1,'1840-01-01','2999-12-31'),
	(35076,'20','092',' 03','092036',92036,'Mandas','Mandas','','CA',1,'1840-01-01','2999-12-31'),
	(35077,'20','092',' 03','092037',92037,'Maracalagonis','Maracalagonis','','CA',1,'1840-01-01','2999-12-31'),
	(35078,'20','092',' 03','092038',92038,'Monastir','Monastir','','CA',1,'1840-01-01','2999-12-31'),
	(35079,'20','092',' 03','092039',92039,'Muravera','Muravera','','CA',1,'1840-01-01','2999-12-31'),
	(35080,'20','092',' 04','092042',92042,'Nuraminis','Nuraminis','','CA',1,'1840-01-01','2999-12-31'),
	(35081,'20','092',' 04','092044',92044,'Ortacesus','Ortacesus','','CA',1,'1840-01-01','2999-12-31'),
	(35082,'20','092',' 04','092048',92048,'Pimentel','Pimentel','','CA',1,'1840-01-01','2999-12-31'),
	(35083,'20','092',' 05','092050',92050,'Pula','Pula','','CA',1,'1840-01-01','2999-12-31'),
	(35084,'20','092',' 05','092051',92051,'Quartu Sant\'Elena','Quartu Sant\'Elena','','CA',1,'1840-01-01','2999-12-31'),
	(35085,'20','092',' 05','092053',92053,'Samatzai','Samatzai','','CA',1,'1840-01-01','2999-12-31'),
	(35086,'20','092',' 05','092054',92054,'San Basilio','San Basilio','','CA',1,'1840-01-01','2999-12-31'),
	(35087,'20','092',' 05','092058',92058,'San Nicolò Gerrei','San Nicolò Gerrei','','CA',1,'1840-01-01','2999-12-31'),
	(35088,'20','092',' 05','092059',92059,'San Sperate','San Sperate','','CA',1,'1840-01-01','2999-12-31'),
	(35089,'20','092',' 06','092061',92061,'Sant\'Andrea Frius','Sant\'Andrea Frius','','CA',1,'1840-01-01','2999-12-31'),
	(35090,'20','092',' 06','092064',92064,'San Vito','San Vito','','CA',1,'1840-01-01','2999-12-31'),
	(35091,'20','092',' 06','092066',92066,'Sarroch','Sarroch','','CA',1,'1840-01-01','2999-12-31'),
	(35092,'20','092',' 06','092068',92068,'Selargius','Selargius','','CA',1,'1840-01-01','2999-12-31'),
	(35093,'20','092',' 06','092069',92069,'Selegas','Selegas','','CA',1,'1840-01-01','2999-12-31'),
	(35094,'20','092',' 07','092070',92070,'Senorbì','Senorbì','','CA',1,'1840-01-01','2999-12-31'),
	(35095,'20','092',' 07','092071',92071,'Serdiana','Serdiana','','CA',1,'1840-01-01','2999-12-31'),
	(35096,'20','092',' 07','092074',92074,'Sestu','Sestu','','CA',1,'1840-01-01','2999-12-31'),
	(35097,'20','092',' 07','092075',92075,'Settimo San Pietro','Settimo San Pietro','','CA',1,'1840-01-01','2999-12-31'),
	(35098,'20','092',' 07','092078',92078,'Siliqua','Siliqua','','CA',1,'1840-01-01','2999-12-31'),
	(35099,'20','092',' 07','092079',92079,'Silius','Silius','','CA',1,'1840-01-01','2999-12-31'),
	(35100,'20','092',' 08','092080',92080,'Sinnai','Sinnai','','CA',1,'1840-01-01','2999-12-31'),
	(35101,'20','092',' 08','092081',92081,'Siurgus Donigala','Siurgus Donigala','','CA',1,'1840-01-01','2999-12-31'),
	(35102,'20','092',' 08','092082',92082,'Soleminis','Soleminis','','CA',1,'1840-01-01','2999-12-31'),
	(35103,'20','092',' 08','092083',92083,'Suelli','Suelli','','CA',1,'1840-01-01','2999-12-31'),
	(35104,'20','092',' 08','092084',92084,'Teulada','Teulada','','CA',1,'1840-01-01','2999-12-31'),
	(35105,'20','092',' 08','092088',92088,'Ussana','Ussana','','CA',1,'1840-01-01','2999-12-31'),
	(35106,'20','092',' 09','092090',92090,'Uta','Uta','','CA',1,'1840-01-01','2999-12-31'),
	(35107,'20','092',' 09','092091',92091,'Vallermosa','Vallermosa','','CA',1,'1840-01-01','2999-12-31'),
	(35108,'20','092',' 09','092097',92097,'Villaputzu','Villaputzu','','CA',1,'1840-01-01','2999-12-31'),
	(35109,'20','092',' 09','092098',92098,'Villasalto','Villasalto','','CA',1,'1840-01-01','2999-12-31'),
	(35110,'20','092',' 09','092099',92099,'Villa San Pietro','Villa San Pietro','','CA',1,'1840-01-01','2999-12-31'),
	(35111,'20','092',' 10','092100',92100,'Villasimius','Villasimius','','CA',1,'1840-01-01','2999-12-31'),
	(35112,'20','092',' 10','092101',92101,'Villasor','Villasor','','CA',1,'1840-01-01','2999-12-31'),
	(35113,'20','092',' 10','092102',92102,'Villaspeciosa','Villaspeciosa','','CA',1,'1840-01-01','2999-12-31'),
	(35114,'20','092',' 10','092105',92105,'Quartucciu','Quartucciu','','CA',1,'1840-01-01','2999-12-31'),
	(35115,'20','092',' 10','092106',92106,'Castiadas','Castiadas','','CA',1,'1840-01-01','2999-12-31'),
	(35116,'20','092',' 10','092108',92108,'Elmas','Elmas','','CA',1,'1840-01-01','2999-12-31'),
	(35117,'20','092',' 10','092109',92109,'Monserrato','Monserrato','','CA',1,'1840-01-01','2999-12-31'),
	(35118,'20','092',' 11','092110',92110,'Escalaplano','Escalaplano','','CA',1,'1840-01-01','2999-12-31'),
	(35119,'20','092',' 11','092111',92111,'Escolca','Escolca','','CA',1,'1840-01-01','2999-12-31'),
	(35120,'20','092',' 11','092112',92112,'Esterzili','Esterzili','','CA',1,'1840-01-01','2999-12-31'),
	(35121,'20','092',' 11','092113',92113,'Gergei','Gergei','','CA',1,'1840-01-01','2999-12-31'),
	(35122,'20','092',' 11','092114',92114,'Isili','Isili','','CA',1,'1840-01-01','2999-12-31'),
	(35123,'20','092',' 11','092115',92115,'Nuragus','Nuragus','','CA',1,'1840-01-01','2999-12-31'),
	(35124,'20','092',' 11','092116',92116,'Nurallao','Nurallao','','CA',1,'1840-01-01','2999-12-31'),
	(35125,'20','092',' 11','092117',92117,'Nurri','Nurri','','CA',1,'1840-01-01','2999-12-31'),
	(35126,'20','092',' 11','092118',92118,'Orroli','Orroli','','CA',1,'1840-01-01','2999-12-31'),
	(35127,'20','092',' 11','092119',92119,'Sadali','Sadali','','CA',1,'1840-01-01','2999-12-31'),
	(35128,'20','092',' 12','092120',92120,'Serri','Serri','','CA',1,'1840-01-01','2999-12-31'),
	(35129,'20','092',' 12','092121',92121,'Seulo','Seulo','','CA',1,'1840-01-01','2999-12-31'),
	(35130,'20','092',' 12','092122',92122,'Villanova Tulo','Villanova Tulo','','CA',1,'1840-01-01','2999-12-31'),
	(35131,'06','093',' 00','093001',93001,'Andreis','Andreis','','PN',1,'1840-01-01','2999-12-31'),
	(35132,'06','093',' 00','093002',93002,'Arba','Arba','','PN',1,'1840-01-01','2999-12-31'),
	(35133,'06','093',' 00','093003',93003,'Arzene','Arzene','','PN',1,'1840-01-01','2999-12-31'),
	(35134,'06','093',' 00','093004',93004,'Aviano','Aviano','','PN',1,'1840-01-01','2999-12-31'),
	(35135,'06','093',' 00','093005',93005,'Azzano Decimo','Azzano Decimo','','PN',1,'1840-01-01','2999-12-31'),
	(35136,'06','093',' 00','093006',93006,'Barcis','Barcis','','PN',1,'1840-01-01','2999-12-31'),
	(35137,'06','093',' 00','093007',93007,'Brugnera','Brugnera','','PN',1,'1840-01-01','2999-12-31'),
	(35138,'06','093',' 00','093008',93008,'Budoia','Budoia','','PN',1,'1840-01-01','2999-12-31'),
	(35139,'06','093',' 00','093009',93009,'Caneva','Caneva','','PN',1,'1840-01-01','2999-12-31'),
	(35140,'06','093',' 01','093010',93010,'Casarsa della Delizia','Casarsa della Delizia','','PN',1,'1840-01-01','2999-12-31'),
	(35141,'06','093',' 01','093011',93011,'Castelnovo del Friuli','Castelnovo del Friuli','','PN',1,'1840-01-01','2999-12-31'),
	(35142,'06','093',' 01','093012',93012,'Cavasso Nuovo','Cavasso Nuovo','','PN',1,'1840-01-01','2999-12-31'),
	(35143,'06','093',' 01','093013',93013,'Chions','Chions','','PN',1,'1840-01-01','2999-12-31'),
	(35144,'06','093',' 01','093014',93014,'Cimolais','Cimolais','','PN',1,'1840-01-01','2999-12-31'),
	(35145,'06','093',' 01','093015',93015,'Claut','Claut','','PN',1,'1840-01-01','2999-12-31'),
	(35146,'06','093',' 01','093016',93016,'Clauzetto','Clauzetto','','PN',1,'1840-01-01','2999-12-31'),
	(35147,'06','093',' 01','093017',93017,'Cordenons','Cordenons','','PN',1,'1840-01-01','2999-12-31'),
	(35148,'06','093',' 01','093018',93018,'Cordovado','Cordovado','','PN',1,'1840-01-01','2999-12-31'),
	(35149,'06','093',' 01','093019',93019,'Erto e Casso','Erto e Casso','','PN',1,'1840-01-01','2999-12-31'),
	(35150,'06','093',' 02','093020',93020,'Fanna','Fanna','','PN',1,'1840-01-01','2999-12-31'),
	(35151,'06','093',' 02','093021',93021,'Fiume Veneto','Fiume Veneto','','PN',1,'1840-01-01','2999-12-31'),
	(35152,'06','093',' 02','093022',93022,'Fontanafredda','Fontanafredda','','PN',1,'1840-01-01','2999-12-31'),
	(35153,'06','093',' 02','093024',93024,'Frisanco','Frisanco','','PN',1,'1840-01-01','2999-12-31'),
	(35154,'06','093',' 02','093025',93025,'Maniago','Maniago','','PN',1,'1840-01-01','2999-12-31'),
	(35155,'06','093',' 02','093026',93026,'Meduno','Meduno','','PN',1,'1840-01-01','2999-12-31'),
	(35156,'06','093',' 02','093027',93027,'Montereale Valcellina','Montereale Valcellina','','PN',1,'1840-01-01','2999-12-31'),
	(35157,'06','093',' 02','093028',93028,'Morsano al Tagliamento','Morsano al Tagliamento','','PN',1,'1840-01-01','2999-12-31'),
	(35158,'06','093',' 02','093029',93029,'Pasiano di Pordenone','Pasiano di Pordenone','','PN',1,'1840-01-01','2999-12-31'),
	(35159,'06','093',' 03','093030',93030,'Pinzano al Tagliamento','Pinzano al Tagliamento','','PN',1,'1840-01-01','2999-12-31'),
	(35160,'06','093',' 03','093031',93031,'Polcenigo','Polcenigo','','PN',1,'1840-01-01','2999-12-31'),
	(35161,'06','093',' 03','093032',93032,'Porcia','Porcia','','PN',1,'1840-01-01','2999-12-31'),
	(35162,'06','093',' 03','093033',93033,'Pordenone','Pordenone','','PN',1,'1840-01-01','2999-12-31'),
	(35163,'06','093',' 03','093034',93034,'Prata di Pordenone','Prata di Pordenone','','PN',1,'1840-01-01','2999-12-31'),
	(35164,'06','093',' 03','093035',93035,'Pravisdomini','Pravisdomini','','PN',1,'1840-01-01','2999-12-31'),
	(35165,'06','093',' 03','093036',93036,'Roveredo in Piano','Roveredo in Piano','','PN',1,'1840-01-01','2999-12-31'),
	(35166,'06','093',' 03','093037',93037,'Sacile','Sacile','','PN',1,'1840-01-01','2999-12-31'),
	(35167,'06','093',' 03','093038',93038,'San Giorgio della Richinvelda','San Giorgio della Richinvelda','','PN',1,'1840-01-01','2999-12-31'),
	(35168,'06','093',' 03','093039',93039,'San Martino al Tagliamento','San Martino al Tagliamento','','PN',1,'1840-01-01','2999-12-31'),
	(35169,'06','093',' 04','093040',93040,'San Quirino','San Quirino','','PN',1,'1840-01-01','2999-12-31'),
	(35170,'06','093',' 04','093041',93041,'San Vito al Tagliamento','San Vito al Tagliamento','','PN',1,'1840-01-01','2999-12-31'),
	(35171,'06','093',' 04','093042',93042,'Sequals','Sequals','','PN',1,'1840-01-01','2999-12-31'),
	(35172,'06','093',' 04','093043',93043,'Sesto al Reghena','Sesto al Reghena','','PN',1,'1840-01-01','2999-12-31'),
	(35173,'06','093',' 04','093044',93044,'Spilimbergo','Spilimbergo','','PN',1,'1840-01-01','2999-12-31'),
	(35174,'06','093',' 04','093045',93045,'Tramonti di Sopra','Tramonti di Sopra','','PN',1,'1840-01-01','2999-12-31'),
	(35175,'06','093',' 04','093046',93046,'Tramonti di Sotto','Tramonti di Sotto','','PN',1,'1840-01-01','2999-12-31'),
	(35176,'06','093',' 04','093047',93047,'Travesio','Travesio','','PN',1,'1840-01-01','2999-12-31'),
	(35177,'06','093',' 04','093048',93048,'Valvasone','Valvasone','','PN',1,'1840-01-01','2999-12-31'),
	(35178,'06','093',' 04','093049',93049,'Vito d\'Asio','Vito d\'Asio','','PN',1,'1840-01-01','2999-12-31'),
	(35179,'06','093',' 05','093050',93050,'Vivaro','Vivaro','','PN',1,'1840-01-01','2999-12-31'),
	(35180,'06','093',' 05','093051',93051,'Zoppola','Zoppola','','PN',1,'1840-01-01','2999-12-31'),
	(35181,'06','093',' 05','093052',93052,'Vajont','Vajont','','PN',1,'1840-01-01','2999-12-31'),
	(35182,'14','094',' 00','094001',94001,'Acquaviva d\'Isernia','Acquaviva d\'Isernia','','IS',1,'1840-01-01','2999-12-31'),
	(35183,'14','094',' 00','094002',94002,'Agnone','Agnone','','IS',1,'1840-01-01','2999-12-31'),
	(35184,'14','094',' 00','094003',94003,'Bagnoli del Trigno','Bagnoli del Trigno','','IS',1,'1840-01-01','2999-12-31'),
	(35185,'14','094',' 00','094004',94004,'Belmonte del Sannio','Belmonte del Sannio','','IS',1,'1840-01-01','2999-12-31'),
	(35186,'14','094',' 00','094005',94005,'Cantalupo nel Sannio','Cantalupo nel Sannio','','IS',1,'1840-01-01','2999-12-31'),
	(35187,'14','094',' 00','094006',94006,'Capracotta','Capracotta','','IS',1,'1840-01-01','2999-12-31'),
	(35188,'14','094',' 00','094007',94007,'Carovilli','Carovilli','','IS',1,'1840-01-01','2999-12-31'),
	(35189,'14','094',' 00','094008',94008,'Carpinone','Carpinone','','IS',1,'1840-01-01','2999-12-31'),
	(35190,'14','094',' 00','094009',94009,'Castel del Giudice','Castel del Giudice','','IS',1,'1840-01-01','2999-12-31'),
	(35191,'14','094',' 01','094010',94010,'Castelpetroso','Castelpetroso','','IS',1,'1840-01-01','2999-12-31'),
	(35192,'14','094',' 01','094011',94011,'Castelpizzuto','Castelpizzuto','','IS',1,'1840-01-01','2999-12-31'),
	(35193,'14','094',' 01','094012',94012,'Castel San Vincenzo','Castel San Vincenzo','','IS',1,'1840-01-01','2999-12-31'),
	(35194,'14','094',' 01','094013',94013,'Castelverrino','Castelverrino','','IS',1,'1840-01-01','2999-12-31'),
	(35195,'14','094',' 01','094014',94014,'Cerro al Volturno','Cerro al Volturno','','IS',1,'1840-01-01','2999-12-31'),
	(35196,'14','094',' 01','094015',94015,'Chiauci','Chiauci','','IS',1,'1840-01-01','2999-12-31'),
	(35197,'14','094',' 01','094016',94016,'Civitanova del Sannio','Civitanova del Sannio','','IS',1,'1840-01-01','2999-12-31'),
	(35198,'14','094',' 01','094017',94017,'Colli a Volturno','Colli a Volturno','','IS',1,'1840-01-01','2999-12-31'),
	(35199,'14','094',' 01','094018',94018,'Conca Casale','Conca Casale','','IS',1,'1840-01-01','2999-12-31'),
	(35200,'14','094',' 01','094019',94019,'Filignano','Filignano','','IS',1,'1840-01-01','2999-12-31'),
	(35201,'14','094',' 02','094020',94020,'Forlì del Sannio','Forlì del Sannio','','IS',1,'1840-01-01','2999-12-31'),
	(35202,'14','094',' 02','094021',94021,'Fornelli','Fornelli','','IS',1,'1840-01-01','2999-12-31'),
	(35203,'14','094',' 02','094022',94022,'Frosolone','Frosolone','','IS',1,'1840-01-01','2999-12-31'),
	(35204,'14','094',' 02','094023',94023,'Isernia','Isernia','','IS',1,'1840-01-01','2999-12-31'),
	(35205,'14','094',' 02','094024',94024,'Longano','Longano','','IS',1,'1840-01-01','2999-12-31'),
	(35206,'14','094',' 02','094025',94025,'Macchia d\'Isernia','Macchia d\'Isernia','','IS',1,'1840-01-01','2999-12-31'),
	(35207,'14','094',' 02','094026',94026,'Macchiagodena','Macchiagodena','','IS',1,'1840-01-01','2999-12-31'),
	(35208,'14','094',' 02','094027',94027,'Miranda','Miranda','','IS',1,'1840-01-01','2999-12-31'),
	(35209,'14','094',' 02','094028',94028,'Montaquila','Montaquila','','IS',1,'1840-01-01','2999-12-31'),
	(35210,'14','094',' 02','094029',94029,'Montenero Val Cocchiara','Montenero Val Cocchiara','','IS',1,'1840-01-01','2999-12-31'),
	(35211,'14','094',' 03','094030',94030,'Monteroduni','Monteroduni','','IS',1,'1840-01-01','2999-12-31'),
	(35212,'14','094',' 03','094031',94031,'Pesche','Pesche','','IS',1,'1840-01-01','2999-12-31'),
	(35213,'14','094',' 03','094032',94032,'Pescolanciano','Pescolanciano','','IS',1,'1840-01-01','2999-12-31'),
	(35214,'14','094',' 03','094033',94033,'Pescopennataro','Pescopennataro','','IS',1,'1840-01-01','2999-12-31'),
	(35215,'14','094',' 03','094034',94034,'Pettoranello del Molise','Pettoranello del Molise','','IS',1,'1840-01-01','2999-12-31'),
	(35216,'14','094',' 03','094035',94035,'Pietrabbondante','Pietrabbondante','','IS',1,'1840-01-01','2999-12-31'),
	(35217,'14','094',' 03','094036',94036,'Pizzone','Pizzone','','IS',1,'1840-01-01','2999-12-31'),
	(35218,'14','094',' 03','094037',94037,'Poggio Sannita','Poggio Sannita','','IS',1,'1840-01-01','2999-12-31'),
	(35219,'14','094',' 03','094038',94038,'Pozzilli','Pozzilli','','IS',1,'1840-01-01','2999-12-31'),
	(35220,'14','094',' 03','094039',94039,'Rionero Sannitico','Rionero Sannitico','','IS',1,'1840-01-01','2999-12-31'),
	(35221,'14','094',' 04','094040',94040,'Roccamandolfi','Roccamandolfi','','IS',1,'1840-01-01','2999-12-31'),
	(35222,'14','094',' 04','094041',94041,'Roccasicura','Roccasicura','','IS',1,'1840-01-01','2999-12-31'),
	(35223,'14','094',' 04','094042',94042,'Rocchetta a Volturno','Rocchetta a Volturno','','IS',1,'1840-01-01','2999-12-31'),
	(35224,'14','094',' 04','094043',94043,'San Pietro Avellana','San Pietro Avellana','','IS',1,'1840-01-01','2999-12-31'),
	(35225,'14','094',' 04','094044',94044,'Sant\'Agapito','Sant\'Agapito','','IS',1,'1840-01-01','2999-12-31'),
	(35226,'14','094',' 04','094045',94045,'Santa Maria del Molise','Santa Maria del Molise','','IS',1,'1840-01-01','2999-12-31'),
	(35227,'14','094',' 04','094046',94046,'Sant\'Angelo del Pesco','Sant\'Angelo del Pesco','','IS',1,'1840-01-01','2999-12-31'),
	(35228,'14','094',' 04','094047',94047,'Sant\'Elena Sannita','Sant\'Elena Sannita','','IS',1,'1840-01-01','2999-12-31'),
	(35229,'14','094',' 04','094048',94048,'Scapoli','Scapoli','','IS',1,'1840-01-01','2999-12-31'),
	(35230,'14','094',' 04','094049',94049,'Sessano del Molise','Sessano del Molise','','IS',1,'1840-01-01','2999-12-31'),
	(35231,'14','094',' 05','094050',94050,'Sesto Campano','Sesto Campano','','IS',1,'1840-01-01','2999-12-31'),
	(35232,'14','094',' 05','094051',94051,'Vastogirardi','Vastogirardi','','IS',1,'1840-01-01','2999-12-31'),
	(35233,'14','094',' 05','094052',94052,'Venafro','Venafro','','IS',1,'1840-01-01','2999-12-31'),
	(35234,'20','095',' 00','095001',95001,'Abbasanta','Abbasanta','','OR',1,'1840-01-01','2999-12-31'),
	(35235,'20','095',' 00','095002',95002,'Aidomaggiore','Aidomaggiore','','OR',1,'1840-01-01','2999-12-31'),
	(35236,'20','095',' 00','095003',95003,'Albagiara','Albagiara','','OR',1,'1840-01-01','2999-12-31'),
	(35237,'20','095',' 00','095004',95004,'Ales','Ales','','OR',1,'1840-01-01','2999-12-31'),
	(35238,'20','095',' 00','095005',95005,'Allai','Allai','','OR',1,'1840-01-01','2999-12-31'),
	(35239,'20','095',' 00','095006',95006,'Arborea','Arborea','','OR',1,'1840-01-01','2999-12-31'),
	(35240,'20','095',' 00','095007',95007,'Ardauli','Ardauli','','OR',1,'1840-01-01','2999-12-31'),
	(35241,'20','095',' 00','095008',95008,'Assolo','Assolo','','OR',1,'1840-01-01','2999-12-31'),
	(35242,'20','095',' 00','095009',95009,'Asuni','Asuni','','OR',1,'1840-01-01','2999-12-31'),
	(35243,'20','095',' 01','095010',95010,'Baradili','Baradili','','OR',1,'1840-01-01','2999-12-31'),
	(35244,'20','095',' 01','095011',95011,'Baratili San Pietro','Baratili San Pietro','','OR',1,'1840-01-01','2999-12-31'),
	(35245,'20','095',' 01','095012',95012,'Baressa','Baressa','','OR',1,'1840-01-01','2999-12-31'),
	(35246,'20','095',' 01','095013',95013,'Bauladu','Bauladu','','OR',1,'1840-01-01','2999-12-31'),
	(35247,'20','095',' 01','095014',95014,'Bidonì','Bidonì','','OR',1,'1840-01-01','2999-12-31'),
	(35248,'20','095',' 01','095015',95015,'Bonarcado','Bonarcado','','OR',1,'1840-01-01','2999-12-31'),
	(35249,'20','095',' 01','095016',95016,'Boroneddu','Boroneddu','','OR',1,'1840-01-01','2999-12-31'),
	(35250,'20','095',' 01','095017',95017,'Busachi','Busachi','','OR',1,'1840-01-01','2999-12-31'),
	(35251,'20','095',' 01','095018',95018,'Cabras','Cabras','','OR',1,'1840-01-01','2999-12-31'),
	(35252,'20','095',' 01','095019',95019,'Cuglieri','Cuglieri','','OR',1,'1840-01-01','2999-12-31'),
	(35253,'20','095',' 02','095020',95020,'Fordongianus','Fordongianus','','OR',1,'1840-01-01','2999-12-31'),
	(35254,'20','095',' 02','095021',95021,'Ghilarza','Ghilarza','','OR',1,'1840-01-01','2999-12-31'),
	(35255,'20','095',' 02','095022',95022,'Gonnoscodina','Gonnoscodina','','OR',1,'1840-01-01','2999-12-31'),
	(35256,'20','095',' 02','095023',95023,'Gonnosnò','Gonnosnò','','OR',1,'1840-01-01','2999-12-31'),
	(35257,'20','095',' 02','095024',95024,'Gonnostramatza','Gonnostramatza','','OR',1,'1840-01-01','2999-12-31'),
	(35258,'20','095',' 02','095025',95025,'Marrubiu','Marrubiu','','OR',1,'1840-01-01','2999-12-31'),
	(35259,'20','095',' 02','095026',95026,'Masullas','Masullas','','OR',1,'1840-01-01','2999-12-31'),
	(35260,'20','095',' 02','095027',95027,'Milis','Milis','','OR',1,'1840-01-01','2999-12-31'),
	(35261,'20','095',' 02','095028',95028,'Mogorella','Mogorella','','OR',1,'1840-01-01','2999-12-31'),
	(35262,'20','095',' 02','095029',95029,'Mogoro','Mogoro','','OR',1,'1840-01-01','2999-12-31'),
	(35263,'20','095',' 03','095030',95030,'Morgongiori','Morgongiori','','OR',1,'1840-01-01','2999-12-31'),
	(35264,'20','095',' 03','095031',95031,'Narbolia','Narbolia','','OR',1,'1840-01-01','2999-12-31'),
	(35265,'20','095',' 03','095032',95032,'Neoneli','Neoneli','','OR',1,'1840-01-01','2999-12-31'),
	(35266,'20','095',' 03','095033',95033,'Norbello','Norbello','','OR',1,'1840-01-01','2999-12-31'),
	(35267,'20','095',' 03','095034',95034,'Nughedu Santa Vittoria','Nughedu Santa Vittoria','','OR',1,'1840-01-01','2999-12-31'),
	(35268,'20','095',' 03','095035',95035,'Nurachi','Nurachi','','OR',1,'1840-01-01','2999-12-31'),
	(35269,'20','095',' 03','095036',95036,'Nureci','Nureci','','OR',1,'1840-01-01','2999-12-31'),
	(35270,'20','095',' 03','095037',95037,'Ollastra','Ollastra','','OR',1,'1840-01-01','2999-12-31'),
	(35271,'20','095',' 03','095038',95038,'Oristano','Oristano','','OR',1,'1840-01-01','2999-12-31'),
	(35272,'20','095',' 03','095039',95039,'Palmas Arborea','Palmas Arborea','','OR',1,'1840-01-01','2999-12-31'),
	(35273,'20','095',' 04','095040',95040,'Pau','Pau','','OR',1,'1840-01-01','2999-12-31'),
	(35274,'20','095',' 04','095041',95041,'Paulilatino','Paulilatino','','OR',1,'1840-01-01','2999-12-31'),
	(35275,'20','095',' 04','095042',95042,'Pompu','Pompu','','OR',1,'1840-01-01','2999-12-31'),
	(35276,'20','095',' 04','095043',95043,'Riola Sardo','Riola Sardo','','OR',1,'1840-01-01','2999-12-31'),
	(35277,'20','095',' 04','095044',95044,'Ruinas','Ruinas','','OR',1,'1840-01-01','2999-12-31'),
	(35278,'20','095',' 04','095045',95045,'Samugheo','Samugheo','','OR',1,'1840-01-01','2999-12-31'),
	(35279,'20','095',' 04','095046',95046,'San Nicolò d\'Arcidano','San Nicolò d\'Arcidano','','OR',1,'1840-01-01','2999-12-31'),
	(35280,'20','095',' 04','095047',95047,'Santa Giusta','Santa Giusta','','OR',1,'1840-01-01','2999-12-31'),
	(35281,'20','095',' 04','095048',95048,'Villa Sant\'Antonio','Villa Sant\'Antonio','','OR',1,'1840-01-01','2999-12-31'),
	(35282,'20','095',' 04','095049',95049,'Santu Lussurgiu','Santu Lussurgiu','','OR',1,'1840-01-01','2999-12-31'),
	(35283,'20','095',' 05','095050',95050,'San Vero Milis','San Vero Milis','','OR',1,'1840-01-01','2999-12-31'),
	(35284,'20','095',' 05','095051',95051,'Scano di Montiferro','Scano di Montiferro','','OR',1,'1840-01-01','2999-12-31'),
	(35285,'20','095',' 05','095052',95052,'Sedilo','Sedilo','','OR',1,'1840-01-01','2999-12-31'),
	(35286,'20','095',' 05','095053',95053,'Seneghe','Seneghe','','OR',1,'1840-01-01','2999-12-31'),
	(35287,'20','095',' 05','095054',95054,'Senis','Senis','','OR',1,'1840-01-01','2999-12-31'),
	(35288,'20','095',' 05','095055',95055,'Sennariolo','Sennariolo','','OR',1,'1840-01-01','2999-12-31'),
	(35289,'20','095',' 05','095056',95056,'Siamaggiore','Siamaggiore','','OR',1,'1840-01-01','2999-12-31'),
	(35290,'20','095',' 05','095057',95057,'Siamanna','Siamanna','','OR',1,'1840-01-01','2999-12-31'),
	(35291,'20','095',' 05','095058',95058,'Simala','Simala','','OR',1,'1840-01-01','2999-12-31'),
	(35292,'20','095',' 05','095059',95059,'Simaxis','Simaxis','','OR',1,'1840-01-01','2999-12-31'),
	(35293,'20','095',' 06','095060',95060,'Sini','Sini','','OR',1,'1840-01-01','2999-12-31'),
	(35294,'20','095',' 06','095061',95061,'Siris','Siris','','OR',1,'1840-01-01','2999-12-31'),
	(35295,'20','095',' 06','095062',95062,'Solarussa','Solarussa','','OR',1,'1840-01-01','2999-12-31'),
	(35296,'20','095',' 06','095063',95063,'Sorradile','Sorradile','','OR',1,'1840-01-01','2999-12-31'),
	(35297,'20','095',' 06','095064',95064,'Tadasuni','Tadasuni','','OR',1,'1840-01-01','2999-12-31'),
	(35298,'20','095',' 06','095065',95065,'Terralba','Terralba','','OR',1,'1840-01-01','2999-12-31'),
	(35299,'20','095',' 06','095066',95066,'Tramatza','Tramatza','','OR',1,'1840-01-01','2999-12-31'),
	(35300,'20','095',' 06','095067',95067,'Tresnuraghes','Tresnuraghes','','OR',1,'1840-01-01','2999-12-31'),
	(35301,'20','095',' 06','095068',95068,'Ulà Tirso','Ulà Tirso','','OR',1,'1840-01-01','2999-12-31'),
	(35302,'20','095',' 06','095069',95069,'Uras','Uras','','OR',1,'1840-01-01','2999-12-31'),
	(35303,'20','095',' 07','095070',95070,'Usellus','Usellus','','OR',1,'1840-01-01','2999-12-31'),
	(35304,'20','095',' 07','095071',95071,'Villanova Truschedu','Villanova Truschedu','','OR',1,'1840-01-01','2999-12-31'),
	(35305,'20','095',' 07','095072',95072,'Villaurbana','Villaurbana','','OR',1,'1840-01-01','2999-12-31'),
	(35306,'20','095',' 07','095073',95073,'Villa Verde','Villa Verde','','OR',1,'1840-01-01','2999-12-31'),
	(35307,'20','095',' 07','095074',95074,'Zeddiani','Zeddiani','','OR',1,'1840-01-01','2999-12-31'),
	(35308,'20','095',' 07','095075',95075,'Zerfaliu','Zerfaliu','','OR',1,'1840-01-01','2999-12-31'),
	(35309,'20','095',' 07','095076',95076,'Siapiccia','Siapiccia','','OR',1,'1840-01-01','2999-12-31'),
	(35310,'20','095',' 07','095077',95077,'Curcuris','Curcuris','','OR',1,'1840-01-01','2999-12-31'),
	(35311,'20','095',' 07','095078',95078,'Soddì','Soddì','','OR',1,'1840-01-01','2999-12-31'),
	(35312,'20','095',' 07','095079',95079,'Bosa','Bosa','','OR',1,'1840-01-01','2999-12-31'),
	(35313,'20','095',' 08','095080',95080,'Flussio','Flussio','','OR',1,'1840-01-01','2999-12-31'),
	(35314,'20','095',' 08','095081',95081,'Genoni','Genoni','','OR',1,'1840-01-01','2999-12-31'),
	(35315,'20','095',' 08','095082',95082,'Laconi','Laconi','','OR',1,'1840-01-01','2999-12-31'),
	(35316,'20','095',' 08','095083',95083,'Magomadas','Magomadas','','OR',1,'1840-01-01','2999-12-31'),
	(35317,'20','095',' 08','095084',95084,'Modolo','Modolo','','OR',1,'1840-01-01','2999-12-31'),
	(35318,'20','095',' 08','095085',95085,'Montresta','Montresta','','OR',1,'1840-01-01','2999-12-31'),
	(35319,'20','095',' 08','095086',95086,'Sagama','Sagama','','OR',1,'1840-01-01','2999-12-31'),
	(35320,'20','095',' 08','095087',95087,'Suni','Suni','','OR',1,'1840-01-01','2999-12-31'),
	(35321,'20','095',' 08','095088',95088,'Tinnura','Tinnura','','OR',1,'1840-01-01','2999-12-31'),
	(35322,'01','096',' 00','096001',96001,'Ailoche','Ailoche','','BI',1,'1840-01-01','2999-12-31'),
	(35323,'01','096',' 00','096002',96002,'Andorno Micca','Andorno Micca','','BI',1,'1840-01-01','2999-12-31'),
	(35324,'01','096',' 00','096003',96003,'Benna','Benna','','BI',1,'1840-01-01','2999-12-31'),
	(35325,'01','096',' 00','096004',96004,'Biella','Biella','','BI',1,'1840-01-01','2999-12-31'),
	(35326,'01','096',' 00','096005',96005,'Bioglio','Bioglio','','BI',1,'1840-01-01','2999-12-31'),
	(35327,'01','096',' 00','096006',96006,'Borriana','Borriana','','BI',1,'1840-01-01','2999-12-31'),
	(35328,'01','096',' 00','096007',96007,'Brusnengo','Brusnengo','','BI',1,'1840-01-01','2999-12-31'),
	(35329,'01','096',' 00','096008',96008,'Callabiana','Callabiana','','BI',1,'1840-01-01','2999-12-31'),
	(35330,'01','096',' 00','096009',96009,'Camandona','Camandona','','BI',1,'1840-01-01','2999-12-31'),
	(35331,'01','096',' 01','096010',96010,'Camburzano','Camburzano','','BI',1,'1840-01-01','2999-12-31'),
	(35332,'01','096',' 01','096011',96011,'Campiglia Cervo','Campiglia Cervo','','BI',1,'1840-01-01','2999-12-31'),
	(35333,'01','096',' 01','096012',96012,'Candelo','Candelo','','BI',1,'1840-01-01','2999-12-31'),
	(35334,'01','096',' 01','096013',96013,'Caprile','Caprile','','BI',1,'1840-01-01','2999-12-31'),
	(35335,'01','096',' 01','096014',96014,'Casapinta','Casapinta','','BI',1,'1840-01-01','2999-12-31'),
	(35336,'01','096',' 01','096015',96015,'Castelletto Cervo','Castelletto Cervo','','BI',1,'1840-01-01','2999-12-31'),
	(35337,'01','096',' 01','096016',96016,'Cavaglià','Cavaglià','','BI',1,'1840-01-01','2999-12-31'),
	(35338,'01','096',' 01','096017',96017,'Cerreto Castello','Cerreto Castello','','BI',1,'1840-01-01','2999-12-31'),
	(35339,'01','096',' 01','096018',96018,'Cerrione','Cerrione','','BI',1,'1840-01-01','2999-12-31'),
	(35340,'01','096',' 01','096019',96019,'Coggiola','Coggiola','','BI',1,'1840-01-01','2999-12-31'),
	(35341,'01','096',' 02','096020',96020,'Cossato','Cossato','','BI',1,'1840-01-01','2999-12-31'),
	(35342,'01','096',' 02','096021',96021,'Crevacuore','Crevacuore','','BI',1,'1840-01-01','2999-12-31'),
	(35343,'01','096',' 02','096022',96022,'Crosa','Crosa','','BI',1,'1840-01-01','2999-12-31'),
	(35344,'01','096',' 02','096023',96023,'Curino','Curino','','BI',1,'1840-01-01','2999-12-31'),
	(35345,'01','096',' 02','096024',96024,'Donato','Donato','','BI',1,'1840-01-01','2999-12-31'),
	(35346,'01','096',' 02','096025',96025,'Dorzano','Dorzano','','BI',1,'1840-01-01','2999-12-31'),
	(35347,'01','096',' 02','096026',96026,'Gaglianico','Gaglianico','','BI',1,'1840-01-01','2999-12-31'),
	(35348,'01','096',' 02','096027',96027,'Gifflenga','Gifflenga','','BI',1,'1840-01-01','2999-12-31'),
	(35349,'01','096',' 02','096028',96028,'Graglia','Graglia','','BI',1,'1840-01-01','2999-12-31'),
	(35350,'01','096',' 02','096029',96029,'Lessona','Lessona','','BI',1,'1840-01-01','2999-12-31'),
	(35351,'01','096',' 03','096030',96030,'Magnano','Magnano','','BI',1,'1840-01-01','2999-12-31'),
	(35352,'01','096',' 03','096031',96031,'Massazza','Massazza','','BI',1,'1840-01-01','2999-12-31'),
	(35353,'01','096',' 03','096032',96032,'Masserano','Masserano','','BI',1,'1840-01-01','2999-12-31'),
	(35354,'01','096',' 03','096033',96033,'Mezzana Mortigliengo','Mezzana Mortigliengo','','BI',1,'1840-01-01','2999-12-31'),
	(35355,'01','096',' 03','096034',96034,'Miagliano','Miagliano','','BI',1,'1840-01-01','2999-12-31'),
	(35356,'01','096',' 03','096035',96035,'Mongrando','Mongrando','','BI',1,'1840-01-01','2999-12-31'),
	(35357,'01','096',' 03','096037',96037,'Mottalciata','Mottalciata','','BI',1,'1840-01-01','2999-12-31'),
	(35358,'01','096',' 03','096038',96038,'Muzzano','Muzzano','','BI',1,'1840-01-01','2999-12-31'),
	(35359,'01','096',' 03','096039',96039,'Netro','Netro','','BI',1,'1840-01-01','2999-12-31'),
	(35360,'01','096',' 04','096040',96040,'Occhieppo Inferiore','Occhieppo Inferiore','','BI',1,'1840-01-01','2999-12-31'),
	(35361,'01','096',' 04','096041',96041,'Occhieppo Superiore','Occhieppo Superiore','','BI',1,'1840-01-01','2999-12-31'),
	(35362,'01','096',' 04','096042',96042,'Pettinengo','Pettinengo','','BI',1,'1840-01-01','2999-12-31'),
	(35363,'01','096',' 04','096043',96043,'Piatto','Piatto','','BI',1,'1840-01-01','2999-12-31'),
	(35364,'01','096',' 04','096044',96044,'Piedicavallo','Piedicavallo','','BI',1,'1840-01-01','2999-12-31'),
	(35365,'01','096',' 04','096046',96046,'Pollone','Pollone','','BI',1,'1840-01-01','2999-12-31'),
	(35366,'01','096',' 04','096047',96047,'Ponderano','Ponderano','','BI',1,'1840-01-01','2999-12-31'),
	(35367,'01','096',' 04','096048',96048,'Portula','Portula','','BI',1,'1840-01-01','2999-12-31'),
	(35368,'01','096',' 04','096049',96049,'Pralungo','Pralungo','','BI',1,'1840-01-01','2999-12-31'),
	(35369,'01','096',' 05','096050',96050,'Pray','Pray','','BI',1,'1840-01-01','2999-12-31'),
	(35370,'01','096',' 05','096051',96051,'Quaregna','Quaregna','','BI',1,'1840-01-01','2999-12-31'),
	(35371,'01','096',' 05','096052',96052,'Quittengo','Quittengo','','BI',1,'1840-01-01','2999-12-31'),
	(35372,'01','096',' 05','096053',96053,'Ronco Biellese','Ronco Biellese','','BI',1,'1840-01-01','2999-12-31'),
	(35373,'01','096',' 05','096054',96054,'Roppolo','Roppolo','','BI',1,'1840-01-01','2999-12-31'),
	(35374,'01','096',' 05','096055',96055,'Rosazza','Rosazza','','BI',1,'1840-01-01','2999-12-31'),
	(35375,'01','096',' 05','096056',96056,'Sagliano Micca','Sagliano Micca','','BI',1,'1840-01-01','2999-12-31'),
	(35376,'01','096',' 05','096057',96057,'Sala Biellese','Sala Biellese','','BI',1,'1840-01-01','2999-12-31'),
	(35377,'01','096',' 05','096058',96058,'Salussola','Salussola','','BI',1,'1840-01-01','2999-12-31'),
	(35378,'01','096',' 05','096059',96059,'Sandigliano','Sandigliano','','BI',1,'1840-01-01','2999-12-31'),
	(35379,'01','096',' 06','096060',96060,'San Paolo Cervo','San Paolo Cervo','','BI',1,'1840-01-01','2999-12-31'),
	(35380,'01','096',' 06','096061',96061,'Selve Marcone','Selve Marcone','','BI',1,'1840-01-01','2999-12-31'),
	(35381,'01','096',' 06','096062',96062,'Soprana','Soprana','','BI',1,'1840-01-01','2999-12-31'),
	(35382,'01','096',' 06','096063',96063,'Sordevolo','Sordevolo','','BI',1,'1840-01-01','2999-12-31'),
	(35383,'01','096',' 06','096064',96064,'Sostegno','Sostegno','','BI',1,'1840-01-01','2999-12-31'),
	(35384,'01','096',' 06','096065',96065,'Strona','Strona','','BI',1,'1840-01-01','2999-12-31'),
	(35385,'01','096',' 06','096066',96066,'Tavigliano','Tavigliano','','BI',1,'1840-01-01','2999-12-31'),
	(35386,'01','096',' 06','096067',96067,'Ternengo','Ternengo','','BI',1,'1840-01-01','2999-12-31'),
	(35387,'01','096',' 06','096068',96068,'Tollegno','Tollegno','','BI',1,'1840-01-01','2999-12-31'),
	(35388,'01','096',' 06','096069',96069,'Torrazzo','Torrazzo','','BI',1,'1840-01-01','2999-12-31'),
	(35389,'01','096',' 07','096070',96070,'Trivero','Trivero','','BI',1,'1840-01-01','2999-12-31'),
	(35390,'01','096',' 07','096071',96071,'Valdengo','Valdengo','','BI',1,'1840-01-01','2999-12-31'),
	(35391,'01','096',' 07','096072',96072,'Vallanzengo','Vallanzengo','','BI',1,'1840-01-01','2999-12-31'),
	(35392,'01','096',' 07','096073',96073,'Valle Mosso','Valle Mosso','','BI',1,'1840-01-01','2999-12-31'),
	(35393,'01','096',' 07','096074',96074,'Valle San Nicolao','Valle San Nicolao','','BI',1,'1840-01-01','2999-12-31'),
	(35394,'01','096',' 07','096075',96075,'Veglio','Veglio','','BI',1,'1840-01-01','2999-12-31'),
	(35395,'01','096',' 07','096076',96076,'Verrone','Verrone','','BI',1,'1840-01-01','2999-12-31'),
	(35396,'01','096',' 07','096077',96077,'Vigliano Biellese','Vigliano Biellese','','BI',1,'1840-01-01','2999-12-31'),
	(35397,'01','096',' 07','096078',96078,'Villa del Bosco','Villa del Bosco','','BI',1,'1840-01-01','2999-12-31'),
	(35398,'01','096',' 07','096079',96079,'Villanova Biellese','Villanova Biellese','','BI',1,'1840-01-01','2999-12-31'),
	(35399,'01','096',' 08','096080',96080,'Viverone','Viverone','','BI',1,'1840-01-01','2999-12-31'),
	(35400,'01','096',' 08','096081',96081,'Zimone','Zimone','','BI',1,'1840-01-01','2999-12-31'),
	(35401,'01','096',' 08','096082',96082,'Zubiena','Zubiena','','BI',1,'1840-01-01','2999-12-31'),
	(35402,'01','096',' 08','096083',96083,'Zumaglia','Zumaglia','','BI',1,'1840-01-01','2999-12-31'),
	(35403,'01','096',' 08','096084',96084,'Mosso','Mosso','','BI',1,'1840-01-01','2999-12-31'),
	(35404,'03','097',' 00','097001',97001,'Abbadia Lariana','Abbadia Lariana','','LC',1,'1840-01-01','2999-12-31'),
	(35405,'03','097',' 00','097002',97002,'Airuno','Airuno','','LC',1,'1840-01-01','2999-12-31'),
	(35406,'03','097',' 00','097003',97003,'Annone di Brianza','Annone di Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35407,'03','097',' 00','097004',97004,'Ballabio','Ballabio','','LC',1,'1840-01-01','2999-12-31'),
	(35408,'03','097',' 00','097005',97005,'Barzago','Barzago','','LC',1,'1840-01-01','2999-12-31'),
	(35409,'03','097',' 00','097006',97006,'Barzanò','Barzanò','','LC',1,'1840-01-01','2999-12-31'),
	(35410,'03','097',' 00','097007',97007,'Barzio','Barzio','','LC',1,'1840-01-01','2999-12-31'),
	(35411,'03','097',' 00','097008',97008,'Bellano','Bellano','','LC',1,'1840-01-01','2999-12-31'),
	(35412,'03','097',' 00','097009',97009,'Bosisio Parini','Bosisio Parini','','LC',1,'1840-01-01','2999-12-31'),
	(35413,'03','097',' 01','097010',97010,'Brivio','Brivio','','LC',1,'1840-01-01','2999-12-31'),
	(35414,'03','097',' 01','097011',97011,'Bulciago','Bulciago','','LC',1,'1840-01-01','2999-12-31'),
	(35415,'03','097',' 01','097012',97012,'Calco','Calco','','LC',1,'1840-01-01','2999-12-31'),
	(35416,'03','097',' 01','097013',97013,'Calolziocorte','Calolziocorte','','LC',1,'1840-01-01','2999-12-31'),
	(35417,'03','097',' 01','097014',97014,'Carenno','Carenno','','LC',1,'1840-01-01','2999-12-31'),
	(35418,'03','097',' 01','097015',97015,'Casargo','Casargo','','LC',1,'1840-01-01','2999-12-31'),
	(35419,'03','097',' 01','097016',97016,'Casatenovo','Casatenovo','','LC',1,'1840-01-01','2999-12-31'),
	(35420,'03','097',' 01','097017',97017,'Cassago Brianza','Cassago Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35421,'03','097',' 01','097018',97018,'Cassina Valsassina','Cassina Valsassina','','LC',1,'1840-01-01','2999-12-31'),
	(35422,'03','097',' 01','097019',97019,'Castello di Brianza','Castello di Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35423,'03','097',' 02','097020',97020,'Cernusco Lombardone','Cernusco Lombardone','','LC',1,'1840-01-01','2999-12-31'),
	(35424,'03','097',' 02','097021',97021,'Cesana Brianza','Cesana Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35425,'03','097',' 02','097022',97022,'Civate','Civate','','LC',1,'1840-01-01','2999-12-31'),
	(35426,'03','097',' 02','097023',97023,'Colico','Colico','','LC',1,'1840-01-01','2999-12-31'),
	(35427,'03','097',' 02','097024',97024,'Colle Brianza','Colle Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35428,'03','097',' 02','097025',97025,'Cortenova','Cortenova','','LC',1,'1840-01-01','2999-12-31'),
	(35429,'03','097',' 02','097026',97026,'Costa Masnaga','Costa Masnaga','','LC',1,'1840-01-01','2999-12-31'),
	(35430,'03','097',' 02','097027',97027,'Crandola Valsassina','Crandola Valsassina','','LC',1,'1840-01-01','2999-12-31'),
	(35431,'03','097',' 02','097028',97028,'Cremella','Cremella','','LC',1,'1840-01-01','2999-12-31'),
	(35432,'03','097',' 02','097029',97029,'Cremeno','Cremeno','','LC',1,'1840-01-01','2999-12-31'),
	(35433,'03','097',' 03','097030',97030,'Dervio','Dervio','','LC',1,'1840-01-01','2999-12-31'),
	(35434,'03','097',' 03','097031',97031,'Dolzago','Dolzago','','LC',1,'1840-01-01','2999-12-31'),
	(35435,'03','097',' 03','097032',97032,'Dorio','Dorio','','LC',1,'1840-01-01','2999-12-31'),
	(35436,'03','097',' 03','097033',97033,'Ello','Ello','','LC',1,'1840-01-01','2999-12-31'),
	(35437,'03','097',' 03','097034',97034,'Erve','Erve','','LC',1,'1840-01-01','2999-12-31'),
	(35438,'03','097',' 03','097035',97035,'Esino Lario','Esino Lario','','LC',1,'1840-01-01','2999-12-31'),
	(35439,'03','097',' 03','097036',97036,'Galbiate','Galbiate','','LC',1,'1840-01-01','2999-12-31'),
	(35440,'03','097',' 03','097037',97037,'Garbagnate Monastero','Garbagnate Monastero','','LC',1,'1840-01-01','2999-12-31'),
	(35441,'03','097',' 03','097038',97038,'Garlate','Garlate','','LC',1,'1840-01-01','2999-12-31'),
	(35442,'03','097',' 03','097039',97039,'Imbersago','Imbersago','','LC',1,'1840-01-01','2999-12-31'),
	(35443,'03','097',' 04','097040',97040,'Introbio','Introbio','','LC',1,'1840-01-01','2999-12-31'),
	(35444,'03','097',' 04','097041',97041,'Introzzo','Introzzo','','LC',1,'1840-01-01','2999-12-31'),
	(35445,'03','097',' 04','097042',97042,'Lecco','Lecco','','LC',1,'1840-01-01','2999-12-31'),
	(35446,'03','097',' 04','097043',97043,'Lierna','Lierna','','LC',1,'1840-01-01','2999-12-31'),
	(35447,'03','097',' 04','097044',97044,'Lomagna','Lomagna','','LC',1,'1840-01-01','2999-12-31'),
	(35448,'03','097',' 04','097045',97045,'Malgrate','Malgrate','','LC',1,'1840-01-01','2999-12-31'),
	(35449,'03','097',' 04','097046',97046,'Mandello del Lario','Mandello del Lario','','LC',1,'1840-01-01','2999-12-31'),
	(35450,'03','097',' 04','097047',97047,'Margno','Margno','','LC',1,'1840-01-01','2999-12-31'),
	(35451,'03','097',' 04','097048',97048,'Merate','Merate','','LC',1,'1840-01-01','2999-12-31'),
	(35452,'03','097',' 04','097049',97049,'Missaglia','Missaglia','','LC',1,'1840-01-01','2999-12-31'),
	(35453,'03','097',' 05','097050',97050,'Moggio','Moggio','','LC',1,'1840-01-01','2999-12-31'),
	(35454,'03','097',' 05','097051',97051,'Molteno','Molteno','','LC',1,'1840-01-01','2999-12-31'),
	(35455,'03','097',' 05','097052',97052,'Monte Marenzo','Monte Marenzo','','LC',1,'1840-01-01','2999-12-31'),
	(35456,'03','097',' 05','097053',97053,'Montevecchia','Montevecchia','','LC',1,'1840-01-01','2999-12-31'),
	(35457,'03','097',' 05','097054',97054,'Monticello Brianza','Monticello Brianza','','LC',1,'1840-01-01','2999-12-31'),
	(35458,'03','097',' 05','097055',97055,'Morterone','Morterone','','LC',1,'1840-01-01','2999-12-31'),
	(35459,'03','097',' 05','097056',97056,'Nibionno','Nibionno','','LC',1,'1840-01-01','2999-12-31'),
	(35460,'03','097',' 05','097057',97057,'Oggiono','Oggiono','','LC',1,'1840-01-01','2999-12-31'),
	(35461,'03','097',' 05','097058',97058,'Olgiate Molgora','Olgiate Molgora','','LC',1,'1840-01-01','2999-12-31'),
	(35462,'03','097',' 05','097059',97059,'Olginate','Olginate','','LC',1,'1840-01-01','2999-12-31'),
	(35463,'03','097',' 06','097060',97060,'Oliveto Lario','Oliveto Lario','','LC',1,'1840-01-01','2999-12-31'),
	(35464,'03','097',' 06','097061',97061,'Osnago','Osnago','','LC',1,'1840-01-01','2999-12-31'),
	(35465,'03','097',' 06','097062',97062,'Paderno d\'Adda','Paderno d\'Adda','','LC',1,'1840-01-01','2999-12-31'),
	(35466,'03','097',' 06','097063',97063,'Pagnona','Pagnona','','LC',1,'1840-01-01','2999-12-31'),
	(35467,'03','097',' 06','097064',97064,'Parlasco','Parlasco','','LC',1,'1840-01-01','2999-12-31'),
	(35468,'03','097',' 06','097065',97065,'Pasturo','Pasturo','','LC',1,'1840-01-01','2999-12-31'),
	(35469,'03','097',' 06','097066',97066,'Perego','Perego','','LC',1,'1840-01-01','2999-12-31'),
	(35470,'03','097',' 06','097067',97067,'Perledo','Perledo','','LC',1,'1840-01-01','2999-12-31'),
	(35471,'03','097',' 06','097068',97068,'Pescate','Pescate','','LC',1,'1840-01-01','2999-12-31'),
	(35472,'03','097',' 06','097069',97069,'Premana','Premana','','LC',1,'1840-01-01','2999-12-31'),
	(35473,'03','097',' 07','097070',97070,'Primaluna','Primaluna','','LC',1,'1840-01-01','2999-12-31'),
	(35474,'03','097',' 07','097071',97071,'Robbiate','Robbiate','','LC',1,'1840-01-01','2999-12-31'),
	(35475,'03','097',' 07','097072',97072,'Rogeno','Rogeno','','LC',1,'1840-01-01','2999-12-31'),
	(35476,'03','097',' 07','097073',97073,'Rovagnate','Rovagnate','','LC',1,'1840-01-01','2999-12-31'),
	(35477,'03','097',' 07','097074',97074,'Santa Maria Hoè','Santa Maria Hoè','','LC',1,'1840-01-01','2999-12-31'),
	(35478,'03','097',' 07','097075',97075,'Sirone','Sirone','','LC',1,'1840-01-01','2999-12-31'),
	(35479,'03','097',' 07','097076',97076,'Sirtori','Sirtori','','LC',1,'1840-01-01','2999-12-31'),
	(35480,'03','097',' 07','097077',97077,'Sueglio','Sueglio','','LC',1,'1840-01-01','2999-12-31'),
	(35481,'03','097',' 07','097078',97078,'Suello','Suello','','LC',1,'1840-01-01','2999-12-31'),
	(35482,'03','097',' 07','097079',97079,'Taceno','Taceno','','LC',1,'1840-01-01','2999-12-31'),
	(35483,'03','097',' 08','097080',97080,'Torre de\' Busi','Torre de\' Busi','','LC',1,'1840-01-01','2999-12-31'),
	(35484,'03','097',' 08','097081',97081,'Tremenico','Tremenico','','LC',1,'1840-01-01','2999-12-31'),
	(35485,'03','097',' 08','097082',97082,'Valgreghentino','Valgreghentino','','LC',1,'1840-01-01','2999-12-31'),
	(35486,'03','097',' 08','097083',97083,'Valmadrera','Valmadrera','','LC',1,'1840-01-01','2999-12-31'),
	(35487,'03','097',' 08','097084',97084,'Varenna','Varenna','','LC',1,'1840-01-01','2999-12-31'),
	(35488,'03','097',' 08','097085',97085,'Vendrogno','Vendrogno','','LC',1,'1840-01-01','2999-12-31'),
	(35489,'03','097',' 08','097086',97086,'Vercurago','Vercurago','','LC',1,'1840-01-01','2999-12-31'),
	(35490,'03','097',' 08','097087',97087,'Verderio Inferiore','Verderio Inferiore','','LC',1,'1840-01-01','2999-12-31'),
	(35491,'03','097',' 08','097088',97088,'Verderio Superiore','Verderio Superiore','','LC',1,'1840-01-01','2999-12-31'),
	(35492,'03','097',' 08','097089',97089,'Vestreno','Vestreno','','LC',1,'1840-01-01','2999-12-31'),
	(35493,'03','097',' 09','097090',97090,'Viganò','Viganò','','LC',1,'1840-01-01','2999-12-31'),
	(35494,'03','098',' 00','098001',98001,'Abbadia Cerreto','Abbadia Cerreto','','LO',1,'1840-01-01','2999-12-31'),
	(35495,'03','098',' 00','098002',98002,'Bertonico','Bertonico','','LO',1,'1840-01-01','2999-12-31'),
	(35496,'03','098',' 00','098003',98003,'Boffalora d\'Adda','Boffalora d\'Adda','','LO',1,'1840-01-01','2999-12-31'),
	(35497,'03','098',' 00','098004',98004,'Borghetto Lodigiano','Borghetto Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35498,'03','098',' 00','098005',98005,'Borgo San Giovanni','Borgo San Giovanni','','LO',1,'1840-01-01','2999-12-31'),
	(35499,'03','098',' 00','098006',98006,'Brembio','Brembio','','LO',1,'1840-01-01','2999-12-31'),
	(35500,'03','098',' 00','098007',98007,'Camairago','Camairago','','LO',1,'1840-01-01','2999-12-31'),
	(35501,'03','098',' 00','098008',98008,'Casaletto Lodigiano','Casaletto Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35502,'03','098',' 00','098009',98009,'Casalmaiocco','Casalmaiocco','','LO',1,'1840-01-01','2999-12-31'),
	(35503,'03','098',' 01','098010',98010,'Casalpusterlengo','Casalpusterlengo','','LO',1,'1840-01-01','2999-12-31'),
	(35504,'03','098',' 01','098011',98011,'Caselle Landi','Caselle Landi','','LO',1,'1840-01-01','2999-12-31'),
	(35505,'03','098',' 01','098012',98012,'Caselle Lurani','Caselle Lurani','','LO',1,'1840-01-01','2999-12-31'),
	(35506,'03','098',' 01','098013',98013,'Castelnuovo Bocca d\'Adda','Castelnuovo Bocca d\'Adda','','LO',1,'1840-01-01','2999-12-31'),
	(35507,'03','098',' 01','098014',98014,'Castiglione d\'Adda','Castiglione d\'Adda','','LO',1,'1840-01-01','2999-12-31'),
	(35508,'03','098',' 01','098015',98015,'Castiraga Vidardo','Castiraga Vidardo','','LO',1,'1840-01-01','2999-12-31'),
	(35509,'03','098',' 01','098016',98016,'Cavacurta','Cavacurta','','LO',1,'1840-01-01','2999-12-31'),
	(35510,'03','098',' 01','098017',98017,'Cavenago d\'Adda','Cavenago d\'Adda','','LO',1,'1840-01-01','2999-12-31'),
	(35511,'03','098',' 01','098018',98018,'Cervignano d\'Adda','Cervignano d\'Adda','','LO',1,'1840-01-01','2999-12-31'),
	(35512,'03','098',' 01','098019',98019,'Codogno','Codogno','','LO',1,'1840-01-01','2999-12-31'),
	(35513,'03','098',' 02','098020',98020,'Comazzo','Comazzo','','LO',1,'1840-01-01','2999-12-31'),
	(35514,'03','098',' 02','098021',98021,'Cornegliano Laudense','Cornegliano Laudense','','LO',1,'1840-01-01','2999-12-31'),
	(35515,'03','098',' 02','098022',98022,'Corno Giovine','Corno Giovine','','LO',1,'1840-01-01','2999-12-31'),
	(35516,'03','098',' 02','098023',98023,'Cornovecchio','Cornovecchio','','LO',1,'1840-01-01','2999-12-31'),
	(35517,'03','098',' 02','098024',98024,'Corte Palasio','Corte Palasio','','LO',1,'1840-01-01','2999-12-31'),
	(35518,'03','098',' 02','098025',98025,'Crespiatica','Crespiatica','','LO',1,'1840-01-01','2999-12-31'),
	(35519,'03','098',' 02','098026',98026,'Fombio','Fombio','','LO',1,'1840-01-01','2999-12-31'),
	(35520,'03','098',' 02','098027',98027,'Galgagnano','Galgagnano','','LO',1,'1840-01-01','2999-12-31'),
	(35521,'03','098',' 02','098028',98028,'Graffignana','Graffignana','','LO',1,'1840-01-01','2999-12-31'),
	(35522,'03','098',' 02','098029',98029,'Guardamiglio','Guardamiglio','','LO',1,'1840-01-01','2999-12-31'),
	(35523,'03','098',' 03','098030',98030,'Livraga','Livraga','','LO',1,'1840-01-01','2999-12-31'),
	(35524,'03','098',' 03','098031',98031,'Lodi','Lodi','','LO',1,'1840-01-01','2999-12-31'),
	(35525,'03','098',' 03','098032',98032,'Lodi Vecchio','Lodi Vecchio','','LO',1,'1840-01-01','2999-12-31'),
	(35526,'03','098',' 03','098033',98033,'Maccastorna','Maccastorna','','LO',1,'1840-01-01','2999-12-31'),
	(35527,'03','098',' 03','098034',98034,'Mairago','Mairago','','LO',1,'1840-01-01','2999-12-31'),
	(35528,'03','098',' 03','098035',98035,'Maleo','Maleo','','LO',1,'1840-01-01','2999-12-31'),
	(35529,'03','098',' 03','098036',98036,'Marudo','Marudo','','LO',1,'1840-01-01','2999-12-31'),
	(35530,'03','098',' 03','098037',98037,'Massalengo','Massalengo','','LO',1,'1840-01-01','2999-12-31'),
	(35531,'03','098',' 03','098038',98038,'Meleti','Meleti','','LO',1,'1840-01-01','2999-12-31'),
	(35532,'03','098',' 03','098039',98039,'Merlino','Merlino','','LO',1,'1840-01-01','2999-12-31'),
	(35533,'03','098',' 04','098040',98040,'Montanaso Lombardo','Montanaso Lombardo','','LO',1,'1840-01-01','2999-12-31'),
	(35534,'03','098',' 04','098041',98041,'Mulazzano','Mulazzano','','LO',1,'1840-01-01','2999-12-31'),
	(35535,'03','098',' 04','098042',98042,'Orio Litta','Orio Litta','','LO',1,'1840-01-01','2999-12-31'),
	(35536,'03','098',' 04','098043',98043,'Ospedaletto Lodigiano','Ospedaletto Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35537,'03','098',' 04','098044',98044,'Ossago Lodigiano','Ossago Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35538,'03','098',' 04','098045',98045,'Pieve Fissiraga','Pieve Fissiraga','','LO',1,'1840-01-01','2999-12-31'),
	(35539,'03','098',' 04','098046',98046,'Salerano sul Lambro','Salerano sul Lambro','','LO',1,'1840-01-01','2999-12-31'),
	(35540,'03','098',' 04','098047',98047,'San Fiorano','San Fiorano','','LO',1,'1840-01-01','2999-12-31'),
	(35541,'03','098',' 04','098048',98048,'San Martino in Strada','San Martino in Strada','','LO',1,'1840-01-01','2999-12-31'),
	(35542,'03','098',' 04','098049',98049,'San Rocco al Porto','San Rocco al Porto','','LO',1,'1840-01-01','2999-12-31'),
	(35543,'03','098',' 05','098050',98050,'Sant\'Angelo Lodigiano','Sant\'Angelo Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35544,'03','098',' 05','098051',98051,'Santo Stefano Lodigiano','Santo Stefano Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35545,'03','098',' 05','098052',98052,'Secugnago','Secugnago','','LO',1,'1840-01-01','2999-12-31'),
	(35546,'03','098',' 05','098053',98053,'Senna Lodigiana','Senna Lodigiana','','LO',1,'1840-01-01','2999-12-31'),
	(35547,'03','098',' 05','098054',98054,'Somaglia','Somaglia','','LO',1,'1840-01-01','2999-12-31'),
	(35548,'03','098',' 05','098055',98055,'Sordio','Sordio','','LO',1,'1840-01-01','2999-12-31'),
	(35549,'03','098',' 05','098056',98056,'Tavazzano con Villavesco','Tavazzano con Villavesco','','LO',1,'1840-01-01','2999-12-31'),
	(35550,'03','098',' 05','098057',98057,'Terranova dei Passerini','Terranova dei Passerini','','LO',1,'1840-01-01','2999-12-31'),
	(35551,'03','098',' 05','098058',98058,'Turano Lodigiano','Turano Lodigiano','','LO',1,'1840-01-01','2999-12-31'),
	(35552,'03','098',' 05','098059',98059,'Valera Fratta','Valera Fratta','','LO',1,'1840-01-01','2999-12-31'),
	(35553,'03','098',' 06','098060',98060,'Villanova del Sillaro','Villanova del Sillaro','','LO',1,'1840-01-01','2999-12-31'),
	(35554,'03','098',' 06','098061',98061,'Zelo Buon Persico','Zelo Buon Persico','','LO',1,'1840-01-01','2999-12-31'),
	(35555,'08','099',' 00','099001',99001,'Bellaria-Igea Marina','Bellaria-Igea Marina','','RN',1,'1840-01-01','2999-12-31'),
	(35556,'08','099',' 00','099002',99002,'Cattolica','Cattolica','','RN',1,'1840-01-01','2999-12-31'),
	(35557,'08','099',' 00','099003',99003,'Coriano','Coriano','','RN',1,'1840-01-01','2999-12-31'),
	(35558,'08','099',' 00','099004',99004,'Gemmano','Gemmano','','RN',1,'1840-01-01','2999-12-31'),
	(35559,'08','099',' 00','099005',99005,'Misano Adriatico','Misano Adriatico','','RN',1,'1840-01-01','2999-12-31'),
	(35560,'08','099',' 00','099006',99006,'Mondaino','Mondaino','','RN',1,'1840-01-01','2999-12-31'),
	(35561,'08','099',' 00','099007',99007,'Monte Colombo','Monte Colombo','','RN',1,'1840-01-01','2999-12-31'),
	(35562,'08','099',' 00','099008',99008,'Montefiore Conca','Montefiore Conca','','RN',1,'1840-01-01','2999-12-31'),
	(35563,'08','099',' 00','099009',99009,'Montegridolfo','Montegridolfo','','RN',1,'1840-01-01','2999-12-31'),
	(35564,'08','099',' 01','099010',99010,'Montescudo','Montescudo','','RN',1,'1840-01-01','2999-12-31'),
	(35565,'08','099',' 01','099011',99011,'Morciano di Romagna','Morciano di Romagna','','RN',1,'1840-01-01','2999-12-31'),
	(35566,'08','099',' 01','099012',99012,'Poggio Berni','Poggio Berni','','RN',1,'1840-01-01','2999-12-31'),
	(35567,'08','099',' 01','099013',99013,'Riccione','Riccione','','RN',1,'1840-01-01','2999-12-31'),
	(35568,'08','099',' 01','099014',99014,'Rimini','Rimini','','RN',1,'1840-01-01','2999-12-31'),
	(35569,'08','099',' 01','099015',99015,'Saludecio','Saludecio','','RN',1,'1840-01-01','2999-12-31'),
	(35570,'08','099',' 01','099016',99016,'San Clemente','San Clemente','','RN',1,'1840-01-01','2999-12-31'),
	(35571,'08','099',' 01','099017',99017,'San Giovanni in Marignano','San Giovanni in Marignano','','RN',1,'1840-01-01','2999-12-31'),
	(35572,'08','099',' 01','099018',99018,'Santarcangelo di Romagna','Santarcangelo di Romagna','','RN',1,'1840-01-01','2999-12-31'),
	(35573,'08','099',' 01','099019',99019,'Torriana','Torriana','','RN',1,'1840-01-01','2999-12-31'),
	(35574,'08','099',' 02','099020',99020,'Verucchio','Verucchio','','RN',1,'1840-01-01','2999-12-31'),
	(35575,'08','099',' 02','099021',99021,'Casteldelci','Casteldelci','','RN',1,'1840-01-01','2999-12-31'),
	(35576,'08','099',' 02','099022',99022,'Maiolo','Maiolo','','RN',1,'1840-01-01','2999-12-31'),
	(35577,'08','099',' 02','099023',99023,'Novafeltria','Novafeltria','','RN',1,'1840-01-01','2999-12-31'),
	(35578,'08','099',' 02','099024',99024,'Pennabilli','Pennabilli','','RN',1,'1840-01-01','2999-12-31'),
	(35579,'08','099',' 02','099025',99025,'San Leo','San Leo','','RN',1,'1840-01-01','2999-12-31'),
	(35580,'08','099',' 02','099026',99026,'Sant\'Agata Feltria','Sant\'Agata Feltria','','RN',1,'1840-01-01','2999-12-31'),
	(35581,'08','099',' 02','099027',99027,'Talamello','Talamello','','RN',1,'1840-01-01','2999-12-31'),
	(35582,'09','100',' 00','100001',100001,'Cantagallo','Cantagallo','','PO',1,'1840-01-01','2999-12-31'),
	(35583,'09','100',' 00','100002',100002,'Carmignano','Carmignano','','PO',1,'1840-01-01','2999-12-31'),
	(35584,'09','100',' 00','100003',100003,'Montemurlo','Montemurlo','','PO',1,'1840-01-01','2999-12-31'),
	(35585,'09','100',' 00','100004',100004,'Poggio a Caiano','Poggio a Caiano','','PO',1,'1840-01-01','2999-12-31'),
	(35586,'09','100',' 00','100005',100005,'Prato','Prato','','PO',1,'1840-01-01','2999-12-31'),
	(35587,'09','100',' 00','100006',100006,'Vaiano','Vaiano','','PO',1,'1840-01-01','2999-12-31'),
	(35588,'09','100',' 00','100007',100007,'Vernio','Vernio','','PO',1,'1840-01-01','2999-12-31'),
	(35589,'18','101',' 00','101001',101001,'Belvedere di Spinello','Belvedere di Spinello','','KR',1,'1840-01-01','2999-12-31'),
	(35590,'18','101',' 00','101002',101002,'Caccuri','Caccuri','','KR',1,'1840-01-01','2999-12-31'),
	(35591,'18','101',' 00','101003',101003,'Carfizzi','Carfizzi','','KR',1,'1840-01-01','2999-12-31'),
	(35592,'18','101',' 00','101004',101004,'Casabona','Casabona','','KR',1,'1840-01-01','2999-12-31'),
	(35593,'18','101',' 00','101005',101005,'Castelsilano','Castelsilano','','KR',1,'1840-01-01','2999-12-31'),
	(35594,'18','101',' 00','101006',101006,'Cerenzia','Cerenzia','','KR',1,'1840-01-01','2999-12-31'),
	(35595,'18','101',' 00','101007',101007,'Cirò','Cirò','','KR',1,'1840-01-01','2999-12-31'),
	(35596,'18','101',' 00','101008',101008,'Cirò Marina','Cirò Marina','','KR',1,'1840-01-01','2999-12-31'),
	(35597,'18','101',' 00','101009',101009,'Cotronei','Cotronei','','KR',1,'1840-01-01','2999-12-31'),
	(35598,'18','101',' 01','101010',101010,'Crotone','Crotone','','KR',1,'1840-01-01','2999-12-31'),
	(35599,'18','101',' 01','101011',101011,'Crucoli','Crucoli','','KR',1,'1840-01-01','2999-12-31'),
	(35600,'18','101',' 01','101012',101012,'Cutro','Cutro','','KR',1,'1840-01-01','2999-12-31'),
	(35601,'18','101',' 01','101013',101013,'Isola di Capo Rizzuto','Isola di Capo Rizzuto','','KR',1,'1840-01-01','2999-12-31'),
	(35602,'18','101',' 01','101014',101014,'Melissa','Melissa','','KR',1,'1840-01-01','2999-12-31'),
	(35603,'18','101',' 01','101015',101015,'Mesoraca','Mesoraca','','KR',1,'1840-01-01','2999-12-31'),
	(35604,'18','101',' 01','101016',101016,'Pallagorio','Pallagorio','','KR',1,'1840-01-01','2999-12-31'),
	(35605,'18','101',' 01','101017',101017,'Petilia Policastro','Petilia Policastro','','KR',1,'1840-01-01','2999-12-31'),
	(35606,'18','101',' 01','101018',101018,'Roccabernarda','Roccabernarda','','KR',1,'1840-01-01','2999-12-31'),
	(35607,'18','101',' 01','101019',101019,'Rocca di Neto','Rocca di Neto','','KR',1,'1840-01-01','2999-12-31'),
	(35608,'18','101',' 02','101020',101020,'San Mauro Marchesato','San Mauro Marchesato','','KR',1,'1840-01-01','2999-12-31'),
	(35609,'18','101',' 02','101021',101021,'San Nicola dell\'Alto','San Nicola dell\'Alto','','KR',1,'1840-01-01','2999-12-31'),
	(35610,'18','101',' 02','101022',101022,'Santa Severina','Santa Severina','','KR',1,'1840-01-01','2999-12-31'),
	(35611,'18','101',' 02','101023',101023,'Savelli','Savelli','','KR',1,'1840-01-01','2999-12-31'),
	(35612,'18','101',' 02','101024',101024,'Scandale','Scandale','','KR',1,'1840-01-01','2999-12-31'),
	(35613,'18','101',' 02','101025',101025,'Strongoli','Strongoli','','KR',1,'1840-01-01','2999-12-31'),
	(35614,'18','101',' 02','101026',101026,'Umbriatico','Umbriatico','','KR',1,'1840-01-01','2999-12-31'),
	(35615,'18','101',' 02','101027',101027,'Verzino','Verzino','','KR',1,'1840-01-01','2999-12-31'),
	(35616,'18','102',' 00','102001',102001,'Acquaro','Acquaro','','VV',1,'1840-01-01','2999-12-31'),
	(35617,'18','102',' 00','102002',102002,'Arena','Arena','','VV',1,'1840-01-01','2999-12-31'),
	(35618,'18','102',' 00','102003',102003,'Briatico','Briatico','','VV',1,'1840-01-01','2999-12-31'),
	(35619,'18','102',' 00','102004',102004,'Brognaturo','Brognaturo','','VV',1,'1840-01-01','2999-12-31'),
	(35620,'18','102',' 00','102005',102005,'Capistrano','Capistrano','','VV',1,'1840-01-01','2999-12-31'),
	(35621,'18','102',' 00','102006',102006,'Cessaniti','Cessaniti','','VV',1,'1840-01-01','2999-12-31'),
	(35622,'18','102',' 00','102007',102007,'Dasà','Dasà','','VV',1,'1840-01-01','2999-12-31'),
	(35623,'18','102',' 00','102008',102008,'Dinami','Dinami','','VV',1,'1840-01-01','2999-12-31'),
	(35624,'18','102',' 00','102009',102009,'Drapia','Drapia','','VV',1,'1840-01-01','2999-12-31'),
	(35625,'18','102',' 01','102010',102010,'Fabrizia','Fabrizia','','VV',1,'1840-01-01','2999-12-31'),
	(35626,'18','102',' 01','102011',102011,'Filadelfia','Filadelfia','','VV',1,'1840-01-01','2999-12-31'),
	(35627,'18','102',' 01','102012',102012,'Filandari','Filandari','','VV',1,'1840-01-01','2999-12-31'),
	(35628,'18','102',' 01','102013',102013,'Filogaso','Filogaso','','VV',1,'1840-01-01','2999-12-31'),
	(35629,'18','102',' 01','102014',102014,'Francavilla Angitola','Francavilla Angitola','','VV',1,'1840-01-01','2999-12-31'),
	(35630,'18','102',' 01','102015',102015,'Francica','Francica','','VV',1,'1840-01-01','2999-12-31'),
	(35631,'18','102',' 01','102016',102016,'Gerocarne','Gerocarne','','VV',1,'1840-01-01','2999-12-31'),
	(35632,'18','102',' 01','102017',102017,'Ionadi','Ionadi','','VV',1,'1840-01-01','2999-12-31'),
	(35633,'18','102',' 01','102018',102018,'Joppolo','Joppolo','','VV',1,'1840-01-01','2999-12-31'),
	(35634,'18','102',' 01','102019',102019,'Limbadi','Limbadi','','VV',1,'1840-01-01','2999-12-31'),
	(35635,'18','102',' 02','102020',102020,'Maierato','Maierato','','VV',1,'1840-01-01','2999-12-31'),
	(35636,'18','102',' 02','102021',102021,'Mileto','Mileto','','VV',1,'1840-01-01','2999-12-31'),
	(35637,'18','102',' 02','102022',102022,'Mongiana','Mongiana','','VV',1,'1840-01-01','2999-12-31'),
	(35638,'18','102',' 02','102023',102023,'Monterosso Calabro','Monterosso Calabro','','VV',1,'1840-01-01','2999-12-31'),
	(35639,'18','102',' 02','102024',102024,'Nardodipace','Nardodipace','','VV',1,'1840-01-01','2999-12-31'),
	(35640,'18','102',' 02','102025',102025,'Nicotera','Nicotera','','VV',1,'1840-01-01','2999-12-31'),
	(35641,'18','102',' 02','102026',102026,'Parghelia','Parghelia','','VV',1,'1840-01-01','2999-12-31'),
	(35642,'18','102',' 02','102027',102027,'Pizzo','Pizzo','','VV',1,'1840-01-01','2999-12-31'),
	(35643,'18','102',' 02','102028',102028,'Pizzoni','Pizzoni','','VV',1,'1840-01-01','2999-12-31'),
	(35644,'18','102',' 02','102029',102029,'Polia','Polia','','VV',1,'1840-01-01','2999-12-31'),
	(35645,'18','102',' 03','102030',102030,'Ricadi','Ricadi','','VV',1,'1840-01-01','2999-12-31'),
	(35646,'18','102',' 03','102031',102031,'Rombiolo','Rombiolo','','VV',1,'1840-01-01','2999-12-31'),
	(35647,'18','102',' 03','102032',102032,'San Calogero','San Calogero','','VV',1,'1840-01-01','2999-12-31'),
	(35648,'18','102',' 03','102033',102033,'San Costantino Calabro','San Costantino Calabro','','VV',1,'1840-01-01','2999-12-31'),
	(35649,'18','102',' 03','102034',102034,'San Gregorio d\'Ippona','San Gregorio d\'Ippona','','VV',1,'1840-01-01','2999-12-31'),
	(35650,'18','102',' 03','102035',102035,'San Nicola da Crissa','San Nicola da Crissa','','VV',1,'1840-01-01','2999-12-31'),
	(35651,'18','102',' 03','102036',102036,'Sant\'Onofrio','Sant\'Onofrio','','VV',1,'1840-01-01','2999-12-31'),
	(35652,'18','102',' 03','102037',102037,'Serra San Bruno','Serra San Bruno','','VV',1,'1840-01-01','2999-12-31'),
	(35653,'18','102',' 03','102038',102038,'Simbario','Simbario','','VV',1,'1840-01-01','2999-12-31'),
	(35654,'18','102',' 03','102039',102039,'Sorianello','Sorianello','','VV',1,'1840-01-01','2999-12-31'),
	(35655,'18','102',' 04','102040',102040,'Soriano Calabro','Soriano Calabro','','VV',1,'1840-01-01','2999-12-31'),
	(35656,'18','102',' 04','102041',102041,'Spadola','Spadola','','VV',1,'1840-01-01','2999-12-31'),
	(35657,'18','102',' 04','102042',102042,'Spilinga','Spilinga','','VV',1,'1840-01-01','2999-12-31'),
	(35658,'18','102',' 04','102043',102043,'Stefanaconi','Stefanaconi','','VV',1,'1840-01-01','2999-12-31'),
	(35659,'18','102',' 04','102044',102044,'Tropea','Tropea','','VV',1,'1840-01-01','2999-12-31'),
	(35660,'18','102',' 04','102045',102045,'Vallelonga','Vallelonga','','VV',1,'1840-01-01','2999-12-31'),
	(35661,'18','102',' 04','102046',102046,'Vazzano','Vazzano','','VV',1,'1840-01-01','2999-12-31'),
	(35662,'18','102',' 04','102047',102047,'Vibo Valentia','Vibo Valentia','','VV',1,'1840-01-01','2999-12-31'),
	(35663,'18','102',' 04','102048',102048,'Zaccanopoli','Zaccanopoli','','VV',1,'1840-01-01','2999-12-31'),
	(35664,'18','102',' 04','102049',102049,'Zambrone','Zambrone','','VV',1,'1840-01-01','2999-12-31'),
	(35665,'18','102',' 05','102050',102050,'Zungri','Zungri','','VV',1,'1840-01-01','2999-12-31'),
	(35666,'01','103',' 00','103001',103001,'Antrona Schieranco','Antrona Schieranco','','VB',1,'1840-01-01','2999-12-31'),
	(35667,'01','103',' 00','103002',103002,'Anzola d\'Ossola','Anzola d\'Ossola','','VB',1,'1840-01-01','2999-12-31'),
	(35668,'01','103',' 00','103003',103003,'Arizzano','Arizzano','','VB',1,'1840-01-01','2999-12-31'),
	(35669,'01','103',' 00','103004',103004,'Arola','Arola','','VB',1,'1840-01-01','2999-12-31'),
	(35670,'01','103',' 00','103005',103005,'Aurano','Aurano','','VB',1,'1840-01-01','2999-12-31'),
	(35671,'01','103',' 00','103006',103006,'Baceno','Baceno','','VB',1,'1840-01-01','2999-12-31'),
	(35672,'01','103',' 00','103007',103007,'Bannio Anzino','Bannio Anzino','','VB',1,'1840-01-01','2999-12-31'),
	(35673,'01','103',' 00','103008',103008,'Baveno','Baveno','','VB',1,'1840-01-01','2999-12-31'),
	(35674,'01','103',' 00','103009',103009,'Bee','Bee','','VB',1,'1840-01-01','2999-12-31'),
	(35675,'01','103',' 01','103010',103010,'Belgirate','Belgirate','','VB',1,'1840-01-01','2999-12-31'),
	(35676,'01','103',' 01','103011',103011,'Beura-Cardezza','Beura-Cardezza','','VB',1,'1840-01-01','2999-12-31'),
	(35677,'01','103',' 01','103012',103012,'Bognanco','Bognanco','','VB',1,'1840-01-01','2999-12-31'),
	(35678,'01','103',' 01','103013',103013,'Brovello-Carpugnino','Brovello-Carpugnino','','VB',1,'1840-01-01','2999-12-31'),
	(35679,'01','103',' 01','103014',103014,'Calasca-Castiglione','Calasca-Castiglione','','VB',1,'1840-01-01','2999-12-31'),
	(35680,'01','103',' 01','103015',103015,'Cambiasca','Cambiasca','','VB',1,'1840-01-01','2999-12-31'),
	(35681,'01','103',' 01','103016',103016,'Cannero Riviera','Cannero Riviera','','VB',1,'1840-01-01','2999-12-31'),
	(35682,'01','103',' 01','103017',103017,'Cannobio','Cannobio','','VB',1,'1840-01-01','2999-12-31'),
	(35683,'01','103',' 01','103018',103018,'Caprezzo','Caprezzo','','VB',1,'1840-01-01','2999-12-31'),
	(35684,'01','103',' 01','103019',103019,'Casale Corte Cerro','Casale Corte Cerro','','VB',1,'1840-01-01','2999-12-31'),
	(35685,'01','103',' 02','103020',103020,'Cavaglio-Spoccia','Cavaglio-Spoccia','','VB',1,'1840-01-01','2999-12-31'),
	(35686,'01','103',' 02','103021',103021,'Ceppo Morelli','Ceppo Morelli','','VB',1,'1840-01-01','2999-12-31'),
	(35687,'01','103',' 02','103022',103022,'Cesara','Cesara','','VB',1,'1840-01-01','2999-12-31'),
	(35688,'01','103',' 02','103023',103023,'Cossogno','Cossogno','','VB',1,'1840-01-01','2999-12-31'),
	(35689,'01','103',' 02','103024',103024,'Craveggia','Craveggia','','VB',1,'1840-01-01','2999-12-31'),
	(35690,'01','103',' 02','103025',103025,'Crevoladossola','Crevoladossola','','VB',1,'1840-01-01','2999-12-31'),
	(35691,'01','103',' 02','103026',103026,'Crodo','Crodo','','VB',1,'1840-01-01','2999-12-31'),
	(35692,'01','103',' 02','103027',103027,'Cursolo-Orasso','Cursolo-Orasso','','VB',1,'1840-01-01','2999-12-31'),
	(35693,'01','103',' 02','103028',103028,'Domodossola','Domodossola','','VB',1,'1840-01-01','2999-12-31'),
	(35694,'01','103',' 02','103029',103029,'Druogno','Druogno','','VB',1,'1840-01-01','2999-12-31'),
	(35695,'01','103',' 03','103030',103030,'Falmenta','Falmenta','','VB',1,'1840-01-01','2999-12-31'),
	(35696,'01','103',' 03','103031',103031,'Formazza','Formazza','','VB',1,'1840-01-01','2999-12-31'),
	(35697,'01','103',' 03','103032',103032,'Germagno','Germagno','','VB',1,'1840-01-01','2999-12-31'),
	(35698,'01','103',' 03','103033',103033,'Ghiffa','Ghiffa','','VB',1,'1840-01-01','2999-12-31'),
	(35699,'01','103',' 03','103034',103034,'Gignese','Gignese','','VB',1,'1840-01-01','2999-12-31'),
	(35700,'01','103',' 03','103035',103035,'Gravellona Toce','Gravellona Toce','','VB',1,'1840-01-01','2999-12-31'),
	(35701,'01','103',' 03','103036',103036,'Gurro','Gurro','','VB',1,'1840-01-01','2999-12-31'),
	(35702,'01','103',' 03','103037',103037,'Intragna','Intragna','','VB',1,'1840-01-01','2999-12-31'),
	(35703,'01','103',' 03','103038',103038,'Loreglia','Loreglia','','VB',1,'1840-01-01','2999-12-31'),
	(35704,'01','103',' 03','103039',103039,'Macugnaga','Macugnaga','','VB',1,'1840-01-01','2999-12-31'),
	(35705,'01','103',' 04','103040',103040,'Madonna del Sasso','Madonna del Sasso','','VB',1,'1840-01-01','2999-12-31'),
	(35706,'01','103',' 04','103041',103041,'Malesco','Malesco','','VB',1,'1840-01-01','2999-12-31'),
	(35707,'01','103',' 04','103042',103042,'Masera','Masera','','VB',1,'1840-01-01','2999-12-31'),
	(35708,'01','103',' 04','103043',103043,'Massiola','Massiola','','VB',1,'1840-01-01','2999-12-31'),
	(35709,'01','103',' 04','103044',103044,'Mergozzo','Mergozzo','','VB',1,'1840-01-01','2999-12-31'),
	(35710,'01','103',' 04','103045',103045,'Miazzina','Miazzina','','VB',1,'1840-01-01','2999-12-31'),
	(35711,'01','103',' 04','103046',103046,'Montecrestese','Montecrestese','','VB',1,'1840-01-01','2999-12-31'),
	(35712,'01','103',' 04','103047',103047,'Montescheno','Montescheno','','VB',1,'1840-01-01','2999-12-31'),
	(35713,'01','103',' 04','103048',103048,'Nonio','Nonio','','VB',1,'1840-01-01','2999-12-31'),
	(35714,'01','103',' 04','103049',103049,'Oggebbio','Oggebbio','','VB',1,'1840-01-01','2999-12-31'),
	(35715,'01','103',' 05','103050',103050,'Omegna','Omegna','','VB',1,'1840-01-01','2999-12-31'),
	(35716,'01','103',' 05','103051',103051,'Ornavasso','Ornavasso','','VB',1,'1840-01-01','2999-12-31'),
	(35717,'01','103',' 05','103052',103052,'Pallanzeno','Pallanzeno','','VB',1,'1840-01-01','2999-12-31'),
	(35718,'01','103',' 05','103053',103053,'Piedimulera','Piedimulera','','VB',1,'1840-01-01','2999-12-31'),
	(35719,'01','103',' 05','103054',103054,'Pieve Vergonte','Pieve Vergonte','','VB',1,'1840-01-01','2999-12-31'),
	(35720,'01','103',' 05','103055',103055,'Premeno','Premeno','','VB',1,'1840-01-01','2999-12-31'),
	(35721,'01','103',' 05','103056',103056,'Premia','Premia','','VB',1,'1840-01-01','2999-12-31'),
	(35722,'01','103',' 05','103057',103057,'Premosello-Chiovenda','Premosello-Chiovenda','','VB',1,'1840-01-01','2999-12-31'),
	(35723,'01','103',' 05','103058',103058,'Quarna Sopra','Quarna Sopra','','VB',1,'1840-01-01','2999-12-31'),
	(35724,'01','103',' 05','103059',103059,'Quarna Sotto','Quarna Sotto','','VB',1,'1840-01-01','2999-12-31'),
	(35725,'01','103',' 06','103060',103060,'Re','Re','','VB',1,'1840-01-01','2999-12-31'),
	(35726,'01','103',' 06','103061',103061,'San Bernardino Verbano','San Bernardino Verbano','','VB',1,'1840-01-01','2999-12-31'),
	(35727,'01','103',' 06','103062',103062,'Santa Maria Maggiore','Santa Maria Maggiore','','VB',1,'1840-01-01','2999-12-31'),
	(35728,'01','103',' 06','103063',103063,'Seppiana','Seppiana','','VB',1,'1840-01-01','2999-12-31'),
	(35729,'01','103',' 06','103064',103064,'Stresa','Stresa','','VB',1,'1840-01-01','2999-12-31'),
	(35730,'01','103',' 06','103065',103065,'Toceno','Toceno','','VB',1,'1840-01-01','2999-12-31'),
	(35731,'01','103',' 06','103066',103066,'Trarego Viggiona','Trarego Viggiona','','VB',1,'1840-01-01','2999-12-31'),
	(35732,'01','103',' 06','103067',103067,'Trasquera','Trasquera','','VB',1,'1840-01-01','2999-12-31'),
	(35733,'01','103',' 06','103068',103068,'Trontano','Trontano','','VB',1,'1840-01-01','2999-12-31'),
	(35734,'01','103',' 06','103069',103069,'Valstrona','Valstrona','','VB',1,'1840-01-01','2999-12-31'),
	(35735,'01','103',' 07','103070',103070,'Vanzone con San Carlo','Vanzone con San Carlo','','VB',1,'1840-01-01','2999-12-31'),
	(35736,'01','103',' 07','103071',103071,'Varzo','Varzo','','VB',1,'1840-01-01','2999-12-31'),
	(35737,'01','103',' 07','103072',103072,'Verbania','Verbania','','VB',1,'1840-01-01','2999-12-31'),
	(35738,'01','103',' 07','103073',103073,'Viganella','Viganella','','VB',1,'1840-01-01','2999-12-31'),
	(35739,'01','103',' 07','103074',103074,'Vignone','Vignone','','VB',1,'1840-01-01','2999-12-31'),
	(35740,'01','103',' 07','103075',103075,'Villadossola','Villadossola','','VB',1,'1840-01-01','2999-12-31'),
	(35741,'01','103',' 07','103076',103076,'Villette','Villette','','VB',1,'1840-01-01','2999-12-31'),
	(35742,'01','103',' 07','103077',103077,'Vogogna','Vogogna','','VB',1,'1840-01-01','2999-12-31'),
	(35743,'20','104',' 00','104001',104001,'Aggius','Aggius','','OT',1,'1840-01-01','2999-12-31'),
	(35744,'20','104',' 00','104002',104002,'Aglientu','Aglientu','','OT',1,'1840-01-01','2999-12-31'),
	(35745,'20','104',' 00','104003',104003,'Alà dei Sardi','Alà dei Sardi','','OT',1,'1840-01-01','2999-12-31'),
	(35746,'20','104',' 00','104004',104004,'Arzachena','Arzachena','','OT',1,'1840-01-01','2999-12-31'),
	(35747,'20','104',' 00','104005',104005,'Badesi','Badesi','','OT',1,'1840-01-01','2999-12-31'),
	(35748,'20','104',' 00','104006',104006,'Berchidda','Berchidda','','OT',1,'1840-01-01','2999-12-31'),
	(35749,'20','104',' 00','104007',104007,'Bortigiadas','Bortigiadas','','OT',1,'1840-01-01','2999-12-31'),
	(35750,'20','104',' 00','104008',104008,'Buddusò','Buddusò','','OT',1,'1840-01-01','2999-12-31'),
	(35751,'20','104',' 00','104009',104009,'Budoni','Budoni','','OT',1,'1840-01-01','2999-12-31'),
	(35752,'20','104',' 01','104010',104010,'Calangianus','Calangianus','','OT',1,'1840-01-01','2999-12-31'),
	(35753,'20','104',' 01','104011',104011,'Golfo Aranci','Golfo Aranci','','OT',1,'1840-01-01','2999-12-31'),
	(35754,'20','104',' 01','104012',104012,'La Maddalena','La Maddalena','','OT',1,'1840-01-01','2999-12-31'),
	(35755,'20','104',' 01','104013',104013,'Loiri Porto San Paolo','Loiri Porto San Paolo','','OT',1,'1840-01-01','2999-12-31'),
	(35756,'20','104',' 01','104014',104014,'Luogosanto','Luogosanto','','OT',1,'1840-01-01','2999-12-31'),
	(35757,'20','104',' 01','104015',104015,'Luras','Luras','','OT',1,'1840-01-01','2999-12-31'),
	(35758,'20','104',' 01','104016',104016,'Monti','Monti','','OT',1,'1840-01-01','2999-12-31'),
	(35759,'20','104',' 01','104017',104017,'Olbia','Olbia','','OT',1,'1840-01-01','2999-12-31'),
	(35760,'20','104',' 01','104018',104018,'Oschiri','Oschiri','','OT',1,'1840-01-01','2999-12-31'),
	(35761,'20','104',' 01','104019',104019,'Padru','Padru','','OT',1,'1840-01-01','2999-12-31'),
	(35762,'20','104',' 02','104020',104020,'Palau','Palau','','OT',1,'1840-01-01','2999-12-31'),
	(35763,'20','104',' 02','104021',104021,'Sant\'Antonio di Gallura','Sant\'Antonio di Gallura','','OT',1,'1840-01-01','2999-12-31'),
	(35764,'20','104',' 02','104022',104022,'Santa Teresa Gallura','Santa Teresa Gallura','','OT',1,'1840-01-01','2999-12-31'),
	(35765,'20','104',' 02','104023',104023,'San Teodoro','San Teodoro','','OT',1,'1840-01-01','2999-12-31'),
	(35766,'20','104',' 02','104024',104024,'Telti','Telti','','OT',1,'1840-01-01','2999-12-31'),
	(35767,'20','104',' 02','104025',104025,'Tempio Pausania','Tempio Pausania','','OT',1,'1840-01-01','2999-12-31'),
	(35768,'20','104',' 02','104026',104026,'Trinità d\'Agultu e Vignola','Trinità d\'Agultu e Vignola','','OT',1,'1840-01-01','2999-12-31'),
	(35769,'20','105',' 00','105001',105001,'Arzana','Arzana','','OG',1,'1840-01-01','2999-12-31'),
	(35770,'20','105',' 00','105002',105002,'Bari Sardo','Bari Sardo','','OG',1,'1840-01-01','2999-12-31'),
	(35771,'20','105',' 00','105003',105003,'Baunei','Baunei','','OG',1,'1840-01-01','2999-12-31'),
	(35772,'20','105',' 00','105004',105004,'Cardedu','Cardedu','','OG',1,'1840-01-01','2999-12-31'),
	(35773,'20','105',' 00','105005',105005,'Elini','Elini','','OG',1,'1840-01-01','2999-12-31'),
	(35774,'20','105',' 00','105006',105006,'Gairo','Gairo','','OG',1,'1840-01-01','2999-12-31'),
	(35775,'20','105',' 00','105007',105007,'Girasole','Girasole','','OG',1,'1840-01-01','2999-12-31'),
	(35776,'20','105',' 00','105008',105008,'Ilbono','Ilbono','','OG',1,'1840-01-01','2999-12-31'),
	(35777,'20','105',' 00','105009',105009,'Jerzu','Jerzu','','OG',1,'1840-01-01','2999-12-31'),
	(35778,'20','105',' 01','105010',105010,'Lanusei','Lanusei','','OG',1,'1840-01-01','2999-12-31'),
	(35779,'20','105',' 01','105011',105011,'Loceri','Loceri','','OG',1,'1840-01-01','2999-12-31'),
	(35780,'20','105',' 01','105012',105012,'Lotzorai','Lotzorai','','OG',1,'1840-01-01','2999-12-31'),
	(35781,'20','105',' 01','105013',105013,'Osini','Osini','','OG',1,'1840-01-01','2999-12-31'),
	(35782,'20','105',' 01','105014',105014,'Perdasdefogu','Perdasdefogu','','OG',1,'1840-01-01','2999-12-31'),
	(35783,'20','105',' 01','105015',105015,'Seui','Seui','','OG',1,'1840-01-01','2999-12-31'),
	(35784,'20','105',' 01','105016',105016,'Talana','Talana','','OG',1,'1840-01-01','2999-12-31'),
	(35785,'20','105',' 01','105017',105017,'Tertenia','Tertenia','','OG',1,'1840-01-01','2999-12-31'),
	(35786,'20','105',' 01','105018',105018,'Tortolì','Tortolì','','OG',1,'1840-01-01','2999-12-31'),
	(35787,'20','105',' 01','105019',105019,'Triei','Triei','','OG',1,'1840-01-01','2999-12-31'),
	(35788,'20','105',' 02','105020',105020,'Ulassai','Ulassai','','OG',1,'1840-01-01','2999-12-31'),
	(35789,'20','105',' 02','105021',105021,'Urzulei','Urzulei','','OG',1,'1840-01-01','2999-12-31'),
	(35790,'20','105',' 02','105022',105022,'Ussassai','Ussassai','','OG',1,'1840-01-01','2999-12-31'),
	(35791,'20','105',' 02','105023',105023,'Villagrande Strisaili','Villagrande Strisaili','','OG',1,'1840-01-01','2999-12-31'),
	(35792,'20','106',' 00','106001',106001,'Arbus','Arbus','','VS',1,'1840-01-01','2999-12-31'),
	(35793,'20','106',' 00','106002',106002,'Barumini','Barumini','','VS',1,'1840-01-01','2999-12-31'),
	(35794,'20','106',' 00','106003',106003,'Collinas','Collinas','','VS',1,'1840-01-01','2999-12-31'),
	(35795,'20','106',' 00','106004',106004,'Furtei','Furtei','','VS',1,'1840-01-01','2999-12-31'),
	(35796,'20','106',' 00','106005',106005,'Genuri','Genuri','','VS',1,'1840-01-01','2999-12-31'),
	(35797,'20','106',' 00','106006',106006,'Gesturi','Gesturi','','VS',1,'1840-01-01','2999-12-31'),
	(35798,'20','106',' 00','106007',106007,'Gonnosfanadiga','Gonnosfanadiga','','VS',1,'1840-01-01','2999-12-31'),
	(35799,'20','106',' 00','106008',106008,'Guspini','Guspini','','VS',1,'1840-01-01','2999-12-31'),
	(35800,'20','106',' 00','106009',106009,'Las Plassas','Las Plassas','','VS',1,'1840-01-01','2999-12-31'),
	(35801,'20','106',' 01','106010',106010,'Lunamatrona','Lunamatrona','','VS',1,'1840-01-01','2999-12-31'),
	(35802,'20','106',' 01','106011',106011,'Pabillonis','Pabillonis','','VS',1,'1840-01-01','2999-12-31'),
	(35803,'20','106',' 01','106012',106012,'Pauli Arbarei','Pauli Arbarei','','VS',1,'1840-01-01','2999-12-31'),
	(35804,'20','106',' 01','106013',106013,'Samassi','Samassi','','VS',1,'1840-01-01','2999-12-31'),
	(35805,'20','106',' 01','106014',106014,'San Gavino Monreale','San Gavino Monreale','','VS',1,'1840-01-01','2999-12-31'),
	(35806,'20','106',' 01','106015',106015,'Sanluri','Sanluri','','VS',1,'1840-01-01','2999-12-31'),
	(35807,'20','106',' 01','106016',106016,'Sardara','Sardara','','VS',1,'1840-01-01','2999-12-31'),
	(35808,'20','106',' 01','106017',106017,'Segariu','Segariu','','VS',1,'1840-01-01','2999-12-31'),
	(35809,'20','106',' 01','106018',106018,'Serramanna','Serramanna','','VS',1,'1840-01-01','2999-12-31'),
	(35810,'20','106',' 01','106019',106019,'Serrenti','Serrenti','','VS',1,'1840-01-01','2999-12-31'),
	(35811,'20','106',' 02','106020',106020,'Setzu','Setzu','','VS',1,'1840-01-01','2999-12-31'),
	(35812,'20','106',' 02','106021',106021,'Siddi','Siddi','','VS',1,'1840-01-01','2999-12-31'),
	(35813,'20','106',' 02','106022',106022,'Tuili','Tuili','','VS',1,'1840-01-01','2999-12-31'),
	(35814,'20','106',' 02','106023',106023,'Turri','Turri','','VS',1,'1840-01-01','2999-12-31'),
	(35815,'20','106',' 02','106024',106024,'Ussaramanna','Ussaramanna','','VS',1,'1840-01-01','2999-12-31'),
	(35816,'20','106',' 02','106025',106025,'Villacidro','Villacidro','','VS',1,'1840-01-01','2999-12-31'),
	(35817,'20','106',' 02','106026',106026,'Villamar','Villamar','','VS',1,'1840-01-01','2999-12-31'),
	(35818,'20','106',' 02','106027',106027,'Villanovaforru','Villanovaforru','','VS',1,'1840-01-01','2999-12-31'),
	(35819,'20','106',' 02','106028',106028,'Villanovafranca','Villanovafranca','','VS',1,'1840-01-01','2999-12-31'),
	(35820,'20','107',' 00','107001',107001,'Buggerru','Buggerru','','CI',1,'1840-01-01','2999-12-31'),
	(35821,'20','107',' 00','107002',107002,'Calasetta','Calasetta','','CI',1,'1840-01-01','2999-12-31'),
	(35822,'20','107',' 00','107003',107003,'Carbonia','Carbonia','','CI',1,'1840-01-01','2999-12-31'),
	(35823,'20','107',' 00','107004',107004,'Carloforte','Carloforte','','CI',1,'1840-01-01','2999-12-31'),
	(35824,'20','107',' 00','107005',107005,'Domusnovas','Domusnovas','','CI',1,'1840-01-01','2999-12-31'),
	(35825,'20','107',' 00','107006',107006,'Fluminimaggiore','Fluminimaggiore','','CI',1,'1840-01-01','2999-12-31'),
	(35826,'20','107',' 00','107007',107007,'Giba','Giba','','CI',1,'1840-01-01','2999-12-31'),
	(35827,'20','107',' 00','107008',107008,'Gonnesa','Gonnesa','','CI',1,'1840-01-01','2999-12-31'),
	(35828,'20','107',' 00','107009',107009,'Iglesias','Iglesias','','CI',1,'1840-01-01','2999-12-31'),
	(35829,'20','107',' 01','107010',107010,'Masainas','Masainas','','CI',1,'1840-01-01','2999-12-31'),
	(35830,'20','107',' 01','107011',107011,'Musei','Musei','','CI',1,'1840-01-01','2999-12-31'),
	(35831,'20','107',' 01','107012',107012,'Narcao','Narcao','','CI',1,'1840-01-01','2999-12-31'),
	(35832,'20','107',' 01','107013',107013,'Nuxis','Nuxis','','CI',1,'1840-01-01','2999-12-31'),
	(35833,'20','107',' 01','107014',107014,'Perdaxius','Perdaxius','','CI',1,'1840-01-01','2999-12-31'),
	(35834,'20','107',' 01','107015',107015,'Piscinas','Piscinas','','CI',1,'1840-01-01','2999-12-31'),
	(35835,'20','107',' 01','107016',107016,'Portoscuso','Portoscuso','','CI',1,'1840-01-01','2999-12-31'),
	(35836,'20','107',' 01','107017',107017,'San Giovanni Suergiu','San Giovanni Suergiu','','CI',1,'1840-01-01','2999-12-31'),
	(35837,'20','107',' 01','107018',107018,'Santadi','Santadi','','CI',1,'1840-01-01','2999-12-31'),
	(35838,'20','107',' 01','107019',107019,'Sant\'Anna Arresi','Sant\'Anna Arresi','','CI',1,'1840-01-01','2999-12-31'),
	(35839,'20','107',' 02','107020',107020,'Sant\'Antioco','Sant\'Antioco','','CI',1,'1840-01-01','2999-12-31'),
	(35840,'20','107',' 02','107021',107021,'Tratalias','Tratalias','','CI',1,'1840-01-01','2999-12-31'),
	(35841,'20','107',' 02','107022',107022,'Villamassargia','Villamassargia','','CI',1,'1840-01-01','2999-12-31'),
	(35842,'20','107',' 02','107023',107023,'Villaperuccio','Villaperuccio','','CI',1,'1840-01-01','2999-12-31'),
	(35843,'03','108',' 00','108001',108001,'Agrate Brianza','Agrate Brianza','','MB',1,'1840-01-01','2999-12-31'),
	(35844,'03','108',' 00','108002',108002,'Aicurzio','Aicurzio','','MB',1,'1840-01-01','2999-12-31'),
	(35845,'03','108',' 00','108003',108003,'Albiate','Albiate','','MB',1,'1840-01-01','2999-12-31'),
	(35846,'03','108',' 00','108004',108004,'Arcore','Arcore','','MB',1,'1840-01-01','2999-12-31'),
	(35847,'03','108',' 00','108005',108005,'Barlassina','Barlassina','','MB',1,'1840-01-01','2999-12-31'),
	(35848,'03','108',' 00','108006',108006,'Bellusco','Bellusco','','MB',1,'1840-01-01','2999-12-31'),
	(35849,'03','108',' 00','108007',108007,'Bernareggio','Bernareggio','','MB',1,'1840-01-01','2999-12-31'),
	(35850,'03','108',' 00','108008',108008,'Besana in Brianza','Besana in Brianza','','MB',1,'1840-01-01','2999-12-31'),
	(35851,'03','108',' 00','108009',108009,'Biassono','Biassono','','MB',1,'1840-01-01','2999-12-31'),
	(35852,'03','108',' 01','108010',108010,'Bovisio-Masciago','Bovisio-Masciago','','MB',1,'1840-01-01','2999-12-31'),
	(35853,'03','108',' 01','108011',108011,'Briosco','Briosco','','MB',1,'1840-01-01','2999-12-31'),
	(35854,'03','108',' 01','108012',108012,'Brugherio','Brugherio','','MB',1,'1840-01-01','2999-12-31'),
	(35855,'03','108',' 01','108013',108013,'Burago di Molgora','Burago di Molgora','','MB',1,'1840-01-01','2999-12-31'),
	(35856,'03','108',' 01','108014',108014,'Camparada','Camparada','','MB',1,'1840-01-01','2999-12-31'),
	(35857,'03','108',' 01','108015',108015,'Carate Brianza','Carate Brianza','','MB',1,'1840-01-01','2999-12-31'),
	(35858,'03','108',' 01','108016',108016,'Carnate','Carnate','','MB',1,'1840-01-01','2999-12-31'),
	(35859,'03','108',' 01','108017',108017,'Cavenago di Brianza','Cavenago di Brianza','','MB',1,'1840-01-01','2999-12-31'),
	(35860,'03','108',' 01','108018',108018,'Ceriano Laghetto','Ceriano Laghetto','','MB',1,'1840-01-01','2999-12-31'),
	(35861,'03','108',' 01','108019',108019,'Cesano Maderno','Cesano Maderno','','MB',1,'1840-01-01','2999-12-31'),
	(35862,'03','108',' 02','108020',108020,'Cogliate','Cogliate','','MB',1,'1840-01-01','2999-12-31'),
	(35863,'03','108',' 02','108021',108021,'Concorezzo','Concorezzo','','MB',1,'1840-01-01','2999-12-31'),
	(35864,'03','108',' 02','108022',108022,'Correzzana','Correzzana','','MB',1,'1840-01-01','2999-12-31'),
	(35865,'03','108',' 02','108023',108023,'Desio','Desio','','MB',1,'1840-01-01','2999-12-31'),
	(35866,'03','108',' 02','108024',108024,'Giussano','Giussano','','MB',1,'1840-01-01','2999-12-31'),
	(35867,'03','108',' 02','108025',108025,'Lazzate','Lazzate','','MB',1,'1840-01-01','2999-12-31'),
	(35868,'03','108',' 02','108026',108026,'Lesmo','Lesmo','','MB',1,'1840-01-01','2999-12-31'),
	(35869,'03','108',' 02','108027',108027,'Limbiate','Limbiate','','MB',1,'1840-01-01','2999-12-31'),
	(35870,'03','108',' 02','108028',108028,'Lissone','Lissone','','MB',1,'1840-01-01','2999-12-31'),
	(35871,'03','108',' 02','108029',108029,'Macherio','Macherio','','MB',1,'1840-01-01','2999-12-31'),
	(35872,'03','108',' 03','108030',108030,'Meda','Meda','','MB',1,'1840-01-01','2999-12-31'),
	(35873,'03','108',' 03','108031',108031,'Mezzago','Mezzago','','MB',1,'1840-01-01','2999-12-31'),
	(35874,'03','108',' 03','108032',108032,'Misinto','Misinto','','MB',1,'1840-01-01','2999-12-31'),
	(35875,'03','108',' 03','108033',108033,'Monza','Monza','','MB',1,'1840-01-01','2999-12-31'),
	(35876,'03','108',' 03','108034',108034,'Muggiò','Muggiò','','MB',1,'1840-01-01','2999-12-31'),
	(35877,'03','108',' 03','108035',108035,'Nova Milanese','Nova Milanese','','MB',1,'1840-01-01','2999-12-31'),
	(35878,'03','108',' 03','108036',108036,'Ornago','Ornago','','MB',1,'1840-01-01','2999-12-31'),
	(35879,'03','108',' 03','108037',108037,'Renate','Renate','','MB',1,'1840-01-01','2999-12-31'),
	(35880,'03','108',' 03','108038',108038,'Ronco Briantino','Ronco Briantino','','MB',1,'1840-01-01','2999-12-31'),
	(35881,'03','108',' 03','108039',108039,'Seregno','Seregno','','MB',1,'1840-01-01','2999-12-31'),
	(35882,'03','108',' 04','108040',108040,'Seveso','Seveso','','MB',1,'1840-01-01','2999-12-31'),
	(35883,'03','108',' 04','108041',108041,'Sovico','Sovico','','MB',1,'1840-01-01','2999-12-31'),
	(35884,'03','108',' 04','108042',108042,'Sulbiate','Sulbiate','','MB',1,'1840-01-01','2999-12-31'),
	(35885,'03','108',' 04','108043',108043,'Triuggio','Triuggio','','MB',1,'1840-01-01','2999-12-31'),
	(35886,'03','108',' 04','108044',108044,'Usmate Velate','Usmate Velate','','MB',1,'1840-01-01','2999-12-31'),
	(35887,'03','108',' 04','108045',108045,'Varedo','Varedo','','MB',1,'1840-01-01','2999-12-31'),
	(35888,'03','108',' 04','108046',108046,'Vedano al Lambro','Vedano al Lambro','','MB',1,'1840-01-01','2999-12-31'),
	(35889,'03','108',' 04','108047',108047,'Veduggio con Colzano','Veduggio con Colzano','','MB',1,'1840-01-01','2999-12-31'),
	(35890,'03','108',' 04','108048',108048,'Verano Brianza','Verano Brianza','','MB',1,'1840-01-01','2999-12-31'),
	(35891,'03','108',' 04','108049',108049,'Villasanta','Villasanta','','MB',1,'1840-01-01','2999-12-31'),
	(35892,'03','108',' 05','108050',108050,'Vimercate','Vimercate','','MB',1,'1840-01-01','2999-12-31'),
	(35893,'03','108',' 05','108051',108051,'Busnago','Busnago','','MB',1,'1840-01-01','2999-12-31'),
	(35894,'03','108',' 05','108052',108052,'Caponago','Caponago','','MB',1,'1840-01-01','2999-12-31'),
	(35895,'03','108',' 05','108053',108053,'Cornate d\'Adda','Cornate d\'Adda','','MB',1,'1840-01-01','2999-12-31'),
	(35896,'03','108',' 05','108054',108054,'Lentate sul Seveso','Lentate sul Seveso','','MB',1,'1840-01-01','2999-12-31'),
	(35897,'03','108',' 05','108055',108055,'Roncello','Roncello','','MB',1,'1840-01-01','2999-12-31'),
	(35898,'11','109',' 00','109001',109001,'Altidona','Altidona','','FM',1,'1840-01-01','2999-12-31'),
	(35899,'11','109',' 00','109002',109002,'Amandola','Amandola','','FM',1,'1840-01-01','2999-12-31'),
	(35900,'11','109',' 00','109003',109003,'Belmonte Piceno','Belmonte Piceno','','FM',1,'1840-01-01','2999-12-31'),
	(35901,'11','109',' 00','109004',109004,'Campofilone','Campofilone','','FM',1,'1840-01-01','2999-12-31'),
	(35902,'11','109',' 00','109005',109005,'Falerone','Falerone','','FM',1,'1840-01-01','2999-12-31'),
	(35903,'11','109',' 00','109006',109006,'Fermo','Fermo','','FM',1,'1840-01-01','2999-12-31'),
	(35904,'11','109',' 00','109007',109007,'Francavilla d\'Ete','Francavilla d\'Ete','','FM',1,'1840-01-01','2999-12-31'),
	(35905,'11','109',' 00','109008',109008,'Grottazzolina','Grottazzolina','','FM',1,'1840-01-01','2999-12-31'),
	(35906,'11','109',' 00','109009',109009,'Lapedona','Lapedona','','FM',1,'1840-01-01','2999-12-31'),
	(35907,'11','109',' 01','109010',109010,'Magliano di Tenna','Magliano di Tenna','','FM',1,'1840-01-01','2999-12-31'),
	(35908,'11','109',' 01','109011',109011,'Massa Fermana','Massa Fermana','','FM',1,'1840-01-01','2999-12-31'),
	(35909,'11','109',' 01','109012',109012,'Monsampietro Morico','Monsampietro Morico','','FM',1,'1840-01-01','2999-12-31'),
	(35910,'11','109',' 01','109013',109013,'Montappone','Montappone','','FM',1,'1840-01-01','2999-12-31'),
	(35911,'11','109',' 01','109014',109014,'Montefalcone Appennino','Montefalcone Appennino','','FM',1,'1840-01-01','2999-12-31'),
	(35912,'11','109',' 01','109015',109015,'Montefortino','Montefortino','','FM',1,'1840-01-01','2999-12-31'),
	(35913,'11','109',' 01','109016',109016,'Monte Giberto','Monte Giberto','','FM',1,'1840-01-01','2999-12-31'),
	(35914,'11','109',' 01','109017',109017,'Montegiorgio','Montegiorgio','','FM',1,'1840-01-01','2999-12-31'),
	(35915,'11','109',' 01','109018',109018,'Montegranaro','Montegranaro','','FM',1,'1840-01-01','2999-12-31'),
	(35916,'11','109',' 01','109019',109019,'Monteleone di Fermo','Monteleone di Fermo','','FM',1,'1840-01-01','2999-12-31'),
	(35917,'11','109',' 02','109020',109020,'Montelparo','Montelparo','','FM',1,'1840-01-01','2999-12-31'),
	(35918,'11','109',' 02','109021',109021,'Monte Rinaldo','Monte Rinaldo','','FM',1,'1840-01-01','2999-12-31'),
	(35919,'11','109',' 02','109022',109022,'Monterubbiano','Monterubbiano','','FM',1,'1840-01-01','2999-12-31'),
	(35920,'11','109',' 02','109023',109023,'Monte San Pietrangeli','Monte San Pietrangeli','','FM',1,'1840-01-01','2999-12-31'),
	(35921,'11','109',' 02','109024',109024,'Monte Urano','Monte Urano','','FM',1,'1840-01-01','2999-12-31'),
	(35922,'11','109',' 02','109025',109025,'Monte Vidon Combatte','Monte Vidon Combatte','','FM',1,'1840-01-01','2999-12-31'),
	(35923,'11','109',' 02','109026',109026,'Monte Vidon Corrado','Monte Vidon Corrado','','FM',1,'1840-01-01','2999-12-31'),
	(35924,'11','109',' 02','109027',109027,'Montottone','Montottone','','FM',1,'1840-01-01','2999-12-31'),
	(35925,'11','109',' 02','109028',109028,'Moresco','Moresco','','FM',1,'1840-01-01','2999-12-31'),
	(35926,'11','109',' 02','109029',109029,'Ortezzano','Ortezzano','','FM',1,'1840-01-01','2999-12-31'),
	(35927,'11','109',' 03','109030',109030,'Pedaso','Pedaso','','FM',1,'1840-01-01','2999-12-31'),
	(35928,'11','109',' 03','109031',109031,'Petritoli','Petritoli','','FM',1,'1840-01-01','2999-12-31'),
	(35929,'11','109',' 03','109032',109032,'Ponzano di Fermo','Ponzano di Fermo','','FM',1,'1840-01-01','2999-12-31'),
	(35930,'11','109',' 03','109033',109033,'Porto San Giorgio','Porto San Giorgio','','FM',1,'1840-01-01','2999-12-31'),
	(35931,'11','109',' 03','109034',109034,'Porto Sant\'Elpidio','Porto Sant\'Elpidio','','FM',1,'1840-01-01','2999-12-31'),
	(35932,'11','109',' 03','109035',109035,'Rapagnano','Rapagnano','','FM',1,'1840-01-01','2999-12-31'),
	(35933,'11','109',' 03','109036',109036,'Santa Vittoria in Matenano','Santa Vittoria in Matenano','','FM',1,'1840-01-01','2999-12-31'),
	(35934,'11','109',' 03','109037',109037,'Sant\'Elpidio a Mare','Sant\'Elpidio a Mare','','FM',1,'1840-01-01','2999-12-31'),
	(35935,'11','109',' 03','109038',109038,'Servigliano','Servigliano','','FM',1,'1840-01-01','2999-12-31'),
	(35936,'11','109',' 03','109039',109039,'Smerillo','Smerillo','','FM',1,'1840-01-01','2999-12-31'),
	(35937,'11','109',' 04','109040',109040,'Torre San Patrizio','Torre San Patrizio','','FM',1,'1840-01-01','2999-12-31'),
	(35938,'16','110',' 00','110001',110001,'Andria','Andria','','BT',1,'1840-01-01','2999-12-31'),
	(35939,'16','110',' 00','110002',110002,'Barletta','Barletta','','BT',1,'1840-01-01','2999-12-31'),
	(35940,'16','110',' 00','110003',110003,'Bisceglie','Bisceglie','','BT',1,'1840-01-01','2999-12-31'),
	(35941,'16','110',' 00','110004',110004,'Canosa di Puglia','Canosa di Puglia','','BT',1,'1840-01-01','2999-12-31'),
	(35942,'16','110',' 00','110005',110005,'Margherita di Savoia','Margherita di Savoia','','BT',1,'1840-01-01','2999-12-31'),
	(35943,'16','110',' 00','110006',110006,'Minervino Murge','Minervino Murge','','BT',1,'1840-01-01','2999-12-31'),
	(35944,'16','110',' 00','110007',110007,'San Ferdinando di Puglia','San Ferdinando di Puglia','','BT',1,'1840-01-01','2999-12-31'),
	(35945,'16','110',' 00','110008',110008,'Spinazzola','Spinazzola','','BT',1,'1840-01-01','2999-12-31'),
	(35946,'16','110',' 00','110009',110009,'Trani','Trani','','BT',1,'1840-01-01','2999-12-31'),
	(35947,'16','110',' 01','110010',110010,'Trinitapoli','Trinitapoli','','BT',1,'1840-01-01','2999-12-31'),
	(35948,'99','999','99','999203',999203,'AUSTRIA','AUSTRIA','','',1,'1840-01-01','2999-12-31'),
	(35949,'99','999','99','999212',999212,'DANIMARCA','DANIMARCA','','',1,'1840-01-01','2999-12-31'),
	(35950,'99','999','99','999206',999206,'BELGIO','BELGIO','','',1,'1840-01-01','2999-12-31'),
	(35951,'99','999','99','999257',999257,'REPUBBLICA CECA','REPUBBLICA CECA','','',1,'1840-01-01','2999-12-31'),
	(35952,'99','999','99','999330',999330,'INDIA','INDIA','','',1,'1840-01-01','2999-12-31'),
	(35953,'99','999','99','999345',999345,'QATAR','QATAR','','',1,'1840-01-01','2999-12-31'),
	(35954,'99','999','99','999348',999348,'SIRIA','SIRIA','','',1,'1840-01-01','2999-12-31'),
	(35955,'99','999','99','999350',999350,'TIMOR','TIMOR','','',1,'1840-01-01','2999-12-31'),
	(35956,'99','999','99','999246',999246,'CITTA\' DEL VATICANO','CITTA\' DEL VATICANO','','',1,'1840-01-01','2999-12-31'),
	(35957,'99','999','99','999247',999247,'ESTONIA','ESTONIA','','',1,'1840-01-01','2999-12-31'),
	(35958,'99','999','99','999322',999322,'EMIRATI ARABI UNITI','EMIRATI ARABI UNITI','','',1,'1840-01-01','2999-12-31'),
	(35959,'99','999','99','999334',999334,'ISRAELE','ISRAELE','','',1,'1840-01-01','2999-12-31'),
	(35960,'99','999','99','999360',999360,'GEORGIA','GEORGIA','','',1,'1840-01-01','2999-12-31'),
	(35961,'99','999','99','999363',999363,'TAIWAN','TAIWAN','','',1,'1840-01-01','2999-12-31'),
	(35962,'99','999','99','999410',999410,'BURUNDI','BURUNDI','','',1,'1840-01-01','2999-12-31'),
	(35963,'99','999','99','999421',999421,'GABON','GABON','','',1,'1840-01-01','2999-12-31'),
	(35964,'99','999','99','999428',999428,'KENIA','KENIA','','',1,'1840-01-01','2999-12-31'),
	(35965,'99','999','99','999453',999453,'SOMALIA','SOMALIA','','',1,'1840-01-01','2999-12-31'),
	(35966,'99','999','99','999466',999466,'ERITREA','ERITREA','','',1,'1840-01-01','2999-12-31'),
	(35967,'99','999','99','999509',999509,'CANADA','CANADA','','',1,'1840-01-01','2999-12-31'),
	(35968,'99','999','99','999526',999526,'MARTINICA','MARTINICA','','',1,'1840-01-01','2999-12-31'),
	(35969,'99','999','99','999528',999528,'MONTSERRAT','MONTSERRAT','','',1,'1840-01-01','2999-12-31'),
	(35970,'99','999','99','999732',999732,'VANUATU','VANUATU','','',1,'1840-01-01','2999-12-31'),
	(35971,'99','999','99','999318',999318,'COCOS','COCOS','','',1,'1840-01-01','2999-12-31'),
	(35972,'99','999','99','999333',999333,'IRAQ','IRAQ','','',1,'1840-01-01','2999-12-31'),
	(35973,'99','999','99','999340',999340,'MALAYSIA','MALAYSIA','','',1,'1840-01-01','2999-12-31'),
	(35974,'99','999','99','999406',999406,'BENIN','BENIN','','',1,'1840-01-01','2999-12-31'),
	(35975,'99','999','99','999407',999407,'BOPHUTHATSWANA','BOPHUTHATSWANA','','',1,'1840-01-01','2999-12-31'),
	(35976,'99','999','99','999447',999447,'SANT\'ELENA','SANT\'ELENA','','',1,'1840-01-01','2999-12-31'),
	(35977,'99','999','99','999454',999454,'REPUBBLICA SUDAFRICANA','REPUBBLICA SUDAFRICANA','','',1,'1840-01-01','2999-12-31'),
	(35978,'99','999','99','999459',999459,'TRANSKEI','TRANSKEI','','',1,'1840-01-01','2999-12-31'),
	(35979,'99','999','99','999531',999531,'PUERTO RICO','PUERTO RICO','','',1,'1840-01-01','2999-12-31'),
	(35980,'99','999','99','999532',999532,'SANTA LUCIA','SANTA LUCIA','','',1,'1840-01-01','2999-12-31'),
	(35981,'99','999','99','999538',999538,'VERGINI AMERICANE','VERGINI AMERICANE','','',1,'1840-01-01','2999-12-31'),
	(35982,'99','999','99','999615',999615,'PERU\'','PERU\'','','',1,'1840-01-01','2999-12-31'),
	(35983,'99','999','99','999701',999701,'AUSTRALIA','AUSTRALIA','','',1,'1840-01-01','2999-12-31'),
	(35984,'99','999','99','999716',999716,'NIUE','NIUE','','',1,'1840-01-01','2999-12-31'),
	(35985,'99','999','99','999734',999734,'ISOLE WALLIS E FUTUNA','ISOLE WALLIS E FUTUNA','','',1,'1840-01-01','2999-12-31'),
	(35986,'99','999','99','999201',999201,'ALBANIA','ALBANIA','','',1,'1840-01-01','2999-12-31'),
	(35987,'99','999','99','999221',999221,'IRLANDA','IRLANDA','','',1,'1840-01-01','2999-12-31'),
	(35988,'99','999','99','999243',999243,'UCRAINA','UCRAINA','','',1,'1840-01-01','2999-12-31'),
	(35989,'99','999','99','999250',999250,'CROAZIA','CROAZIA','','',1,'1840-01-01','2999-12-31'),
	(35990,'99','999','99','999255',999255,'SLOVACCHIA','SLOVACCHIA','','',1,'1840-01-01','2999-12-31'),
	(35991,'99','999','99','999271',999271,'SERBIA','SERBIA','','',1,'1840-01-01','2999-12-31'),
	(35992,'99','999','99','999329',999329,'HONG KONG','HONG KONG','','',1,'1840-01-01','2999-12-31'),
	(35993,'99','999','99','999343',999343,'OMAN','OMAN','','',1,'1840-01-01','2999-12-31'),
	(35994,'99','999','99','999354',999354,'YEMEN','YEMEN','','',1,'1840-01-01','2999-12-31'),
	(35995,'99','999','99','999515',999515,'DOMINICA','DOMINICA','','',1,'1840-01-01','2999-12-31'),
	(35996,'99','999','99','999521',999521,'GUADALUPA','GUADALUPA','','',1,'1840-01-01','2999-12-31'),
	(35997,'99','999','99','999525',999525,'HONDURAS','HONDURAS','','',1,'1840-01-01','2999-12-31'),
	(35998,'99','999','99','999605',999605,'BRASILE','BRASILE','','',1,'1840-01-01','2999-12-31'),
	(35999,'99','999','99','999608',999608,'COLOMBIA','COLOMBIA','','',1,'1840-01-01','2999-12-31'),
	(36000,'99','999','99','999713',999713,'MICRONESIA STATI FEDERATI','MICRONESIA STATI FEDERATI','','',1,'1840-01-01','2999-12-31'),
	(36001,'99','999','99','999228',999228,'MAN (ISOLA)','MAN (ISOLA)','','',1,'1840-01-01','2999-12-31'),
	(36002,'99','999','99','999233',999233,'POLONIA','POLONIA','','',1,'1840-01-01','2999-12-31'),
	(36003,'99','999','99','999249',999249,'LITUANIA','LITUANIA','','',1,'1840-01-01','2999-12-31'),
	(36004,'99','999','99','999272',999272,'KOSOVO','KOSOVO','','',1,'1840-01-01','2999-12-31'),
	(36005,'99','999','99','999332',999332,'IRAN','IRAN','','',1,'1840-01-01','2999-12-31'),
	(36006,'99','999','99','999336',999336,'LAOS','LAOS','','',1,'1840-01-01','2999-12-31'),
	(36007,'99','999','99','999342',999342,'NEPAL','NEPAL','','',1,'1840-01-01','2999-12-31'),
	(36008,'99','999','99','999408',999408,'BOTSWANA','BOTSWANA','','',1,'1840-01-01','2999-12-31'),
	(36009,'99','999','99','999417',999417,'COMORE','COMORE','','',1,'1840-01-01','2999-12-31'),
	(36010,'99','999','99','999432',999432,'MADAGASCAR','MADAGASCAR','','',1,'1840-01-01','2999-12-31'),
	(36011,'99','999','99','999440',999440,'MOZAMBICO','MOZAMBICO','','',1,'1840-01-01','2999-12-31'),
	(36012,'99','999','99','999441',999441,'NAMIBIA','NAMIBIA','','',1,'1840-01-01','2999-12-31'),
	(36013,'99','999','99','999448',999448,'SAO TOME E PRINCIPE','SAO TOME E PRINCIPE','','',1,'1840-01-01','2999-12-31'),
	(36014,'99','999','99','999449',999449,'SEICELLE','SEICELLE','','',1,'1840-01-01','2999-12-31'),
	(36015,'99','999','99','999451',999451,'SIERRA LEONE','SIERRA LEONE','','',1,'1840-01-01','2999-12-31'),
	(36016,'99','999','99','999464',999464,'ZAMBIA','ZAMBIA','','',1,'1840-01-01','2999-12-31'),
	(36017,'99','999','99','999508',999508,'BERMUDA','BERMUDA','','',1,'1840-01-01','2999-12-31'),
	(36018,'99','999','99','999602',999602,'ARGENTINA','ARGENTINA','','',1,'1840-01-01','2999-12-31'),
	(36019,'99','999','99','999616',999616,'SURINAME','SURINAME','','',1,'1840-01-01','2999-12-31'),
	(36020,'99','999','99','999708',999708,'KIRIBATI','KIRIBATI','','',1,'1840-01-01','2999-12-31'),
	(36021,'99','999','99','999718',999718,'NUOVA CALEDONIA','NUOVA CALEDONIA','','',1,'1840-01-01','2999-12-31'),
	(36022,'99','999','99','999235',999235,'ROMANIA','ROMANIA','','',1,'1840-01-01','2999-12-31'),
	(36023,'99','999','99','999302',999302,'ARABIA SAUDITA','ARABIA SAUDITA','','',1,'1840-01-01','2999-12-31'),
	(36024,'99','999','99','999310',999310,'CAMBOGIA','CAMBOGIA','','',1,'1840-01-01','2999-12-31'),
	(36025,'99','999','99','999315',999315,'CIPRO','CIPRO','','',1,'1840-01-01','2999-12-31'),
	(36026,'99','999','99','999326',999326,'GIAPPONE','GIAPPONE','','',1,'1840-01-01','2999-12-31'),
	(36027,'99','999','99','999353',999353,'VIETNAM','VIETNAM','','',1,'1840-01-01','2999-12-31'),
	(36028,'99','999','99','999358',999358,'ARMENIA','ARMENIA','','',1,'1840-01-01','2999-12-31'),
	(36029,'99','999','99','999362',999362,'TAGIKISTAN','TAGIKISTAN','','',1,'1840-01-01','2999-12-31'),
	(36030,'99','999','99','999415',999415,'CIAD','CIAD','','',1,'1840-01-01','2999-12-31'),
	(36031,'99','999','99','999503',999503,'ANTIGUA E BARBUDA','ANTIGUA E BARBUDA','','',1,'1840-01-01','2999-12-31'),
	(36032,'99','999','99','999504',999504,'ANTILLE OLANDESI','ANTILLE OLANDESI','','',1,'1840-01-01','2999-12-31'),
	(36033,'99','999','99','999511',999511,'CAYMAN','CAYMAN','','',1,'1840-01-01','2999-12-31'),
	(36034,'99','999','99','999513',999513,'COSTA RICA','COSTA RICA','','',1,'1840-01-01','2999-12-31'),
	(36035,'99','999','99','999519',999519,'GRENADA','GRENADA','','',1,'1840-01-01','2999-12-31'),
	(36036,'99','999','99','999619',999619,'VENEZUELA','VENEZUELA','','',1,'1840-01-01','2999-12-31'),
	(36037,'99','999','99','999706',999706,'IRIAN OCCIDENTALE','IRIAN OCCIDENTALE','','',1,'1840-01-01','2999-12-31'),
	(36038,'99','999','99','999209',999209,'BULGARIA','BULGARIA','','',1,'1840-01-01','2999-12-31'),
	(36039,'99','999','99','999227',999227,'MALTA','MALTA','','',1,'1840-01-01','2999-12-31'),
	(36040,'99','999','99','999248',999248,'LETTONIA','LETTONIA','','',1,'1840-01-01','2999-12-31'),
	(36041,'99','999','99','999252',999252,'BOSNIA-ERZEGOVINA','BOSNIA-ERZEGOVINA','','',1,'1840-01-01','2999-12-31'),
	(36042,'99','999','99','999331',999331,'INDONESIA','INDONESIA','','',1,'1840-01-01','2999-12-31'),
	(36043,'99','999','99','999341',999341,'MONGOLIA','MONGOLIA','','',1,'1840-01-01','2999-12-31'),
	(36044,'99','999','99','999364',999364,'TURKEMENISTAN','TURKEMENISTAN','','',1,'1840-01-01','2999-12-31'),
	(36045,'99','999','99','999414',999414,'REPUBBLICA CENTRAFRICANA','REPUBBLICA CENTRAFRICANA','','',1,'1840-01-01','2999-12-31'),
	(36046,'99','999','99','999427',999427,'GUINEA EQUATORIALE','GUINEA EQUATORIALE','','',1,'1840-01-01','2999-12-31'),
	(36047,'99','999','99','999460',999460,'TUNISIA','TUNISIA','','',1,'1840-01-01','2999-12-31'),
	(36048,'99','999','99','999502',999502,'ANGUILLA','ANGUILLA','','',1,'1840-01-01','2999-12-31'),
	(36049,'99','999','99','999606',999606,'CILE','CILE','','',1,'1840-01-01','2999-12-31'),
	(36050,'99','999','99','999612',999612,'GUYANA','GUYANA','','',1,'1840-01-01','2999-12-31'),
	(36051,'99','999','99','999731',999731,'TUVALU','TUVALU','','',1,'1840-01-01','2999-12-31'),
	(36052,'99','999','99','999241',999241,'SVIZZERA','SVIZZERA','','',1,'1840-01-01','2999-12-31'),
	(36053,'99','999','99','999270',999270,'MONTENEGRO','MONTENEGRO','','',1,'1840-01-01','2999-12-31'),
	(36054,'99','999','99','999311',999311,'SRI LANKA','SRI LANKA','','',1,'1840-01-01','2999-12-31'),
	(36055,'99','999','99','999419',999419,'EGITTO','EGITTO','','',1,'1840-01-01','2999-12-31'),
	(36056,'99','999','99','999424',999424,'GIBUTI','GIBUTI','','',1,'1840-01-01','2999-12-31'),
	(36057,'99','999','99','999429',999429,'LESOTHO','LESOTHO','','',1,'1840-01-01','2999-12-31'),
	(36058,'99','999','99','999434',999434,'MALAWI','MALAWI','','',1,'1840-01-01','2999-12-31'),
	(36059,'99','999','99','999446',999446,'RUANDA','RUANDA','','',1,'1840-01-01','2999-12-31'),
	(36060,'99','999','99','999455',999455,'SUDAN','SUDAN','','',1,'1840-01-01','2999-12-31'),
	(36061,'99','999','99','999506',999506,'BARBADOS','BARBADOS','','',1,'1840-01-01','2999-12-31'),
	(36062,'99','999','99','999703',999703,'FIGI','FIGI','','',1,'1840-01-01','2999-12-31'),
	(36063,'99','999','99','999709',999709,'MAQUARIE (ISOLE)','MAQUARIE (ISOLE)','','',1,'1840-01-01','2999-12-31'),
	(36064,'99','999','99','999711',999711,'ISOLE MARIANNE','ISOLE MARIANNE','','',1,'1840-01-01','2999-12-31'),
	(36065,'99','999','99','999720',999720,'PALAU','PALAU','','',1,'1840-01-01','2999-12-31'),
	(36066,'99','999','99','999724',999724,'POLINESIA FRANCESE','POLINESIA FRANCESE','','',1,'1840-01-01','2999-12-31'),
	(36067,'99','999','99','999230',999230,'NORMANNE','NORMANNE','','',1,'1840-01-01','2999-12-31'),
	(36068,'99','999','99','999306',999306,'BHUTAN','BHUTAN','','',1,'1840-01-01','2999-12-31'),
	(36069,'99','999','99','999309',999309,'BRUNEI','BRUNEI','','',1,'1840-01-01','2999-12-31'),
	(36070,'99','999','99','999323',999323,'FILIPPINE','FILIPPINE','','',1,'1840-01-01','2999-12-31'),
	(36071,'99','999','99','999327',999327,'GIORDANIA','GIORDANIA','','',1,'1840-01-01','2999-12-31'),
	(36072,'99','999','99','999339',999339,'MALDIVE','MALDIVE','','',1,'1840-01-01','2999-12-31'),
	(36073,'99','999','99','999359',999359,'ARZEBAIGIAN','ARZEBAIGIAN','','',1,'1840-01-01','2999-12-31'),
	(36074,'99','999','99','999413',999413,'CAPO VERDE','CAPO VERDE','','',1,'1840-01-01','2999-12-31'),
	(36075,'99','999','99','999416',999416,'CISKEI','CISKEI','','',1,'1840-01-01','2999-12-31'),
	(36076,'99','999','99','999418',999418,'CONGO','CONGO','','',1,'1840-01-01','2999-12-31'),
	(36077,'99','999','99','999423',999423,'GHANA','GHANA','','',1,'1840-01-01','2999-12-31'),
	(36078,'99','999','99','999450',999450,'SENEGAL','SENEGAL','','',1,'1840-01-01','2999-12-31'),
	(36079,'99','999','99','999463',999463,'ZAIRE','ZAIRE','','',1,'1840-01-01','2999-12-31'),
	(36080,'99','999','99','999510',999510,'PANAMA ZONA DEL CANALE','PANAMA ZONA DEL CANALE','','',1,'1840-01-01','2999-12-31'),
	(36081,'99','999','99','999520',999520,'GROENLANDIA','GROENLANDIA','','',1,'1840-01-01','2999-12-31'),
	(36082,'99','999','99','999704',999704,'ISOLA DI GUAM','ISOLA DI GUAM','','',1,'1840-01-01','2999-12-31'),
	(36083,'99','999','99','999223',999223,'ISLANDA','ISLANDA','','',1,'1840-01-01','2999-12-31'),
	(36084,'99','999','99','999304',999304,'BAHREIN','BAHREIN','','',1,'1840-01-01','2999-12-31'),
	(36085,'99','999','99','999320',999320,'COREA DEL SUD','COREA DEL SUD','','',1,'1840-01-01','2999-12-31'),
	(36086,'99','999','99','999337',999337,'LIBANO','LIBANO','','',1,'1840-01-01','2999-12-31'),
	(36087,'99','999','99','999456',999456,'SWAZILAND','SWAZILAND','','',1,'1840-01-01','2999-12-31'),
	(36088,'99','999','99','999461',999461,'UGANDA','UGANDA','','',1,'1840-01-01','2999-12-31'),
	(36089,'99','999','99','999609',999609,'ECUADOR','ECUADOR','','',1,'1840-01-01','2999-12-31'),
	(36090,'99','999','99','999610',999610,'ISOLE FALKLAND','ISOLE FALKLAND','','',1,'1840-01-01','2999-12-31'),
	(36091,'99','999','99','999224',999224,'SERBIA E MONTENEGRO','SERBIA E MONTENEGRO','','',1,'1840-01-01','2999-12-31'),
	(36092,'99','999','99','999256',999256,'BIELORUSSIA','BIELORUSSIA','','',1,'1840-01-01','2999-12-31'),
	(36093,'99','999','99','999305',999305,'BANGLADESH','BANGLADESH','','',1,'1840-01-01','2999-12-31'),
	(36094,'99','999','99','999307',999307,'MYANMAR (BIRMANIA)','MYANMAR (BIRMANIA)','','',1,'1840-01-01','2999-12-31'),
	(36095,'99','999','99','999346',999346,'SINGAPORE','SINGAPORE','','',1,'1840-01-01','2999-12-31'),
	(36096,'99','999','99','999430',999430,'LIBERIA','LIBERIA','','',1,'1840-01-01','2999-12-31'),
	(36097,'99','999','99','999514',999514,'CUBA','CUBA','','',1,'1840-01-01','2999-12-31'),
	(36098,'99','999','99','999517',999517,'EL SALVADOR','EL SALVADOR','','',1,'1840-01-01','2999-12-31'),
	(36099,'99','999','99','999714',999714,'ISOLE MIDWAY','ISOLE MIDWAY','','',1,'1840-01-01','2999-12-31'),
	(36100,'99','999','99','999202',999202,'ANDORRA','ANDORRA','','',1,'1840-01-01','2999-12-31'),
	(36101,'99','999','99','999214',999214,'FINLANDIA','FINLANDIA','','',1,'1840-01-01','2999-12-31'),
	(36102,'99','999','99','999617',999617,'TRINIDAD E TOBAGO','TRINIDAD E TOBAGO','','',1,'1840-01-01','2999-12-31'),
	(36103,'99','999','99','999721',999721,'PAPUASIA NUOVA GUINEA','PAPUASIA NUOVA GUINEA','','',1,'1840-01-01','2999-12-31'),
	(36104,'99','999','99','999253',999253,'MACEDONIA','MACEDONIA','','',1,'1840-01-01','2999-12-31'),
	(36105,'99','999','99','999324',999324,'TERRITORIO DI GAZA','TERRITORIO DI GAZA','','',1,'1840-01-01','2999-12-31'),
	(36106,'99','999','99','999351',999351,'TURCHIA','TURCHIA','','',1,'1840-01-01','2999-12-31'),
	(36107,'99','999','99','999220',999220,'GRECIA','GRECIA','','',1,'1840-01-01','2999-12-31'),
	(36108,'99','999','99','999226',999226,'LUSSEMBURGO','LUSSEMBURGO','','',1,'1840-01-01','2999-12-31'),
	(36109,'99','999','99','999234',999234,'PORTOGALLO','PORTOGALLO','','',1,'1840-01-01','2999-12-31'),
	(36110,'99','999','99','999254',999254,'MOLDAVIA','MOLDAVIA','','',1,'1840-01-01','2999-12-31'),
	(36111,'99','999','99','999356',999356,'KAZAKISTAN','KAZAKISTAN','','',1,'1840-01-01','2999-12-31'),
	(36112,'99','999','99','999361',999361,'KIRGHIZISTAN','KIRGHIZISTAN','','',1,'1840-01-01','2999-12-31'),
	(36113,'99','999','99','999402',999402,'ANGOLA','ANGOLA','','',1,'1840-01-01','2999-12-31'),
	(36114,'99','999','99','999438',999438,'MAURIZIUS','MAURIZIUS','','',1,'1840-01-01','2999-12-31'),
	(36115,'99','999','99','999457',999457,'TANZANIA','TANZANIA','','',1,'1840-01-01','2999-12-31'),
	(36116,'99','999','99','999458',999458,'TOGO','TOGO','','',1,'1840-01-01','2999-12-31'),
	(36117,'99','999','99','999462',999462,'VENDA','VENDA','','',1,'1840-01-01','2999-12-31'),
	(36118,'99','999','99','999507',999507,'BELIZE','BELIZE','','',1,'1840-01-01','2999-12-31'),
	(36119,'99','999','99','999518',999518,'GIAMAICA','GIAMAICA','','',1,'1840-01-01','2999-12-31'),
	(36120,'99','999','99','999524',999524,'HAITI','HAITI','','',1,'1840-01-01','2999-12-31'),
	(36121,'99','999','99','999529',999529,'NICARAGUA','NICARAGUA','','',1,'1840-01-01','2999-12-31'),
	(36122,'99','999','99','999614',999614,'PARAGUAY','PARAGUAY','','',1,'1840-01-01','2999-12-31'),
	(36123,'99','999','99','999702',999702,'COOK','COOK','','',1,'1840-01-01','2999-12-31'),
	(36124,'99','999','99','999725',999725,'SALOMONE','SALOMONE','','',1,'1840-01-01','2999-12-31'),
	(36125,'99','999','99','999218',999218,'GIBILTERRA','GIBILTERRA','','',1,'1840-01-01','2999-12-31'),
	(36126,'99','999','99','999225',999225,'LIECHTENSTEIN','LIECHTENSTEIN','','',1,'1840-01-01','2999-12-31'),
	(36127,'99','999','99','999349',999349,'THAILANDIA','THAILANDIA','','',1,'1840-01-01','2999-12-31'),
	(36128,'99','999','99','999409',999409,'BURKINA FASO','BURKINA FASO','','',1,'1840-01-01','2999-12-31'),
	(36129,'99','999','99','999425',999425,'GUINEA','GUINEA','','',1,'1840-01-01','2999-12-31'),
	(36130,'99','999','99','999443',999443,'NIGERIA','NIGERIA','','',1,'1840-01-01','2999-12-31'),
	(36131,'99','999','99','999465',999465,'ZIMBABWE','ZIMBABWE','','',1,'1840-01-01','2999-12-31'),
	(36132,'99','999','99','999516',999516,'REPUBBLICA DOMINICANA','REPUBBLICA DOMINICANA','','',1,'1840-01-01','2999-12-31'),
	(36133,'99','999','99','999523',999523,'GUATEMALA','GUATEMALA','','',1,'1840-01-01','2999-12-31'),
	(36134,'99','999','99','999719',999719,'NUOVA ZELANDA','NUOVA ZELANDA','','',1,'1840-01-01','2999-12-31'),
	(36135,'99','999','99','999723',999723,'PITCAIRN','PITCAIRN','','',1,'1840-01-01','2999-12-31'),
	(36136,'99','999','99','999729',999729,'ISOLE TOKELAU','ISOLE TOKELAU','','',1,'1840-01-01','2999-12-31'),
	(36137,'99','999','99','999213',999213,'FAER OER','FAER OER','','',1,'1840-01-01','2999-12-31'),
	(36138,'99','999','99','999219',999219,'GRAN BRETAGNA','GRAN BRETAGNA','','',1,'1840-01-01','2999-12-31'),
	(36139,'99','999','99','999232',999232,'OLANDA','OLANDA','','',1,'1840-01-01','2999-12-31'),
	(36140,'99','999','99','999240',999240,'SVEZIA','SVEZIA','','',1,'1840-01-01','2999-12-31'),
	(36141,'99','999','99','999251',999251,'SLOVENIA','SLOVENIA','','',1,'1840-01-01','2999-12-31'),
	(36142,'99','999','99','999301',999301,'AFGHANISTAN','AFGHANISTAN','','',1,'1840-01-01','2999-12-31'),
	(36143,'99','999','99','999314',999314,'CINA','CINA','','',1,'1840-01-01','2999-12-31'),
	(36144,'99','999','99','999319',999319,'COREA DEL NORD','COREA DEL NORD','','',1,'1840-01-01','2999-12-31'),
	(36145,'99','999','99','999335',999335,'KUWAIT','KUWAIT','','',1,'1840-01-01','2999-12-31'),
	(36146,'99','999','99','999338',999338,'MACAO','MACAO','','',1,'1840-01-01','2999-12-31'),
	(36147,'99','999','99','999344',999344,'PAKISTAN','PAKISTAN','','',1,'1840-01-01','2999-12-31'),
	(36148,'99','999','99','999420',999420,'ETIOPIA','ETIOPIA','','',1,'1840-01-01','2999-12-31'),
	(36149,'99','999','99','999535',999535,'SAINT PIERRE ET MIQUELON','SAINT PIERRE ET MIQUELON','','',1,'1840-01-01','2999-12-31'),
	(36150,'99','999','99','999537',999537,'TURKS E CAICOS','TURKS E CAICOS','','',1,'1840-01-01','2999-12-31'),
	(36151,'99','999','99','999715',999715,'NAURU','NAURU','','',1,'1840-01-01','2999-12-31'),
	(36152,'99','999','99','999717',999717,'NORFOLK (ISOLE)','NORFOLK (ISOLE)','','',1,'1840-01-01','2999-12-31'),
	(36153,'99','999','99','999722',999722,'ISOLA DI PASQUA','ISOLA DI PASQUA','','',1,'1840-01-01','2999-12-31'),
	(36154,'99','999','99','999210',999210,'CECOSLOVACCHIA','CECOSLOVACCHIA','','',1,'1840-01-01','2999-12-31'),
	(36155,'99','999','99','999217',999217,'GERMANIA REPUBBLICA DEMOCRATIC','GERMANIA REPUBBLICA DEMOCRATIC','','',1,'1840-01-01','2999-12-31'),
	(36156,'99','999','99','999229',999229,'PRINCIPATO DI MONACO','PRINCIPATO DI MONACO','','',1,'1840-01-01','2999-12-31'),
	(36157,'99','999','99','999244',999244,'UNGHERIA','UNGHERIA','','',1,'1840-01-01','2999-12-31'),
	(36158,'99','999','99','999357',999357,'UZBEKISTAN','UZBEKISTAN','','',1,'1840-01-01','2999-12-31'),
	(36159,'99','999','99','999422',999422,'GAMBIA','GAMBIA','','',1,'1840-01-01','2999-12-31'),
	(36160,'99','999','99','999431',999431,'LIBIA','LIBIA','','',1,'1840-01-01','2999-12-31'),
	(36161,'99','999','99','999435',999435,'MALI','MALI','','',1,'1840-01-01','2999-12-31'),
	(36162,'99','999','99','999436',999436,'MAROCCO','MAROCCO','','',1,'1840-01-01','2999-12-31'),
	(36163,'99','999','99','999437',999437,'MAURITANIA','MAURITANIA','','',1,'1840-01-01','2999-12-31'),
	(36164,'99','999','99','999530',999530,'PANAMA','PANAMA','','',1,'1840-01-01','2999-12-31'),
	(36165,'99','999','99','999536',999536,'STATI UNITI D\'AMERICA','STATI UNITI D\'AMERICA','','',1,'1840-01-01','2999-12-31'),
	(36166,'99','999','99','999726',999726,'SAMOA AMERICANE (ISOLE)','SAMOA AMERICANE (ISOLE)','','',1,'1840-01-01','2999-12-31'),
	(36167,'99','999','99','999215',999215,'FRANCIA','FRANCIA','','',1,'1840-01-01','2999-12-31'),
	(36168,'99','999','99','999216',999216,'GERMANIA','GERMANIA','','',1,'1840-01-01','2999-12-31'),
	(36169,'99','999','99','999231',999231,'NORVEGIA','NORVEGIA','','',1,'1840-01-01','2999-12-31'),
	(36170,'99','999','99','999236',999236,'SAN MARINO','SAN MARINO','','',1,'1840-01-01','2999-12-31'),
	(36171,'99','999','99','999239',999239,'SPAGNA','SPAGNA','','',1,'1840-01-01','2999-12-31'),
	(36172,'99','999','99','999245',999245,'RUSSIA','RUSSIA','','',0,'1840-01-01','2999-12-31'),
	(36173,'99','999','99','999312',999312,'CHRISTMAS','CHRISTMAS','','',1,'1840-01-01','2999-12-31'),
	(36174,'99','999','99','999411',999411,'CAMERUN','CAMERUN','','',1,'1840-01-01','2999-12-31'),
	(36175,'99','999','99','999426',999426,'GUINEA BISSAU','GUINEA BISSAU','','',1,'1840-01-01','2999-12-31'),
	(36176,'99','999','99','999439',999439,'MAYOTTE','MAYOTTE','','',1,'1840-01-01','2999-12-31'),
	(36177,'99','999','99','999442',999442,'NIGER','NIGER','','',1,'1840-01-01','2999-12-31'),
	(36178,'99','999','99','999445',999445,'ISOLA DELLA RIUNIONE','ISOLA DELLA RIUNIONE','','',1,'1840-01-01','2999-12-31'),
	(36179,'99','999','99','999505',999505,'BAHAMA','BAHAMA','','',1,'1840-01-01','2999-12-31'),
	(36180,'99','999','99','999604',999604,'BOLIVIA','BOLIVIA','','',1,'1840-01-01','2999-12-31'),
	(36181,'99','999','99','999613',999613,'GUAIANA FRANCESE','GUAIANA FRANCESE','','',1,'1840-01-01','2999-12-31'),
	(36182,'99','999','99','999999',999999,'SENZA FISSA DIMORA/NON DEFINIT','SENZA FISSA DIMORA/NON DEFINIT','','',1,'1840-01-01','2999-12-31'),
	(36183,'99','999','99','999401',999401,'ALGERIA','ALGERIA','','',1,'1840-01-01','2999-12-31'),
	(36184,'99','999','99','999404',999404,'COSTA D\'AVORIO','COSTA D\'AVORIO','','',1,'1840-01-01','2999-12-31'),
	(36185,'99','999','99','999527',999527,'MESSICO','MESSICO','','',1,'1840-01-01','2999-12-31'),
	(36186,'99','999','99','999533',999533,'SAINT VINCENT E GRENADINE','SAINT VINCENT E GRENADINE','','',1,'1840-01-01','2999-12-31'),
	(36187,'99','999','99','999534',999534,'SAINT KITTS E NEVIS','SAINT KITTS E NEVIS','','',1,'1840-01-01','2999-12-31'),
	(36188,'99','999','99','999539',999539,'VERGINI BRITANNICHE','VERGINI BRITANNICHE','','',1,'1840-01-01','2999-12-31'),
	(36189,'99','999','99','999618',999618,'URUGUAY','URUGUAY','','',1,'1840-01-01','2999-12-31'),
	(36190,'99','999','99','999712',999712,'MARSHALL','MARSHALL','','',1,'1840-01-01','2999-12-31'),
	(36191,'99','999','99','999727',999727,'SAMOA','SAMOA','','',1,'1840-01-01','2999-12-31'),
	(36192,'99','999','99','999730',999730,'TONGA','TONGA','','',1,'1840-01-01','2999-12-31'),
	(36193,'99','999','99','999100',999100,'ITALIA','ITALIA','','',1,'1840-01-01','2999-12-31'),
	(36194,'18','102',' 01','002012',2012,'Filandari','Filandari','','VV',1,'1840-01-01','2999-12-31'),
	(36195,'01','103',' 06','003061',3061,'San Bernardino Verbano','San Bernardino Verbano','','VB',1,'1840-01-01','2999-12-31'),
	(36196,'01','103',' 05','003125',3125,'Premosello-Chiovenda','Premosello-Chiovenda','','VB',1,'1840-01-01','2999-12-31'),
	(36197,'01','103',' 07','003156',3156,'Verbania','Verbania','','VB',1,'1840-01-01','2999-12-31'),
	(36198,'03','097',' 04','013124',13124,'Lecco','Lecco','','LC',1,'1840-01-01','2999-12-31'),
	(36199,'03','098',' 01','015079',15079,'Codogno','Codogno','','LO',1,'1840-01-01','2999-12-31'),
	(36200,'03','108',' 02','015121',15121,'Limbiate','Limbiate','','MB',1,'1840-01-01','2999-12-31'),
	(36201,'03','098',' 03','015126',15126,'Lodi','Lodi','','LO',1,'1840-01-01','2999-12-31'),
	(36202,'03','108',' 03','015149',15149,'Monza','Monza','','MB',1,'1840-01-01','2999-12-31'),
	(36203,'03','108',' 03','015208',15208,'Seregno','Seregno','','MB',1,'1840-01-01','2999-12-31'),
	(36204,'08','099',' 01','040035',40035,'Rimini','Rimini','','RN',1,'1840-01-01','2999-12-31'),
	(36205,'08','099',' 02','041039',41039,'Novafeltria','Novafeltria','','RN',1,'1840-01-01','2999-12-31'),
	(36206,'09','100',' 00','048034',48034,'Prato','Prato','','PO',1,'1840-01-01','2999-12-31'),
	(36207,'16','110',' 00','072009',72009,'Bisceglie','Bisceglie','','BT',1,'1840-01-01','2999-12-31'),
	(36208,'18','101',' 01','079037',79037,'Crotone','Crotone','','KR',1,'1840-01-01','2999-12-31'),
	(36209,'18','102',' 02','079086',79086,'Nicotera','Nicotera','','VV',1,'1840-01-01','2999-12-31'),
	(36210,'18','102',' 02','079097',79097,'Pizzo','Pizzo','','VV',1,'1840-01-01','2999-12-31'),
	(36211,'18','101',' 01','079103',79103,'Rocca di Neto','Rocca di Neto','','KR',1,'1840-01-01','2999-12-31'),
	(36212,'18','102',' 03','079121',79121,'Sant\'Onofrio','Sant\'Onofrio','','VV',1,'1840-01-01','2999-12-31'),
	(36213,'18','101',' 02','079124',79124,'Savelli','Savelli','','KR',1,'1840-01-01','2999-12-31'),
	(36214,'18','102',' 04','079140',79140,'Spadola','Spadola','','VV',1,'1840-01-01','2999-12-31'),
	(36215,'18','102',' 04','079149',79149,'Tropea','Tropea','','VV',1,'1840-01-01','2999-12-31'),
	(36216,'18','102',' 04','079155',79155,'Vibo Valentia','Vibo Valentia','','VV',1,'1840-01-01','2999-12-31'),
	(36217,'20','104',' 00','090001',90001,'Aggius','Aggius','','OT',1,'1840-01-01','2999-12-31'),
	(36218,'20','104',' 00','090002',90002,'Alà dei Sardi','Alà dei Sardi','','OT',1,'1840-01-01','2999-12-31'),
	(36219,'20','104',' 00','090006',90006,'Arzachena','Arzachena','','OT',1,'1840-01-01','2999-12-31'),
	(36220,'20','104',' 00','090009',90009,'Berchidda','Berchidda','','OT',1,'1840-01-01','2999-12-31'),
	(36221,'20','104',' 00','090017',90017,'Buddusò','Buddusò','','OT',1,'1840-01-01','2999-12-31'),
	(36222,'20','104',' 01','090021',90021,'Calangianus','Calangianus','','OT',1,'1840-01-01','2999-12-31'),
	(36223,'20','104',' 01','090035',90035,'La Maddalena','La Maddalena','','OT',1,'1840-01-01','2999-12-31'),
	(36224,'20','104',' 01','090036',90036,'Luogosanto','Luogosanto','','OT',1,'1840-01-01','2999-12-31'),
	(36225,'20','104',' 01','090037',90037,'Luras','Luras','','OT',1,'1840-01-01','2999-12-31'),
	(36226,'20','104',' 01','090041',90041,'Monti','Monti','','OT',1,'1840-01-01','2999-12-31'),
	(36227,'20','104',' 01','090047',90047,'Olbia','Olbia','','OT',1,'1840-01-01','2999-12-31'),
	(36228,'20','104',' 01','090049',90049,'Oschiri','Oschiri','','OT',1,'1840-01-01','2999-12-31'),
	(36229,'20','104',' 02','090054',90054,'Palau','Palau','','OT',1,'1840-01-01','2999-12-31'),
	(36230,'20','104',' 02','090063',90063,'Santa Teresa Gallura','Santa Teresa Gallura','','OT',1,'1840-01-01','2999-12-31'),
	(36231,'20','104',' 02','090070',90070,'Tempio Pausania','Tempio Pausania','','OT',1,'1840-01-01','2999-12-31'),
	(36232,'20','104',' 02','090074',90074,'Trinità d\'Agultu e Vignola','Trinità d\'Agultu e Vignola','','OT',1,'1840-01-01','2999-12-31'),
	(36233,'20','104',' 02','090080',90080,'Telti','Telti','','OT',1,'1840-01-01','2999-12-31'),
	(36234,'20','104',' 01','090084',90084,'Loiri Porto San Paolo','Loiri Porto San Paolo','','OT',1,'1840-01-01','2999-12-31'),
	(36235,'20','104',' 02','090085',90085,'Sant\'Antonio di Gallura','Sant\'Antonio di Gallura','','OT',1,'1840-01-01','2999-12-31'),
	(36236,'20','105',' 00','091002',91002,'Arzana','Arzana','','OG',1,'1840-01-01','2999-12-31'),
	(36237,'20','090',' 06','090802',90802,'Nuchis','Nuchis','','SS',1,'1840-01-01','2999-12-31'),
	(36238,'20','105',' 00','091005',91005,'Bari Sardo','Bari Sardo','','OG',1,'1840-01-01','2999-12-31'),
	(36239,'20','105',' 00','091006',91006,'Baunei','Baunei','','OG',1,'1840-01-01','2999-12-31'),
	(36240,'20','095',' 07','091013',91013,'Bosa','Bosa','','OR',1,'1840-01-01','2999-12-31'),
	(36241,'20','104',' 00','091014',91014,'Budoni','Budoni','','OT',1,'1840-01-01','2999-12-31'),
	(36242,'20','105',' 00','091019',91019,'Elini','Elini','','OG',1,'1840-01-01','2999-12-31'),
	(36243,'20','092',' 11','091020',91020,'Escalaplano','Escalaplano','','CA',1,'1840-01-01','2999-12-31'),
	(36244,'20','092',' 11','091022',91022,'Esterzili','Esterzili','','CA',1,'1840-01-01','2999-12-31'),
	(36245,'20','095',' 08','091023',91023,'Flussio','Flussio','','OR',1,'1840-01-01','2999-12-31'),
	(36246,'20','105',' 00','091026',91026,'Gairo','Gairo','','OG',1,'1840-01-01','2999-12-31'),
	(36247,'20','095',' 08','091029',91029,'Genoni','Genoni','','OR',1,'1840-01-01','2999-12-31'),
	(36248,'20','105',' 00','091031',91031,'Girasole','Girasole','','OG',1,'1840-01-01','2999-12-31'),
	(36249,'20','105',' 00','091032',91032,'Ilbono','Ilbono','','OG',1,'1840-01-01','2999-12-31'),
	(36250,'20','092',' 11','091034',91034,'Isili','Isili','','CA',1,'1840-01-01','2999-12-31'),
	(36251,'20','105',' 00','091035',91035,'Jerzu','Jerzu','','OG',1,'1840-01-01','2999-12-31'),
	(36252,'20','095',' 08','091036',91036,'Laconi','Laconi','','OR',1,'1840-01-01','2999-12-31'),
	(36253,'20','105',' 01','091037',91037,'Lanusei','Lanusei','','OG',1,'1840-01-01','2999-12-31'),
	(36254,'20','105',' 01','091039',91039,'Loceri','Loceri','','OG',1,'1840-01-01','2999-12-31'),
	(36255,'20','105',' 01','091042',91042,'Lotzorai','Lotzorai','','OG',1,'1840-01-01','2999-12-31'),
	(36256,'20','095',' 08','091045',91045,'Magomadas','Magomadas','','OR',1,'1840-01-01','2999-12-31'),
	(36257,'20','095',' 08','091048',91048,'Modolo','Modolo','','OR',1,'1840-01-01','2999-12-31'),
	(36258,'20','095',' 08','091049',91049,'Montresta','Montresta','','OR',1,'1840-01-01','2999-12-31'),
	(36259,'20','092',' 11','091053',91053,'Nurallao','Nurallao','','CA',1,'1840-01-01','2999-12-31'),
	(36260,'20','092',' 11','091054',91054,'Nurri','Nurri','','CA',1,'1840-01-01','2999-12-31'),
	(36261,'20','092',' 11','091065',91065,'Orroli','Orroli','','CA',1,'1840-01-01','2999-12-31'),
	(36262,'20','105',' 01','091069',91069,'Osini','Osini','','OG',1,'1840-01-01','2999-12-31'),
	(36263,'20','105',' 01','091072',91072,'Perdasdefogu','Perdasdefogu','','OG',1,'1840-01-01','2999-12-31'),
	(36264,'20','095',' 08','091075',91075,'Sagama','Sagama','','OR',1,'1840-01-01','2999-12-31'),
	(36265,'20','104',' 02','091076',91076,'San Teodoro','San Teodoro','','OT',1,'1840-01-01','2999-12-31'),
	(36266,'20','105',' 01','091081',91081,'Seui','Seui','','OG',1,'1840-01-01','2999-12-31'),
	(36267,'20','092',' 12','091082',91082,'Seulo','Seulo','','CA',1,'1840-01-01','2999-12-31'),
	(36268,'20','095',' 08','091087',91087,'Suni','Suni','','OR',1,'1840-01-01','2999-12-31'),
	(36269,'20','105',' 01','091088',91088,'Talana','Talana','','OG',1,'1840-01-01','2999-12-31'),
	(36270,'20','105',' 01','091089',91089,'Tertenia','Tertenia','','OG',1,'1840-01-01','2999-12-31'),
	(36271,'20','095',' 08','091092',91092,'Tinnura','Tinnura','','OR',1,'1840-01-01','2999-12-31'),
	(36272,'20','105',' 01','091095',91095,'Tortolì','Tortolì','','OG',1,'1840-01-01','2999-12-31'),
	(36273,'20','105',' 01','091097',91097,'Triei','Triei','','OG',1,'1840-01-01','2999-12-31'),
	(36274,'20','105',' 02','091098',91098,'Ulassai','Ulassai','','OG',1,'1840-01-01','2999-12-31'),
	(36275,'20','105',' 02','091099',91099,'Urzulei','Urzulei','','OG',1,'1840-01-01','2999-12-31'),
	(36276,'20','105',' 02','091100',91100,'Ussassai','Ussassai','','OG',1,'1840-01-01','2999-12-31'),
	(36277,'20','105',' 02','091101',91101,'Villagrande Strisaili','Villagrande Strisaili','','OG',1,'1840-01-01','2999-12-31'),
	(36278,'20','106',' 00','092001',92001,'Arbus','Arbus','','VS',1,'1840-01-01','2999-12-31'),
	(36279,'20','107',' 00','092010',92010,'Calasetta','Calasetta','','CI',1,'1840-01-01','2999-12-31'),
	(36280,'20','107',' 00','092012',92012,'Carbonia','Carbonia','','CI',1,'1840-01-01','2999-12-31'),
	(36281,'20','107',' 00','092013',92013,'Carloforte','Carloforte','','CI',1,'1840-01-01','2999-12-31'),
	(36282,'20','107',' 00','092019',92019,'Domusnovas','Domusnovas','','CI',1,'1840-01-01','2999-12-31'),
	(36283,'20','107',' 00','092021',92021,'Fluminimaggiore','Fluminimaggiore','','CI',1,'1840-01-01','2999-12-31'),
	(36284,'20','106',' 00','092022',92022,'Furtei','Furtei','','VS',1,'1840-01-01','2999-12-31'),
	(36285,'20','106',' 00','092025',92025,'Gesturi','Gesturi','','VS',1,'1840-01-01','2999-12-31'),
	(36286,'20','107',' 00','092026',92026,'Giba','Giba','','CI',1,'1840-01-01','2999-12-31'),
	(36287,'20','107',' 00','092028',92028,'Gonnesa','Gonnesa','','CI',1,'1840-01-01','2999-12-31'),
	(36288,'20','106',' 00','092029',92029,'Gonnosfanadiga','Gonnosfanadiga','','VS',1,'1840-01-01','2999-12-31'),
	(36289,'20','106',' 00','092032',92032,'Guspini','Guspini','','VS',1,'1840-01-01','2999-12-31'),
	(36290,'20','107',' 00','092033',92033,'Iglesias','Iglesias','','CI',1,'1840-01-01','2999-12-31'),
	(36291,'20','106',' 01','092035',92035,'Lunamatrona','Lunamatrona','','VS',1,'1840-01-01','2999-12-31'),
	(36292,'20','107',' 01','092040',92040,'Musei','Musei','','CI',1,'1840-01-01','2999-12-31'),
	(36293,'20','107',' 01','092041',92041,'Narcao','Narcao','','CI',1,'1840-01-01','2999-12-31'),
	(36294,'20','106',' 01','092045',92045,'Pabillonis','Pabillonis','','VS',1,'1840-01-01','2999-12-31'),
	(36295,'20','107',' 01','092049',92049,'Portoscuso','Portoscuso','','CI',1,'1840-01-01','2999-12-31'),
	(36296,'20','106',' 01','092055',92055,'San Gavino Monreale','San Gavino Monreale','','VS',1,'1840-01-01','2999-12-31'),
	(36297,'20','107',' 01','092056',92056,'San Giovanni Suergiu','San Giovanni Suergiu','','CI',1,'1840-01-01','2999-12-31'),
	(36298,'20','106',' 01','092057',92057,'Sanluri','Sanluri','','VS',1,'1840-01-01','2999-12-31'),
	(36299,'20','107',' 01','092060',92060,'Santadi','Santadi','','CI',1,'1840-01-01','2999-12-31'),
	(36300,'20','107',' 02','092063',92063,'Sant\'Antioco','Sant\'Antioco','','CI',1,'1840-01-01','2999-12-31'),
	(36301,'20','106',' 01','092065',92065,'Sardara','Sardara','','VS',1,'1840-01-01','2999-12-31'),
	(36302,'20','106',' 01','092067',92067,'Segariu','Segariu','','VS',1,'1840-01-01','2999-12-31'),
	(36303,'20','106',' 01','092072',92072,'Serramanna','Serramanna','','VS',1,'1840-01-01','2999-12-31'),
	(36304,'20','106',' 01','092073',92073,'Serrenti','Serrenti','','VS',1,'1840-01-01','2999-12-31'),
	(36305,'20','106',' 02','092076',92076,'Setzu','Setzu','','VS',1,'1840-01-01','2999-12-31'),
	(36306,'20','106',' 02','092092',92092,'Villacidro','Villacidro','','VS',1,'1840-01-01','2999-12-31'),
	(36307,'20','106',' 02','092093',92093,'Villamar','Villamar','','VS',1,'1840-01-01','2999-12-31'),
	(36308,'20','106',' 02','092095',92095,'Villanovaforru','Villanovaforru','','VS',1,'1840-01-01','2999-12-31'),
	(36309,'20','106',' 02','092096',92096,'Villanovafranca','Villanovafranca','','VS',1,'1840-01-01','2999-12-31'),
	(36310,'20','095',' 06','092142',92142,'Terralba','Terralba','','OR',1,'1840-01-01','2999-12-31'),
	(36311,'20','107',' 00','092807',92807,'Serbariu','Serbariu','','CI',1,'1840-01-01','2999-12-31'),
	(36312,'20','092',' 00','092805',92805,'Pirri','Pirri','','CA',1,'1840-01-01','2999-12-31'),
	(36313,'00','000','000','000000',0,'LOCALITA SCONOSCIUTA/Standort unbekannt','LOCALITA SCONOSCIUTA','Standort unbekannt','',1,'1840-01-01','2999-12-31'),
	(36314,'60','030','115','030115',30115,'TAPOGLIANO','TAPOGLIANO','TAPOGLIANO','UD',1,'1840-01-01','2999-12-31'),
	(36315,'60','030','017','030017',30017,'CAMPOLONGO AL TORRE','CAMPOLONGO AL TORRE','CAMPOLONGO AL TORRE','UD',1,'1840-01-01','2999-12-31'),
	(36316,'50','024','109','024109',24109,'TRETTO','TRETTO','TRETTO','VI',1,'1840-01-01','2999-12-31'),
	(36317,'50','029','016','029016',29016,'CONTARINA','CONTARINA','CONTARINA','RO',1,'1840-01-01','2999-12-31'),
	(36318,'50','029','020','029020',29020,'DONADA','DONADA','DONADA','RO',1,'1840-01-01','2999-12-31'),
	(36319,'30','015','119','015119',15119,'LENTATE SUL SEVESO','LENTATE SUL SEVESO','LENTATE SUL SEVESO','MI',1,'1840-01-01','2999-12-31'),
	(36320,'30','015','088','015088',15088,'CORNATE D\'ADDA','CORNATE D\'ADDA','CORNATE D\'ADDA','MI',1,'1840-01-01','2999-12-31'),
	(36321,'30','015','039','015039',15039,'BUSNAGO','BUSNAGO','BUSNAGO','MI',1,'1840-01-01','2999-12-31'),
	(36322,'30','015','047','015047',15047,'CAPONAGO','CAPONAGO','CAPONAGO','MI',1,'1840-01-01','2999-12-31'),
	(36323,'42','022','141','022141',22141,'PIEVE DI LEDRO','PIEVE DI LEDRO','PIEVE DI LEDRO','TN',1,'1840-01-01','2999-12-31'),
	(36324,'42','022','197','022197',22197,'TIARNO DI SOPRA','TIARNO DI SOPRA','TIARNO DI SOPRA','TN',1,'1840-01-01','2999-12-31'),
	(36325,'42','022','198','022198',22198,'TIARNO DI SOTTO','TIARNO DI SOTTO','TIARNO DI SOTTO','TN',1,'1840-01-01','2999-12-31'),
	(36326,'42','022','065','022065',22065,'CONCEI','CONCEI','CONCEI','TN',1,'1840-01-01','2999-12-31'),
	(36327,'42','022','107','022107',22107,'LOMASO','LOMASO','LOMASO','TN',1,'1840-01-01','2999-12-31'),
	(36328,'42','022','119','022119',22119,'MOLINA DI LEDRO','MOLINA DI LEDRO','MOLINA DI LEDRO','TN',1,'1840-01-01','2999-12-31'),
	(36329,'42','022','014','022014',22014,'BEZZECCA','BEZZECCA','BEZZECCA','TN',1,'1840-01-01','2999-12-31'),
	(36330,'42','022','016','022016',22016,'BLEGGIO INFERIORE','BLEGGIO INFERIORE','BLEGGIO INFERIORE','TN',1,'1840-01-01','2999-12-31'),
	(36331,'41','021','078','021078',21078,'SAN FELICE - ST. FELIX','SAN FELICE - ST. FELIX','SAN FELICE - ST. FELIX','BZ',1,'1840-01-01','2999-12-31'),
	(36332,'41','021','090','021090',21090,'SENALE - U.L. FRAU IM WALDE','SENALE - U.L. FRAU IM WALDE','SENALE - U.L. FRAU IM WALDE','BZ',1,'1840-01-01','2999-12-31'),
	(36333,'30','015','186','015186',15186,'RONCELLO','RONCELLO','RONCELLO','MI',1,'1840-01-01','2999-12-31'),
	(36334,'10','005','102','005102',5102,'SCANDELUZZA','SCANDELUZZA','SCANDELUZZA','AT',1,'1840-01-01','2999-12-31'),
	(36335,'10','005','043','005043',5043,'COLCAVAGNO','COLCAVAGNO','COLCAVAGNO','AT',1,'1840-01-01','2999-12-31'),
	(36336,'10','005','078','005078',5078,'MONTIGLIO','MONTIGLIO','MONTIGLIO','AT',1,'1840-01-01','2999-12-31'),
	(36337,'99','603','000','999603',999603,'ARUBA-ANTILLE OLANDESI','ARUBA-ANTILLE OLANDESI','ARUBA-ANTILLE OLANDESI','AW',1,'1840-01-01','2999-12-31'),
	(36338,'50','028','025','028025',28025,'CARRARA SANTO STEFANO','CARRARA SANTO STEFANO','CARRARA SANTO STEFANO','PD',1,'1840-01-01','2999-12-31'),
	(36339,'12','058','121','058121',58121,'BOVILLE','BOVILLE','BOVILLE','RM',1,'1840-01-01','2999-12-31'),
	(36340,'99','999','888','999888',999888,'COMUNE SCONOSCIUTO','COMUNE SCONOSCIUTO','COMUNE SCONOSCIUTO','',1,'1840-01-01','2999-12-31'),
	(36341,'50','028','024','028024',28024,'CARRARA SAN GIORGIO','CARRARA SAN GIORGIO','CARRARA SAN GIORGIO','PD',1,'1840-01-01','2999-12-31'),
	(36342,'99','999','998','999998',999998,'IRREPERIBILE','IRREPERIBILE','IRREPERIBILE','',1,'1840-01-01','2999-12-31'),
	(36343,'99','999','997','999997',999997,'ISCRITTO ALL\'AIRE','ISCRITTO ALL\'AIRE','ISCRITTO ALL\'AIRE','',1,'1840-01-01','2999-12-31'),
	(36344,'30','013','846','013846',13846,'CASSANO ALBESE','CASSANO ALBESE','CASSANO ALBESE','CO',1,'1840-01-01','2999-12-31'),
	(36345,'41','021','909','021909',21909,'TUNES - THUINS','TUNES - THUINS','TUNES - THUINS','BZ',1,'1840-01-01','2999-12-31'),
	(36346,'41','021','912','021912',21912,'VALLARGA - WEITENTAL','VALLARGA - WEITENTAL','VALLARGA - WEITENTAL','BZ',1,'1840-01-01','2999-12-31'),
	(36347,'41','021','918','021918',21918,'VANGA - WANGEN','VANGA - WANGEN','VANGA - WANGEN','BZ',1,'1840-01-01','2999-12-31'),
	(36348,'30','013','953','013953',13953,'VERDERIO','VERDERIO','VERDERIO','CO',1,'1840-01-01','2999-12-31'),
	(36349,'30','013','958','013958',13958,'VILLA VERGANO','VILLA VERGANO','VILLA VERGANO','CO',1,'1840-01-01','2999-12-31'),
	(36350,'10','004','823','004823',4823,'VILLANOVETTA','VILLANOVETTA','VILLANOVETTA','CN',1,'1840-01-01','2999-12-31'),
	(36351,'41','021','923','021923',21923,'VIZZE - PFITSCH','VIZZE - PFITSCH','VIZZE - PFITSCH','BZ',1,'1840-01-01','2999-12-31'),
	(36352,'30','013','806','013806',13806,'ALBOGASIO','ALBOGASIO','ALBOGASIO','CO',1,'1840-01-01','2999-12-31'),
	(36353,'30','017','802','017802',17802,'ALONE','ALONE','ALONE','BS',1,'1840-01-01','2999-12-31'),
	(36354,'90','045','802','045802',45802,'APUANIA','APUANIA','APUANIA','MS',1,'1840-01-01','2999-12-31'),
	(36355,'30','012','806','012806',12806,'ARMIO','ARMIO','ARMIO','VA',1,'1840-01-01','2999-12-31'),
	(36356,'20','090','801','090801',90801,'BANTINE','BANTINE','BANTINE','SS',1,'1840-01-01','2999-12-31'),
	(36357,'30','018','802','018802',18802,'BASELICA BOLOGNA','BASELICA BOLOGNA','BASELICA BOLOGNA','PV',1,'1840-01-01','2999-12-31'),
	(36358,'30','013','815','013815',13815,'BELLEDO','BELLEDO','BELLEDO','CO',1,'1840-01-01','2999-12-31'),
	(36359,'30','015','813','015813',15813,'BIRAGO','BIRAGO','BIRAGO','MI',1,'1840-01-01','2999-12-31'),
	(36360,'30','015','815','015815',15815,'BOLDINASCO','BOLDINASCO','BOLDINASCO','MI',1,'1840-01-01','2999-12-31'),
	(36361,'10','002','804','002804',2804,'BORNATE','BORNATE','BORNATE','VC',1,'1840-01-01','2999-12-31'),
	(36362,'10','003','820','003820',3820,'BRISINO','BRISINO','BRISINO','NO',1,'1840-01-01','2999-12-31'),
	(36363,'30','013','826','013826',13826,'BUGIALLO','BUGIALLO','BUGIALLO','CO',1,'1840-01-01','2999-12-31'),
	(36364,'30','018','808','018808',18808,'CA\' DE\' TEDIOLI','CA\' DE\' TEDIOLI','CA\' DE\' TEDIOLI','PV',1,'1840-01-01','2999-12-31'),
	(36365,'70','009','807','009807',9807,'CALVISIO','CALVISIO','CALVISIO','SV',1,'1840-01-01','2999-12-31'),
	(36366,'70','010','806','010806',10806,'CANEPA','CANEPA','CANEPA','GE',1,'1840-01-01','2999-12-31'),
	(36367,'30','015','830','015830',15830,'CAPRIANO DI BRIANZA','CAPRIANO DI BRIANZA','CAPRIANO DI BRIANZA','MI',1,'1840-01-01','2999-12-31'),
	(36368,'30','013','839','013839',13839,'CARUGO AROSIO','CARUGO AROSIO','CARUGO AROSIO','CO',1,'1840-01-01','2999-12-31'),
	(36369,'10','003','853','003853',3853,'FOMARCO','FOMARCO','FOMARCO','NO',1,'1840-01-01','2999-12-31'),
	(36370,'30','017','846','017846',17846,'GOGLIONE SOTTO','GOGLIONE SOTTO','GOGLIONE SOTTO','BS',1,'1840-01-01','2999-12-31'),
	(36371,'90','052','803','052803',52803,'MASSE DI SIENA','MASSE DI SIENA','MASSE DI SIENA','SI',1,'1840-01-01','2999-12-31'),
	(36372,'30','018','845','018845',18845,'MISANO OLONA','MISANO OLONA','MISANO OLONA','PV',1,'1840-01-01','2999-12-31'),
	(36373,'11','042','801','042801',42801,'MONTESICURO','MONTESICURO','MONTESICURO','AN',1,'1840-01-01','2999-12-31'),
	(36374,'10','006','817','006817',6817,'PAVONE D\'ALESSANDRIA','PAVONE D\'ALESSANDRIA','PAVONE D\'ALESSANDRIA','AL',1,'1840-01-01','2999-12-31'),
	(36375,'41','021','869','021869',21869,'QUARAZZE - GRATSCH','QUARAZZE - GRATSCH','QUARAZZE - GRATSCH','BZ',1,'1840-01-01','2999-12-31'),
	(36376,'30','013','925','013925',13925,'REBBIO','REBBIO','REBBIO','CO',1,'1840-01-01','2999-12-31'),
	(36377,'30','016','858','016858',16858,'ROTA FUORI','ROTA FUORI','ROTA FUORI','BG',1,'1840-01-01','2999-12-31'),
	(36378,'60','031','807','031807',31807,'SALCANO','SALCANO','SALCANO','GO',1,'1840-01-01','2999-12-31'),
	(36379,'70','008','832','008832',8832,'SAN LAZZARO REALE','SAN LAZZARO REALE','SAN LAZZARO REALE','IM',1,'1840-01-01','2999-12-31'),
	(36380,'11','044','819','044819',44819,'SANTA MARIA DEL TRONTO','SANTA MARIA DEL TRONTO','SANTA MARIA DEL TRONTO','AP',1,'1840-01-01','2999-12-31'),
	(36381,'20','092','808','092808',92808,'SEUNI','SEUNI','SEUNI','CA',1,'1840-01-01','2999-12-31'),
	(36382,'41','021','901','021901',21901,'TANAS - TANNAS','TANAS - TANNAS','TANAS - TANNAS','BZ',1,'1840-01-01','2999-12-31'),
	(36383,'11','044','820','044820',44820,'TORRE DI PALME','TORRE DI PALME','TORRE DI PALME','AP',1,'1840-01-01','2999-12-31'),
	(36384,'70','009','831','009831',9831,'VERZI PIETRA','VERZI PIETRA','VERZI PIETRA','SV',1,'1840-01-01','2999-12-31'),
	(36385,'15','061','809','061809',61809,'VILLA VOLTURNO','VILLA VOLTURNO','VILLA VOLTURNO','CE',1,'1840-01-01','2999-12-31'),
	(36386,'15','062','801','062801',62801,'BAGNARA DI BENEVENTO','BAGNARA DI BENEVENTO','BAGNARA DI BENEVENTO','BN',1,'1840-01-01','2999-12-31'),
	(36387,'12','057','801','057801',57801,'BOCCHIGNANO','BOCCHIGNANO','BOCCHIGNANO','RI',1,'1840-01-01','2999-12-31'),
	(36388,'30','019','816','019816',19816,'CA\' DE\' QUINZANI','CA\' DE\' QUINZANI','CA\' DE\' QUINZANI','CR',1,'1840-01-01','2999-12-31'),
	(36389,'30','012','828','012828',12828,'CAPRONNO','CAPRONNO','CAPRONNO','VA',1,'1840-01-01','2999-12-31'),
	(36390,'30','015','851','015851',15851,'CERCHIATE','CERCHIATE','CERCHIATE','MI',1,'1840-01-01','2999-12-31'),
	(36391,'30','015','867','015867',15867,'COSTA AL LAMBRO','COSTA AL LAMBRO','COSTA AL LAMBRO','MI',1,'1840-01-01','2999-12-31'),
	(36392,'50','023','814','023814',23814,'PRUN','PRUN','PRUN','VR',1,'1840-01-01','2999-12-31'),
	(36393,'30','016','835','016835',16835,'GRUMELLO DEL PIANO','GRUMELLO DEL PIANO','GRUMELLO DEL PIANO','BG',1,'1840-01-01','2999-12-31'),
	(36394,'30','017','848','017848',17848,'INZINO','INZINO','INZINO','BS',1,'1840-01-01','2999-12-31'),
	(36395,'30','019','861','019861',19861,'ISOLA PESCAROLI','ISOLA PESCAROLI','ISOLA PESCAROLI','CR',1,'1840-01-01','2999-12-31'),
	(36396,'15','063','803','063803',63803,'LICIGNANO DI NAPOLI','LICIGNANO DI NAPOLI','LICIGNANO DI NAPOLI','NA',1,'1840-01-01','2999-12-31'),
	(36397,'30','017','851','017851',17851,'LOVENO GRUMELLO','LOVENO GRUMELLO','LOVENO GRUMELLO','BS',1,'1840-01-01','2999-12-31'),
	(36398,'30','017','855','017855',17855,'LUMEZZANE SANT\'APOLLONIO','LUMEZZANE SANT\'APOLLONIO','LUMEZZANE SANT\'APOLLONIO','BS',1,'1840-01-01','2999-12-31'),
	(36399,'70','010','809','010809',10809,'MARASSI','MARASSI','MARASSI','GE',1,'1840-01-01','2999-12-31'),
	(36400,'30','016','840','016840',16840,'MASSARI MELZI','MASSARI MELZI','MASSARI MELZI','BG',1,'1840-01-01','2999-12-31'),
	(36401,'30','015','895','015895',15895,'MELEGNANELLO','MELEGNANELLO','MELEGNANELLO','MI',1,'1840-01-01','2999-12-31'),
	(36402,'30','015','900','015900',15900,'MIGNETE','MIGNETE','MIGNETE','MI',1,'1840-01-01','2999-12-31'),
	(36403,'10','006','813','006813',6813,'MOLINO ALZANO','MOLINO ALZANO','MOLINO ALZANO','AL',1,'1840-01-01','2999-12-31'),
	(36404,'11','044','806','044806',44806,'MONTADAMO','MONTADAMO','MONTADAMO','AP',1,'1840-01-01','2999-12-31'),
	(36405,'10','003','866','003866',3866,'MONTE OSSOLANO','MONTE OSSOLANO','MONTE OSSOLANO','NO',1,'1840-01-01','2999-12-31'),
	(36406,'30','012','866','012866',12866,'MONTEGRINO','MONTEGRINO','MONTEGRINO','VA',1,'1840-01-01','2999-12-31'),
	(36407,'11','041','815','041815',41815,'MONTEVECCHIO','MONTEVECCHIO','MONTEVECCHIO','PS',1,'1840-01-01','2999-12-31'),
	(36408,'30','013','906','013906',13906,'NAVA','NAVA','NAVA','CO',1,'1840-01-01','2999-12-31'),
	(36409,'10','001','845','001845',1845,'NOVAREGLIA','NOVAREGLIA','NOVAREGLIA','TO',1,'1840-01-01','2999-12-31'),
	(36410,'30','016','844','016844',16844,'OLTREPOVO','OLTREPOVO','OLTREPOVO','BG',1,'1840-01-01','2999-12-31'),
	(36411,'30','013','912','013912',13912,'PAGNANO VALSASSINA','PAGNANO VALSASSINA','PAGNANO VALSASSINA','CO',1,'1840-01-01','2999-12-31'),
	(36412,'15','062','805','062805',62805,'PASTENE','PASTENE','PASTENE','BN',1,'1840-01-01','2999-12-31'),
	(36413,'70','008','828','008828',8828,'PIANAVIA','PIANAVIA','PIANAVIA','IM',1,'1840-01-01','2999-12-31'),
	(36414,'18','079','802','079802',79802,'PISCOPIO','PISCOPIO','PISCOPIO','CZ',1,'1840-01-01','2999-12-31'),
	(36415,'70','010','814','010814',10814,'PONTEDECIMO','PONTEDECIMO','PONTEDECIMO','GE',1,'1840-01-01','2999-12-31'),
	(36416,'10','055','812','055812',55812,'PORTARIA','PORTARIA','PORTARIA','TR',1,'1840-01-01','2999-12-31'),
	(36417,'41','021','868','021868',21868,'PRATO DI VENOSTA - PRAD','PRATO DI VENOSTA - PRAD','PRATO DI VENOSTA - PRAD','BZ',1,'1840-01-01','2999-12-31'),
	(36418,'30','015','834','015834',15834,'CASONE','CASONE','CASONE','MI',1,'1840-01-01','2999-12-31'),
	(36419,'15','063','801','063801',63801,'BARRA','BARRA','BARRA','NA',1,'1840-01-01','2999-12-31'),
	(36420,'30','012','811','012811',12811,'BARZOLA','BARZOLA','BARZOLA','VA',1,'1840-01-01','2999-12-31'),
	(36421,'70','010','802','010802',10802,'BAVARI','BAVARI','BAVARI','GE',1,'1840-01-01','2999-12-31'),
	(36422,'30','012','816','012816',12816,'BOGNO','BOGNO','BOGNO','VA',1,'1840-01-01','2999-12-31'),
	(36423,'10','003','818','003818',3818,'BOLETO','BOLETO','BOLETO','NO',1,'1840-01-01','2999-12-31'),
	(36424,'30','016','806','016806',16806,'BONDIONE','BONDIONE','BONDIONE','BG',1,'1840-01-01','2999-12-31'),
	(36425,'30','016','808','016808',16808,'BORDOGNA','BORDOGNA','BORDOGNA','BG',1,'1840-01-01','2999-12-31'),
	(36426,'80','037','801','037801',37801,'BORGO PANIGALE','BORGO PANIGALE','BORGO PANIGALE','BO',1,'1840-01-01','2999-12-31'),
	(36427,'30','015','818','015818',15818,'BORNAGO','BORNAGO','BORNAGO','MI',1,'1840-01-01','2999-12-31'),
	(36428,'70','008','805','008805',8805,'BOSCOMARE','BOSCOMARE','BOSCOMARE','IM',1,'1840-01-01','2999-12-31'),
	(36429,'50','029','804','029804',29804,'BOTTRIGHE','BOTTRIGHE','BOTTRIGHE','RO',1,'1840-01-01','2999-12-31'),
	(36430,'42','022','812','022812',22812,'BOZZANA','BOZZANA','BOZZANA','TN',1,'1840-01-01','2999-12-31'),
	(36431,'60','031','801','031801',31801,'BRAZZANO','BRAZZANO','BRAZZANO','GO',1,'1840-01-01','2999-12-31'),
	(36432,'30','019','812','019812',19812,'BROLPASINO','BROLPASINO','BROLPASINO','CR',1,'1840-01-01','2999-12-31'),
	(36433,'50','029','806','029806',29806,'CA\' EMO','CA\' EMO','CA\' EMO','RO',1,'1840-01-01','2999-12-31'),
	(36434,'42','022','813','022813',22813,'CADINE','CADINE','CADINE','TN',1,'1840-01-01','2999-12-31'),
	(36435,'30','013','811','013811',13811,'BALLABIO INFERIORE','BALLABIO INFERIORE','BALLABIO INFERIORE','CO',1,'1840-01-01','2999-12-31'),
	(36436,'30','015','807','015807',15807,'BARATE','BARATE','BARATE','MI',1,'1840-01-01','2999-12-31'),
	(36437,'19','083','802','083802',83802,'CALVARUSO','CALVARUSO','CALVARUSO','ME',1,'1840-01-01','2999-12-31'),
	(36438,'30','018','814','018814',18814,'CAMPORINALDO','CAMPORINALDO','CAMPORINALDO','PV',1,'1840-01-01','2999-12-31'),
	(36439,'30','019','824','019824',19824,'CARPANETA CON DOSIMO','CARPANETA CON DOSIMO','CARPANETA CON DOSIMO','CR',1,'1840-01-01','2999-12-31'),
	(36440,'30','013','840','013840',13840,'CASANOVA LANZA','CASANOVA LANZA','CASANOVA LANZA','CO',1,'1840-01-01','2999-12-31'),
	(36441,'30','012','832','012832',12832,'CASSINA PERTUSELLA','CASSINA PERTUSELLA','CASSINA PERTUSELLA','VA',1,'1840-01-01','2999-12-31'),
	(36442,'10','055','803','055803',55803,'CASTEL DI LAGO','CASTEL DI LAGO','CASTEL DI LAGO','TR',1,'1840-01-01','2999-12-31'),
	(36443,'30','015','844','015844',15844,'CASTELLAZZO DE\' BARZI','CASTELLAZZO DE\' BARZI','CASTELLAZZO DE\' BARZI','MI',1,'1840-01-01','2999-12-31'),
	(36444,'30','019','835','019835',19835,'CASTELNUOVO GHERARDI','CASTELNUOVO GHERARDI','CASTELNUOVO GHERARDI','CR',1,'1840-01-01','2999-12-31'),
	(36445,'10','003','834','003834',3834,'CAVANDONE','CAVANDONE','CAVANDONE','NO',1,'1840-01-01','2999-12-31'),
	(36446,'30','013','853','013853',13853,'CEREDA','CEREDA','CEREDA','CO',1,'1840-01-01','2999-12-31'),
	(36447,'15','064','802','064802',64802,'CHIANCHETELLE','CHIANCHETELLE','CHIANCHETELLE','AV',1,'1840-01-01','2999-12-31'),
	(36448,'42','022','823','022823',22823,'CHIZZOLA','CHIZZOLA','CHIZZOLA','TN',1,'1840-01-01','2999-12-31'),
	(36449,'30','012','841','012841',12841,'COCQUIO','COCQUIO','COCQUIO','VA',1,'1840-01-01','2999-12-31'),
	(36450,'42','022','830','022830',22830,'COMASINE','COMASINE','COMASINE','TN',1,'1840-01-01','2999-12-31'),
	(36451,'30','018','830','018830',18830,'CORBESATE','CORBESATE','CORBESATE','PV',1,'1840-01-01','2999-12-31'),
	(36452,'41','021','819','021819',21819,'CORTI IN PUSTERIA - HOFERN','CORTI IN PUSTERIA - HOFERN','CORTI IN PUSTERIA - HOFERN','BZ',1,'1840-01-01','2999-12-31'),
	(36453,'30','012','846','012846',12846,'CUVEGLIO IN VALLE','CUVEGLIO IN VALLE','CUVEGLIO IN VALLE','VA',1,'1840-01-01','2999-12-31'),
	(36454,'42','022','836','022836',22836,'DEGGIANO','DEGGIANO','DEGGIANO','TN',1,'1840-01-01','2999-12-31'),
	(36455,'20','095','802','095802',95802,'DONIGALA FENUGHEDU','DONIGALA FENUGHEDU','DONIGALA FENUGHEDU','OR',1,'1840-01-01','2999-12-31'),
	(36456,'50','027','803','027803',27803,'FAVARO VENETO','FAVARO VENETO','FAVARO VENETO','VE',1,'1840-01-01','2999-12-31'),
	(36457,'10','003','851','003851',3851,'FINERO','FINERO','FINERO','NO',1,'1840-01-01','2999-12-31'),
	(36458,'10','002','817','002817',2817,'FORESTO SESIA','FORESTO SESIA','FORESTO SESIA','VC',1,'1840-01-01','2999-12-31'),
	(36459,'30','019','856','019856',19856,'GADESCO','GADESCO','GADESCO','CR',1,'1840-01-01','2999-12-31'),
	(36460,'70','008','817','008817',8817,'GAZZELLI','GAZZELLI','GAZZELLI','IM',1,'1840-01-01','2999-12-31'),
	(36461,'30','015','879','015879',15879,'GRAZZANELLO','GRAZZANELLO','GRAZZANELLO','MI',1,'1840-01-01','2999-12-31'),
	(36462,'30','019','830','019830',19830,'CASSINE GANDINE','CASSINE GANDINE','CASSINE GANDINE','CR',1,'1840-01-01','2999-12-31'),
	(36463,'10','001','814','001814',1814,'CAMPO CANAVESE','CAMPO CANAVESE','CAMPO CANAVESE','TO',1,'1840-01-01','2999-12-31'),
	(36464,'30','015','829','015829',15829,'CAMPOLUNGO','CAMPOLUNGO','CAMPOLUNGO','MI',1,'1840-01-01','2999-12-31'),
	(36465,'30','018','815','018815',18815,'CAMPOSPINOSO ALBAREDO','CAMPOSPINOSO ALBAREDO','CAMPOSPINOSO ALBAREDO','PV',1,'1840-01-01','2999-12-31'),
	(36466,'16','072','801','072801',72801,'CANNETO DI BARI','CANNETO DI BARI','CANNETO DI BARI','BA',1,'1840-01-01','2999-12-31'),
	(36467,'30','019','821','019821',19821,'CANOVA DEL MORBASCO','CANOVA DEL MORBASCO','CANOVA DEL MORBASCO','CR',1,'1840-01-01','2999-12-31'),
	(36468,'30','013','832','013832',13832,'CAPIAGO','CAPIAGO','CAPIAGO','CO',1,'1840-01-01','2999-12-31'),
	(36469,'10','055','801','055801',55801,'CAPITONE','CAPITONE','CAPITONE','TR',1,'1840-01-01','2999-12-31'),
	(36470,'30','012','827','012827',12827,'CAPOLAGO','CAPOLAGO','CAPOLAGO','VA',1,'1840-01-01','2999-12-31'),
	(36471,'60','031','705','031705',31705,'CAPORETTO','CAPORETTO','CAPORETTO','GO',1,'1840-01-01','2999-12-31'),
	(36472,'30','013','834','013834',13834,'CARATE LARIO','CARATE LARIO','CARATE LARIO','CO',1,'1840-01-01','2999-12-31'),
	(36473,'16','072','802','072802',72802,'CARBONARA DI BARI','CARBONARA DI BARI','CARBONARA DI BARI','BA',1,'1840-01-01','2999-12-31'),
	(36474,'10','055','802','055802',55802,'CARNAIOLA','CARNAIOLA','CARNAIOLA','TR',1,'1840-01-01','2999-12-31'),
	(36475,'30','012','830','012830',12830,'CARONNO CORBELLARO','CARONNO CORBELLARO','CARONNO CORBELLARO','VA',1,'1840-01-01','2999-12-31'),
	(36476,'70','009','809','009809',9809,'CARPE','CARPE','CARPE','SV',1,'1840-01-01','2999-12-31'),
	(36477,'10','003','830','003830',3830,'CARPUGNINO','CARPUGNINO','CARPUGNINO','NO',1,'1840-01-01','2999-12-31'),
	(36478,'70','008','809','008809',8809,'CARTARI E CALDERARA','CARTARI E CALDERARA','CARTARI E CALDERARA','IM',1,'1840-01-01','2999-12-31'),
	(36479,'15','061','804','061804',61804,'CASALBA','CASALBA','CASALBA','CE',1,'1840-01-01','2999-12-31'),
	(36480,'30','019','828','019828',19828,'CASALSIGONE','CASALSIGONE','CASALSIGONE','CR',1,'1840-01-01','2999-12-31'),
	(36481,'30','015','831','015831',15831,'CASELLE D\'OZERO','CASELLE D\'OZERO','CASELLE D\'OZERO','MI',1,'1840-01-01','2999-12-31'),
	(36482,'42','022','044','022044',22044,'CASEZ','CASEZ','CASEZ','TN',1,'1840-01-01','2999-12-31'),
	(36483,'30','013','843','013843',13843,'CASLINO AL PIANO','CASLINO AL PIANO','CASLINO AL PIANO','CO',1,'1840-01-01','2999-12-31'),
	(36484,'30','015','833','015833',15833,'CASOLATE','CASOLATE','CASOLATE','MI',1,'1840-01-01','2999-12-31'),
	(36485,'30','013','845','013845',13845,'CASSAGO','CASSAGO','CASSAGO','CO',1,'1840-01-01','2999-12-31'),
	(36486,'30','012','831','012831',12831,'CASSINA FERRARA','CASSINA FERRARA','CASSINA FERRARA','VA',1,'1840-01-01','2999-12-31'),
	(36487,'30','015','839','015839',15839,'CASSINA NUOVA','CASSINA NUOVA','CASSINA NUOVA','MI',1,'1840-01-01','2999-12-31'),
	(36488,'10','004','818','004818',4818,'SCALETTA UZZONE','SCALETTA UZZONE','SCALETTA UZZONE','CN',1,'1840-01-01','2999-12-31'),
	(36489,'30','015','941','015941',15941,'RUGINELLO','RUGINELLO','RUGINELLO','MI',1,'1840-01-01','2999-12-31'),
	(36490,'10','001','859','001859',1859,'SALTO','SALTO','SALTO','TO',1,'1840-01-01','2999-12-31'),
	(36491,'18','080','816','080816',80816,'SAMBATELLO','SAMBATELLO','SAMBATELLO','RC',1,'1840-01-01','2999-12-31'),
	(36492,'10','004','815','004815',4815,'SAMBUCO-PIETRAPORZIO','SAMBUCO-PIETRAPORZIO','SAMBUCO-PIETRAPORZIO','CN',1,'1840-01-01','2999-12-31'),
	(36493,'15','064','805','064805',64805,'SAN BARBATO','SAN BARBATO','SAN BARBATO','AV',1,'1840-01-01','2999-12-31'),
	(36494,'41','021','880','021880',21880,'SAN FELICE - ST. FELIX','SAN FELICE - ST. FELIX','SAN FELICE - ST. FELIX','BZ',1,'1840-01-01','2999-12-31'),
	(36495,'60','032','709','032709',32709,'SAN GIACOMO IN COLLE','SAN GIACOMO IN COLLE','SAN GIACOMO IN COLLE','TS',1,'1840-01-01','2999-12-31'),
	(36496,'15','063','807','063807',63807,'SAN GIOVANNI A TEDUCCIO','SAN GIOVANNI A TEDUCCIO','SAN GIOVANNI A TEDUCCIO','NA',1,'1840-01-01','2999-12-31'),
	(36497,'10','002','826','002826',2826,'SAN GIUSEPPE DI CASTO','SAN GIUSEPPE DI CASTO','SAN GIUSEPPE DI CASTO','VC',1,'1840-01-01','2999-12-31'),
	(36498,'30','019','903','019903',19903,'SAN MICHELE CREMASCO','SAN MICHELE CREMASCO','SAN MICHELE CREMASCO','CR',1,'1840-01-01','2999-12-31'),
	(36499,'50','023','818','023818',23818,'SAN MICHELE EXTRA','SAN MICHELE EXTRA','SAN MICHELE EXTRA','VR',1,'1840-01-01','2999-12-31'),
	(36500,'30','015','944','015944',15944,'SAN NOVO','SAN NOVO','SAN NOVO','MI',1,'1840-01-01','2999-12-31'),
	(36501,'80','034','809','034809',34809,'SAN PANCRAZIO PARMENSE','SAN PANCRAZIO PARMENSE','SAN PANCRAZIO PARMENSE','PR',1,'1840-01-01','2999-12-31'),
	(36502,'60','032','804','032804',32804,'SAN PELAGIO','SAN PELAGIO','SAN PELAGIO','TS',1,'1840-01-01','2999-12-31'),
	(36503,'70','010','823','010823',10823,'SAN PIER D\'ARENA','SAN PIER D\'ARENA','SAN PIER D\'ARENA','GE',1,'1840-01-01','2999-12-31'),
	(36504,'30','015','946','015946',15946,'SAN PIETRO BESTAZZO','SAN PIETRO BESTAZZO','SAN PIETRO BESTAZZO','MI',1,'1840-01-01','2999-12-31'),
	(36505,'60','032','711','032711',32711,'SAN PIETRO DEL CARSO','SAN PIETRO DEL CARSO','SAN PIETRO DEL CARSO','TS',1,'1840-01-01','2999-12-31'),
	(36506,'30','018','865','018865',18865,'SANT\'ALBANO DI BOBBIO','SANT\'ALBANO DI BOBBIO','SANT\'ALBANO DI BOBBIO','PV',1,'1840-01-01','2999-12-31'),
	(36507,'50','026','806','026806',26806,'SANT\'ANDREA DI CAVASAGRA','SANT\'ANDREA DI CAVASAGRA','SANT\'ANDREA DI CAVASAGRA','TV',1,'1840-01-01','2999-12-31'),
	(36508,'12','057','811','057811',57811,'SANT\'ELIA REATINO','SANT\'ELIA REATINO','SANT\'ELIA REATINO','RI',1,'1840-01-01','2999-12-31'),
	(36509,'30','017','895','017895',17895,'SANT\'EUFEMIA DELLA FONTE','SANT\'EUFEMIA DELLA FONTE','SANT\'EUFEMIA DELLA FONTE','BS',1,'1840-01-01','2999-12-31'),
	(36510,'70','009','826','009826',9826,'SANTA GIULIA','SANTA GIULIA','SANTA GIULIA','SV',1,'1840-01-01','2999-12-31'),
	(36511,'42','022','911','022911',22911,'SASSO','SASSO','SASSO','TN',1,'1840-01-01','2999-12-31'),
	(36512,'30','017','894','017894',17894,'SANT\'ALESSANDRO','SANT\'ALESSANDRO','SANT\'ALESSANDRO','BS',1,'1840-01-01','2999-12-31'),
	(36513,'41','021','878','021878',21878,'RIVA DI TURES - RAIN','RIVA DI TURES - RAIN','RIVA DI TURES - RAIN','BZ',1,'1840-01-01','2999-12-31'),
	(36514,'30','016','181','016181',16181,'RIVIERA D\'ADDA','RIVIERA D\'ADDA','RIVIERA D\'ADDA','BG',1,'1840-01-01','2999-12-31'),
	(36515,'30','015','935','015935',15935,'ROBBIANO','ROBBIANO','ROBBIANO','MI',1,'1840-01-01','2999-12-31'),
	(36516,'10','002','825','002825',2825,'ROCCA PIETRA','ROCCA PIETRA','ROCCA PIETRA','VC',1,'1840-01-01','2999-12-31'),
	(36517,'30','012','881','012881',12881,'ROGGIANO VALTRAVAGLIA','ROGGIANO VALTRAVAGLIA','ROGGIANO VALTRAVAGLIA','VA',1,'1840-01-01','2999-12-31'),
	(36518,'30','019','893','019893',19893,'RONCA DE\' GOLFERAMI','RONCA DE\' GOLFERAMI','RONCA DE\' GOLFERAMI','CR',1,'1840-01-01','2999-12-31'),
	(36519,'30','015','939','015939',15939,'ROSERIO','ROSERIO','ROSERIO','MI',1,'1840-01-01','2999-12-31'),
	(36520,'30','012','882','012882',12882,'ROVATE','ROVATE','ROVATE','VA',1,'1840-01-01','2999-12-31'),
	(36521,'60','031','722','031722',31722,'SAMBASSO','SAMBASSO','SAMBASSO','GO',1,'1840-01-01','2999-12-31'),
	(36522,'42','022','906','022906',22906,'SAMOCLEVO','SAMOCLEVO','SAMOCLEVO','TN',1,'1840-01-01','2999-12-31'),
	(36523,'10','003','882','003882',3882,'SAN BARTOLOMEO VALMARA','SAN BARTOLOMEO VALMARA','SAN BARTOLOMEO VALMARA','NO',1,'1840-01-01','2999-12-31'),
	(36524,'80','034','806','034806',34806,'SAN DONATO D\'ENZA','SAN DONATO D\'ENZA','SAN DONATO D\'ENZA','PR',1,'1840-01-01','2999-12-31'),
	(36525,'30','016','861','016861',16861,'SAN GALLO','SAN GALLO','SAN GALLO','BG',1,'1840-01-01','2999-12-31'),
	(36526,'10','001','860','001860',1860,'SAN GILLIO TORINESE','SAN GILLIO TORINESE','SAN GILLIO TORINESE','TO',1,'1840-01-01','2999-12-31'),
	(36527,'41','021','883','021883',21883,'SAN GIOVANNI - ST. JOHANN IN A','SAN GIOVANNI - ST. JOHANN IN A','SAN GIOVANNI - ST. JOHANN IN A','BZ',1,'1840-01-01','2999-12-31'),
	(36528,'60','031','724','031724',31724,'SAN MARTINO QUISCA','SAN MARTINO QUISCA','SAN MARTINO QUISCA','GO',1,'1840-01-01','2999-12-31'),
	(36529,'10','005','813','005813',5813,'SAN MARZANOTTO','SAN MARZANOTTO','SAN MARZANOTTO','AT',1,'1840-01-01','2999-12-31'),
	(36530,'50','028','801','028801',28801,'SAN MICHELE DELLE BADESSE','SAN MICHELE DELLE BADESSE','SAN MICHELE DELLE BADESSE','PD',1,'1840-01-01','2999-12-31'),
	(36531,'30','017','892','017892',17892,'SAN NAZZARO MELLA','SAN NAZZARO MELLA','SAN NAZZARO MELLA','BS',1,'1840-01-01','2999-12-31'),
	(36532,'10','005','815','005815',5815,'SAN PAOLO DELLA VALLE','SAN PAOLO DELLA VALLE','SAN PAOLO DELLA VALLE','AT',1,'1840-01-01','2999-12-31'),
	(36533,'41','021','890','021890',21890,'SAN VALENTINO AL BRENNERO - B','SAN VALENTINO AL BRENNERO - B','SAN VALENTINO AL BRENNERO - B','BZ',1,'1840-01-01','2999-12-31'),
	(36534,'11','041','818','041818',41818,'SAN VITO SUL CESANO','SAN VITO SUL CESANO','SAN VITO SUL CESANO','PS',1,'1840-01-01','2999-12-31'),
	(36535,'60','030','814','030814',30814,'PONTEBBA NOVA','PONTEBBA NOVA','PONTEBBA NOVA','UD',1,'1840-01-01','2999-12-31'),
	(36536,'30','013','914','013914',13914,'PARRAVICINO','PARRAVICINO','PARRAVICINO','CO',1,'1840-01-01','2999-12-31'),
	(36537,'30','015','917','015917',15917,'PASSIRANA MILANESE','PASSIRANA MILANESE','PASSIRANA MILANESE','MI',1,'1840-01-01','2999-12-31'),
	(36538,'30','015','918','015918',15918,'PASTURAGO','PASTURAGO','PASTURAGO','MI',1,'1840-01-01','2999-12-31'),
	(36539,'11','042','802','042802',42802,'PATERNO D\'ANCONA','PATERNO D\'ANCONA','PATERNO D\'ANCONA','AN',1,'1840-01-01','2999-12-31'),
	(36540,'42','022','882','022882',22882,'PATONE','PATONE','PATONE','TN',1,'1840-01-01','2999-12-31'),
	(36541,'18','080','810','080810',80810,'PEDAVOLI','PEDAVOLI','PEDAVOLI','RC',1,'1840-01-01','2999-12-31'),
	(36542,'70','010','813','010813',10813,'PEGLI','PEGLI','PEGLI','GE',1,'1840-01-01','2999-12-31'),
	(36543,'90','048','804','048804',48804,'PELLEGRINO DA CAREGGI','PELLEGRINO DA CAREGGI','PELLEGRINO DA CAREGGI','FI',1,'1840-01-01','2999-12-31'),
	(36544,'10','004','813','004813',4813,'PERNO','PERNO','PERNO','CN',1,'1840-01-01','2999-12-31'),
	(36545,'30','019','878','019878',19878,'PERSICO','PERSICO','PERSICO','CR',1,'1840-01-01','2999-12-31'),
	(36546,'70','009','821','009821',9821,'PERTI','PERTI','PERTI','SV',1,'1840-01-01','2999-12-31'),
	(36547,'30','013','916','013916',13916,'PESSINA VALSASSINA','PESSINA VALSASSINA','PESSINA VALSASSINA','CO',1,'1840-01-01','2999-12-31'),
	(36548,'30','015','921','015921',15921,'PEZZOLO DI TAVAZZANO','PEZZOLO DI TAVAZZANO','PEZZOLO DI TAVAZZANO','MI',1,'1840-01-01','2999-12-31'),
	(36549,'70','008','829','008829',8829,'PIANI','PIANI','PIANI','IM',1,'1840-01-01','2999-12-31'),
	(36550,'30','013','918','013918',13918,'PIAZZA SANTO STEFANO','PIAZZA SANTO STEFANO','PIAZZA SANTO STEFANO','CO',1,'1840-01-01','2999-12-31'),
	(36551,'30','016','849','016849',16849,'PIAZZO ALTO','PIAZZO ALTO','PIAZZO ALTO','BG',1,'1840-01-01','2999-12-31'),
	(36552,'10','054','807','054807',54807,'PIEDIPATERNO SUL NERA','PIEDIPATERNO SUL NERA','PIEDIPATERNO SUL NERA','PG',1,'1840-01-01','2999-12-31'),
	(36553,'30','018','854','018854',18854,'PIETRA GAVINA','PIETRA GAVINA','PIETRA GAVINA','PV',1,'1840-01-01','2999-12-31'),
	(36554,'42','022','886','022886',22886,'PILCANTE','PILCANTE','PILCANTE','TN',1,'1840-01-01','2999-12-31'),
	(36555,'99','702','728','702728',702728,'PINGUENTE','PINGUENTE','PINGUENTE','PL',1,'1840-01-01','2999-12-31'),
	(36556,'18','080','812','080812',80812,'PODARGONI','PODARGONI','PODARGONI','RC',1,'1840-01-01','2999-12-31'),
	(36557,'70','008','830','008830',8830,'POGGI','POGGI','POGGI','IM',1,'1840-01-01','2999-12-31'),
	(36558,'99','702','731','702731',702731,'POLA','POLA','POLA','PL',1,'1840-01-01','2999-12-31'),
	(36559,'30','019','882','019882',19882,'POLENGO','POLENGO','POLENGO','CR',1,'1840-01-01','2999-12-31'),
	(36560,'30','017','874','017874',17874,'PONCARALE FLERO','PONCARALE FLERO','PONCARALE FLERO','BS',1,'1840-01-01','2999-12-31'),
	(36561,'30','013','922','013922',13922,'RAMPONIO','RAMPONIO','RAMPONIO','CO',1,'1840-01-01','2999-12-31'),
	(36562,'70','009','823','009823',9823,'RANZI PIETRA','RANZI PIETRA','RANZI PIETRA','SV',1,'1840-01-01','2999-12-31'),
	(36563,'30','013','924','013924',13924,'RAVELLINO','RAVELLINO','RAVELLINO','CO',1,'1840-01-01','2999-12-31'),
	(36564,'20','090','803','090803',90803,'REBECCU','REBECCU','REBECCU','SS',1,'1840-01-01','2999-12-31'),
	(36565,'30','016','852','016852',16852,'REDONA','REDONA','REDONA','BG',1,'1840-01-01','2999-12-31'),
	(36566,'30','015','933','015933',15933,'RESCALDA','RESCALDA','RESCALDA','MI',1,'1840-01-01','2999-12-31'),
	(36567,'50','026','803','026803',26803,'REVINE','REVINE','REVINE','TV',1,'1840-01-01','2999-12-31'),
	(36568,'30','013','926','013926',13926,'REZZONICO','REZZONICO','REZZONICO','CO',1,'1840-01-01','2999-12-31'),
	(36569,'10','001','851','001851',1851,'RICLARETTO','RICLARETTO','RICLARETTO','TO',1,'1840-01-01','2999-12-31'),
	(36570,'60','031','720','031720',31720,'RIFEMBERGO','RIFEMBERGO','RIFEMBERGO','GO',1,'1840-01-01','2999-12-31'),
	(36571,'41','021','875','021875',21875,'RINA - WELSCHELLEN','RINA - WELSCHELLEN','RINA - WELSCHELLEN','BZ',1,'1840-01-01','2999-12-31'),
	(36572,'30','015','934','015934',15934,'RIOZZO','RIOZZO','RIOZZO','MI',1,'1840-01-01','2999-12-31'),
	(36573,'30','016','854','016854',16854,'ROCCA DEL COLLE','ROCCA DEL COLLE','ROCCA DEL COLLE','BG',1,'1840-01-01','2999-12-31'),
	(36574,'12','056','804','056804',56804,'ROCCALVECCE','ROCCALVECCE','ROCCALVECCE','VT',1,'1840-01-01','2999-12-31'),
	(36575,'11','044','817','044817',44817,'ROCCAREONILE','ROCCAREONILE','ROCCAREONILE','AP',1,'1840-01-01','2999-12-31'),
	(36576,'70','009','825','009825',9825,'ROCCHETTA CENGIO','ROCCHETTA CENGIO','ROCCHETTA CENGIO','SV',1,'1840-01-01','2999-12-31'),
	(36577,'10','001','854','001854',1854,'ROCHEMOLLES','ROCHEMOLLES','ROCHEMOLLES','TO',1,'1840-01-01','2999-12-31'),
	(36578,'10','001','855','001855',1855,'RODORETTO','RODORETTO','RODORETTO','TO',1,'1840-01-01','2999-12-31'),
	(36579,'30','019','892','019892',19892,'ROMPREZZAGNO','ROMPREZZAGNO','ROMPREZZAGNO','CR',1,'1840-01-01','2999-12-31'),
	(36580,'30','019','894','019894',19894,'RONCADELLO D\'ADDA','RONCADELLO D\'ADDA','RONCADELLO D\'ADDA','CR',1,'1840-01-01','2999-12-31'),
	(36581,'18','080','814','080814',80814,'ROSALI\'','ROSALI\'','ROSALI\'','RC',1,'1840-01-01','2999-12-31'),
	(36582,'10','006','819','006819',6819,'ROSINGO','ROSINGO','ROSINGO','AL',1,'1840-01-01','2999-12-31'),
	(36583,'30','016','857','016857',16857,'ROTA DENTRO','ROTA DENTRO','ROTA DENTRO','BG',1,'1840-01-01','2999-12-31'),
	(36584,'30','015','940','015940',15940,'ROVAGNASCO','ROVAGNASCO','ROVAGNASCO','MI',1,'1840-01-01','2999-12-31'),
	(36585,'30','013','929','013929',13929,'ROVENNA','ROVENNA','ROVENNA','CO',1,'1840-01-01','2999-12-31'),
	(36586,'99','702','733','702733',702733,'ROVIGNO D\'ISTRIA','ROVIGNO D\'ISTRIA','ROVIGNO D\'ISTRIA','PL',1,'1840-01-01','2999-12-31'),
	(36587,'30','017','821','017821',17821,'CARZAGO DELLA RIVIERA','CARZAGO DELLA RIVIERA','CARZAGO DELLA RIVIERA','BS',1,'1840-01-01','2999-12-31'),
	(36588,'30','018','811','018811',18811,'CALIGNANO','CALIGNANO','CALIGNANO','PV',1,'1840-01-01','2999-12-31'),
	(36589,'30','017','817','017817',17817,'CALINO','CALINO','CALINO','BS',1,'1840-01-01','2999-12-31'),
	(36590,'42','022','814','022814',22814,'CELLEDIZZO','CELLEDIZZO','CELLEDIZZO','TN',1,'1840-01-01','2999-12-31'),
	(36591,'30','015','828','015828',15828,'CALO\'','CALO\'','CALO\'','MI',1,'1840-01-01','2999-12-31'),
	(36592,'30','018','812','018812',18812,'CAMBIO\'','CAMBIO\'','CAMBIO\'','PV',1,'1840-01-01','2999-12-31'),
	(36593,'30','017','818','017818',17818,'CAMIGNONE','CAMIGNONE','CAMIGNONE','BS',1,'1840-01-01','2999-12-31'),
	(36594,'30','013','830','013830',13830,'CAMNAGO FALOPPIA','CAMNAGO FALOPPIA','CAMNAGO FALOPPIA','CO',1,'1840-01-01','2999-12-31'),
	(36595,'30','013','831','013831',13831,'CAMNAGO VOLTA','CAMNAGO VOLTA','CAMNAGO VOLTA','CO',1,'1840-01-01','2999-12-31'),
	(36596,'42','022','815','022815',22815,'CAMPO','CAMPO','CAMPO','TN',1,'1840-01-01','2999-12-31'),
	(36597,'70','009','808','009808',9808,'CAMPOCHIESA','CAMPOCHIESA','CAMPOCHIESA','SV',1,'1840-01-01','2999-12-31'),
	(36598,'30','017','819','017819',17819,'CAMPOVERDE','CAMPOVERDE','CAMPOVERDE','BS',1,'1840-01-01','2999-12-31'),
	(36599,'11','041','801','041801',41801,'CANDELARA','CANDELARA','CANDELARA','PS',1,'1840-01-01','2999-12-31'),
	(36600,'18','080','801','080801',80801,'CANNITELLO','CANNITELLO','CANNITELLO','RC',1,'1840-01-01','2999-12-31'),
	(36601,'30','018','816','018816',18816,'CANTONALE','CANTONALE','CANTONALE','PV',1,'1840-01-01','2999-12-31'),
	(36602,'15','065','801','065801',65801,'CAPITELLO','CAPITELLO','CAPITELLO','SA',1,'1840-01-01','2999-12-31'),
	(36603,'30','012','824','012824',12824,'CAIDATE','CAIDATE','CAIDATE','VA',1,'1840-01-01','2999-12-31'),
	(36604,'13','066','803','066803',66803,'CAMARDA','CAMARDA','CAMARDA','AQ',1,'1840-01-01','2999-12-31'),
	(36605,'30','013','829','013829',13829,'CAMERLATA','CAMERLATA','CAMERLATA','CO',1,'1840-01-01','2999-12-31'),
	(36606,'10','001','813','001813',1813,'CAMPIGLIA SOANA','CAMPIGLIA SOANA','CAMPIGLIA SOANA','TO',1,'1840-01-01','2999-12-31'),
	(36607,'30','018','813','018813',18813,'CAMPOMORTO','CAMPOMORTO','CAMPOMORTO','PV',1,'1840-01-01','2999-12-31'),
	(36608,'70','008','807','008807',8807,'CANDEASCO','CANDEASCO','CANDEASCO','IM',1,'1840-01-01','2999-12-31'),
	(36609,'42','022','816','022816',22816,'CANEZZA','CANEZZA','CANEZZA','TN',1,'1840-01-01','2999-12-31'),
	(36610,'30','019','823','019823',19823,'CANSERO','CANSERO','CANSERO','CR',1,'1840-01-01','2999-12-31'),
	(36611,'30','013','833','013833',13833,'CAPIATE','CAPIATE','CAPIATE','CO',1,'1840-01-01','2999-12-31'),
	(36612,'30','015','832','015832',15832,'CASIRATE OLONA','CASIRATE OLONA','CASIRATE OLONA','MI',1,'1840-01-01','2999-12-31'),
	(36613,'10','002','811','002811',2811,'COSSILA','COSSILA','COSSILA','VC',1,'1840-01-01','2999-12-31'),
	(36614,'30','018','887','018887',18887,'VILLAREGGIO','VILLAREGGIO','VILLAREGGIO','PV',1,'1840-01-01','2999-12-31'),
	(36615,'42','022','941','022941',22941,'VILLE DEL MONTE','VILLE DEL MONTE','VILLE DEL MONTE','TN',1,'1840-01-01','2999-12-31'),
	(36616,'30','018','888','018888',18888,'VIMANONE','VIMANONE','VIMANONE','PV',1,'1840-01-01','2999-12-31'),
	(36617,'30','013','959','013959',13959,'VIMOGNO','VIMOGNO','VIMOGNO','CO',1,'1840-01-01','2999-12-31'),
	(36618,'10','002','829','002829',2829,'VINTEBBIO','VINTEBBIO','VINTEBBIO','VC',1,'1840-01-01','2999-12-31'),
	(36619,'30','017','910','017910',17910,'VIRLE TREPONTI','VIRLE TREPONTI','VIRLE TREPONTI','BS',1,'1840-01-01','2999-12-31'),
	(36620,'30','018','889','018889',18889,'VIVENTE','VIVENTE','VIVENTE','PV',1,'1840-01-01','2999-12-31'),
	(36621,'10','003','903','003903',3903,'VOCOGNO E PRESTINONE','VOCOGNO E PRESTINONE','VOCOGNO E PRESTINONE','NO',1,'1840-01-01','2999-12-31'),
	(36622,'30','012','905','012905',12905,'VOLTORRE','VOLTORRE','VOLTORRE','VA',1,'1840-01-01','2999-12-31'),
	(36623,'70','010','829','010829',10829,'VOLTRI','VOLTRI','VOLTRI','GE',1,'1840-01-01','2999-12-31'),
	(36624,'30','019','924','019924',19924,'ZANENGO','ZANENGO','ZANENGO','CR',1,'1840-01-01','2999-12-31'),
	(36625,'30','019','925','019925',19925,'ZAPPELLO','ZAPPELLO','ZAPPELLO','CR',1,'1840-01-01','2999-12-31'),
	(36626,'30','018','890','018890',18890,'ZAVATTARELLO VALVERDE','ZAVATTARELLO VALVERDE','ZAVATTARELLO VALVERDE','PV',1,'1840-01-01','2999-12-31'),
	(36627,'30','018','891','018891',18891,'ZELATA','ZELATA','ZELATA','PV',1,'1840-01-01','2999-12-31'),
	(36628,'30','015','983','015983',15983,'ZELO FORAMAGNO','ZELO FORAMAGNO','ZELO FORAMAGNO','MI',1,'1840-01-01','2999-12-31'),
	(36629,'30','018','892','018892',18892,'ZIBIDO AL LAMBRO','ZIBIDO AL LAMBRO','ZIBIDO AL LAMBRO','PV',1,'1840-01-01','2999-12-31'),
	(36630,'30','015','984','015984',15984,'ZIVIDO','ZIVIDO','ZIVIDO','MI',1,'1840-01-01','2999-12-31'),
	(36631,'30','015','985','015985',15985,'ZORLESCO','ZORLESCO','ZORLESCO','MI',1,'1840-01-01','2999-12-31'),
	(36632,'10','003','904','003904',3904,'ZORNASCO','ZORNASCO','ZORNASCO','NO',1,'1840-01-01','2999-12-31'),
	(36633,'10','003','905','003905',3905,'ZOVERALLO','ZOVERALLO','ZOVERALLO','NO',1,'1840-01-01','2999-12-31'),
	(36634,'20','095','813','095813',95813,'ZURI','ZURI','ZURI','OR',1,'1840-01-01','2999-12-31'),
	(36635,'30','015','850','015850',15850,'CEPPEDA','CEPPEDA','CEPPEDA','MI',1,'1840-01-01','2999-12-31'),
	(36636,'10','003','835','003835',3835,'CHIGNOLO VERBANO','CHIGNOLO VERBANO','CHIGNOLO VERBANO','NO',1,'1840-01-01','2999-12-31'),
	(36637,'30','013','860','013860',13860,'COLCIAGO','COLCIAGO','COLCIAGO','CO',1,'1840-01-01','2999-12-31'),
	(36638,'30','017','830','017830',17830,'COLOMBARO','COLOMBARO','COLOMBARO','BS',1,'1840-01-01','2999-12-31'),
	(36639,'60','032','703','032703',32703,'CORGNALE','CORGNALE','CORGNALE','TS',1,'1840-01-01','2999-12-31'),
	(36640,'70','008','843','008843',8843,'VILLE SAN PIETRO','VILLE SAN PIETRO','VILLE SAN PIETRO','IM',1,'1840-01-01','2999-12-31'),
	(36641,'30','013','961','013961',13961,'ZELBIO-VELESO','ZELBIO-VELESO','ZELBIO-VELESO','CO',1,'1840-01-01','2999-12-31'),
	(36642,'30','017','803','017803',17803,'ANFURRO','ANFURRO','ANFURRO','BS',1,'1840-01-01','2999-12-31'),
	(36643,'30','012','805','012805',12805,'ARDENA','ARDENA','ARDENA','VA',1,'1840-01-01','2999-12-31'),
	(36644,'30','012','809','012809',12809,'BALLARATE','BALLARATE','BALLARATE','VA',1,'1840-01-01','2999-12-31'),
	(36645,'30','012','810','012810',12810,'BARZA','BARZA','BARZA','VA',1,'1840-01-01','2999-12-31'),
	(36646,'42','022','805','022805',22805,'BESENO','BESENO','BESENO','TN',1,'1840-01-01','2999-12-31'),
	(36647,'30','012','815','012815',12815,'BODIO','BODIO','BODIO','VA',1,'1840-01-01','2999-12-31'),
	(36648,'42','022','810','022810',22810,'BORGHETTO','BORGHETTO','BORGHETTO','TN',1,'1840-01-01','2999-12-31'),
	(36649,'60','032','701','032701',32701,'BUCUIE','BUCUIE','BUCUIE','TS',1,'1840-01-01','2999-12-31'),
	(36650,'10','003','823','003823',3823,'BUTTOGNO','BUTTOGNO','BUTTOGNO','NO',1,'1840-01-01','2999-12-31'),
	(36651,'70','009','806','009806',9806,'CAGNA','CAGNA','CAGNA','SV',1,'1840-01-01','2999-12-31'),
	(36652,'30','014','803','014803',14803,'CAMPOVICO','CAMPOVICO','CAMPOVICO','SO',1,'1840-01-01','2999-12-31'),
	(36653,'30','013','835','013835',13835,'CARCANO','CARCANO','CARCANO','CO',1,'1840-01-01','2999-12-31'),
	(36654,'30','019','827','019827',19827,'CASALORZO GEROLDI','CASALORZO GEROLDI','CASALORZO GEROLDI','CR',1,'1840-01-01','2999-12-31'),
	(36655,'30','012','833','012833',12833,'CASSINA VERGHERA','CASSINA VERGHERA','CASSINA VERGHERA','VA',1,'1840-01-01','2999-12-31'),
	(36656,'30','012','837','012837',12837,'CEDRATE','CEDRATE','CEDRATE','VA',1,'1840-01-01','2999-12-31'),
	(36657,'30','016','818','016818',16818,'CEPINO','CEPINO','CEPINO','BG',1,'1840-01-01','2999-12-31'),
	(36658,'42','022','822','022822',22822,'CHIENIS','CHIENIS','CHIENIS','TN',1,'1840-01-01','2999-12-31'),
	(36659,'10','005','804','005804',5804,'COCCONITO','COCCONITO','COCCONITO','AT',1,'1840-01-01','2999-12-31'),
	(36660,'60','031','710','031710',31710,'COMENO','COMENO','COMENO','GO',1,'1840-01-01','2999-12-31'),
	(36661,'30','015','866','015866',15866,'CORTE SANT\'ANDREA','CORTE SANT\'ANDREA','CORTE SANT\'ANDREA','MI',1,'1840-01-01','2999-12-31'),
	(36662,'42','022','833','022833',22833,'CRETO','CRETO','CRETO','TN',1,'1840-01-01','2999-12-31'),
	(36663,'10','002','814','002814',2814,'DOCCIO','DOCCIO','DOCCIO','VC',1,'1840-01-01','2999-12-31'),
	(36664,'30','013','873','013873',13873,'DRANO','DRANO','DRANO','CO',1,'1840-01-01','2999-12-31'),
	(36665,'30','016','826','016826',16826,'ENDINE','ENDINE','ENDINE','BG',1,'1840-01-01','2999-12-31'),
	(36666,'13','069','801','069801',69801,'FALLASCOSO','FALLASCOSO','FALLASCOSO','CH',1,'1840-01-01','2999-12-31'),
	(36667,'99','702','704','702704',702704,'BARBANA D\'ISTRIA','BARBANA D\'ISTRIA','BARBANA D\'ISTRIA','PL',1,'1840-01-01','2999-12-31'),
	(36668,'15','062','808','062808',62808,'VARONI','VARONI','VARONI','BN',1,'1840-01-01','2999-12-31'),
	(36669,'90','047','806','047806',47806,'VELLANO','VELLANO','VELLANO','PT',1,'1840-01-01','2999-12-31'),
	(36670,'10','003','899','003899',3899,'VERGANO NOVARESE','VERGANO NOVARESE','VERGANO NOVARESE','NO',1,'1840-01-01','2999-12-31'),
	(36671,'30','013','955','013955',13955,'VERTEMATE','VERTEMATE','VERTEMATE','CO',1,'1840-01-01','2999-12-31'),
	(36672,'70','009','832','009832',9832,'VEZZI','VEZZI','VEZZI','SV',1,'1840-01-01','2999-12-31'),
	(36673,'30','015','975','015975',15975,'VIGENTINO','VIGENTINO','VIGENTINO','MI',1,'1840-01-01','2999-12-31'),
	(36674,'42','022','218','022218',22218,'VIGOLO BASELGA','VIGOLO BASELGA','VIGOLO BASELGA','TN',1,'1840-01-01','2999-12-31'),
	(36675,'10','005','820','005820',5820,'VILLA CORSIONE','VILLA CORSIONE','VILLA CORSIONE','AT',1,'1840-01-01','2999-12-31'),
	(36676,'42','022','940','022940',22940,'VILLAZZANO','VILLAZZANO','VILLAZZANO','TN',1,'1840-01-01','2999-12-31'),
	(36677,'30','016','883','016883',16883,'VILLONGO SANT\'ALESSANDRO','VILLONGO SANT\'ALESSANDRO','VILLONGO SANT\'ALESSANDRO','BG',1,'1840-01-01','2999-12-31'),
	(36678,'99','702','741','702741',702741,'VISIGNANO D\'ISTRIA','VISIGNANO D\'ISTRIA','VISIGNANO D\'ISTRIA','PL',1,'1840-01-01','2999-12-31'),
	(36679,'30','012','904','012904',12904,'VOLDOMINO','VOLDOMINO','VOLDOMINO','VA',1,'1840-01-01','2999-12-31'),
	(36680,'99','703','702','703702',703702,'ZARA','ZARA','ZARA','ZA',1,'1840-01-01','2999-12-31'),
	(36681,'20','095','812','095812',95812,'ZEPPARA','ZEPPARA','ZEPPARA','OR',1,'1840-01-01','2999-12-31'),
	(36682,'30','016','885','016885',16885,'ZORZINO','ZORZINO','ZORZINO','BG',1,'1840-01-01','2999-12-31'),
	(36683,'42','022','801','022801',22801,'AGRONE','AGRONE','AGRONE','TN',1,'1840-01-01','2999-12-31'),
	(36684,'30','013','803','013803',13803,'AIZURRO','AIZURRO','AIZURRO','CO',1,'1840-01-01','2999-12-31'),
	(36685,'30','013','805','013805',13805,'ALBESE','ALBESE','ALBESE','CO',1,'1840-01-01','2999-12-31'),
	(36686,'10','003','804','003804',3804,'ALBOGNO','ALBOGNO','ALBOGNO','NO',1,'1840-01-01','2999-12-31'),
	(36687,'20','092','801','092801',92801,'ARIXI','ARIXI','ARIXI','CA',1,'1840-01-01','2999-12-31'),
	(36688,'50','023','801','023801',23801,'AVESA','AVESA','AVESA','VR',1,'1840-01-01','2999-12-31'),
	(36689,'30','015','804','015804',15804,'BAGGIO','BAGGIO','BAGGIO','MI',1,'1840-01-01','2999-12-31'),
	(36690,'30','013','810','013810',13810,'BAIEDO','BAIEDO','BAIEDO','CO',1,'1840-01-01','2999-12-31'),
	(36691,'99','321','000','999321',999321,'MACAO','MACAO','MACAO','P',1,'1840-01-01','2999-12-31'),
	(36692,'99','355','000','999355',999355,'YEMEN DEL SUD','YEMEN DEL SUD','YEMEN DEL SUD','YD',1,'1840-01-01','2999-12-31'),
	(36693,'50','027','805','027805',27805,'MESTRE','MESTRE','MESTRE','VE',1,'1840-01-01','2999-12-31'),
	(36694,'42','022','870','022870',22870,'MESTRIAGO','MESTRIAGO','MESTRIAGO','TN',1,'1840-01-01','2999-12-31'),
	(36695,'30','015','898','015898',15898,'MEZZANA CASATI','MEZZANA CASATI','MEZZANA CASATI','MI',1,'1840-01-01','2999-12-31'),
	(36696,'30','015','899','015899',15899,'MEZZANO PASSONE','MEZZANO PASSONE','MEZZANO PASSONE','MI',1,'1840-01-01','2999-12-31'),
	(36697,'15','064','803','064803',64803,'MIGLIANO','MIGLIANO','MIGLIANO','AV',1,'1840-01-01','2999-12-31'),
	(36698,'10','001','838','001838',1838,'MILLAURES','MILLAURES','MILLAURES','TO',1,'1840-01-01','2999-12-31'),
	(36699,'30','017','859','017859',17859,'MILZANELLO','MILZANELLO','MILZANELLO','BS',1,'1840-01-01','2999-12-31'),
	(36700,'60','030','811','030811',30811,'MIONE','MIONE','MIONE','UD',1,'1840-01-01','2999-12-31'),
	(36701,'70','008','822','008822',8822,'MOANO','MOANO','MOANO','IM',1,'1840-01-01','2999-12-31'),
	(36702,'30','013','902','013902',13902,'MOLINA','MOLINA','MOLINA','CO',1,'1840-01-01','2999-12-31'),
	(36703,'30','015','904','015904',15904,'MONGIARDINO SILLARO','MONGIARDINO SILLARO','MONGIARDINO SILLARO','MI',1,'1840-01-01','2999-12-31'),
	(36704,'70','008','840','008840',8840,'VILLAGUARDIA','VILLAGUARDIA','VILLAGUARDIA','IM',1,'1840-01-01','2999-12-31'),
	(36705,'30','018','886','018886',18886,'VILLALUNGA','VILLALUNGA','VILLALUNGA','PV',1,'1840-01-01','2999-12-31'),
	(36706,'30','015','980','015980',15980,'VILLANOVA VIMERCATE','VILLANOVA VIMERCATE','VILLANOVA VIMERCATE','MI',1,'1840-01-01','2999-12-31'),
	(36707,'70','008','841','008841',8841,'VILLATALLA','VILLATALLA','VILLATALLA','IM',1,'1840-01-01','2999-12-31'),
	(36708,'70','008','844','008844',8844,'VILLE SAN SEBASTIANO','VILLE SAN SEBASTIANO','VILLE SAN SEBASTIANO','IM',1,'1840-01-01','2999-12-31'),
	(36709,'30','016','884','016884',16884,'VILMINORE','VILMINORE','VILMINORE','BG',1,'1840-01-01','2999-12-31'),
	(36710,'30','012','903','012903',12903,'VINAGO','VINAGO','VINAGO','VA',1,'1840-01-01','2999-12-31'),
	(36711,'60','031','732','031732',31732,'VIPACCO','VIPACCO','VIPACCO','GO',1,'1840-01-01','2999-12-31'),
	(36712,'30','013','960','013960',13960,'VISINO','VISINO','VISINO','CO',1,'1840-01-01','2999-12-31'),
	(36713,'30','015','982','015982',15982,'VITTADONE','VITTADONE','VITTADONE','MI',1,'1840-01-01','2999-12-31'),
	(36714,'19','083','806','083806',83806,'SALINA','SALINA','SALINA','ME',1,'1840-01-01','2999-12-31'),
	(36715,'15','062','806','062806',62806,'PERRILLO','PERRILLO','PERRILLO','BN',1,'1840-01-01','2999-12-31'),
	(36716,'30','017','872','017872',17872,'PEZZORO','PEZZORO','PEZZORO','BS',1,'1840-01-01','2999-12-31'),
	(36717,'10','002','823','002823',2823,'PIANCERI','PIANCERI','PIANCERI','VC',1,'1840-01-01','2999-12-31'),
	(36718,'15','063','804','063804',63804,'PIANURA','PIANURA','PIANURA','NA',1,'1840-01-01','2999-12-31'),
	(36719,'30','016','850','016850',16850,'PIAZZO BASSO','PIAZZO BASSO','PIAZZO BASSO','BG',1,'1840-01-01','2999-12-31'),
	(36720,'30','019','881','019881',19881,'PIEVE TERZAGNI','PIEVE TERZAGNI','PIEVE TERZAGNI','CR',1,'1840-01-01','2999-12-31'),
	(36721,'80','034','805','034805',34805,'PIONE','PIONE','PIONE','PR',1,'1840-01-01','2999-12-31'),
	(36722,'15','063','805','063805',63805,'PISCINOLA','PISCINOLA','PISCINOLA','NA',1,'1840-01-01','2999-12-31'),
	(36723,'30','018','856','018856',18856,'PIZZOCORNO','PIZZOCORNO','PIZZOCORNO','PV',1,'1840-01-01','2999-12-31'),
	(36724,'30','018','858','018858',18858,'PONTECARATE','PONTECARATE','PONTECARATE','PV',1,'1840-01-01','2999-12-31'),
	(36725,'42','022','891','022891',22891,'PREGASINA','PREGASINA','PREGASINA','TN',1,'1840-01-01','2999-12-31'),
	(36726,'30','015','927','015927',15927,'PREMENUGO','PREMENUGO','PREMENUGO','MI',1,'1840-01-01','2999-12-31'),
	(36727,'42','022','894','022894',22894,'PRESSON','PRESSON','PRESSON','TN',1,'1840-01-01','2999-12-31'),
	(36728,'10','003','877','003877',3877,'QUARNA','QUARNA','QUARNA','NO',1,'1840-01-01','2999-12-31'),
	(36729,'10','005','810','005810',5810,'QUARTO ASTESE','QUARTO ASTESE','QUARTO ASTESE','AT',1,'1840-01-01','2999-12-31'),
	(36730,'11','044','815','044815',44815,'QUINTODECIMO','QUINTODECIMO','QUINTODECIMO','AP',1,'1840-01-01','2999-12-31'),
	(36731,'60','030','815','030815',30815,'RACCOLANA','RACCOLANA','RACCOLANA','UD',1,'1840-01-01','2999-12-31'),
	(36732,'50','029','811','029811',29811,'RAMO DI PALO','RAMO DI PALO','RAMO DI PALO','RO',1,'1840-01-01','2999-12-31'),
	(36733,'42','022','899','022899',22899,'RAVINA','RAVINA','RAVINA','TN',1,'1840-01-01','2999-12-31'),
	(36734,'13','066','806','066806',66806,'ROIO PIANO','ROIO PIANO','ROIO PIANO','AQ',1,'1840-01-01','2999-12-31'),
	(36735,'60','031','806','031806',31806,'ROMANS','ROMANS','ROMANS','GO',1,'1840-01-01','2999-12-31'),
	(36736,'42','022','903','022903',22903,'RONCOGNO','RONCOGNO','RONCOGNO','TN',1,'1840-01-01','2999-12-31'),
	(36737,'30','016','855','016855',16855,'ROSCIATE','ROSCIATE','ROSCIATE','BG',1,'1840-01-01','2999-12-31'),
	(36738,'30','016','856','016856',16856,'ROSSINO','ROSSINO','ROSSINO','BG',1,'1840-01-01','2999-12-31'),
	(36739,'10','003','878','003878',3878,'ROVEGRO','ROVEGRO','ROVEGRO','NO',1,'1840-01-01','2999-12-31'),
	(36740,'30','019','896','019896',19896,'RUBBIANO','RUBBIANO','RUBBIANO','CR',1,'1840-01-01','2999-12-31'),
	(36741,'10','003','831','003831',3831,'CASALEGGIO CASTELLAZZO','CASALEGGIO CASTELLAZZO','CASALEGGIO CASTELLAZZO','NO',1,'1840-01-01','2999-12-31'),
	(36742,'30','020','801','020801',20801,'CASALPOGLIO','CASALPOGLIO','CASALPOGLIO','MN',1,'1840-01-01','2999-12-31'),
	(36743,'30','019','829','019829',19829,'CASANOVA D\'OFFREDI','CASANOVA D\'OFFREDI','CASANOVA D\'OFFREDI','CR',1,'1840-01-01','2999-12-31'),
	(36744,'10','002','806','002806',2806,'CASCINE DI STRA','CASCINE DI STRA','CASCINE DI STRA','VC',1,'1840-01-01','2999-12-31'),
	(36745,'30','013','841','013841',13841,'CASIRAGO','CASIRAGO','CASIRAGO','CO',1,'1840-01-01','2999-12-31'),
	(36746,'30','013','842','013842',13842,'CASLETTO','CASLETTO','CASLETTO','CO',1,'1840-01-01','2999-12-31'),
	(36747,'30','013','844','013844',13844,'CASNATE','CASNATE','CASNATE','CO',1,'1840-01-01','2999-12-31'),
	(36748,'50','024','801','024801',24801,'CASOTTO','CASOTTO','CASOTTO','VI',1,'1840-01-01','2999-12-31'),
	(36749,'30','015','836','015836',15836,'CASSINA AMATA','CASSINA AMATA','CASSINA AMATA','MI',1,'1840-01-01','2999-12-31'),
	(36750,'30','013','847','013847',13847,'CASSINA DE\' BRACCHI','CASSINA DE\' BRACCHI','CASSINA DE\' BRACCHI','CO',1,'1840-01-01','2999-12-31'),
	(36751,'30','015','838','015838',15838,'CASSINA DE\' GATTI','CASSINA DE\' GATTI','CASSINA DE\' GATTI','MI',1,'1840-01-01','2999-12-31'),
	(36752,'30','015','841','015841',15841,'CASSINA SAVINA','CASSINA SAVINA','CASSINA SAVINA','MI',1,'1840-01-01','2999-12-31'),
	(36753,'30','018','819','018819',18819,'CASSINE CALDERARI','CASSINE CALDERARI','CASSINE CALDERARI','PV',1,'1840-01-01','2999-12-31'),
	(36754,'30','018','820','018820',18820,'CASSINE SIRIGARI','CASSINE SIRIGARI','CASSINE SIRIGARI','PV',1,'1840-01-01','2999-12-31'),
	(36755,'30','015','843','015843',15843,'CASSINO D\'ALBERI','CASSINO D\'ALBERI','CASSINO D\'ALBERI','MI',1,'1840-01-01','2999-12-31'),
	(36756,'30','018','822','018822',18822,'CASSINO PO','CASSINO PO','CASSINO PO','PV',1,'1840-01-01','2999-12-31'),
	(36757,'30','012','834','012834',12834,'CASTEGNATE OLONA','CASTEGNATE OLONA','CASTEGNATE OLONA','VA',1,'1840-01-01','2999-12-31'),
	(36758,'10','006','805','006805',6805,'CASTEL DE\' RATTI','CASTEL DE\' RATTI','CASTEL DE\' RATTI','AL',1,'1840-01-01','2999-12-31'),
	(36759,'15','062','802','062802',62802,'CIVITELLA LICINIO','CIVITELLA LICINIO','CIVITELLA LICINIO','BN',1,'1840-01-01','2999-12-31'),
	(36760,'30','015','862','015862',15862,'CONCESA','CONCESA','CONCESA','MI',1,'1840-01-01','2999-12-31'),
	(36761,'30','015','864','015864',15864,'CORNELIANO BERTARIO','CORNELIANO BERTARIO','CORNELIANO BERTARIO','MI',1,'1840-01-01','2999-12-31'),
	(36762,'10','003','844','003844',3844,'CRAVEGNA','CRAVEGNA','CRAVEGNA','NO',1,'1840-01-01','2999-12-31'),
	(36763,'30','017','837','017837',17837,'DEGAGNA','DEGAGNA','DEGAGNA','BS',1,'1840-01-01','2999-12-31'),
	(36764,'20','092','802','092802',92802,'DONIGALA SIURGUS','DONIGALA SIURGUS','DONIGALA SIURGUS','CA',1,'1840-01-01','2999-12-31'),
	(36765,'30','019','850','019850',19850,'FARINATE','FARINATE','FARINATE','CR',1,'1840-01-01','2999-12-31'),
	(36766,'20','095','804','095804',95804,'FIGU','FIGU','FIGU','OR',1,'1840-01-01','2999-12-31'),
	(36767,'30','019','852','019852',19852,'FORCELLO','FORCELLO','FORCELLO','CR',1,'1840-01-01','2999-12-31'),
	(36768,'41','021','829','021829',21829,'FUNDRES - PFUNDERS','FUNDRES - PFUNDERS','FUNDRES - PFUNDERS','BZ',1,'1840-01-01','2999-12-31'),
	(36769,'30','013','879','013879',13879,'GERMANEDO','GERMANEDO','GERMANEDO','CO',1,'1840-01-01','2999-12-31'),
	(36770,'41','021','831','021831',21831,'GRIMALDO - GREINWALDEN','GRIMALDO - GREINWALDEN','GRIMALDO - GREINWALDEN','BZ',1,'1840-01-01','2999-12-31'),
	(36771,'41','021','832','021832',21832,'GUDON - GUFIDAUN','GUDON - GUFIDAUN','GUDON - GUFIDAUN','BZ',1,'1840-01-01','2999-12-31'),
	(36772,'60','030','808','030808',30808,'IPPLIS','IPPLIS','IPPLIS','UD',1,'1840-01-01','2999-12-31'),
	(36773,'30','017','873','017873',17873,'PILZONE','PILZONE','PILZONE','BS',1,'1840-01-01','2999-12-31'),
	(36774,'30','017','867','017867',17867,'ORIANO','ORIANO','ORIANO','BS',1,'1840-01-01','2999-12-31'),
	(36775,'30','018','851','018851',18851,'ORIGIOSO','ORIGIOSO','ORIGIOSO','PV',1,'1840-01-01','2999-12-31'),
	(36776,'99','702','725','702725',702725,'ORSERA','ORSERA','ORSERA','PL',1,'1840-01-01','2999-12-31'),
	(36777,'11','044','810','044810',44810,'OSOLI','OSOLI','OSOLI','AP',1,'1840-01-01','2999-12-31'),
	(36778,'30','016','847','016847',16847,'OSSANESGA','OSSANESGA','OSSANESGA','BG',1,'1840-01-01','2999-12-31'),
	(36779,'11','044','802','044802',44802,'CAPRADOSSO','CAPRADOSSO','CAPRADOSSO','AP',1,'1840-01-01','2999-12-31'),
	(36780,'30','016','813','016813',16813,'CAPRIATE D\'ADDA','CAPRIATE D\'ADDA','CAPRIATE D\'ADDA','BG',1,'1840-01-01','2999-12-31'),
	(36781,'19','086','801','086801',86801,'CARCACI','CARCACI','CARCACI','EN',1,'1840-01-01','2999-12-31'),
	(36782,'42','022','817','022817',22817,'CARCIATO','CARCIATO','CARCIATO','TN',1,'1840-01-01','2999-12-31'),
	(36783,'30','012','829','012829',12829,'CARDANA','CARDANA','CARDANA','VA',1,'1840-01-01','2999-12-31'),
	(36784,'30','013','837','013837',13837,'CARENO','CARENO','CARENO','CO',1,'1840-01-01','2999-12-31'),
	(36785,'10','003','829','003829',3829,'CARGIAGO','CARGIAGO','CARGIAGO','NO',1,'1840-01-01','2999-12-31'),
	(36786,'18','080','802','080802',80802,'CARIDA\'','CARIDA\'','CARIDA\'','RC',1,'1840-01-01','2999-12-31'),
	(36787,'30','016','814','016814',16814,'CAROBBIO','CAROBBIO','CAROBBIO','BG',1,'1840-01-01','2999-12-31'),
	(36788,'30','018','817','018817',18817,'CARPIGNAGO','CARPIGNAGO','CARPIGNAGO','PV',1,'1840-01-01','2999-12-31'),
	(36789,'70','009','810','009810',9810,'CARRETTO','CARRETTO','CARRETTO','SV',1,'1840-01-01','2999-12-31'),
	(36790,'42','022','853','022853',22853,'LODRONE','LODRONE','LODRONE','TN',1,'1840-01-01','2999-12-31'),
	(36791,'30','012','847','012847',12847,'CUVIRONE','CUVIRONE','CUVIRONE','VA',1,'1840-01-01','2999-12-31'),
	(36792,'10','001','822','001822',1822,'DRUSACCO','DRUSACCO','DRUSACCO','TO',1,'1840-01-01','2999-12-31'),
	(36793,'10','005','805','005805',5805,'DUSINO','DUSINO','DUSINO','AT',1,'1840-01-01','2999-12-31'),
	(36794,'30','013','876','013876',13876,'ESINO SUPERIORE','ESINO SUPERIORE','ESINO SUPERIORE','CO',1,'1840-01-01','2999-12-31'),
	(36795,'30','015','871','015871',15871,'FAGNANO SUL NAVIGLIO','FAGNANO SUL NAVIGLIO','FAGNANO SUL NAVIGLIO','MI',1,'1840-01-01','2999-12-31'),
	(36796,'11','041','803','041803',41803,'FENIGLI','FENIGLI','FENIGLI','PS',1,'1840-01-01','2999-12-31'),
	(36797,'10','002','815','002815',2815,'FERRUTA','FERRUTA','FERRUTA','VC',1,'1840-01-01','2999-12-31'),
	(36798,'99','702','714','702714',702714,'FIANONA','FIANONA','FIANONA','PL',1,'1840-01-01','2999-12-31'),
	(36799,'70','009','814','009814',9814,'FINALE MARINA','FINALE MARINA','FINALE MARINA','SV',1,'1840-01-01','2999-12-31'),
	(36800,'30','016','829','016829',16829,'FIUMENERO','FIUMENERO','FIUMENERO','BG',1,'1840-01-01','2999-12-31'),
	(36801,'30','019','857','019857',19857,'GAMBINA BARCHETTI','GAMBINA BARCHETTI','GAMBINA BARCHETTI','CR',1,'1840-01-01','2999-12-31'),
	(36802,'20','091','801','091801',91801,'GAROFAI','GAROFAI','GAROFAI','NU',1,'1840-01-01','2999-12-31'),
	(36803,'30','012','851','012851',12851,'GAZZADA','GAZZADA','GAZZADA','VA',1,'1840-01-01','2999-12-31'),
	(36804,'30','017','844','017844',17844,'GEROLANUOVA','GEROLANUOVA','GEROLANUOVA','BS',1,'1840-01-01','2999-12-31'),
	(36805,'30','017','845','017845',17845,'GOGLIONE SOPRA','GOGLIONE SOPRA','GOGLIONE SOPRA','BS',1,'1840-01-01','2999-12-31'),
	(36806,'30','012','852','012852',12852,'GORNATE-SUPERIORE','GORNATE-SUPERIORE','GORNATE-SUPERIORE','VA',1,'1840-01-01','2999-12-31'),
	(36807,'30','015','878','015878',15878,'GRANCINO','GRANCINO','GRANCINO','MI',1,'1840-01-01','2999-12-31'),
	(36808,'50','029','809','029809',29809,'GRIGNANO DI POLESINE','GRIGNANO DI POLESINE','GRIGNANO DI POLESINE','RO',1,'1840-01-01','2999-12-31'),
	(36809,'30','015','881','015881',15881,'GROPPELLO D\'ADDA','GROPPELLO D\'ADDA','GROPPELLO D\'ADDA','MI',1,'1840-01-01','2999-12-31'),
	(36810,'99','702','717','702717',702717,'ISOLA D\'ISTRIA','ISOLA D\'ISTRIA','ISOLA D\'ISTRIA','PL',1,'1840-01-01','2999-12-31'),
	(36811,'10','002','818','002818',2818,'ISOLELLA','ISOLELLA','ISOLELLA','VC',1,'1840-01-01','2999-12-31'),
	(36812,'41','021','835','021835',21835,'LAPPAGO - LAPPACH','LAPPAGO - LAPPACH','LAPPAGO - LAPPACH','BZ',1,'1840-01-01','2999-12-31'),
	(36813,'41','021','837','021837',21837,'LAZFONS - LATZFONS','LAZFONS - LATZFONS','LAZFONS - LATZFONS','BZ',1,'1840-01-01','2999-12-31'),
	(36814,'30','018','839','018839',18839,'LICONASCO','LICONASCO','LICONASCO','PV',1,'1840-01-01','2999-12-31'),
	(36815,'30','015','890','015890',15890,'LINATE AL LAMBRO','LINATE AL LAMBRO','LINATE AL LAMBRO','MI',1,'1840-01-01','2999-12-31'),
	(36816,'70','010','805','010805',10805,'BORZOLI','BORZOLI','BORZOLI','GE',1,'1840-01-01','2999-12-31'),
	(36817,'10','001','805','001805',1805,'BARATONIA','BARATONIA','BARATONIA','TO',1,'1840-01-01','2999-12-31'),
	(36818,'30','017','806','017806',17806,'BARCO','BARCO','BARCO','BS',1,'1840-01-01','2999-12-31'),
	(36819,'10','001','806','001806',1806,'BARDASSANO','BARDASSANO','BARDASSANO','TO',1,'1840-01-01','2999-12-31'),
	(36820,'70','009','802','009802',9802,'BARDINO VECCHIO','BARDINO VECCHIO','BARDINO VECCHIO','SV',1,'1840-01-01','2999-12-31'),
	(36821,'30','018','801','018801',18801,'BARONA','BARONA','BARONA','PV',1,'1840-01-01','2999-12-31'),
	(36822,'30','013','814','013814',13814,'BARTESATE','BARTESATE','BARTESATE','CO',1,'1840-01-01','2999-12-31'),
	(36823,'10','001','807','001807',1807,'BEAULARD','BEAULARD','BEAULARD','TO',1,'1840-01-01','2999-12-31'),
	(36824,'50','029','801','029801',29801,'BELLOMBRA','BELLOMBRA','BELLOMBRA','RO',1,'1840-01-01','2999-12-31'),
	(36825,'30','018','803','018803',18803,'BELVEDERE AL PO','BELVEDERE AL PO','BELVEDERE AL PO','PV',1,'1840-01-01','2999-12-31'),
	(36826,'30','013','816','013816',13816,'BERNAGA','BERNAGA','BERNAGA','CO',1,'1840-01-01','2999-12-31'),
	(36827,'10','004','804','004804',4804,'BERSEZIO','BERSEZIO','BERSEZIO','CN',1,'1840-01-01','2999-12-31'),
	(36828,'30','015','810','015810',15810,'BESTAZZO','BESTAZZO','BESTAZZO','MI',1,'1840-01-01','2999-12-31'),
	(36829,'30','019','807','019807',19807,'BETTENESCO','BETTENESCO','BETTENESCO','CR',1,'1840-01-01','2999-12-31'),
	(36830,'50','023','803','023803',23803,'BEVILACQUA-BOSCHI','BEVILACQUA-BOSCHI','BEVILACQUA-BOSCHI','VR',1,'1840-01-01','2999-12-31'),
	(36831,'10','006','801','006801',6801,'BISIO','BISIO','BISIO','AL',1,'1840-01-01','2999-12-31'),
	(36832,'30','012','813','012813',12813,'BIZZOZERO','BIZZOZERO','BIZZOZERO','VA',1,'1840-01-01','2999-12-31'),
	(36833,'50','029','802','029802',29802,'BOARA POLESINE','BOARA POLESINE','BOARA POLESINE','RO',1,'1840-01-01','2999-12-31'),
	(36834,'30','014','802','014802',14802,'BOFFETTO','BOFFETTO','BOFFETTO','SO',1,'1840-01-01','2999-12-31'),
	(36835,'99','702','705','702705',702705,'BOGLIUNO','BOGLIUNO','BOGLIUNO','PL',1,'1840-01-01','2999-12-31'),
	(36836,'30','015','816','015816',15816,'BOLGIANO','BOLGIANO','BOLGIANO','MI',1,'1840-01-01','2999-12-31'),
	(36837,'30','017','808','017808',17808,'BOLLONE','BOLLONE','BOLLONE','BS',1,'1840-01-01','2999-12-31'),
	(36838,'30','016','807','016807',16807,'BONDO PETELLO','BONDO PETELLO','BONDO PETELLO','BG',1,'1840-01-01','2999-12-31'),
	(36839,'30','015','817','015817',15817,'BONIROLA','BONIROLA','BONIROLA','MI',1,'1840-01-01','2999-12-31'),
	(36840,'70','008','804','008804',8804,'BORGO SANT\'AGATA','BORGO SANT\'AGATA','BORGO SANT\'AGATA','IM',1,'1840-01-01','2999-12-3